import { filterInPlace } from "./_utils.ts";
export function intersect(...arrays) {
    const [originalHead, ...tail] = arrays;
    const head = [...new Set(originalHead)];
    const tailSets = tail.map((it) => new Set(it));
    for (const set of tailSets) {
        filterInPlace(head, (it) => set.has(it));
        if (head.length === 0)
            return head;
    }
    return head;
}
//# sourceMappingURL=data:application/json;base64,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