import * as path from "../path/mod.ts";
export function isSubdir(src, dest, sep = path.sep) {
    if (src === dest) {
        return false;
    }
    const srcArray = src.split(sep);
    const destArray = dest.split(sep);
    return srcArray.every((current, i) => destArray[i] === current);
}
export function getFileInfoType(fileInfo) {
    return fileInfo.isFile
        ? "file"
        : fileInfo.isDirectory
            ? "dir"
            : fileInfo.isSymlink
                ? "symlink"
                : undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3V0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxPQUFPLEtBQUssSUFBSSxNQUFNLGdCQUFnQixDQUFDO0FBUXZDLE1BQU0sVUFBVSxRQUFRLENBQ3RCLEdBQVcsRUFDWCxJQUFZLEVBQ1osTUFBYyxJQUFJLENBQUMsR0FBRztJQUV0QixJQUFJLEdBQUcsS0FBSyxJQUFJLEVBQUU7UUFDaEIsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUNELE1BQU0sUUFBUSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDaEMsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNsQyxPQUFPLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEtBQUssT0FBTyxDQUFDLENBQUM7QUFDbEUsQ0FBQztBQVVELE1BQU0sVUFBVSxlQUFlLENBQUMsUUFBdUI7SUFDckQsT0FBTyxRQUFRLENBQUMsTUFBTTtRQUNwQixDQUFDLENBQUMsTUFBTTtRQUNSLENBQUMsQ0FBQyxRQUFRLENBQUMsV0FBVztZQUN0QixDQUFDLENBQUMsS0FBSztZQUNQLENBQUMsQ0FBQyxRQUFRLENBQUMsU0FBUztnQkFDcEIsQ0FBQyxDQUFDLFNBQVM7Z0JBQ1gsQ0FBQyxDQUFDLFNBQVMsQ0FBQztBQUNoQixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyMSB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcIi4uL3BhdGgvbW9kLnRzXCI7XG5cbi8qKlxuICogVGVzdCB3aGV0aGVyIG9yIG5vdCBgZGVzdGAgaXMgYSBzdWItZGlyZWN0b3J5IG9mIGBzcmNgXG4gKiBAcGFyYW0gc3JjIHNyYyBmaWxlIHBhdGhcbiAqIEBwYXJhbSBkZXN0IGRlc3QgZmlsZSBwYXRoXG4gKiBAcGFyYW0gc2VwIHBhdGggc2VwYXJhdG9yXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpc1N1YmRpcihcbiAgc3JjOiBzdHJpbmcsXG4gIGRlc3Q6IHN0cmluZyxcbiAgc2VwOiBzdHJpbmcgPSBwYXRoLnNlcCxcbik6IGJvb2xlYW4ge1xuICBpZiAoc3JjID09PSBkZXN0KSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG4gIGNvbnN0IHNyY0FycmF5ID0gc3JjLnNwbGl0KHNlcCk7XG4gIGNvbnN0IGRlc3RBcnJheSA9IGRlc3Quc3BsaXQoc2VwKTtcbiAgcmV0dXJuIHNyY0FycmF5LmV2ZXJ5KChjdXJyZW50LCBpKSA9PiBkZXN0QXJyYXlbaV0gPT09IGN1cnJlbnQpO1xufVxuXG5leHBvcnQgdHlwZSBQYXRoVHlwZSA9IFwiZmlsZVwiIHwgXCJkaXJcIiB8IFwic3ltbGlua1wiO1xuXG4vKipcbiAqIEdldCBhIGh1bWFuIHJlYWRhYmxlIGZpbGUgdHlwZSBzdHJpbmcuXG4gKlxuICogQHBhcmFtIGZpbGVJbmZvIEEgRmlsZUluZm8gZGVzY3JpYmVzIGEgZmlsZSBhbmQgaXMgcmV0dXJuZWQgYnkgYHN0YXRgLFxuICogICAgICAgICAgICAgICAgIGBsc3RhdGBcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGdldEZpbGVJbmZvVHlwZShmaWxlSW5mbzogRGVuby5GaWxlSW5mbyk6IFBhdGhUeXBlIHwgdW5kZWZpbmVkIHtcbiAgcmV0dXJuIGZpbGVJbmZvLmlzRmlsZVxuICAgID8gXCJmaWxlXCJcbiAgICA6IGZpbGVJbmZvLmlzRGlyZWN0b3J5XG4gICAgPyBcImRpclwiXG4gICAgOiBmaWxlSW5mby5pc1N5bWxpbmtcbiAgICA/IFwic3ltbGlua1wiXG4gICAgOiB1bmRlZmluZWQ7XG59XG4iXX0=