export function deferred() {
    let methods;
    let state = "pending";
    const promise = new Promise((resolve, reject) => {
        methods = {
            async resolve(value) {
                await value;
                state = "fulfilled";
                resolve(value);
            },
            reject(reason) {
                state = "rejected";
                reject(reason);
            },
        };
    });
    Object.defineProperty(promise, "state", { get: () => state });
    return Object.assign(promise, methods);
}
//# sourceMappingURL=data:application/json;base64,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