export function sortBy(array, selector) {
    const len = array.length;
    const indexes = new Array(len);
    const selectors = new Array(len);
    for (let i = 0; i < len; i++) {
        indexes[i] = i;
        const s = selector(array[i]);
        selectors[i] = Number.isNaN(s) ? null : s;
    }
    indexes.sort((ai, bi) => {
        const a = selectors[ai];
        const b = selectors[bi];
        if (a === null)
            return 1;
        if (b === null)
            return -1;
        return a > b ? 1 : a < b ? -1 : 0;
    });
    for (let i = 0; i < len; i++) {
        indexes[i] = array[indexes[i]];
    }
    return indexes;
}
//# sourceMappingURL=data:application/json;base64,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