import { Type } from "../type.ts";
function reconstructFunction(code) {
    const func = new Function(`return ${code}`)();
    if (!(func instanceof Function)) {
        throw new TypeError(`Expected function but got ${typeof func}: ${code}`);
    }
    return func;
}
export const func = new Type("tag:yaml.org,2002:js/function", {
    kind: "scalar",
    resolve(data) {
        if (data === null) {
            return false;
        }
        try {
            reconstructFunction(`${data}`);
            return true;
        }
        catch (_err) {
            return false;
        }
    },
    construct(data) {
        return reconstructFunction(data);
    },
    predicate(object) {
        return object instanceof Function;
    },
    represent(object) {
        return object.toString();
    },
});
//# sourceMappingURL=data:application/json;base64,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