// deno-fmt-ignore-file
// deno-lint-ignore-file
// This code was bundled using `deno bundle` and it's not recommended to edit it manually

function distance(a, b) {
    if (a.length == 0) {
        return b.length;
    }
    if (b.length == 0) {
        return a.length;
    }
    const matrix = [];
    for(let i5 = 0; i5 <= b.length; i5++){
        matrix[i5] = [
            i5
        ];
    }
    for(let j = 0; j <= a.length; j++){
        matrix[0][j] = j;
    }
    for(let i1 = 1; i1 <= b.length; i1++){
        for(let j = 1; j <= a.length; j++){
            if (b.charAt(i1 - 1) == a.charAt(j - 1)) {
                matrix[i1][j] = matrix[i1 - 1][j - 1];
            } else {
                matrix[i1][j] = Math.min(matrix[i1 - 1][j - 1] + 1, Math.min(matrix[i1][j - 1] + 1, matrix[i1 - 1][j] + 1));
            }
        }
    }
    return matrix[b.length][a.length];
}
function paramCaseToCamelCase(str2) {
    return str2.replace(/-([a-z])/g, (g)=>g[1].toUpperCase()
    );
}
function underscoreToCamelCase(str3) {
    return str3.replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase().replace(/_([a-z])/g, (g)=>g[1].toUpperCase()
    );
}
function getOption(flags, name1) {
    while(name1[0] === "-"){
        name1 = name1.slice(1);
    }
    for (const flag of flags){
        if (isOption(flag, name1)) {
            return flag;
        }
    }
    return;
}
function didYouMeanOption(option1, options) {
    const optionNames = options.map((option)=>[
            option.name,
            ...option.aliases ?? []
        ]
    ).flat().map((option)=>getFlag(option)
    );
    return didYouMean(" Did you mean option", getFlag(option1), optionNames);
}
function didYouMeanType(type1, types3) {
    return didYouMean(" Did you mean type", type1, types3);
}
function didYouMean(message, type2, types4) {
    const match = closest(type2, types4);
    return match ? `${message} "${match}"?` : "";
}
function getFlag(name2) {
    if (name2.startsWith("-")) {
        return name2;
    }
    if (name2.length > 1) {
        return `--${name2}`;
    }
    return `-${name2}`;
}
function isOption(option, name3) {
    return option.name === name3 || option.aliases && option.aliases.indexOf(name3) !== -1;
}
function matchWildCardOptions(name4, flags) {
    for (const option of flags){
        if (option.name.indexOf("*") === -1) {
            continue;
        }
        let matched = matchWildCardOption(name4, option);
        if (matched) {
            matched = {
                ...matched,
                name: name4
            };
            flags.push(matched);
            return matched;
        }
    }
}
function matchWildCardOption(name5, option) {
    const parts = option.name.split(".");
    const parts2 = name5.split(".");
    if (parts.length !== parts2.length) {
        return false;
    }
    const count = Math.max(parts.length, parts2.length);
    for(let i6 = 0; i6 < count; i6++){
        if (parts[i6] !== parts2[i6] && parts[i6] !== "*") {
            return false;
        }
    }
    return option;
}
function closest(str4, arr) {
    let minDistance = Infinity;
    let minIndex = 0;
    for(let i7 = 0; i7 < arr.length; i7++){
        const dist = distance(str4, arr[i7]);
        if (dist < minDistance) {
            minDistance = dist;
            minIndex = i7;
        }
    }
    return arr[minIndex];
}
function getDefaultValue(option) {
    return typeof option.default === "function" ? option.default() : option.default;
}
class FlagsError extends Error {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, FlagsError.prototype);
    }
}
class UnknownRequiredOption extends FlagsError {
    constructor(option, options){
        super(`Unknown required option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownRequiredOption.prototype);
    }
}
class UnknownConflictingOption extends FlagsError {
    constructor(option, options){
        super(`Unknown conflicting option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownConflictingOption.prototype);
    }
}
class UnknownType extends FlagsError {
    constructor(type3, types5){
        super(`Unknown type "${type3}".${didYouMeanType(type3, types5)}`);
        Object.setPrototypeOf(this, UnknownType.prototype);
    }
}
class ValidationError extends FlagsError {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, ValidationError.prototype);
    }
}
class DuplicateOption extends ValidationError {
    constructor(name6){
        super(`Option "${getFlag(name6).replace(/^--no-/, "--")}" can only occur once, but was found several times.`);
        Object.setPrototypeOf(this, DuplicateOption.prototype);
    }
}
class InvalidOption extends ValidationError {
    constructor(option, options){
        super(`Invalid option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, InvalidOption.prototype);
    }
}
class UnknownOption extends ValidationError {
    constructor(option, options){
        super(`Unknown option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownOption.prototype);
    }
}
class MissingOptionValue extends ValidationError {
    constructor(option){
        super(`Missing value for option "${getFlag(option)}".`);
        Object.setPrototypeOf(this, MissingOptionValue.prototype);
    }
}
class InvalidOptionValue extends ValidationError {
    constructor(option, expected, value){
        super(`Option "${getFlag(option)}" must be of type "${expected}", but got "${value}".`);
        Object.setPrototypeOf(this, InvalidOptionValue.prototype);
    }
}
class OptionNotCombinable extends ValidationError {
    constructor(option){
        super(`Option "${getFlag(option)}" cannot be combined with other options.`);
        Object.setPrototypeOf(this, OptionNotCombinable.prototype);
    }
}
class ConflictingOption extends ValidationError {
    constructor(option, conflictingOption){
        super(`Option "${getFlag(option)}" conflicts with option "${getFlag(conflictingOption)}".`);
        Object.setPrototypeOf(this, ConflictingOption.prototype);
    }
}
class DependingOption extends ValidationError {
    constructor(option, dependingOption){
        super(`Option "${getFlag(option)}" depends on option "${getFlag(dependingOption)}".`);
        Object.setPrototypeOf(this, DependingOption.prototype);
    }
}
class MissingRequiredOption extends ValidationError {
    constructor(option){
        super(`Missing required option "${getFlag(option)}".`);
        Object.setPrototypeOf(this, MissingRequiredOption.prototype);
    }
}
class RequiredArgumentFollowsOptionalArgument extends ValidationError {
    constructor(arg){
        super(`An required argument cannot follow an optional argument, but "${arg}"  is defined as required.`);
        Object.setPrototypeOf(this, RequiredArgumentFollowsOptionalArgument.prototype);
    }
}
class ArgumentFollowsVariadicArgument extends ValidationError {
    constructor(arg){
        super(`An argument cannot follow an variadic argument, but got "${arg}".`);
        Object.setPrototypeOf(this, ArgumentFollowsVariadicArgument.prototype);
    }
}
class NoArguments extends ValidationError {
    constructor(){
        super(`No arguments.`);
        Object.setPrototypeOf(this, NoArguments.prototype);
    }
}
class InvalidTypeError extends ValidationError {
    constructor({ label , name: name7 , value: value1 , type: type4  }, expected){
        super(`${label} "${name7}" must be of type "${type4}", but got "${value1}".` + (expected ? ` Expected values: ${expected.map((value)=>`"${value}"`
        ).join(", ")}` : ""));
        Object.setPrototypeOf(this, MissingOptionValue.prototype);
    }
}
var OptionType;
(function(OptionType1) {
    OptionType1["STRING"] = "string";
    OptionType1["NUMBER"] = "number";
    OptionType1["INTEGER"] = "integer";
    OptionType1["BOOLEAN"] = "boolean";
})(OptionType || (OptionType = {}));
function didYouMeanCommand(command1, commands1, excludes = []) {
    const commandNames = commands1.map((command)=>command.getName()
    ).filter((command)=>!excludes.includes(command)
    );
    return didYouMean(" Did you mean command", command1, commandNames);
}
const ARGUMENT_REGEX = /^[<\[].+[\]>]$/;
const ARGUMENT_DETAILS_REGEX = /[<\[:>\]]/;
function splitArguments(args) {
    const parts = args.trim().split(/[, =] */g);
    const typeParts = [];
    while(parts[parts.length - 1] && ARGUMENT_REGEX.test(parts[parts.length - 1])){
        typeParts.unshift(parts.pop());
    }
    const typeDefinition = typeParts.join(" ");
    return {
        flags: parts,
        typeDefinition,
        equalsSign: args.includes("=")
    };
}
function parseArgumentsDefinition(argsDefinition, validate1 = true, all) {
    const argumentDetails = [];
    let hasOptional = false;
    let hasVariadic = false;
    const parts = argsDefinition.split(/ +/);
    for (const arg of parts){
        if (validate1 && hasVariadic) {
            throw new ArgumentFollowsVariadicArgument(arg);
        }
        const parts = arg.split(ARGUMENT_DETAILS_REGEX);
        if (!parts[1]) {
            if (all) {
                argumentDetails.push(parts[0]);
            }
            continue;
        }
        const type5 = parts[2] || OptionType.STRING;
        const details = {
            optionalValue: arg[0] === "[",
            requiredValue: arg[0] === "<",
            name: parts[1],
            action: parts[3] || type5,
            variadic: false,
            list: type5 ? arg.indexOf(type5 + "[]") !== -1 : false,
            type: type5
        };
        if (validate1 && !details.optionalValue && hasOptional) {
            throw new RequiredArgumentFollowsOptionalArgument(details.name);
        }
        if (arg[0] === "[") {
            hasOptional = true;
        }
        if (details.name.length > 3) {
            const istVariadicLeft = details.name.slice(0, 3) === "...";
            const istVariadicRight = details.name.slice(-3) === "...";
            hasVariadic = details.variadic = istVariadicLeft || istVariadicRight;
            if (istVariadicLeft) {
                details.name = details.name.slice(3);
            } else if (istVariadicRight) {
                details.name = details.name.slice(0, -3);
            }
        }
        argumentDetails.push(details);
    }
    return argumentDetails;
}
function dedent(str5) {
    const lines1 = str5.split(/\r?\n|\r/g);
    let text = "";
    let indent = 0;
    for (const line of lines1){
        if (text || line.trim()) {
            if (!text) {
                text = line.trimStart();
                indent = line.length - text.length;
            } else {
                text += line.slice(indent);
            }
            text += "\n";
        }
    }
    return text.trimEnd();
}
function getDescription(description, __short) {
    return __short ? description.trim().split("\n", 1)[0] : dedent(description);
}
class CommandError extends Error {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, CommandError.prototype);
    }
}
class ValidationError1 extends CommandError {
    exitCode;
    constructor(message, { exitCode  } = {}){
        super(message);
        Object.setPrototypeOf(this, ValidationError1.prototype);
        this.exitCode = exitCode ?? 1;
    }
}
class DuplicateOptionName extends CommandError {
    constructor(name8){
        super(`Option with name "${getFlag(name8)}" already exists.`);
        Object.setPrototypeOf(this, DuplicateOptionName.prototype);
    }
}
class MissingCommandName extends CommandError {
    constructor(){
        super("Missing command name.");
        Object.setPrototypeOf(this, MissingCommandName.prototype);
    }
}
class DuplicateCommandName extends CommandError {
    constructor(name9){
        super(`Duplicate command name "${name9}".`);
        Object.setPrototypeOf(this, DuplicateCommandName.prototype);
    }
}
class DuplicateCommandAlias extends CommandError {
    constructor(alias){
        super(`Duplicate command alias "${alias}".`);
        Object.setPrototypeOf(this, DuplicateCommandAlias.prototype);
    }
}
class CommandNotFound extends CommandError {
    constructor(name10, commands2, excluded){
        super(`Unknown command "${name10}".${didYouMeanCommand(name10, commands2, excluded)}`);
        Object.setPrototypeOf(this, UnknownCommand.prototype);
    }
}
class DuplicateType extends CommandError {
    constructor(name11){
        super(`Type with name "${name11}" already exists.`);
        Object.setPrototypeOf(this, DuplicateType.prototype);
    }
}
class DuplicateCompletion extends CommandError {
    constructor(name12){
        super(`Completion with name "${name12}" already exists.`);
        Object.setPrototypeOf(this, DuplicateCompletion.prototype);
    }
}
class DuplicateExample extends CommandError {
    constructor(name13){
        super(`Example with name "${name13}" already exists.`);
        Object.setPrototypeOf(this, DuplicateExample.prototype);
    }
}
class DuplicateEnvironmentVariable extends CommandError {
    constructor(name14){
        super(`Environment variable with name "${name14}" already exists.`);
        Object.setPrototypeOf(this, DuplicateEnvironmentVariable.prototype);
    }
}
class MissingRequiredEnvVar extends ValidationError1 {
    constructor(envVar){
        super(`Missing required environment variable "${envVar.names[0]}".`);
        Object.setPrototypeOf(this, MissingRequiredEnvVar.prototype);
    }
}
class EnvironmentVariableSingleValue extends CommandError {
    constructor(name15){
        super(`An environment variable can only have one value, but "${name15}" has more than one.`);
        Object.setPrototypeOf(this, EnvironmentVariableSingleValue.prototype);
    }
}
class EnvironmentVariableOptionalValue extends CommandError {
    constructor(name16){
        super(`An environment variable cannot have an optional value, but "${name16}" is defined as optional.`);
        Object.setPrototypeOf(this, EnvironmentVariableOptionalValue.prototype);
    }
}
class EnvironmentVariableVariadicValue extends CommandError {
    constructor(name17){
        super(`An environment variable cannot have an variadic value, but "${name17}" is defined as variadic.`);
        Object.setPrototypeOf(this, EnvironmentVariableVariadicValue.prototype);
    }
}
class DefaultCommandNotFound extends CommandError {
    constructor(name18, commands3){
        super(`Default command "${name18}" not found.${didYouMeanCommand(name18, commands3)}`);
        Object.setPrototypeOf(this, DefaultCommandNotFound.prototype);
    }
}
class CommandExecutableNotFound extends CommandError {
    constructor(name19){
        super(`Command executable not found: ${name19}`);
        Object.setPrototypeOf(this, CommandExecutableNotFound.prototype);
    }
}
class UnknownCompletionCommand extends CommandError {
    constructor(name20, commands4){
        super(`Auto-completion failed. Unknown command "${name20}".${didYouMeanCommand(name20, commands4)}`);
        Object.setPrototypeOf(this, UnknownCompletionCommand.prototype);
    }
}
class UnknownCommand extends ValidationError1 {
    constructor(name21, commands5, excluded){
        super(`Unknown command "${name21}".${didYouMeanCommand(name21, commands5, excluded)}`);
        Object.setPrototypeOf(this, UnknownCommand.prototype);
    }
}
class NoArgumentsAllowed extends ValidationError1 {
    constructor(name22){
        super(`No arguments allowed for command "${name22}".`);
        Object.setPrototypeOf(this, NoArgumentsAllowed.prototype);
    }
}
class MissingArguments extends ValidationError1 {
    constructor(args){
        super("Missing argument(s): " + args.join(", "));
        Object.setPrototypeOf(this, MissingArguments.prototype);
    }
}
class MissingArgument extends ValidationError1 {
    constructor(arg){
        super(`Missing argument "${arg}".`);
        Object.setPrototypeOf(this, MissingArgument.prototype);
    }
}
class TooManyArguments extends ValidationError1 {
    constructor(args){
        super(`Too many arguments: ${args.join(" ")}`);
        Object.setPrototypeOf(this, TooManyArguments.prototype);
    }
}
const __boolean = (type6)=>{
    if (~[
        "1",
        "true"
    ].indexOf(type6.value)) {
        return true;
    }
    if (~[
        "0",
        "false"
    ].indexOf(type6.value)) {
        return false;
    }
    throw new InvalidTypeError(type6);
};
const number = (type7)=>{
    const value = Number(type7.value);
    if (Number.isFinite(value)) {
        return value;
    }
    throw new InvalidTypeError(type7);
};
const string = ({ value  })=>{
    return value;
};
function validateFlags(opts, values1, optionNameMap = {}) {
    if (!opts.flags?.length) {
        return;
    }
    const defaultValues = setDefaultValues(opts, values1, optionNameMap);
    const optionNames = Object.keys(values1);
    if (!optionNames.length && opts.allowEmpty) {
        return;
    }
    const options = optionNames.map((name23)=>({
            name: name23,
            option: getOption(opts.flags, optionNameMap[name23])
        })
    );
    for (const { name: name1 , option  } of options){
        if (!option) {
            throw new UnknownOption(name1, opts.flags);
        }
        if (validateStandaloneOption(option, options, optionNames, defaultValues)) {
            return;
        }
        validateConflictingOptions(option, values1);
        validateDependingOptions(option, values1, defaultValues);
        validateRequiredValues(option, values1, name1);
    }
    validateRequiredOptions(options, values1, opts);
}
function setDefaultValues(opts, values2, optionNameMap = {}) {
    const defaultValues = {};
    if (!opts.flags?.length) {
        return defaultValues;
    }
    for (const option of opts.flags){
        let name24;
        let defaultValue = undefined;
        if (option.name.startsWith("no-")) {
            const propName = option.name.replace(/^no-/, "");
            if (propName in values2) {
                continue;
            }
            const positiveOption = getOption(opts.flags, propName);
            if (positiveOption) {
                continue;
            }
            name24 = paramCaseToCamelCase(propName);
            defaultValue = true;
        }
        if (!name24) {
            name24 = paramCaseToCamelCase(option.name);
        }
        if (!(name24 in optionNameMap)) {
            optionNameMap[name24] = option.name;
        }
        const hasDefaultValue = (!opts.ignoreDefaults || typeof opts.ignoreDefaults[name24] === "undefined") && typeof values2[name24] === "undefined" && (typeof option.default !== "undefined" || typeof defaultValue !== "undefined");
        if (hasDefaultValue) {
            values2[name24] = getDefaultValue(option) ?? defaultValue;
            defaultValues[option.name] = true;
            if (typeof option.value === "function") {
                values2[name24] = option.value(values2[name24]);
            }
        }
    }
    return defaultValues;
}
function validateStandaloneOption(option, options, optionNames, defaultValues) {
    if (!option.standalone) {
        return false;
    }
    if (optionNames.length === 1) {
        return true;
    }
    if (options.every((opt)=>opt.option && (option === opt.option || defaultValues[opt.option.name])
    )) {
        return true;
    }
    throw new OptionNotCombinable(option.name);
}
function validateConflictingOptions(option, values3) {
    option.conflicts?.forEach((flag)=>{
        if (isset(flag, values3)) {
            throw new ConflictingOption(option.name, flag);
        }
    });
}
function validateDependingOptions(option, values4, defaultValues) {
    option.depends?.forEach((flag)=>{
        if (!isset(flag, values4) && !defaultValues[option.name]) {
            throw new DependingOption(option.name, flag);
        }
    });
}
function validateRequiredValues(option, values5, name25) {
    const isArray2 = (option.args?.length || 0) > 1;
    option.args?.forEach((arg, i8)=>{
        if (arg.requiredValue && (typeof values5[name25] === "undefined" || isArray2 && typeof values5[name25][i8] === "undefined")) {
            throw new MissingOptionValue(option.name);
        }
    });
}
function validateRequiredOptions(options, values6, opts) {
    if (!opts.flags?.length) {
        return;
    }
    for (const option of opts.flags){
        if (option.required && !(paramCaseToCamelCase(option.name) in values6)) {
            if ((!option.conflicts || !option.conflicts.find((flag)=>!!values6[flag]
            )) && !options.find((opt)=>opt.option?.conflicts?.find((flag)=>flag === option.name
                )
            )) {
                throw new MissingRequiredOption(option.name);
            }
        }
    }
}
function isset(flag, values7) {
    const name26 = paramCaseToCamelCase(flag);
    return typeof values7[name26] !== "undefined";
}
const integer = (type8)=>{
    const value = Number(type8.value);
    if (Number.isInteger(value)) {
        return value;
    }
    throw new InvalidTypeError(type8);
};
const Types = {
    [OptionType.STRING]: string,
    [OptionType.NUMBER]: number,
    [OptionType.INTEGER]: integer,
    [OptionType.BOOLEAN]: __boolean
};
function parseFlags(args, opts = {}) {
    args = args.slice();
    !opts.flags && (opts.flags = []);
    let inLiteral = false;
    let negate = false;
    const flags = {};
    const optionNameMap = {};
    let literal1 = [];
    let unknown = [];
    let stopEarly = null;
    opts.flags.forEach((opt)=>{
        opt.depends?.forEach((flag)=>{
            if (!opts.flags || !getOption(opts.flags, flag)) {
                throw new UnknownRequiredOption(flag, opts.flags ?? []);
            }
        });
        opt.conflicts?.forEach((flag)=>{
            if (!opts.flags || !getOption(opts.flags, flag)) {
                throw new UnknownConflictingOption(flag, opts.flags ?? []);
            }
        });
    });
    for(let argsIndex = 0; argsIndex < args.length; argsIndex++){
        let option1;
        let optionArgs1;
        let current = args[argsIndex];
        let currentValue;
        if (inLiteral) {
            literal1.push(current);
            continue;
        }
        if (current === "--") {
            inLiteral = true;
            continue;
        }
        const isFlag = current.length > 1 && current[0] === "-";
        const next = ()=>currentValue ?? args[argsIndex + 1]
        ;
        if (isFlag) {
            const isShort = current[1] !== "-";
            const isLong = isShort ? false : current.length > 3 && current[2] !== "-";
            if (!isShort && !isLong) {
                throw new InvalidOption(current, opts.flags);
            }
            const equalSignIndex = current.indexOf("=");
            if (equalSignIndex > -1) {
                currentValue = current.slice(equalSignIndex + 1) || undefined;
                current = current.slice(0, equalSignIndex);
            }
            if (isShort && current.length > 2 && current[2] !== ".") {
                args.splice(argsIndex, 1, ...splitFlags(current));
                current = args[argsIndex];
            } else if (isLong && current.startsWith("--no-")) {
                negate = true;
            }
            option1 = getOption(opts.flags, current);
            if (!option1) {
                if (opts.flags.length) {
                    const name27 = current.replace(/^-+/g, "");
                    option1 = matchWildCardOptions(name27, opts.flags);
                    if (!option1) {
                        throw new UnknownOption(current, opts.flags);
                    }
                }
                if (!option1) {
                    option1 = {
                        name: current.replace(/^-+/, ""),
                        optionalValue: true,
                        type: OptionType.STRING
                    };
                }
            }
            const positiveName = negate ? option1.name.replace(/^no-?/, "") : option1.name;
            const propName = paramCaseToCamelCase(positiveName);
            if (typeof flags[propName] !== "undefined") {
                if (!opts.flags.length) {
                    option1.collect = true;
                } else if (!option1.collect) {
                    throw new DuplicateOption(current);
                }
            }
            optionArgs1 = option1.args?.length ? option1.args : [
                {
                    type: option1.type,
                    requiredValue: option1.requiredValue,
                    optionalValue: option1.optionalValue,
                    variadic: option1.variadic,
                    list: option1.list,
                    separator: option1.separator
                }
            ];
            let optionArgsIndex = 0;
            let inOptionalArg = false;
            const previous = flags[propName];
            parseNext(option1, optionArgs1);
            if (typeof flags[propName] === "undefined") {
                if (optionArgs1[optionArgsIndex].requiredValue) {
                    throw new MissingOptionValue(option1.name);
                } else if (typeof option1.default !== "undefined") {
                    flags[propName] = getDefaultValue(option1);
                } else {
                    flags[propName] = true;
                }
            }
            if (option1.value) {
                flags[propName] = option1.value(flags[propName], previous);
            } else if (option1.collect) {
                const value = typeof previous !== "undefined" ? Array.isArray(previous) ? previous : [
                    previous
                ] : [];
                value.push(flags[propName]);
                flags[propName] = value;
            }
            optionNameMap[propName] = option1.name;
            opts.option?.(option1, flags[propName]);
            function parseNext(option3, optionArgs) {
                const arg1 = optionArgs[optionArgsIndex];
                if (!arg1) {
                    const flag = next();
                    throw new UnknownOption(flag, opts.flags ?? []);
                }
                if (!arg1.type) {
                    arg1.type = OptionType.BOOLEAN;
                }
                if (option3.args?.length) {
                    if ((typeof arg1.optionalValue === "undefined" || arg1.optionalValue === false) && typeof arg1.requiredValue === "undefined") {
                        arg1.requiredValue = true;
                    }
                } else {
                    if (arg1.type !== OptionType.BOOLEAN && (typeof arg1.optionalValue === "undefined" || arg1.optionalValue === false) && typeof arg1.requiredValue === "undefined") {
                        arg1.requiredValue = true;
                    }
                }
                if (arg1.requiredValue) {
                    if (inOptionalArg) {
                        throw new RequiredArgumentFollowsOptionalArgument(option3.name);
                    }
                } else {
                    inOptionalArg = true;
                }
                if (negate) {
                    flags[propName] = false;
                    return;
                }
                let result2;
                let increase = false;
                if (arg1.list && hasNext(arg1)) {
                    const parsed = next().split(arg1.separator || ",").map((nextValue)=>{
                        const value = parseValue(option3, arg1, nextValue);
                        if (typeof value === "undefined") {
                            throw new InvalidOptionValue(option3.name, arg1.type ?? "?", nextValue);
                        }
                        return value;
                    });
                    if (parsed?.length) {
                        result2 = parsed;
                    }
                } else {
                    if (hasNext(arg1)) {
                        result2 = parseValue(option3, arg1, next());
                    } else if (arg1.optionalValue && arg1.type === OptionType.BOOLEAN) {
                        result2 = true;
                    }
                }
                if (increase && typeof currentValue === "undefined") {
                    argsIndex++;
                    if (!arg1.variadic) {
                        optionArgsIndex++;
                    } else if (optionArgs[optionArgsIndex + 1]) {
                        throw new ArgumentFollowsVariadicArgument(next());
                    }
                }
                if (typeof result2 !== "undefined" && (optionArgs.length > 1 || arg1.variadic)) {
                    if (!flags[propName]) {
                        flags[propName] = [];
                    }
                    flags[propName].push(result2);
                    if (hasNext(arg1)) {
                        parseNext(option3, optionArgs);
                    }
                } else {
                    flags[propName] = result2;
                }
                function hasNext(arg) {
                    const nextValue = currentValue ?? args[argsIndex + 1];
                    if (!nextValue) {
                        return false;
                    }
                    if (optionArgs.length > 1 && optionArgsIndex >= optionArgs.length) {
                        return false;
                    }
                    if (arg.requiredValue) {
                        return true;
                    }
                    if (option3.equalsSign && arg.optionalValue && !arg.variadic && typeof currentValue === "undefined") {
                        return false;
                    }
                    if (arg.optionalValue || arg.variadic) {
                        return nextValue[0] !== "-" || arg.type === OptionType.NUMBER && !isNaN(Number(nextValue));
                    }
                    return false;
                }
                function parseValue(option, arg, value) {
                    const type9 = arg.type || OptionType.STRING;
                    const result = opts.parse ? opts.parse({
                        label: "Option",
                        type: type9,
                        name: `--${option.name}`,
                        value
                    }) : parseFlagValue(option, arg, value);
                    if (typeof result !== "undefined") {
                        increase = true;
                    }
                    return result;
                }
            }
        } else {
            if (opts.stopEarly) {
                stopEarly = current;
                break;
            }
            unknown.push(current);
        }
    }
    if (stopEarly) {
        const stopEarlyArgIndex = args.indexOf(stopEarly);
        if (stopEarlyArgIndex !== -1) {
            const doubleDashIndex = args.indexOf("--");
            unknown = args.slice(stopEarlyArgIndex, doubleDashIndex === -1 ? undefined : doubleDashIndex);
            if (doubleDashIndex !== -1) {
                literal1 = args.slice(doubleDashIndex + 1);
            }
        }
    }
    validateFlags(opts, flags, optionNameMap);
    const result1 = Object.keys(flags).reduce((result3, key)=>{
        if (~key.indexOf(".")) {
            key.split(".").reduce((result, subKey, index, parts)=>{
                if (index === parts.length - 1) {
                    result[subKey] = flags[key];
                } else {
                    result[subKey] = result[subKey] ?? {};
                }
                return result[subKey];
            }, result3);
        } else {
            result3[key] = flags[key];
        }
        return result3;
    }, {});
    return {
        flags: result1,
        unknown,
        literal: literal1
    };
}
function splitFlags(flag) {
    const normalized = [];
    const flags = flag.slice(1).split("");
    if (isNaN(Number(flag[flag.length - 1]))) {
        flags.forEach((val)=>normalized.push(`-${val}`)
        );
    } else {
        normalized.push(`-${flags.shift()}`);
        if (flags.length) {
            normalized.push(flags.join(""));
        }
    }
    return normalized;
}
function parseFlagValue(option, arg, value) {
    const type10 = arg.type || OptionType.STRING;
    const parseType = Types[type10];
    if (!parseType) {
        throw new UnknownType(type10, Object.keys(Types));
    }
    return parseType({
        label: "Option",
        type: type10,
        name: `--${option.name}`,
        value
    });
}
const { Deno: Deno2  } = globalThis;
const noColor = typeof Deno2?.noColor === "boolean" ? Deno2.noColor : true;
let enabled = !noColor;
function setColorEnabled(value) {
    if (noColor) {
        return;
    }
    enabled = value;
}
function getColorEnabled() {
    return enabled;
}
function code(open, close) {
    return {
        open: `\x1b[${open.join(";")}m`,
        close: `\x1b[${close}m`,
        regexp: new RegExp(`\\x1b\\[${close}m`, "g")
    };
}
function run(str6, code1) {
    return enabled ? `${code1.open}${str6.replace(code1.regexp, code1.open)}${code1.close}` : str6;
}
function reset(str7) {
    return run(str7, code([
        0
    ], 0));
}
function bold(str8) {
    return run(str8, code([
        1
    ], 22));
}
function dim(str9) {
    return run(str9, code([
        2
    ], 22));
}
function italic(str10) {
    return run(str10, code([
        3
    ], 23));
}
function underline(str11) {
    return run(str11, code([
        4
    ], 24));
}
function inverse(str12) {
    return run(str12, code([
        7
    ], 27));
}
function hidden(str13) {
    return run(str13, code([
        8
    ], 28));
}
function strikethrough(str14) {
    return run(str14, code([
        9
    ], 29));
}
function black(str15) {
    return run(str15, code([
        30
    ], 39));
}
function red(str16) {
    return run(str16, code([
        31
    ], 39));
}
function green(str17) {
    return run(str17, code([
        32
    ], 39));
}
function yellow(str18) {
    return run(str18, code([
        33
    ], 39));
}
function blue(str19) {
    return run(str19, code([
        34
    ], 39));
}
function magenta(str20) {
    return run(str20, code([
        35
    ], 39));
}
function cyan(str21) {
    return run(str21, code([
        36
    ], 39));
}
function white(str22) {
    return run(str22, code([
        37
    ], 39));
}
function gray(str23) {
    return brightBlack(str23);
}
function brightBlack(str24) {
    return run(str24, code([
        90
    ], 39));
}
function brightRed(str25) {
    return run(str25, code([
        91
    ], 39));
}
function brightGreen(str26) {
    return run(str26, code([
        92
    ], 39));
}
function brightYellow(str27) {
    return run(str27, code([
        93
    ], 39));
}
function brightBlue(str28) {
    return run(str28, code([
        94
    ], 39));
}
function brightMagenta(str29) {
    return run(str29, code([
        95
    ], 39));
}
function brightCyan(str30) {
    return run(str30, code([
        96
    ], 39));
}
function brightWhite(str31) {
    return run(str31, code([
        97
    ], 39));
}
function bgBlack(str32) {
    return run(str32, code([
        40
    ], 49));
}
function bgRed(str33) {
    return run(str33, code([
        41
    ], 49));
}
function bgGreen(str34) {
    return run(str34, code([
        42
    ], 49));
}
function bgYellow(str35) {
    return run(str35, code([
        43
    ], 49));
}
function bgBlue(str36) {
    return run(str36, code([
        44
    ], 49));
}
function bgMagenta(str37) {
    return run(str37, code([
        45
    ], 49));
}
function bgCyan(str38) {
    return run(str38, code([
        46
    ], 49));
}
function bgWhite(str39) {
    return run(str39, code([
        47
    ], 49));
}
function bgBrightBlack(str40) {
    return run(str40, code([
        100
    ], 49));
}
function bgBrightRed(str41) {
    return run(str41, code([
        101
    ], 49));
}
function bgBrightGreen(str42) {
    return run(str42, code([
        102
    ], 49));
}
function bgBrightYellow(str43) {
    return run(str43, code([
        103
    ], 49));
}
function bgBrightBlue(str44) {
    return run(str44, code([
        104
    ], 49));
}
function bgBrightMagenta(str45) {
    return run(str45, code([
        105
    ], 49));
}
function bgBrightCyan(str46) {
    return run(str46, code([
        106
    ], 49));
}
function bgBrightWhite(str47) {
    return run(str47, code([
        107
    ], 49));
}
function clampAndTruncate(n, max = 255, min = 0) {
    return Math.trunc(Math.max(Math.min(n, max), min));
}
function rgb8(str48, color) {
    return run(str48, code([
        38,
        5,
        clampAndTruncate(color)
    ], 39));
}
function bgRgb8(str49, color) {
    return run(str49, code([
        48,
        5,
        clampAndTruncate(color)
    ], 49));
}
function rgb24(str50, color) {
    if (typeof color === "number") {
        return run(str50, code([
            38,
            2,
            color >> 16 & 0xff,
            color >> 8 & 0xff,
            color & 0xff
        ], 39));
    }
    return run(str50, code([
        38,
        2,
        clampAndTruncate(color.r),
        clampAndTruncate(color.g),
        clampAndTruncate(color.b), 
    ], 39));
}
function bgRgb24(str51, color) {
    if (typeof color === "number") {
        return run(str51, code([
            48,
            2,
            color >> 16 & 0xff,
            color >> 8 & 0xff,
            color & 0xff
        ], 49));
    }
    return run(str51, code([
        48,
        2,
        clampAndTruncate(color.r),
        clampAndTruncate(color.g),
        clampAndTruncate(color.b), 
    ], 49));
}
const ANSI_PATTERN = new RegExp([
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-nq-uy=><~]))", 
].join("|"), "g");
function stripColor(string1) {
    return string1.replace(ANSI_PATTERN, "");
}
const mod = {
    setColorEnabled: setColorEnabled,
    getColorEnabled: getColorEnabled,
    reset: reset,
    bold: bold,
    dim: dim,
    italic: italic,
    underline: underline,
    inverse: inverse,
    hidden: hidden,
    strikethrough: strikethrough,
    black: black,
    red: red,
    green: green,
    yellow: yellow,
    blue: blue,
    magenta: magenta,
    cyan: cyan,
    white: white,
    gray: gray,
    brightBlack: brightBlack,
    brightRed: brightRed,
    brightGreen: brightGreen,
    brightYellow: brightYellow,
    brightBlue: brightBlue,
    brightMagenta: brightMagenta,
    brightCyan: brightCyan,
    brightWhite: brightWhite,
    bgBlack: bgBlack,
    bgRed: bgRed,
    bgGreen: bgGreen,
    bgYellow: bgYellow,
    bgBlue: bgBlue,
    bgMagenta: bgMagenta,
    bgCyan: bgCyan,
    bgWhite: bgWhite,
    bgBrightBlack: bgBrightBlack,
    bgBrightRed: bgBrightRed,
    bgBrightGreen: bgBrightGreen,
    bgBrightYellow: bgBrightYellow,
    bgBrightBlue: bgBrightBlue,
    bgBrightMagenta: bgBrightMagenta,
    bgBrightCyan: bgBrightCyan,
    bgBrightWhite: bgBrightWhite,
    rgb8: rgb8,
    bgRgb8: bgRgb8,
    rgb24: rgb24,
    bgRgb24: bgRgb24,
    stripColor: stripColor
};
class Type {
}
class BooleanType extends Type {
    parse(type11) {
        return __boolean(type11);
    }
    complete() {
        return [
            "true",
            "false"
        ];
    }
}
class StringType extends Type {
    parse(type12) {
        return string(type12);
    }
}
class FileType extends StringType {
    constructor(){
        super();
    }
}
class NumberType extends Type {
    parse(type13) {
        return number(type13);
    }
}
const border = {
    top: "─",
    topMid: "┬",
    topLeft: "┌",
    topRight: "┐",
    bottom: "─",
    bottomMid: "┴",
    bottomLeft: "└",
    bottomRight: "┘",
    left: "│",
    leftMid: "├",
    mid: "─",
    midMid: "┼",
    right: "│",
    rightMid: "┤",
    middle: "│"
};
class Cell {
    options;
    get length() {
        return this.toString().length;
    }
    static from(value) {
        const cell = new this(value);
        if (value instanceof Cell) {
            cell.options = {
                ...value.options
            };
        }
        return cell;
    }
    constructor(value){
        this.value = value;
        this.options = {};
    }
    toString() {
        return this.value.toString();
    }
    setValue(value) {
        this.value = value;
        return this;
    }
    clone(value) {
        const cell = new Cell(value ?? this);
        cell.options = {
            ...this.options
        };
        return cell;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    colSpan(span, override = true) {
        if (override || typeof this.options.colSpan === "undefined") {
            this.options.colSpan = span;
        }
        return this;
    }
    rowSpan(span, override = true) {
        if (override || typeof this.options.rowSpan === "undefined") {
            this.options.rowSpan = span;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    getBorder() {
        return this.options.border === true;
    }
    getColSpan() {
        return typeof this.options.colSpan === "number" && this.options.colSpan > 0 ? this.options.colSpan : 1;
    }
    getRowSpan() {
        return typeof this.options.rowSpan === "number" && this.options.rowSpan > 0 ? this.options.rowSpan : 1;
    }
    getAlign() {
        return this.options.align ?? "left";
    }
    value;
}
class Row extends Array {
    options = {};
    static from(cells) {
        const row = new this(...cells);
        if (cells instanceof Row) {
            row.options = {
                ...cells.options
            };
        }
        return row;
    }
    clone() {
        const row = new Row(...this.map((cell)=>cell instanceof Cell ? cell.clone() : cell
        ));
        row.options = {
            ...this.options
        };
        return row;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    getBorder() {
        return this.options.border === true;
    }
    hasBorder() {
        return this.getBorder() || this.some((cell)=>cell instanceof Cell && cell.getBorder()
        );
    }
    getAlign() {
        return this.options.align ?? "left";
    }
}
function consumeWords(length, content) {
    let consumed = "";
    const words = content.split("\n")[0]?.split(/ /g);
    for(let i9 = 0; i9 < words.length; i9++){
        const word = words[i9];
        if (consumed) {
            const nextLength = strLength(word);
            const consumedLength = strLength(consumed);
            if (consumedLength + nextLength >= length) {
                break;
            }
        }
        consumed += (i9 > 0 ? " " : "") + word;
    }
    return consumed;
}
function longest(index, rows, maxWidth) {
    const cellLengths = rows.map((row)=>{
        const cell = row[index];
        const cellValue = cell instanceof Cell && cell.getColSpan() > 1 ? "" : cell?.toString() || "";
        return cellValue.split("\n").map((line)=>{
            const str52 = typeof maxWidth === "undefined" ? line : consumeWords(maxWidth, line);
            return strLength(str52) || 0;
        });
    }).flat();
    return Math.max(...cellLengths);
}
const strLength = (str53)=>{
    str53 = stripColor(str53);
    let length = 0;
    for(let i10 = 0; i10 < str53.length; i10++){
        const charCode = str53.charCodeAt(i10);
        if (charCode >= 19968 && charCode <= 40869) {
            length += 2;
        } else {
            length += 1;
        }
    }
    return length;
};
class TableLayout {
    constructor(table, options){
        this.table = table;
        this.options = options;
    }
    toString() {
        const opts = this.createLayout();
        return opts.rows.length ? this.renderRows(opts) : "";
    }
    createLayout() {
        Object.keys(this.options.chars).forEach((key)=>{
            if (typeof this.options.chars[key] !== "string") {
                this.options.chars[key] = "";
            }
        });
        const hasBodyBorder = this.table.getBorder() || this.table.hasBodyBorder();
        const hasHeaderBorder = this.table.hasHeaderBorder();
        const hasBorder = hasHeaderBorder || hasBodyBorder;
        const rows = this.#getRows();
        const columns = Math.max(...rows.map((row)=>row.length
        ));
        for (const row1 of rows){
            const length = row1.length;
            if (length < columns) {
                const diff = columns - length;
                for(let i11 = 0; i11 < diff; i11++){
                    row1.push(this.createCell(null, row1));
                }
            }
        }
        const padding = [];
        const width = [];
        for(let colIndex = 0; colIndex < columns; colIndex++){
            const minColWidth = Array.isArray(this.options.minColWidth) ? this.options.minColWidth[colIndex] : this.options.minColWidth;
            const maxColWidth = Array.isArray(this.options.maxColWidth) ? this.options.maxColWidth[colIndex] : this.options.maxColWidth;
            const colWidth = longest(colIndex, rows, maxColWidth);
            width[colIndex] = Math.min(maxColWidth, Math.max(minColWidth, colWidth));
            padding[colIndex] = Array.isArray(this.options.padding) ? this.options.padding[colIndex] : this.options.padding;
        }
        return {
            padding,
            width,
            rows,
            columns,
            hasBorder,
            hasBodyBorder,
            hasHeaderBorder
        };
    }
     #getRows() {
        const header = this.table.getHeader();
        const rows = header ? [
            header,
            ...this.table
        ] : this.table.slice();
        const hasSpan = rows.some((row)=>row.some((cell)=>cell instanceof Cell && (cell.getColSpan() > 1 || cell.getRowSpan() > 1)
            )
        );
        if (hasSpan) {
            return this.spanRows(rows);
        }
        return rows.map((row)=>{
            const newRow = this.createRow(row);
            return newRow.map((cell)=>this.createCell(cell, newRow)
            );
        });
    }
    spanRows(_rows, rowIndex = 0, colIndex = 0, rowSpan = [], colSpan = 1) {
        const rows = _rows;
        if (rowIndex >= rows.length && rowSpan.every((span)=>span === 1
        )) {
            return rows;
        } else if (rows[rowIndex] && colIndex >= rows[rowIndex].length && colIndex >= rowSpan.length && colSpan === 1) {
            return this.spanRows(rows, ++rowIndex, 0, rowSpan, 1);
        }
        if (colSpan > 1) {
            colSpan--;
            rowSpan[colIndex] = rowSpan[colIndex - 1];
            rows[rowIndex].splice(colIndex - 1, 0, rows[rowIndex][colIndex - 1]);
            return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
        }
        if (colIndex === 0) {
            rows[rowIndex] = this.createRow(rows[rowIndex] || []);
        }
        if (rowSpan[colIndex] > 1) {
            rowSpan[colIndex]--;
            rows[rowIndex].splice(colIndex, 0, rows[rowIndex - 1][colIndex]);
            return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
        }
        rows[rowIndex][colIndex] = this.createCell(rows[rowIndex][colIndex] || null, rows[rowIndex]);
        colSpan = rows[rowIndex][colIndex].getColSpan();
        rowSpan[colIndex] = rows[rowIndex][colIndex].getRowSpan();
        return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
    }
    createRow(row) {
        return Row.from(row).border(this.table.getBorder(), false).align(this.table.getAlign(), false);
    }
    createCell(cell, row) {
        return Cell.from(cell ?? "").border(row.getBorder(), false).align(row.getAlign(), false);
    }
    renderRows(opts) {
        let result = "";
        const rowSpan = new Array(opts.columns).fill(1);
        for(let rowIndex = 0; rowIndex < opts.rows.length; rowIndex++){
            result += this.renderRow(rowSpan, rowIndex, opts);
        }
        return result.slice(0, -1);
    }
    renderRow(rowSpan, rowIndex, opts, isMultiline) {
        const row = opts.rows[rowIndex];
        const prevRow = opts.rows[rowIndex - 1];
        const nextRow = opts.rows[rowIndex + 1];
        let result = "";
        let colSpan = 1;
        if (!isMultiline && rowIndex === 0 && row.hasBorder()) {
            result += this.renderBorderRow(undefined, row, rowSpan, opts);
        }
        let isMultilineRow = false;
        result += " ".repeat(this.options.indent || 0);
        for(let colIndex = 0; colIndex < opts.columns; colIndex++){
            if (colSpan > 1) {
                colSpan--;
                rowSpan[colIndex] = rowSpan[colIndex - 1];
                continue;
            }
            result += this.renderCell(colIndex, row, opts);
            if (rowSpan[colIndex] > 1) {
                if (!isMultiline) {
                    rowSpan[colIndex]--;
                }
            } else if (!prevRow || prevRow[colIndex] !== row[colIndex]) {
                rowSpan[colIndex] = row[colIndex].getRowSpan();
            }
            colSpan = row[colIndex].getColSpan();
            if (rowSpan[colIndex] === 1 && row[colIndex].length) {
                isMultilineRow = true;
            }
        }
        if (opts.columns > 0) {
            if (row[opts.columns - 1].getBorder()) {
                result += this.options.chars.right;
            } else if (opts.hasBorder) {
                result += " ";
            }
        }
        result += "\n";
        if (isMultilineRow) {
            return result + this.renderRow(rowSpan, rowIndex, opts, isMultilineRow);
        }
        if (rowIndex === 0 && opts.hasHeaderBorder || rowIndex < opts.rows.length - 1 && opts.hasBodyBorder) {
            result += this.renderBorderRow(row, nextRow, rowSpan, opts);
        }
        if (rowIndex === opts.rows.length - 1 && row.hasBorder()) {
            result += this.renderBorderRow(row, undefined, rowSpan, opts);
        }
        return result;
    }
    renderCell(colIndex, row, opts, noBorder) {
        let result = "";
        const prevCell = row[colIndex - 1];
        const cell = row[colIndex];
        if (!noBorder) {
            if (colIndex === 0) {
                if (cell.getBorder()) {
                    result += this.options.chars.left;
                } else if (opts.hasBorder) {
                    result += " ";
                }
            } else {
                if (cell.getBorder() || prevCell?.getBorder()) {
                    result += this.options.chars.middle;
                } else if (opts.hasBorder) {
                    result += " ";
                }
            }
        }
        let maxLength = opts.width[colIndex];
        const colSpan = cell.getColSpan();
        if (colSpan > 1) {
            for(let o = 1; o < colSpan; o++){
                maxLength += opts.width[colIndex + o] + opts.padding[colIndex + o];
                if (opts.hasBorder) {
                    maxLength += opts.padding[colIndex + o] + 1;
                }
            }
        }
        const { current , next  } = this.renderCellValue(cell, maxLength);
        row[colIndex].setValue(next);
        if (opts.hasBorder) {
            result += " ".repeat(opts.padding[colIndex]);
        }
        result += current;
        if (opts.hasBorder || colIndex < opts.columns - 1) {
            result += " ".repeat(opts.padding[colIndex]);
        }
        return result;
    }
    renderCellValue(cell, maxLength) {
        const length = Math.min(maxLength, strLength(cell.toString()));
        let words = consumeWords(length, cell.toString());
        const breakWord = strLength(words) > length;
        if (breakWord) {
            words = words.slice(0, length);
        }
        const next = cell.toString().slice(words.length + (breakWord ? 0 : 1));
        const fillLength = maxLength - strLength(words);
        const align = cell.getAlign();
        let current;
        if (fillLength === 0) {
            current = words;
        } else if (align === "left") {
            current = words + " ".repeat(fillLength);
        } else if (align === "center") {
            current = " ".repeat(Math.floor(fillLength / 2)) + words + " ".repeat(Math.ceil(fillLength / 2));
        } else if (align === "right") {
            current = " ".repeat(fillLength) + words;
        } else {
            throw new Error("Unknown direction: " + align);
        }
        return {
            current,
            next: cell.clone(next)
        };
    }
    renderBorderRow(prevRow, nextRow, rowSpan, opts) {
        let result = "";
        let colSpan = 1;
        for(let colIndex = 0; colIndex < opts.columns; colIndex++){
            if (rowSpan[colIndex] > 1) {
                if (!nextRow) {
                    throw new Error("invalid layout");
                }
                if (colSpan > 1) {
                    colSpan--;
                    continue;
                }
            }
            result += this.renderBorderCell(colIndex, prevRow, nextRow, rowSpan, opts);
            colSpan = nextRow?.[colIndex].getColSpan() ?? 1;
        }
        return result.length ? " ".repeat(this.options.indent) + result + "\n" : "";
    }
    renderBorderCell(colIndex, prevRow, nextRow, rowSpan, opts) {
        const a1 = prevRow?.[colIndex - 1];
        const a2 = nextRow?.[colIndex - 1];
        const b1 = prevRow?.[colIndex];
        const b2 = nextRow?.[colIndex];
        const a1Border = !!a1?.getBorder();
        const a2Border = !!a2?.getBorder();
        const b1Border = !!b1?.getBorder();
        const b2Border = !!b2?.getBorder();
        const hasColSpan = (cell)=>(cell?.getColSpan() ?? 1) > 1
        ;
        const hasRowSpan = (cell)=>(cell?.getRowSpan() ?? 1) > 1
        ;
        let result = "";
        if (colIndex === 0) {
            if (rowSpan[colIndex] > 1) {
                if (b1Border) {
                    result += this.options.chars.left;
                } else {
                    result += " ";
                }
            } else if (b1Border && b2Border) {
                result += this.options.chars.leftMid;
            } else if (b1Border) {
                result += this.options.chars.bottomLeft;
            } else if (b2Border) {
                result += this.options.chars.topLeft;
            } else {
                result += " ";
            }
        } else if (colIndex < opts.columns) {
            if (a1Border && b2Border || b1Border && a2Border) {
                const a1ColSpan = hasColSpan(a1);
                const a2ColSpan = hasColSpan(a2);
                const b1ColSpan = hasColSpan(b1);
                const b2ColSpan = hasColSpan(b2);
                const a1RowSpan = hasRowSpan(a1);
                const a2RowSpan = hasRowSpan(a2);
                const b1RowSpan = hasRowSpan(b1);
                const b2RowSpan = hasRowSpan(b2);
                const hasAllBorder = a1Border && b2Border && b1Border && a2Border;
                const hasAllRowSpan = a1RowSpan && b1RowSpan && a2RowSpan && b2RowSpan;
                const hasAllColSpan = a1ColSpan && b1ColSpan && a2ColSpan && b2ColSpan;
                if (hasAllRowSpan && hasAllBorder) {
                    result += this.options.chars.middle;
                } else if (hasAllColSpan && hasAllBorder && a1 === b1 && a2 === b2) {
                    result += this.options.chars.mid;
                } else if (a1ColSpan && b1ColSpan && a1 === b1) {
                    result += this.options.chars.topMid;
                } else if (a2ColSpan && b2ColSpan && a2 === b2) {
                    result += this.options.chars.bottomMid;
                } else if (a1RowSpan && a2RowSpan && a1 === a2) {
                    result += this.options.chars.leftMid;
                } else if (b1RowSpan && b2RowSpan && b1 === b2) {
                    result += this.options.chars.rightMid;
                } else {
                    result += this.options.chars.midMid;
                }
            } else if (a1Border && b1Border) {
                if (hasColSpan(a1) && hasColSpan(b1) && a1 === b1) {
                    result += this.options.chars.bottom;
                } else {
                    result += this.options.chars.bottomMid;
                }
            } else if (b1Border && b2Border) {
                if (rowSpan[colIndex] > 1) {
                    result += this.options.chars.left;
                } else {
                    result += this.options.chars.leftMid;
                }
            } else if (b2Border && a2Border) {
                if (hasColSpan(a2) && hasColSpan(b2) && a2 === b2) {
                    result += this.options.chars.top;
                } else {
                    result += this.options.chars.topMid;
                }
            } else if (a1Border && a2Border) {
                if (hasRowSpan(a1) && a1 === a2) {
                    result += this.options.chars.right;
                } else {
                    result += this.options.chars.rightMid;
                }
            } else if (a1Border) {
                result += this.options.chars.bottomRight;
            } else if (b1Border) {
                result += this.options.chars.bottomLeft;
            } else if (a2Border) {
                result += this.options.chars.topRight;
            } else if (b2Border) {
                result += this.options.chars.topLeft;
            } else {
                result += " ";
            }
        }
        const length = opts.padding[colIndex] + opts.width[colIndex] + opts.padding[colIndex];
        if (rowSpan[colIndex] > 1 && nextRow) {
            result += this.renderCell(colIndex, nextRow, opts, true);
            if (nextRow[colIndex] === nextRow[nextRow.length - 1]) {
                if (b1Border) {
                    result += this.options.chars.right;
                } else {
                    result += " ";
                }
                return result;
            }
        } else if (b1Border && b2Border) {
            result += this.options.chars.mid.repeat(length);
        } else if (b1Border) {
            result += this.options.chars.bottom.repeat(length);
        } else if (b2Border) {
            result += this.options.chars.top.repeat(length);
        } else {
            result += " ".repeat(length);
        }
        if (colIndex === opts.columns - 1) {
            if (b1Border && b2Border) {
                result += this.options.chars.rightMid;
            } else if (b1Border) {
                result += this.options.chars.bottomRight;
            } else if (b2Border) {
                result += this.options.chars.topRight;
            } else {
                result += " ";
            }
        }
        return result;
    }
    table;
    options;
}
class Table extends Array {
    static _chars = {
        ...border
    };
    options = {
        indent: 0,
        border: false,
        maxColWidth: Infinity,
        minColWidth: 0,
        padding: 1,
        chars: {
            ...Table._chars
        }
    };
    headerRow;
    static from(rows) {
        const table = new this(...rows);
        if (rows instanceof Table) {
            table.options = {
                ...rows.options
            };
            table.headerRow = rows.headerRow ? Row.from(rows.headerRow) : undefined;
        }
        return table;
    }
    static fromJson(rows) {
        return new this().fromJson(rows);
    }
    static chars(chars) {
        Object.assign(this._chars, chars);
        return this;
    }
    static render(rows) {
        Table.from(rows).render();
    }
    fromJson(rows) {
        this.header(Object.keys(rows[0]));
        this.body(rows.map((row)=>Object.values(row)
        ));
        return this;
    }
    header(header) {
        this.headerRow = header instanceof Row ? header : Row.from(header);
        return this;
    }
    body(rows) {
        this.length = 0;
        this.push(...rows);
        return this;
    }
    clone() {
        const table = new Table(...this.map((row)=>row instanceof Row ? row.clone() : Row.from(row).clone()
        ));
        table.options = {
            ...this.options
        };
        table.headerRow = this.headerRow?.clone();
        return table;
    }
    toString() {
        return new TableLayout(this, this.options).toString();
    }
    render() {
        console.log(this.toString());
        return this;
    }
    maxColWidth(width, override = true) {
        if (override || typeof this.options.maxColWidth === "undefined") {
            this.options.maxColWidth = width;
        }
        return this;
    }
    minColWidth(width, override = true) {
        if (override || typeof this.options.minColWidth === "undefined") {
            this.options.minColWidth = width;
        }
        return this;
    }
    indent(width, override = true) {
        if (override || typeof this.options.indent === "undefined") {
            this.options.indent = width;
        }
        return this;
    }
    padding(padding, override = true) {
        if (override || typeof this.options.padding === "undefined") {
            this.options.padding = padding;
        }
        return this;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    chars(chars) {
        Object.assign(this.options.chars, chars);
        return this;
    }
    getHeader() {
        return this.headerRow;
    }
    getBody() {
        return [
            ...this
        ];
    }
    getMaxColWidth() {
        return this.options.maxColWidth;
    }
    getMinColWidth() {
        return this.options.minColWidth;
    }
    getIndent() {
        return this.options.indent;
    }
    getPadding() {
        return this.options.padding;
    }
    getBorder() {
        return this.options.border === true;
    }
    hasHeaderBorder() {
        const hasBorder = this.headerRow?.hasBorder();
        return hasBorder === true || this.getBorder() && hasBorder !== false;
    }
    hasBodyBorder() {
        return this.getBorder() || this.some((row)=>row instanceof Row ? row.hasBorder() : row.some((cell)=>cell instanceof Cell ? cell.getBorder : false
            )
        );
    }
    hasBorder() {
        return this.hasHeaderBorder() || this.hasBodyBorder();
    }
    getAlign() {
        return this.options.align ?? "left";
    }
}
class HelpGenerator {
    indent;
    options;
    static generate(cmd, options) {
        return new HelpGenerator(cmd, options).generate();
    }
    constructor(cmd, options = {}){
        this.cmd = cmd;
        this.indent = 2;
        this.options = {
            types: false,
            hints: true,
            colors: true,
            long: false,
            ...options
        };
    }
    generate() {
        const areColorsEnabled = getColorEnabled();
        setColorEnabled(this.options.colors);
        const result = this.generateHeader() + this.generateMeta() + this.generateDescription() + this.generateOptions() + this.generateCommands() + this.generateEnvironmentVariables() + this.generateExamples();
        setColorEnabled(areColorsEnabled);
        return result;
    }
    generateHeader() {
        const usage = this.cmd.getUsage();
        const rows = [
            [
                bold("Usage:"),
                magenta(this.cmd.getPath() + (usage ? " " + highlightArguments(usage, this.options.types) : "")), 
            ], 
        ];
        const version1 = this.cmd.getVersion();
        if (version1) {
            rows.push([
                bold("Version:"),
                yellow(`${this.cmd.getVersion()}`)
            ]);
        }
        return "\n" + Table.from(rows).indent(this.indent).padding(1).toString() + "\n";
    }
    generateMeta() {
        const meta1 = Object.entries(this.cmd.getMeta());
        if (!meta1.length) {
            return "";
        }
        const rows = [];
        for (const [name28, value] of meta1){
            rows.push([
                bold(`${name28}: `) + value
            ]);
        }
        return "\n" + Table.from(rows).indent(this.indent).padding(1).toString() + "\n";
    }
    generateDescription() {
        if (!this.cmd.getDescription()) {
            return "";
        }
        return this.label("Description") + Table.from([
            [
                dedent(this.cmd.getDescription())
            ], 
        ]).indent(this.indent * 2).maxColWidth(140).padding(1).toString() + "\n";
    }
    generateOptions() {
        const options = this.cmd.getOptions(false);
        if (!options.length) {
            return "";
        }
        let groups = [];
        const hasGroups = options.some((option)=>option.groupName
        );
        if (hasGroups) {
            for (const option of options){
                let group1 = groups.find((group)=>group.name === option.groupName
                );
                if (!group1) {
                    group1 = {
                        name: option.groupName,
                        options: []
                    };
                    groups.push(group1);
                }
                group1.options.push(option);
            }
        } else {
            groups = [
                {
                    name: "Options",
                    options
                }
            ];
        }
        let result = "";
        for (const group2 of groups){
            result += this.generateOptionGroup(group2);
        }
        return result;
    }
    generateOptionGroup(group) {
        if (!group.options.length) {
            return "";
        }
        const hasTypeDefinitions = !!group.options.find((option)=>!!option.typeDefinition
        );
        if (hasTypeDefinitions) {
            return this.label(group.name ?? "Options") + Table.from([
                ...group.options.map((option)=>[
                        option.flags.map((flag)=>blue(flag)
                        ).join(", "),
                        highlightArguments(option.typeDefinition || "", this.options.types),
                        red(bold("-")),
                        getDescription(option.description, !this.options.long),
                        this.generateHints(option), 
                    ]
                ), 
            ]).padding([
                2,
                2,
                1,
                2
            ]).indent(this.indent * 2).maxColWidth([
                60,
                60,
                1,
                80,
                60
            ]).toString() + "\n";
        }
        return this.label(group.name ?? "Options") + Table.from([
            ...group.options.map((option)=>[
                    option.flags.map((flag)=>blue(flag)
                    ).join(", "),
                    red(bold("-")),
                    getDescription(option.description, !this.options.long),
                    this.generateHints(option), 
                ]
            ), 
        ]).indent(this.indent * 2).maxColWidth([
            60,
            1,
            80,
            60
        ]).padding([
            2,
            1,
            2
        ]).toString() + "\n";
    }
    generateCommands() {
        const commands6 = this.cmd.getCommands(false);
        if (!commands6.length) {
            return "";
        }
        const hasTypeDefinitions = !!commands6.find((command)=>!!command.getArgsDefinition()
        );
        if (hasTypeDefinitions) {
            return this.label("Commands") + Table.from([
                ...commands6.map((command)=>[
                        [
                            command.getName(),
                            ...command.getAliases()
                        ].map((name29)=>blue(name29)
                        ).join(", "),
                        highlightArguments(command.getArgsDefinition() || "", this.options.types),
                        red(bold("-")),
                        command.getShortDescription(), 
                    ]
                ), 
            ]).indent(this.indent * 2).maxColWidth([
                60,
                60,
                1,
                80
            ]).padding([
                2,
                2,
                1,
                2
            ]).toString() + "\n";
        }
        return this.label("Commands") + Table.from([
            ...commands6.map((command)=>[
                    [
                        command.getName(),
                        ...command.getAliases()
                    ].map((name30)=>blue(name30)
                    ).join(", "),
                    red(bold("-")),
                    command.getShortDescription(), 
                ]
            ), 
        ]).maxColWidth([
            60,
            1,
            80
        ]).padding([
            2,
            1,
            2
        ]).indent(this.indent * 2).toString() + "\n";
    }
    generateEnvironmentVariables() {
        const envVars = this.cmd.getEnvVars(false);
        if (!envVars.length) {
            return "";
        }
        return this.label("Environment variables") + Table.from([
            ...envVars.map((envVar)=>[
                    envVar.names.map((name31)=>blue(name31)
                    ).join(", "),
                    highlightArgumentDetails(envVar.details, this.options.types),
                    red(bold("-")),
                    this.options.long ? dedent(envVar.description) : envVar.description.trim().split("\n", 1)[0], 
                ]
            ), 
        ]).padding([
            2,
            2,
            1
        ]).indent(this.indent * 2).maxColWidth([
            60,
            60,
            1,
            80
        ]).toString() + "\n";
    }
    generateExamples() {
        const examples = this.cmd.getExamples();
        if (!examples.length) {
            return "";
        }
        return this.label("Examples") + Table.from(examples.map((example)=>[
                dim(bold(`${capitalize(example.name)}:`)),
                dedent(example.description), 
            ]
        )).padding(1).indent(this.indent * 2).maxColWidth(150).toString() + "\n";
    }
    generateHints(option) {
        if (!this.options.hints) {
            return "";
        }
        const hints = [];
        option.required && hints.push(yellow(`required`));
        typeof option.default !== "undefined" && hints.push(bold(`Default: `) + inspect(option.default, this.options.colors));
        option.depends?.length && hints.push(yellow(bold(`Depends: `)) + italic(option.depends.map(getFlag).join(", ")));
        option.conflicts?.length && hints.push(red(bold(`Conflicts: `)) + italic(option.conflicts.map(getFlag).join(", ")));
        const type14 = this.cmd.getType(option.args[0]?.type)?.handler;
        if (type14 instanceof Type) {
            const possibleValues = type14.values?.(this.cmd, this.cmd.getParent());
            if (possibleValues?.length) {
                hints.push(bold(`Values: `) + possibleValues.map((value)=>inspect(value, this.options.colors)
                ).join(", "));
            }
        }
        if (hints.length) {
            return `(${hints.join(", ")})`;
        }
        return "";
    }
    label(label) {
        return "\n" + " ".repeat(this.indent) + bold(`${label}:`) + "\n\n";
    }
    cmd;
}
function capitalize(string2) {
    return (string2?.charAt(0).toUpperCase() + string2.slice(1)) ?? "";
}
function inspect(value, colors) {
    return Deno.inspect(value, {
        depth: 1,
        colors,
        trailingComma: false
    });
}
function highlightArguments(argsDefinition, types6 = true) {
    if (!argsDefinition) {
        return "";
    }
    return parseArgumentsDefinition(argsDefinition, false, true).map((arg)=>typeof arg === "string" ? arg : highlightArgumentDetails(arg, types6)
    ).join(" ");
}
function highlightArgumentDetails(arg, types7 = true) {
    let str54 = "";
    str54 += yellow(arg.optionalValue ? "[" : "<");
    let name32 = "";
    name32 += arg.name;
    if (arg.variadic) {
        name32 += "...";
    }
    name32 = magenta(name32);
    str54 += name32;
    if (types7) {
        str54 += yellow(":");
        str54 += red(arg.type);
        if (arg.list) {
            str54 += green("[]");
        }
    }
    str54 += yellow(arg.optionalValue ? "]" : ">");
    return str54;
}
class IntegerType extends Type {
    parse(type15) {
        return integer(type15);
    }
}
class Command {
    types = new Map();
    rawArgs = [];
    literalArgs = [];
    _name = "COMMAND";
    _parent;
    _globalParent;
    ver;
    desc = "";
    _usage;
    fn;
    options = [];
    commands = new Map();
    examples = [];
    envVars = [];
    aliases = [];
    completions = new Map();
    cmd = this;
    argsDefinition;
    isExecutable = false;
    throwOnError = false;
    _allowEmpty = false;
    _stopEarly = false;
    defaultCommand;
    _useRawArgs = false;
    args = [];
    isHidden = false;
    isGlobal = false;
    hasDefaults = false;
    _versionOption;
    _helpOption;
    _help;
    _shouldExit;
    _meta = {};
    _groupName;
    versionOption(flags, desc, opts) {
        this._versionOption = flags === false ? flags : {
            flags,
            desc,
            opts: typeof opts === "function" ? {
                action: opts
            } : opts
        };
        return this;
    }
    helpOption(flags, desc, opts) {
        this._helpOption = flags === false ? flags : {
            flags,
            desc,
            opts: typeof opts === "function" ? {
                action: opts
            } : opts
        };
        return this;
    }
    command(nameAndArguments, cmdOrDescription, override) {
        this.reset();
        const result = splitArguments(nameAndArguments);
        const name33 = result.flags.shift();
        const aliases = result.flags;
        if (!name33) {
            throw new MissingCommandName();
        }
        if (this.getBaseCommand(name33, true)) {
            if (!override) {
                throw new DuplicateCommandName(name33);
            }
            this.removeCommand(name33);
        }
        let description;
        let cmd;
        if (typeof cmdOrDescription === "string") {
            description = cmdOrDescription;
        }
        if (cmdOrDescription instanceof Command) {
            cmd = cmdOrDescription.reset();
        } else {
            cmd = new Command();
        }
        cmd._name = name33;
        cmd._parent = this;
        if (description) {
            cmd.description(description);
        }
        if (result.typeDefinition) {
            cmd.arguments(result.typeDefinition);
        }
        aliases.forEach((alias)=>cmd.alias(alias)
        );
        this.commands.set(name33, cmd);
        this.select(name33);
        return this;
    }
    alias(alias) {
        if (this.cmd._name === alias || this.cmd.aliases.includes(alias)) {
            throw new DuplicateCommandAlias(alias);
        }
        this.cmd.aliases.push(alias);
        return this;
    }
    reset() {
        this._groupName = undefined;
        this.cmd = this;
        return this;
    }
    select(name34) {
        const cmd = this.getBaseCommand(name34, true);
        if (!cmd) {
            throw new CommandNotFound(name34, this.getBaseCommands(true));
        }
        this.cmd = cmd;
        return this;
    }
    name(name35) {
        this.cmd._name = name35;
        return this;
    }
    version(version2) {
        if (typeof version2 === "string") {
            this.cmd.ver = ()=>version2
            ;
        } else if (typeof version2 === "function") {
            this.cmd.ver = version2;
        }
        return this;
    }
    meta(name36, value) {
        this.cmd._meta[name36] = value;
        return this;
    }
    getMeta(name37) {
        return typeof name37 === "undefined" ? this._meta : this._meta[name37];
    }
    help(help) {
        if (typeof help === "string") {
            this.cmd._help = ()=>help
            ;
        } else if (typeof help === "function") {
            this.cmd._help = help;
        } else {
            this.cmd._help = (cmd, options)=>HelpGenerator.generate(cmd, {
                    ...help,
                    ...options
                })
            ;
        }
        return this;
    }
    description(description) {
        this.cmd.desc = description;
        return this;
    }
    usage(usage) {
        this.cmd._usage = usage;
        return this;
    }
    hidden() {
        this.cmd.isHidden = true;
        return this;
    }
    global() {
        this.cmd.isGlobal = true;
        return this;
    }
    executable() {
        this.cmd.isExecutable = true;
        return this;
    }
    arguments(args) {
        this.cmd.argsDefinition = args;
        return this;
    }
    action(fn) {
        this.cmd.fn = fn;
        return this;
    }
    allowEmpty(allowEmpty = true) {
        this.cmd._allowEmpty = allowEmpty;
        return this;
    }
    stopEarly(stopEarly = true) {
        this.cmd._stopEarly = stopEarly;
        return this;
    }
    useRawArgs(useRawArgs = true) {
        this.cmd._useRawArgs = useRawArgs;
        return this;
    }
    default(name38) {
        this.cmd.defaultCommand = name38;
        return this;
    }
    globalType(name39, handler, options) {
        return this.type(name39, handler, {
            ...options,
            global: true
        });
    }
    type(name40, handler, options) {
        if (this.cmd.types.get(name40) && !options?.override) {
            throw new DuplicateType(name40);
        }
        this.cmd.types.set(name40, {
            ...options,
            name: name40,
            handler
        });
        if (handler instanceof Type && (typeof handler.complete !== "undefined" || typeof handler.values !== "undefined")) {
            const completeHandler = (cmd, parent)=>handler.complete?.(cmd, parent) || []
            ;
            this.complete(name40, completeHandler, options);
        }
        return this;
    }
    globalComplete(name41, complete, options) {
        return this.complete(name41, complete, {
            ...options,
            global: true
        });
    }
    complete(name42, complete, options) {
        if (this.cmd.completions.has(name42) && !options?.override) {
            throw new DuplicateCompletion(name42);
        }
        this.cmd.completions.set(name42, {
            name: name42,
            complete,
            ...options
        });
        return this;
    }
    throwErrors() {
        this.cmd.throwOnError = true;
        return this;
    }
    noExit() {
        this.cmd._shouldExit = false;
        this.throwErrors();
        return this;
    }
    shouldThrowErrors() {
        return this.cmd.throwOnError || !!this.cmd._parent?.shouldThrowErrors();
    }
    shouldExit() {
        return (this.cmd._shouldExit ?? this.cmd._parent?.shouldExit()) ?? true;
    }
    globalOption(flags, desc, opts) {
        if (typeof opts === "function") {
            return this.option(flags, desc, {
                value: opts,
                global: true
            });
        }
        return this.option(flags, desc, {
            ...opts,
            global: true
        });
    }
    group(name43) {
        this.cmd._groupName = name43;
        return this;
    }
    option(flags, desc, opts) {
        if (typeof opts === "function") {
            return this.option(flags, desc, {
                value: opts
            });
        }
        const result = splitArguments(flags);
        const args = result.typeDefinition ? parseArgumentsDefinition(result.typeDefinition) : [];
        const option = {
            ...opts,
            name: "",
            description: desc,
            args,
            flags: result.flags,
            equalsSign: result.equalsSign,
            typeDefinition: result.typeDefinition,
            groupName: this._groupName
        };
        if (option.separator) {
            for (const arg of args){
                if (arg.list) {
                    arg.separator = option.separator;
                }
            }
        }
        for (const part of option.flags){
            const arg = part.trim();
            const isLong = /^--/.test(arg);
            const name44 = isLong ? arg.slice(2) : arg.slice(1);
            if (this.cmd.getBaseOption(name44, true)) {
                if (opts?.override) {
                    this.removeOption(name44);
                } else {
                    throw new DuplicateOptionName(name44);
                }
            }
            if (!option.name && isLong) {
                option.name = name44;
            } else if (!option.aliases) {
                option.aliases = [
                    name44
                ];
            } else {
                option.aliases.push(name44);
            }
        }
        if (option.prepend) {
            this.cmd.options.unshift(option);
        } else {
            this.cmd.options.push(option);
        }
        return this;
    }
    example(name45, description) {
        if (this.cmd.hasExample(name45)) {
            throw new DuplicateExample(name45);
        }
        this.cmd.examples.push({
            name: name45,
            description
        });
        return this;
    }
    globalEnv(name46, description, options) {
        return this.env(name46, description, {
            ...options,
            global: true
        });
    }
    env(name47, description, options) {
        const result = splitArguments(name47);
        if (!result.typeDefinition) {
            result.typeDefinition = "<value:boolean>";
        }
        if (result.flags.some((envName)=>this.cmd.getBaseEnvVar(envName, true)
        )) {
            throw new DuplicateEnvironmentVariable(name47);
        }
        const details = parseArgumentsDefinition(result.typeDefinition);
        if (details.length > 1) {
            throw new EnvironmentVariableSingleValue(name47);
        } else if (details.length && details[0].optionalValue) {
            throw new EnvironmentVariableOptionalValue(name47);
        } else if (details.length && details[0].variadic) {
            throw new EnvironmentVariableVariadicValue(name47);
        }
        this.cmd.envVars.push({
            name: result.flags[0],
            names: result.flags,
            description,
            type: details[0].type,
            details: details.shift(),
            ...options
        });
        return this;
    }
    async parse(args = Deno.args) {
        try {
            this.reset();
            this.registerDefaults();
            this.rawArgs = args;
            if (args.length > 0) {
                const subCommand = this.getCommand(args[0], true);
                if (subCommand) {
                    subCommand._globalParent = this;
                    return subCommand.parse(this.rawArgs.slice(1));
                }
            }
            if (this.isExecutable) {
                await this.executeExecutable(this.rawArgs);
                return {
                    options: {},
                    args: [],
                    cmd: this,
                    literal: []
                };
            } else if (this._useRawArgs) {
                const env = await this.parseEnvVars();
                return this.execute(env, ...this.rawArgs);
            } else {
                const env = await this.parseEnvVars();
                const { actionOption , flags , unknown , literal: literal2  } = this.parseFlags(this.rawArgs, env);
                this.literalArgs = literal2;
                const options = {
                    ...env,
                    ...flags
                };
                const params = this.parseArguments(unknown, options);
                if (actionOption) {
                    await actionOption.action.call(this, options, ...params);
                    if (actionOption.standalone) {
                        return {
                            options,
                            args: params,
                            cmd: this,
                            literal: this.literalArgs
                        };
                    }
                }
                return this.execute(options, ...params);
            }
        } catch (error2) {
            if (error2 instanceof Error) {
                throw this.error(error2);
            } else {
                throw this.error(new Error(`[non-error-thrown] ${error2}`));
            }
        }
    }
    registerDefaults() {
        if (this.hasDefaults || this.getParent()) {
            return this;
        }
        this.hasDefaults = true;
        this.reset();
        !this.types.has("string") && this.type("string", new StringType(), {
            global: true
        });
        !this.types.has("number") && this.type("number", new NumberType(), {
            global: true
        });
        !this.types.has("integer") && this.type("integer", new IntegerType(), {
            global: true
        });
        !this.types.has("boolean") && this.type("boolean", new BooleanType(), {
            global: true
        });
        !this.types.has("file") && this.type("file", new FileType(), {
            global: true
        });
        if (!this._help) {
            this.help({
                hints: true,
                types: false
            });
        }
        if (this._versionOption !== false && (this._versionOption || this.ver)) {
            this.option(this._versionOption?.flags || "-V, --version", this._versionOption?.desc || "Show the version number for this program.", {
                standalone: true,
                prepend: true,
                action: async function() {
                    const __long = this.getRawArgs().includes(`--${versionOption.name}`);
                    if (__long) {
                        await this.checkVersion();
                        this.showLongVersion();
                    } else {
                        this.showVersion();
                    }
                    this.exit();
                },
                ...this._versionOption?.opts ?? {}
            });
            const versionOption = this.options[0];
        }
        if (this._helpOption !== false) {
            this.option(this._helpOption?.flags || "-h, --help", this._helpOption?.desc || "Show this help.", {
                standalone: true,
                global: true,
                prepend: true,
                action: async function() {
                    const __long = this.getRawArgs().includes(`--${helpOption.name}`);
                    await this.checkVersion();
                    this.showHelp({
                        long: __long
                    });
                    this.exit();
                },
                ...this._helpOption?.opts ?? {}
            });
            const helpOption = this.options[0];
        }
        return this;
    }
    async execute(options, ...args) {
        if (this.fn) {
            await this.fn(options, ...args);
        } else if (this.defaultCommand) {
            const cmd = this.getCommand(this.defaultCommand, true);
            if (!cmd) {
                throw new DefaultCommandNotFound(this.defaultCommand, this.getCommands());
            }
            cmd._globalParent = this;
            await cmd.execute(options, ...args);
        }
        return {
            options,
            args,
            cmd: this,
            literal: this.literalArgs
        };
    }
    async executeExecutable(args) {
        const command = this.getPath().replace(/\s+/g, "-");
        await Deno.permissions.request({
            name: "run",
            command
        });
        try {
            const process = Deno.run({
                cmd: [
                    command,
                    ...args
                ]
            });
            const status = await process.status();
            if (!status.success) {
                Deno.exit(status.code);
            }
        } catch (error3) {
            if (error3 instanceof Deno.errors.NotFound) {
                throw new CommandExecutableNotFound(command);
            }
            throw error3;
        }
    }
    parseFlags(args, env) {
        try {
            let actionOption;
            const result = parseFlags(args, {
                stopEarly: this._stopEarly,
                allowEmpty: this._allowEmpty,
                flags: this.getOptions(true),
                ignoreDefaults: env,
                parse: (type16)=>this.parseType(type16)
                ,
                option: (option)=>{
                    if (!actionOption && option.action) {
                        actionOption = option;
                    }
                }
            });
            return {
                ...result,
                actionOption
            };
        } catch (error4) {
            if (error4 instanceof ValidationError) {
                throw new ValidationError1(error4.message);
            }
            throw error4;
        }
    }
    parseType(type1) {
        const typeSettings = this.getType(type1.type);
        if (!typeSettings) {
            throw new UnknownType(type1.type, this.getTypes().map((type17)=>type17.name
            ));
        }
        return typeSettings.handler instanceof Type ? typeSettings.handler.parse(type1) : typeSettings.handler(type1);
    }
    async parseEnvVars() {
        const envVars = this.getEnvVars(true);
        const result = {};
        if (!envVars.length) {
            return result;
        }
        const hasEnvPermissions = (await Deno.permissions.query({
            name: "env"
        })).state === "granted";
        for (const env of envVars){
            const name1 = hasEnvPermissions && env.names.find((name48)=>!!Deno.env.get(name48)
            );
            if (name1) {
                const propertyName = underscoreToCamelCase(env.prefix ? env.names[0].replace(new RegExp(`^${env.prefix}`), "") : env.names[0]);
                if (env.details.list) {
                    const values8 = Deno.env.get(name1)?.split(env.details.separator ?? ",") ?? [
                        ""
                    ];
                    result[propertyName] = values8.map((value)=>this.parseType({
                            label: "Environment variable",
                            type: env.type,
                            name: name1,
                            value
                        })
                    );
                } else {
                    result[propertyName] = this.parseType({
                        label: "Environment variable",
                        type: env.type,
                        name: name1,
                        value: Deno.env.get(name1) ?? ""
                    });
                }
                if (env.value && typeof result[propertyName] !== "undefined") {
                    result[propertyName] = env.value(result[propertyName]);
                }
            } else if (env.required) {
                throw new MissingRequiredEnvVar(env);
            }
        }
        return result;
    }
    parseArguments(args, flags) {
        const params = [];
        args = args.slice(0);
        if (!this.hasArguments()) {
            if (args.length) {
                if (this.hasCommands(true)) {
                    throw new UnknownCommand(args[0], this.getCommands());
                } else {
                    throw new NoArgumentsAllowed(this.getPath());
                }
            }
        } else {
            if (!args.length) {
                const required = this.getArguments().filter((expectedArg)=>!expectedArg.optionalValue
                ).map((expectedArg)=>expectedArg.name
                );
                if (required.length) {
                    const flagNames = Object.keys(flags);
                    const hasStandaloneOption = !!flagNames.find((name49)=>this.getOption(name49, true)?.standalone
                    );
                    if (!hasStandaloneOption) {
                        throw new MissingArguments(required);
                    }
                }
            } else {
                for (const expectedArg of this.getArguments()){
                    if (!args.length) {
                        if (expectedArg.optionalValue) {
                            break;
                        }
                        throw new MissingArgument(`Missing argument: ${expectedArg.name}`);
                    }
                    let arg;
                    if (expectedArg.variadic) {
                        arg = args.splice(0, args.length).map((value)=>this.parseType({
                                label: "Argument",
                                type: expectedArg.type,
                                name: expectedArg.name,
                                value
                            })
                        );
                    } else {
                        arg = this.parseType({
                            label: "Argument",
                            type: expectedArg.type,
                            name: expectedArg.name,
                            value: args.shift()
                        });
                    }
                    if (typeof arg !== "undefined") {
                        params.push(arg);
                    }
                }
                if (args.length) {
                    throw new TooManyArguments(args);
                }
            }
        }
        return params;
    }
    error(error5) {
        if (this.shouldThrowErrors() || !(error5 instanceof ValidationError1)) {
            return error5;
        }
        this.showHelp();
        console.error(red(`  ${bold("error")}: ${error5.message}\n`));
        Deno.exit(error5 instanceof ValidationError1 ? error5.exitCode : 1);
    }
    getName() {
        return this._name;
    }
    getParent() {
        return this._parent;
    }
    getGlobalParent() {
        return this._globalParent;
    }
    getMainCommand() {
        return this._parent?.getMainCommand() ?? this;
    }
    getAliases() {
        return this.aliases;
    }
    getPath() {
        return this._parent ? this._parent.getPath() + " " + this._name : this._name;
    }
    getArgsDefinition() {
        return this.argsDefinition;
    }
    getArgument(name50) {
        return this.getArguments().find((arg)=>arg.name === name50
        );
    }
    getArguments() {
        if (!this.args.length && this.argsDefinition) {
            this.args = parseArgumentsDefinition(this.argsDefinition);
        }
        return this.args;
    }
    hasArguments() {
        return !!this.argsDefinition;
    }
    getVersion() {
        return this.getVersionHandler()?.call(this, this);
    }
    getVersionHandler() {
        return this.ver ?? this._parent?.getVersionHandler();
    }
    getDescription() {
        return typeof this.desc === "function" ? this.desc = this.desc() : this.desc;
    }
    getUsage() {
        return this._usage ?? this.getArgsDefinition();
    }
    getShortDescription() {
        return getDescription(this.getDescription(), true);
    }
    getRawArgs() {
        return this.rawArgs;
    }
    getLiteralArgs() {
        return this.literalArgs;
    }
    showVersion() {
        console.log(this.getVersion());
    }
    getLongVersion() {
        return `${bold(this.getMainCommand().getName())} ${blue(this.getVersion() ?? "")}` + Object.entries(this.getMeta()).map(([k, v])=>`\n${bold(k)} ${blue(v)}`
        ).join("");
    }
    showLongVersion() {
        console.log(this.getLongVersion());
    }
    showHelp(options) {
        console.log(this.getHelp(options));
    }
    getHelp(options) {
        this.registerDefaults();
        return this.getHelpHandler().call(this, this, options ?? {});
    }
    getHelpHandler() {
        return this._help ?? this._parent?.getHelpHandler();
    }
    exit(code2 = 0) {
        if (this.shouldExit()) {
            Deno.exit(code2);
        }
    }
    async checkVersion() {
        const mainCommand = this.getMainCommand();
        const upgradeCommand = mainCommand.getCommand("upgrade");
        if (isUpgradeCommand(upgradeCommand)) {
            const latestVersion = await upgradeCommand.getLatestVersion();
            const currentVersion = mainCommand.getVersion();
            if (currentVersion !== latestVersion) {
                mainCommand.version(`${currentVersion}  ${bold(yellow(`(New version available: ${latestVersion}. Run '${mainCommand.getName()} upgrade' to upgrade to the latest version!)`))}`);
            }
        }
    }
    hasOptions(hidden1) {
        return this.getOptions(hidden1).length > 0;
    }
    getOptions(hidden2) {
        return this.getGlobalOptions(hidden2).concat(this.getBaseOptions(hidden2));
    }
    getBaseOptions(hidden3) {
        if (!this.options.length) {
            return [];
        }
        return hidden3 ? this.options.slice(0) : this.options.filter((opt)=>!opt.hidden
        );
    }
    getGlobalOptions(hidden4) {
        const getOptions1 = (cmd, options = [], names = [])=>{
            if (cmd) {
                if (cmd.options.length) {
                    cmd.options.forEach((option)=>{
                        if (option.global && !this.options.find((opt)=>opt.name === option.name
                        ) && names.indexOf(option.name) === -1 && (hidden4 || !option.hidden)) {
                            names.push(option.name);
                            options.push(option);
                        }
                    });
                }
                return getOptions1(cmd._parent, options, names);
            }
            return options;
        };
        return getOptions1(this._parent);
    }
    hasOption(name51, hidden5) {
        return !!this.getOption(name51, hidden5);
    }
    getOption(name52, hidden6) {
        return this.getBaseOption(name52, hidden6) ?? this.getGlobalOption(name52, hidden6);
    }
    getBaseOption(name53, hidden7) {
        const option1 = this.options.find((option)=>option.name === name53
        );
        return option1 && (hidden7 || !option1.hidden) ? option1 : undefined;
    }
    getGlobalOption(name54, hidden8) {
        if (!this._parent) {
            return;
        }
        const option = this._parent.getBaseOption(name54, hidden8);
        if (!option || !option.global) {
            return this._parent.getGlobalOption(name54, hidden8);
        }
        return option;
    }
    removeOption(name55) {
        const index = this.options.findIndex((option)=>option.name === name55
        );
        if (index === -1) {
            return;
        }
        return this.options.splice(index, 1)[0];
    }
    hasCommands(hidden9) {
        return this.getCommands(hidden9).length > 0;
    }
    getCommands(hidden10) {
        return this.getGlobalCommands(hidden10).concat(this.getBaseCommands(hidden10));
    }
    getBaseCommands(hidden11) {
        const commands7 = Array.from(this.commands.values());
        return hidden11 ? commands7 : commands7.filter((cmd)=>!cmd.isHidden
        );
    }
    getGlobalCommands(hidden12) {
        const getCommands = (cmd1, commands8 = [], names = [])=>{
            if (cmd1) {
                if (cmd1.commands.size) {
                    cmd1.commands.forEach((cmd)=>{
                        if (cmd.isGlobal && this !== cmd && !this.commands.has(cmd._name) && names.indexOf(cmd._name) === -1 && (hidden12 || !cmd.isHidden)) {
                            names.push(cmd._name);
                            commands8.push(cmd);
                        }
                    });
                }
                return getCommands(cmd1._parent, commands8, names);
            }
            return commands8;
        };
        return getCommands(this._parent);
    }
    hasCommand(name56, hidden13) {
        return !!this.getCommand(name56, hidden13);
    }
    getCommand(name57, hidden14) {
        return this.getBaseCommand(name57, hidden14) ?? this.getGlobalCommand(name57, hidden14);
    }
    getBaseCommand(name58, hidden15) {
        for (const cmd of this.commands.values()){
            if (cmd._name === name58 || cmd.aliases.includes(name58)) {
                return cmd && (hidden15 || !cmd.isHidden) ? cmd : undefined;
            }
        }
    }
    getGlobalCommand(name59, hidden16) {
        if (!this._parent) {
            return;
        }
        const cmd = this._parent.getBaseCommand(name59, hidden16);
        if (!cmd?.isGlobal) {
            return this._parent.getGlobalCommand(name59, hidden16);
        }
        return cmd;
    }
    removeCommand(name60) {
        const command = this.getBaseCommand(name60, true);
        if (command) {
            this.commands.delete(command._name);
        }
        return command;
    }
    getTypes() {
        return this.getGlobalTypes().concat(this.getBaseTypes());
    }
    getBaseTypes() {
        return Array.from(this.types.values());
    }
    getGlobalTypes() {
        const getTypes = (cmd, types8 = [], names = [])=>{
            if (cmd) {
                if (cmd.types.size) {
                    cmd.types.forEach((type18)=>{
                        if (type18.global && !this.types.has(type18.name) && names.indexOf(type18.name) === -1) {
                            names.push(type18.name);
                            types8.push(type18);
                        }
                    });
                }
                return getTypes(cmd._parent, types8, names);
            }
            return types8;
        };
        return getTypes(this._parent);
    }
    getType(name61) {
        return this.getBaseType(name61) ?? this.getGlobalType(name61);
    }
    getBaseType(name62) {
        return this.types.get(name62);
    }
    getGlobalType(name63) {
        if (!this._parent) {
            return;
        }
        const cmd = this._parent.getBaseType(name63);
        if (!cmd?.global) {
            return this._parent.getGlobalType(name63);
        }
        return cmd;
    }
    getCompletions() {
        return this.getGlobalCompletions().concat(this.getBaseCompletions());
    }
    getBaseCompletions() {
        return Array.from(this.completions.values());
    }
    getGlobalCompletions() {
        const getCompletions = (cmd, completions = [], names = [])=>{
            if (cmd) {
                if (cmd.completions.size) {
                    cmd.completions.forEach((completion)=>{
                        if (completion.global && !this.completions.has(completion.name) && names.indexOf(completion.name) === -1) {
                            names.push(completion.name);
                            completions.push(completion);
                        }
                    });
                }
                return getCompletions(cmd._parent, completions, names);
            }
            return completions;
        };
        return getCompletions(this._parent);
    }
    getCompletion(name64) {
        return this.getBaseCompletion(name64) ?? this.getGlobalCompletion(name64);
    }
    getBaseCompletion(name65) {
        return this.completions.get(name65);
    }
    getGlobalCompletion(name66) {
        if (!this._parent) {
            return;
        }
        const completion = this._parent.getBaseCompletion(name66);
        if (!completion?.global) {
            return this._parent.getGlobalCompletion(name66);
        }
        return completion;
    }
    hasEnvVars(hidden17) {
        return this.getEnvVars(hidden17).length > 0;
    }
    getEnvVars(hidden18) {
        return this.getGlobalEnvVars(hidden18).concat(this.getBaseEnvVars(hidden18));
    }
    getBaseEnvVars(hidden19) {
        if (!this.envVars.length) {
            return [];
        }
        return hidden19 ? this.envVars.slice(0) : this.envVars.filter((env)=>!env.hidden
        );
    }
    getGlobalEnvVars(hidden20) {
        const getEnvVars = (cmd, envVars = [], names = [])=>{
            if (cmd) {
                if (cmd.envVars.length) {
                    cmd.envVars.forEach((envVar)=>{
                        if (envVar.global && !this.envVars.find((env)=>env.names[0] === envVar.names[0]
                        ) && names.indexOf(envVar.names[0]) === -1 && (hidden20 || !envVar.hidden)) {
                            names.push(envVar.names[0]);
                            envVars.push(envVar);
                        }
                    });
                }
                return getEnvVars(cmd._parent, envVars, names);
            }
            return envVars;
        };
        return getEnvVars(this._parent);
    }
    hasEnvVar(name67, hidden21) {
        return !!this.getEnvVar(name67, hidden21);
    }
    getEnvVar(name68, hidden22) {
        return this.getBaseEnvVar(name68, hidden22) ?? this.getGlobalEnvVar(name68, hidden22);
    }
    getBaseEnvVar(name69, hidden23) {
        const envVar = this.envVars.find((env)=>env.names.indexOf(name69) !== -1
        );
        return envVar && (hidden23 || !envVar.hidden) ? envVar : undefined;
    }
    getGlobalEnvVar(name70, hidden24) {
        if (!this._parent) {
            return;
        }
        const envVar = this._parent.getBaseEnvVar(name70, hidden24);
        if (!envVar?.global) {
            return this._parent.getGlobalEnvVar(name70, hidden24);
        }
        return envVar;
    }
    hasExamples() {
        return this.examples.length > 0;
    }
    getExamples() {
        return this.examples;
    }
    hasExample(name71) {
        return !!this.getExample(name71);
    }
    getExample(name72) {
        return this.examples.find((example)=>example.name === name72
        );
    }
}
function isUpgradeCommand(command) {
    return command instanceof Command && "getLatestVersion" in command;
}
class BashCompletionsGenerator {
    static generate(cmd) {
        return new BashCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
    }
    generate() {
        const path4 = this.cmd.getPath();
        const version3 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env bash
# bash completion support for ${path4}${version3}

_${replaceSpecialChars(path4)}() {
  local word cur prev listFiles
  local -a opts
  COMPREPLY=()
  cur="\${COMP_WORDS[COMP_CWORD]}"
  prev="\${COMP_WORDS[COMP_CWORD-1]}"
  cmd="_"
  opts=()
  listFiles=0

  _${replaceSpecialChars(this.cmd.getName())}_complete() {
    local action="$1"; shift
    mapfile -t values < <( ${this.cmd.getName()} completions complete "\${action}" "\${@}" )
    for i in "\${values[@]}"; do
      opts+=("$i")
    done
  }

  _${replaceSpecialChars(this.cmd.getName())}_expand() {
    [ "$cur" != "\${cur%\\\\}" ] && cur="$cur\\\\"
  
    # expand ~username type directory specifications
    if [[ "$cur" == \\~*/* ]]; then
      eval cur=$cur
      
    elif [[ "$cur" == \\~* ]]; then
      cur=\${cur#\\~}
      COMPREPLY=( $( compgen -P '~' -u $cur ) )
      return \${#COMPREPLY[@]}
    fi
  }

  _${replaceSpecialChars(this.cmd.getName())}_file_dir() {
    listFiles=1
    local IFS=$'\\t\\n' xspec #glob
    _${replaceSpecialChars(this.cmd.getName())}_expand || return 0
  
    if [ "\${1:-}" = -d ]; then
      COMPREPLY=( \${COMPREPLY[@]:-} $( compgen -d -- $cur ) )
      #eval "$glob"    # restore glob setting.
      return 0
    fi
  
    xspec=\${1:+"!*.$1"}	# set only if glob passed in as $1
    COMPREPLY=( \${COMPREPLY[@]:-} $( compgen -f -X "$xspec" -- "$cur" ) \
          $( compgen -d -- "$cur" ) )
  }

  ${this.generateCompletions(this.cmd).trim()}

  for word in "\${COMP_WORDS[@]}"; do
    case "\${word}" in
      -*) ;;
      *)
        cmd_tmp="\${cmd}_\${word//[^[:alnum:]]/_}"
        if type "\${cmd_tmp}" &>/dev/null; then
          cmd="\${cmd_tmp}"
        fi
    esac
  done

  \${cmd}

  if [[ listFiles -eq 1 ]]; then
    return 0
  fi

  if [[ \${#opts[@]} -eq 0 ]]; then
    # shellcheck disable=SC2207
    COMPREPLY=($(compgen -f "\${cur}"))
    return 0
  fi

  local values
  values="$( printf "\\n%s" "\${opts[@]}" )"
  local IFS=$'\\n'
  # shellcheck disable=SC2207
  local result=($(compgen -W "\${values[@]}" -- "\${cur}"))
  if [[ \${#result[@]} -eq 0 ]]; then
    # shellcheck disable=SC2207
    COMPREPLY=($(compgen -f "\${cur}"))
  else
    # shellcheck disable=SC2207
    COMPREPLY=($(printf '%q\\n' "\${result[@]}"))
  fi

  return 0
}

complete -F _${replaceSpecialChars(path4)} -o bashdefault -o default ${path4}`;
    }
    generateCompletions(command, path5 = "", index = 1) {
        path5 = (path5 ? path5 + " " : "") + command.getName();
        const commandCompletions = this.generateCommandCompletions(command, path5, index);
        const childCommandCompletions = command.getCommands(false).filter((subCommand)=>subCommand !== command
        ).map((subCommand)=>this.generateCompletions(subCommand, path5, index + 1)
        ).join("");
        return `${commandCompletions}

${childCommandCompletions}`;
    }
    generateCommandCompletions(command, path6, index) {
        const flags = this.getFlags(command);
        const childCommandNames = command.getCommands(false).map((childCommand)=>childCommand.getName()
        );
        const completionsPath = ~path6.indexOf(" ") ? " " + path6.split(" ").slice(1).join(" ") : "";
        const optionArguments = this.generateOptionArguments(command, completionsPath);
        const completionsCmd = this.generateCommandCompletionsCommand(command, completionsPath);
        return `  __${replaceSpecialChars(path6)}() {
    opts=(${[
            ...flags,
            ...childCommandNames
        ].join(" ")})
    ${completionsCmd}
    if [[ \${cur} == -* || \${COMP_CWORD} -eq ${index} ]] ; then
      return 0
    fi
    ${optionArguments}
  }`;
    }
    getFlags(command) {
        return command.getOptions(false).map((option)=>option.flags
        ).flat();
    }
    generateOptionArguments(command, completionsPath) {
        let opts = "";
        const options = command.getOptions(false);
        if (options.length) {
            opts += 'case "${prev}" in';
            for (const option of options){
                const flags = option.flags.map((flag)=>flag.trim()
                ).join("|");
                const completionsCmd = this.generateOptionCompletionsCommand(command, option.args, completionsPath, {
                    standalone: option.standalone
                });
                opts += `\n      ${flags}) ${completionsCmd} ;;`;
            }
            opts += "\n    esac";
        }
        return opts;
    }
    generateCommandCompletionsCommand(command, path7) {
        const args = command.getArguments();
        if (args.length) {
            const type19 = command.getType(args[0].type);
            if (type19 && type19.handler instanceof FileType) {
                return `_${replaceSpecialChars(this.cmd.getName())}_file_dir`;
            }
            return `_${replaceSpecialChars(this.cmd.getName())}_complete ${args[0].action}${path7}`;
        }
        return "";
    }
    generateOptionCompletionsCommand(command, args, path8, opts) {
        if (args.length) {
            const type20 = command.getType(args[0].type);
            if (type20 && type20.handler instanceof FileType) {
                return `opts=(); _${replaceSpecialChars(this.cmd.getName())}_file_dir`;
            }
            return `opts=(); _${replaceSpecialChars(this.cmd.getName())}_complete ${args[0].action}${path8}`;
        }
        if (opts?.standalone) {
            return "opts=()";
        }
        return "";
    }
    cmd;
}
function replaceSpecialChars(str55) {
    return str55.replace(/[^a-zA-Z0-9]/g, "_");
}
class BashCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        return this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for bash.

To enable bash completions for this program add following line to your ${dim(italic("~/.bashrc"))}:

    ${dim(italic(`source <(${baseCmd.getPath()} completions bash)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            console.log(BashCompletionsGenerator.generate(baseCmd));
        });
    }
}
class CompleteCommand extends Command {
    constructor(cmd1){
        super();
        return this.description("Get completions for given action from given command.").arguments("<action:string> [command...:string]").action(async (_, action, commandNames)=>{
            let parent;
            const completeCommand = commandNames?.reduce((cmd, name73)=>{
                parent = cmd;
                const childCmd = cmd.getCommand(name73, false);
                if (!childCmd) {
                    throw new UnknownCompletionCommand(name73, cmd.getCommands());
                }
                return childCmd;
            }, cmd1 || this.getMainCommand()) ?? (cmd1 || this.getMainCommand());
            const completion = completeCommand.getCompletion(action);
            const result = await completion?.complete(completeCommand, parent) ?? [];
            if (result?.length) {
                Deno.stdout.writeSync(new TextEncoder().encode(result.join("\n")));
            }
        }).reset();
    }
}
class FishCompletionsGenerator {
    static generate(cmd) {
        return new FishCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
    }
    generate() {
        const path9 = this.cmd.getPath();
        const version4 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env fish
# fish completion support for ${path9}${version4}

function __fish_${replaceSpecialChars1(this.cmd.getName())}_using_command
  set cmds ${getCommandFnNames(this.cmd).join(" ")}
  set words (commandline -opc)
  set cmd "_"
  for word in $words
    switch $word
      case '-*'
        continue
      case '*'
        set word (string replace -r -a '\\W' '_' $word)
        set cmd_tmp $cmd"_$word"
        if contains $cmd_tmp $cmds
          set cmd $cmd_tmp
        end
    end
  end
  if [ "$cmd" = "$argv[1]" ]
    return 0
  end
  return 1
end

${this.generateCompletions(this.cmd).trim()}`;
    }
    generateCompletions(command) {
        const parent = command.getParent();
        let result = ``;
        if (parent) {
            result += "\n" + this.complete(parent, {
                description: command.getShortDescription(),
                arguments: command.getName()
            });
        }
        const commandArgs = command.getArguments();
        if (commandArgs.length) {
            result += "\n" + this.complete(command, {
                arguments: commandArgs.length ? this.getCompletionCommand(command, commandArgs[0]) : undefined
            });
        }
        for (const option of command.getOptions(false)){
            result += "\n" + this.completeOption(command, option);
        }
        for (const subCommand of command.getCommands(false)){
            result += this.generateCompletions(subCommand);
        }
        return result;
    }
    completeOption(command, option) {
        const shortOption = option.flags.find((flag)=>flag.length === 2
        )?.replace(/^(-)+/, "");
        const longOption = option.flags.find((flag)=>flag.length > 2
        )?.replace(/^(-)+/, "");
        return this.complete(command, {
            description: getDescription(option.description),
            shortOption: shortOption,
            longOption: longOption,
            required: true,
            standalone: option.standalone,
            arguments: option.args.length ? this.getCompletionCommand(command, option.args[0]) : undefined
        });
    }
    complete(command, options) {
        const cmd = [
            "complete"
        ];
        cmd.push("-c", this.cmd.getName());
        cmd.push("-n", `'__fish_${replaceSpecialChars1(this.cmd.getName())}_using_command __${replaceSpecialChars1(command.getPath())}'`);
        options.shortOption && cmd.push("-s", options.shortOption);
        options.longOption && cmd.push("-l", options.longOption);
        options.standalone && cmd.push("-x");
        cmd.push("-k");
        cmd.push("-f");
        if (options.arguments) {
            options.required && cmd.push("-r");
            cmd.push("-a", options.arguments);
        }
        options.description && cmd.push("-d", `'${getDescription(options.description, true)}'`);
        return cmd.join(" ");
    }
    getCompletionCommand(cmd, arg) {
        const type21 = cmd.getType(arg.type);
        if (type21 && type21.handler instanceof FileType) {
            return `'(__fish_complete_path)'`;
        }
        return `'(${this.cmd.getName()} completions complete ${arg.action + " " + getCompletionsPath(cmd)})'`;
    }
    cmd;
}
function getCommandFnNames(cmd, cmds = []) {
    cmds.push(`__${replaceSpecialChars1(cmd.getPath())}`);
    cmd.getCommands(false).forEach((command)=>{
        getCommandFnNames(command, cmds);
    });
    return cmds;
}
function getCompletionsPath(command) {
    return command.getPath().split(" ").slice(1).join(" ");
}
function replaceSpecialChars1(str56) {
    return str56.replace(/[^a-zA-Z0-9]/g, "_");
}
class FishCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        return this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for fish.

To enable fish completions for this program add following line to your ${dim(italic("~/.config/fish/config.fish"))}:

    ${dim(italic(`source (${baseCmd.getPath()} completions fish | psub)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            console.log(FishCompletionsGenerator.generate(baseCmd));
        });
    }
}
class ZshCompletionsGenerator {
    actions;
    static generate(cmd) {
        return new ZshCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
        this.actions = new Map();
    }
    generate() {
        const path10 = this.cmd.getPath();
        const name74 = this.cmd.getName();
        const version5 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env zsh
# zsh completion support for ${path10}${version5}

autoload -U is-at-least

# shellcheck disable=SC2154
(( $+functions[__${replaceSpecialChars2(name74)}_complete] )) ||
function __${replaceSpecialChars2(name74)}_complete {
  local name="$1"; shift
  local action="$1"; shift
  integer ret=1
  local -a values
  local expl lines
  _tags "$name"
  while _tags; do
    if _requested "$name"; then
      # shellcheck disable=SC2034
      lines="$(${name74} completions complete "\${action}" "\${@}")"
      values=("\${(ps:\\n:)lines}")
      if (( \${#values[@]} )); then
        while _next_label "$name" expl "$action"; do
          compadd -S '' "\${expl[@]}" "\${values[@]}"
        done
      fi
    fi
  done
}

${this.generateCompletions(this.cmd).trim()}

# _${replaceSpecialChars2(path10)} "\${@}"

compdef _${replaceSpecialChars2(path10)} ${path10}`;
    }
    generateCompletions(command, path11 = "") {
        if (!command.hasCommands(false) && !command.hasOptions(false) && !command.hasArguments()) {
            return "";
        }
        path11 = (path11 ? path11 + " " : "") + command.getName();
        return `# shellcheck disable=SC2154
(( $+functions[_${replaceSpecialChars2(path11)}] )) ||
function _${replaceSpecialChars2(path11)}() {` + (!command.getParent() ? `
  local state` : "") + this.generateCommandCompletions(command, path11) + this.generateSubCommandCompletions(command, path11) + this.generateArgumentCompletions(command, path11) + this.generateActions(command) + `\n}\n\n` + command.getCommands(false).filter((subCommand)=>subCommand !== command
        ).map((subCommand)=>this.generateCompletions(subCommand, path11)
        ).join("");
    }
    generateCommandCompletions(command, path12) {
        const commands9 = command.getCommands(false);
        let completions = commands9.map((subCommand)=>`'${subCommand.getName()}:${subCommand.getShortDescription()}'`
        ).join("\n      ");
        if (completions) {
            completions = `
    local -a commands
    # shellcheck disable=SC2034
    commands=(
      ${completions}
    )
    _describe 'command' commands`;
        }
        if (command.hasArguments()) {
            const completionsPath = path12.split(" ").slice(1).join(" ");
            const arg = command.getArguments()[0];
            const action = this.addAction(arg, completionsPath);
            if (action && command.getCompletion(arg.action)) {
                completions += `\n    __${replaceSpecialChars2(this.cmd.getName())}_complete ${action.arg.name} ${action.arg.action} ${action.cmd}`;
            }
        }
        if (completions) {
            completions = `\n\n  function _commands() {${completions}\n  }`;
        }
        return completions;
    }
    generateSubCommandCompletions(command1, path13) {
        if (command1.hasCommands(false)) {
            const actions = command1.getCommands(false).map((command)=>`${command.getName()}) _${replaceSpecialChars2(path13 + " " + command.getName())} ;;`
            ).join("\n      ");
            return `\n
  function _command_args() {
    case "\${words[1]}" in\n      ${actions}\n    esac
  }`;
        }
        return "";
    }
    generateArgumentCompletions(command, path14) {
        this.actions.clear();
        const options = this.generateOptions(command, path14);
        let argIndex = 0;
        let argsCommand = "\n\n  _arguments -w -s -S -C";
        if (command.hasOptions()) {
            argsCommand += ` \\\n    ${options.join(" \\\n    ")}`;
        }
        if (command.hasCommands(false) || command.getArguments().filter((arg)=>command.getCompletion(arg.action)
        ).length) {
            argsCommand += ` \\\n    '${++argIndex}:command:_commands'`;
        }
        if (command.hasArguments() || command.hasCommands(false)) {
            const args = [];
            for (const arg1 of command.getArguments().slice(1)){
                const type22 = command.getType(arg1.type);
                if (type22 && type22.handler instanceof FileType) {
                    const fileCompletions = this.getFileCompletions(type22);
                    if (arg1.variadic) {
                        argIndex++;
                        for(let i12 = 0; i12 < 5; i12++){
                            args.push(`${argIndex + i12}${arg1.optionalValue ? "::" : ":"}${arg1.name}:${fileCompletions}`);
                        }
                    } else {
                        args.push(`${++argIndex}${arg1.optionalValue ? "::" : ":"}${arg1.name}:${fileCompletions}`);
                    }
                } else {
                    const completionsPath = path14.split(" ").slice(1).join(" ");
                    const action = this.addAction(arg1, completionsPath);
                    args.push(`${++argIndex}${arg1.optionalValue ? "::" : ":"}${arg1.name}:->${action.name}`);
                }
            }
            argsCommand += args.map((arg)=>`\\\n    '${arg}'`
            ).join("");
            if (command.hasCommands(false)) {
                argsCommand += ` \\\n    '*::sub command:->command_args'`;
            }
        }
        return argsCommand;
    }
    generateOptions(command, path15) {
        const options = [];
        const cmdArgs = path15.split(" ");
        cmdArgs.shift();
        const completionsPath = cmdArgs.join(" ");
        const excludedFlags = command.getOptions(false).map((option)=>option.standalone ? option.flags : false
        ).flat().filter((flag)=>typeof flag === "string"
        );
        for (const option1 of command.getOptions(false)){
            options.push(this.generateOption(command, option1, completionsPath, excludedFlags));
        }
        return options;
    }
    generateOption(command, option, completionsPath, excludedOptions) {
        let excludedFlags = option.conflicts?.length ? [
            ...excludedOptions,
            ...option.conflicts.map((opt)=>"--" + opt.replace(/^--/, "")
            ), 
        ] : excludedOptions;
        excludedFlags = option.collect ? excludedFlags : [
            ...excludedFlags,
            ...option.flags, 
        ];
        let args = "";
        for (const arg of option.args){
            const type23 = command.getType(arg.type);
            if (type23 && type23.handler instanceof FileType) {
                const fileCompletions = this.getFileCompletions(type23);
                args += `${arg.optionalValue ? "::" : ":"}${arg.name}:${fileCompletions}`;
            } else {
                const action = this.addAction(arg, completionsPath);
                args += `${arg.optionalValue ? "::" : ":"}${arg.name}:->${action.name}`;
            }
        }
        const description = getDescription(option.description, true).replace(/\[/g, "\\[").replace(/]/g, "\\]").replace(/"/g, '\\"').replace(/'/g, "'\"'\"'");
        const collect = option.collect ? "*" : "";
        const equalsSign = option.equalsSign ? "=" : "";
        const flags = option.flags.map((flag)=>`${flag}${equalsSign}`
        ).join(",");
        if (option.standalone) {
            return `'(- *)'{${collect}${flags}}'[${description}]${args}'`;
        } else {
            const excluded = excludedFlags.length ? `'(${excludedFlags.join(" ")})'` : "";
            if (collect || flags.length > 1) {
                return `${excluded}{${collect}${flags}}'[${description}]${args}'`;
            } else {
                return `${excluded}${flags}'[${description}]${args}'`;
            }
        }
    }
    getFileCompletions(type24) {
        if (!(type24.handler instanceof FileType)) {
            return "";
        }
        return "_files";
    }
    addAction(arg, cmd) {
        const action = `${arg.name}-${arg.action}`;
        if (!this.actions.has(action)) {
            this.actions.set(action, {
                arg: arg,
                label: `${arg.name}: ${arg.action}`,
                name: action,
                cmd
            });
        }
        return this.actions.get(action);
    }
    generateActions(command) {
        let actions = [];
        if (this.actions.size) {
            actions = Array.from(this.actions).map(([name75, action])=>`${name75}) __${replaceSpecialChars2(this.cmd.getName())}_complete ${action.arg.name} ${action.arg.action} ${action.cmd} ;;`
            );
        }
        if (command.hasCommands(false)) {
            actions.unshift(`command_args) _command_args ;;`);
        }
        if (actions.length) {
            return `\n\n  case "$state" in\n    ${actions.join("\n    ")}\n  esac`;
        }
        return "";
    }
    cmd;
}
function replaceSpecialChars2(str57) {
    return str57.replace(/[^a-zA-Z0-9]/g, "_");
}
class ZshCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        return this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for zsh.

To enable zsh completions for this program add following line to your ${dim(italic("~/.zshrc"))}:

    ${dim(italic(`source <(${baseCmd.getPath()} completions zsh)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            console.log(ZshCompletionsGenerator.generate(baseCmd));
        });
    }
}
class CompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        return this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions.

To enable shell completions for this program add the following line to your ${dim(italic("~/.bashrc"))} or similar:

    ${dim(italic(`source <(${baseCmd.getPath()} completions [shell])`))}

    For more information run ${dim(italic(`${baseCmd.getPath()} completions [shell] --help`))}
`;
        }).action(()=>this.showHelp()
        ).command("bash", new BashCompletionsCommand(this.#cmd)).command("fish", new FishCompletionsCommand(this.#cmd)).command("zsh", new ZshCompletionsCommand(this.#cmd)).command("complete", new CompleteCommand(this.#cmd).hidden()).reset();
    }
}
class CommandType extends StringType {
    complete(_cmd, parent) {
        return parent?.getCommands(false).map((cmd)=>cmd.getName()
        ) || [];
    }
}
class HelpCommand extends Command {
    constructor(cmd){
        super();
        return this.type("command", new CommandType()).arguments("[command:command]").description("Show this help or the help of a sub-command.").action(async (_, name76)=>{
            if (!cmd) {
                cmd = name76 ? this.getGlobalParent()?.getBaseCommand(name76) : this.getGlobalParent();
            }
            if (!cmd) {
                const cmds = this.getGlobalParent()?.getCommands();
                throw new UnknownCommand(name76 ?? "", cmds ?? [], [
                    this.getName(),
                    ...this.getAliases(), 
                ]);
            }
            await cmd.checkVersion();
            cmd.showHelp();
            Deno.exit(0);
        });
    }
}
const osType = (()=>{
    const { Deno  } = globalThis;
    if (typeof Deno?.build?.os === "string") {
        return Deno.build.os;
    }
    const { navigator  } = globalThis;
    if (navigator?.appVersion?.includes?.("Win") ?? false) {
        return "windows";
    }
    return "linux";
})();
const isWindows = osType === "windows";
const CHAR_FORWARD_SLASH = 47;
function assertPath(path16) {
    if (typeof path16 !== "string") {
        throw new TypeError(`Path must be a string. Received ${JSON.stringify(path16)}`);
    }
}
function isPosixPathSeparator(code3) {
    return code3 === 47;
}
function isPathSeparator(code4) {
    return isPosixPathSeparator(code4) || code4 === 92;
}
function isWindowsDeviceRoot(code5) {
    return code5 >= 97 && code5 <= 122 || code5 >= 65 && code5 <= 90;
}
function normalizeString(path17, allowAboveRoot, separator, isPathSeparator1) {
    let res = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code6;
    for(let i13 = 0, len = path17.length; i13 <= len; ++i13){
        if (i13 < len) code6 = path17.charCodeAt(i13);
        else if (isPathSeparator1(code6)) break;
        else code6 = CHAR_FORWARD_SLASH;
        if (isPathSeparator1(code6)) {
            if (lastSlash === i13 - 1 || dots === 1) {} else if (lastSlash !== i13 - 1 && dots === 2) {
                if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
                    if (res.length > 2) {
                        const lastSlashIndex = res.lastIndexOf(separator);
                        if (lastSlashIndex === -1) {
                            res = "";
                            lastSegmentLength = 0;
                        } else {
                            res = res.slice(0, lastSlashIndex);
                            lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
                        }
                        lastSlash = i13;
                        dots = 0;
                        continue;
                    } else if (res.length === 2 || res.length === 1) {
                        res = "";
                        lastSegmentLength = 0;
                        lastSlash = i13;
                        dots = 0;
                        continue;
                    }
                }
                if (allowAboveRoot) {
                    if (res.length > 0) res += `${separator}..`;
                    else res = "..";
                    lastSegmentLength = 2;
                }
            } else {
                if (res.length > 0) res += separator + path17.slice(lastSlash + 1, i13);
                else res = path17.slice(lastSlash + 1, i13);
                lastSegmentLength = i13 - lastSlash - 1;
            }
            lastSlash = i13;
            dots = 0;
        } else if (code6 === 46 && dots !== -1) {
            ++dots;
        } else {
            dots = -1;
        }
    }
    return res;
}
function _format(sep7, pathObject) {
    const dir = pathObject.dir || pathObject.root;
    const base2 = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
    if (!dir) return base2;
    if (dir === pathObject.root) return dir + base2;
    return dir + sep7 + base2;
}
const WHITESPACE_ENCODINGS = {
    "\u0009": "%09",
    "\u000A": "%0A",
    "\u000B": "%0B",
    "\u000C": "%0C",
    "\u000D": "%0D",
    "\u0020": "%20"
};
function encodeWhitespace(string3) {
    return string3.replaceAll(/[\s]/g, (c)=>{
        return WHITESPACE_ENCODINGS[c] ?? c;
    });
}
class DenoStdInternalError extends Error {
    constructor(message){
        super(message);
        this.name = "DenoStdInternalError";
    }
}
function assert(expr, msg = "") {
    if (!expr) {
        throw new DenoStdInternalError(msg);
    }
}
const sep = "\\";
const delimiter = ";";
function resolve(...pathSegments) {
    let resolvedDevice = "";
    let resolvedTail = "";
    let resolvedAbsolute = false;
    for(let i14 = pathSegments.length - 1; i14 >= -1; i14--){
        let path18;
        const { Deno  } = globalThis;
        if (i14 >= 0) {
            path18 = pathSegments[i14];
        } else if (!resolvedDevice) {
            if (typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a drive-letter-less path without a CWD.");
            }
            path18 = Deno.cwd();
        } else {
            if (typeof Deno?.env?.get !== "function" || typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a relative path without a CWD.");
            }
            path18 = Deno.cwd();
            if (path18 === undefined || path18.slice(0, 3).toLowerCase() !== `${resolvedDevice.toLowerCase()}\\`) {
                path18 = `${resolvedDevice}\\`;
            }
        }
        assertPath(path18);
        const len = path18.length;
        if (len === 0) continue;
        let rootEnd = 0;
        let device = "";
        let isAbsolute1 = false;
        const code7 = path18.charCodeAt(0);
        if (len > 1) {
            if (isPathSeparator(code7)) {
                isAbsolute1 = true;
                if (isPathSeparator(path18.charCodeAt(1))) {
                    let j = 2;
                    let last = j;
                    for(; j < len; ++j){
                        if (isPathSeparator(path18.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        const firstPart = path18.slice(last, j);
                        last = j;
                        for(; j < len; ++j){
                            if (!isPathSeparator(path18.charCodeAt(j))) break;
                        }
                        if (j < len && j !== last) {
                            last = j;
                            for(; j < len; ++j){
                                if (isPathSeparator(path18.charCodeAt(j))) break;
                            }
                            if (j === len) {
                                device = `\\\\${firstPart}\\${path18.slice(last)}`;
                                rootEnd = j;
                            } else if (j !== last) {
                                device = `\\\\${firstPart}\\${path18.slice(last, j)}`;
                                rootEnd = j;
                            }
                        }
                    }
                } else {
                    rootEnd = 1;
                }
            } else if (isWindowsDeviceRoot(code7)) {
                if (path18.charCodeAt(1) === 58) {
                    device = path18.slice(0, 2);
                    rootEnd = 2;
                    if (len > 2) {
                        if (isPathSeparator(path18.charCodeAt(2))) {
                            isAbsolute1 = true;
                            rootEnd = 3;
                        }
                    }
                }
            }
        } else if (isPathSeparator(code7)) {
            rootEnd = 1;
            isAbsolute1 = true;
        }
        if (device.length > 0 && resolvedDevice.length > 0 && device.toLowerCase() !== resolvedDevice.toLowerCase()) {
            continue;
        }
        if (resolvedDevice.length === 0 && device.length > 0) {
            resolvedDevice = device;
        }
        if (!resolvedAbsolute) {
            resolvedTail = `${path18.slice(rootEnd)}\\${resolvedTail}`;
            resolvedAbsolute = isAbsolute1;
        }
        if (resolvedAbsolute && resolvedDevice.length > 0) break;
    }
    resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
    return resolvedDevice + (resolvedAbsolute ? "\\" : "") + resolvedTail || ".";
}
function normalize(path19) {
    assertPath(path19);
    const len = path19.length;
    if (len === 0) return ".";
    let rootEnd = 0;
    let device;
    let isAbsolute2 = false;
    const code8 = path19.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code8)) {
            isAbsolute2 = true;
            if (isPathSeparator(path19.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path19.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    const firstPart = path19.slice(last, j);
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path19.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path19.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            return `\\\\${firstPart}\\${path19.slice(last)}\\`;
                        } else if (j !== last) {
                            device = `\\\\${firstPart}\\${path19.slice(last, j)}`;
                            rootEnd = j;
                        }
                    }
                }
            } else {
                rootEnd = 1;
            }
        } else if (isWindowsDeviceRoot(code8)) {
            if (path19.charCodeAt(1) === 58) {
                device = path19.slice(0, 2);
                rootEnd = 2;
                if (len > 2) {
                    if (isPathSeparator(path19.charCodeAt(2))) {
                        isAbsolute2 = true;
                        rootEnd = 3;
                    }
                }
            }
        }
    } else if (isPathSeparator(code8)) {
        return "\\";
    }
    let tail;
    if (rootEnd < len) {
        tail = normalizeString(path19.slice(rootEnd), !isAbsolute2, "\\", isPathSeparator);
    } else {
        tail = "";
    }
    if (tail.length === 0 && !isAbsolute2) tail = ".";
    if (tail.length > 0 && isPathSeparator(path19.charCodeAt(len - 1))) {
        tail += "\\";
    }
    if (device === undefined) {
        if (isAbsolute2) {
            if (tail.length > 0) return `\\${tail}`;
            else return "\\";
        } else if (tail.length > 0) {
            return tail;
        } else {
            return "";
        }
    } else if (isAbsolute2) {
        if (tail.length > 0) return `${device}\\${tail}`;
        else return `${device}\\`;
    } else if (tail.length > 0) {
        return device + tail;
    } else {
        return device;
    }
}
function isAbsolute(path20) {
    assertPath(path20);
    const len = path20.length;
    if (len === 0) return false;
    const code9 = path20.charCodeAt(0);
    if (isPathSeparator(code9)) {
        return true;
    } else if (isWindowsDeviceRoot(code9)) {
        if (len > 2 && path20.charCodeAt(1) === 58) {
            if (isPathSeparator(path20.charCodeAt(2))) return true;
        }
    }
    return false;
}
function join(...paths) {
    const pathsCount = paths.length;
    if (pathsCount === 0) return ".";
    let joined;
    let firstPart = null;
    for(let i15 = 0; i15 < pathsCount; ++i15){
        const path21 = paths[i15];
        assertPath(path21);
        if (path21.length > 0) {
            if (joined === undefined) joined = firstPart = path21;
            else joined += `\\${path21}`;
        }
    }
    if (joined === undefined) return ".";
    let needsReplace = true;
    let slashCount = 0;
    assert(firstPart != null);
    if (isPathSeparator(firstPart.charCodeAt(0))) {
        ++slashCount;
        const firstLen = firstPart.length;
        if (firstLen > 1) {
            if (isPathSeparator(firstPart.charCodeAt(1))) {
                ++slashCount;
                if (firstLen > 2) {
                    if (isPathSeparator(firstPart.charCodeAt(2))) ++slashCount;
                    else {
                        needsReplace = false;
                    }
                }
            }
        }
    }
    if (needsReplace) {
        for(; slashCount < joined.length; ++slashCount){
            if (!isPathSeparator(joined.charCodeAt(slashCount))) break;
        }
        if (slashCount >= 2) joined = `\\${joined.slice(slashCount)}`;
    }
    return normalize(joined);
}
function relative(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return "";
    const fromOrig = resolve(from);
    const toOrig = resolve(to);
    if (fromOrig === toOrig) return "";
    from = fromOrig.toLowerCase();
    to = toOrig.toLowerCase();
    if (from === to) return "";
    let fromStart = 0;
    let fromEnd = from.length;
    for(; fromStart < fromEnd; ++fromStart){
        if (from.charCodeAt(fromStart) !== 92) break;
    }
    for(; fromEnd - 1 > fromStart; --fromEnd){
        if (from.charCodeAt(fromEnd - 1) !== 92) break;
    }
    const fromLen = fromEnd - fromStart;
    let toStart = 0;
    let toEnd = to.length;
    for(; toStart < toEnd; ++toStart){
        if (to.charCodeAt(toStart) !== 92) break;
    }
    for(; toEnd - 1 > toStart; --toEnd){
        if (to.charCodeAt(toEnd - 1) !== 92) break;
    }
    const toLen = toEnd - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i16 = 0;
    for(; i16 <= length; ++i16){
        if (i16 === length) {
            if (toLen > length) {
                if (to.charCodeAt(toStart + i16) === 92) {
                    return toOrig.slice(toStart + i16 + 1);
                } else if (i16 === 2) {
                    return toOrig.slice(toStart + i16);
                }
            }
            if (fromLen > length) {
                if (from.charCodeAt(fromStart + i16) === 92) {
                    lastCommonSep = i16;
                } else if (i16 === 2) {
                    lastCommonSep = 3;
                }
            }
            break;
        }
        const fromCode = from.charCodeAt(fromStart + i16);
        const toCode = to.charCodeAt(toStart + i16);
        if (fromCode !== toCode) break;
        else if (fromCode === 92) lastCommonSep = i16;
    }
    if (i16 !== length && lastCommonSep === -1) {
        return toOrig;
    }
    let out = "";
    if (lastCommonSep === -1) lastCommonSep = 0;
    for(i16 = fromStart + lastCommonSep + 1; i16 <= fromEnd; ++i16){
        if (i16 === fromEnd || from.charCodeAt(i16) === 92) {
            if (out.length === 0) out += "..";
            else out += "\\..";
        }
    }
    if (out.length > 0) {
        return out + toOrig.slice(toStart + lastCommonSep, toEnd);
    } else {
        toStart += lastCommonSep;
        if (toOrig.charCodeAt(toStart) === 92) ++toStart;
        return toOrig.slice(toStart, toEnd);
    }
}
function toNamespacedPath(path22) {
    if (typeof path22 !== "string") return path22;
    if (path22.length === 0) return "";
    const resolvedPath = resolve(path22);
    if (resolvedPath.length >= 3) {
        if (resolvedPath.charCodeAt(0) === 92) {
            if (resolvedPath.charCodeAt(1) === 92) {
                const code10 = resolvedPath.charCodeAt(2);
                if (code10 !== 63 && code10 !== 46) {
                    return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
                }
            }
        } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0))) {
            if (resolvedPath.charCodeAt(1) === 58 && resolvedPath.charCodeAt(2) === 92) {
                return `\\\\?\\${resolvedPath}`;
            }
        }
    }
    return path22;
}
function dirname(path23) {
    assertPath(path23);
    const len = path23.length;
    if (len === 0) return ".";
    let rootEnd = -1;
    let end = -1;
    let matchedSlash = true;
    let offset = 0;
    const code11 = path23.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code11)) {
            rootEnd = offset = 1;
            if (isPathSeparator(path23.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path23.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path23.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path23.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            return path23;
                        }
                        if (j !== last) {
                            rootEnd = offset = j + 1;
                        }
                    }
                }
            }
        } else if (isWindowsDeviceRoot(code11)) {
            if (path23.charCodeAt(1) === 58) {
                rootEnd = offset = 2;
                if (len > 2) {
                    if (isPathSeparator(path23.charCodeAt(2))) rootEnd = offset = 3;
                }
            }
        }
    } else if (isPathSeparator(code11)) {
        return path23;
    }
    for(let i17 = len - 1; i17 >= offset; --i17){
        if (isPathSeparator(path23.charCodeAt(i17))) {
            if (!matchedSlash) {
                end = i17;
                break;
            }
        } else {
            matchedSlash = false;
        }
    }
    if (end === -1) {
        if (rootEnd === -1) return ".";
        else end = rootEnd;
    }
    return path23.slice(0, end);
}
function basename(path24, ext = "") {
    if (ext !== undefined && typeof ext !== "string") {
        throw new TypeError('"ext" argument must be a string');
    }
    assertPath(path24);
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i18;
    if (path24.length >= 2) {
        const drive = path24.charCodeAt(0);
        if (isWindowsDeviceRoot(drive)) {
            if (path24.charCodeAt(1) === 58) start = 2;
        }
    }
    if (ext !== undefined && ext.length > 0 && ext.length <= path24.length) {
        if (ext.length === path24.length && ext === path24) return "";
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for(i18 = path24.length - 1; i18 >= start; --i18){
            const code12 = path24.charCodeAt(i18);
            if (isPathSeparator(code12)) {
                if (!matchedSlash) {
                    start = i18 + 1;
                    break;
                }
            } else {
                if (firstNonSlashEnd === -1) {
                    matchedSlash = false;
                    firstNonSlashEnd = i18 + 1;
                }
                if (extIdx >= 0) {
                    if (code12 === ext.charCodeAt(extIdx)) {
                        if (--extIdx === -1) {
                            end = i18;
                        }
                    } else {
                        extIdx = -1;
                        end = firstNonSlashEnd;
                    }
                }
            }
        }
        if (start === end) end = firstNonSlashEnd;
        else if (end === -1) end = path24.length;
        return path24.slice(start, end);
    } else {
        for(i18 = path24.length - 1; i18 >= start; --i18){
            if (isPathSeparator(path24.charCodeAt(i18))) {
                if (!matchedSlash) {
                    start = i18 + 1;
                    break;
                }
            } else if (end === -1) {
                matchedSlash = false;
                end = i18 + 1;
            }
        }
        if (end === -1) return "";
        return path24.slice(start, end);
    }
}
function extname(path25) {
    assertPath(path25);
    let start = 0;
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    if (path25.length >= 2 && path25.charCodeAt(1) === 58 && isWindowsDeviceRoot(path25.charCodeAt(0))) {
        start = startPart = 2;
    }
    for(let i19 = path25.length - 1; i19 >= start; --i19){
        const code13 = path25.charCodeAt(i19);
        if (isPathSeparator(code13)) {
            if (!matchedSlash) {
                startPart = i19 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i19 + 1;
        }
        if (code13 === 46) {
            if (startDot === -1) startDot = i19;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
    }
    return path25.slice(startDot, end);
}
function format(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError(`The "pathObject" argument must be of type Object. Received type ${typeof pathObject}`);
    }
    return _format("\\", pathObject);
}
function parse(path26) {
    assertPath(path26);
    const ret = {
        root: "",
        dir: "",
        base: "",
        ext: "",
        name: ""
    };
    const len = path26.length;
    if (len === 0) return ret;
    let rootEnd = 0;
    let code14 = path26.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code14)) {
            rootEnd = 1;
            if (isPathSeparator(path26.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path26.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path26.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path26.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            rootEnd = j;
                        } else if (j !== last) {
                            rootEnd = j + 1;
                        }
                    }
                }
            }
        } else if (isWindowsDeviceRoot(code14)) {
            if (path26.charCodeAt(1) === 58) {
                rootEnd = 2;
                if (len > 2) {
                    if (isPathSeparator(path26.charCodeAt(2))) {
                        if (len === 3) {
                            ret.root = ret.dir = path26;
                            return ret;
                        }
                        rootEnd = 3;
                    }
                } else {
                    ret.root = ret.dir = path26;
                    return ret;
                }
            }
        }
    } else if (isPathSeparator(code14)) {
        ret.root = ret.dir = path26;
        return ret;
    }
    if (rootEnd > 0) ret.root = path26.slice(0, rootEnd);
    let startDot = -1;
    let startPart = rootEnd;
    let end = -1;
    let matchedSlash = true;
    let i20 = path26.length - 1;
    let preDotState = 0;
    for(; i20 >= rootEnd; --i20){
        code14 = path26.charCodeAt(i20);
        if (isPathSeparator(code14)) {
            if (!matchedSlash) {
                startPart = i20 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i20 + 1;
        }
        if (code14 === 46) {
            if (startDot === -1) startDot = i20;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
            ret.base = ret.name = path26.slice(startPart, end);
        }
    } else {
        ret.name = path26.slice(startPart, startDot);
        ret.base = path26.slice(startPart, end);
        ret.ext = path26.slice(startDot, end);
    }
    if (startPart > 0 && startPart !== rootEnd) {
        ret.dir = path26.slice(0, startPart - 1);
    } else ret.dir = ret.root;
    return ret;
}
function fromFileUrl(url) {
    url = url instanceof URL ? url : new URL(url);
    if (url.protocol != "file:") {
        throw new TypeError("Must be a file URL.");
    }
    let path27 = decodeURIComponent(url.pathname.replace(/\//g, "\\").replace(/%(?![0-9A-Fa-f]{2})/g, "%25")).replace(/^\\*([A-Za-z]:)(\\|$)/, "$1\\");
    if (url.hostname != "") {
        path27 = `\\\\${url.hostname}${path27}`;
    }
    return path27;
}
function toFileUrl(path28) {
    if (!isAbsolute(path28)) {
        throw new TypeError("Must be an absolute path.");
    }
    const [, hostname, pathname] = path28.match(/^(?:[/\\]{2}([^/\\]+)(?=[/\\](?:[^/\\]|$)))?(.*)/);
    const url = new URL("file:///");
    url.pathname = encodeWhitespace(pathname.replace(/%/g, "%25"));
    if (hostname != null && hostname != "localhost") {
        url.hostname = hostname;
        if (!url.hostname) {
            throw new TypeError("Invalid hostname.");
        }
    }
    return url;
}
const mod1 = {
    sep: sep,
    delimiter: delimiter,
    resolve: resolve,
    normalize: normalize,
    isAbsolute: isAbsolute,
    join: join,
    relative: relative,
    toNamespacedPath: toNamespacedPath,
    dirname: dirname,
    basename: basename,
    extname: extname,
    format: format,
    parse: parse,
    fromFileUrl: fromFileUrl,
    toFileUrl: toFileUrl
};
const sep1 = "/";
const delimiter1 = ":";
function resolve1(...pathSegments) {
    let resolvedPath = "";
    let resolvedAbsolute = false;
    for(let i21 = pathSegments.length - 1; i21 >= -1 && !resolvedAbsolute; i21--){
        let path29;
        if (i21 >= 0) path29 = pathSegments[i21];
        else {
            const { Deno  } = globalThis;
            if (typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a relative path without a CWD.");
            }
            path29 = Deno.cwd();
        }
        assertPath(path29);
        if (path29.length === 0) {
            continue;
        }
        resolvedPath = `${path29}/${resolvedPath}`;
        resolvedAbsolute = path29.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
    if (resolvedAbsolute) {
        if (resolvedPath.length > 0) return `/${resolvedPath}`;
        else return "/";
    } else if (resolvedPath.length > 0) return resolvedPath;
    else return ".";
}
function normalize1(path30) {
    assertPath(path30);
    if (path30.length === 0) return ".";
    const isAbsolute1 = path30.charCodeAt(0) === 47;
    const trailingSeparator = path30.charCodeAt(path30.length - 1) === 47;
    path30 = normalizeString(path30, !isAbsolute1, "/", isPosixPathSeparator);
    if (path30.length === 0 && !isAbsolute1) path30 = ".";
    if (path30.length > 0 && trailingSeparator) path30 += "/";
    if (isAbsolute1) return `/${path30}`;
    return path30;
}
function isAbsolute1(path31) {
    assertPath(path31);
    return path31.length > 0 && path31.charCodeAt(0) === 47;
}
function join1(...paths) {
    if (paths.length === 0) return ".";
    let joined;
    for(let i22 = 0, len = paths.length; i22 < len; ++i22){
        const path32 = paths[i22];
        assertPath(path32);
        if (path32.length > 0) {
            if (!joined) joined = path32;
            else joined += `/${path32}`;
        }
    }
    if (!joined) return ".";
    return normalize1(joined);
}
function relative1(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return "";
    from = resolve1(from);
    to = resolve1(to);
    if (from === to) return "";
    let fromStart = 1;
    const fromEnd = from.length;
    for(; fromStart < fromEnd; ++fromStart){
        if (from.charCodeAt(fromStart) !== 47) break;
    }
    const fromLen = fromEnd - fromStart;
    let toStart = 1;
    const toEnd = to.length;
    for(; toStart < toEnd; ++toStart){
        if (to.charCodeAt(toStart) !== 47) break;
    }
    const toLen = toEnd - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i23 = 0;
    for(; i23 <= length; ++i23){
        if (i23 === length) {
            if (toLen > length) {
                if (to.charCodeAt(toStart + i23) === 47) {
                    return to.slice(toStart + i23 + 1);
                } else if (i23 === 0) {
                    return to.slice(toStart + i23);
                }
            } else if (fromLen > length) {
                if (from.charCodeAt(fromStart + i23) === 47) {
                    lastCommonSep = i23;
                } else if (i23 === 0) {
                    lastCommonSep = 0;
                }
            }
            break;
        }
        const fromCode = from.charCodeAt(fromStart + i23);
        const toCode = to.charCodeAt(toStart + i23);
        if (fromCode !== toCode) break;
        else if (fromCode === 47) lastCommonSep = i23;
    }
    let out = "";
    for(i23 = fromStart + lastCommonSep + 1; i23 <= fromEnd; ++i23){
        if (i23 === fromEnd || from.charCodeAt(i23) === 47) {
            if (out.length === 0) out += "..";
            else out += "/..";
        }
    }
    if (out.length > 0) return out + to.slice(toStart + lastCommonSep);
    else {
        toStart += lastCommonSep;
        if (to.charCodeAt(toStart) === 47) ++toStart;
        return to.slice(toStart);
    }
}
function toNamespacedPath1(path33) {
    return path33;
}
function dirname1(path34) {
    assertPath(path34);
    if (path34.length === 0) return ".";
    const hasRoot = path34.charCodeAt(0) === 47;
    let end = -1;
    let matchedSlash = true;
    for(let i24 = path34.length - 1; i24 >= 1; --i24){
        if (path34.charCodeAt(i24) === 47) {
            if (!matchedSlash) {
                end = i24;
                break;
            }
        } else {
            matchedSlash = false;
        }
    }
    if (end === -1) return hasRoot ? "/" : ".";
    if (hasRoot && end === 1) return "//";
    return path34.slice(0, end);
}
function basename1(path35, ext = "") {
    if (ext !== undefined && typeof ext !== "string") {
        throw new TypeError('"ext" argument must be a string');
    }
    assertPath(path35);
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i25;
    if (ext !== undefined && ext.length > 0 && ext.length <= path35.length) {
        if (ext.length === path35.length && ext === path35) return "";
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for(i25 = path35.length - 1; i25 >= 0; --i25){
            const code15 = path35.charCodeAt(i25);
            if (code15 === 47) {
                if (!matchedSlash) {
                    start = i25 + 1;
                    break;
                }
            } else {
                if (firstNonSlashEnd === -1) {
                    matchedSlash = false;
                    firstNonSlashEnd = i25 + 1;
                }
                if (extIdx >= 0) {
                    if (code15 === ext.charCodeAt(extIdx)) {
                        if (--extIdx === -1) {
                            end = i25;
                        }
                    } else {
                        extIdx = -1;
                        end = firstNonSlashEnd;
                    }
                }
            }
        }
        if (start === end) end = firstNonSlashEnd;
        else if (end === -1) end = path35.length;
        return path35.slice(start, end);
    } else {
        for(i25 = path35.length - 1; i25 >= 0; --i25){
            if (path35.charCodeAt(i25) === 47) {
                if (!matchedSlash) {
                    start = i25 + 1;
                    break;
                }
            } else if (end === -1) {
                matchedSlash = false;
                end = i25 + 1;
            }
        }
        if (end === -1) return "";
        return path35.slice(start, end);
    }
}
function extname1(path36) {
    assertPath(path36);
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    for(let i26 = path36.length - 1; i26 >= 0; --i26){
        const code16 = path36.charCodeAt(i26);
        if (code16 === 47) {
            if (!matchedSlash) {
                startPart = i26 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i26 + 1;
        }
        if (code16 === 46) {
            if (startDot === -1) startDot = i26;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
    }
    return path36.slice(startDot, end);
}
function format1(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError(`The "pathObject" argument must be of type Object. Received type ${typeof pathObject}`);
    }
    return _format("/", pathObject);
}
function parse1(path37) {
    assertPath(path37);
    const ret = {
        root: "",
        dir: "",
        base: "",
        ext: "",
        name: ""
    };
    if (path37.length === 0) return ret;
    const isAbsolute2 = path37.charCodeAt(0) === 47;
    let start;
    if (isAbsolute2) {
        ret.root = "/";
        start = 1;
    } else {
        start = 0;
    }
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let i27 = path37.length - 1;
    let preDotState = 0;
    for(; i27 >= start; --i27){
        const code17 = path37.charCodeAt(i27);
        if (code17 === 47) {
            if (!matchedSlash) {
                startPart = i27 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i27 + 1;
        }
        if (code17 === 46) {
            if (startDot === -1) startDot = i27;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
            if (startPart === 0 && isAbsolute2) {
                ret.base = ret.name = path37.slice(1, end);
            } else {
                ret.base = ret.name = path37.slice(startPart, end);
            }
        }
    } else {
        if (startPart === 0 && isAbsolute2) {
            ret.name = path37.slice(1, startDot);
            ret.base = path37.slice(1, end);
        } else {
            ret.name = path37.slice(startPart, startDot);
            ret.base = path37.slice(startPart, end);
        }
        ret.ext = path37.slice(startDot, end);
    }
    if (startPart > 0) ret.dir = path37.slice(0, startPart - 1);
    else if (isAbsolute2) ret.dir = "/";
    return ret;
}
function fromFileUrl1(url) {
    url = url instanceof URL ? url : new URL(url);
    if (url.protocol != "file:") {
        throw new TypeError("Must be a file URL.");
    }
    return decodeURIComponent(url.pathname.replace(/%(?![0-9A-Fa-f]{2})/g, "%25"));
}
function toFileUrl1(path38) {
    if (!isAbsolute1(path38)) {
        throw new TypeError("Must be an absolute path.");
    }
    const url = new URL("file:///");
    url.pathname = encodeWhitespace(path38.replace(/%/g, "%25").replace(/\\/g, "%5C"));
    return url;
}
const mod2 = {
    sep: sep1,
    delimiter: delimiter1,
    resolve: resolve1,
    normalize: normalize1,
    isAbsolute: isAbsolute1,
    join: join1,
    relative: relative1,
    toNamespacedPath: toNamespacedPath1,
    dirname: dirname1,
    basename: basename1,
    extname: extname1,
    format: format1,
    parse: parse1,
    fromFileUrl: fromFileUrl1,
    toFileUrl: toFileUrl1
};
const SEP = isWindows ? "\\" : "/";
const SEP_PATTERN = isWindows ? /[\\/]+/ : /\/+/;
const path = isWindows ? mod1 : mod2;
const { join: join2 , normalize: normalize2  } = path;
const regExpEscapeChars = [
    "!",
    "$",
    "(",
    ")",
    "*",
    "+",
    ".",
    "=",
    "?",
    "[",
    "\\",
    "^",
    "{",
    "|", 
];
const rangeEscapeChars = [
    "-",
    "\\",
    "]"
];
function globToRegExp(glob, { extended =true , globstar: globstarOption = true , os: os1 = osType , caseInsensitive =false  } = {}) {
    if (glob == "") {
        return /(?!)/;
    }
    const sep8 = os1 == "windows" ? "(?:\\\\|/)+" : "/+";
    const sepMaybe = os1 == "windows" ? "(?:\\\\|/)*" : "/*";
    const seps = os1 == "windows" ? [
        "\\",
        "/"
    ] : [
        "/"
    ];
    const globstar = os1 == "windows" ? "(?:[^\\\\/]*(?:\\\\|/|$)+)*" : "(?:[^/]*(?:/|$)+)*";
    const wildcard = os1 == "windows" ? "[^\\\\/]*" : "[^/]*";
    const escapePrefix = os1 == "windows" ? "`" : "\\";
    let newLength = glob.length;
    for(; newLength > 1 && seps.includes(glob[newLength - 1]); newLength--);
    glob = glob.slice(0, newLength);
    let regExpString = "";
    for(let j = 0; j < glob.length;){
        let segment = "";
        const groupStack = [];
        let inRange = false;
        let inEscape = false;
        let endsWithSep = false;
        let i28 = j;
        for(; i28 < glob.length && !seps.includes(glob[i28]); i28++){
            if (inEscape) {
                inEscape = false;
                const escapeChars = inRange ? rangeEscapeChars : regExpEscapeChars;
                segment += escapeChars.includes(glob[i28]) ? `\\${glob[i28]}` : glob[i28];
                continue;
            }
            if (glob[i28] == escapePrefix) {
                inEscape = true;
                continue;
            }
            if (glob[i28] == "[") {
                if (!inRange) {
                    inRange = true;
                    segment += "[";
                    if (glob[i28 + 1] == "!") {
                        i28++;
                        segment += "^";
                    } else if (glob[i28 + 1] == "^") {
                        i28++;
                        segment += "\\^";
                    }
                    continue;
                } else if (glob[i28 + 1] == ":") {
                    let k = i28 + 1;
                    let value = "";
                    while(glob[k + 1] != null && glob[k + 1] != ":"){
                        value += glob[k + 1];
                        k++;
                    }
                    if (glob[k + 1] == ":" && glob[k + 2] == "]") {
                        i28 = k + 2;
                        if (value == "alnum") segment += "\\dA-Za-z";
                        else if (value == "alpha") segment += "A-Za-z";
                        else if (value == "ascii") segment += "\x00-\x7F";
                        else if (value == "blank") segment += "\t ";
                        else if (value == "cntrl") segment += "\x00-\x1F\x7F";
                        else if (value == "digit") segment += "\\d";
                        else if (value == "graph") segment += "\x21-\x7E";
                        else if (value == "lower") segment += "a-z";
                        else if (value == "print") segment += "\x20-\x7E";
                        else if (value == "punct") {
                            segment += "!\"#$%&'()*+,\\-./:;<=>?@[\\\\\\]^_‘{|}~";
                        } else if (value == "space") segment += "\\s\v";
                        else if (value == "upper") segment += "A-Z";
                        else if (value == "word") segment += "\\w";
                        else if (value == "xdigit") segment += "\\dA-Fa-f";
                        continue;
                    }
                }
            }
            if (glob[i28] == "]" && inRange) {
                inRange = false;
                segment += "]";
                continue;
            }
            if (inRange) {
                if (glob[i28] == "\\") {
                    segment += `\\\\`;
                } else {
                    segment += glob[i28];
                }
                continue;
            }
            if (glob[i28] == ")" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += ")";
                const type25 = groupStack.pop();
                if (type25 == "!") {
                    segment += wildcard;
                } else if (type25 != "@") {
                    segment += type25;
                }
                continue;
            }
            if (glob[i28] == "|" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i28] == "+" && extended && glob[i28 + 1] == "(") {
                i28++;
                groupStack.push("+");
                segment += "(?:";
                continue;
            }
            if (glob[i28] == "@" && extended && glob[i28 + 1] == "(") {
                i28++;
                groupStack.push("@");
                segment += "(?:";
                continue;
            }
            if (glob[i28] == "?") {
                if (extended && glob[i28 + 1] == "(") {
                    i28++;
                    groupStack.push("?");
                    segment += "(?:";
                } else {
                    segment += ".";
                }
                continue;
            }
            if (glob[i28] == "!" && extended && glob[i28 + 1] == "(") {
                i28++;
                groupStack.push("!");
                segment += "(?!";
                continue;
            }
            if (glob[i28] == "{") {
                groupStack.push("BRACE");
                segment += "(?:";
                continue;
            }
            if (glob[i28] == "}" && groupStack[groupStack.length - 1] == "BRACE") {
                groupStack.pop();
                segment += ")";
                continue;
            }
            if (glob[i28] == "," && groupStack[groupStack.length - 1] == "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i28] == "*") {
                if (extended && glob[i28 + 1] == "(") {
                    i28++;
                    groupStack.push("*");
                    segment += "(?:";
                } else {
                    const prevChar = glob[i28 - 1];
                    let numStars = 1;
                    while(glob[i28 + 1] == "*"){
                        i28++;
                        numStars++;
                    }
                    const nextChar = glob[i28 + 1];
                    if (globstarOption && numStars == 2 && [
                        ...seps,
                        undefined
                    ].includes(prevChar) && [
                        ...seps,
                        undefined
                    ].includes(nextChar)) {
                        segment += globstar;
                        endsWithSep = true;
                    } else {
                        segment += wildcard;
                    }
                }
                continue;
            }
            segment += regExpEscapeChars.includes(glob[i28]) ? `\\${glob[i28]}` : glob[i28];
        }
        if (groupStack.length > 0 || inRange || inEscape) {
            segment = "";
            for (const c of glob.slice(j, i28)){
                segment += regExpEscapeChars.includes(c) ? `\\${c}` : c;
                endsWithSep = false;
            }
        }
        regExpString += segment;
        if (!endsWithSep) {
            regExpString += i28 < glob.length ? sep8 : sepMaybe;
            endsWithSep = true;
        }
        while(seps.includes(glob[i28]))i28++;
        if (!(i28 > j)) {
            throw new Error("Assertion failure: i > j (potential infinite loop)");
        }
        j = i28;
    }
    regExpString = `^${regExpString}$`;
    return new RegExp(regExpString, caseInsensitive ? "i" : "");
}
function isGlob(str58) {
    const chars = {
        "{": "}",
        "(": ")",
        "[": "]"
    };
    const regex = /\\(.)|(^!|\*|\?|[\].+)]\?|\[[^\\\]]+\]|\{[^\\}]+\}|\(\?[:!=][^\\)]+\)|\([^|]+\|[^\\)]+\))/;
    if (str58 === "") {
        return false;
    }
    let match;
    while(match = regex.exec(str58)){
        if (match[2]) return true;
        let idx = match.index + match[0].length;
        const open = match[1];
        const close = open ? chars[open] : null;
        if (open && close) {
            const n = str58.indexOf(close, idx);
            if (n !== -1) {
                idx = n + 1;
            }
        }
        str58 = str58.slice(idx);
    }
    return false;
}
function normalizeGlob(glob, { globstar =false  } = {}) {
    if (glob.match(/\0/g)) {
        throw new Error(`Glob contains invalid characters: "${glob}"`);
    }
    if (!globstar) {
        return normalize2(glob);
    }
    const s = SEP_PATTERN.source;
    const badParentPattern = new RegExp(`(?<=(${s}|^)\\*\\*${s})\\.\\.(?=${s}|$)`, "g");
    return normalize2(glob.replace(badParentPattern, "\0")).replace(/\0/g, "..");
}
function joinGlobs(globs, { extended =true , globstar =false  } = {}) {
    if (!globstar || globs.length == 0) {
        return join2(...globs);
    }
    if (globs.length === 0) return ".";
    let joined;
    for (const glob of globs){
        const path1 = glob;
        if (path1.length > 0) {
            if (!joined) joined = path1;
            else joined += `${SEP}${path1}`;
        }
    }
    if (!joined) return ".";
    return normalizeGlob(joined, {
        extended,
        globstar
    });
}
const path1 = isWindows ? mod1 : mod2;
const posix = mod2;
const { basename: basename2 , delimiter: delimiter2 , dirname: dirname2 , extname: extname2 , format: format2 , fromFileUrl: fromFileUrl2 , isAbsolute: isAbsolute2 , join: join3 , normalize: normalize3 , parse: parse2 , relative: relative2 , resolve: resolve2 , sep: sep2 , toFileUrl: toFileUrl2 , toNamespacedPath: toNamespacedPath2 ,  } = path1;
function _createWalkEntrySync(path39) {
    path39 = normalize3(path39);
    const name77 = basename2(path39);
    const info1 = Deno.statSync(path39);
    return {
        path: path39,
        name: name77,
        isFile: info1.isFile,
        isDirectory: info1.isDirectory,
        isSymlink: info1.isSymlink
    };
}
function include(path40, exts, match, skip) {
    if (exts && !exts.some((ext)=>path40.endsWith(ext)
    )) {
        return false;
    }
    if (match && !match.some((pattern)=>!!path40.match(pattern)
    )) {
        return false;
    }
    if (skip && skip.some((pattern)=>!!path40.match(pattern)
    )) {
        return false;
    }
    return true;
}
function wrapErrorWithRootPath(err, root1) {
    if (err instanceof Error && "root" in err) return err;
    const e = new Error();
    e.root = root1;
    e.message = err instanceof Error ? `${err.message} for path "${root1}"` : `[non-error thrown] for path "${root1}"`;
    e.stack = err instanceof Error ? err.stack : undefined;
    e.cause = err instanceof Error ? err.cause : undefined;
    return e;
}
function* walkSync(root2, { maxDepth =Infinity , includeFiles =true , includeDirs =true , followSymlinks =false , exts =undefined , match =undefined , skip =undefined  } = {}) {
    if (maxDepth < 0) {
        return;
    }
    if (includeDirs && include(root2, exts, match, skip)) {
        yield _createWalkEntrySync(root2);
    }
    if (maxDepth < 1 || !include(root2, undefined, undefined, skip)) {
        return;
    }
    let entries;
    try {
        entries = Deno.readDirSync(root2);
    } catch (err) {
        throw wrapErrorWithRootPath(err, normalize3(root2));
    }
    for (const entry of entries){
        assert(entry.name != null);
        let path41 = join3(root2, entry.name);
        let { isSymlink , isDirectory: isDirectory1  } = entry;
        if (isSymlink) {
            if (!followSymlinks) continue;
            path41 = Deno.realPathSync(path41);
            ({ isSymlink , isDirectory: isDirectory1  } = Deno.lstatSync(path41));
        }
        if (isSymlink || isDirectory1) {
            yield* walkSync(path41, {
                maxDepth: maxDepth - 1,
                includeFiles,
                includeDirs,
                followSymlinks,
                exts,
                match,
                skip
            });
        } else if (includeFiles && include(path41, exts, match, skip)) {
            yield {
                path: path41,
                ...entry
            };
        }
    }
}
function split(path42) {
    const s = SEP_PATTERN.source;
    const segments = path42.replace(new RegExp(`^${s}|${s}$`, "g"), "").split(SEP_PATTERN);
    const isAbsolute_ = isAbsolute2(path42);
    return {
        segments,
        isAbsolute: isAbsolute_,
        hasTrailingSep: !!path42.match(new RegExp(`${s}$`)),
        winRoot: isWindows && isAbsolute_ ? segments.shift() : undefined
    };
}
function throwUnlessNotFound(error6) {
    if (!(error6 instanceof Deno.errors.NotFound)) {
        throw error6;
    }
}
function comparePath(a, b) {
    if (a.path < b.path) return -1;
    if (a.path > b.path) return 1;
    return 0;
}
function* expandGlobSync(glob, { root: root3 = Deno.cwd() , exclude =[] , includeDirs =true , extended =true , globstar =false , caseInsensitive  } = {}) {
    const globOptions = {
        extended,
        globstar,
        caseInsensitive
    };
    const absRoot = resolve2(root3);
    const resolveFromRoot = (path43)=>resolve2(absRoot, path43)
    ;
    const excludePatterns = exclude.map(resolveFromRoot).map((s)=>globToRegExp(s, globOptions)
    );
    const shouldInclude1 = (path44)=>!excludePatterns.some((p)=>!!path44.match(p)
        )
    ;
    const { segments , isAbsolute: isGlobAbsolute , hasTrailingSep , winRoot  } = split(glob);
    let fixedRoot = isGlobAbsolute ? winRoot != undefined ? winRoot : "/" : absRoot;
    while(segments.length > 0 && !isGlob(segments[0])){
        const seg = segments.shift();
        assert(seg != null);
        fixedRoot = joinGlobs([
            fixedRoot,
            seg
        ], globOptions);
    }
    let fixedRootInfo;
    try {
        fixedRootInfo = _createWalkEntrySync(fixedRoot);
    } catch (error2) {
        return throwUnlessNotFound(error2);
    }
    function* advanceMatch(walkInfo, globSegment) {
        if (!walkInfo.isDirectory) {
            return;
        } else if (globSegment == "..") {
            const parentPath = joinGlobs([
                walkInfo.path,
                ".."
            ], globOptions);
            try {
                if (shouldInclude1(parentPath)) {
                    return yield _createWalkEntrySync(parentPath);
                }
            } catch (error7) {
                throwUnlessNotFound(error7);
            }
            return;
        } else if (globSegment == "**") {
            return yield* walkSync(walkInfo.path, {
                skip: excludePatterns
            });
        }
        const globPattern = globToRegExp(globSegment, globOptions);
        for (const walkEntry of walkSync(walkInfo.path, {
            maxDepth: 1,
            skip: excludePatterns
        })){
            if (walkEntry.path != walkInfo.path && walkEntry.name.match(globPattern)) {
                yield walkEntry;
            }
        }
    }
    let currentMatches = [
        fixedRootInfo
    ];
    for (const segment of segments){
        const nextMatchMap = new Map();
        for (const currentMatch of currentMatches){
            for (const nextMatch of advanceMatch(currentMatch, segment)){
                nextMatchMap.set(nextMatch.path, nextMatch);
            }
        }
        currentMatches = [
            ...nextMatchMap.values()
        ].sort(comparePath);
    }
    if (hasTrailingSep) {
        currentMatches = currentMatches.filter((entry)=>entry.isDirectory
        );
    }
    if (!includeDirs) {
        currentMatches = currentMatches.filter((entry)=>!entry.isDirectory
        );
    }
    yield* currentMatches;
}
var LogLevels;
(function(LogLevels1) {
    LogLevels1[LogLevels1["NOTSET"] = 0] = "NOTSET";
    LogLevels1[LogLevels1["DEBUG"] = 10] = "DEBUG";
    LogLevels1[LogLevels1["INFO"] = 20] = "INFO";
    LogLevels1[LogLevels1["WARNING"] = 30] = "WARNING";
    LogLevels1[LogLevels1["ERROR"] = 40] = "ERROR";
    LogLevels1[LogLevels1["CRITICAL"] = 50] = "CRITICAL";
})(LogLevels || (LogLevels = {}));
Object.keys(LogLevels).filter((key)=>isNaN(Number(key))
);
const byLevel = {
    [String(LogLevels.NOTSET)]: "NOTSET",
    [String(LogLevels.DEBUG)]: "DEBUG",
    [String(LogLevels.INFO)]: "INFO",
    [String(LogLevels.WARNING)]: "WARNING",
    [String(LogLevels.ERROR)]: "ERROR",
    [String(LogLevels.CRITICAL)]: "CRITICAL"
};
function getLevelByName(name78) {
    switch(name78){
        case "NOTSET":
            return LogLevels.NOTSET;
        case "DEBUG":
            return LogLevels.DEBUG;
        case "INFO":
            return LogLevels.INFO;
        case "WARNING":
            return LogLevels.WARNING;
        case "ERROR":
            return LogLevels.ERROR;
        case "CRITICAL":
            return LogLevels.CRITICAL;
        default:
            throw new Error(`no log level found for "${name78}"`);
    }
}
function getLevelName(level) {
    const levelName = byLevel[level];
    if (levelName) {
        return levelName;
    }
    throw new Error(`no level name found for level: ${level}`);
}
class LogRecord {
    msg;
    #args;
    #datetime;
    level;
    levelName;
    loggerName;
    constructor(options){
        this.msg = options.msg;
        this.#args = [
            ...options.args
        ];
        this.level = options.level;
        this.loggerName = options.loggerName;
        this.#datetime = new Date();
        this.levelName = getLevelName(options.level);
    }
    get args() {
        return [
            ...this.#args
        ];
    }
    get datetime() {
        return new Date(this.#datetime.getTime());
    }
}
class Logger {
    #level;
    #handlers;
    #loggerName;
    constructor(loggerName, levelName, options = {}){
        this.#loggerName = loggerName;
        this.#level = getLevelByName(levelName);
        this.#handlers = options.handlers || [];
    }
    get level() {
        return this.#level;
    }
    set level(level) {
        this.#level = level;
    }
    get levelName() {
        return getLevelName(this.#level);
    }
    set levelName(levelName) {
        this.#level = getLevelByName(levelName);
    }
    get loggerName() {
        return this.#loggerName;
    }
    set handlers(hndls) {
        this.#handlers = hndls;
    }
    get handlers() {
        return this.#handlers;
    }
    _log(level, msg, ...args) {
        if (this.level > level) {
            return msg instanceof Function ? undefined : msg;
        }
        let fnResult;
        let logMessage;
        if (msg instanceof Function) {
            fnResult = msg();
            logMessage = this.asString(fnResult);
        } else {
            logMessage = this.asString(msg);
        }
        const record = new LogRecord({
            msg: logMessage,
            args: args,
            level: level,
            loggerName: this.loggerName
        });
        this.#handlers.forEach((handler)=>{
            handler.handle(record);
        });
        return msg instanceof Function ? fnResult : msg;
    }
    asString(data2) {
        if (typeof data2 === "string") {
            return data2;
        } else if (data2 === null || typeof data2 === "number" || typeof data2 === "bigint" || typeof data2 === "boolean" || typeof data2 === "undefined" || typeof data2 === "symbol") {
            return String(data2);
        } else if (data2 instanceof Error) {
            return data2.stack;
        } else if (typeof data2 === "object") {
            return JSON.stringify(data2);
        }
        return "undefined";
    }
    debug(msg, ...args) {
        return this._log(LogLevels.DEBUG, msg, ...args);
    }
    info(msg, ...args) {
        return this._log(LogLevels.INFO, msg, ...args);
    }
    warning(msg, ...args) {
        return this._log(LogLevels.WARNING, msg, ...args);
    }
    error(msg, ...args) {
        return this._log(LogLevels.ERROR, msg, ...args);
    }
    critical(msg, ...args) {
        return this._log(LogLevels.CRITICAL, msg, ...args);
    }
}
async function exists(filePath) {
    try {
        await Deno.lstat(filePath);
        return true;
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return false;
        }
        throw err;
    }
}
function existsSync(filePath) {
    try {
        Deno.lstatSync(filePath);
        return true;
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return false;
        }
        throw err;
    }
}
function indexOfNeedle(source, needle, start = 0) {
    if (start >= source.length) {
        return -1;
    }
    if (start < 0) {
        start = Math.max(0, source.length + start);
    }
    const s = needle[0];
    for(let i29 = start; i29 < source.length; i29++){
        if (source[i29] !== s) continue;
        const pin = i29;
        let matched = 1;
        let j = i29;
        while(matched < needle.length){
            j++;
            if (source[j] !== needle[j - pin]) {
                break;
            }
            matched++;
        }
        if (matched === needle.length) {
            return pin;
        }
    }
    return -1;
}
function concat(...buf) {
    let length = 0;
    for (const b of buf){
        length += b.length;
    }
    const output = new Uint8Array(length);
    let index = 0;
    for (const b1 of buf){
        output.set(b1, index);
        index += b1.length;
    }
    return output;
}
function copy(src1, dst, off = 0) {
    off = Math.max(0, Math.min(off, dst.byteLength));
    const dstBytesAvailable = dst.byteLength - off;
    if (src1.byteLength > dstBytesAvailable) {
        src1 = src1.subarray(0, dstBytesAvailable);
    }
    dst.set(src1, off);
    return src1.byteLength;
}
const MIN_READ = 32 * 1024;
const MAX_SIZE = 2 ** 32 - 2;
class Buffer4 {
    #buf;
    #off = 0;
    constructor(ab){
        this.#buf = ab === undefined ? new Uint8Array(0) : new Uint8Array(ab);
    }
    bytes(options = {
        copy: true
    }) {
        if (options.copy === false) return this.#buf.subarray(this.#off);
        return this.#buf.slice(this.#off);
    }
    empty() {
        return this.#buf.byteLength <= this.#off;
    }
    get length() {
        return this.#buf.byteLength - this.#off;
    }
    get capacity() {
        return this.#buf.buffer.byteLength;
    }
    truncate(n) {
        if (n === 0) {
            this.reset();
            return;
        }
        if (n < 0 || n > this.length) {
            throw Error("bytes.Buffer: truncation out of range");
        }
        this.#reslice(this.#off + n);
    }
    reset() {
        this.#reslice(0);
        this.#off = 0;
    }
     #tryGrowByReslice(n) {
        const l = this.#buf.byteLength;
        if (n <= this.capacity - l) {
            this.#reslice(l + n);
            return l;
        }
        return -1;
    }
     #reslice(len) {
        assert(len <= this.#buf.buffer.byteLength);
        this.#buf = new Uint8Array(this.#buf.buffer, 0, len);
    }
    readSync(p) {
        if (this.empty()) {
            this.reset();
            if (p.byteLength === 0) {
                return 0;
            }
            return null;
        }
        const nread = copy(this.#buf.subarray(this.#off), p);
        this.#off += nread;
        return nread;
    }
    read(p) {
        const rr = this.readSync(p);
        return Promise.resolve(rr);
    }
    writeSync(p) {
        const m = this.#grow(p.byteLength);
        return copy(p, this.#buf, m);
    }
    write(p) {
        const n1 = this.writeSync(p);
        return Promise.resolve(n1);
    }
     #grow(n2) {
        const m = this.length;
        if (m === 0 && this.#off !== 0) {
            this.reset();
        }
        const i = this.#tryGrowByReslice(n2);
        if (i >= 0) {
            return i;
        }
        const c = this.capacity;
        if (n2 <= Math.floor(c / 2) - m) {
            copy(this.#buf.subarray(this.#off), this.#buf);
        } else if (c + n2 > MAX_SIZE) {
            throw new Error("The buffer cannot be grown beyond the maximum size.");
        } else {
            const buf = new Uint8Array(Math.min(2 * c + n2, MAX_SIZE));
            copy(this.#buf.subarray(this.#off), buf);
            this.#buf = buf;
        }
        this.#off = 0;
        this.#reslice(Math.min(m + n2, MAX_SIZE));
        return m;
    }
    grow(n3) {
        if (n3 < 0) {
            throw Error("Buffer.grow: negative count");
        }
        const m = this.#grow(n3);
        this.#reslice(m);
    }
    async readFrom(r) {
        let n4 = 0;
        const tmp = new Uint8Array(MIN_READ);
        while(true){
            const shouldGrow = this.capacity - this.length < MIN_READ;
            const buf = shouldGrow ? tmp : new Uint8Array(this.#buf.buffer, this.length);
            const nread = await r.read(buf);
            if (nread === null) {
                return n4;
            }
            if (shouldGrow) this.writeSync(buf.subarray(0, nread));
            else this.#reslice(this.length + nread);
            n4 += nread;
        }
    }
    readFromSync(r) {
        let n5 = 0;
        const tmp = new Uint8Array(MIN_READ);
        while(true){
            const shouldGrow = this.capacity - this.length < MIN_READ;
            const buf = shouldGrow ? tmp : new Uint8Array(this.#buf.buffer, this.length);
            const nread = r.readSync(buf);
            if (nread === null) {
                return n5;
            }
            if (shouldGrow) this.writeSync(buf.subarray(0, nread));
            else this.#reslice(this.length + nread);
            n5 += nread;
        }
    }
}
const MIN_BUF_SIZE = 16;
const CR = "\r".charCodeAt(0);
const LF = "\n".charCodeAt(0);
class BufferFullError extends Error {
    name;
    constructor(partial){
        super("Buffer full");
        this.partial = partial;
        this.name = "BufferFullError";
    }
    partial;
}
class PartialReadError extends Error {
    name = "PartialReadError";
    partial;
    constructor(){
        super("Encountered UnexpectedEof, data only partially read");
    }
}
class BufReader {
    #buf;
    #rd;
    #r = 0;
    #w = 0;
    #eof = false;
    static create(r, size = 4096) {
        return r instanceof BufReader ? r : new BufReader(r, size);
    }
    constructor(rd, size = 4096){
        if (size < 16) {
            size = MIN_BUF_SIZE;
        }
        this.#reset(new Uint8Array(size), rd);
    }
    size() {
        return this.#buf.byteLength;
    }
    buffered() {
        return this.#w - this.#r;
    }
    #fill = async ()=>{
        if (this.#r > 0) {
            this.#buf.copyWithin(0, this.#r, this.#w);
            this.#w -= this.#r;
            this.#r = 0;
        }
        if (this.#w >= this.#buf.byteLength) {
            throw Error("bufio: tried to fill full buffer");
        }
        for(let i30 = 100; i30 > 0; i30--){
            const rr = await this.#rd.read(this.#buf.subarray(this.#w));
            if (rr === null) {
                this.#eof = true;
                return;
            }
            assert(rr >= 0, "negative read");
            this.#w += rr;
            if (rr > 0) {
                return;
            }
        }
        throw new Error(`No progress after ${100} read() calls`);
    };
    reset(r) {
        this.#reset(this.#buf, r);
    }
    #reset = (buf, rd)=>{
        this.#buf = buf;
        this.#rd = rd;
        this.#eof = false;
    };
    async read(p) {
        let rr = p.byteLength;
        if (p.byteLength === 0) return rr;
        if (this.#r === this.#w) {
            if (p.byteLength >= this.#buf.byteLength) {
                const rr = await this.#rd.read(p);
                const nread = rr ?? 0;
                assert(nread >= 0, "negative read");
                return rr;
            }
            this.#r = 0;
            this.#w = 0;
            rr = await this.#rd.read(this.#buf);
            if (rr === 0 || rr === null) return rr;
            assert(rr >= 0, "negative read");
            this.#w += rr;
        }
        const copied = copy(this.#buf.subarray(this.#r, this.#w), p, 0);
        this.#r += copied;
        return copied;
    }
    async readFull(p) {
        let bytesRead = 0;
        while(bytesRead < p.length){
            try {
                const rr = await this.read(p.subarray(bytesRead));
                if (rr === null) {
                    if (bytesRead === 0) {
                        return null;
                    } else {
                        throw new PartialReadError();
                    }
                }
                bytesRead += rr;
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = p.subarray(0, bytesRead);
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = p.subarray(0, bytesRead);
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
        }
        return p;
    }
    async readByte() {
        while(this.#r === this.#w){
            if (this.#eof) return null;
            await this.#fill();
        }
        const c = this.#buf[this.#r];
        this.#r++;
        return c;
    }
    async readString(delim) {
        if (delim.length !== 1) {
            throw new Error("Delimiter should be a single character");
        }
        const buffer = await this.readSlice(delim.charCodeAt(0));
        if (buffer === null) return null;
        return new TextDecoder().decode(buffer);
    }
    async readLine() {
        let line = null;
        try {
            line = await this.readSlice(LF);
        } catch (err) {
            if (err instanceof Deno.errors.BadResource) {
                throw err;
            }
            let partial;
            if (err instanceof PartialReadError) {
                partial = err.partial;
                assert(partial instanceof Uint8Array, "bufio: caught error from `readSlice()` without `partial` property");
            }
            if (!(err instanceof BufferFullError)) {
                throw err;
            }
            partial = err.partial;
            if (!this.#eof && partial && partial.byteLength > 0 && partial[partial.byteLength - 1] === CR) {
                assert(this.#r > 0, "bufio: tried to rewind past start of buffer");
                this.#r--;
                partial = partial.subarray(0, partial.byteLength - 1);
            }
            if (partial) {
                return {
                    line: partial,
                    more: !this.#eof
                };
            }
        }
        if (line === null) {
            return null;
        }
        if (line.byteLength === 0) {
            return {
                line,
                more: false
            };
        }
        if (line[line.byteLength - 1] == LF) {
            let drop = 1;
            if (line.byteLength > 1 && line[line.byteLength - 2] === CR) {
                drop = 2;
            }
            line = line.subarray(0, line.byteLength - drop);
        }
        return {
            line,
            more: false
        };
    }
    async readSlice(delim) {
        let s = 0;
        let slice1;
        while(true){
            let i31 = this.#buf.subarray(this.#r + s, this.#w).indexOf(delim);
            if (i31 >= 0) {
                i31 += s;
                slice1 = this.#buf.subarray(this.#r, this.#r + i31 + 1);
                this.#r += i31 + 1;
                break;
            }
            if (this.#eof) {
                if (this.#r === this.#w) {
                    return null;
                }
                slice1 = this.#buf.subarray(this.#r, this.#w);
                this.#r = this.#w;
                break;
            }
            if (this.buffered() >= this.#buf.byteLength) {
                this.#r = this.#w;
                const oldbuf = this.#buf;
                const newbuf = this.#buf.slice(0);
                this.#buf = newbuf;
                throw new BufferFullError(oldbuf);
            }
            s = this.#w - this.#r;
            try {
                await this.#fill();
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = slice1;
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = slice1;
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
        }
        return slice1;
    }
    async peek(n6) {
        if (n6 < 0) {
            throw Error("negative count");
        }
        let avail = this.#w - this.#r;
        while(avail < n6 && avail < this.#buf.byteLength && !this.#eof){
            try {
                await this.#fill();
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = this.#buf.subarray(this.#r, this.#w);
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = this.#buf.subarray(this.#r, this.#w);
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
            avail = this.#w - this.#r;
        }
        if (avail === 0 && this.#eof) {
            return null;
        } else if (avail < n6 && this.#eof) {
            return this.#buf.subarray(this.#r, this.#r + avail);
        } else if (avail < n6) {
            throw new BufferFullError(this.#buf.subarray(this.#r, this.#w));
        }
        return this.#buf.subarray(this.#r, this.#r + n6);
    }
}
class AbstractBufBase {
    buf;
    usedBufferBytes = 0;
    err = null;
    constructor(buf){
        this.buf = buf;
    }
    size() {
        return this.buf.byteLength;
    }
    available() {
        return this.buf.byteLength - this.usedBufferBytes;
    }
    buffered() {
        return this.usedBufferBytes;
    }
}
class BufWriter extends AbstractBufBase {
    #writer;
    static create(writer, size = 4096) {
        return writer instanceof BufWriter ? writer : new BufWriter(writer, size);
    }
    constructor(writer, size = 4096){
        super(new Uint8Array(size <= 0 ? 4096 : size));
        this.#writer = writer;
    }
    reset(w) {
        this.err = null;
        this.usedBufferBytes = 0;
        this.#writer = w;
    }
    async flush() {
        if (this.err !== null) throw this.err;
        if (this.usedBufferBytes === 0) return;
        try {
            const p = this.buf.subarray(0, this.usedBufferBytes);
            let nwritten = 0;
            while(nwritten < p.length){
                nwritten += await this.#writer.write(p.subarray(nwritten));
            }
        } catch (e) {
            if (e instanceof Error) {
                this.err = e;
            }
            throw e;
        }
        this.buf = new Uint8Array(this.buf.length);
        this.usedBufferBytes = 0;
    }
    async write(data3) {
        if (this.err !== null) throw this.err;
        if (data3.length === 0) return 0;
        let totalBytesWritten = 0;
        let numBytesWritten = 0;
        while(data3.byteLength > this.available()){
            if (this.buffered() === 0) {
                try {
                    numBytesWritten = await this.#writer.write(data3);
                } catch (e) {
                    if (e instanceof Error) {
                        this.err = e;
                    }
                    throw e;
                }
            } else {
                numBytesWritten = copy(data3, this.buf, this.usedBufferBytes);
                this.usedBufferBytes += numBytesWritten;
                await this.flush();
            }
            totalBytesWritten += numBytesWritten;
            data3 = data3.subarray(numBytesWritten);
        }
        numBytesWritten = copy(data3, this.buf, this.usedBufferBytes);
        this.usedBufferBytes += numBytesWritten;
        totalBytesWritten += numBytesWritten;
        return totalBytesWritten;
    }
}
class BufWriterSync extends AbstractBufBase {
    #writer;
    static create(writer, size = 4096) {
        return writer instanceof BufWriterSync ? writer : new BufWriterSync(writer, size);
    }
    constructor(writer, size = 4096){
        super(new Uint8Array(size <= 0 ? 4096 : size));
        this.#writer = writer;
    }
    reset(w) {
        this.err = null;
        this.usedBufferBytes = 0;
        this.#writer = w;
    }
    flush() {
        if (this.err !== null) throw this.err;
        if (this.usedBufferBytes === 0) return;
        try {
            const p = this.buf.subarray(0, this.usedBufferBytes);
            let nwritten = 0;
            while(nwritten < p.length){
                nwritten += this.#writer.writeSync(p.subarray(nwritten));
            }
        } catch (e) {
            if (e instanceof Error) {
                this.err = e;
            }
            throw e;
        }
        this.buf = new Uint8Array(this.buf.length);
        this.usedBufferBytes = 0;
    }
    writeSync(data4) {
        if (this.err !== null) throw this.err;
        if (data4.length === 0) return 0;
        let totalBytesWritten = 0;
        let numBytesWritten = 0;
        while(data4.byteLength > this.available()){
            if (this.buffered() === 0) {
                try {
                    numBytesWritten = this.#writer.writeSync(data4);
                } catch (e) {
                    if (e instanceof Error) {
                        this.err = e;
                    }
                    throw e;
                }
            } else {
                numBytesWritten = copy(data4, this.buf, this.usedBufferBytes);
                this.usedBufferBytes += numBytesWritten;
                this.flush();
            }
            totalBytesWritten += numBytesWritten;
            data4 = data4.subarray(numBytesWritten);
        }
        numBytesWritten = copy(data4, this.buf, this.usedBufferBytes);
        this.usedBufferBytes += numBytesWritten;
        totalBytesWritten += numBytesWritten;
        return totalBytesWritten;
    }
}
async function* readLines(reader, decoderOpts) {
    const bufReader = new BufReader(reader);
    let chunks = [];
    const decoder = new TextDecoder(decoderOpts?.encoding, decoderOpts);
    while(true){
        const res = await bufReader.readLine();
        if (!res) {
            if (chunks.length > 0) {
                yield decoder.decode(concat(...chunks));
            }
            break;
        }
        chunks.push(res.line);
        if (!res.more) {
            yield decoder.decode(concat(...chunks));
            chunks = [];
        }
    }
}
const DEFAULT_FORMATTER = "{levelName} {msg}";
class BaseHandler {
    level;
    levelName;
    formatter;
    constructor(levelName, options = {}){
        this.level = getLevelByName(levelName);
        this.levelName = levelName;
        this.formatter = options.formatter || DEFAULT_FORMATTER;
    }
    handle(logRecord) {
        if (this.level > logRecord.level) return;
        const msg = this.format(logRecord);
        return this.log(msg);
    }
    format(logRecord) {
        if (this.formatter instanceof Function) {
            return this.formatter(logRecord);
        }
        return this.formatter.replace(/{([^\s}]+)}/g, (match, p1)=>{
            const value = logRecord[p1];
            if (value == null) {
                return match;
            }
            return String(value);
        });
    }
    log(_msg) {}
    async setup() {}
    async destroy() {}
}
class ConsoleHandler extends BaseHandler {
    format(logRecord) {
        let msg = super.format(logRecord);
        switch(logRecord.level){
            case LogLevels.INFO:
                msg = blue(msg);
                break;
            case LogLevels.WARNING:
                msg = yellow(msg);
                break;
            case LogLevels.ERROR:
                msg = red(msg);
                break;
            case LogLevels.CRITICAL:
                msg = bold(red(msg));
                break;
            default:
                break;
        }
        return msg;
    }
    log(msg) {
        console.log(msg);
    }
}
class WriterHandler extends BaseHandler {
    _writer;
    #encoder = new TextEncoder();
}
class FileHandler extends WriterHandler {
    _file;
    _buf;
    _filename;
    _mode;
    _openOptions;
    _encoder = new TextEncoder();
    #unloadCallback = (()=>{
        this.destroy();
    }).bind(this);
    constructor(levelName, options){
        super(levelName, options);
        this._filename = options.filename;
        this._mode = options.mode ? options.mode : "a";
        this._openOptions = {
            createNew: this._mode === "x",
            create: this._mode !== "x",
            append: this._mode === "a",
            truncate: this._mode !== "a",
            write: true
        };
    }
    async setup() {
        this._file = await Deno.open(this._filename, this._openOptions);
        this._writer = this._file;
        this._buf = new BufWriterSync(this._file);
        addEventListener("unload", this.#unloadCallback);
    }
    handle(logRecord) {
        super.handle(logRecord);
        if (logRecord.level > LogLevels.ERROR) {
            this.flush();
        }
    }
    log(msg) {
        if (this._encoder.encode(msg).byteLength + 1 > this._buf.available()) {
            this.flush();
        }
        this._buf.writeSync(this._encoder.encode(msg + "\n"));
    }
    flush() {
        if (this._buf?.buffered() > 0) {
            this._buf.flush();
        }
    }
    destroy() {
        this.flush();
        this._file?.close();
        this._file = undefined;
        removeEventListener("unload", this.#unloadCallback);
        return Promise.resolve();
    }
}
const DEFAULT_LEVEL = "INFO";
const DEFAULT_CONFIG = {
    handlers: {
        default: new ConsoleHandler(DEFAULT_LEVEL)
    },
    loggers: {
        default: {
            level: DEFAULT_LEVEL,
            handlers: [
                "default"
            ]
        }
    }
};
const state = {
    handlers: new Map(),
    loggers: new Map(),
    config: DEFAULT_CONFIG
};
function getLogger(name79) {
    if (!name79) {
        const d = state.loggers.get("default");
        assert(d != null, `"default" logger must be set for getting logger without name`);
        return d;
    }
    const result = state.loggers.get(name79);
    if (!result) {
        const logger = new Logger(name79, "NOTSET", {
            handlers: []
        });
        state.loggers.set(name79, logger);
        return logger;
    }
    return result;
}
function debug(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").debug(msg, ...args);
    }
    return getLogger("default").debug(msg, ...args);
}
function info(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").info(msg, ...args);
    }
    return getLogger("default").info(msg, ...args);
}
function warning(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").warning(msg, ...args);
    }
    return getLogger("default").warning(msg, ...args);
}
function error(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").error(msg, ...args);
    }
    return getLogger("default").error(msg, ...args);
}
async function setup(config1) {
    state.config = {
        handlers: {
            ...DEFAULT_CONFIG.handlers,
            ...config1.handlers
        },
        loggers: {
            ...DEFAULT_CONFIG.loggers,
            ...config1.loggers
        }
    };
    state.handlers.forEach((handler)=>{
        handler.destroy();
    });
    state.handlers.clear();
    const handlers1 = state.config.handlers || {};
    for(const handlerName1 in handlers1){
        const handler = handlers1[handlerName1];
        await handler.setup();
        state.handlers.set(handlerName1, handler);
    }
    state.loggers.clear();
    const loggers = state.config.loggers || {};
    for(const loggerName in loggers){
        const loggerConfig = loggers[loggerName];
        const handlerNames = loggerConfig.handlers || [];
        const handlers2 = [];
        handlerNames.forEach((handlerName)=>{
            const handler = state.handlers.get(handlerName);
            if (handler) {
                handlers2.push(handler);
            }
        });
        const levelName = loggerConfig.level || DEFAULT_LEVEL;
        const logger = new Logger(loggerName, levelName, {
            handlers: handlers2
        });
        state.loggers.set(loggerName, logger);
    }
}
await setup(DEFAULT_CONFIG);
function isSubdir(src2, dest, sep9 = sep2) {
    if (src2 === dest) {
        return false;
    }
    const srcArray = src2.split(sep9);
    const destArray = dest.split(sep9);
    return srcArray.every((current, i32)=>destArray[i32] === current
    );
}
function getFileInfoType(fileInfo) {
    return fileInfo.isFile ? "file" : fileInfo.isDirectory ? "dir" : fileInfo.isSymlink ? "symlink" : undefined;
}
async function ensureDir(dir) {
    try {
        const fileInfo = await Deno.lstat(dir);
        if (!fileInfo.isDirectory) {
            throw new Error(`Ensure path exists, expected 'dir', got '${getFileInfoType(fileInfo)}'`);
        }
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            await Deno.mkdir(dir, {
                recursive: true
            });
            return;
        }
        throw err;
    }
}
function ensureDirSync(dir) {
    try {
        const fileInfo = Deno.lstatSync(dir);
        if (!fileInfo.isDirectory) {
            throw new Error(`Ensure path exists, expected 'dir', got '${getFileInfoType(fileInfo)}'`);
        }
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            Deno.mkdirSync(dir, {
                recursive: true
            });
            return;
        }
        throw err;
    }
}
function utime(...args) {
    if (typeof Deno.utime == "function") {
        return Deno.utime(...args);
    } else {
        return Promise.reject(new TypeError("Requires --unstable"));
    }
}
async function ensureValidCopy(src3, dest, options) {
    let destStat;
    try {
        destStat = await Deno.lstat(dest);
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return;
        }
        throw err;
    }
    if (options.isFolder && !destStat.isDirectory) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src3}'.`);
    }
    if (!options.overwrite) {
        throw new Error(`'${dest}' already exists.`);
    }
    return destStat;
}
async function copyFile(src4, dest, options) {
    await ensureValidCopy(src4, dest, options);
    await Deno.copyFile(src4, dest);
    if (options.preserveTimestamps) {
        const statInfo = await Deno.stat(src4);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await utime(dest, statInfo.atime, statInfo.mtime);
    }
}
async function copySymLink(src5, dest, options) {
    await ensureValidCopy(src5, dest, options);
    const originSrcFilePath = await Deno.readLink(src5);
    const type26 = getFileInfoType(await Deno.lstat(src5));
    if (isWindows) {
        await Deno.symlink(originSrcFilePath, dest, {
            type: type26 === "dir" ? "dir" : "file"
        });
    } else {
        await Deno.symlink(originSrcFilePath, dest);
    }
    if (options.preserveTimestamps) {
        const statInfo = await Deno.lstat(src5);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await utime(dest, statInfo.atime, statInfo.mtime);
    }
}
async function copyDir(src6, dest, options) {
    const destStat = await ensureValidCopy(src6, dest, {
        ...options,
        isFolder: true
    });
    if (!destStat) {
        await ensureDir(dest);
    }
    if (options.preserveTimestamps) {
        const srcStatInfo = await Deno.stat(src6);
        assert(srcStatInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(srcStatInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await utime(dest, srcStatInfo.atime, srcStatInfo.mtime);
    }
    for await (const entry of Deno.readDir(src6)){
        const srcPath = join3(src6, entry.name);
        const destPath = join3(dest, basename2(srcPath));
        if (entry.isSymlink) {
            await copySymLink(srcPath, destPath, options);
        } else if (entry.isDirectory) {
            await copyDir(srcPath, destPath, options);
        } else if (entry.isFile) {
            await copyFile(srcPath, destPath, options);
        }
    }
}
async function copy1(src7, dest, options = {}) {
    src7 = resolve2(src7);
    dest = resolve2(dest);
    if (src7 === dest) {
        throw new Error("Source and destination cannot be the same.");
    }
    const srcStat = await Deno.lstat(src7);
    if (srcStat.isDirectory && isSubdir(src7, dest)) {
        throw new Error(`Cannot copy '${src7}' to a subdirectory of itself, '${dest}'.`);
    }
    if (srcStat.isSymlink) {
        await copySymLink(src7, dest, options);
    } else if (srcStat.isDirectory) {
        await copyDir(src7, dest, options);
    } else if (srcStat.isFile) {
        await copyFile(src7, dest, options);
    }
}
var EOL;
(function(EOL1) {
    EOL1["LF"] = "\n";
    EOL1["CRLF"] = "\r\n";
})(EOL || (EOL = {}));
class YAMLError extends Error {
    constructor(message = "(unknown reason)", mark = ""){
        super(`${message} ${mark}`);
        this.mark = mark;
        this.name = this.constructor.name;
    }
    toString(_compact) {
        return `${this.name}: ${this.message} ${this.mark}`;
    }
    mark;
}
function isBoolean(value) {
    return typeof value === "boolean" || value instanceof Boolean;
}
function isObject(value) {
    return value !== null && typeof value === "object";
}
function repeat(str59, count) {
    let result = "";
    for(let cycle = 0; cycle < count; cycle++){
        result += str59;
    }
    return result;
}
function isNegativeZero(i33) {
    return i33 === 0 && Number.NEGATIVE_INFINITY === 1 / i33;
}
class Mark {
    constructor(name80, buffer, position, line, column){
        this.name = name80;
        this.buffer = buffer;
        this.position = position;
        this.line = line;
        this.column = column;
    }
    getSnippet(indent = 4, maxLength = 75) {
        if (!this.buffer) return null;
        let head = "";
        let start = this.position;
        while(start > 0 && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(start - 1)) === -1){
            start -= 1;
            if (this.position - start > maxLength / 2 - 1) {
                head = " ... ";
                start += 5;
                break;
            }
        }
        let tail = "";
        let end = this.position;
        while(end < this.buffer.length && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(end)) === -1){
            end += 1;
            if (end - this.position > maxLength / 2 - 1) {
                tail = " ... ";
                end -= 5;
                break;
            }
        }
        const snippet1 = this.buffer.slice(start, end);
        return `${repeat(" ", indent)}${head}${snippet1}${tail}\n${repeat(" ", indent + this.position - start + head.length)}^`;
    }
    toString(compact) {
        let snippet2, where = "";
        if (this.name) {
            where += `in "${this.name}" `;
        }
        where += `at line ${this.line + 1}, column ${this.column + 1}`;
        if (!compact) {
            snippet2 = this.getSnippet();
            if (snippet2) {
                where += `:\n${snippet2}`;
            }
        }
        return where;
    }
    name;
    buffer;
    position;
    line;
    column;
}
function compileList(schema1, name81, result) {
    const exclude = [];
    for (const includedSchema of schema1.include){
        result = compileList(includedSchema, name81, result);
    }
    for (const currentType of schema1[name81]){
        for(let previousIndex = 0; previousIndex < result.length; previousIndex++){
            const previousType = result[previousIndex];
            if (previousType.tag === currentType.tag && previousType.kind === currentType.kind) {
                exclude.push(previousIndex);
            }
        }
        result.push(currentType);
    }
    return result.filter((_type, index)=>!exclude.includes(index)
    );
}
function compileMap(...typesList) {
    const result = {
        fallback: {},
        mapping: {},
        scalar: {},
        sequence: {}
    };
    for (const types9 of typesList){
        for (const type27 of types9){
            if (type27.kind !== null) {
                result[type27.kind][type27.tag] = result["fallback"][type27.tag] = type27;
            }
        }
    }
    return result;
}
class Schema {
    static SCHEMA_DEFAULT;
    implicit;
    explicit;
    include;
    compiledImplicit;
    compiledExplicit;
    compiledTypeMap;
    constructor(definition){
        this.explicit = definition.explicit || [];
        this.implicit = definition.implicit || [];
        this.include = definition.include || [];
        for (const type28 of this.implicit){
            if (type28.loadKind && type28.loadKind !== "scalar") {
                throw new YAMLError("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
            }
        }
        this.compiledImplicit = compileList(this, "implicit", []);
        this.compiledExplicit = compileList(this, "explicit", []);
        this.compiledTypeMap = compileMap(this.compiledImplicit, this.compiledExplicit);
    }
    extend(definition) {
        return new Schema({
            implicit: [
                ...new Set([
                    ...this.implicit,
                    ...definition?.implicit ?? []
                ]), 
            ],
            explicit: [
                ...new Set([
                    ...this.explicit,
                    ...definition?.explicit ?? []
                ]), 
            ],
            include: [
                ...new Set([
                    ...this.include,
                    ...definition?.include ?? []
                ])
            ]
        });
    }
    static create() {}
}
const DEFAULT_RESOLVE = ()=>true
;
const DEFAULT_CONSTRUCT = (data5)=>data5
;
function checkTagFormat(tag) {
    return tag;
}
class Type1 {
    tag;
    kind = null;
    instanceOf;
    predicate;
    represent;
    defaultStyle;
    styleAliases;
    loadKind;
    constructor(tag, options){
        this.tag = checkTagFormat(tag);
        if (options) {
            this.kind = options.kind;
            this.resolve = options.resolve || DEFAULT_RESOLVE;
            this.construct = options.construct || DEFAULT_CONSTRUCT;
            this.instanceOf = options.instanceOf;
            this.predicate = options.predicate;
            this.represent = options.represent;
            this.defaultStyle = options.defaultStyle;
            this.styleAliases = options.styleAliases;
        }
    }
    resolve = ()=>true
    ;
    construct = (data6)=>data6
    ;
}
const BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary(data7) {
    if (data7 === null) return false;
    let code18;
    let bitlen = 0;
    const max = data7.length;
    const map2 = BASE64_MAP;
    for(let idx = 0; idx < max; idx++){
        code18 = map2.indexOf(data7.charAt(idx));
        if (code18 > 64) continue;
        if (code18 < 0) return false;
        bitlen += 6;
    }
    return bitlen % 8 === 0;
}
function constructYamlBinary(data8) {
    const input = data8.replace(/[\r\n=]/g, "");
    const max = input.length;
    const map3 = BASE64_MAP;
    const result = [];
    let bits = 0;
    for(let idx = 0; idx < max; idx++){
        if (idx % 4 === 0 && idx) {
            result.push(bits >> 16 & 0xff);
            result.push(bits >> 8 & 0xff);
            result.push(bits & 0xff);
        }
        bits = bits << 6 | map3.indexOf(input.charAt(idx));
    }
    const tailbits = max % 4 * 6;
    if (tailbits === 0) {
        result.push(bits >> 16 & 0xff);
        result.push(bits >> 8 & 0xff);
        result.push(bits & 0xff);
    } else if (tailbits === 18) {
        result.push(bits >> 10 & 0xff);
        result.push(bits >> 2 & 0xff);
    } else if (tailbits === 12) {
        result.push(bits >> 4 & 0xff);
    }
    return new Buffer4(new Uint8Array(result));
}
function representYamlBinary(object) {
    const max = object.length;
    const map4 = BASE64_MAP;
    let result = "";
    let bits = 0;
    for(let idx = 0; idx < max; idx++){
        if (idx % 3 === 0 && idx) {
            result += map4[bits >> 18 & 0x3f];
            result += map4[bits >> 12 & 0x3f];
            result += map4[bits >> 6 & 0x3f];
            result += map4[bits & 0x3f];
        }
        bits = (bits << 8) + object[idx];
    }
    const tail = max % 3;
    if (tail === 0) {
        result += map4[bits >> 18 & 0x3f];
        result += map4[bits >> 12 & 0x3f];
        result += map4[bits >> 6 & 0x3f];
        result += map4[bits & 0x3f];
    } else if (tail === 2) {
        result += map4[bits >> 10 & 0x3f];
        result += map4[bits >> 4 & 0x3f];
        result += map4[bits << 2 & 0x3f];
        result += map4[64];
    } else if (tail === 1) {
        result += map4[bits >> 2 & 0x3f];
        result += map4[bits << 4 & 0x3f];
        result += map4[64];
        result += map4[64];
    }
    return result;
}
function isBinary(obj) {
    const buf = new Buffer4();
    try {
        if (0 > buf.readFromSync(obj)) return true;
        return false;
    } catch  {
        return false;
    } finally{
        buf.reset();
    }
}
const binary = new Type1("tag:yaml.org,2002:binary", {
    construct: constructYamlBinary,
    kind: "scalar",
    predicate: isBinary,
    represent: representYamlBinary,
    resolve: resolveYamlBinary
});
function resolveYamlBoolean(data9) {
    const max = data9.length;
    return max === 4 && (data9 === "true" || data9 === "True" || data9 === "TRUE") || max === 5 && (data9 === "false" || data9 === "False" || data9 === "FALSE");
}
function constructYamlBoolean(data10) {
    return data10 === "true" || data10 === "True" || data10 === "TRUE";
}
const bool = new Type1("tag:yaml.org,2002:bool", {
    construct: constructYamlBoolean,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isBoolean,
    represent: {
        lowercase (object) {
            return object ? "true" : "false";
        },
        uppercase (object) {
            return object ? "TRUE" : "FALSE";
        },
        camelcase (object) {
            return object ? "True" : "False";
        }
    },
    resolve: resolveYamlBoolean
});
const YAML_FLOAT_PATTERN = new RegExp("^(?:[-+]?(?:0|[1-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?" + "|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?" + "|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*" + "|[-+]?\\.(?:inf|Inf|INF)" + "|\\.(?:nan|NaN|NAN))$");
function resolveYamlFloat(data11) {
    if (!YAML_FLOAT_PATTERN.test(data11) || data11[data11.length - 1] === "_") {
        return false;
    }
    return true;
}
function constructYamlFloat(data12) {
    let value = data12.replace(/_/g, "").toLowerCase();
    const sign = value[0] === "-" ? -1 : 1;
    const digits1 = [];
    if ("+-".indexOf(value[0]) >= 0) {
        value = value.slice(1);
    }
    if (value === ".inf") {
        return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    }
    if (value === ".nan") {
        return NaN;
    }
    if (value.indexOf(":") >= 0) {
        value.split(":").forEach((v)=>{
            digits1.unshift(parseFloat(v));
        });
        let valueNb = 0.0;
        let base3 = 1;
        digits1.forEach((d)=>{
            valueNb += d * base3;
            base3 *= 60;
        });
        return sign * valueNb;
    }
    return sign * parseFloat(value);
}
const SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
function representYamlFloat(object, style) {
    if (isNaN(object)) {
        switch(style){
            case "lowercase":
                return ".nan";
            case "uppercase":
                return ".NAN";
            case "camelcase":
                return ".NaN";
        }
    } else if (Number.POSITIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return ".inf";
            case "uppercase":
                return ".INF";
            case "camelcase":
                return ".Inf";
        }
    } else if (Number.NEGATIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return "-.inf";
            case "uppercase":
                return "-.INF";
            case "camelcase":
                return "-.Inf";
        }
    } else if (isNegativeZero(object)) {
        return "-0.0";
    }
    const res = object.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
}
function isFloat(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 !== 0 || isNegativeZero(object));
}
const __float = new Type1("tag:yaml.org,2002:float", {
    construct: constructYamlFloat,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isFloat,
    represent: representYamlFloat,
    resolve: resolveYamlFloat
});
function reconstructFunction(code19) {
    const func1 = new Function(`return ${code19}`)();
    if (!(func1 instanceof Function)) {
        throw new TypeError(`Expected function but got ${typeof func1}: ${code19}`);
    }
    return func1;
}
new Type1("tag:yaml.org,2002:js/function", {
    kind: "scalar",
    resolve (data13) {
        if (data13 === null) {
            return false;
        }
        try {
            reconstructFunction(`${data13}`);
            return true;
        } catch (_err) {
            return false;
        }
    },
    construct (data14) {
        return reconstructFunction(data14);
    },
    predicate (object) {
        return object instanceof Function;
    },
    represent (object) {
        return object.toString();
    }
});
function isHexCode(c) {
    return 0x30 <= c && c <= 0x39 || 0x41 <= c && c <= 0x46 || 0x61 <= c && c <= 0x66;
}
function isOctCode(c) {
    return 0x30 <= c && c <= 0x37;
}
function isDecCode(c) {
    return 0x30 <= c && c <= 0x39;
}
function resolveYamlInteger(data15) {
    const max = data15.length;
    let index = 0;
    let hasDigits = false;
    if (!max) return false;
    let ch = data15[index];
    if (ch === "-" || ch === "+") {
        ch = data15[++index];
    }
    if (ch === "0") {
        if (index + 1 === max) return true;
        ch = data15[++index];
        if (ch === "b") {
            index++;
            for(; index < max; index++){
                ch = data15[index];
                if (ch === "_") continue;
                if (ch !== "0" && ch !== "1") return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        if (ch === "x") {
            index++;
            for(; index < max; index++){
                ch = data15[index];
                if (ch === "_") continue;
                if (!isHexCode(data15.charCodeAt(index))) return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        for(; index < max; index++){
            ch = data15[index];
            if (ch === "_") continue;
            if (!isOctCode(data15.charCodeAt(index))) return false;
            hasDigits = true;
        }
        return hasDigits && ch !== "_";
    }
    if (ch === "_") return false;
    for(; index < max; index++){
        ch = data15[index];
        if (ch === "_") continue;
        if (ch === ":") break;
        if (!isDecCode(data15.charCodeAt(index))) {
            return false;
        }
        hasDigits = true;
    }
    if (!hasDigits || ch === "_") return false;
    if (ch !== ":") return true;
    return /^(:[0-5]?[0-9])+$/.test(data15.slice(index));
}
function constructYamlInteger(data16) {
    let value = data16;
    const digits2 = [];
    if (value.indexOf("_") !== -1) {
        value = value.replace(/_/g, "");
    }
    let sign = 1;
    let ch = value[0];
    if (ch === "-" || ch === "+") {
        if (ch === "-") sign = -1;
        value = value.slice(1);
        ch = value[0];
    }
    if (value === "0") return 0;
    if (ch === "0") {
        if (value[1] === "b") return sign * parseInt(value.slice(2), 2);
        if (value[1] === "x") return sign * parseInt(value, 16);
        return sign * parseInt(value, 8);
    }
    if (value.indexOf(":") !== -1) {
        value.split(":").forEach((v)=>{
            digits2.unshift(parseInt(v, 10));
        });
        let valueInt = 0;
        let base4 = 1;
        digits2.forEach((d)=>{
            valueInt += d * base4;
            base4 *= 60;
        });
        return sign * valueInt;
    }
    return sign * parseInt(value, 10);
}
function isInteger(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && object % 1 === 0 && !isNegativeZero(object);
}
const __int = new Type1("tag:yaml.org,2002:int", {
    construct: constructYamlInteger,
    defaultStyle: "decimal",
    kind: "scalar",
    predicate: isInteger,
    represent: {
        binary (obj) {
            return obj >= 0 ? `0b${obj.toString(2)}` : `-0b${obj.toString(2).slice(1)}`;
        },
        octal (obj) {
            return obj >= 0 ? `0${obj.toString(8)}` : `-0${obj.toString(8).slice(1)}`;
        },
        decimal (obj) {
            return obj.toString(10);
        },
        hexadecimal (obj) {
            return obj >= 0 ? `0x${obj.toString(16).toUpperCase()}` : `-0x${obj.toString(16).toUpperCase().slice(1)}`;
        }
    },
    resolve: resolveYamlInteger,
    styleAliases: {
        binary: [
            2,
            "bin"
        ],
        decimal: [
            10,
            "dec"
        ],
        hexadecimal: [
            16,
            "hex"
        ],
        octal: [
            8,
            "oct"
        ]
    }
});
const map = new Type1("tag:yaml.org,2002:map", {
    construct (data17) {
        return data17 !== null ? data17 : {};
    },
    kind: "mapping"
});
function resolveYamlMerge(data18) {
    return data18 === "<<" || data18 === null;
}
const merge = new Type1("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
});
function resolveYamlNull(data19) {
    const max = data19.length;
    return max === 1 && data19 === "~" || max === 4 && (data19 === "null" || data19 === "Null" || data19 === "NULL");
}
function constructYamlNull() {
    return null;
}
function isNull(object) {
    return object === null;
}
const nil = new Type1("tag:yaml.org,2002:null", {
    construct: constructYamlNull,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isNull,
    represent: {
        canonical () {
            return "~";
        },
        lowercase () {
            return "null";
        },
        uppercase () {
            return "NULL";
        },
        camelcase () {
            return "Null";
        }
    },
    resolve: resolveYamlNull
});
const { hasOwn  } = Object;
const _toString = Object.prototype.toString;
function resolveYamlOmap(data20) {
    const objectKeys = [];
    let pairKey = "";
    let pairHasKey = false;
    for (const pair of data20){
        pairHasKey = false;
        if (_toString.call(pair) !== "[object Object]") return false;
        for(pairKey in pair){
            if (hasOwn(pair, pairKey)) {
                if (!pairHasKey) pairHasKey = true;
                else return false;
            }
        }
        if (!pairHasKey) return false;
        if (objectKeys.indexOf(pairKey) === -1) objectKeys.push(pairKey);
        else return false;
    }
    return true;
}
function constructYamlOmap(data21) {
    return data21 !== null ? data21 : [];
}
const omap = new Type1("tag:yaml.org,2002:omap", {
    construct: constructYamlOmap,
    kind: "sequence",
    resolve: resolveYamlOmap
});
const _toString1 = Object.prototype.toString;
function resolveYamlPairs(data22) {
    const result = Array.from({
        length: data22.length
    });
    for(let index = 0; index < data22.length; index++){
        const pair = data22[index];
        if (_toString1.call(pair) !== "[object Object]") return false;
        const keys1 = Object.keys(pair);
        if (keys1.length !== 1) return false;
        result[index] = [
            keys1[0],
            pair[keys1[0]]
        ];
    }
    return true;
}
function constructYamlPairs(data23) {
    if (data23 === null) return [];
    const result = Array.from({
        length: data23.length
    });
    for(let index = 0; index < data23.length; index += 1){
        const pair = data23[index];
        const keys2 = Object.keys(pair);
        result[index] = [
            keys2[0],
            pair[keys2[0]]
        ];
    }
    return result;
}
const pairs = new Type1("tag:yaml.org,2002:pairs", {
    construct: constructYamlPairs,
    kind: "sequence",
    resolve: resolveYamlPairs
});
const REGEXP = /^\/(?<regexp>[\s\S]+)\/(?<modifiers>[gismuy]*)$/;
const regexp = new Type1("tag:yaml.org,2002:js/regexp", {
    kind: "scalar",
    resolve (data24) {
        if (data24 === null || !data24.length) {
            return false;
        }
        const regexp1 = `${data24}`;
        if (regexp1.charAt(0) === "/") {
            if (!REGEXP.test(data24)) {
                return false;
            }
            const modifiers = [
                ...regexp1.match(REGEXP)?.groups?.modifiers ?? ""
            ];
            if (new Set(modifiers).size < modifiers.length) {
                return false;
            }
        }
        return true;
    },
    construct (data25) {
        const { regexp: regexp2 = `${data25}` , modifiers =""  } = `${data25}`.match(REGEXP)?.groups ?? {};
        return new RegExp(regexp2, modifiers);
    },
    predicate (object) {
        return object instanceof RegExp;
    },
    represent (object) {
        return object.toString();
    }
});
const seq = new Type1("tag:yaml.org,2002:seq", {
    construct (data26) {
        return data26 !== null ? data26 : [];
    },
    kind: "sequence"
});
const { hasOwn: hasOwn1  } = Object;
function resolveYamlSet(data27) {
    if (data27 === null) return true;
    for(const key in data27){
        if (hasOwn1(data27, key)) {
            if (data27[key] !== null) return false;
        }
    }
    return true;
}
function constructYamlSet(data28) {
    return data28 !== null ? data28 : {};
}
const set = new Type1("tag:yaml.org,2002:set", {
    construct: constructYamlSet,
    kind: "mapping",
    resolve: resolveYamlSet
});
const str = new Type1("tag:yaml.org,2002:str", {
    construct (data29) {
        return data29 !== null ? data29 : "";
    },
    kind: "scalar"
});
const YAML_DATE_REGEXP = new RegExp("^([0-9][0-9][0-9][0-9])" + "-([0-9][0-9])" + "-([0-9][0-9])$");
const YAML_TIMESTAMP_REGEXP = new RegExp("^([0-9][0-9][0-9][0-9])" + "-([0-9][0-9]?)" + "-([0-9][0-9]?)" + "(?:[Tt]|[ \\t]+)" + "([0-9][0-9]?)" + ":([0-9][0-9])" + ":([0-9][0-9])" + "(?:\\.([0-9]*))?" + "(?:[ \\t]*(Z|([-+])([0-9][0-9]?)" + "(?::([0-9][0-9]))?))?$");
function resolveYamlTimestamp(data30) {
    if (data30 === null) return false;
    if (YAML_DATE_REGEXP.exec(data30) !== null) return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data30) !== null) return true;
    return false;
}
function constructYamlTimestamp(data31) {
    let match = YAML_DATE_REGEXP.exec(data31);
    if (match === null) match = YAML_TIMESTAMP_REGEXP.exec(data31);
    if (match === null) throw new Error("Date resolve error");
    const year = +match[1];
    const month = +match[2] - 1;
    const day = +match[3];
    if (!match[4]) {
        return new Date(Date.UTC(year, month, day));
    }
    const hour = +match[4];
    const minute = +match[5];
    const second = +match[6];
    let fraction = 0;
    if (match[7]) {
        let partFraction = match[7].slice(0, 3);
        while(partFraction.length < 3){
            partFraction += "0";
        }
        fraction = +partFraction;
    }
    let delta = null;
    if (match[9]) {
        const tzHour = +match[10];
        const tzMinute = +(match[11] || 0);
        delta = (tzHour * 60 + tzMinute) * 60000;
        if (match[9] === "-") delta = -delta;
    }
    const date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
    if (delta) date.setTime(date.getTime() - delta);
    return date;
}
function representYamlTimestamp(date) {
    return date.toISOString();
}
const timestamp = new Type1("tag:yaml.org,2002:timestamp", {
    construct: constructYamlTimestamp,
    instanceOf: Date,
    kind: "scalar",
    represent: representYamlTimestamp,
    resolve: resolveYamlTimestamp
});
const undefinedType = new Type1("tag:yaml.org,2002:js/undefined", {
    kind: "scalar",
    resolve () {
        return true;
    },
    construct () {
        return undefined;
    },
    predicate (object) {
        return typeof object === "undefined";
    },
    represent () {
        return "";
    }
});
const failsafe = new Schema({
    explicit: [
        str,
        seq,
        map
    ]
});
const json = new Schema({
    implicit: [
        nil,
        bool,
        __int,
        __float
    ],
    include: [
        failsafe
    ]
});
const core = new Schema({
    include: [
        json
    ]
});
const def = new Schema({
    explicit: [
        binary,
        omap,
        pairs,
        set
    ],
    implicit: [
        timestamp,
        merge
    ],
    include: [
        core
    ]
});
new Schema({
    explicit: [
        regexp,
        undefinedType
    ],
    include: [
        def
    ]
});
class State {
    constructor(schema2 = def){
        this.schema = schema2;
    }
    schema;
}
class LoaderState extends State {
    documents;
    length;
    lineIndent;
    lineStart;
    position;
    line;
    filename;
    onWarning;
    legacy;
    json;
    listener;
    implicitTypes;
    typeMap;
    version;
    checkLineBreaks;
    tagMap;
    anchorMap;
    tag;
    anchor;
    kind;
    result;
    constructor(input, { filename , schema: schema3 , onWarning , legacy =false , json: json2 = false , listener =null  }){
        super(schema3);
        this.input = input;
        this.documents = [];
        this.lineIndent = 0;
        this.lineStart = 0;
        this.position = 0;
        this.line = 0;
        this.result = "";
        this.filename = filename;
        this.onWarning = onWarning;
        this.legacy = legacy;
        this.json = json2;
        this.listener = listener;
        this.implicitTypes = this.schema.compiledImplicit;
        this.typeMap = this.schema.compiledTypeMap;
        this.length = input.length;
    }
    input;
}
const { hasOwn: hasOwn2  } = Object;
const CONTEXT_BLOCK_IN = 3;
const CONTEXT_BLOCK_OUT = 4;
const CHOMPING_STRIP = 2;
const CHOMPING_KEEP = 3;
const PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
const PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
const PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
const PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
const PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
function _class(obj) {
    return Object.prototype.toString.call(obj);
}
function isEOL(c) {
    return c === 0x0a || c === 0x0d;
}
function isWhiteSpace(c) {
    return c === 0x09 || c === 0x20;
}
function isWsOrEol(c) {
    return c === 0x09 || c === 0x20 || c === 0x0a || c === 0x0d;
}
function isFlowIndicator(c) {
    return c === 0x2c || c === 0x5b || c === 0x5d || c === 0x7b || c === 0x7d;
}
function fromHexCode(c) {
    if (0x30 <= c && c <= 0x39) {
        return c - 0x30;
    }
    const lc = c | 0x20;
    if (0x61 <= lc && lc <= 0x66) {
        return lc - 0x61 + 10;
    }
    return -1;
}
function escapedHexLen(c) {
    if (c === 0x78) {
        return 2;
    }
    if (c === 0x75) {
        return 4;
    }
    if (c === 0x55) {
        return 8;
    }
    return 0;
}
function fromDecimalCode(c) {
    if (0x30 <= c && c <= 0x39) {
        return c - 0x30;
    }
    return -1;
}
function simpleEscapeSequence(c) {
    return c === 0x30 ? "\x00" : c === 0x61 ? "\x07" : c === 0x62 ? "\x08" : c === 0x74 ? "\x09" : c === 0x09 ? "\x09" : c === 0x6e ? "\x0A" : c === 0x76 ? "\x0B" : c === 0x66 ? "\x0C" : c === 0x72 ? "\x0D" : c === 0x65 ? "\x1B" : c === 0x20 ? " " : c === 0x22 ? "\x22" : c === 0x2f ? "/" : c === 0x5c ? "\x5C" : c === 0x4e ? "\x85" : c === 0x5f ? "\xA0" : c === 0x4c ? "\u2028" : c === 0x50 ? "\u2029" : "";
}
function charFromCodepoint(c) {
    if (c <= 0xffff) {
        return String.fromCharCode(c);
    }
    return String.fromCharCode((c - 0x010000 >> 10) + 0xd800, (c - 0x010000 & 0x03ff) + 0xdc00);
}
const simpleEscapeCheck = Array.from({
    length: 256
});
const simpleEscapeMap = Array.from({
    length: 256
});
for(let i67 = 0; i67 < 256; i67++){
    simpleEscapeCheck[i67] = simpleEscapeSequence(i67) ? 1 : 0;
    simpleEscapeMap[i67] = simpleEscapeSequence(i67);
}
function generateError(state1, message) {
    return new YAMLError(message, new Mark(state1.filename, state1.input, state1.position, state1.line, state1.position - state1.lineStart));
}
function throwError(state2, message) {
    throw generateError(state2, message);
}
function throwWarning(state3, message) {
    if (state3.onWarning) {
        state3.onWarning.call(null, generateError(state3, message));
    }
}
const directiveHandlers = {
    YAML (state4, _name, ...args) {
        if (state4.version !== null) {
            return throwError(state4, "duplication of %YAML directive");
        }
        if (args.length !== 1) {
            return throwError(state4, "YAML directive accepts exactly one argument");
        }
        const match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
        if (match === null) {
            return throwError(state4, "ill-formed argument of the YAML directive");
        }
        const major = parseInt(match[1], 10);
        const minor = parseInt(match[2], 10);
        if (major !== 1) {
            return throwError(state4, "unacceptable YAML version of the document");
        }
        state4.version = args[0];
        state4.checkLineBreaks = minor < 2;
        if (minor !== 1 && minor !== 2) {
            return throwWarning(state4, "unsupported YAML version of the document");
        }
    },
    TAG (state5, _name, ...args) {
        if (args.length !== 2) {
            return throwError(state5, "TAG directive accepts exactly two arguments");
        }
        const handle = args[0];
        const prefix = args[1];
        if (!PATTERN_TAG_HANDLE.test(handle)) {
            return throwError(state5, "ill-formed tag handle (first argument) of the TAG directive");
        }
        if (state5.tagMap && hasOwn2(state5.tagMap, handle)) {
            return throwError(state5, `there is a previously declared suffix for "${handle}" tag handle`);
        }
        if (!PATTERN_TAG_URI.test(prefix)) {
            return throwError(state5, "ill-formed tag prefix (second argument) of the TAG directive");
        }
        if (typeof state5.tagMap === "undefined") {
            state5.tagMap = {};
        }
        state5.tagMap[handle] = prefix;
    }
};
function captureSegment(state6, start, end, checkJson) {
    let result;
    if (start < end) {
        result = state6.input.slice(start, end);
        if (checkJson) {
            for(let position = 0, length = result.length; position < length; position++){
                const character = result.charCodeAt(position);
                if (!(character === 0x09 || 0x20 <= character && character <= 0x10ffff)) {
                    return throwError(state6, "expected valid JSON character");
                }
            }
        } else if (PATTERN_NON_PRINTABLE.test(result)) {
            return throwError(state6, "the stream contains non-printable characters");
        }
        state6.result += result;
    }
}
function mergeMappings(state7, destination, source, overridableKeys) {
    if (!isObject(source)) {
        return throwError(state7, "cannot merge mappings; the provided source object is unacceptable");
    }
    const keys3 = Object.keys(source);
    for(let i1 = 0, len1 = keys3.length; i1 < len1; i1++){
        const key = keys3[i1];
        if (!hasOwn2(destination, key)) {
            destination[key] = source[key];
            overridableKeys[key] = true;
        }
    }
}
function storeMappingPair(state8, result, overridableKeys, keyTag, keyNode, valueNode, startLine, startPos) {
    if (Array.isArray(keyNode)) {
        keyNode = Array.prototype.slice.call(keyNode);
        for(let index = 0, quantity = keyNode.length; index < quantity; index++){
            if (Array.isArray(keyNode[index])) {
                return throwError(state8, "nested arrays are not supported inside keys");
            }
            if (typeof keyNode === "object" && _class(keyNode[index]) === "[object Object]") {
                keyNode[index] = "[object Object]";
            }
        }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
        keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (result === null) {
        result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
        if (Array.isArray(valueNode)) {
            for(let index = 0, quantity = valueNode.length; index < quantity; index++){
                mergeMappings(state8, result, valueNode[index], overridableKeys);
            }
        } else {
            mergeMappings(state8, result, valueNode, overridableKeys);
        }
    } else {
        if (!state8.json && !hasOwn2(overridableKeys, keyNode) && hasOwn2(result, keyNode)) {
            state8.line = startLine || state8.line;
            state8.position = startPos || state8.position;
            return throwError(state8, "duplicated mapping key");
        }
        result[keyNode] = valueNode;
        delete overridableKeys[keyNode];
    }
    return result;
}
function readLineBreak(state9) {
    const ch = state9.input.charCodeAt(state9.position);
    if (ch === 0x0a) {
        state9.position++;
    } else if (ch === 0x0d) {
        state9.position++;
        if (state9.input.charCodeAt(state9.position) === 0x0a) {
            state9.position++;
        }
    } else {
        return throwError(state9, "a line break is expected");
    }
    state9.line += 1;
    state9.lineStart = state9.position;
}
function skipSeparationSpace(state10, allowComments, checkIndent) {
    let lineBreaks = 0, ch = state10.input.charCodeAt(state10.position);
    while(ch !== 0){
        while(isWhiteSpace(ch)){
            ch = state10.input.charCodeAt(++state10.position);
        }
        if (allowComments && ch === 0x23) {
            do {
                ch = state10.input.charCodeAt(++state10.position);
            }while (ch !== 0x0a && ch !== 0x0d && ch !== 0)
        }
        if (isEOL(ch)) {
            readLineBreak(state10);
            ch = state10.input.charCodeAt(state10.position);
            lineBreaks++;
            state10.lineIndent = 0;
            while(ch === 0x20){
                state10.lineIndent++;
                ch = state10.input.charCodeAt(++state10.position);
            }
        } else {
            break;
        }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state10.lineIndent < checkIndent) {
        throwWarning(state10, "deficient indentation");
    }
    return lineBreaks;
}
function testDocumentSeparator(state11) {
    let _position = state11.position;
    let ch = state11.input.charCodeAt(_position);
    if ((ch === 0x2d || ch === 0x2e) && ch === state11.input.charCodeAt(_position + 1) && ch === state11.input.charCodeAt(_position + 2)) {
        _position += 3;
        ch = state11.input.charCodeAt(_position);
        if (ch === 0 || isWsOrEol(ch)) {
            return true;
        }
    }
    return false;
}
function writeFoldedLines(state12, count) {
    if (count === 1) {
        state12.result += " ";
    } else if (count > 1) {
        state12.result += repeat("\n", count - 1);
    }
}
function readPlainScalar(state13, nodeIndent, withinFlowCollection) {
    const kind = state13.kind;
    const result = state13.result;
    let ch = state13.input.charCodeAt(state13.position);
    if (isWsOrEol(ch) || isFlowIndicator(ch) || ch === 0x23 || ch === 0x26 || ch === 0x2a || ch === 0x21 || ch === 0x7c || ch === 0x3e || ch === 0x27 || ch === 0x22 || ch === 0x25 || ch === 0x40 || ch === 0x60) {
        return false;
    }
    let following;
    if (ch === 0x3f || ch === 0x2d) {
        following = state13.input.charCodeAt(state13.position + 1);
        if (isWsOrEol(following) || withinFlowCollection && isFlowIndicator(following)) {
            return false;
        }
    }
    state13.kind = "scalar";
    state13.result = "";
    let captureEnd, captureStart = captureEnd = state13.position;
    let hasPendingContent = false;
    let line = 0;
    while(ch !== 0){
        if (ch === 0x3a) {
            following = state13.input.charCodeAt(state13.position + 1);
            if (isWsOrEol(following) || withinFlowCollection && isFlowIndicator(following)) {
                break;
            }
        } else if (ch === 0x23) {
            const preceding = state13.input.charCodeAt(state13.position - 1);
            if (isWsOrEol(preceding)) {
                break;
            }
        } else if (state13.position === state13.lineStart && testDocumentSeparator(state13) || withinFlowCollection && isFlowIndicator(ch)) {
            break;
        } else if (isEOL(ch)) {
            line = state13.line;
            const lineStart = state13.lineStart;
            const lineIndent = state13.lineIndent;
            skipSeparationSpace(state13, false, -1);
            if (state13.lineIndent >= nodeIndent) {
                hasPendingContent = true;
                ch = state13.input.charCodeAt(state13.position);
                continue;
            } else {
                state13.position = captureEnd;
                state13.line = line;
                state13.lineStart = lineStart;
                state13.lineIndent = lineIndent;
                break;
            }
        }
        if (hasPendingContent) {
            captureSegment(state13, captureStart, captureEnd, false);
            writeFoldedLines(state13, state13.line - line);
            captureStart = captureEnd = state13.position;
            hasPendingContent = false;
        }
        if (!isWhiteSpace(ch)) {
            captureEnd = state13.position + 1;
        }
        ch = state13.input.charCodeAt(++state13.position);
    }
    captureSegment(state13, captureStart, captureEnd, false);
    if (state13.result) {
        return true;
    }
    state13.kind = kind;
    state13.result = result;
    return false;
}
function readSingleQuotedScalar(state14, nodeIndent) {
    let ch, captureStart, captureEnd;
    ch = state14.input.charCodeAt(state14.position);
    if (ch !== 0x27) {
        return false;
    }
    state14.kind = "scalar";
    state14.result = "";
    state14.position++;
    captureStart = captureEnd = state14.position;
    while((ch = state14.input.charCodeAt(state14.position)) !== 0){
        if (ch === 0x27) {
            captureSegment(state14, captureStart, state14.position, true);
            ch = state14.input.charCodeAt(++state14.position);
            if (ch === 0x27) {
                captureStart = state14.position;
                state14.position++;
                captureEnd = state14.position;
            } else {
                return true;
            }
        } else if (isEOL(ch)) {
            captureSegment(state14, captureStart, captureEnd, true);
            writeFoldedLines(state14, skipSeparationSpace(state14, false, nodeIndent));
            captureStart = captureEnd = state14.position;
        } else if (state14.position === state14.lineStart && testDocumentSeparator(state14)) {
            return throwError(state14, "unexpected end of the document within a single quoted scalar");
        } else {
            state14.position++;
            captureEnd = state14.position;
        }
    }
    return throwError(state14, "unexpected end of the stream within a single quoted scalar");
}
function readDoubleQuotedScalar(state15, nodeIndent) {
    let ch = state15.input.charCodeAt(state15.position);
    if (ch !== 0x22) {
        return false;
    }
    state15.kind = "scalar";
    state15.result = "";
    state15.position++;
    let captureEnd, captureStart = captureEnd = state15.position;
    let tmp;
    while((ch = state15.input.charCodeAt(state15.position)) !== 0){
        if (ch === 0x22) {
            captureSegment(state15, captureStart, state15.position, true);
            state15.position++;
            return true;
        }
        if (ch === 0x5c) {
            captureSegment(state15, captureStart, state15.position, true);
            ch = state15.input.charCodeAt(++state15.position);
            if (isEOL(ch)) {
                skipSeparationSpace(state15, false, nodeIndent);
            } else if (ch < 256 && simpleEscapeCheck[ch]) {
                state15.result += simpleEscapeMap[ch];
                state15.position++;
            } else if ((tmp = escapedHexLen(ch)) > 0) {
                let hexLength = tmp;
                let hexResult = 0;
                for(; hexLength > 0; hexLength--){
                    ch = state15.input.charCodeAt(++state15.position);
                    if ((tmp = fromHexCode(ch)) >= 0) {
                        hexResult = (hexResult << 4) + tmp;
                    } else {
                        return throwError(state15, "expected hexadecimal character");
                    }
                }
                state15.result += charFromCodepoint(hexResult);
                state15.position++;
            } else {
                return throwError(state15, "unknown escape sequence");
            }
            captureStart = captureEnd = state15.position;
        } else if (isEOL(ch)) {
            captureSegment(state15, captureStart, captureEnd, true);
            writeFoldedLines(state15, skipSeparationSpace(state15, false, nodeIndent));
            captureStart = captureEnd = state15.position;
        } else if (state15.position === state15.lineStart && testDocumentSeparator(state15)) {
            return throwError(state15, "unexpected end of the document within a double quoted scalar");
        } else {
            state15.position++;
            captureEnd = state15.position;
        }
    }
    return throwError(state15, "unexpected end of the stream within a double quoted scalar");
}
function readFlowCollection(state16, nodeIndent) {
    let ch = state16.input.charCodeAt(state16.position);
    let terminator;
    let isMapping = true;
    let result = {};
    if (ch === 0x5b) {
        terminator = 0x5d;
        isMapping = false;
        result = [];
    } else if (ch === 0x7b) {
        terminator = 0x7d;
    } else {
        return false;
    }
    if (state16.anchor !== null && typeof state16.anchor != "undefined" && typeof state16.anchorMap != "undefined") {
        state16.anchorMap[state16.anchor] = result;
    }
    ch = state16.input.charCodeAt(++state16.position);
    const tag = state16.tag, anchor = state16.anchor;
    let readNext = true;
    let valueNode, keyNode, keyTag = keyNode = valueNode = null, isExplicitPair, isPair = isExplicitPair = false;
    let following = 0, line = 0;
    const overridableKeys = {};
    while(ch !== 0){
        skipSeparationSpace(state16, true, nodeIndent);
        ch = state16.input.charCodeAt(state16.position);
        if (ch === terminator) {
            state16.position++;
            state16.tag = tag;
            state16.anchor = anchor;
            state16.kind = isMapping ? "mapping" : "sequence";
            state16.result = result;
            return true;
        }
        if (!readNext) {
            return throwError(state16, "missed comma between flow collection entries");
        }
        keyTag = keyNode = valueNode = null;
        isPair = isExplicitPair = false;
        if (ch === 0x3f) {
            following = state16.input.charCodeAt(state16.position + 1);
            if (isWsOrEol(following)) {
                isPair = isExplicitPair = true;
                state16.position++;
                skipSeparationSpace(state16, true, nodeIndent);
            }
        }
        line = state16.line;
        composeNode(state16, nodeIndent, 1, false, true);
        keyTag = state16.tag || null;
        keyNode = state16.result;
        skipSeparationSpace(state16, true, nodeIndent);
        ch = state16.input.charCodeAt(state16.position);
        if ((isExplicitPair || state16.line === line) && ch === 0x3a) {
            isPair = true;
            ch = state16.input.charCodeAt(++state16.position);
            skipSeparationSpace(state16, true, nodeIndent);
            composeNode(state16, nodeIndent, 1, false, true);
            valueNode = state16.result;
        }
        if (isMapping) {
            storeMappingPair(state16, result, overridableKeys, keyTag, keyNode, valueNode);
        } else if (isPair) {
            result.push(storeMappingPair(state16, null, overridableKeys, keyTag, keyNode, valueNode));
        } else {
            result.push(keyNode);
        }
        skipSeparationSpace(state16, true, nodeIndent);
        ch = state16.input.charCodeAt(state16.position);
        if (ch === 0x2c) {
            readNext = true;
            ch = state16.input.charCodeAt(++state16.position);
        } else {
            readNext = false;
        }
    }
    return throwError(state16, "unexpected end of the stream within a flow collection");
}
function readBlockScalar(state17, nodeIndent) {
    let chomping = 1, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false;
    let ch = state17.input.charCodeAt(state17.position);
    let folding = false;
    if (ch === 0x7c) {
        folding = false;
    } else if (ch === 0x3e) {
        folding = true;
    } else {
        return false;
    }
    state17.kind = "scalar";
    state17.result = "";
    let tmp = 0;
    while(ch !== 0){
        ch = state17.input.charCodeAt(++state17.position);
        if (ch === 0x2b || ch === 0x2d) {
            if (1 === chomping) {
                chomping = ch === 0x2b ? CHOMPING_KEEP : CHOMPING_STRIP;
            } else {
                return throwError(state17, "repeat of a chomping mode identifier");
            }
        } else if ((tmp = fromDecimalCode(ch)) >= 0) {
            if (tmp === 0) {
                return throwError(state17, "bad explicit indentation width of a block scalar; it cannot be less than one");
            } else if (!detectedIndent) {
                textIndent = nodeIndent + tmp - 1;
                detectedIndent = true;
            } else {
                return throwError(state17, "repeat of an indentation width identifier");
            }
        } else {
            break;
        }
    }
    if (isWhiteSpace(ch)) {
        do {
            ch = state17.input.charCodeAt(++state17.position);
        }while (isWhiteSpace(ch))
        if (ch === 0x23) {
            do {
                ch = state17.input.charCodeAt(++state17.position);
            }while (!isEOL(ch) && ch !== 0)
        }
    }
    while(ch !== 0){
        readLineBreak(state17);
        state17.lineIndent = 0;
        ch = state17.input.charCodeAt(state17.position);
        while((!detectedIndent || state17.lineIndent < textIndent) && ch === 0x20){
            state17.lineIndent++;
            ch = state17.input.charCodeAt(++state17.position);
        }
        if (!detectedIndent && state17.lineIndent > textIndent) {
            textIndent = state17.lineIndent;
        }
        if (isEOL(ch)) {
            emptyLines++;
            continue;
        }
        if (state17.lineIndent < textIndent) {
            if (chomping === 3) {
                state17.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (chomping === 1) {
                if (didReadContent) {
                    state17.result += "\n";
                }
            }
            break;
        }
        if (folding) {
            if (isWhiteSpace(ch)) {
                atMoreIndented = true;
                state17.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (atMoreIndented) {
                atMoreIndented = false;
                state17.result += repeat("\n", emptyLines + 1);
            } else if (emptyLines === 0) {
                if (didReadContent) {
                    state17.result += " ";
                }
            } else {
                state17.result += repeat("\n", emptyLines);
            }
        } else {
            state17.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        }
        didReadContent = true;
        detectedIndent = true;
        emptyLines = 0;
        const captureStart = state17.position;
        while(!isEOL(ch) && ch !== 0){
            ch = state17.input.charCodeAt(++state17.position);
        }
        captureSegment(state17, captureStart, state17.position, false);
    }
    return true;
}
function readBlockSequence(state18, nodeIndent) {
    let line, following, detected = false, ch;
    const tag = state18.tag, anchor = state18.anchor, result = [];
    if (state18.anchor !== null && typeof state18.anchor !== "undefined" && typeof state18.anchorMap !== "undefined") {
        state18.anchorMap[state18.anchor] = result;
    }
    ch = state18.input.charCodeAt(state18.position);
    while(ch !== 0){
        if (ch !== 0x2d) {
            break;
        }
        following = state18.input.charCodeAt(state18.position + 1);
        if (!isWsOrEol(following)) {
            break;
        }
        detected = true;
        state18.position++;
        if (skipSeparationSpace(state18, true, -1)) {
            if (state18.lineIndent <= nodeIndent) {
                result.push(null);
                ch = state18.input.charCodeAt(state18.position);
                continue;
            }
        }
        line = state18.line;
        composeNode(state18, nodeIndent, 3, false, true);
        result.push(state18.result);
        skipSeparationSpace(state18, true, -1);
        ch = state18.input.charCodeAt(state18.position);
        if ((state18.line === line || state18.lineIndent > nodeIndent) && ch !== 0) {
            return throwError(state18, "bad indentation of a sequence entry");
        } else if (state18.lineIndent < nodeIndent) {
            break;
        }
    }
    if (detected) {
        state18.tag = tag;
        state18.anchor = anchor;
        state18.kind = "sequence";
        state18.result = result;
        return true;
    }
    return false;
}
function readBlockMapping(state19, nodeIndent, flowIndent) {
    const tag = state19.tag, anchor = state19.anchor, result = {}, overridableKeys = {};
    let following, allowCompact = false, line, pos, keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state19.anchor !== null && typeof state19.anchor !== "undefined" && typeof state19.anchorMap !== "undefined") {
        state19.anchorMap[state19.anchor] = result;
    }
    ch = state19.input.charCodeAt(state19.position);
    while(ch !== 0){
        following = state19.input.charCodeAt(state19.position + 1);
        line = state19.line;
        pos = state19.position;
        if ((ch === 0x3f || ch === 0x3a) && isWsOrEol(following)) {
            if (ch === 0x3f) {
                if (atExplicitKey) {
                    storeMappingPair(state19, result, overridableKeys, keyTag, keyNode, null);
                    keyTag = keyNode = valueNode = null;
                }
                detected = true;
                atExplicitKey = true;
                allowCompact = true;
            } else if (atExplicitKey) {
                atExplicitKey = false;
                allowCompact = true;
            } else {
                return throwError(state19, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
            }
            state19.position += 1;
            ch = following;
        } else if (composeNode(state19, flowIndent, 2, false, true)) {
            if (state19.line === line) {
                ch = state19.input.charCodeAt(state19.position);
                while(isWhiteSpace(ch)){
                    ch = state19.input.charCodeAt(++state19.position);
                }
                if (ch === 0x3a) {
                    ch = state19.input.charCodeAt(++state19.position);
                    if (!isWsOrEol(ch)) {
                        return throwError(state19, "a whitespace character is expected after the key-value separator within a block mapping");
                    }
                    if (atExplicitKey) {
                        storeMappingPair(state19, result, overridableKeys, keyTag, keyNode, null);
                        keyTag = keyNode = valueNode = null;
                    }
                    detected = true;
                    atExplicitKey = false;
                    allowCompact = false;
                    keyTag = state19.tag;
                    keyNode = state19.result;
                } else if (detected) {
                    return throwError(state19, "can not read an implicit mapping pair; a colon is missed");
                } else {
                    state19.tag = tag;
                    state19.anchor = anchor;
                    return true;
                }
            } else if (detected) {
                return throwError(state19, "can not read a block mapping entry; a multiline key may not be an implicit key");
            } else {
                state19.tag = tag;
                state19.anchor = anchor;
                return true;
            }
        } else {
            break;
        }
        if (state19.line === line || state19.lineIndent > nodeIndent) {
            if (composeNode(state19, nodeIndent, 4, true, allowCompact)) {
                if (atExplicitKey) {
                    keyNode = state19.result;
                } else {
                    valueNode = state19.result;
                }
            }
            if (!atExplicitKey) {
                storeMappingPair(state19, result, overridableKeys, keyTag, keyNode, valueNode, line, pos);
                keyTag = keyNode = valueNode = null;
            }
            skipSeparationSpace(state19, true, -1);
            ch = state19.input.charCodeAt(state19.position);
        }
        if (state19.lineIndent > nodeIndent && ch !== 0) {
            return throwError(state19, "bad indentation of a mapping entry");
        } else if (state19.lineIndent < nodeIndent) {
            break;
        }
    }
    if (atExplicitKey) {
        storeMappingPair(state19, result, overridableKeys, keyTag, keyNode, null);
    }
    if (detected) {
        state19.tag = tag;
        state19.anchor = anchor;
        state19.kind = "mapping";
        state19.result = result;
    }
    return detected;
}
function readTagProperty(state20) {
    let position, isVerbatim = false, isNamed = false, tagHandle = "", tagName, ch;
    ch = state20.input.charCodeAt(state20.position);
    if (ch !== 0x21) return false;
    if (state20.tag !== null) {
        return throwError(state20, "duplication of a tag property");
    }
    ch = state20.input.charCodeAt(++state20.position);
    if (ch === 0x3c) {
        isVerbatim = true;
        ch = state20.input.charCodeAt(++state20.position);
    } else if (ch === 0x21) {
        isNamed = true;
        tagHandle = "!!";
        ch = state20.input.charCodeAt(++state20.position);
    } else {
        tagHandle = "!";
    }
    position = state20.position;
    if (isVerbatim) {
        do {
            ch = state20.input.charCodeAt(++state20.position);
        }while (ch !== 0 && ch !== 0x3e)
        if (state20.position < state20.length) {
            tagName = state20.input.slice(position, state20.position);
            ch = state20.input.charCodeAt(++state20.position);
        } else {
            return throwError(state20, "unexpected end of the stream within a verbatim tag");
        }
    } else {
        while(ch !== 0 && !isWsOrEol(ch)){
            if (ch === 0x21) {
                if (!isNamed) {
                    tagHandle = state20.input.slice(position - 1, state20.position + 1);
                    if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
                        return throwError(state20, "named tag handle cannot contain such characters");
                    }
                    isNamed = true;
                    position = state20.position + 1;
                } else {
                    return throwError(state20, "tag suffix cannot contain exclamation marks");
                }
            }
            ch = state20.input.charCodeAt(++state20.position);
        }
        tagName = state20.input.slice(position, state20.position);
        if (PATTERN_FLOW_INDICATORS.test(tagName)) {
            return throwError(state20, "tag suffix cannot contain flow indicator characters");
        }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
        return throwError(state20, `tag name cannot contain such characters: ${tagName}`);
    }
    if (isVerbatim) {
        state20.tag = tagName;
    } else if (typeof state20.tagMap !== "undefined" && hasOwn2(state20.tagMap, tagHandle)) {
        state20.tag = state20.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
        state20.tag = `!${tagName}`;
    } else if (tagHandle === "!!") {
        state20.tag = `tag:yaml.org,2002:${tagName}`;
    } else {
        return throwError(state20, `undeclared tag handle "${tagHandle}"`);
    }
    return true;
}
function readAnchorProperty(state21) {
    let ch = state21.input.charCodeAt(state21.position);
    if (ch !== 0x26) return false;
    if (state21.anchor !== null) {
        return throwError(state21, "duplication of an anchor property");
    }
    ch = state21.input.charCodeAt(++state21.position);
    const position = state21.position;
    while(ch !== 0 && !isWsOrEol(ch) && !isFlowIndicator(ch)){
        ch = state21.input.charCodeAt(++state21.position);
    }
    if (state21.position === position) {
        return throwError(state21, "name of an anchor node must contain at least one character");
    }
    state21.anchor = state21.input.slice(position, state21.position);
    return true;
}
function readAlias(state22) {
    let ch = state22.input.charCodeAt(state22.position);
    if (ch !== 0x2a) return false;
    ch = state22.input.charCodeAt(++state22.position);
    const _position = state22.position;
    while(ch !== 0 && !isWsOrEol(ch) && !isFlowIndicator(ch)){
        ch = state22.input.charCodeAt(++state22.position);
    }
    if (state22.position === _position) {
        return throwError(state22, "name of an alias node must contain at least one character");
    }
    const alias = state22.input.slice(_position, state22.position);
    if (typeof state22.anchorMap !== "undefined" && !hasOwn2(state22.anchorMap, alias)) {
        return throwError(state22, `unidentified alias "${alias}"`);
    }
    if (typeof state22.anchorMap !== "undefined") {
        state22.result = state22.anchorMap[alias];
    }
    skipSeparationSpace(state22, true, -1);
    return true;
}
function composeNode(state23, parentIndent, nodeContext, allowToSeek, allowCompact) {
    let allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, type29, flowIndent, blockIndent;
    if (state23.listener && state23.listener !== null) {
        state23.listener("open", state23);
    }
    state23.tag = null;
    state23.anchor = null;
    state23.kind = null;
    state23.result = null;
    const allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
        if (skipSeparationSpace(state23, true, -1)) {
            atNewLine = true;
            if (state23.lineIndent > parentIndent) {
                indentStatus = 1;
            } else if (state23.lineIndent === parentIndent) {
                indentStatus = 0;
            } else if (state23.lineIndent < parentIndent) {
                indentStatus = -1;
            }
        }
    }
    if (indentStatus === 1) {
        while(readTagProperty(state23) || readAnchorProperty(state23)){
            if (skipSeparationSpace(state23, true, -1)) {
                atNewLine = true;
                allowBlockCollections = allowBlockStyles;
                if (state23.lineIndent > parentIndent) {
                    indentStatus = 1;
                } else if (state23.lineIndent === parentIndent) {
                    indentStatus = 0;
                } else if (state23.lineIndent < parentIndent) {
                    indentStatus = -1;
                }
            } else {
                allowBlockCollections = false;
            }
        }
    }
    if (allowBlockCollections) {
        allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || 4 === nodeContext) {
        const cond = 1 === nodeContext || 2 === nodeContext;
        flowIndent = cond ? parentIndent : parentIndent + 1;
        blockIndent = state23.position - state23.lineStart;
        if (indentStatus === 1) {
            if (allowBlockCollections && (readBlockSequence(state23, blockIndent) || readBlockMapping(state23, blockIndent, flowIndent)) || readFlowCollection(state23, flowIndent)) {
                hasContent = true;
            } else {
                if (allowBlockScalars && readBlockScalar(state23, flowIndent) || readSingleQuotedScalar(state23, flowIndent) || readDoubleQuotedScalar(state23, flowIndent)) {
                    hasContent = true;
                } else if (readAlias(state23)) {
                    hasContent = true;
                    if (state23.tag !== null || state23.anchor !== null) {
                        return throwError(state23, "alias node should not have Any properties");
                    }
                } else if (readPlainScalar(state23, flowIndent, 1 === nodeContext)) {
                    hasContent = true;
                    if (state23.tag === null) {
                        state23.tag = "?";
                    }
                }
                if (state23.anchor !== null && typeof state23.anchorMap !== "undefined") {
                    state23.anchorMap[state23.anchor] = state23.result;
                }
            }
        } else if (indentStatus === 0) {
            hasContent = allowBlockCollections && readBlockSequence(state23, blockIndent);
        }
    }
    if (state23.tag !== null && state23.tag !== "!") {
        if (state23.tag === "?") {
            for(let typeIndex = 0, typeQuantity = state23.implicitTypes.length; typeIndex < typeQuantity; typeIndex++){
                type29 = state23.implicitTypes[typeIndex];
                if (type29.resolve(state23.result)) {
                    state23.result = type29.construct(state23.result);
                    state23.tag = type29.tag;
                    if (state23.anchor !== null && typeof state23.anchorMap !== "undefined") {
                        state23.anchorMap[state23.anchor] = state23.result;
                    }
                    break;
                }
            }
        } else if (hasOwn2(state23.typeMap[state23.kind || "fallback"], state23.tag)) {
            type29 = state23.typeMap[state23.kind || "fallback"][state23.tag];
            if (state23.result !== null && type29.kind !== state23.kind) {
                return throwError(state23, `unacceptable node kind for !<${state23.tag}> tag; it should be "${type29.kind}", not "${state23.kind}"`);
            }
            if (!type29.resolve(state23.result)) {
                return throwError(state23, `cannot resolve a node with !<${state23.tag}> explicit tag`);
            } else {
                state23.result = type29.construct(state23.result);
                if (state23.anchor !== null && typeof state23.anchorMap !== "undefined") {
                    state23.anchorMap[state23.anchor] = state23.result;
                }
            }
        } else {
            return throwError(state23, `unknown tag !<${state23.tag}>`);
        }
    }
    if (state23.listener && state23.listener !== null) {
        state23.listener("close", state23);
    }
    return state23.tag !== null || state23.anchor !== null || hasContent;
}
function readDocument(state24) {
    const documentStart = state24.position;
    let position, directiveName, directiveArgs, hasDirectives = false, ch;
    state24.version = null;
    state24.checkLineBreaks = state24.legacy;
    state24.tagMap = {};
    state24.anchorMap = {};
    while((ch = state24.input.charCodeAt(state24.position)) !== 0){
        skipSeparationSpace(state24, true, -1);
        ch = state24.input.charCodeAt(state24.position);
        if (state24.lineIndent > 0 || ch !== 0x25) {
            break;
        }
        hasDirectives = true;
        ch = state24.input.charCodeAt(++state24.position);
        position = state24.position;
        while(ch !== 0 && !isWsOrEol(ch)){
            ch = state24.input.charCodeAt(++state24.position);
        }
        directiveName = state24.input.slice(position, state24.position);
        directiveArgs = [];
        if (directiveName.length < 1) {
            return throwError(state24, "directive name must not be less than one character in length");
        }
        while(ch !== 0){
            while(isWhiteSpace(ch)){
                ch = state24.input.charCodeAt(++state24.position);
            }
            if (ch === 0x23) {
                do {
                    ch = state24.input.charCodeAt(++state24.position);
                }while (ch !== 0 && !isEOL(ch))
                break;
            }
            if (isEOL(ch)) break;
            position = state24.position;
            while(ch !== 0 && !isWsOrEol(ch)){
                ch = state24.input.charCodeAt(++state24.position);
            }
            directiveArgs.push(state24.input.slice(position, state24.position));
        }
        if (ch !== 0) readLineBreak(state24);
        if (hasOwn2(directiveHandlers, directiveName)) {
            directiveHandlers[directiveName](state24, directiveName, ...directiveArgs);
        } else {
            throwWarning(state24, `unknown document directive "${directiveName}"`);
        }
    }
    skipSeparationSpace(state24, true, -1);
    if (state24.lineIndent === 0 && state24.input.charCodeAt(state24.position) === 0x2d && state24.input.charCodeAt(state24.position + 1) === 0x2d && state24.input.charCodeAt(state24.position + 2) === 0x2d) {
        state24.position += 3;
        skipSeparationSpace(state24, true, -1);
    } else if (hasDirectives) {
        return throwError(state24, "directives end mark is expected");
    }
    composeNode(state24, state24.lineIndent - 1, 4, false, true);
    skipSeparationSpace(state24, true, -1);
    if (state24.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state24.input.slice(documentStart, state24.position))) {
        throwWarning(state24, "non-ASCII line breaks are interpreted as content");
    }
    state24.documents.push(state24.result);
    if (state24.position === state24.lineStart && testDocumentSeparator(state24)) {
        if (state24.input.charCodeAt(state24.position) === 0x2e) {
            state24.position += 3;
            skipSeparationSpace(state24, true, -1);
        }
        return;
    }
    if (state24.position < state24.length - 1) {
        return throwError(state24, "end of the stream or a document separator is expected");
    } else {
        return;
    }
}
function loadDocuments(input, options) {
    input = String(input);
    options = options || {};
    if (input.length !== 0) {
        if (input.charCodeAt(input.length - 1) !== 0x0a && input.charCodeAt(input.length - 1) !== 0x0d) {
            input += "\n";
        }
        if (input.charCodeAt(0) === 0xfeff) {
            input = input.slice(1);
        }
    }
    const state25 = new LoaderState(input, options);
    state25.input += "\0";
    while(state25.input.charCodeAt(state25.position) === 0x20){
        state25.lineIndent += 1;
        state25.position += 1;
    }
    while(state25.position < state25.length - 1){
        readDocument(state25);
    }
    return state25.documents;
}
function load(input, options) {
    const documents = loadDocuments(input, options);
    if (documents.length === 0) {
        return;
    }
    if (documents.length === 1) {
        return documents[0];
    }
    throw new YAMLError("expected a single document in the stream, but found more");
}
function parse3(content, options) {
    return load(content, options);
}
const { hasOwn: hasOwn3  } = Object;
function compileStyleMap(schema4, map5) {
    if (typeof map5 === "undefined" || map5 === null) return {};
    let type30;
    const result = {};
    const keys4 = Object.keys(map5);
    let tag, style;
    for(let index = 0, length = keys4.length; index < length; index += 1){
        tag = keys4[index];
        style = String(map5[tag]);
        if (tag.slice(0, 2) === "!!") {
            tag = `tag:yaml.org,2002:${tag.slice(2)}`;
        }
        type30 = schema4.compiledTypeMap.fallback[tag];
        if (type30 && typeof type30.styleAliases !== "undefined" && hasOwn3(type30.styleAliases, style)) {
            style = type30.styleAliases[style];
        }
        result[tag] = style;
    }
    return result;
}
class DumperState extends State {
    indent;
    noArrayIndent;
    skipInvalid;
    flowLevel;
    sortKeys;
    lineWidth;
    noRefs;
    noCompatMode;
    condenseFlow;
    implicitTypes;
    explicitTypes;
    tag = null;
    result = "";
    duplicates = [];
    usedDuplicates = [];
    styleMap;
    dump;
    constructor({ schema: schema5 , indent =2 , noArrayIndent =false , skipInvalid =false , flowLevel =-1 , styles =null , sortKeys =false , lineWidth =80 , noRefs =false , noCompatMode =false , condenseFlow =false  }){
        super(schema5);
        this.indent = Math.max(1, indent);
        this.noArrayIndent = noArrayIndent;
        this.skipInvalid = skipInvalid;
        this.flowLevel = flowLevel;
        this.styleMap = compileStyleMap(this.schema, styles);
        this.sortKeys = sortKeys;
        this.lineWidth = lineWidth;
        this.noRefs = noRefs;
        this.noCompatMode = noCompatMode;
        this.condenseFlow = condenseFlow;
        this.implicitTypes = this.schema.compiledImplicit;
        this.explicitTypes = this.schema.compiledExplicit;
    }
}
const _toString2 = Object.prototype.toString;
const { hasOwn: hasOwn4  } = Object;
const ESCAPE_SEQUENCES = {};
ESCAPE_SEQUENCES[0x00] = "\\0";
ESCAPE_SEQUENCES[0x07] = "\\a";
ESCAPE_SEQUENCES[0x08] = "\\b";
ESCAPE_SEQUENCES[0x09] = "\\t";
ESCAPE_SEQUENCES[0x0a] = "\\n";
ESCAPE_SEQUENCES[0x0b] = "\\v";
ESCAPE_SEQUENCES[0x0c] = "\\f";
ESCAPE_SEQUENCES[0x0d] = "\\r";
ESCAPE_SEQUENCES[0x1b] = "\\e";
ESCAPE_SEQUENCES[0x22] = '\\"';
ESCAPE_SEQUENCES[0x5c] = "\\\\";
ESCAPE_SEQUENCES[0x85] = "\\N";
ESCAPE_SEQUENCES[0xa0] = "\\_";
ESCAPE_SEQUENCES[0x2028] = "\\L";
ESCAPE_SEQUENCES[0x2029] = "\\P";
const DEPRECATED_BOOLEANS_SYNTAX = [
    "y",
    "Y",
    "yes",
    "Yes",
    "YES",
    "on",
    "On",
    "ON",
    "n",
    "N",
    "no",
    "No",
    "NO",
    "off",
    "Off",
    "OFF", 
];
function encodeHex(character) {
    const string4 = character.toString(16).toUpperCase();
    let handle;
    let length;
    if (character <= 0xff) {
        handle = "x";
        length = 2;
    } else if (character <= 0xffff) {
        handle = "u";
        length = 4;
    } else if (character <= 0xffffffff) {
        handle = "U";
        length = 8;
    } else {
        throw new YAMLError("code point within a string may not be greater than 0xFFFFFFFF");
    }
    return `\\${handle}${repeat("0", length - string4.length)}${string4}`;
}
function indentString(string5, spaces) {
    const ind = repeat(" ", spaces), length = string5.length;
    let position = 0, next = -1, result = "", line;
    while(position < length){
        next = string5.indexOf("\n", position);
        if (next === -1) {
            line = string5.slice(position);
            position = length;
        } else {
            line = string5.slice(position, next + 1);
            position = next + 1;
        }
        if (line.length && line !== "\n") result += ind;
        result += line;
    }
    return result;
}
function generateNextLine(state26, level) {
    return `\n${repeat(" ", state26.indent * level)}`;
}
function testImplicitResolving(state27, str60) {
    let type31;
    for(let index = 0, length = state27.implicitTypes.length; index < length; index += 1){
        type31 = state27.implicitTypes[index];
        if (type31.resolve(str60)) {
            return true;
        }
    }
    return false;
}
function isWhitespace(c) {
    return c === 0x20 || c === 0x09;
}
function isPrintable(c) {
    return 0x00020 <= c && c <= 0x00007e || 0x000a1 <= c && c <= 0x00d7ff && c !== 0x2028 && c !== 0x2029 || 0x0e000 <= c && c <= 0x00fffd && c !== 0xfeff || 0x10000 <= c && c <= 0x10ffff;
}
function isPlainSafe(c) {
    return isPrintable(c) && c !== 0xfeff && c !== 0x2c && c !== 0x5b && c !== 0x5d && c !== 0x7b && c !== 0x7d && c !== 0x3a && c !== 0x23;
}
function isPlainSafeFirst(c) {
    return isPrintable(c) && c !== 0xfeff && !isWhitespace(c) && c !== 0x2d && c !== 0x3f && c !== 0x3a && c !== 0x2c && c !== 0x5b && c !== 0x5d && c !== 0x7b && c !== 0x7d && c !== 0x23 && c !== 0x26 && c !== 0x2a && c !== 0x21 && c !== 0x7c && c !== 0x3e && c !== 0x27 && c !== 0x22 && c !== 0x25 && c !== 0x40 && c !== 0x60;
}
function needIndentIndicator(string6) {
    const leadingSpaceRe = /^\n* /;
    return leadingSpaceRe.test(string6);
}
const STYLE_PLAIN = 1, STYLE_SINGLE = 2, STYLE_LITERAL = 3, STYLE_FOLDED = 4, STYLE_DOUBLE = 5;
function chooseScalarStyle(string7, singleLineOnly, indentPerLevel, lineWidth, testAmbiguousType) {
    const shouldTrackWidth = lineWidth !== -1;
    let hasLineBreak = false, hasFoldableLine = false, previousLineBreak = -1, plain = isPlainSafeFirst(string7.charCodeAt(0)) && !isWhitespace(string7.charCodeAt(string7.length - 1));
    let __char, i34;
    if (singleLineOnly) {
        for(i34 = 0; i34 < string7.length; i34++){
            __char = string7.charCodeAt(i34);
            if (!isPrintable(__char)) {
                return 5;
            }
            plain = plain && isPlainSafe(__char);
        }
    } else {
        for(i34 = 0; i34 < string7.length; i34++){
            __char = string7.charCodeAt(i34);
            if (__char === 0x0a) {
                hasLineBreak = true;
                if (shouldTrackWidth) {
                    hasFoldableLine = hasFoldableLine || i34 - previousLineBreak - 1 > lineWidth && string7[previousLineBreak + 1] !== " ";
                    previousLineBreak = i34;
                }
            } else if (!isPrintable(__char)) {
                return 5;
            }
            plain = plain && isPlainSafe(__char);
        }
        hasFoldableLine = hasFoldableLine || shouldTrackWidth && i34 - previousLineBreak - 1 > lineWidth && string7[previousLineBreak + 1] !== " ";
    }
    if (!hasLineBreak && !hasFoldableLine) {
        return plain && !testAmbiguousType(string7) ? 1 : 2;
    }
    if (indentPerLevel > 9 && needIndentIndicator(string7)) {
        return 5;
    }
    return hasFoldableLine ? 4 : 3;
}
function foldLine(line, width) {
    if (line === "" || line[0] === " ") return line;
    const breakRe = / [^ ]/g;
    let match;
    let start = 0, end, curr = 0, next = 0;
    let result = "";
    while(match = breakRe.exec(line)){
        next = match.index;
        if (next - start > width) {
            end = curr > start ? curr : next;
            result += `\n${line.slice(start, end)}`;
            start = end + 1;
        }
        curr = next;
    }
    result += "\n";
    if (line.length - start > width && curr > start) {
        result += `${line.slice(start, curr)}\n${line.slice(curr + 1)}`;
    } else {
        result += line.slice(start);
    }
    return result.slice(1);
}
function dropEndingNewline(string8) {
    return string8[string8.length - 1] === "\n" ? string8.slice(0, -1) : string8;
}
function foldString(string9, width) {
    const lineRe = /(\n+)([^\n]*)/g;
    let result = (()=>{
        let nextLF = string9.indexOf("\n");
        nextLF = nextLF !== -1 ? nextLF : string9.length;
        lineRe.lastIndex = nextLF;
        return foldLine(string9.slice(0, nextLF), width);
    })();
    let prevMoreIndented = string9[0] === "\n" || string9[0] === " ";
    let moreIndented;
    let match;
    while(match = lineRe.exec(string9)){
        const prefix = match[1], line = match[2];
        moreIndented = line[0] === " ";
        result += prefix + (!prevMoreIndented && !moreIndented && line !== "" ? "\n" : "") + foldLine(line, width);
        prevMoreIndented = moreIndented;
    }
    return result;
}
function escapeString(string10) {
    let result = "";
    let __char, nextChar;
    let escapeSeq;
    for(let i35 = 0; i35 < string10.length; i35++){
        __char = string10.charCodeAt(i35);
        if (__char >= 0xd800 && __char <= 0xdbff) {
            nextChar = string10.charCodeAt(i35 + 1);
            if (nextChar >= 0xdc00 && nextChar <= 0xdfff) {
                result += encodeHex((__char - 0xd800) * 0x400 + nextChar - 0xdc00 + 0x10000);
                i35++;
                continue;
            }
        }
        escapeSeq = ESCAPE_SEQUENCES[__char];
        result += !escapeSeq && isPrintable(__char) ? string10[i35] : escapeSeq || encodeHex(__char);
    }
    return result;
}
function blockHeader(string11, indentPerLevel) {
    const indentIndicator = needIndentIndicator(string11) ? String(indentPerLevel) : "";
    const clip = string11[string11.length - 1] === "\n";
    const keep = clip && (string11[string11.length - 2] === "\n" || string11 === "\n");
    const chomp = keep ? "+" : clip ? "" : "-";
    return `${indentIndicator}${chomp}\n`;
}
function writeScalar(state28, string12, level, iskey) {
    state28.dump = (()=>{
        if (string12.length === 0) {
            return "''";
        }
        if (!state28.noCompatMode && DEPRECATED_BOOLEANS_SYNTAX.indexOf(string12) !== -1) {
            return `'${string12}'`;
        }
        const indent = state28.indent * Math.max(1, level);
        const lineWidth = state28.lineWidth === -1 ? -1 : Math.max(Math.min(state28.lineWidth, 40), state28.lineWidth - indent);
        const singleLineOnly = iskey || state28.flowLevel > -1 && level >= state28.flowLevel;
        function testAmbiguity(str61) {
            return testImplicitResolving(state28, str61);
        }
        switch(chooseScalarStyle(string12, singleLineOnly, state28.indent, lineWidth, testAmbiguity)){
            case STYLE_PLAIN:
                return string12;
            case STYLE_SINGLE:
                return `'${string12.replace(/'/g, "''")}'`;
            case STYLE_LITERAL:
                return `|${blockHeader(string12, state28.indent)}${dropEndingNewline(indentString(string12, indent))}`;
            case STYLE_FOLDED:
                return `>${blockHeader(string12, state28.indent)}${dropEndingNewline(indentString(foldString(string12, lineWidth), indent))}`;
            case STYLE_DOUBLE:
                return `"${escapeString(string12)}"`;
            default:
                throw new YAMLError("impossible error: invalid scalar style");
        }
    })();
}
function writeFlowSequence(state29, level, object) {
    let _result = "";
    const _tag = state29.tag;
    for(let index = 0, length = object.length; index < length; index += 1){
        if (writeNode(state29, level, object[index], false, false)) {
            if (index !== 0) _result += `,${!state29.condenseFlow ? " " : ""}`;
            _result += state29.dump;
        }
    }
    state29.tag = _tag;
    state29.dump = `[${_result}]`;
}
function writeBlockSequence(state30, level, object, compact = false) {
    let _result = "";
    const _tag = state30.tag;
    for(let index = 0, length = object.length; index < length; index += 1){
        if (writeNode(state30, level + 1, object[index], true, true)) {
            if (!compact || index !== 0) {
                _result += generateNextLine(state30, level);
            }
            if (state30.dump && 0x0a === state30.dump.charCodeAt(0)) {
                _result += "-";
            } else {
                _result += "- ";
            }
            _result += state30.dump;
        }
    }
    state30.tag = _tag;
    state30.dump = _result || "[]";
}
function writeFlowMapping(state31, level, object) {
    let _result = "";
    const _tag = state31.tag, objectKeyList = Object.keys(object);
    let pairBuffer, objectKey, objectValue;
    for(let index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = state31.condenseFlow ? '"' : "";
        if (index !== 0) pairBuffer += ", ";
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (!writeNode(state31, level, objectKey, false, false)) {
            continue;
        }
        if (state31.dump.length > 1024) pairBuffer += "? ";
        pairBuffer += `${state31.dump}${state31.condenseFlow ? '"' : ""}:${state31.condenseFlow ? "" : " "}`;
        if (!writeNode(state31, level, objectValue, false, false)) {
            continue;
        }
        pairBuffer += state31.dump;
        _result += pairBuffer;
    }
    state31.tag = _tag;
    state31.dump = `{${_result}}`;
}
function writeBlockMapping(state32, level, object, compact = false) {
    const _tag = state32.tag, objectKeyList = Object.keys(object);
    let _result = "";
    if (state32.sortKeys === true) {
        objectKeyList.sort();
    } else if (typeof state32.sortKeys === "function") {
        objectKeyList.sort(state32.sortKeys);
    } else if (state32.sortKeys) {
        throw new YAMLError("sortKeys must be a boolean or a function");
    }
    let pairBuffer = "", objectKey, objectValue, explicitPair;
    for(let index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = "";
        if (!compact || index !== 0) {
            pairBuffer += generateNextLine(state32, level);
        }
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (!writeNode(state32, level + 1, objectKey, true, true, true)) {
            continue;
        }
        explicitPair = state32.tag !== null && state32.tag !== "?" || state32.dump && state32.dump.length > 1024;
        if (explicitPair) {
            if (state32.dump && 0x0a === state32.dump.charCodeAt(0)) {
                pairBuffer += "?";
            } else {
                pairBuffer += "? ";
            }
        }
        pairBuffer += state32.dump;
        if (explicitPair) {
            pairBuffer += generateNextLine(state32, level);
        }
        if (!writeNode(state32, level + 1, objectValue, true, explicitPair)) {
            continue;
        }
        if (state32.dump && 0x0a === state32.dump.charCodeAt(0)) {
            pairBuffer += ":";
        } else {
            pairBuffer += ": ";
        }
        pairBuffer += state32.dump;
        _result += pairBuffer;
    }
    state32.tag = _tag;
    state32.dump = _result || "{}";
}
function detectType(state33, object, explicit = false) {
    const typeList = explicit ? state33.explicitTypes : state33.implicitTypes;
    let type32;
    let style;
    let _result;
    for(let index = 0, length = typeList.length; index < length; index += 1){
        type32 = typeList[index];
        if ((type32.instanceOf || type32.predicate) && (!type32.instanceOf || typeof object === "object" && object instanceof type32.instanceOf) && (!type32.predicate || type32.predicate(object))) {
            state33.tag = explicit ? type32.tag : "?";
            if (type32.represent) {
                style = state33.styleMap[type32.tag] || type32.defaultStyle;
                if (_toString2.call(type32.represent) === "[object Function]") {
                    _result = type32.represent(object, style);
                } else if (hasOwn4(type32.represent, style)) {
                    _result = type32.represent[style](object, style);
                } else {
                    throw new YAMLError(`!<${type32.tag}> tag resolver accepts not "${style}" style`);
                }
                state33.dump = _result;
            }
            return true;
        }
    }
    return false;
}
function writeNode(state34, level, object, block, compact, iskey = false) {
    state34.tag = null;
    state34.dump = object;
    if (!detectType(state34, object, false)) {
        detectType(state34, object, true);
    }
    const type33 = _toString2.call(state34.dump);
    if (block) {
        block = state34.flowLevel < 0 || state34.flowLevel > level;
    }
    const objectOrArray = type33 === "[object Object]" || type33 === "[object Array]";
    let duplicateIndex = -1;
    let duplicate = false;
    if (objectOrArray) {
        duplicateIndex = state34.duplicates.indexOf(object);
        duplicate = duplicateIndex !== -1;
    }
    if (state34.tag !== null && state34.tag !== "?" || duplicate || state34.indent !== 2 && level > 0) {
        compact = false;
    }
    if (duplicate && state34.usedDuplicates[duplicateIndex]) {
        state34.dump = `*ref_${duplicateIndex}`;
    } else {
        if (objectOrArray && duplicate && !state34.usedDuplicates[duplicateIndex]) {
            state34.usedDuplicates[duplicateIndex] = true;
        }
        if (type33 === "[object Object]") {
            if (block && Object.keys(state34.dump).length !== 0) {
                writeBlockMapping(state34, level, state34.dump, compact);
                if (duplicate) {
                    state34.dump = `&ref_${duplicateIndex}${state34.dump}`;
                }
            } else {
                writeFlowMapping(state34, level, state34.dump);
                if (duplicate) {
                    state34.dump = `&ref_${duplicateIndex} ${state34.dump}`;
                }
            }
        } else if (type33 === "[object Array]") {
            const arrayLevel = state34.noArrayIndent && level > 0 ? level - 1 : level;
            if (block && state34.dump.length !== 0) {
                writeBlockSequence(state34, arrayLevel, state34.dump, compact);
                if (duplicate) {
                    state34.dump = `&ref_${duplicateIndex}${state34.dump}`;
                }
            } else {
                writeFlowSequence(state34, arrayLevel, state34.dump);
                if (duplicate) {
                    state34.dump = `&ref_${duplicateIndex} ${state34.dump}`;
                }
            }
        } else if (type33 === "[object String]") {
            if (state34.tag !== "?") {
                writeScalar(state34, state34.dump, level, iskey);
            }
        } else {
            if (state34.skipInvalid) return false;
            throw new YAMLError(`unacceptable kind of an object to dump ${type33}`);
        }
        if (state34.tag !== null && state34.tag !== "?") {
            state34.dump = `!<${state34.tag}> ${state34.dump}`;
        }
    }
    return true;
}
function inspectNode(object, objects, duplicatesIndexes) {
    if (object !== null && typeof object === "object") {
        const index = objects.indexOf(object);
        if (index !== -1) {
            if (duplicatesIndexes.indexOf(index) === -1) {
                duplicatesIndexes.push(index);
            }
        } else {
            objects.push(object);
            if (Array.isArray(object)) {
                for(let idx = 0, length = object.length; idx < length; idx += 1){
                    inspectNode(object[idx], objects, duplicatesIndexes);
                }
            } else {
                const objectKeyList = Object.keys(object);
                for(let idx = 0, length = objectKeyList.length; idx < length; idx += 1){
                    inspectNode(object[objectKeyList[idx]], objects, duplicatesIndexes);
                }
            }
        }
    }
}
function getDuplicateReferences(object, state35) {
    const objects = [], duplicatesIndexes = [];
    inspectNode(object, objects, duplicatesIndexes);
    const length = duplicatesIndexes.length;
    for(let index = 0; index < length; index += 1){
        state35.duplicates.push(objects[duplicatesIndexes[index]]);
    }
    state35.usedDuplicates = Array.from({
        length
    });
}
function dump(input, options) {
    options = options || {};
    const state36 = new DumperState(options);
    if (!state36.noRefs) getDuplicateReferences(input, state36);
    if (writeNode(state36, 0, input, true, true)) return `${state36.dump}\n`;
    return "";
}
function stringify(obj, options) {
    return dump(obj, options);
}
var State1;
(function(State3) {
    State3[State3["PASSTHROUGH"] = 0] = "PASSTHROUGH";
    State3[State3["PERCENT"] = 1] = "PERCENT";
    State3[State3["POSITIONAL"] = 2] = "POSITIONAL";
    State3[State3["PRECISION"] = 3] = "PRECISION";
    State3[State3["WIDTH"] = 4] = "WIDTH";
})(State1 || (State1 = {}));
var WorP;
(function(WorP1) {
    WorP1[WorP1["WIDTH"] = 0] = "WIDTH";
    WorP1[WorP1["PRECISION"] = 1] = "PRECISION";
})(WorP || (WorP = {}));
var F;
(function(F1) {
    F1[F1["sign"] = 1] = "sign";
    F1[F1["mantissa"] = 2] = "mantissa";
    F1[F1["fractional"] = 3] = "fractional";
    F1[F1["esign"] = 4] = "esign";
    F1[F1["exponent"] = 5] = "exponent";
})(F || (F = {}));
function glb(array, value, compare1) {
    compare1 = compare1 || ((a, b)=>a - b
    );
    if (array.length === 0) {
        return -1;
    }
    if (array.length === 1) {
        if (compare1(value, array[0]) < 0) {
            return -1;
        } else {
            return 0;
        }
    }
    let left = 0;
    let right = array.length - 1;
    const vLeft = array[left], vRight = array[right];
    if (compare1(value, vRight) >= 0) {
        return right;
    }
    if (compare1(value, vLeft) < 0) {
        return -1;
    }
    while(right - left > 1){
        const center = left + (right - left >> 1);
        const vCenter = array[center];
        const cmp1 = compare1(value, vCenter);
        if (cmp1 < 0) {
            right = center;
        } else if (cmp1 === 0) {
            left = center;
        } else {
            left = center;
        }
    }
    return left;
}
let Deno1;
try {
    Deno1 = globalThis.Deno;
} catch (_e) {}
const noColor1 = typeof (Deno1 && Deno1.noColor) === "boolean" ? Deno1.noColor : true;
let enabled1 = !noColor1;
function code1(open, close) {
    return {
        open: `\x1b[${open.join(";")}m`,
        close: `\x1b[${close}m`,
        regexp: new RegExp(`\\x1b\\[${close}m`, "g")
    };
}
function run1(str62, code110) {
    return enabled1 ? `${code110.open}${str62.replace(code110.regexp, code110.open)}${code110.close}` : str62;
}
function red1(str63) {
    return run1(str63, code1([
        31
    ], 39));
}
function blue1(str64) {
    return run1(str64, code1([
        34
    ], 39));
}
const ANSI_PATTERN1 = new RegExp([
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))", 
].join("|"), "g");
function stripColor1(string13) {
    return string13.replace(ANSI_PATTERN1, "");
}
function platformHasNonAsciiCharacters() {
    try {
        return Deno.build.os !== "windows";
    } catch (_e) {
        return false;
    }
}
function tidyverseInfo(msg) {
    if (platformHasNonAsciiCharacters()) {
        return `${blue1("ℹ")} ${msg}`;
    } else {
        return `${blue1("i")} ${msg}`;
    }
}
function tidyverseError(msg) {
    if (platformHasNonAsciiCharacters()) {
        return `${red1("✖")} ${msg}`;
    } else {
        return `${red1("x")} ${msg}`;
    }
}
function tidyverseFormatError(msg) {
    let { heading , error: error8 , info: info2  } = msg;
    if (msg.location) {
        heading = `${locationString(msg.location)} ${heading}`;
    }
    if (msg.fileName) {
        heading = `In file ${msg.fileName}\n${heading}`;
    }
    const strings = [
        heading,
        msg.sourceContext,
        ...error8.map(tidyverseError),
        ...Object.values(info2).map(tidyverseInfo),
        "", 
    ];
    return strings.join("\n");
}
function quotedStringColor(msg) {
    return blue1(msg);
}
function addFileInfo(msg, src8) {
    if (src8.fileName !== undefined) {
        msg.fileName = src8.fileName;
    }
}
function addInstancePathInfo(msg, instancePath) {
    if (instancePath.length) {
        const niceInstancePath = instancePath.map((s)=>blue1(String(s))
        ).join(":");
        msg.info["instance-path-location"] = `The error happened in location ${niceInstancePath}.`;
    }
}
function locationString(loc) {
    const { start , end  } = loc;
    if (start.line === end.line) {
        if (start.column === end.column) {
            return `(line ${start.line + 1}, column ${start.column + 1})`;
        } else {
            return `(line ${start.line + 1}, columns ${start.column + 1}--${end.column + 1})`;
        }
    } else {
        return `(line ${start.line + 1}, column ${start.column + 1} through line ${end.line + 1}, column ${end.column + 1})`;
    }
}
function errorKey(err) {
    const positionKey = (pos)=>`${pos.line}-${pos.column}`
    ;
    return `${err.fileName || ""}-${positionKey(err.location.start)}-${positionKey(err.location.end)}`;
}
function reportOnce(reporter, reportSet) {
    const errorsReported = reportSet || new Set();
    return (err)=>{
        const key = errorKey(err);
        if (errorsReported.has(key)) {
            return;
        }
        errorsReported.add(key);
        reporter(err);
    };
}
function lines(text) {
    return text.split(/\r?\n/);
}
function normalizeNewlines(text) {
    return lines(text).join("\n");
}
function* matchAll(text, regexp3) {
    if (!regexp3.global) {
        throw new Error("matchAll requires global regexps");
    }
    let match;
    while((match = regexp3.exec(text)) !== null){
        yield match;
    }
}
function* lineOffsets(text) {
    yield 0;
    for (const match of matchAll(text, /\r?\n/g)){
        yield match.index + match[0].length;
    }
}
function indexToLineCol(text) {
    const offsets = Array.from(lineOffsets(text));
    return function(offset) {
        if (offset === 0) {
            return {
                line: 0,
                column: 0
            };
        }
        const startIndex = glb(offsets, offset);
        return {
            line: startIndex,
            column: offset - offsets[startIndex]
        };
    };
}
function lineColToIndex(text) {
    const offsets = Array.from(lineOffsets(text));
    return function(position) {
        return offsets[position.line] + position.column;
    };
}
function formatLineRange(text, firstLine, lastLine) {
    const lineWidth = Math.max(String(firstLine + 1).length, String(lastLine + 1).length);
    const pad1 = " ".repeat(lineWidth);
    const ls = lines(text);
    const result = [];
    for(let i36 = firstLine; i36 <= lastLine; ++i36){
        const numberStr = `${pad1}${i36 + 1}: `.slice(-(lineWidth + 2));
        const lineStr = ls[i36];
        result.push({
            lineNumber: i36,
            content: numberStr + quotedStringColor(lineStr),
            rawLine: ls[i36]
        });
    }
    return {
        prefixWidth: lineWidth + 2,
        lines: result
    };
}
function editDistance(w1, w2) {
    const cost = (c)=>{
        if ("_-".indexOf(c) !== -1) {
            return 1;
        }
        return 10;
    };
    const cost2 = (c1, c2)=>{
        if (c1 === c2) {
            return 0;
        }
        if ("_-".indexOf(c1) !== -1 && "_-".indexOf(c2) !== -1) {
            return 1;
        }
        if (c1.toLocaleLowerCase() === c2.toLocaleLowerCase()) {
            return 1;
        }
        const cc1 = c1.charCodeAt(0);
        const cc2 = c2.charCodeAt(0);
        if (cc1 >= 48 && cc1 <= 57 && cc2 >= 48 && cc2 <= 57) {
            return 1;
        }
        return 10;
    };
    const s1 = w1.length + 1;
    const s2 = w2.length + 1;
    const v = new Int32Array(s1 * s2);
    for(let i37 = 0; i37 < s1; ++i37){
        for(let j = 0; j < s2; ++j){
            if (i37 === 0 && j === 0) {
                continue;
            } else if (i37 === 0) {
                v[i37 * s2 + j] = v[i37 * s2 + (j - 1)] + cost(w2[j - 1]);
            } else if (j === 0) {
                v[i37 * s2 + j] = v[(i37 - 1) * s2 + j] + cost(w1[i37 - 1]);
            } else {
                v[i37 * s2 + j] = Math.min(v[(i37 - 1) * s2 + (j - 1)] + cost2(w1[i37 - 1], w2[j - 1]), v[i37 * s2 + (j - 1)] + cost(w2[j - 1]), v[(i37 - 1) * s2 + j] + cost(w1[i37 - 1]));
            }
        }
    }
    return v[(w1.length + 1) * (w2.length + 1) - 1];
}
function detectCaseConvention(key) {
    if (key.toLocaleLowerCase() !== key) {
        return "capitalizationCase";
    }
    if (key.indexOf("_") !== -1) {
        return "underscore_case";
    }
    if (key.indexOf("-") !== -1) {
        return "dash-case";
    }
    return undefined;
}
function resolveCaseConventionRegex(keys5, conventions) {
    if (conventions !== undefined) {
        if (conventions.length === 0) {
            throw new Error("Internal Error: resolveCaseConventionRegex requires nonempty `conventions`");
        }
        return {
            pattern: conventions.map((c)=>`(${c})`
            ).join("|"),
            list: conventions
        };
    }
    const disallowedNearMisses = [];
    const foundConventions = new Set();
    for (const key of keys5){
        const found = detectCaseConvention(key);
        if (found) {
            foundConventions.add(found);
        }
        switch(found){
            case "capitalizationCase":
                disallowedNearMisses.push(toUnderscoreCase(key), toDashCase(key));
                break;
            case "dash-case":
                disallowedNearMisses.push(toUnderscoreCase(key), toCapitalizationCase(key));
                break;
            case "underscore_case":
                disallowedNearMisses.push(toDashCase(key), toCapitalizationCase(key));
                break;
        }
    }
    if (foundConventions.size === 0) {
        return {
            pattern: undefined,
            list: []
        };
    }
    return {
        pattern: `^(?!(${disallowedNearMisses.join("|")}))`,
        list: Array.from(foundConventions)
    };
}
function toDashCase(str65) {
    return toUnderscoreCase(str65).replace(/_/g, "-");
}
function toUnderscoreCase(str66) {
    return str66.replace(/([A-Z]+)/g, (_match, p1)=>`-${p1}`
    ).replace(/-/g, "_").split("_").filter((x)=>x.length
    ).join("_").toLocaleLowerCase();
}
function toCapitalizationCase(str67) {
    return toUnderscoreCase(str67).replace(/_(.)/g, (_match, p1)=>p1.toLocaleUpperCase()
    );
}
function capitalize1(str68) {
    return str68.slice(0, 1).toUpperCase() + str68.slice(1);
}
const kLastPunctuationRegex = /([\S\s]*)[\.\?\!]/;
function trimSentence(text) {
    const match = text.match(kLastPunctuationRegex);
    if (match) {
        return {
            text: match[0],
            trimmed: true
        };
    } else {
        return {
            text,
            trimmed: false
        };
    }
}
function trimLength(text, length) {
    if (text.length < length) {
        return {
            text,
            trimmed: false
        };
    } else {
        return {
            text: text.substring(0, length),
            trimmed: true
        };
    }
}
function trimSpace(text) {
    const lastSpace = text.lastIndexOf(" ");
    if (lastSpace > 0) {
        return {
            text: text.substring(0, lastSpace),
            trimmed: true
        };
    } else {
        return {
            text,
            trimmed: false
        };
    }
}
function truncateText(text1, length, breakAt) {
    const trimEnd = (text)=>{
        if ([
            ",",
            "/",
            ":"
        ].includes(text.charAt(text.length - 1))) {
            return text.substring(0, text.length - 1);
        } else {
            return text;
        }
    };
    const trimAtSpace = (text)=>{
        const spaceResult = trimSpace(text.substring(0, text.length - 1));
        return trimEnd(spaceResult.text) + "…";
    };
    const trimPunc = (text)=>{
        const puncResult = trimSentence(text);
        if (puncResult.trimmed) {
            return puncResult.text;
        } else {
            return trimAtSpace(puncResult.text);
        }
    };
    const lengthResult = trimLength(text1, length);
    if (lengthResult.trimmed) {
        if (breakAt === "punctuation") {
            return trimPunc(lengthResult.text);
        } else {
            return trimAtSpace(lengthResult.text);
        }
    } else {
        return lengthResult.text;
    }
}
function matchAll1(str69, regex) {
    let match;
    regex = new RegExp(regex);
    const result = [];
    while((match = regex.exec(str69)) != null){
        result.push(match);
    }
    return result;
}
function rangedLines(text, includeNewLines = false) {
    const regex = /\r?\n/g;
    const result = [];
    let startOffset = 0;
    if (!includeNewLines) {
        for (const r of matchAll1(text, regex)){
            result.push({
                substring: text.substring(startOffset, r.index),
                range: {
                    start: startOffset,
                    end: r.index
                }
            });
            startOffset = r.index + r[0].length;
        }
        result.push({
            substring: text.substring(startOffset, text.length),
            range: {
                start: startOffset,
                end: text.length
            }
        });
        return result;
    } else {
        const matches = matchAll1(text, regex);
        let prevOffset = 0;
        for (const r of matches){
            const stringEnd = r.index + r[0].length;
            result.push({
                substring: text.substring(prevOffset, stringEnd),
                range: {
                    start: prevOffset,
                    end: stringEnd
                }
            });
            prevOffset = stringEnd;
        }
        result.push({
            substring: text.substring(prevOffset, text.length),
            range: {
                start: prevOffset,
                end: text.length
            }
        });
        return result;
    }
}
function mappedSubstring(source, start, end) {
    if (typeof source === "string") {
        source = asMappedString(source);
    }
    const value = source.value.substring(start, end);
    const mappedSource1 = source;
    return {
        value,
        map: (index, closest1)=>{
            if (closest1) {
                index = Math.max(0, Math.min(value.length, index - 1));
            }
            if (index === 0 && index === value.length) {
                return mappedSource1.map(index + start, closest1);
            }
            if (index < 0 || index >= value.length) {
                return undefined;
            }
            return mappedSource1.map(index + start, closest1);
        }
    };
}
function mappedString(source, pieces, fileName) {
    if (typeof source === "string") {
        source = asMappedString(source, fileName);
    }
    const mappedPieces = pieces.map((piece)=>{
        if (typeof piece === "string") {
            return asMappedString(piece);
        } else if (piece.value !== undefined) {
            return piece;
        } else {
            const { start , end  } = piece;
            return mappedSubstring(source, start, end);
        }
    });
    return mappedConcat(mappedPieces);
}
function asMappedString(str70, fileName) {
    if (typeof str70 === "string") {
        return {
            value: str70,
            fileName,
            map: function(index, closest2) {
                if (closest2) {
                    index = Math.min(str70.length - 1, Math.max(0, index));
                }
                if (index < 0 || index >= str70.length) {
                    return undefined;
                }
                return {
                    index,
                    originalString: this
                };
            }
        };
    } else if (fileName !== undefined) {
        throw new Error("Internal error: can't change the fileName of an existing MappedString");
    } else {
        return str70;
    }
}
function mappedConcat(strings) {
    if (strings.length === 0) {
        return {
            value: "",
            map: (_index, _closest)=>undefined
        };
    }
    if (strings.every((s)=>typeof s === "string"
    )) {
        return asMappedString(strings.join(""));
    }
    const mappedStrings = strings.map((s)=>{
        if (typeof s === "string") {
            return asMappedString(s);
        } else return s;
    });
    let currentOffset = 0;
    const offsets = [
        0
    ];
    for (const s1 of mappedStrings){
        currentOffset += s1.value.length;
        offsets.push(currentOffset);
    }
    const value = mappedStrings.map((s)=>s.value
    ).join("");
    return {
        value,
        map: (offset, closest3)=>{
            if (closest3) {
                offset = Math.max(0, Math.min(offset, value.length - 1));
            }
            if (offset === 0 && offset == value.length && mappedStrings.length) {
                return mappedStrings[0].map(0, closest3);
            }
            if (offset < 0 || offset >= value.length) {
                return undefined;
            }
            const ix = glb(offsets, offset);
            const v = mappedStrings[ix];
            return v.map(offset - offsets[ix]);
        }
    };
}
function mappedIndexToLineCol(eitherText) {
    const text = asMappedString(eitherText);
    return function(offset) {
        const mapResult = text.map(offset, true);
        if (mapResult === undefined) {
            throw new Error("Internal Error: bad offset in mappedIndexRowCol");
        }
        const { index , originalString  } = mapResult;
        return indexToLineCol(originalString.value)(index);
    };
}
function join4(mappedStrs, sep10) {
    const innerStrings = [];
    const mappedSep = asMappedString(sep10);
    for(let i38 = 0; i38 < mappedStrs.length; ++i38){
        const mappedStr = mappedStrs[i38];
        if (typeof mappedStr === "string") {
            innerStrings.push(asMappedString(mappedStr));
        } else {
            innerStrings.push(mappedStr);
        }
        if (i38 < mappedStrs.length) {
            innerStrings.push(mappedSep);
        }
    }
    return mappedConcat(innerStrings);
}
function mappedLines(str71, keepNewLines = false) {
    const lines2 = rangedLines(str71.value, keepNewLines);
    return lines2.map((v)=>mappedString(str71, [
            v.range
        ])
    );
}
class ErrorEx extends Error {
    constructor(name82, message, printName = true, printStack = true){
        super(message);
        this.name = name82;
        this.printName = printName;
        this.printStack = printStack;
    }
    printName;
    printStack;
}
class LocalizedError extends Error {
    constructor(name83, message, source, position = 0, printName = true, printStack = true){
        const fileName = source.map(position)?.originalString?.fileName;
        if (fileName) {
            const { line , column  } = mappedIndexToLineCol(source)(position);
            message = `In file ${fileName} (${line + 1}:${column + 1}):
${message}`;
        }
        super(message);
        this.name = name83;
        this.printName = printName;
        this.printStack = printStack;
    }
    printName;
    printStack;
}
function asErrorEx(e) {
    if (e instanceof ErrorEx) {
        return e;
    } else if (e instanceof Error) {
        e.printName = e.name !== "Error";
        e.printStack = !!e.message;
        return e;
    } else {
        return new ErrorEx("Error", String(e), false, true);
    }
}
const booleanSchema = {
    "type": "boolean",
    "description": "be `true` or `false`",
    "completions": [
        "true",
        "false"
    ],
    "exhaustiveCompletions": true
};
const numberSchema = {
    "type": "number",
    "description": "be a number"
};
const stringSchema = {
    "type": "string",
    "description": "be a string"
};
const nullSchema = {
    "type": "null",
    "description": "be the null value",
    "completions": [
        "null"
    ],
    "exhaustiveCompletions": true
};
function schemaType(schema6) {
    if (schema6 === false) {
        return "false";
    }
    if (schema6 === true) {
        return "true";
    }
    return schema6.type;
}
function schemaDispatch(s, d) {
    const st = schemaType(s);
    if (d[st]) {
        d[st](s);
    }
}
function schemaCall(s, d, other) {
    const st = schemaType(s);
    if (d[st]) {
        return d[st](s);
    }
    if (other) {
        return other(s);
    }
    throw new Error(`Internal Error: dispatch failed for type ${st}`);
}
function schemaDocString(d) {
    if (typeof d === "string") {
        return d;
    }
    if (d.short) {
        return d.short;
    }
    return "";
}
function schemaDescription(schema7) {
    if (schema7 === true) {
        return `be anything`;
    } else if (schema7 === false) {
        return `be no possible value`;
    } else {
        return schema7.description || `be ${schemaType(schema7)}`;
    }
}
function tagSchema(schema8, tags) {
    return {
        ...schema8,
        tags: {
            ...schema8.tags || {},
            ...tags
        }
    };
}
function enumSchema(...args) {
    if (args.length === 0) {
        throw new Error("Internal Error: Empty enum schema not supported.");
    }
    return {
        "type": "enum",
        "enum": args,
        "description": args.length > 1 ? `be one of: ${args.map((x)=>"`" + x + "`"
        ).join(", ")}` : `be '${args[0]}'`,
        "completions": args.map(String),
        "exhaustiveCompletions": true
    };
}
function regexSchema(arg, description) {
    const result = {
        "type": "string",
        "pattern": arg
    };
    if (description) {
        result.description = description;
    } else {
        result.description = `be a string that satisfies regex "${arg}"`;
    }
    return result;
}
function anyOfSchema(...args) {
    return {
        "type": "anyOf",
        "anyOf": args,
        "description": `be at least one of: ${args.map((x)=>schemaDescription(x).slice(3)
        ).join(", ")}`
    };
}
function allOfSchema(...args) {
    return {
        "type": "allOf",
        "allOf": args,
        "description": `be all of: ${args.map((x)=>schemaDescription(x).slice(3)
        ).join(", ")}`
    };
}
function objectSchema(params = {}) {
    let { properties , patternProperties , required , additionalProperties , description , baseSchema , exhaustive , completions: completionsParam , namingConvention , propertyNames: propertyNamesSchema ,  } = params;
    required = required || [];
    properties = properties || {};
    patternProperties = patternProperties || {};
    const tags = {};
    let tagsAreSet = false;
    let propertyNames = propertyNamesSchema;
    const objectKeys = Object.getOwnPropertyNames(completionsParam || properties);
    if (namingConvention !== "ignore") {
        const { pattern , list  } = resolveCaseConventionRegex(objectKeys, namingConvention);
        if (pattern !== undefined) {
            if (propertyNames === undefined) {
                propertyNames = {
                    "type": "string",
                    pattern
                };
            } else {
                propertyNames = allOfSchema(propertyNames, {
                    "type": "string",
                    pattern
                });
            }
            tags["case-convention"] = list;
            tagsAreSet = true;
        }
    }
    if (completionsParam) {
        tags["completions"] = completionsParam;
        tagsAreSet = true;
    }
    const hasDescription = description !== undefined;
    description = description || "be an object";
    let result = undefined;
    if (baseSchema) {
        if (baseSchema.type !== "object") {
            throw new Error("Internal Error: can only extend other object Schema");
        }
        result = Object.assign({}, baseSchema);
        if (result.$id) {
            delete result.$id;
        }
        if (exhaustive && baseSchema.exhaustiveCompletions) {
            result.exhaustiveCompletions = true;
        }
        if (hasDescription) {
            result.description = description;
        }
        result.properties = Object.assign({}, result.properties, properties);
        result.patternProperties = Object.assign({}, result.patternProperties, patternProperties);
        if (required) {
            result.required = (result.required || []).slice();
            result.required.push(...required);
        }
        if (additionalProperties !== undefined) {
            if (result.additionalProperties === false) {
                throw new Error("Internal Error: don't know how to subclass object schema with additionalProperties === false");
            }
            if (result.additionalProperties) {
                result.additionalProperties = allOfSchema(result.additionalProperties, additionalProperties);
            } else {
                result.additionalProperties = additionalProperties;
            }
        }
        if (propertyNames !== undefined && result.propertyNames !== undefined) {
            result.propertyNames = anyOfSchema(propertyNames, result.propertyNames);
        }
    } else {
        result = {
            "type": "object",
            description
        };
        if (exhaustive) {
            result.exhaustiveCompletions = true;
        }
        if (properties) {
            result.properties = properties;
        }
        if (patternProperties) {
            result.patternProperties = patternProperties;
        }
        if (required && required.length > 0) {
            result.required = required;
        }
        if (additionalProperties !== undefined) {
            result.additionalProperties = additionalProperties;
        }
        if (propertyNames !== undefined) {
            result.propertyNames = propertyNames;
        }
    }
    if (tagsAreSet) {
        result.tags = tags;
    }
    return result;
}
function arraySchema(items) {
    if (items) {
        return {
            "type": "array",
            "description": `be an array of values, where each element must ${schemaDescription(items)}`,
            items
        };
    } else {
        return {
            "type": "array",
            "description": `be an array of values`
        };
    }
}
function documentSchema(schema9, doc) {
    const result = Object.assign({}, schema9);
    result.documentation = doc;
    return result;
}
function describeSchema(schema10, description) {
    const result = Object.assign({}, schema10);
    result.description = `be ${description}`;
    return result;
}
function completeSchema(schema11, ...completions) {
    const result = Object.assign({}, schema11);
    const prevCompletions = (schema11.completions || []).slice();
    prevCompletions.push(...completions);
    result.completions = prevCompletions;
    return result;
}
function completeSchemaOverwrite(schema12, ...completions) {
    const result = Object.assign({}, schema12);
    result.completions = completions;
    return result;
}
function idSchema(schema13, id) {
    const result = Object.assign({}, schema13);
    result["$id"] = id;
    return result;
}
function errorMessageSchema(schema14, errorMessage) {
    return {
        ...schema14,
        errorMessage
    };
}
function refSchema($ref, description) {
    return {
        "type": "ref",
        $ref,
        description
    };
}
function valueSchema(val, description) {
    return {
        "type": "enum",
        "enum": [
            val
        ],
        "description": description || `be ${JSON.stringify(val)}`
    };
}
const definitionsObject = {};
function hasSchemaDefinition(key) {
    return definitionsObject[key] !== undefined;
}
function getSchemaDefinition(key) {
    if (definitionsObject[key] === undefined) {
        throw new Error(`Internal Error: Schema ${key} not found.`);
    }
    return definitionsObject[key];
}
function setSchemaDefinition(schema15) {
    if (schema15.$id === undefined) {
        throw new Error("Internal Error, setSchemaDefinition needs $id");
    }
    if (definitionsObject[schema15.$id] === undefined) {
        definitionsObject[schema15.$id] = schema15;
    }
}
function getSchemaDefinitionsObject() {
    return Object.assign({}, definitionsObject);
}
function expandAliasesFrom(lst, defs) {
    const aliases = defs;
    const result = [];
    lst = lst.slice();
    for(let i39 = 0; i39 < lst.length; ++i39){
        const el = lst[i39];
        if (el.startsWith("$")) {
            const v = aliases[el.slice(1)];
            if (v === undefined) {
                throw new Error(`Internal Error: ${el} doesn't have an entry in the aliases map`);
            }
            lst.push(...v);
        } else {
            result.push(el);
        }
    }
    return result;
}
function resolveSchema(schema16, visit, hasRef, next) {
    if (schema16 === false || schema16 === true) {
        return schema16;
    }
    if (hasRef === undefined) {
        hasRef = (cursor)=>{
            return schemaCall(cursor, {
                ref: (_s)=>true
            }, (_s)=>false
            );
        };
    }
    if (!hasRef(schema16)) {
        return schema16;
    }
    if (visit === undefined) {
        visit = (_schema)=>{};
    }
    if (next === undefined) {
        next = (cursor)=>{
            const result = schemaCall(cursor, {
                ref: (s)=>getSchemaDefinition(s.$ref)
            });
            if (result === undefined) {
                throw new Error("Internal Error, couldn't resolve schema ${JSON.stringify(cursor)}");
            }
            return result;
        };
    }
    let cursor1 = schema16;
    let cursor2 = schema16;
    let stopped = false;
    do {
        cursor1 = next(cursor1);
        visit(cursor1);
        if (hasRef(cursor2)) {
            cursor2 = next(cursor2);
        } else {
            stopped = true;
        }
        if (hasRef(cursor2)) {
            cursor2 = next(cursor2);
        } else {
            stopped = true;
        }
        if (!stopped && cursor1 === cursor2) {
            throw new Error(`reference cycle detected at ${JSON.stringify(cursor1)}`);
        }
    }while (hasRef(cursor1))
    return cursor1;
}
Object.freeze({
    __proto__: null
});
class DataSet {
    constructor(raw2018, raw2019, raw2020, raw2021){
        this._raw2018 = raw2018;
        this._raw2019 = raw2019;
        this._raw2020 = raw2020;
        this._raw2021 = raw2021;
    }
    get es2018() {
        return this._set2018 || (this._set2018 = new Set(this._raw2018.split(" ")));
    }
    get es2019() {
        return this._set2019 || (this._set2019 = new Set(this._raw2019.split(" ")));
    }
    get es2020() {
        return this._set2020 || (this._set2020 = new Set(this._raw2020.split(" ")));
    }
    get es2021() {
        return this._set2021 || (this._set2021 = new Set(this._raw2021.split(" ")));
    }
}
new Set([
    "General_Category",
    "gc"
]);
new Set([
    "Script",
    "Script_Extensions",
    "sc",
    "scx"
]);
new DataSet("C Cased_Letter Cc Cf Close_Punctuation Cn Co Combining_Mark Connector_Punctuation Control Cs Currency_Symbol Dash_Punctuation Decimal_Number Enclosing_Mark Final_Punctuation Format Initial_Punctuation L LC Letter Letter_Number Line_Separator Ll Lm Lo Lowercase_Letter Lt Lu M Mark Math_Symbol Mc Me Mn Modifier_Letter Modifier_Symbol N Nd Nl No Nonspacing_Mark Number Open_Punctuation Other Other_Letter Other_Number Other_Punctuation Other_Symbol P Paragraph_Separator Pc Pd Pe Pf Pi Po Private_Use Ps Punctuation S Sc Separator Sk Sm So Space_Separator Spacing_Mark Surrogate Symbol Titlecase_Letter Unassigned Uppercase_Letter Z Zl Zp Zs cntrl digit punct", "", "", "");
new DataSet("Adlam Adlm Aghb Ahom Anatolian_Hieroglyphs Arab Arabic Armenian Armi Armn Avestan Avst Bali Balinese Bamu Bamum Bass Bassa_Vah Batak Batk Beng Bengali Bhaiksuki Bhks Bopo Bopomofo Brah Brahmi Brai Braille Bugi Buginese Buhd Buhid Cakm Canadian_Aboriginal Cans Cari Carian Caucasian_Albanian Chakma Cham Cher Cherokee Common Copt Coptic Cprt Cuneiform Cypriot Cyrillic Cyrl Deseret Deva Devanagari Dsrt Dupl Duployan Egyp Egyptian_Hieroglyphs Elba Elbasan Ethi Ethiopic Geor Georgian Glag Glagolitic Gonm Goth Gothic Gran Grantha Greek Grek Gujarati Gujr Gurmukhi Guru Han Hang Hangul Hani Hano Hanunoo Hatr Hatran Hebr Hebrew Hira Hiragana Hluw Hmng Hung Imperial_Aramaic Inherited Inscriptional_Pahlavi Inscriptional_Parthian Ital Java Javanese Kaithi Kali Kana Kannada Katakana Kayah_Li Khar Kharoshthi Khmer Khmr Khoj Khojki Khudawadi Knda Kthi Lana Lao Laoo Latin Latn Lepc Lepcha Limb Limbu Lina Linb Linear_A Linear_B Lisu Lyci Lycian Lydi Lydian Mahajani Mahj Malayalam Mand Mandaic Mani Manichaean Marc Marchen Masaram_Gondi Meetei_Mayek Mend Mende_Kikakui Merc Mero Meroitic_Cursive Meroitic_Hieroglyphs Miao Mlym Modi Mong Mongolian Mro Mroo Mtei Mult Multani Myanmar Mymr Nabataean Narb Nbat New_Tai_Lue Newa Nko Nkoo Nshu Nushu Ogam Ogham Ol_Chiki Olck Old_Hungarian Old_Italic Old_North_Arabian Old_Permic Old_Persian Old_South_Arabian Old_Turkic Oriya Orkh Orya Osage Osge Osma Osmanya Pahawh_Hmong Palm Palmyrene Pau_Cin_Hau Pauc Perm Phag Phags_Pa Phli Phlp Phnx Phoenician Plrd Prti Psalter_Pahlavi Qaac Qaai Rejang Rjng Runic Runr Samaritan Samr Sarb Saur Saurashtra Sgnw Sharada Shavian Shaw Shrd Sidd Siddham SignWriting Sind Sinh Sinhala Sora Sora_Sompeng Soyo Soyombo Sund Sundanese Sylo Syloti_Nagri Syrc Syriac Tagalog Tagb Tagbanwa Tai_Le Tai_Tham Tai_Viet Takr Takri Tale Talu Tamil Taml Tang Tangut Tavt Telu Telugu Tfng Tglg Thaa Thaana Thai Tibetan Tibt Tifinagh Tirh Tirhuta Ugar Ugaritic Vai Vaii Wara Warang_Citi Xpeo Xsux Yi Yiii Zanabazar_Square Zanb Zinh Zyyy", "Dogr Dogra Gong Gunjala_Gondi Hanifi_Rohingya Maka Makasar Medefaidrin Medf Old_Sogdian Rohg Sogd Sogdian Sogo", "Elym Elymaic Hmnp Nand Nandinagari Nyiakeng_Puachue_Hmong Wancho Wcho", "Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi");
new DataSet("AHex ASCII ASCII_Hex_Digit Alpha Alphabetic Any Assigned Bidi_C Bidi_Control Bidi_M Bidi_Mirrored CI CWCF CWCM CWKCF CWL CWT CWU Case_Ignorable Cased Changes_When_Casefolded Changes_When_Casemapped Changes_When_Lowercased Changes_When_NFKC_Casefolded Changes_When_Titlecased Changes_When_Uppercased DI Dash Default_Ignorable_Code_Point Dep Deprecated Dia Diacritic Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Ext Extender Gr_Base Gr_Ext Grapheme_Base Grapheme_Extend Hex Hex_Digit IDC IDS IDSB IDST IDS_Binary_Operator IDS_Trinary_Operator ID_Continue ID_Start Ideo Ideographic Join_C Join_Control LOE Logical_Order_Exception Lower Lowercase Math NChar Noncharacter_Code_Point Pat_Syn Pat_WS Pattern_Syntax Pattern_White_Space QMark Quotation_Mark RI Radical Regional_Indicator SD STerm Sentence_Terminal Soft_Dotted Term Terminal_Punctuation UIdeo Unified_Ideograph Upper Uppercase VS Variation_Selector White_Space XIDC XIDS XID_Continue XID_Start space", "Extended_Pictographic", "", "EBase EComp EMod EPres ExtPict");
({
    at (s, end, i40) {
        return i40 < end ? s.charCodeAt(i40) : -1;
    },
    width (c) {
        return 1;
    }
});
({
    at (s, end, i41) {
        return i41 < end ? s.codePointAt(i41) : -1;
    },
    width (c) {
        return c > 0xffff ? 2 : 1;
    }
});
function navigateSchemaBySchemaPathSingle(schema17, path45) {
    const ensurePathFragment = (fragment, expected)=>{
        if (fragment !== expected) {
            throw new Error(`Internal Error in navigateSchemaBySchemaPathSingle: ${fragment} !== ${expected}`);
        }
    };
    const inner = (subschema, index)=>{
        subschema = resolveSchema(subschema);
        if (subschema === undefined) {
            throw new Error(`Internal Error in navigateSchemaBySchemaPathSingle: invalid path navigation`);
        }
        if (index === path45.length) {
            return subschema;
        }
        const st = schemaType(subschema);
        switch(st){
            case "anyOf":
                ensurePathFragment(path45[index], "anyOf");
                return inner(subschema.anyOf[path45[index + 1]], index + 2);
            case "allOf":
                ensurePathFragment(path45[index], "allOf");
                return inner(subschema.allOf[path45[index + 1]], index + 2);
            case "array":
                ensurePathFragment(path45[index], "array");
                return inner(subschema.arrayOf.schema, index + 2);
            case "object":
                ensurePathFragment(path45[index], "object");
                if (path45[index + 1] === "properties") {
                    return inner(subschema.properties[path45[index + 2]], index + 3);
                } else if (path45[index + 1] === "patternProperties") {
                    return inner(subschema.patternProperties[path45[index + 2]], index + 3);
                } else if (path45[index + 1] === "additionalProperties") {
                    return inner(subschema.additionalProperties, index + 2);
                } else {
                    throw new Error(`Internal Error in navigateSchemaBySchemaPathSingle: bad path fragment ${path45[index]} in object navigation`);
                }
            default:
                throw new Error(`Internal Error in navigateSchemaBySchemaPathSingle: can't navigate schema type ${st}`);
        }
    };
    return inner(schema17, 0);
}
function resolveDescription(s) {
    if (typeof s === "string") {
        return s;
    }
    const valueS = resolveSchema(s);
    if (valueS === false || valueS === true) {
        return "";
    }
    if (valueS.documentation === undefined) {
        return "";
    }
    if (typeof valueS.documentation === "string") {
        return valueS.documentation;
    }
    if (valueS.documentation.short) {
        return valueS.documentation.short;
    } else {
        return "";
    }
}
function schemaCompletions(s1) {
    if (s1 === true || s1 === false) {
        return [];
    }
    let schema1 = resolveSchema(s1);
    schema1 = resolveSchema(schema1, (_schema)=>{}, (schema18)=>{
        return schema18.tags !== undefined && schema18.tags["complete-from"] !== undefined;
    }, (schema19)=>{
        return navigateSchemaBySchemaPathSingle(schema19, schema19.tags["complete-from"]);
    });
    if (schema1 === true || schema1 === false) {
        return [];
    }
    const normalize8 = (completions)=>{
        const result = (completions || []).map((c)=>{
            if (typeof c === "string") {
                return {
                    type: "value",
                    display: c,
                    value: c,
                    description: "",
                    suggest_on_accept: false,
                    schema: schema1
                };
            }
            return {
                ...c,
                description: resolveDescription(c.description),
                schema: schema1
            };
        });
        return result;
    };
    if (schema1.completions && schema1.completions.length) {
        return normalize8(schema1.completions);
    }
    if (schema1.tags && schema1.tags.completions && schema1.tags.completions.length) {
        return normalize8(schema1.tags.completions);
    }
    return schemaCall(schema1, {
        array: (s)=>{
            if (s.items) {
                return schemaCompletions(s.items);
            } else {
                return [];
            }
        },
        anyOf: (s)=>{
            return s.anyOf.map(schemaCompletions).flat();
        },
        allOf: (s)=>{
            return s.allOf.map(schemaCompletions).flat();
        },
        "object": (s)=>{
            s.cachedCompletions = getObjectCompletions(s);
            return normalize8(s.cachedCompletions);
        }
    }, (_)=>[]
    );
}
function getObjectCompletions(s) {
    const completionsParam = s.tags && s.tags.completions || [];
    return schemaCall(s, {
        "object": (schema3)=>{
            const properties = schema3.properties;
            const objectKeys = completionsParam.length ? completionsParam : Object.getOwnPropertyNames(properties);
            const completions = [];
            for (const k1 of objectKeys){
                const schema2 = properties && properties[k1];
                const maybeDescriptions = [];
                let hidden25 = false;
                if (schema2 !== undefined && schema2 !== true && schema2 !== false) {
                    if (schema2.documentation) {
                        maybeDescriptions.push(schemaDocString(schema2.documentation));
                    } else {
                        let described = false;
                        const visitor = (schema20)=>{
                            if (schema20 === false || schema20 === true) {
                                return;
                            }
                            if (schema20.hidden) {
                                hidden25 = true;
                            }
                            if (described) {
                                return;
                            }
                            if (schema20.documentation) {
                                maybeDescriptions.push(schemaDocString(schema20.documentation));
                                described = true;
                            }
                        };
                        try {
                            resolveSchema(schema2, visitor);
                        } catch (_e) {}
                        if (!described) {
                            schemaDispatch(schema2, {
                                ref: (schema21)=>maybeDescriptions.push({
                                        $ref: schema21.$ref
                                    })
                            });
                        }
                    }
                }
                if (hidden25) {
                    continue;
                }
                let description = "";
                for (const md of maybeDescriptions){
                    if (md !== undefined) {
                        description = md;
                        break;
                    }
                }
                completions.push({
                    type: "key",
                    display: "",
                    value: `${k1}: `,
                    description,
                    suggest_on_accept: true
                });
            }
            return completions;
        }
    }, (_)=>completionsParam.map((c)=>({
                type: "value",
                display: "",
                value: c,
                description: "",
                suggest_on_accept: false
            })
        )
    );
}
function possibleSchemaKeys(schema22) {
    const precomputedCompletions = schemaCompletions(schema22).filter((c)=>c.type === "key"
    ).map((c)=>c.value.split(":")[0]
    );
    if (precomputedCompletions.length) {
        return precomputedCompletions;
    }
    const results = [];
    walkSchema(schema22, {
        "object": (s)=>{
            results.push(...Object.keys(s.properties || {}));
            return true;
        },
        "array": (_s)=>true
    });
    return results;
}
function possibleSchemaValues(schema23) {
    const results = [];
    walkSchema(schema23, {
        "enum": (s)=>{
            results.push(...s["enum"].map(String));
            return true;
        },
        "array": (_s)=>true
        ,
        "object": (_s)=>true
    });
    return results;
}
function walkSchema(schema24, f) {
    const recur = {
        "anyOf": (ss)=>{
            for (const s of ss.anyOf){
                walkSchema(s, f);
            }
        },
        "allOf": (ss)=>{
            for (const s of ss.allOf){
                walkSchema(s, f);
            }
        },
        "array": (x)=>{
            if (x.items) {
                walkSchema(x.items, f);
            }
        },
        "object": (x)=>{
            if (x.properties) {
                for (const ss of Object.values(x.properties)){
                    walkSchema(ss, f);
                }
            }
            if (x.patternProperties) {
                for (const ss of Object.values(x.patternProperties)){
                    walkSchema(ss, f);
                }
            }
            if (x.propertyNames) {
                walkSchema(x.propertyNames, f);
            }
        }
    };
    if (typeof f === "function") {
        if (f(schema24) === true) {
            return;
        }
    } else {
        if (schemaCall(schema24, f, (_)=>false
        ) === true) {
            return;
        }
    }
    schemaCall(schema24, recur, (_)=>false
    );
}
function setDefaultErrorHandlers(validator) {
    validator.addHandler(ignoreExprViolations);
    validator.addHandler(expandEmptySpan);
    validator.addHandler(improveErrorHeadingForValueErrors);
    validator.addHandler(checkForTypeMismatch);
    validator.addHandler(checkForBadBoolean);
    validator.addHandler(checkForBadColon);
    validator.addHandler(identifyKeyErrors);
    validator.addHandler(checkForNearbyCorrection);
    validator.addHandler(checkForNearbyRequired);
    validator.addHandler(schemaDefinedErrors);
}
function errorKeyword(error9) {
    if (error9.schemaPath.length === 0) {
        return "";
    }
    return String(error9.schemaPath[error9.schemaPath.length - 1]);
}
function getBadKey(error10) {
    if (error10.schemaPath.indexOf("propertyNames") === -1) {
        return undefined;
    }
    const result = error10.violatingObject.result;
    if (typeof result !== "string") {
        throw new Error("Internal Error: propertyNames error has a violating non-string.");
    }
    return result;
}
function getVerbatimInput(error11) {
    return error11.source.value;
}
function navigate(path46, annotation, returnKey = false, pathIndex = 0) {
    if (annotation === undefined) {
        throw new Error("Can't navigate an undefined annotation");
    }
    if (pathIndex >= path46.length) {
        return annotation;
    }
    if (annotation.kind === "mapping" || annotation.kind === "block_mapping") {
        const { components  } = annotation;
        const searchKey = path46[pathIndex];
        const lastKeyIndex = ~~((components.length - 1) / 2) * 2;
        for(let i42 = lastKeyIndex; i42 >= 0; i42 -= 2){
            const key = components[i42].result;
            if (key === searchKey) {
                if (returnKey && pathIndex === path46.length - 1) {
                    return navigate(path46, components[i42], returnKey, pathIndex + 1);
                } else {
                    return navigate(path46, components[i42 + 1], returnKey, pathIndex + 1);
                }
            }
        }
        return annotation;
    } else if ([
        "sequence",
        "block_sequence",
        "flow_sequence"
    ].indexOf(annotation.kind) !== -1) {
        const searchKey = Number(path46[pathIndex]);
        if (isNaN(searchKey) || searchKey < 0 || searchKey >= annotation.components.length) {
            return annotation;
        }
        return navigate(path46, annotation.components[searchKey], returnKey, pathIndex + 1);
    } else {
        return annotation;
    }
}
function isEmptyValue(error12) {
    const rawVerbatimInput = getVerbatimInput(error12);
    return rawVerbatimInput.trim().length === 0;
}
function getLastFragment(instancePath) {
    if (instancePath.length === 0) {
        return undefined;
    }
    return instancePath[instancePath.length - 1];
}
function reindent(str72) {
    return str72;
}
function ignoreExprViolations(error13, _parse, _schema) {
    const { result  } = error13.violatingObject;
    if (typeof result !== "object" || Array.isArray(result) || result === null || error13.schemaPath.slice(-1)[0] !== "type") {
        return error13;
    }
    if (result.tag === "!expr" && typeof result.value === "string") {
        return null;
    } else {
        return error13;
    }
}
function formatHeadingForKeyError(_error, _parse, _schema, key) {
    return `property name ${blue1(key)} is invalid`;
}
function formatHeadingForValueError(error14, _parse, _schema) {
    const rawVerbatimInput = reindent(getVerbatimInput(error14));
    const rawLines = lines(rawVerbatimInput);
    let verbatimInput;
    if (rawLines.length > 4) {
        verbatimInput = quotedStringColor([
            ...rawLines.slice(0, 2),
            "...",
            ...rawLines.slice(-2)
        ].join("\n"));
    } else {
        verbatimInput = quotedStringColor(rawVerbatimInput);
    }
    const empty1 = isEmptyValue(error14);
    const lastFragment = getLastFragment(error14.instancePath);
    switch(typeof lastFragment){
        case "undefined":
            if (empty1) {
                return "YAML value is missing.";
            } else {
                return `YAML value ${verbatimInput} must ${schemaDescription(error14.schema)}.`;
            }
        case "number":
            if (empty1) {
                return `Array entry ${lastFragment + 1} is empty but it must instead ${schemaDescription(error14.schema)}.`;
            } else {
                return `Array entry ${lastFragment + 1} with value ${verbatimInput} failed to ${schemaDescription(error14.schema)}.`;
            }
        case "string":
            {
                const formatLastFragment = blue1(lastFragment);
                if (empty1) {
                    return `Key ${formatLastFragment} has empty value but it must instead ${schemaDescription(error14.schema)}`;
                } else {
                    return `Key ${formatLastFragment} has value ${verbatimInput}, which must ${schemaDescription(error14.schema)}`;
                }
            }
    }
}
function identifyKeyErrors(error15, parse16, schema25) {
    if (error15.schemaPath.indexOf("propertyNames") === -1) {
        return error15;
    }
    const badKey = getBadKey(error15);
    if (badKey) {
        if (error15.instancePath.length && error15.instancePath[error15.instancePath.length - 1] !== badKey) {
            addInstancePathInfo(error15.niceError, [
                ...error15.instancePath,
                badKey
            ]);
        } else {
            addInstancePathInfo(error15.niceError, error15.instancePath);
        }
        error15.niceError.heading = formatHeadingForKeyError(error15, parse16, schema25, badKey);
    }
    return error15;
}
function improveErrorHeadingForValueErrors(error16, parse17, schema26) {
    if (error16.schemaPath.indexOf("propertyNames") !== -1 || errorKeyword(error16) === "required") {
        return error16;
    }
    return {
        ...error16,
        niceError: {
            ...error16.niceError,
            heading: formatHeadingForValueError(error16, parse17, schema26)
        }
    };
}
function expandEmptySpan(error17, parse18, _schema) {
    if (error17.location.start.line !== error17.location.end.line || error17.location.start.column !== error17.location.end.column || !isEmptyValue(error17) || typeof getLastFragment(error17.instancePath) === "undefined") {
        return error17;
    }
    const lastKey = navigate(error17.instancePath, parse18, true);
    const locF = mappedIndexToLineCol(parse18.source);
    try {
        const location = {
            start: locF(lastKey.start),
            end: locF(lastKey.end)
        };
        return {
            ...error17,
            location,
            niceError: {
                ...error17.niceError,
                location
            }
        };
    } catch (_e) {
        return error17;
    }
}
function checkForTypeMismatch(error18, parse19, schema27) {
    const rawVerbatimInput = getVerbatimInput(error18);
    const rawLines = lines(rawVerbatimInput);
    let verbatimInput;
    if (rawLines.length > 4) {
        verbatimInput = quotedStringColor([
            ...rawLines.slice(0, 2),
            "...",
            ...rawLines.slice(-2)
        ].join("\n"));
    } else {
        verbatimInput = quotedStringColor(rawVerbatimInput);
    }
    const goodType = (obj)=>{
        if (Array.isArray(obj)) {
            return "an array";
        }
        if (obj === null) {
            return "a null value";
        }
        return typeof obj;
    };
    if (errorKeyword(error18) === "type" && rawVerbatimInput.length > 0) {
        const newError = {
            ...error18.niceError,
            heading: formatHeadingForValueError(error18, parse19, schema27),
            error: [
                `The value ${verbatimInput} is ${goodType(error18.violatingObject.result)}.`, 
            ],
            info: {},
            location: error18.niceError.location
        };
        addInstancePathInfo(newError, error18.instancePath);
        addFileInfo(newError, error18.source);
        return {
            ...error18,
            niceError: newError
        };
    }
    return error18;
}
function checkForBadBoolean(error19, parse20, _schema) {
    const schema28 = error19.schema;
    if (!(typeof error19.violatingObject.result === "string" && errorKeyword(error19) === "type" && schemaType(schema28) === "boolean")) {
        return error19;
    }
    const strValue = error19.violatingObject.result;
    const verbatimInput = quotedStringColor(getVerbatimInput(error19));
    const yesses = new Set("y|Y|yes|Yes|YES|true|True|TRUE|on|On|ON".split("|"));
    const nos = new Set("n|N|no|No|NO|false|False|FALSE|off|Off|OFF".split("|"));
    let fix;
    if (yesses.has(strValue)) {
        fix = true;
    } else if (nos.has(strValue)) {
        fix = false;
    } else {
        return error19;
    }
    const errorMessage = `The value ${verbatimInput} is a string.`;
    const suggestion1 = `Quarto uses YAML 1.2, which interprets booleans strictly.`;
    const suggestion2 = `Try using ${quotedStringColor(String(fix))} instead.`;
    const newError = {
        heading: formatHeadingForValueError(error19, parse20, schema28),
        error: [
            errorMessage
        ],
        info: {},
        location: error19.niceError.location
    };
    addInstancePathInfo(newError, error19.instancePath);
    addFileInfo(newError, error19.source);
    newError.info["yaml-version-1.2"] = suggestion1;
    newError.info["suggestion-fix"] = suggestion2;
    return {
        ...error19,
        niceError: newError
    };
}
function checkForBadColon(error20, parse21, schema29) {
    if (typeof error20.violatingObject.result !== "string") {
        return error20;
    }
    const e = error20.schemaPath.slice(-2);
    if (e.length !== 2) {
        return error20;
    }
    if (e[0] !== "object" || e[1] !== "type") {
        return error20;
    }
    if (!error20.violatingObject.result.match(/^.+:[^ ].*$/)) {
        return error20;
    }
    const verbatimInput = quotedStringColor(getVerbatimInput(error20));
    const errorMessage = `The value ${verbatimInput} is a string.`;
    const suggestion1 = `In YAML, key-value pairs in objects must be separated by a space.`;
    const suggestion2 = `Did you mean ${quotedStringColor(quotedStringColor(getVerbatimInput(error20)).replace(/:/g, ": "))} instead?`;
    const newError = {
        heading: formatHeadingForValueError(error20, parse21, schema29),
        error: [
            errorMessage
        ],
        info: {},
        location: error20.niceError.location
    };
    addInstancePathInfo(newError, error20.instancePath);
    addFileInfo(newError, error20.source);
    newError.info["yaml-key-value-pairs"] = suggestion1;
    newError.info["suggestion-fix"] = suggestion2;
    return {
        ...error20,
        niceError: newError
    };
}
function createErrorFragments(error21) {
    const rawVerbatimInput = getVerbatimInput(error21);
    const verbatimInput = quotedStringColor(reindent(rawVerbatimInput));
    const pathFragments = error21.instancePath.map((s)=>blue1(String(s))
    );
    return {
        location: locationString(error21.location),
        fullPath: pathFragments.join(":"),
        key: pathFragments[pathFragments.length - 1],
        value: verbatimInput
    };
}
function schemaDefinedErrors(error22, _parse, _schema) {
    const schema30 = error22.schema;
    if (schema30 === true || schema30 === false) {
        return error22;
    }
    if (schema30.errorMessage === undefined) {
        return error22;
    }
    if (typeof schema30.errorMessage !== "string") {
        return error22;
    }
    let result = schema30.errorMessage;
    for (const [k, v] of Object.entries(createErrorFragments(error22))){
        result = result.replace("${" + k + "}", v);
    }
    return {
        ...error22,
        niceError: {
            ...error22.niceError,
            heading: result
        }
    };
}
function checkForNearbyRequired(error23, _parse, _schema) {
    const schema31 = error23.schema;
    if (errorKeyword(error23) !== "required") {
        return error23;
    }
    const missingKeys = [];
    const errObj = error23.violatingObject.result;
    const keys6 = Object.keys(errObj);
    schemaCall(schema31, {
        object (s) {
            if (s.required === undefined) {
                throw new Error("Internal Error: required schema error without a required field");
            }
            for (const r of s.required){
                if (keys6.indexOf(r) === -1) {
                    missingKeys.push(r);
                }
            }
        }
    }, (_)=>{
        throw new Error("Internal Error: required error on a non-object schema");
    });
    for (const missingKey of missingKeys){
        let bestCorrection;
        let bestDistance = Infinity;
        for (const correction of keys6){
            const d = editDistance(correction, missingKey);
            if (d < bestDistance) {
                bestCorrection = [
                    correction
                ];
                bestDistance = d;
            } else if (d === bestDistance) {
                bestCorrection.push(correction);
                bestDistance = d;
            }
        }
        if (bestDistance > missingKey.length * 10 * 0.3) {
            continue;
        }
        const suggestions = bestCorrection.map((s)=>blue1(s)
        );
        if (suggestions.length === 1) {
            error23.niceError.info[`did-you-mean-key`] = `Is ${suggestions[0]} a typo of ${blue1(missingKey)}?`;
        } else if (suggestions.length === 2) {
            error23.niceError.info[`did-you-mean-key`] = `Is ${suggestions[0]} or ${suggestions[1]} a typo of ${blue1(missingKey)}?`;
        } else {
            suggestions[suggestions.length - 1] = `or ${suggestions[suggestions.length - 1]}`;
            error23.niceError.info[`did-you-mean-key`] = `Is one of ${suggestions.join(", ")} a typo of ${blue1(missingKey)}?`;
        }
    }
    return error23;
}
function checkForNearbyCorrection(error24, parse22, _schema) {
    const schema32 = error24.schema;
    const corrections = [];
    let errVal = "";
    let keyOrValue = "";
    const key = getBadKey(error24);
    if (key) {
        errVal = key;
        corrections.push(...possibleSchemaKeys(schema32));
        keyOrValue = "key";
    } else {
        const val = navigate(error24.instancePath, parse22);
        if (typeof val.result !== "string") {
            return error24;
        }
        errVal = val.result;
        corrections.push(...possibleSchemaValues(schema32));
        keyOrValue = "value";
    }
    if (corrections.length === 0) {
        return error24;
    }
    let bestCorrection;
    let bestDistance = Infinity;
    for (const correction of corrections){
        const d = editDistance(correction, errVal);
        if (d < bestDistance) {
            bestCorrection = [
                correction
            ];
            bestDistance = d;
        } else if (d === bestDistance) {
            bestCorrection.push(correction);
            bestDistance = d;
        }
    }
    if (bestDistance > errVal.length * 10 * 0.3) {
        return error24;
    }
    const suggestions = bestCorrection.map((s)=>blue1(s)
    );
    if (suggestions.length === 1) {
        error24.niceError.info[`did-you-mean-${keyOrValue}`] = `Did you mean ${suggestions[0]}?`;
    } else if (suggestions.length === 2) {
        error24.niceError.info[`did-you-mean-${keyOrValue}`] = `Did you mean ${suggestions[0]} or ${suggestions[1]}?`;
    } else {
        suggestions[suggestions.length - 1] = `or ${suggestions[suggestions.length - 1]}`;
        error24.niceError.info[`did-you-mean-${keyOrValue}`] = `Did you mean ${suggestions.join(", ")}?`;
    }
    return error24;
}
function createSourceContext(src9, location) {
    const startMapResult = src9.map(location.start, true);
    const endMapResult = src9.map(location.end, true);
    const locF = mappedIndexToLineCol(src9);
    let sourceLocation;
    try {
        sourceLocation = {
            start: locF(location.start),
            end: locF(location.end)
        };
    } catch (_e) {
        sourceLocation = {
            start: {
                line: 0,
                column: 0
            },
            end: {
                line: 0,
                column: 0
            }
        };
    }
    if (startMapResult === undefined || endMapResult === undefined) {
        throw new Error("Internal Error: createSourceContext called with bad location.");
    }
    if (startMapResult.originalString !== endMapResult.originalString) {
        throw new Error("Internal Error: don't know how to create source context across different source files");
    }
    const originalString = startMapResult.originalString;
    const nLines = lines(originalString.value).length;
    const { start , end ,  } = sourceLocation;
    const { prefixWidth , lines: formattedLines ,  } = formatLineRange(originalString.value, Math.max(0, start.line - 1), Math.min(end.line + 1, nLines - 1));
    const contextLines = [];
    let mustPrintEllipsis = true;
    for (const { lineNumber , content , rawLine  } of formattedLines){
        if (lineNumber < start.line || lineNumber > end.line) {
            if (rawLine.trim().length) {
                contextLines.push(content);
            }
        } else {
            if (lineNumber >= start.line + 2 && lineNumber <= end.line - 2) {
                if (mustPrintEllipsis) {
                    mustPrintEllipsis = false;
                    contextLines.push("...");
                }
            } else {
                const startColumn = lineNumber > start.line ? 0 : start.column;
                const endColumn = lineNumber < end.line ? rawLine.length : end.column;
                contextLines.push(content);
                contextLines.push(" ".repeat(prefixWidth + startColumn) + "~".repeat(endColumn - startColumn));
            }
        }
    }
    return contextLines.join("\n");
}
function createLocalizedError(obj) {
    const { violatingObject , instancePath , schemaPath , source , message , schema: schema33 ,  } = obj;
    const locF = mappedIndexToLineCol(source);
    let location;
    try {
        location = {
            start: locF(violatingObject.start),
            end: locF(violatingObject.end)
        };
    } catch (_e) {
        location = {
            start: {
                line: 0,
                column: 0
            },
            end: {
                line: 0,
                column: 0
            }
        };
    }
    const mapResult = source.map(violatingObject.start);
    const fileName = mapResult ? mapResult.originalString.fileName : undefined;
    return {
        source: mappedString(source, [
            {
                start: violatingObject.start,
                end: violatingObject.end
            }
        ]),
        violatingObject: violatingObject,
        instancePath,
        schemaPath,
        schema: schema33,
        message,
        location: location,
        niceError: {
            heading: message,
            error: [],
            info: {},
            fileName,
            location: location,
            sourceContext: createSourceContext(violatingObject.source, {
                start: violatingObject.start,
                end: violatingObject.end
            })
        }
    };
}
class ValidationContext {
    instancePath;
    root;
    nodeStack;
    currentNode;
    constructor(){
        this.instancePath = [];
        this.currentNode = {
            edge: "#",
            errors: [],
            children: []
        };
        this.nodeStack = [
            this.currentNode
        ];
        this.root = this.currentNode;
    }
    error(value, schema34, message) {
        this.currentNode.errors.push({
            value,
            schema: schema34,
            message,
            instancePath: this.instancePath.slice(),
            schemaPath: this.nodeStack.map((node)=>node.edge
            )
        });
    }
    pushSchema(schemaPath) {
        const newNode = {
            edge: schemaPath,
            errors: [],
            children: []
        };
        this.currentNode.children.push(newNode);
        this.currentNode = newNode;
        this.nodeStack.push(newNode);
    }
    popSchema(success) {
        this.nodeStack.pop();
        this.currentNode = this.nodeStack[this.nodeStack.length - 1];
        if (success) {
            this.currentNode.children.pop();
        }
        return success;
    }
    pushInstance(instance) {
        this.instancePath.push(instance);
    }
    popInstance() {
        this.instancePath.pop();
    }
    withSchemaPath(schemaPath, chunk) {
        this.pushSchema(schemaPath);
        return this.popSchema(chunk());
    }
    validate(schema35, source, value, pruneErrors = true) {
        if (validateGeneric(value, schema35, this)) {
            return [];
        }
        return this.collectErrors(schema35, source, value, pruneErrors);
    }
    collectErrors(_schema, source, _value, pruneErrors = true) {
        const inner = (node)=>{
            const result = [];
            if (node.edge === "anyOf" && pruneErrors) {
                const innerResults = node.children.map(inner);
                const isRequiredError = (e)=>e.schemaPath.indexOf("required") === e.schemaPath.length - 1
                ;
                const isPropertyNamesError = (e)=>e.schemaPath.indexOf("propertyNames") !== -1
                ;
                if (innerResults.some((el)=>el.length && isRequiredError(el[0])
                ) && innerResults.some((el)=>el.length && isPropertyNamesError(el[0])
                )) {
                    return innerResults.filter((r)=>{
                        return r.length && r[0].schemaPath.slice(-1)[0] === "required";
                    })[0];
                }
                const errorTypeQuality = (e)=>{
                    const t = e.schemaPath.slice().reverse();
                    if (e.schemaPath.indexOf("propertyNames") !== -1) {
                        return 10;
                    }
                    if (t[0] === "required") {
                        return 0;
                    }
                    if (t[0] === "type") {
                        if (t[1] === "null") {
                            return 10;
                        }
                        return 1;
                    }
                    return 1;
                };
                const errorComparator = (a, b)=>{
                    for(let i43 = 0; i43 < a.length; ++i43){
                        if (a[i43] < b[i43]) {
                            return -1;
                        }
                        if (a[i43] > b[i43]) {
                            return 1;
                        }
                    }
                    return 0;
                };
                let bestResults = [];
                let bestError = [
                    Infinity,
                    Infinity
                ];
                for (const resultGroup of innerResults){
                    let maxQuality = -Infinity;
                    let totalSpan = 0;
                    for (const result of resultGroup){
                        totalSpan += result.value.end - result.value.start;
                        maxQuality = Math.max(maxQuality, errorTypeQuality(result));
                    }
                    const thisError = [
                        maxQuality,
                        totalSpan
                    ];
                    if (errorComparator(thisError, bestError) === -1) {
                        bestError = thisError;
                        bestResults = resultGroup;
                    }
                }
                return bestResults;
            } else {
                result.push(...node.errors);
                for (const child of node.children){
                    result.push(...inner(child));
                }
                return result;
            }
        };
        const errors1 = inner(this.root);
        const result1 = errors1.map((validationError)=>createLocalizedError({
                violatingObject: validationError.value,
                instancePath: validationError.instancePath,
                schemaPath: validationError.schemaPath,
                schema: validationError.schema,
                message: validationError.message,
                source
            })
        );
        return result1;
    }
}
function validateGeneric(value, s, context) {
    s = resolveSchema(s);
    const st = schemaType(s);
    return context.withSchemaPath(st, ()=>schemaCall(s, {
            "false": (schema36)=>{
                context.error(value, schema36, "false");
                return false;
            },
            "true": (_)=>true
            ,
            "boolean": (schema37)=>validateBoolean(value, schema37, context)
            ,
            "number": (schema38)=>validateNumber(value, schema38, context)
            ,
            "string": (schema39)=>validateString(value, schema39, context)
            ,
            "null": (schema40)=>validateNull(value, schema40, context)
            ,
            "enum": (schema41)=>validateEnum(value, schema41, context)
            ,
            "anyOf": (schema42)=>validateAnyOf(value, schema42, context)
            ,
            "allOf": (schema43)=>validateAllOf(value, schema43, context)
            ,
            "array": (schema44)=>validateArray(value, schema44, context)
            ,
            "object": (schema45)=>validateObject(value, schema45, context)
            ,
            "ref": (schema46)=>validateGeneric(value, resolveSchema(schema46), context)
        })
    );
}
function typeIsValid(value, schema47, context, valid) {
    if (!valid) {
        return context.withSchemaPath("type", ()=>{
            context.error(value, schema47, "type mismatch");
            return false;
        });
    }
    return valid;
}
function validateBoolean(value, schema48, context) {
    return typeIsValid(value, schema48, context, typeof value.result === "boolean");
}
function validateNumber(value, schema49, context) {
    if (!typeIsValid(value, schema49, context, typeof value.result === "number")) {
        return false;
    }
    let result = true;
    if (schema49.minimum !== undefined) {
        result = context.withSchemaPath("minimum", ()=>{
            const v = value.result;
            if (!(v >= schema49.minimum)) {
                context.error(value, schema49, `value ${value.result} is less than required minimum ${schema49.minimum}`);
                return false;
            }
            return true;
        });
    }
    if (schema49.maximum !== undefined) {
        result = context.withSchemaPath("maximum", ()=>{
            const v = value.result;
            if (!(v <= schema49.maximum)) {
                context.error(value, schema49, `value ${value.result} is greater than required maximum ${schema49.maximum}`);
                return false;
            }
            return true;
        });
    }
    if (schema49.exclusiveMinimum !== undefined) {
        result = context.withSchemaPath("exclusiveMinimum", ()=>{
            const v = value.result;
            if (!(v > schema49.exclusiveMinimum)) {
                context.error(value, schema49, `value ${value.result} is less than or equal to required (exclusive) minimum ${schema49.exclusiveMinimum}`);
                return false;
            }
            return true;
        });
    }
    if (schema49.exclusiveMaximum !== undefined) {
        result = context.withSchemaPath("exclusiveMaximum", ()=>{
            const v = value.result;
            if (!(v < schema49.exclusiveMaximum)) {
                context.error(value, schema49, `value ${value.result} is greater than or equal to required (exclusive) maximum ${schema49.exclusiveMaximum}`);
                return false;
            }
            return true;
        });
    }
    return result;
}
function validateString(value, schema50, context) {
    if (!typeIsValid(value, schema50, context, typeof value.result === "string")) {
        return false;
    }
    if (schema50.pattern !== undefined) {
        if (schema50.compiledPattern === undefined) {
            schema50.compiledPattern = new RegExp(schema50.pattern);
        }
        if (!value.result.match(schema50.compiledPattern)) {
            return context.withSchemaPath("pattern", ()=>{
                context.error(value, schema50, `value doesn't match pattern`);
                return false;
            });
        }
    }
    return true;
}
function validateNull(value, schema51, context) {
    if (!typeIsValid(value, schema51, context, value.result === null)) {
        return false;
    }
    return true;
}
function validateEnum(value, schema52, context) {
    for (const enumValue of schema52["enum"]){
        if (enumValue === value.result) {
            return true;
        }
    }
    context.error(value, schema52, `must match one of the values`);
    return false;
}
function validateAnyOf(value, schema53, context) {
    let passingSchemas = 0;
    for(let i44 = 0; i44 < schema53.anyOf.length; ++i44){
        const subSchema = schema53.anyOf[i44];
        context.withSchemaPath(i44, ()=>{
            if (validateGeneric(value, subSchema, context)) {
                passingSchemas++;
                return true;
            }
            return false;
        });
    }
    return passingSchemas > 0;
}
function validateAllOf(value, schema54, context) {
    let passingSchemas = 0;
    for(let i45 = 0; i45 < schema54.allOf.length; ++i45){
        const subSchema = schema54.allOf[i45];
        context.withSchemaPath(i45, ()=>{
            if (validateGeneric(value, subSchema, context)) {
                passingSchemas++;
                return true;
            }
            return false;
        });
    }
    return passingSchemas === schema54.allOf.length;
}
function validateArray(value, schema55, context) {
    let result2 = true;
    if (!typeIsValid(value, schema55, context, Array.isArray(value.result))) {
        return false;
    }
    const length = value.result.length;
    if (schema55.minItems !== undefined && length < schema55.minItems) {
        context.withSchemaPath("minItems", ()=>{
            context.error(value, schema55, `array should have at least ${schema55.minItems} items but has ${length} items instead`);
            return false;
        });
        result2 = false;
    }
    if (schema55.maxItems !== undefined && length > schema55.maxItems) {
        context.withSchemaPath("maxItems", ()=>{
            context.error(value, schema55, `array should have at most ${schema55.maxItems} items but has ${length} items instead`);
            return false;
        });
        result2 = false;
    }
    if (schema55.items !== undefined) {
        result2 = context.withSchemaPath("items", ()=>{
            let result = true;
            for(let i46 = 0; i46 < value.components.length; ++i46){
                context.pushInstance(i46);
                result = validateGeneric(value.components[i46], schema55.items, context) && result;
                context.popInstance();
            }
            return result;
        }) && result2;
    }
    return result2;
}
function validateObject(value, schema56, context) {
    const isObject4 = typeof value.result === "object" && !Array.isArray(value.result) && value.result !== null;
    if (!typeIsValid(value, schema56, context, isObject4)) {
        return false;
    }
    let result3 = true;
    const ownProperties = new Set(Object.getOwnPropertyNames(value.result));
    const objResult = value.result;
    const locate = (key, keyOrValue = "value")=>{
        for(let i47 = 0; i47 < value.components.length; i47 += 2){
            if (value.components[i47].result === key) {
                if (keyOrValue === "value") {
                    return value.components[i47 + 1];
                } else {
                    return value.components[i47];
                }
            }
        }
        throw new Error(`Internal Error, couldn't locate key ${key}`);
    };
    const inspectedProps = new Set();
    if (schema56.properties !== undefined) {
        result3 = context.withSchemaPath("properties", ()=>{
            let result = true;
            for (const [key, subSchema] of Object.entries(schema56.properties)){
                if (ownProperties.has(key)) {
                    inspectedProps.add(key);
                    context.pushInstance(key);
                    result = context.withSchemaPath(key, ()=>validateGeneric(locate(key), subSchema, context)
                    ) && result;
                    context.popInstance();
                }
            }
            return result;
        }) && result3;
    }
    if (schema56.patternProperties !== undefined) {
        result3 = context.withSchemaPath("patternProperties", ()=>{
            let result = true;
            for (const [key, subSchema] of Object.entries(schema56.patternProperties)){
                if (schema56.compiledPatterns === undefined) {
                    schema56.compiledPatterns = {};
                }
                if (schema56.compiledPatterns[key] === undefined) {
                    schema56.compiledPatterns[key] = new RegExp(key);
                }
                const regexp4 = schema56.compiledPatterns[key];
                for (const [objectKey, _val] of Object.entries(objResult)){
                    if (objectKey.match(regexp4)) {
                        inspectedProps.add(objectKey);
                        context.pushInstance(objectKey);
                        result = context.withSchemaPath(key, ()=>validateGeneric(locate(objectKey), subSchema, context)
                        ) && result;
                        context.popInstance();
                    }
                }
            }
            return result;
        }) && result3;
    }
    if (schema56.additionalProperties !== undefined) {
        result3 = context.withSchemaPath("additionalProperties", ()=>{
            return Object.keys(objResult).filter((objectKey)=>!inspectedProps.has(objectKey)
            ).every((objectKey)=>validateGeneric(locate(objectKey), schema56.additionalProperties, context)
            );
        }) && result3;
    }
    if (schema56.propertyNames !== undefined) {
        result3 = context.withSchemaPath("propertyNames", ()=>{
            return Array.from(ownProperties).every((key)=>validateGeneric(locate(key, "key"), schema56.propertyNames, context)
            );
        }) && result3;
    }
    if (schema56.required !== undefined) {
        result3 = context.withSchemaPath("required", ()=>{
            let result = true;
            for (const reqKey of schema56.required){
                if (!ownProperties.has(reqKey)) {
                    context.error(value, schema56, `object is missing required property ${reqKey}`);
                    result = false;
                }
            }
            return result;
        }) && result3;
    }
    return result3;
}
function validate(value, schema57, source, pruneErrors = true) {
    const context = new ValidationContext();
    return context.validate(schema57, source, value, pruneErrors);
}
class YAMLSchema {
    schema;
    errorHandlers;
    constructor(schema58){
        this.errorHandlers = [];
        this.schema = schema58;
    }
    addHandler(handler) {
        this.errorHandlers.push(handler);
    }
    transformErrors(annotation, errors2) {
        return errors2.map((error25)=>{
            for (const handler of this.errorHandlers){
                const localError = handler(error25, annotation, this.schema);
                if (localError === null) {
                    return null;
                }
                error25 = localError;
            }
            return error25;
        }).filter((error26)=>error26 !== null
        );
    }
    async validateParse(src10, annotation, pruneErrors = true) {
        const validationErrors = validate(annotation, this.schema, src10, pruneErrors);
        if (validationErrors.length) {
            const localizedErrors = this.transformErrors(annotation, validationErrors);
            return {
                result: annotation.result,
                errors: localizedErrors
            };
        } else {
            return {
                result: annotation.result,
                errors: []
            };
        }
    }
    reportErrorsInSource(result, _src, message, error27, log) {
        if (result.errors.length) {
            if (message.length) {
                error27(message);
            }
            for (const err of result.errors){
                log(err.niceError);
            }
        }
        return result;
    }
    async validateParseWithErrors(src11, annotation, message, error28, log) {
        const result = await this.validateParse(src11, annotation);
        this.reportErrorsInSource(result, src11, message, error28, log);
        return result;
    }
}
const yamlValidators = {};
function getSchemaName(schema59) {
    if (schema59 === true || schema59 === false) {
        throw new Error("Expected schema to be named");
    }
    let schemaName = schema59["$id"];
    if (schemaName !== undefined) {
        return schemaName;
    }
    if (schemaType(schema59) === "ref") {
        schemaName = schema59["$ref"];
    }
    if (schemaName !== undefined) {
        return schemaName;
    }
    throw new Error("Expected schema to be named");
}
function getValidator(schema60) {
    const schemaName = getSchemaName(schema60);
    if (yamlValidators[schemaName]) {
        return yamlValidators[schemaName];
    }
    const validator = new YAMLSchema(schema60);
    yamlValidators[schemaName] = validator;
    setDefaultErrorHandlers(validator);
    return validator;
}
async function withValidator(schema61, fun) {
    let result;
    let error29;
    try {
        const validator = getValidator(schema61);
        result = await fun(validator);
    } catch (e) {
        error29 = e;
    }
    if (error29 !== undefined) {
        throw error29;
    }
    return result;
}
function addValidatorErrorHandler(schema62, handler) {
    return withValidator(schema62, async (validator)=>{
        validator.addHandler(handler);
    });
}
function memoize(f, keyMemoizer) {
    const memo1 = {};
    const inner = (...args)=>{
        const key = keyMemoizer(...args);
        const v = memo1[key];
        if (v !== undefined) {
            return v;
        }
        memo1[key] = f(...args);
        return memo1[key];
    };
    return inner;
}
const regExpEscapeChars1 = [
    "!",
    "$",
    "(",
    ")",
    "*",
    "+",
    ".",
    "=",
    "?",
    "[",
    "\\",
    "^",
    "{",
    "|", 
];
const rangeEscapeChars1 = [
    "-",
    "\\",
    "]"
];
function globToRegExp1(glob, { extended =true , globstar: globstarOption = true , caseInsensitive =false  } = {}) {
    if (glob == "") {
        return /(?!)/;
    }
    const sep11 = "/+";
    const sepMaybe = "/*";
    const seps = [
        "/"
    ];
    const globstar = "(?:[^/]*(?:/|$)+)*";
    const wildcard = "[^/]*";
    const escapePrefix = "\\";
    let newLength = glob.length;
    for(; newLength > 1 && seps.includes(glob[newLength - 1]); newLength--);
    glob = glob.slice(0, newLength);
    let regExpString = "";
    for(let j = 0; j < glob.length;){
        let segment = "";
        const groupStack = [];
        let inRange = false;
        let inEscape = false;
        let endsWithSep = false;
        let i48 = j;
        for(; i48 < glob.length && !seps.includes(glob[i48]); i48++){
            if (inEscape) {
                inEscape = false;
                const escapeChars = inRange ? rangeEscapeChars1 : regExpEscapeChars1;
                segment += escapeChars.includes(glob[i48]) ? `\\${glob[i48]}` : glob[i48];
                continue;
            }
            if (glob[i48] == escapePrefix) {
                inEscape = true;
                continue;
            }
            if (glob[i48] == "[") {
                if (!inRange) {
                    inRange = true;
                    segment += "[";
                    if (glob[i48 + 1] == "!") {
                        i48++;
                        segment += "^";
                    } else if (glob[i48 + 1] == "^") {
                        i48++;
                        segment += "\\^";
                    }
                    continue;
                } else if (glob[i48 + 1] == ":") {
                    let k = i48 + 1;
                    let value = "";
                    while(glob[k + 1] != null && glob[k + 1] != ":"){
                        value += glob[k + 1];
                        k++;
                    }
                    if (glob[k + 1] == ":" && glob[k + 2] == "]") {
                        i48 = k + 2;
                        if (value == "alnum") segment += "\\dA-Za-z";
                        else if (value == "alpha") segment += "A-Za-z";
                        else if (value == "ascii") segment += "\x00-\x7F";
                        else if (value == "blank") segment += "\t ";
                        else if (value == "cntrl") segment += "\x00-\x1F\x7F";
                        else if (value == "digit") segment += "\\d";
                        else if (value == "graph") segment += "\x21-\x7E";
                        else if (value == "lower") segment += "a-z";
                        else if (value == "print") segment += "\x20-\x7E";
                        else if (value == "punct") {
                            segment += "!\"#$%&'()*+,\\-./:;<=>?@[\\\\\\]^_‘{|}~";
                        } else if (value == "space") segment += "\\s\v";
                        else if (value == "upper") segment += "A-Z";
                        else if (value == "word") segment += "\\w";
                        else if (value == "xdigit") segment += "\\dA-Fa-f";
                        continue;
                    }
                }
            }
            if (glob[i48] == "]" && inRange) {
                inRange = false;
                segment += "]";
                continue;
            }
            if (inRange) {
                if (glob[i48] == "\\") {
                    segment += `\\\\`;
                } else {
                    segment += glob[i48];
                }
                continue;
            }
            if (glob[i48] == ")" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += ")";
                const type34 = groupStack.pop();
                if (type34 == "!") {
                    segment += wildcard;
                } else if (type34 != "@") {
                    segment += type34;
                }
                continue;
            }
            if (glob[i48] == "|" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i48] == "+" && extended && glob[i48 + 1] == "(") {
                i48++;
                groupStack.push("+");
                segment += "(?:";
                continue;
            }
            if (glob[i48] == "@" && extended && glob[i48 + 1] == "(") {
                i48++;
                groupStack.push("@");
                segment += "(?:";
                continue;
            }
            if (glob[i48] == "?") {
                if (extended && glob[i48 + 1] == "(") {
                    i48++;
                    groupStack.push("?");
                    segment += "(?:";
                } else {
                    segment += ".";
                }
                continue;
            }
            if (glob[i48] == "!" && extended && glob[i48 + 1] == "(") {
                i48++;
                groupStack.push("!");
                segment += "(?!";
                continue;
            }
            if (glob[i48] == "{") {
                groupStack.push("BRACE");
                segment += "(?:";
                continue;
            }
            if (glob[i48] == "}" && groupStack[groupStack.length - 1] == "BRACE") {
                groupStack.pop();
                segment += ")";
                continue;
            }
            if (glob[i48] == "," && groupStack[groupStack.length - 1] == "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i48] == "*") {
                if (extended && glob[i48 + 1] == "(") {
                    i48++;
                    groupStack.push("*");
                    segment += "(?:";
                } else {
                    const prevChar = glob[i48 - 1];
                    let numStars = 1;
                    while(glob[i48 + 1] == "*"){
                        i48++;
                        numStars++;
                    }
                    const nextChar = glob[i48 + 1];
                    if (globstarOption && numStars == 2 && [
                        ...seps,
                        undefined
                    ].includes(prevChar) && [
                        ...seps,
                        undefined
                    ].includes(nextChar)) {
                        segment += globstar;
                        endsWithSep = true;
                    } else {
                        segment += wildcard;
                    }
                }
                continue;
            }
            segment += regExpEscapeChars1.includes(glob[i48]) ? `\\${glob[i48]}` : glob[i48];
        }
        if (groupStack.length > 0 || inRange || inEscape) {
            segment = "";
            for (const c of glob.slice(j, i48)){
                segment += regExpEscapeChars1.includes(c) ? `\\${c}` : c;
                endsWithSep = false;
            }
        }
        regExpString += segment;
        if (!endsWithSep) {
            regExpString += i48 < glob.length ? sep11 : sepMaybe;
            endsWithSep = true;
        }
        while(seps.includes(glob[i48]))i48++;
        if (!(i48 > j)) {
            throw new Error("Assertion failure: i > j (potential infinite loop)");
        }
        j = i48;
    }
    regExpString = `^${regExpString}$`;
    return new RegExp(regExpString, caseInsensitive ? "i" : "");
}
const _resources = {};
function setYamlIntelligenceResources(resources) {
    for (const [key, value] of Object.entries(resources)){
        _resources[key] = value;
    }
}
function exportYamlIntelligenceResources(pretty = false) {
    if (pretty) {
        return JSON.stringify(_resources, null, 2);
    } else {
        return JSON.stringify(_resources);
    }
}
function getYamlIntelligenceResource(filename) {
    if (_resources[filename] === undefined) {
        throw new Error(`Internal Error: getYamlIntelligenceResource called with missing resource ${filename}`);
    }
    return _resources[filename];
}
function expandResourceGlob(glob) {
    return Object.keys(_resources).filter((key)=>key.match(globToRegExp1(glob))
    ).map((key)=>[
            key,
            getYamlIntelligenceResource(key)
        ]
    );
}
function fromEntries(iterable) {
    return [
        ...iterable
    ].reduce((obj, [key, val])=>{
        obj[key] = val;
        return obj;
    }, {});
}
let _parser;
function setTreeSitter(parser) {
    _parser = parser;
}
function getTreeSitterSync() {
    if (_parser === undefined) {
        throw new Error("tree-sitter uninitialized");
    }
    return _parser;
}
function isNothing(subject) {
    return typeof subject === "undefined" || subject === null;
}
function isObject1(subject) {
    return typeof subject === "object" && subject !== null;
}
function toArray(sequence) {
    if (Array.isArray(sequence)) return sequence;
    else if (isNothing(sequence)) return [];
    return [
        sequence
    ];
}
function extend(target, source) {
    var index, length, key, sourceKeys;
    if (source) {
        sourceKeys = Object.keys(source);
        for(index = 0, length = sourceKeys.length; index < length; index += 1){
            key = sourceKeys[index];
            target[key] = source[key];
        }
    }
    return target;
}
function repeat1(string14, count) {
    var result = "", cycle;
    for(cycle = 0; cycle < count; cycle += 1){
        result += string14;
    }
    return result;
}
function isNegativeZero1(number1) {
    return number1 === 0 && Number.NEGATIVE_INFINITY === 1 / number1;
}
var isNothing_1 = isNothing;
var isObject_1 = isObject1;
var toArray_1 = toArray;
var repeat_1 = repeat1;
var isNegativeZero_1 = isNegativeZero1;
var extend_1 = extend;
var common = {
    isNothing: isNothing_1,
    isObject: isObject_1,
    toArray: toArray_1,
    repeat: repeat_1,
    isNegativeZero: isNegativeZero_1,
    extend: extend_1
};
function formatError(exception2, compact) {
    var where = "", message = exception2.reason || "(unknown reason)";
    if (!exception2.mark) return message;
    if (exception2.mark.name) {
        where += 'in "' + exception2.mark.name + '" ';
    }
    where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
    if (!compact && exception2.mark.snippet) {
        where += "\n\n" + exception2.mark.snippet;
    }
    return message + " " + where;
}
function YAMLException$1(reason, mark) {
    Error.call(this);
    this.name = "YAMLException";
    this.reason = reason;
    this.mark = mark;
    this.message = formatError(this, false);
    if (Error.captureStackTrace) {
        Error.captureStackTrace(this, this.constructor);
    } else {
        this.stack = new Error().stack || "";
    }
}
YAMLException$1.prototype = Object.create(Error.prototype);
YAMLException$1.prototype.constructor = YAMLException$1;
YAMLException$1.prototype.toString = function toString(compact) {
    return this.name + ": " + formatError(this, compact);
};
var exception = YAMLException$1;
function getLine(buffer, lineStart, lineEnd, position, maxLineLength) {
    var head = "";
    var tail = "";
    var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
    if (position - lineStart > maxHalfLength) {
        head = " ... ";
        lineStart = position - maxHalfLength + head.length;
    }
    if (lineEnd - position > maxHalfLength) {
        tail = " ...";
        lineEnd = position + maxHalfLength - tail.length;
    }
    return {
        str: head + buffer.slice(lineStart, lineEnd).replace(/\t/g, "\u2192") + tail,
        pos: position - lineStart + head.length
    };
}
function padStart(string15, max) {
    return common.repeat(" ", max - string15.length) + string15;
}
function makeSnippet(mark, options) {
    options = Object.create(options || null);
    if (!mark.buffer) return null;
    if (!options.maxLength) options.maxLength = 79;
    if (typeof options.indent !== "number") options.indent = 1;
    if (typeof options.linesBefore !== "number") options.linesBefore = 3;
    if (typeof options.linesAfter !== "number") options.linesAfter = 2;
    var re1 = /\r?\n|\r|\0/g;
    var lineStarts = [
        0
    ];
    var lineEnds = [];
    var match;
    var foundLineNo = -1;
    while(match = re1.exec(mark.buffer)){
        lineEnds.push(match.index);
        lineStarts.push(match.index + match[0].length);
        if (mark.position <= match.index && foundLineNo < 0) {
            foundLineNo = lineStarts.length - 2;
        }
    }
    if (foundLineNo < 0) foundLineNo = lineStarts.length - 1;
    var result = "", i1, line;
    var lineNoLength = Math.min(mark.line + options.linesAfter, lineEnds.length).toString().length;
    var maxLineLength = options.maxLength - (options.indent + lineNoLength + 3);
    for(i1 = 1; i1 <= options.linesBefore; i1++){
        if (foundLineNo - i1 < 0) break;
        line = getLine(mark.buffer, lineStarts[foundLineNo - i1], lineEnds[foundLineNo - i1], mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i1]), maxLineLength);
        result = common.repeat(" ", options.indent) + padStart((mark.line - i1 + 1).toString(), lineNoLength) + " | " + line.str + "\n" + result;
    }
    line = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
    result += common.repeat(" ", options.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line.str + "\n";
    result += common.repeat("-", options.indent + lineNoLength + 3 + line.pos) + "^\n";
    for(i1 = 1; i1 <= options.linesAfter; i1++){
        if (foundLineNo + i1 >= lineEnds.length) break;
        line = getLine(mark.buffer, lineStarts[foundLineNo + i1], lineEnds[foundLineNo + i1], mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i1]), maxLineLength);
        result += common.repeat(" ", options.indent) + padStart((mark.line + i1 + 1).toString(), lineNoLength) + " | " + line.str + "\n";
    }
    return result.replace(/\n$/, "");
}
var snippet = makeSnippet;
var TYPE_CONSTRUCTOR_OPTIONS = [
    "kind",
    "multi",
    "resolve",
    "construct",
    "instanceOf",
    "predicate",
    "represent",
    "representName",
    "defaultStyle",
    "styleAliases", 
];
var YAML_NODE_KINDS = [
    "scalar",
    "sequence",
    "mapping"
];
function compileStyleAliases(map2) {
    var result = {};
    if (map2 !== null) {
        Object.keys(map2).forEach(function(style) {
            map2[style].forEach(function(alias) {
                result[String(alias)] = style;
            });
        });
    }
    return result;
}
function Type$1(tag, options) {
    options = options || {};
    Object.keys(options).forEach(function(name84) {
        if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name84) === -1) {
            throw new exception('Unknown option "' + name84 + '" is met in definition of "' + tag + '" YAML type.');
        }
    });
    this.options = options;
    this.tag = tag;
    this.kind = options["kind"] || null;
    this.resolve = options["resolve"] || function() {
        return true;
    };
    this.construct = options["construct"] || function(data32) {
        return data32;
    };
    this.instanceOf = options["instanceOf"] || null;
    this.predicate = options["predicate"] || null;
    this.represent = options["represent"] || null;
    this.representName = options["representName"] || null;
    this.defaultStyle = options["defaultStyle"] || null;
    this.multi = options["multi"] || false;
    this.styleAliases = compileStyleAliases(options["styleAliases"] || null);
    if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
        throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
    }
}
var type = Type$1;
function compileList1(schema2, name85) {
    var result = [];
    schema2[name85].forEach(function(currentType) {
        var newIndex = result.length;
        result.forEach(function(previousType, previousIndex) {
            if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
                newIndex = previousIndex;
            }
        });
        result[newIndex] = currentType;
    });
    return result;
}
function compileMap1() {
    var result = {
        scalar: {},
        sequence: {},
        mapping: {},
        fallback: {},
        multi: {
            scalar: [],
            sequence: [],
            mapping: [],
            fallback: []
        }
    }, index, length;
    function collectType(type2) {
        if (type2.multi) {
            result.multi[type2.kind].push(type2);
            result.multi["fallback"].push(type2);
        } else {
            result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
        }
    }
    for(index = 0, length = arguments.length; index < length; index += 1){
        arguments[index].forEach(collectType);
    }
    return result;
}
function Schema$1(definition) {
    return this.extend(definition);
}
Schema$1.prototype.extend = function extend2(definition) {
    var implicit = [];
    var explicit = [];
    if (definition instanceof type) {
        explicit.push(definition);
    } else if (Array.isArray(definition)) {
        explicit = explicit.concat(definition);
    } else if (definition && (Array.isArray(definition.implicit) || Array.isArray(definition.explicit))) {
        if (definition.implicit) implicit = implicit.concat(definition.implicit);
        if (definition.explicit) explicit = explicit.concat(definition.explicit);
    } else {
        throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
    }
    implicit.forEach(function(type$1) {
        if (!(type$1 instanceof type)) {
            throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
        }
        if (type$1.loadKind && type$1.loadKind !== "scalar") {
            throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
        }
        if (type$1.multi) {
            throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
        }
    });
    explicit.forEach(function(type$1) {
        if (!(type$1 instanceof type)) {
            throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
        }
    });
    var result = Object.create(Schema$1.prototype);
    result.implicit = (this.implicit || []).concat(implicit);
    result.explicit = (this.explicit || []).concat(explicit);
    result.compiledImplicit = compileList1(result, "implicit");
    result.compiledExplicit = compileList1(result, "explicit");
    result.compiledTypeMap = compileMap1(result.compiledImplicit, result.compiledExplicit);
    return result;
};
var schema = Schema$1;
var str1 = new type("tag:yaml.org,2002:str", {
    kind: "scalar",
    construct: function(data33) {
        return data33 !== null ? data33 : "";
    }
});
var seq1 = new type("tag:yaml.org,2002:seq", {
    kind: "sequence",
    construct: function(data34) {
        return data34 !== null ? data34 : [];
    }
});
var map1 = new type("tag:yaml.org,2002:map", {
    kind: "mapping",
    construct: function(data35) {
        return data35 !== null ? data35 : {};
    }
});
var failsafe1 = new schema({
    explicit: [
        str1,
        seq1,
        map1
    ]
});
function resolveYamlNull1(data36) {
    if (data36 === null) return true;
    var max = data36.length;
    return max === 1 && data36 === "~" || max === 4 && (data36 === "null" || data36 === "Null" || data36 === "NULL");
}
function constructYamlNull1() {
    return null;
}
function isNull1(object) {
    return object === null;
}
var _null = new type("tag:yaml.org,2002:null", {
    kind: "scalar",
    resolve: resolveYamlNull1,
    construct: constructYamlNull1,
    predicate: isNull1,
    represent: {
        canonical: function() {
            return "~";
        },
        lowercase: function() {
            return "null";
        },
        uppercase: function() {
            return "NULL";
        },
        camelcase: function() {
            return "Null";
        },
        empty: function() {
            return "";
        }
    },
    defaultStyle: "lowercase"
});
function resolveYamlBoolean1(data37) {
    if (data37 === null) return false;
    var max = data37.length;
    return max === 4 && (data37 === "true" || data37 === "True" || data37 === "TRUE") || max === 5 && (data37 === "false" || data37 === "False" || data37 === "FALSE");
}
function constructYamlBoolean1(data38) {
    return data38 === "true" || data38 === "True" || data38 === "TRUE";
}
function isBoolean1(object) {
    return Object.prototype.toString.call(object) === "[object Boolean]";
}
var bool1 = new type("tag:yaml.org,2002:bool", {
    kind: "scalar",
    resolve: resolveYamlBoolean1,
    construct: constructYamlBoolean1,
    predicate: isBoolean1,
    represent: {
        lowercase: function(object) {
            return object ? "true" : "false";
        },
        uppercase: function(object) {
            return object ? "TRUE" : "FALSE";
        },
        camelcase: function(object) {
            return object ? "True" : "False";
        }
    },
    defaultStyle: "lowercase"
});
function isHexCode1(c) {
    return 48 <= c && c <= 57 || 65 <= c && c <= 70 || 97 <= c && c <= 102;
}
function isOctCode1(c) {
    return 48 <= c && c <= 55;
}
function isDecCode1(c) {
    return 48 <= c && c <= 57;
}
function resolveYamlInteger1(data39) {
    if (data39 === null) return false;
    var max = data39.length, index = 0, hasDigits = false, ch;
    if (!max) return false;
    ch = data39[index];
    if (ch === "-" || ch === "+") {
        ch = data39[++index];
    }
    if (ch === "0") {
        if (index + 1 === max) return true;
        ch = data39[++index];
        if (ch === "b") {
            index++;
            for(; index < max; index++){
                ch = data39[index];
                if (ch === "_") continue;
                if (ch !== "0" && ch !== "1") return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        if (ch === "x") {
            index++;
            for(; index < max; index++){
                ch = data39[index];
                if (ch === "_") continue;
                if (!isHexCode1(data39.charCodeAt(index))) return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        if (ch === "o") {
            index++;
            for(; index < max; index++){
                ch = data39[index];
                if (ch === "_") continue;
                if (!isOctCode1(data39.charCodeAt(index))) return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
    }
    if (ch === "_") return false;
    for(; index < max; index++){
        ch = data39[index];
        if (ch === "_") continue;
        if (!isDecCode1(data39.charCodeAt(index))) {
            return false;
        }
        hasDigits = true;
    }
    if (!hasDigits || ch === "_") return false;
    return true;
}
function constructYamlInteger1(data40) {
    var value = data40, sign = 1, ch;
    if (value.indexOf("_") !== -1) {
        value = value.replace(/_/g, "");
    }
    ch = value[0];
    if (ch === "-" || ch === "+") {
        if (ch === "-") sign = -1;
        value = value.slice(1);
        ch = value[0];
    }
    if (value === "0") return 0;
    if (ch === "0") {
        if (value[1] === "b") return sign * parseInt(value.slice(2), 2);
        if (value[1] === "x") return sign * parseInt(value.slice(2), 16);
        if (value[1] === "o") return sign * parseInt(value.slice(2), 8);
    }
    return sign * parseInt(value, 10);
}
function isInteger1(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && object % 1 === 0 && !common.isNegativeZero(object);
}
var __int1 = new type("tag:yaml.org,2002:int", {
    kind: "scalar",
    resolve: resolveYamlInteger1,
    construct: constructYamlInteger1,
    predicate: isInteger1,
    represent: {
        binary: function(obj) {
            return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
        },
        octal: function(obj) {
            return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
        },
        decimal: function(obj) {
            return obj.toString(10);
        },
        hexadecimal: function(obj) {
            return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
        }
    },
    defaultStyle: "decimal",
    styleAliases: {
        binary: [
            2,
            "bin"
        ],
        octal: [
            8,
            "oct"
        ],
        decimal: [
            10,
            "dec"
        ],
        hexadecimal: [
            16,
            "hex"
        ]
    }
});
var YAML_FLOAT_PATTERN1 = new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
function resolveYamlFloat1(data41) {
    if (data41 === null) return false;
    if (!YAML_FLOAT_PATTERN1.test(data41) || data41[data41.length - 1] === "_") {
        return false;
    }
    return true;
}
function constructYamlFloat1(data42) {
    var value, sign;
    value = data42.replace(/_/g, "").toLowerCase();
    sign = value[0] === "-" ? -1 : 1;
    if ("+-".indexOf(value[0]) >= 0) {
        value = value.slice(1);
    }
    if (value === ".inf") {
        return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    } else if (value === ".nan") {
        return NaN;
    }
    return sign * parseFloat(value, 10);
}
var SCIENTIFIC_WITHOUT_DOT1 = /^[-+]?[0-9]+e/;
function representYamlFloat1(object, style) {
    var res;
    if (isNaN(object)) {
        switch(style){
            case "lowercase":
                return ".nan";
            case "uppercase":
                return ".NAN";
            case "camelcase":
                return ".NaN";
        }
    } else if (Number.POSITIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return ".inf";
            case "uppercase":
                return ".INF";
            case "camelcase":
                return ".Inf";
        }
    } else if (Number.NEGATIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return "-.inf";
            case "uppercase":
                return "-.INF";
            case "camelcase":
                return "-.Inf";
        }
    } else if (common.isNegativeZero(object)) {
        return "-0.0";
    }
    res = object.toString(10);
    return SCIENTIFIC_WITHOUT_DOT1.test(res) ? res.replace("e", ".e") : res;
}
function isFloat1(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 !== 0 || common.isNegativeZero(object));
}
var __float1 = new type("tag:yaml.org,2002:float", {
    kind: "scalar",
    resolve: resolveYamlFloat1,
    construct: constructYamlFloat1,
    predicate: isFloat1,
    represent: representYamlFloat1,
    defaultStyle: "lowercase"
});
var json1 = failsafe1.extend({
    implicit: [
        _null,
        bool1,
        __int1,
        __float1
    ]
});
var core1 = json1;
var YAML_DATE_REGEXP1 = new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$");
var YAML_TIMESTAMP_REGEXP1 = new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$");
function resolveYamlTimestamp1(data43) {
    if (data43 === null) return false;
    if (YAML_DATE_REGEXP1.exec(data43) !== null) return true;
    if (YAML_TIMESTAMP_REGEXP1.exec(data43) !== null) return true;
    return false;
}
function constructYamlTimestamp1(data44) {
    var match, year, month, day, hour, minute, second, fraction = 0, delta = null, tz_hour, tz_minute, date;
    match = YAML_DATE_REGEXP1.exec(data44);
    if (match === null) match = YAML_TIMESTAMP_REGEXP1.exec(data44);
    if (match === null) throw new Error("Date resolve error");
    year = +match[1];
    month = +match[2] - 1;
    day = +match[3];
    if (!match[4]) {
        return new Date(Date.UTC(year, month, day));
    }
    hour = +match[4];
    minute = +match[5];
    second = +match[6];
    if (match[7]) {
        fraction = match[7].slice(0, 3);
        while(fraction.length < 3){
            fraction += "0";
        }
        fraction = +fraction;
    }
    if (match[9]) {
        tz_hour = +match[10];
        tz_minute = +(match[11] || 0);
        delta = (tz_hour * 60 + tz_minute) * 6e4;
        if (match[9] === "-") delta = -delta;
    }
    date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
    if (delta) date.setTime(date.getTime() - delta);
    return date;
}
function representYamlTimestamp1(object) {
    return object.toISOString();
}
var timestamp1 = new type("tag:yaml.org,2002:timestamp", {
    kind: "scalar",
    resolve: resolveYamlTimestamp1,
    construct: constructYamlTimestamp1,
    instanceOf: Date,
    represent: representYamlTimestamp1
});
function resolveYamlMerge1(data45) {
    return data45 === "<<" || data45 === null;
}
var merge1 = new type("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge1
});
var BASE64_MAP1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary1(data46) {
    if (data46 === null) return false;
    var code20, idx, bitlen = 0, max = data46.length, map2 = BASE64_MAP1;
    for(idx = 0; idx < max; idx++){
        code20 = map2.indexOf(data46.charAt(idx));
        if (code20 > 64) continue;
        if (code20 < 0) return false;
        bitlen += 6;
    }
    return bitlen % 8 === 0;
}
function constructYamlBinary1(data47) {
    var idx, tailbits, input = data47.replace(/[\r\n=]/g, ""), max = input.length, map2 = BASE64_MAP1, bits = 0, result = [];
    for(idx = 0; idx < max; idx++){
        if (idx % 4 === 0 && idx) {
            result.push(bits >> 16 & 255);
            result.push(bits >> 8 & 255);
            result.push(bits & 255);
        }
        bits = bits << 6 | map2.indexOf(input.charAt(idx));
    }
    tailbits = max % 4 * 6;
    if (tailbits === 0) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
    } else if (tailbits === 18) {
        result.push(bits >> 10 & 255);
        result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
        result.push(bits >> 4 & 255);
    }
    return new Uint8Array(result);
}
function representYamlBinary1(object) {
    var result = "", bits = 0, idx, tail, max = object.length, map2 = BASE64_MAP1;
    for(idx = 0; idx < max; idx++){
        if (idx % 3 === 0 && idx) {
            result += map2[bits >> 18 & 63];
            result += map2[bits >> 12 & 63];
            result += map2[bits >> 6 & 63];
            result += map2[bits & 63];
        }
        bits = (bits << 8) + object[idx];
    }
    tail = max % 3;
    if (tail === 0) {
        result += map2[bits >> 18 & 63];
        result += map2[bits >> 12 & 63];
        result += map2[bits >> 6 & 63];
        result += map2[bits & 63];
    } else if (tail === 2) {
        result += map2[bits >> 10 & 63];
        result += map2[bits >> 4 & 63];
        result += map2[bits << 2 & 63];
        result += map2[64];
    } else if (tail === 1) {
        result += map2[bits >> 2 & 63];
        result += map2[bits << 4 & 63];
        result += map2[64];
        result += map2[64];
    }
    return result;
}
function isBinary1(obj) {
    return Object.prototype.toString.call(obj) === "[object Uint8Array]";
}
var binary1 = new type("tag:yaml.org,2002:binary", {
    kind: "scalar",
    resolve: resolveYamlBinary1,
    construct: constructYamlBinary1,
    predicate: isBinary1,
    represent: representYamlBinary1
});
var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
var _toString$2 = Object.prototype.toString;
function resolveYamlOmap1(data48) {
    if (data48 === null) return true;
    var objectKeys = [], index, length, pair, pairKey, pairHasKey, object = data48;
    for(index = 0, length = object.length; index < length; index += 1){
        pair = object[index];
        pairHasKey = false;
        if (_toString$2.call(pair) !== "[object Object]") return false;
        for(pairKey in pair){
            if (_hasOwnProperty$3.call(pair, pairKey)) {
                if (!pairHasKey) pairHasKey = true;
                else return false;
            }
        }
        if (!pairHasKey) return false;
        if (objectKeys.indexOf(pairKey) === -1) objectKeys.push(pairKey);
        else return false;
    }
    return true;
}
function constructYamlOmap1(data49) {
    return data49 !== null ? data49 : [];
}
var omap1 = new type("tag:yaml.org,2002:omap", {
    kind: "sequence",
    resolve: resolveYamlOmap1,
    construct: constructYamlOmap1
});
var _toString$1 = Object.prototype.toString;
function resolveYamlPairs1(data50) {
    if (data50 === null) return true;
    var index, length, pair, keys7, result, object = data50;
    result = new Array(object.length);
    for(index = 0, length = object.length; index < length; index += 1){
        pair = object[index];
        if (_toString$1.call(pair) !== "[object Object]") return false;
        keys7 = Object.keys(pair);
        if (keys7.length !== 1) return false;
        result[index] = [
            keys7[0],
            pair[keys7[0]]
        ];
    }
    return true;
}
function constructYamlPairs1(data51) {
    if (data51 === null) return [];
    var index, length, pair, keys8, result, object = data51;
    result = new Array(object.length);
    for(index = 0, length = object.length; index < length; index += 1){
        pair = object[index];
        keys8 = Object.keys(pair);
        result[index] = [
            keys8[0],
            pair[keys8[0]]
        ];
    }
    return result;
}
var pairs1 = new type("tag:yaml.org,2002:pairs", {
    kind: "sequence",
    resolve: resolveYamlPairs1,
    construct: constructYamlPairs1
});
var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
function resolveYamlSet1(data52) {
    if (data52 === null) return true;
    var key, object = data52;
    for(key in object){
        if (_hasOwnProperty$2.call(object, key)) {
            if (object[key] !== null) return false;
        }
    }
    return true;
}
function constructYamlSet1(data53) {
    return data53 !== null ? data53 : {};
}
var set1 = new type("tag:yaml.org,2002:set", {
    kind: "mapping",
    resolve: resolveYamlSet1,
    construct: constructYamlSet1
});
var _default = core1.extend({
    implicit: [
        timestamp1,
        merge1
    ],
    explicit: [
        binary1,
        omap1,
        pairs1,
        set1
    ]
});
var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
var CONTEXT_FLOW_IN = 1;
var CONTEXT_FLOW_OUT = 2;
var CONTEXT_BLOCK_IN1 = 3;
var CONTEXT_BLOCK_OUT1 = 4;
var CHOMPING_CLIP = 1;
var CHOMPING_STRIP1 = 2;
var CHOMPING_KEEP1 = 3;
var PATTERN_NON_PRINTABLE1 = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
var PATTERN_NON_ASCII_LINE_BREAKS1 = /[\x85\u2028\u2029]/;
var PATTERN_FLOW_INDICATORS1 = /[,\[\]\{\}]/;
var PATTERN_TAG_HANDLE1 = /^(?:!|!!|![a-z\-]+!)$/i;
var PATTERN_TAG_URI1 = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
function _class1(obj) {
    return Object.prototype.toString.call(obj);
}
function is_EOL(c) {
    return c === 10 || c === 13;
}
function is_WHITE_SPACE(c) {
    return c === 9 || c === 32;
}
function is_WS_OR_EOL(c) {
    return c === 9 || c === 32 || c === 10 || c === 13;
}
function is_FLOW_INDICATOR(c) {
    return c === 44 || c === 91 || c === 93 || c === 123 || c === 125;
}
function fromHexCode1(c) {
    var lc;
    if (48 <= c && c <= 57) {
        return c - 48;
    }
    lc = c | 32;
    if (97 <= lc && lc <= 102) {
        return lc - 97 + 10;
    }
    return -1;
}
function escapedHexLen1(c) {
    if (c === 120) {
        return 2;
    }
    if (c === 117) {
        return 4;
    }
    if (c === 85) {
        return 8;
    }
    return 0;
}
function fromDecimalCode1(c) {
    if (48 <= c && c <= 57) {
        return c - 48;
    }
    return -1;
}
function simpleEscapeSequence1(c) {
    return c === 48 ? "\0" : c === 97 ? "\x07" : c === 98 ? "\b" : c === 116 ? "	" : c === 9 ? "	" : c === 110 ? "\n" : c === 118 ? "\v" : c === 102 ? "\f" : c === 114 ? "\r" : c === 101 ? "" : c === 32 ? " " : c === 34 ? '"' : c === 47 ? "/" : c === 92 ? "\\" : c === 78 ? "\x85" : c === 95 ? "\xA0" : c === 76 ? "\u2028" : c === 80 ? "\u2029" : "";
}
function charFromCodepoint1(c) {
    if (c <= 65535) {
        return String.fromCharCode(c);
    }
    return String.fromCharCode((c - 65536 >> 10) + 55296, (c - 65536 & 1023) + 56320);
}
var simpleEscapeCheck1 = new Array(256);
var simpleEscapeMap1 = new Array(256);
for(var i1 = 0; i1 < 256; i1++){
    simpleEscapeCheck1[i1] = simpleEscapeSequence1(i1) ? 1 : 0;
    simpleEscapeMap1[i1] = simpleEscapeSequence1(i1);
}
function State$1(input, options) {
    this.input = input;
    this.filename = options["filename"] || null;
    this.schema = options["schema"] || _default;
    this.onWarning = options["onWarning"] || null;
    this.legacy = options["legacy"] || false;
    this.json = options["json"] || false;
    this.listener = options["listener"] || null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.typeMap = this.schema.compiledTypeMap;
    this.length = input.length;
    this.position = 0;
    this.line = 0;
    this.lineStart = 0;
    this.lineIndent = 0;
    this.firstTabInLine = -1;
    this.documents = [];
}
function generateError1(state37, message) {
    var mark = {
        name: state37.filename,
        buffer: state37.input.slice(0, -1),
        position: state37.position,
        line: state37.line,
        column: state37.position - state37.lineStart
    };
    mark.snippet = snippet(mark);
    return new exception(message, mark);
}
function throwError1(state38, message) {
    throw generateError1(state38, message);
}
function throwWarning1(state39, message) {
    if (state39.onWarning) {
        state39.onWarning.call(null, generateError1(state39, message));
    }
}
var directiveHandlers1 = {
    YAML: function handleYamlDirective(state40, name, args) {
        var match, major, minor;
        if (state40.version !== null) {
            throwError1(state40, "duplication of %YAML directive");
        }
        if (args.length !== 1) {
            throwError1(state40, "YAML directive accepts exactly one argument");
        }
        match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
        if (match === null) {
            throwError1(state40, "ill-formed argument of the YAML directive");
        }
        major = parseInt(match[1], 10);
        minor = parseInt(match[2], 10);
        if (major !== 1) {
            throwError1(state40, "unacceptable YAML version of the document");
        }
        state40.version = args[0];
        state40.checkLineBreaks = minor < 2;
        if (minor !== 1 && minor !== 2) {
            throwWarning1(state40, "unsupported YAML version of the document");
        }
    },
    TAG: function handleTagDirective(state41, name, args) {
        var handle, prefix;
        if (args.length !== 2) {
            throwError1(state41, "TAG directive accepts exactly two arguments");
        }
        handle = args[0];
        prefix = args[1];
        if (!PATTERN_TAG_HANDLE1.test(handle)) {
            throwError1(state41, "ill-formed tag handle (first argument) of the TAG directive");
        }
        if (_hasOwnProperty$1.call(state41.tagMap, handle)) {
            throwError1(state41, 'there is a previously declared suffix for "' + handle + '" tag handle');
        }
        if (!PATTERN_TAG_URI1.test(prefix)) {
            throwError1(state41, "ill-formed tag prefix (second argument) of the TAG directive");
        }
        try {
            prefix = decodeURIComponent(prefix);
        } catch (err) {
            throwError1(state41, "tag prefix is malformed: " + prefix);
        }
        state41.tagMap[handle] = prefix;
    }
};
function captureSegment1(state42, start, end, checkJson) {
    var _position, _length, _character, _result;
    if (start < end) {
        _result = state42.input.slice(start, end);
        if (checkJson) {
            for(_position = 0, _length = _result.length; _position < _length; _position += 1){
                _character = _result.charCodeAt(_position);
                if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
                    throwError1(state42, "expected valid JSON character");
                }
            }
        } else if (PATTERN_NON_PRINTABLE1.test(_result)) {
            throwError1(state42, "the stream contains non-printable characters");
        }
        state42.result += _result;
    }
}
function mergeMappings1(state43, destination, source, overridableKeys) {
    var sourceKeys, key, index, quantity;
    if (!common.isObject(source)) {
        throwError1(state43, "cannot merge mappings; the provided source object is unacceptable");
    }
    sourceKeys = Object.keys(source);
    for(index = 0, quantity = sourceKeys.length; index < quantity; index += 1){
        key = sourceKeys[index];
        if (!_hasOwnProperty$1.call(destination, key)) {
            destination[key] = source[key];
            overridableKeys[key] = true;
        }
    }
}
function storeMappingPair1(state44, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
    var index, quantity;
    if (Array.isArray(keyNode)) {
        keyNode = Array.prototype.slice.call(keyNode);
        for(index = 0, quantity = keyNode.length; index < quantity; index += 1){
            if (Array.isArray(keyNode[index])) {
                throwError1(state44, "nested arrays are not supported inside keys");
            }
            if (typeof keyNode === "object" && _class1(keyNode[index]) === "[object Object]") {
                keyNode[index] = "[object Object]";
            }
        }
    }
    if (typeof keyNode === "object" && _class1(keyNode) === "[object Object]") {
        keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (_result === null) {
        _result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
        if (Array.isArray(valueNode)) {
            for(index = 0, quantity = valueNode.length; index < quantity; index += 1){
                mergeMappings1(state44, _result, valueNode[index], overridableKeys);
            }
        } else {
            mergeMappings1(state44, _result, valueNode, overridableKeys);
        }
    } else {
        if (!state44.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
            state44.line = startLine || state44.line;
            state44.lineStart = startLineStart || state44.lineStart;
            state44.position = startPos || state44.position;
            throwError1(state44, "duplicated mapping key");
        }
        if (keyNode === "__proto__") {
            Object.defineProperty(_result, keyNode, {
                configurable: true,
                enumerable: true,
                writable: true,
                value: valueNode
            });
        } else {
            _result[keyNode] = valueNode;
        }
        delete overridableKeys[keyNode];
    }
    return _result;
}
function readLineBreak1(state45) {
    var ch;
    ch = state45.input.charCodeAt(state45.position);
    if (ch === 10) {
        state45.position++;
    } else if (ch === 13) {
        state45.position++;
        if (state45.input.charCodeAt(state45.position) === 10) {
            state45.position++;
        }
    } else {
        throwError1(state45, "a line break is expected");
    }
    state45.line += 1;
    state45.lineStart = state45.position;
    state45.firstTabInLine = -1;
}
function skipSeparationSpace1(state46, allowComments, checkIndent) {
    var lineBreaks = 0, ch = state46.input.charCodeAt(state46.position);
    while(ch !== 0){
        while(is_WHITE_SPACE(ch)){
            if (ch === 9 && state46.firstTabInLine === -1) {
                state46.firstTabInLine = state46.position;
            }
            ch = state46.input.charCodeAt(++state46.position);
        }
        if (allowComments && ch === 35) {
            do {
                ch = state46.input.charCodeAt(++state46.position);
            }while (ch !== 10 && ch !== 13 && ch !== 0)
        }
        if (is_EOL(ch)) {
            readLineBreak1(state46);
            ch = state46.input.charCodeAt(state46.position);
            lineBreaks++;
            state46.lineIndent = 0;
            while(ch === 32){
                state46.lineIndent++;
                ch = state46.input.charCodeAt(++state46.position);
            }
        } else {
            break;
        }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state46.lineIndent < checkIndent) {
        throwWarning1(state46, "deficient indentation");
    }
    return lineBreaks;
}
function testDocumentSeparator1(state47) {
    var _position = state47.position, ch;
    ch = state47.input.charCodeAt(_position);
    if ((ch === 45 || ch === 46) && ch === state47.input.charCodeAt(_position + 1) && ch === state47.input.charCodeAt(_position + 2)) {
        _position += 3;
        ch = state47.input.charCodeAt(_position);
        if (ch === 0 || is_WS_OR_EOL(ch)) {
            return true;
        }
    }
    return false;
}
function writeFoldedLines1(state48, count) {
    if (count === 1) {
        state48.result += " ";
    } else if (count > 1) {
        state48.result += common.repeat("\n", count - 1);
    }
}
function readPlainScalar1(state49, nodeIndent, withinFlowCollection) {
    var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state49.kind, _result = state49.result, ch;
    ch = state49.input.charCodeAt(state49.position);
    if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
        return false;
    }
    if (ch === 63 || ch === 45) {
        following = state49.input.charCodeAt(state49.position + 1);
        if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
            return false;
        }
    }
    state49.kind = "scalar";
    state49.result = "";
    captureStart = captureEnd = state49.position;
    hasPendingContent = false;
    while(ch !== 0){
        if (ch === 58) {
            following = state49.input.charCodeAt(state49.position + 1);
            if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
                break;
            }
        } else if (ch === 35) {
            preceding = state49.input.charCodeAt(state49.position - 1);
            if (is_WS_OR_EOL(preceding)) {
                break;
            }
        } else if (state49.position === state49.lineStart && testDocumentSeparator1(state49) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
            break;
        } else if (is_EOL(ch)) {
            _line = state49.line;
            _lineStart = state49.lineStart;
            _lineIndent = state49.lineIndent;
            skipSeparationSpace1(state49, false, -1);
            if (state49.lineIndent >= nodeIndent) {
                hasPendingContent = true;
                ch = state49.input.charCodeAt(state49.position);
                continue;
            } else {
                state49.position = captureEnd;
                state49.line = _line;
                state49.lineStart = _lineStart;
                state49.lineIndent = _lineIndent;
                break;
            }
        }
        if (hasPendingContent) {
            captureSegment1(state49, captureStart, captureEnd, false);
            writeFoldedLines1(state49, state49.line - _line);
            captureStart = captureEnd = state49.position;
            hasPendingContent = false;
        }
        if (!is_WHITE_SPACE(ch)) {
            captureEnd = state49.position + 1;
        }
        ch = state49.input.charCodeAt(++state49.position);
    }
    captureSegment1(state49, captureStart, captureEnd, false);
    if (state49.result) {
        return true;
    }
    state49.kind = _kind;
    state49.result = _result;
    return false;
}
function readSingleQuotedScalar1(state50, nodeIndent) {
    var ch, captureStart, captureEnd;
    ch = state50.input.charCodeAt(state50.position);
    if (ch !== 39) {
        return false;
    }
    state50.kind = "scalar";
    state50.result = "";
    state50.position++;
    captureStart = captureEnd = state50.position;
    while((ch = state50.input.charCodeAt(state50.position)) !== 0){
        if (ch === 39) {
            captureSegment1(state50, captureStart, state50.position, true);
            ch = state50.input.charCodeAt(++state50.position);
            if (ch === 39) {
                captureStart = state50.position;
                state50.position++;
                captureEnd = state50.position;
            } else {
                return true;
            }
        } else if (is_EOL(ch)) {
            captureSegment1(state50, captureStart, captureEnd, true);
            writeFoldedLines1(state50, skipSeparationSpace1(state50, false, nodeIndent));
            captureStart = captureEnd = state50.position;
        } else if (state50.position === state50.lineStart && testDocumentSeparator1(state50)) {
            throwError1(state50, "unexpected end of the document within a single quoted scalar");
        } else {
            state50.position++;
            captureEnd = state50.position;
        }
    }
    throwError1(state50, "unexpected end of the stream within a single quoted scalar");
}
function readDoubleQuotedScalar1(state51, nodeIndent) {
    var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
    ch = state51.input.charCodeAt(state51.position);
    if (ch !== 34) {
        return false;
    }
    state51.kind = "scalar";
    state51.result = "";
    state51.position++;
    captureStart = captureEnd = state51.position;
    while((ch = state51.input.charCodeAt(state51.position)) !== 0){
        if (ch === 34) {
            captureSegment1(state51, captureStart, state51.position, true);
            state51.position++;
            return true;
        } else if (ch === 92) {
            captureSegment1(state51, captureStart, state51.position, true);
            ch = state51.input.charCodeAt(++state51.position);
            if (is_EOL(ch)) {
                skipSeparationSpace1(state51, false, nodeIndent);
            } else if (ch < 256 && simpleEscapeCheck1[ch]) {
                state51.result += simpleEscapeMap1[ch];
                state51.position++;
            } else if ((tmp = escapedHexLen1(ch)) > 0) {
                hexLength = tmp;
                hexResult = 0;
                for(; hexLength > 0; hexLength--){
                    ch = state51.input.charCodeAt(++state51.position);
                    if ((tmp = fromHexCode1(ch)) >= 0) {
                        hexResult = (hexResult << 4) + tmp;
                    } else {
                        throwError1(state51, "expected hexadecimal character");
                    }
                }
                state51.result += charFromCodepoint1(hexResult);
                state51.position++;
            } else {
                throwError1(state51, "unknown escape sequence");
            }
            captureStart = captureEnd = state51.position;
        } else if (is_EOL(ch)) {
            captureSegment1(state51, captureStart, captureEnd, true);
            writeFoldedLines1(state51, skipSeparationSpace1(state51, false, nodeIndent));
            captureStart = captureEnd = state51.position;
        } else if (state51.position === state51.lineStart && testDocumentSeparator1(state51)) {
            throwError1(state51, "unexpected end of the document within a double quoted scalar");
        } else {
            state51.position++;
            captureEnd = state51.position;
        }
    }
    throwError1(state51, "unexpected end of the stream within a double quoted scalar");
}
function readFlowCollection1(state52, nodeIndent) {
    var readNext = true, _line, _lineStart, _pos, _tag = state52.tag, _result, _anchor = state52.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = Object.create(null), keyNode, keyTag, valueNode, ch;
    ch = state52.input.charCodeAt(state52.position);
    if (ch === 91) {
        terminator = 93;
        isMapping = false;
        _result = [];
    } else if (ch === 123) {
        terminator = 125;
        isMapping = true;
        _result = {};
    } else {
        return false;
    }
    if (state52.anchor !== null) {
        state52.anchorMap[state52.anchor] = _result;
    }
    ch = state52.input.charCodeAt(++state52.position);
    while(ch !== 0){
        skipSeparationSpace1(state52, true, nodeIndent);
        ch = state52.input.charCodeAt(state52.position);
        if (ch === terminator) {
            state52.position++;
            state52.tag = _tag;
            state52.anchor = _anchor;
            state52.kind = isMapping ? "mapping" : "sequence";
            state52.result = _result;
            return true;
        } else if (!readNext) {
            throwError1(state52, "missed comma between flow collection entries");
        } else if (ch === 44) {
            throwError1(state52, "expected the node content, but found ','");
        }
        keyTag = keyNode = valueNode = null;
        isPair = isExplicitPair = false;
        if (ch === 63) {
            following = state52.input.charCodeAt(state52.position + 1);
            if (is_WS_OR_EOL(following)) {
                isPair = isExplicitPair = true;
                state52.position++;
                skipSeparationSpace1(state52, true, nodeIndent);
            }
        }
        _line = state52.line;
        _lineStart = state52.lineStart;
        _pos = state52.position;
        composeNode1(state52, nodeIndent, CONTEXT_FLOW_IN, false, true);
        keyTag = state52.tag;
        keyNode = state52.result;
        skipSeparationSpace1(state52, true, nodeIndent);
        ch = state52.input.charCodeAt(state52.position);
        if ((isExplicitPair || state52.line === _line) && ch === 58) {
            isPair = true;
            ch = state52.input.charCodeAt(++state52.position);
            skipSeparationSpace1(state52, true, nodeIndent);
            composeNode1(state52, nodeIndent, CONTEXT_FLOW_IN, false, true);
            valueNode = state52.result;
        }
        if (isMapping) {
            storeMappingPair1(state52, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
        } else if (isPair) {
            _result.push(storeMappingPair1(state52, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
        } else {
            _result.push(keyNode);
        }
        skipSeparationSpace1(state52, true, nodeIndent);
        ch = state52.input.charCodeAt(state52.position);
        if (ch === 44) {
            readNext = true;
            ch = state52.input.charCodeAt(++state52.position);
        } else {
            readNext = false;
        }
    }
    throwError1(state52, "unexpected end of the stream within a flow collection");
}
function readBlockScalar1(state53, nodeIndent) {
    var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
    ch = state53.input.charCodeAt(state53.position);
    if (ch === 124) {
        folding = false;
    } else if (ch === 62) {
        folding = true;
    } else {
        return false;
    }
    state53.kind = "scalar";
    state53.result = "";
    while(ch !== 0){
        ch = state53.input.charCodeAt(++state53.position);
        if (ch === 43 || ch === 45) {
            if (CHOMPING_CLIP === chomping) {
                chomping = ch === 43 ? CHOMPING_KEEP1 : CHOMPING_STRIP1;
            } else {
                throwError1(state53, "repeat of a chomping mode identifier");
            }
        } else if ((tmp = fromDecimalCode1(ch)) >= 0) {
            if (tmp === 0) {
                throwError1(state53, "bad explicit indentation width of a block scalar; it cannot be less than one");
            } else if (!detectedIndent) {
                textIndent = nodeIndent + tmp - 1;
                detectedIndent = true;
            } else {
                throwError1(state53, "repeat of an indentation width identifier");
            }
        } else {
            break;
        }
    }
    if (is_WHITE_SPACE(ch)) {
        do {
            ch = state53.input.charCodeAt(++state53.position);
        }while (is_WHITE_SPACE(ch))
        if (ch === 35) {
            do {
                ch = state53.input.charCodeAt(++state53.position);
            }while (!is_EOL(ch) && ch !== 0)
        }
    }
    while(ch !== 0){
        readLineBreak1(state53);
        state53.lineIndent = 0;
        ch = state53.input.charCodeAt(state53.position);
        while((!detectedIndent || state53.lineIndent < textIndent) && ch === 32){
            state53.lineIndent++;
            ch = state53.input.charCodeAt(++state53.position);
        }
        if (!detectedIndent && state53.lineIndent > textIndent) {
            textIndent = state53.lineIndent;
        }
        if (is_EOL(ch)) {
            emptyLines++;
            continue;
        }
        if (state53.lineIndent < textIndent) {
            if (chomping === CHOMPING_KEEP1) {
                state53.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (chomping === CHOMPING_CLIP) {
                if (didReadContent) {
                    state53.result += "\n";
                }
            }
            break;
        }
        if (folding) {
            if (is_WHITE_SPACE(ch)) {
                atMoreIndented = true;
                state53.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (atMoreIndented) {
                atMoreIndented = false;
                state53.result += common.repeat("\n", emptyLines + 1);
            } else if (emptyLines === 0) {
                if (didReadContent) {
                    state53.result += " ";
                }
            } else {
                state53.result += common.repeat("\n", emptyLines);
            }
        } else {
            state53.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        }
        didReadContent = true;
        detectedIndent = true;
        emptyLines = 0;
        captureStart = state53.position;
        while(!is_EOL(ch) && ch !== 0){
            ch = state53.input.charCodeAt(++state53.position);
        }
        captureSegment1(state53, captureStart, state53.position, false);
    }
    return true;
}
function readBlockSequence1(state54, nodeIndent) {
    var _line, _tag = state54.tag, _anchor = state54.anchor, _result = [], following, detected = false, ch;
    if (state54.firstTabInLine !== -1) return false;
    if (state54.anchor !== null) {
        state54.anchorMap[state54.anchor] = _result;
    }
    ch = state54.input.charCodeAt(state54.position);
    while(ch !== 0){
        if (state54.firstTabInLine !== -1) {
            state54.position = state54.firstTabInLine;
            throwError1(state54, "tab characters must not be used in indentation");
        }
        if (ch !== 45) {
            break;
        }
        following = state54.input.charCodeAt(state54.position + 1);
        if (!is_WS_OR_EOL(following)) {
            break;
        }
        detected = true;
        state54.position++;
        if (skipSeparationSpace1(state54, true, -1)) {
            if (state54.lineIndent <= nodeIndent) {
                _result.push(null);
                ch = state54.input.charCodeAt(state54.position);
                continue;
            }
        }
        _line = state54.line;
        composeNode1(state54, nodeIndent, CONTEXT_BLOCK_IN1, false, true);
        _result.push(state54.result);
        skipSeparationSpace1(state54, true, -1);
        ch = state54.input.charCodeAt(state54.position);
        if ((state54.line === _line || state54.lineIndent > nodeIndent) && ch !== 0) {
            throwError1(state54, "bad indentation of a sequence entry");
        } else if (state54.lineIndent < nodeIndent) {
            break;
        }
    }
    if (detected) {
        state54.tag = _tag;
        state54.anchor = _anchor;
        state54.kind = "sequence";
        state54.result = _result;
        return true;
    }
    return false;
}
function readBlockMapping1(state55, nodeIndent, flowIndent) {
    var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state55.tag, _anchor = state55.anchor, _result = {}, overridableKeys = Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state55.firstTabInLine !== -1) return false;
    if (state55.anchor !== null) {
        state55.anchorMap[state55.anchor] = _result;
    }
    ch = state55.input.charCodeAt(state55.position);
    while(ch !== 0){
        if (!atExplicitKey && state55.firstTabInLine !== -1) {
            state55.position = state55.firstTabInLine;
            throwError1(state55, "tab characters must not be used in indentation");
        }
        following = state55.input.charCodeAt(state55.position + 1);
        _line = state55.line;
        if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
            if (ch === 63) {
                if (atExplicitKey) {
                    storeMappingPair1(state55, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
                    keyTag = keyNode = valueNode = null;
                }
                detected = true;
                atExplicitKey = true;
                allowCompact = true;
            } else if (atExplicitKey) {
                atExplicitKey = false;
                allowCompact = true;
            } else {
                throwError1(state55, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
            }
            state55.position += 1;
            ch = following;
        } else {
            _keyLine = state55.line;
            _keyLineStart = state55.lineStart;
            _keyPos = state55.position;
            if (!composeNode1(state55, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
                break;
            }
            if (state55.line === _line) {
                ch = state55.input.charCodeAt(state55.position);
                while(is_WHITE_SPACE(ch)){
                    ch = state55.input.charCodeAt(++state55.position);
                }
                if (ch === 58) {
                    ch = state55.input.charCodeAt(++state55.position);
                    if (!is_WS_OR_EOL(ch)) {
                        throwError1(state55, "a whitespace character is expected after the key-value separator within a block mapping");
                    }
                    if (atExplicitKey) {
                        storeMappingPair1(state55, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
                        keyTag = keyNode = valueNode = null;
                    }
                    detected = true;
                    atExplicitKey = false;
                    allowCompact = false;
                    keyTag = state55.tag;
                    keyNode = state55.result;
                } else if (detected) {
                    throwError1(state55, "can not read an implicit mapping pair; a colon is missed");
                } else {
                    state55.tag = _tag;
                    state55.anchor = _anchor;
                    return true;
                }
            } else if (detected) {
                throwError1(state55, "can not read a block mapping entry; a multiline key may not be an implicit key");
            } else {
                state55.tag = _tag;
                state55.anchor = _anchor;
                return true;
            }
        }
        if (state55.line === _line || state55.lineIndent > nodeIndent) {
            if (atExplicitKey) {
                _keyLine = state55.line;
                _keyLineStart = state55.lineStart;
                _keyPos = state55.position;
            }
            if (composeNode1(state55, nodeIndent, CONTEXT_BLOCK_OUT1, true, allowCompact)) {
                if (atExplicitKey) {
                    keyNode = state55.result;
                } else {
                    valueNode = state55.result;
                }
            }
            if (!atExplicitKey) {
                storeMappingPair1(state55, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
                keyTag = keyNode = valueNode = null;
            }
            skipSeparationSpace1(state55, true, -1);
            ch = state55.input.charCodeAt(state55.position);
        }
        if ((state55.line === _line || state55.lineIndent > nodeIndent) && ch !== 0) {
            throwError1(state55, "bad indentation of a mapping entry");
        } else if (state55.lineIndent < nodeIndent) {
            break;
        }
    }
    if (atExplicitKey) {
        storeMappingPair1(state55, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
    }
    if (detected) {
        state55.tag = _tag;
        state55.anchor = _anchor;
        state55.kind = "mapping";
        state55.result = _result;
    }
    return detected;
}
function readTagProperty1(state56) {
    var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
    ch = state56.input.charCodeAt(state56.position);
    if (ch !== 33) return false;
    if (state56.tag !== null) {
        throwError1(state56, "duplication of a tag property");
    }
    ch = state56.input.charCodeAt(++state56.position);
    if (ch === 60) {
        isVerbatim = true;
        ch = state56.input.charCodeAt(++state56.position);
    } else if (ch === 33) {
        isNamed = true;
        tagHandle = "!!";
        ch = state56.input.charCodeAt(++state56.position);
    } else {
        tagHandle = "!";
    }
    _position = state56.position;
    if (isVerbatim) {
        do {
            ch = state56.input.charCodeAt(++state56.position);
        }while (ch !== 0 && ch !== 62)
        if (state56.position < state56.length) {
            tagName = state56.input.slice(_position, state56.position);
            ch = state56.input.charCodeAt(++state56.position);
        } else {
            throwError1(state56, "unexpected end of the stream within a verbatim tag");
        }
    } else {
        while(ch !== 0 && !is_WS_OR_EOL(ch)){
            if (ch === 33) {
                if (!isNamed) {
                    tagHandle = state56.input.slice(_position - 1, state56.position + 1);
                    if (!PATTERN_TAG_HANDLE1.test(tagHandle)) {
                        throwError1(state56, "named tag handle cannot contain such characters");
                    }
                    isNamed = true;
                    _position = state56.position + 1;
                } else {
                    throwError1(state56, "tag suffix cannot contain exclamation marks");
                }
            }
            ch = state56.input.charCodeAt(++state56.position);
        }
        tagName = state56.input.slice(_position, state56.position);
        if (PATTERN_FLOW_INDICATORS1.test(tagName)) {
            throwError1(state56, "tag suffix cannot contain flow indicator characters");
        }
    }
    if (tagName && !PATTERN_TAG_URI1.test(tagName)) {
        throwError1(state56, "tag name cannot contain such characters: " + tagName);
    }
    try {
        tagName = decodeURIComponent(tagName);
    } catch (err) {
        throwError1(state56, "tag name is malformed: " + tagName);
    }
    if (isVerbatim) {
        state56.tag = tagName;
    } else if (_hasOwnProperty$1.call(state56.tagMap, tagHandle)) {
        state56.tag = state56.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
        state56.tag = "!" + tagName;
    } else if (tagHandle === "!!") {
        state56.tag = "tag:yaml.org,2002:" + tagName;
    } else {
        throwError1(state56, 'undeclared tag handle "' + tagHandle + '"');
    }
    return true;
}
function readAnchorProperty1(state57) {
    var _position, ch;
    ch = state57.input.charCodeAt(state57.position);
    if (ch !== 38) return false;
    if (state57.anchor !== null) {
        throwError1(state57, "duplication of an anchor property");
    }
    ch = state57.input.charCodeAt(++state57.position);
    _position = state57.position;
    while(ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)){
        ch = state57.input.charCodeAt(++state57.position);
    }
    if (state57.position === _position) {
        throwError1(state57, "name of an anchor node must contain at least one character");
    }
    state57.anchor = state57.input.slice(_position, state57.position);
    return true;
}
function readAlias1(state58) {
    var _position, alias, ch;
    ch = state58.input.charCodeAt(state58.position);
    if (ch !== 42) return false;
    ch = state58.input.charCodeAt(++state58.position);
    _position = state58.position;
    while(ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)){
        ch = state58.input.charCodeAt(++state58.position);
    }
    if (state58.position === _position) {
        throwError1(state58, "name of an alias node must contain at least one character");
    }
    alias = state58.input.slice(_position, state58.position);
    if (!_hasOwnProperty$1.call(state58.anchorMap, alias)) {
        throwError1(state58, 'unidentified alias "' + alias + '"');
    }
    state58.result = state58.anchorMap[alias];
    skipSeparationSpace1(state58, true, -1);
    return true;
}
function composeNode1(state59, parentIndent, nodeContext, allowToSeek, allowCompact) {
    var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
    if (state59.listener !== null) {
        state59.listener("open", state59);
    }
    state59.tag = null;
    state59.anchor = null;
    state59.kind = null;
    state59.result = null;
    allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT1 === nodeContext || CONTEXT_BLOCK_IN1 === nodeContext;
    if (allowToSeek) {
        if (skipSeparationSpace1(state59, true, -1)) {
            atNewLine = true;
            if (state59.lineIndent > parentIndent) {
                indentStatus = 1;
            } else if (state59.lineIndent === parentIndent) {
                indentStatus = 0;
            } else if (state59.lineIndent < parentIndent) {
                indentStatus = -1;
            }
        }
    }
    if (indentStatus === 1) {
        while(readTagProperty1(state59) || readAnchorProperty1(state59)){
            if (skipSeparationSpace1(state59, true, -1)) {
                atNewLine = true;
                allowBlockCollections = allowBlockStyles;
                if (state59.lineIndent > parentIndent) {
                    indentStatus = 1;
                } else if (state59.lineIndent === parentIndent) {
                    indentStatus = 0;
                } else if (state59.lineIndent < parentIndent) {
                    indentStatus = -1;
                }
            } else {
                allowBlockCollections = false;
            }
        }
    }
    if (allowBlockCollections) {
        allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || CONTEXT_BLOCK_OUT1 === nodeContext) {
        if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
            flowIndent = parentIndent;
        } else {
            flowIndent = parentIndent + 1;
        }
        blockIndent = state59.position - state59.lineStart;
        if (indentStatus === 1) {
            if (allowBlockCollections && (readBlockSequence1(state59, blockIndent) || readBlockMapping1(state59, blockIndent, flowIndent)) || readFlowCollection1(state59, flowIndent)) {
                hasContent = true;
            } else {
                if (allowBlockScalars && readBlockScalar1(state59, flowIndent) || readSingleQuotedScalar1(state59, flowIndent) || readDoubleQuotedScalar1(state59, flowIndent)) {
                    hasContent = true;
                } else if (readAlias1(state59)) {
                    hasContent = true;
                    if (state59.tag !== null || state59.anchor !== null) {
                        throwError1(state59, "alias node should not have any properties");
                    }
                } else if (readPlainScalar1(state59, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
                    hasContent = true;
                    if (state59.tag === null) {
                        state59.tag = "?";
                    }
                }
                if (state59.anchor !== null) {
                    state59.anchorMap[state59.anchor] = state59.result;
                }
            }
        } else if (indentStatus === 0) {
            hasContent = allowBlockCollections && readBlockSequence1(state59, blockIndent);
        }
    }
    if (state59.tag === null) {
        if (state59.anchor !== null) {
            state59.anchorMap[state59.anchor] = state59.result;
        }
    } else if (state59.tag === "?") {
        if (state59.result !== null && state59.kind !== "scalar") {
            throwError1(state59, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state59.kind + '"');
        }
        for(typeIndex = 0, typeQuantity = state59.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1){
            type2 = state59.implicitTypes[typeIndex];
            if (type2.resolve(state59.result)) {
                state59.result = type2.construct(state59.result);
                state59.tag = type2.tag;
                if (state59.anchor !== null) {
                    state59.anchorMap[state59.anchor] = state59.result;
                }
                break;
            }
        }
    } else if (state59.tag !== "!") {
        if (_hasOwnProperty$1.call(state59.typeMap[state59.kind || "fallback"], state59.tag)) {
            type2 = state59.typeMap[state59.kind || "fallback"][state59.tag];
        } else {
            type2 = null;
            typeList = state59.typeMap.multi[state59.kind || "fallback"];
            for(typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1){
                if (state59.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
                    type2 = typeList[typeIndex];
                    break;
                }
            }
        }
        if (!type2) {
            throwError1(state59, "unknown tag !<" + state59.tag + ">");
        }
        if (state59.result !== null && type2.kind !== state59.kind) {
            throwError1(state59, "unacceptable node kind for !<" + state59.tag + '> tag; it should be "' + type2.kind + '", not "' + state59.kind + '"');
        }
        if (!type2.resolve(state59.result, state59.tag)) {
            throwError1(state59, "cannot resolve a node with !<" + state59.tag + "> explicit tag");
        } else {
            state59.result = type2.construct(state59.result, state59.tag);
            if (state59.anchor !== null) {
                state59.anchorMap[state59.anchor] = state59.result;
            }
        }
    }
    if (state59.listener !== null) {
        state59.listener("close", state59);
    }
    return state59.tag !== null || state59.anchor !== null || hasContent;
}
function readDocument1(state60) {
    var documentStart = state60.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
    state60.version = null;
    state60.checkLineBreaks = state60.legacy;
    state60.tagMap = Object.create(null);
    state60.anchorMap = Object.create(null);
    while((ch = state60.input.charCodeAt(state60.position)) !== 0){
        skipSeparationSpace1(state60, true, -1);
        ch = state60.input.charCodeAt(state60.position);
        if (state60.lineIndent > 0 || ch !== 37) {
            break;
        }
        hasDirectives = true;
        ch = state60.input.charCodeAt(++state60.position);
        _position = state60.position;
        while(ch !== 0 && !is_WS_OR_EOL(ch)){
            ch = state60.input.charCodeAt(++state60.position);
        }
        directiveName = state60.input.slice(_position, state60.position);
        directiveArgs = [];
        if (directiveName.length < 1) {
            throwError1(state60, "directive name must not be less than one character in length");
        }
        while(ch !== 0){
            while(is_WHITE_SPACE(ch)){
                ch = state60.input.charCodeAt(++state60.position);
            }
            if (ch === 35) {
                do {
                    ch = state60.input.charCodeAt(++state60.position);
                }while (ch !== 0 && !is_EOL(ch))
                break;
            }
            if (is_EOL(ch)) break;
            _position = state60.position;
            while(ch !== 0 && !is_WS_OR_EOL(ch)){
                ch = state60.input.charCodeAt(++state60.position);
            }
            directiveArgs.push(state60.input.slice(_position, state60.position));
        }
        if (ch !== 0) readLineBreak1(state60);
        if (_hasOwnProperty$1.call(directiveHandlers1, directiveName)) {
            directiveHandlers1[directiveName](state60, directiveName, directiveArgs);
        } else {
            throwWarning1(state60, 'unknown document directive "' + directiveName + '"');
        }
    }
    skipSeparationSpace1(state60, true, -1);
    if (state60.lineIndent === 0 && state60.input.charCodeAt(state60.position) === 45 && state60.input.charCodeAt(state60.position + 1) === 45 && state60.input.charCodeAt(state60.position + 2) === 45) {
        state60.position += 3;
        skipSeparationSpace1(state60, true, -1);
    } else if (hasDirectives) {
        throwError1(state60, "directives end mark is expected");
    }
    composeNode1(state60, state60.lineIndent - 1, CONTEXT_BLOCK_OUT1, false, true);
    skipSeparationSpace1(state60, true, -1);
    if (state60.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS1.test(state60.input.slice(documentStart, state60.position))) {
        throwWarning1(state60, "non-ASCII line breaks are interpreted as content");
    }
    state60.documents.push(state60.result);
    if (state60.position === state60.lineStart && testDocumentSeparator1(state60)) {
        if (state60.input.charCodeAt(state60.position) === 46) {
            state60.position += 3;
            skipSeparationSpace1(state60, true, -1);
        }
        return;
    }
    if (state60.position < state60.length - 1) {
        throwError1(state60, "end of the stream or a document separator is expected");
    } else {
        return;
    }
}
function loadDocuments1(input, options) {
    input = String(input);
    options = options || {};
    if (input.length !== 0) {
        if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
            input += "\n";
        }
        if (input.charCodeAt(0) === 65279) {
            input = input.slice(1);
        }
    }
    var state61 = new State$1(input, options);
    var nullpos = input.indexOf("\0");
    if (nullpos !== -1) {
        state61.position = nullpos;
        throwError1(state61, "null byte is not allowed in input");
    }
    state61.input += "\0";
    while(state61.input.charCodeAt(state61.position) === 32){
        state61.lineIndent += 1;
        state61.position += 1;
    }
    while(state61.position < state61.length - 1){
        readDocument1(state61);
    }
    return state61.documents;
}
function loadAll$1(input, iterator, options) {
    if (iterator !== null && typeof iterator === "object" && typeof options === "undefined") {
        options = iterator;
        iterator = null;
    }
    var documents = loadDocuments1(input, options);
    if (typeof iterator !== "function") {
        return documents;
    }
    for(var index = 0, length = documents.length; index < length; index += 1){
        iterator(documents[index]);
    }
}
function load$1(input, options) {
    var documents = loadDocuments1(input, options);
    if (documents.length === 0) {
        return void 0;
    } else if (documents.length === 1) {
        return documents[0];
    }
    throw new exception("expected a single document in the stream, but found more");
}
var loadAll_1 = loadAll$1;
var load_1 = load$1;
var loader = {
    loadAll: loadAll_1,
    load: load_1
};
var _toString3 = Object.prototype.toString;
var _hasOwnProperty = Object.prototype.hasOwnProperty;
var CHAR_BOM = 65279;
var CHAR_TAB = 9;
var CHAR_LINE_FEED = 10;
var CHAR_CARRIAGE_RETURN = 13;
var CHAR_SPACE = 32;
var CHAR_EXCLAMATION = 33;
var CHAR_DOUBLE_QUOTE = 34;
var CHAR_SHARP = 35;
var CHAR_PERCENT = 37;
var CHAR_AMPERSAND = 38;
var CHAR_SINGLE_QUOTE = 39;
var CHAR_ASTERISK = 42;
var CHAR_COMMA = 44;
var CHAR_MINUS = 45;
var CHAR_COLON = 58;
var CHAR_EQUALS = 61;
var CHAR_GREATER_THAN = 62;
var CHAR_QUESTION = 63;
var CHAR_COMMERCIAL_AT = 64;
var CHAR_LEFT_SQUARE_BRACKET = 91;
var CHAR_RIGHT_SQUARE_BRACKET = 93;
var CHAR_GRAVE_ACCENT = 96;
var CHAR_LEFT_CURLY_BRACKET = 123;
var CHAR_VERTICAL_LINE = 124;
var CHAR_RIGHT_CURLY_BRACKET = 125;
var ESCAPE_SEQUENCES1 = {};
ESCAPE_SEQUENCES1[0] = "\\0";
ESCAPE_SEQUENCES1[7] = "\\a";
ESCAPE_SEQUENCES1[8] = "\\b";
ESCAPE_SEQUENCES1[9] = "\\t";
ESCAPE_SEQUENCES1[10] = "\\n";
ESCAPE_SEQUENCES1[11] = "\\v";
ESCAPE_SEQUENCES1[12] = "\\f";
ESCAPE_SEQUENCES1[13] = "\\r";
ESCAPE_SEQUENCES1[27] = "\\e";
ESCAPE_SEQUENCES1[34] = '\\"';
ESCAPE_SEQUENCES1[92] = "\\\\";
ESCAPE_SEQUENCES1[133] = "\\N";
ESCAPE_SEQUENCES1[160] = "\\_";
ESCAPE_SEQUENCES1[8232] = "\\L";
ESCAPE_SEQUENCES1[8233] = "\\P";
var DEPRECATED_BOOLEANS_SYNTAX1 = [
    "y",
    "Y",
    "yes",
    "Yes",
    "YES",
    "on",
    "On",
    "ON",
    "n",
    "N",
    "no",
    "No",
    "NO",
    "off",
    "Off",
    "OFF", 
];
var DEPRECATED_BASE60_SYNTAX = /^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;
function compileStyleMap1(schema2, map2) {
    var result, keys9, index, length, tag, style, type2;
    if (map2 === null) return {};
    result = {};
    keys9 = Object.keys(map2);
    for(index = 0, length = keys9.length; index < length; index += 1){
        tag = keys9[index];
        style = String(map2[tag]);
        if (tag.slice(0, 2) === "!!") {
            tag = "tag:yaml.org,2002:" + tag.slice(2);
        }
        type2 = schema2.compiledTypeMap["fallback"][tag];
        if (type2 && _hasOwnProperty.call(type2.styleAliases, style)) {
            style = type2.styleAliases[style];
        }
        result[tag] = style;
    }
    return result;
}
function encodeHex1(character) {
    var string16, handle, length;
    string16 = character.toString(16).toUpperCase();
    if (character <= 255) {
        handle = "x";
        length = 2;
    } else if (character <= 65535) {
        handle = "u";
        length = 4;
    } else if (character <= 4294967295) {
        handle = "U";
        length = 8;
    } else {
        throw new exception("code point within a string may not be greater than 0xFFFFFFFF");
    }
    return "\\" + handle + common.repeat("0", length - string16.length) + string16;
}
var QUOTING_TYPE_SINGLE = 1, QUOTING_TYPE_DOUBLE = 2;
function State2(options) {
    this.schema = options["schema"] || _default;
    this.indent = Math.max(1, options["indent"] || 2);
    this.noArrayIndent = options["noArrayIndent"] || false;
    this.skipInvalid = options["skipInvalid"] || false;
    this.flowLevel = common.isNothing(options["flowLevel"]) ? -1 : options["flowLevel"];
    this.styleMap = compileStyleMap1(this.schema, options["styles"] || null);
    this.sortKeys = options["sortKeys"] || false;
    this.lineWidth = options["lineWidth"] || 80;
    this.noRefs = options["noRefs"] || false;
    this.noCompatMode = options["noCompatMode"] || false;
    this.condenseFlow = options["condenseFlow"] || false;
    this.quotingType = options["quotingType"] === '"' ? QUOTING_TYPE_DOUBLE : QUOTING_TYPE_SINGLE;
    this.forceQuotes = options["forceQuotes"] || false;
    this.replacer = typeof options["replacer"] === "function" ? options["replacer"] : null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.explicitTypes = this.schema.compiledExplicit;
    this.tag = null;
    this.result = "";
    this.duplicates = [];
    this.usedDuplicates = null;
}
function indentString1(string17, spaces) {
    var ind = common.repeat(" ", spaces), position = 0, next = -1, result = "", line, length = string17.length;
    while(position < length){
        next = string17.indexOf("\n", position);
        if (next === -1) {
            line = string17.slice(position);
            position = length;
        } else {
            line = string17.slice(position, next + 1);
            position = next + 1;
        }
        if (line.length && line !== "\n") result += ind;
        result += line;
    }
    return result;
}
function generateNextLine1(state62, level) {
    return "\n" + common.repeat(" ", state62.indent * level);
}
function testImplicitResolving1(state63, str2) {
    var index, length, type2;
    for(index = 0, length = state63.implicitTypes.length; index < length; index += 1){
        type2 = state63.implicitTypes[index];
        if (type2.resolve(str2)) {
            return true;
        }
    }
    return false;
}
function isWhitespace1(c) {
    return c === CHAR_SPACE || c === CHAR_TAB;
}
function isPrintable1(c) {
    return 32 <= c && c <= 126 || 161 <= c && c <= 55295 && c !== 8232 && c !== 8233 || 57344 <= c && c <= 65533 && c !== CHAR_BOM || 65536 <= c && c <= 1114111;
}
function isNsCharOrWhitespace(c) {
    return isPrintable1(c) && c !== CHAR_BOM && c !== CHAR_CARRIAGE_RETURN && c !== CHAR_LINE_FEED;
}
function isPlainSafe1(c, prev, inblock) {
    var cIsNsCharOrWhitespace = isNsCharOrWhitespace(c);
    var cIsNsChar = cIsNsCharOrWhitespace && !isWhitespace1(c);
    return (inblock ? cIsNsCharOrWhitespace : cIsNsCharOrWhitespace && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET) && c !== CHAR_SHARP && !(prev === CHAR_COLON && !cIsNsChar) || isNsCharOrWhitespace(prev) && !isWhitespace1(prev) && c === CHAR_SHARP || prev === CHAR_COLON && cIsNsChar;
}
function isPlainSafeFirst1(c) {
    return isPrintable1(c) && c !== CHAR_BOM && !isWhitespace1(c) && c !== CHAR_MINUS && c !== CHAR_QUESTION && c !== CHAR_COLON && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET && c !== CHAR_SHARP && c !== CHAR_AMPERSAND && c !== CHAR_ASTERISK && c !== CHAR_EXCLAMATION && c !== CHAR_VERTICAL_LINE && c !== CHAR_EQUALS && c !== CHAR_GREATER_THAN && c !== CHAR_SINGLE_QUOTE && c !== CHAR_DOUBLE_QUOTE && c !== CHAR_PERCENT && c !== CHAR_COMMERCIAL_AT && c !== CHAR_GRAVE_ACCENT;
}
function isPlainSafeLast(c) {
    return !isWhitespace1(c) && c !== CHAR_COLON;
}
function codePointAt(string18, pos) {
    var first = string18.charCodeAt(pos), second;
    if (first >= 55296 && first <= 56319 && pos + 1 < string18.length) {
        second = string18.charCodeAt(pos + 1);
        if (second >= 56320 && second <= 57343) {
            return (first - 55296) * 1024 + second - 56320 + 65536;
        }
    }
    return first;
}
function needIndentIndicator1(string19) {
    var leadingSpaceRe = /^\n* /;
    return leadingSpaceRe.test(string19);
}
var STYLE_PLAIN1 = 1, STYLE_SINGLE1 = 2, STYLE_LITERAL1 = 3, STYLE_FOLDED1 = 4, STYLE_DOUBLE1 = 5;
function chooseScalarStyle1(string20, singleLineOnly, indentPerLevel, lineWidth, testAmbiguousType, quotingType, forceQuotes, inblock) {
    var i2;
    var __char = 0;
    var prevChar = null;
    var hasLineBreak = false;
    var hasFoldableLine = false;
    var shouldTrackWidth = lineWidth !== -1;
    var previousLineBreak = -1;
    var plain = isPlainSafeFirst1(codePointAt(string20, 0)) && isPlainSafeLast(codePointAt(string20, string20.length - 1));
    if (singleLineOnly || forceQuotes) {
        for(i2 = 0; i2 < string20.length; __char >= 65536 ? i2 += 2 : i2++){
            __char = codePointAt(string20, i2);
            if (!isPrintable1(__char)) {
                return STYLE_DOUBLE1;
            }
            plain = plain && isPlainSafe1(__char, prevChar, inblock);
            prevChar = __char;
        }
    } else {
        for(i2 = 0; i2 < string20.length; __char >= 65536 ? i2 += 2 : i2++){
            __char = codePointAt(string20, i2);
            if (__char === CHAR_LINE_FEED) {
                hasLineBreak = true;
                if (shouldTrackWidth) {
                    hasFoldableLine = hasFoldableLine || i2 - previousLineBreak - 1 > lineWidth && string20[previousLineBreak + 1] !== " ";
                    previousLineBreak = i2;
                }
            } else if (!isPrintable1(__char)) {
                return STYLE_DOUBLE1;
            }
            plain = plain && isPlainSafe1(__char, prevChar, inblock);
            prevChar = __char;
        }
        hasFoldableLine = hasFoldableLine || shouldTrackWidth && i2 - previousLineBreak - 1 > lineWidth && string20[previousLineBreak + 1] !== " ";
    }
    if (!hasLineBreak && !hasFoldableLine) {
        if (plain && !forceQuotes && !testAmbiguousType(string20)) {
            return STYLE_PLAIN1;
        }
        return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE1 : STYLE_SINGLE1;
    }
    if (indentPerLevel > 9 && needIndentIndicator1(string20)) {
        return STYLE_DOUBLE1;
    }
    if (!forceQuotes) {
        return hasFoldableLine ? STYLE_FOLDED1 : STYLE_LITERAL1;
    }
    return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE1 : STYLE_SINGLE1;
}
function writeScalar1(state64, string21, level, iskey, inblock) {
    state64.dump = function() {
        if (string21.length === 0) {
            return state64.quotingType === QUOTING_TYPE_DOUBLE ? '""' : "''";
        }
        if (!state64.noCompatMode) {
            if (DEPRECATED_BOOLEANS_SYNTAX1.indexOf(string21) !== -1 || DEPRECATED_BASE60_SYNTAX.test(string21)) {
                return state64.quotingType === QUOTING_TYPE_DOUBLE ? '"' + string21 + '"' : "'" + string21 + "'";
            }
        }
        var indent = state64.indent * Math.max(1, level);
        var lineWidth = state64.lineWidth === -1 ? -1 : Math.max(Math.min(state64.lineWidth, 40), state64.lineWidth - indent);
        var singleLineOnly = iskey || state64.flowLevel > -1 && level >= state64.flowLevel;
        function testAmbiguity(string2) {
            return testImplicitResolving1(state64, string2);
        }
        switch(chooseScalarStyle1(string21, singleLineOnly, state64.indent, lineWidth, testAmbiguity, state64.quotingType, state64.forceQuotes && !iskey, inblock)){
            case STYLE_PLAIN1:
                return string21;
            case STYLE_SINGLE1:
                return "'" + string21.replace(/'/g, "''") + "'";
            case STYLE_LITERAL1:
                return "|" + blockHeader1(string21, state64.indent) + dropEndingNewline1(indentString1(string21, indent));
            case STYLE_FOLDED1:
                return ">" + blockHeader1(string21, state64.indent) + dropEndingNewline1(indentString1(foldString1(string21, lineWidth), indent));
            case STYLE_DOUBLE1:
                return '"' + escapeString1(string21) + '"';
            default:
                throw new exception("impossible error: invalid scalar style");
        }
    }();
}
function blockHeader1(string22, indentPerLevel) {
    var indentIndicator = needIndentIndicator1(string22) ? String(indentPerLevel) : "";
    var clip = string22[string22.length - 1] === "\n";
    var keep = clip && (string22[string22.length - 2] === "\n" || string22 === "\n");
    var chomp = keep ? "+" : clip ? "" : "-";
    return indentIndicator + chomp + "\n";
}
function dropEndingNewline1(string23) {
    return string23[string23.length - 1] === "\n" ? string23.slice(0, -1) : string23;
}
function foldString1(string24, width) {
    var lineRe = /(\n+)([^\n]*)/g;
    var result = function() {
        var nextLF = string24.indexOf("\n");
        nextLF = nextLF !== -1 ? nextLF : string24.length;
        lineRe.lastIndex = nextLF;
        return foldLine1(string24.slice(0, nextLF), width);
    }();
    var prevMoreIndented = string24[0] === "\n" || string24[0] === " ";
    var moreIndented;
    var match;
    while(match = lineRe.exec(string24)){
        var prefix = match[1], line = match[2];
        moreIndented = line[0] === " ";
        result += prefix + (!prevMoreIndented && !moreIndented && line !== "" ? "\n" : "") + foldLine1(line, width);
        prevMoreIndented = moreIndented;
    }
    return result;
}
function foldLine1(line, width) {
    if (line === "" || line[0] === " ") return line;
    var breakRe = / [^ ]/g;
    var match;
    var start = 0, end, curr = 0, next = 0;
    var result = "";
    while(match = breakRe.exec(line)){
        next = match.index;
        if (next - start > width) {
            end = curr > start ? curr : next;
            result += "\n" + line.slice(start, end);
            start = end + 1;
        }
        curr = next;
    }
    result += "\n";
    if (line.length - start > width && curr > start) {
        result += line.slice(start, curr) + "\n" + line.slice(curr + 1);
    } else {
        result += line.slice(start);
    }
    return result.slice(1);
}
function escapeString1(string25) {
    var result = "";
    var __char = 0;
    var escapeSeq;
    for(var i3 = 0; i3 < string25.length; __char >= 65536 ? i3 += 2 : i3++){
        __char = codePointAt(string25, i3);
        escapeSeq = ESCAPE_SEQUENCES1[__char];
        if (!escapeSeq && isPrintable1(__char)) {
            result += string25[i3];
            if (__char >= 65536) result += string25[i3 + 1];
        } else {
            result += escapeSeq || encodeHex1(__char);
        }
    }
    return result;
}
function writeFlowSequence1(state65, level, object) {
    var _result = "", _tag = state65.tag, index, length, value;
    for(index = 0, length = object.length; index < length; index += 1){
        value = object[index];
        if (state65.replacer) {
            value = state65.replacer.call(object, String(index), value);
        }
        if (writeNode1(state65, level, value, false, false) || typeof value === "undefined" && writeNode1(state65, level, null, false, false)) {
            if (_result !== "") _result += "," + (!state65.condenseFlow ? " " : "");
            _result += state65.dump;
        }
    }
    state65.tag = _tag;
    state65.dump = "[" + _result + "]";
}
function writeBlockSequence1(state66, level, object, compact) {
    var _result = "", _tag = state66.tag, index, length, value;
    for(index = 0, length = object.length; index < length; index += 1){
        value = object[index];
        if (state66.replacer) {
            value = state66.replacer.call(object, String(index), value);
        }
        if (writeNode1(state66, level + 1, value, true, true, false, true) || typeof value === "undefined" && writeNode1(state66, level + 1, null, true, true, false, true)) {
            if (!compact || _result !== "") {
                _result += generateNextLine1(state66, level);
            }
            if (state66.dump && CHAR_LINE_FEED === state66.dump.charCodeAt(0)) {
                _result += "-";
            } else {
                _result += "- ";
            }
            _result += state66.dump;
        }
    }
    state66.tag = _tag;
    state66.dump = _result || "[]";
}
function writeFlowMapping1(state67, level, object) {
    var _result = "", _tag = state67.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, pairBuffer;
    for(index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = "";
        if (_result !== "") pairBuffer += ", ";
        if (state67.condenseFlow) pairBuffer += '"';
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (state67.replacer) {
            objectValue = state67.replacer.call(object, objectKey, objectValue);
        }
        if (!writeNode1(state67, level, objectKey, false, false)) {
            continue;
        }
        if (state67.dump.length > 1024) pairBuffer += "? ";
        pairBuffer += state67.dump + (state67.condenseFlow ? '"' : "") + ":" + (state67.condenseFlow ? "" : " ");
        if (!writeNode1(state67, level, objectValue, false, false)) {
            continue;
        }
        pairBuffer += state67.dump;
        _result += pairBuffer;
    }
    state67.tag = _tag;
    state67.dump = "{" + _result + "}";
}
function writeBlockMapping1(state68, level, object, compact) {
    var _result = "", _tag = state68.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, explicitPair, pairBuffer;
    if (state68.sortKeys === true) {
        objectKeyList.sort();
    } else if (typeof state68.sortKeys === "function") {
        objectKeyList.sort(state68.sortKeys);
    } else if (state68.sortKeys) {
        throw new exception("sortKeys must be a boolean or a function");
    }
    for(index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = "";
        if (!compact || _result !== "") {
            pairBuffer += generateNextLine1(state68, level);
        }
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (state68.replacer) {
            objectValue = state68.replacer.call(object, objectKey, objectValue);
        }
        if (!writeNode1(state68, level + 1, objectKey, true, true, true)) {
            continue;
        }
        explicitPair = state68.tag !== null && state68.tag !== "?" || state68.dump && state68.dump.length > 1024;
        if (explicitPair) {
            if (state68.dump && CHAR_LINE_FEED === state68.dump.charCodeAt(0)) {
                pairBuffer += "?";
            } else {
                pairBuffer += "? ";
            }
        }
        pairBuffer += state68.dump;
        if (explicitPair) {
            pairBuffer += generateNextLine1(state68, level);
        }
        if (!writeNode1(state68, level + 1, objectValue, true, explicitPair)) {
            continue;
        }
        if (state68.dump && CHAR_LINE_FEED === state68.dump.charCodeAt(0)) {
            pairBuffer += ":";
        } else {
            pairBuffer += ": ";
        }
        pairBuffer += state68.dump;
        _result += pairBuffer;
    }
    state68.tag = _tag;
    state68.dump = _result || "{}";
}
function detectType1(state69, object, explicit) {
    var _result, typeList, index, length, type2, style;
    typeList = explicit ? state69.explicitTypes : state69.implicitTypes;
    for(index = 0, length = typeList.length; index < length; index += 1){
        type2 = typeList[index];
        if ((type2.instanceOf || type2.predicate) && (!type2.instanceOf || typeof object === "object" && object instanceof type2.instanceOf) && (!type2.predicate || type2.predicate(object))) {
            if (explicit) {
                if (type2.multi && type2.representName) {
                    state69.tag = type2.representName(object);
                } else {
                    state69.tag = type2.tag;
                }
            } else {
                state69.tag = "?";
            }
            if (type2.represent) {
                style = state69.styleMap[type2.tag] || type2.defaultStyle;
                if (_toString3.call(type2.represent) === "[object Function]") {
                    _result = type2.represent(object, style);
                } else if (_hasOwnProperty.call(type2.represent, style)) {
                    _result = type2.represent[style](object, style);
                } else {
                    throw new exception("!<" + type2.tag + '> tag resolver accepts not "' + style + '" style');
                }
                state69.dump = _result;
            }
            return true;
        }
    }
    return false;
}
function writeNode1(state70, level, object, block, compact, iskey, isblockseq) {
    state70.tag = null;
    state70.dump = object;
    if (!detectType1(state70, object, false)) {
        detectType1(state70, object, true);
    }
    var type2 = _toString3.call(state70.dump);
    var inblock = block;
    var tagStr;
    if (block) {
        block = state70.flowLevel < 0 || state70.flowLevel > level;
    }
    var objectOrArray = type2 === "[object Object]" || type2 === "[object Array]", duplicateIndex, duplicate;
    if (objectOrArray) {
        duplicateIndex = state70.duplicates.indexOf(object);
        duplicate = duplicateIndex !== -1;
    }
    if (state70.tag !== null && state70.tag !== "?" || duplicate || state70.indent !== 2 && level > 0) {
        compact = false;
    }
    if (duplicate && state70.usedDuplicates[duplicateIndex]) {
        state70.dump = "*ref_" + duplicateIndex;
    } else {
        if (objectOrArray && duplicate && !state70.usedDuplicates[duplicateIndex]) {
            state70.usedDuplicates[duplicateIndex] = true;
        }
        if (type2 === "[object Object]") {
            if (block && Object.keys(state70.dump).length !== 0) {
                writeBlockMapping1(state70, level, state70.dump, compact);
                if (duplicate) {
                    state70.dump = "&ref_" + duplicateIndex + state70.dump;
                }
            } else {
                writeFlowMapping1(state70, level, state70.dump);
                if (duplicate) {
                    state70.dump = "&ref_" + duplicateIndex + " " + state70.dump;
                }
            }
        } else if (type2 === "[object Array]") {
            if (block && state70.dump.length !== 0) {
                if (state70.noArrayIndent && !isblockseq && level > 0) {
                    writeBlockSequence1(state70, level - 1, state70.dump, compact);
                } else {
                    writeBlockSequence1(state70, level, state70.dump, compact);
                }
                if (duplicate) {
                    state70.dump = "&ref_" + duplicateIndex + state70.dump;
                }
            } else {
                writeFlowSequence1(state70, level, state70.dump);
                if (duplicate) {
                    state70.dump = "&ref_" + duplicateIndex + " " + state70.dump;
                }
            }
        } else if (type2 === "[object String]") {
            if (state70.tag !== "?") {
                writeScalar1(state70, state70.dump, level, iskey, inblock);
            }
        } else if (type2 === "[object Undefined]") {
            return false;
        } else {
            if (state70.skipInvalid) return false;
            throw new exception("unacceptable kind of an object to dump " + type2);
        }
        if (state70.tag !== null && state70.tag !== "?") {
            tagStr = encodeURI(state70.tag[0] === "!" ? state70.tag.slice(1) : state70.tag).replace(/!/g, "%21");
            if (state70.tag[0] === "!") {
                tagStr = "!" + tagStr;
            } else if (tagStr.slice(0, 18) === "tag:yaml.org,2002:") {
                tagStr = "!!" + tagStr.slice(18);
            } else {
                tagStr = "!<" + tagStr + ">";
            }
            state70.dump = tagStr + " " + state70.dump;
        }
    }
    return true;
}
function getDuplicateReferences1(object, state71) {
    var objects = [], duplicatesIndexes = [], index, length;
    inspectNode1(object, objects, duplicatesIndexes);
    for(index = 0, length = duplicatesIndexes.length; index < length; index += 1){
        state71.duplicates.push(objects[duplicatesIndexes[index]]);
    }
    state71.usedDuplicates = new Array(length);
}
function inspectNode1(object, objects, duplicatesIndexes) {
    var objectKeyList, index, length;
    if (object !== null && typeof object === "object") {
        index = objects.indexOf(object);
        if (index !== -1) {
            if (duplicatesIndexes.indexOf(index) === -1) {
                duplicatesIndexes.push(index);
            }
        } else {
            objects.push(object);
            if (Array.isArray(object)) {
                for(index = 0, length = object.length; index < length; index += 1){
                    inspectNode1(object[index], objects, duplicatesIndexes);
                }
            } else {
                objectKeyList = Object.keys(object);
                for(index = 0, length = objectKeyList.length; index < length; index += 1){
                    inspectNode1(object[objectKeyList[index]], objects, duplicatesIndexes);
                }
            }
        }
    }
}
function dump$1(input, options) {
    options = options || {};
    var state72 = new State2(options);
    if (!state72.noRefs) getDuplicateReferences1(input, state72);
    var value = input;
    if (state72.replacer) {
        value = state72.replacer.call({
            "": value
        }, "", value);
    }
    if (writeNode1(state72, 0, value, true, true)) return state72.dump + "\n";
    return "";
}
var dump_1 = dump$1;
var dumper = {
    dump: dump_1
};
function renamed(from, to) {
    return function() {
        throw new Error("Function yaml." + from + " is removed in js-yaml 4. Use yaml." + to + " instead, which is now safe by default.");
    };
}
var Type2 = type;
var Schema1 = schema;
var load1 = loader.load;
loader.loadAll;
dumper.dump;
renamed("safeLoad", "load");
renamed("safeLoadAll", "loadAll");
renamed("safeDump", "dump");
const QuartoJSONSchema = new Schema1({
    implicit: [
        _null,
        bool1,
        __int1,
        __float1
    ],
    include: [
        failsafe1
    ],
    explicit: [
        new Type2("!expr", {
            kind: "scalar",
            construct (data54) {
                const result = data54 !== null ? data54 : "";
                return {
                    value: result,
                    tag: "!expr"
                };
            }
        }), 
    ]
});
function readAnnotatedYamlFromMappedString(mappedSource2) {
    const parser = getTreeSitterSync();
    const tree = parser.parse(mappedSource2.value);
    const treeSitterAnnotation = buildTreeSitterAnnotation(tree, mappedSource2);
    if (treeSitterAnnotation) {
        return treeSitterAnnotation;
    }
    try {
        return buildJsYamlAnnotation(mappedSource2);
    } catch (e) {
        const m = e.stack.split("\n")[0].match(/^.+ \((\d+):(\d+)\)$/);
        if (m) {
            const f = lineColToIndex(mappedSource2.value);
            const offset = f({
                line: Number(m[1]) - 1,
                column: Number(m[2] - 1)
            });
            const { originalString  } = mappedSource2.map(offset, true);
            const filename = originalString.fileName;
            const f2 = mappedIndexToLineCol(mappedSource2);
            const { line , column  } = f2(offset);
            const sourceContext = createSourceContext(mappedSource2, {
                start: offset,
                end: offset + 1
            });
            e.stack = `${e.reason} (${filename}, ${line + 1}:${column + 1})\n${sourceContext}`;
            e.message = e.stack;
            e.stack = "";
        }
        throw e;
    }
}
function buildJsYamlAnnotation(mappedYaml) {
    const yml = mappedYaml.value;
    const stack = [];
    const results = [];
    function listener(what, state73) {
        const { result , position , kind  } = state73;
        if (what === "close") {
            const { position: openPosition  } = stack.pop();
            if (results.length > 0) {
                const last = results[results.length - 1];
                if (last.start === openPosition && last.end === position) {
                    return;
                }
            }
            const components = [];
            while(results.length > 0){
                const last = results[results.length - 1];
                if (last.end <= openPosition) {
                    break;
                }
                components.push(results.pop());
            }
            components.reverse();
            const rawRange = yml.substring(openPosition, position);
            const leftTrim = rawRange.length - rawRange.trimLeft().length;
            const rightTrim = rawRange.length - rawRange.trimRight().length;
            if (rawRange.trim().length === 0) {
                results.push({
                    start: position - rightTrim,
                    end: position - rightTrim,
                    result: result,
                    components,
                    kind,
                    source: mappedYaml
                });
            } else {
                results.push({
                    start: openPosition + leftTrim,
                    end: position - rightTrim,
                    result: result,
                    components,
                    kind,
                    source: mappedYaml
                });
            }
        } else {
            stack.push({
                position
            });
        }
    }
    load1(yml, {
        listener,
        schema: QuartoJSONSchema
    });
    if (results.length === 0) {
        return {
            start: 0,
            end: 0,
            result: null,
            kind: "null",
            components: [],
            source: mappedYaml
        };
    }
    if (results.length !== 1) {
        throw new Error(`Internal Error - expected a single result, got ${results.length} instead`);
    }
    JSON.stringify(results[0]);
    return results[0];
}
function buildTreeSitterAnnotation(tree, mappedSource3) {
    const errors3 = [];
    const singletonBuild = (node)=>{
        let tag = undefined;
        for (const child of node.children){
            if (child.type === "tag") {
                tag = child;
                continue;
            }
            if (child.type !== "comment") {
                const result = buildNode(child, node.endIndex);
                if (tag) {
                    return annotateTag(result, tag, node);
                } else {
                    return result;
                }
            }
        }
        return annotateEmpty(node.endIndex);
    };
    const buildNode = (node, endIndex)=>{
        if (node === null) {
            return annotateEmpty(endIndex === undefined ? -1 : endIndex);
        }
        if (dispatch[node.type] === undefined) {
            return annotateEmpty(endIndex || node.endIndex || -1);
        }
        return dispatch[node.type](node);
    };
    const annotateError = (start, end, message)=>{
        errors3.push({
            start,
            end,
            message
        });
        return {
            start,
            end,
            result: null,
            kind: "<<ERROR>>",
            components: [],
            source: mappedSource3
        };
    };
    const annotateEmpty = (position)=>{
        return {
            start: position,
            end: position,
            result: null,
            kind: "<<EMPTY>>",
            components: [],
            source: mappedSource3
        };
    };
    const annotate = (node, result, components)=>{
        return {
            start: node.startIndex,
            end: node.endIndex,
            result: result,
            kind: node.type,
            components,
            source: mappedSource3
        };
    };
    const annotateTag = (innerParse, tagNode, outerNode)=>{
        const tagParse = annotate(tagNode, tagNode.text, []);
        const result = annotate(outerNode, {
            tag: tagNode.text,
            value: innerParse.result
        }, [
            tagParse,
            innerParse
        ]);
        return result;
    };
    const buildPair = (node)=>{
        let key, value;
        const children = node.children.filter((n7)=>n7.type !== "comment"
        );
        if (children.length === 3) {
            key = annotate(children[0], children[0].text, []);
            value = buildNode(children[2], node.endIndex);
        } else if (children.length === 2) {
            key = annotate(children[0], children[0].text, []);
            value = annotateEmpty(node.endIndex);
        } else {
            key = annotateEmpty(node.endIndex);
            value = annotateEmpty(node.endIndex);
        }
        return annotate(node, {
            key: key.result,
            value: value.result
        }, [
            key,
            value
        ]);
    };
    const dispatch = {
        "stream": singletonBuild,
        "document": singletonBuild,
        "block_node": singletonBuild,
        "flow_node": singletonBuild,
        "block_scalar": (node)=>{
            if (!node.text.startsWith("|") && !node.text.startsWith(">")) {
                return annotateError(node.startIndex, node.endIndex, "Block scalar must start with either `|` or `>`");
            }
            const joinString = node.text.startsWith("|") ? "\n" : "";
            const ls = lines(node.text);
            let chompChar = "";
            if (ls[0].endsWith("-")) {
                while(ls[ls.length - 1] === ""){
                    ls.pop();
                }
            } else if (ls[1].endsWith("+")) {
                chompChar = "\n";
            } else {
                while(ls[ls.length - 1] === ""){
                    ls.pop();
                }
                chompChar = "\n";
            }
            if (ls.length < 2) {
                return annotateEmpty(node.endIndex);
            }
            const indent = ls[1].length - ls[1].trimStart().length;
            const result = ls.slice(1).map((l)=>l.slice(indent)
            ).join(joinString) + chompChar;
            return annotate(node, result, []);
        },
        "block_sequence": (node)=>{
            const result = [], components = [];
            for(let i49 = 0; i49 < node.childCount; ++i49){
                const child = node.child(i49);
                if (child.type !== "block_sequence_item") {
                    continue;
                }
                const component = buildNode(child, node.endIndex);
                components.push(component);
                result.push(component && component.result);
            }
            return annotate(node, result, components);
        },
        "block_sequence_item": (node)=>{
            if (node.childCount < 2) {
                return annotateEmpty(node.endIndex);
            } else {
                return buildNode(node.child(1), node.endIndex);
            }
        },
        "double_quote_scalar": (node)=>{
            return annotate(node, JSON.parse(node.text), []);
        },
        "single_quote_scalar": (node)=>{
            const str73 = node.text.slice(1, -1);
            const matches = [
                -2,
                ...Array.from(matchAll(str73, /''/g)).map((x)=>x.index
                ),
                str73.length, 
            ];
            const lst = [];
            for(let i50 = 0; i50 < matches.length - 1; ++i50){
                lst.push(str73.substring(matches[i50] + 2, matches[i50 + 1]));
            }
            const result = lst.join("'");
            return annotate(node, result, []);
        },
        "plain_scalar": (node)=>{
            function getV() {
                try {
                    return JSON.parse(node.text);
                } catch (_e) {
                    return node.text;
                }
            }
            const v = getV();
            return annotate(node, v, []);
        },
        "flow_sequence": (node)=>{
            const result = [], components = [];
            for(let i51 = 0; i51 < node.childCount; ++i51){
                const child = node.child(i51);
                if (child.type !== "flow_node") {
                    continue;
                }
                const component = buildNode(child, node.endIndex);
                components.push(component);
                result.push(component.result);
            }
            return annotate(node, result, components);
        },
        "block_mapping": (node)=>{
            const result = {}, components = [];
            for(let i52 = 0; i52 < node.childCount; ++i52){
                const child = node.child(i52);
                let component;
                if (child.type === "ERROR") {
                    result[child.text] = "<<ERROR>>";
                    const key = annotate(child, child.text, []);
                    const value = annotateEmpty(child.endIndex);
                    component = annotate(child, {
                        key: key.result,
                        value: value.result
                    }, [
                        key,
                        value
                    ]);
                } else if (child.type !== "block_mapping_pair") {
                    continue;
                } else {
                    component = buildNode(child, node.endIndex);
                }
                const { key , value  } = component.result;
                result[String(key)] = value;
                components.push(...component.components);
            }
            return annotate(node, result, components);
        },
        "flow_pair": buildPair,
        "flow_mapping": (node)=>{
            const result = {}, components = [];
            for(let i53 = 0; i53 < node.childCount; ++i53){
                const child = node.child(i53);
                if (child.type === "flow_node") {
                    continue;
                }
                if (child.type === "flow_pair") {
                    const component = buildNode(child, node.endIndex);
                    const { key , value  } = component.result;
                    result[String(key)] = value;
                    components.push(...component.components);
                }
            }
            return annotate(node, result, components);
        },
        "block_mapping_pair": buildPair
    };
    const result1 = buildNode(tree.rootNode, tree.rootNode.endIndex);
    if (errors3.length) {
        result1.errors = errors3;
    }
    const parsedSize = tree.rootNode.text.trim().length;
    const codeSize = mappedSource3.value.trim().length;
    const lossage = parsedSize / codeSize;
    if (lossage < 0.95) {
        return null;
    }
    return result1;
}
function locateAnnotation(annotation, position, kind) {
    const originalSource = annotation.source;
    kind = kind || "value";
    for(let i54 = 0; i54 < position.length; ++i54){
        const value = position[i54];
        if (typeof value === "number") {
            const inner = annotation.components[value];
            if (inner === undefined) {
                throw new Error("Internal Error: invalid path for locateAnnotation");
            }
            annotation = inner;
        } else {
            let found = false;
            for(let j = 0; j < annotation.components.length; j += 2){
                if (originalSource.value.substring(annotation.components[j].start, annotation.components[j].end).trim() === value) {
                    if (i54 === position.length - 1) {
                        if (kind === "key") {
                            annotation = annotation.components[j];
                        } else {
                            annotation = annotation.components[j + 1];
                        }
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new Error("Internal Error: invalid path for locateAnnotation");
            }
        }
    }
    return annotation;
}
class ValidationError2 extends Error {
    validationErrors;
    constructor(msg, validationErrors){
        super([
            msg,
            ...validationErrors.map((e)=>tidyverseFormatError(e.niceError)
            )
        ].join("\n\n"));
        Object.setPrototypeOf(this, ValidationError2.prototype);
        this.validationErrors = validationErrors;
    }
}
const isObject2 = (value)=>{
    const type35 = typeof value;
    return value !== null && (type35 === "object" || type35 === "function");
};
async function readAndValidateYamlFromMappedString(mappedYaml, schema63, pruneErrors = true) {
    const result = await withValidator(schema63, async (validator)=>{
        const annotation = await readAnnotatedYamlFromMappedString(mappedYaml);
        if (annotation === null) {
            throw new Error("Parse error in readAnnotatedYamlFromMappedString");
        }
        const validateYaml = !isObject2(annotation.result) || annotation.result["validate-yaml"] !== false;
        const yaml = annotation.result;
        if (validateYaml) {
            const valResult = await validator.validateParse(mappedYaml, annotation, pruneErrors);
            return {
                yaml: yaml,
                yamlValidationErrors: valResult.errors
            };
        } else {
            return {
                yaml: yaml,
                yamlValidationErrors: []
            };
        }
    });
    return result;
}
function setBaseSchemaProperties(yaml, schema64) {
    if (yaml.additionalCompletions) {
        schema64 = completeSchema(schema64, ...yaml.additionalCompletions);
    }
    if (yaml.completions) {
        schema64 = completeSchemaOverwrite(schema64, ...yaml.completions);
    }
    if (yaml.id) {
        schema64 = idSchema(schema64, yaml.id);
    }
    if (yaml.hidden === true) {
        schema64 = completeSchemaOverwrite(schema64);
        schema64 = tagSchema(schema64, {
            "hidden": true
        });
    }
    if (yaml.tags) {
        schema64 = tagSchema(schema64, yaml.tags);
    }
    if (yaml.description) {
        schema64 = tagSchema(schema64, {
            description: yaml.description
        });
        if (typeof yaml.description === "string") {
            schema64 = documentSchema(schema64, yaml.description);
        } else if (typeof yaml.description === "object") {
            schema64 = documentSchema(schema64, yaml.description.short);
        }
    }
    const result = Object.assign({}, schema64);
    if (yaml.errorDescription) {
        result.description = yaml.errorDescription;
    }
    if (yaml.errorMessage) {
        result.errorMessage = yaml.errorMessage;
    }
    return result;
}
function convertFromNull(yaml) {
    return setBaseSchemaProperties(yaml["null"], nullSchema);
}
function convertFromSchema(yaml) {
    const schema65 = convertFromYaml(yaml.schema);
    return setBaseSchemaProperties(yaml, schema65);
}
function convertFromString(yaml) {
    if (yaml["string"].pattern) {
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml["string"], regexSchema(yaml["string"].pattern)));
    } else {
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml["string"], stringSchema));
    }
}
function convertFromPattern(yaml) {
    if (typeof yaml.pattern === "string") {
        return setBaseSchemaProperties(yaml, regexSchema(yaml.pattern));
    } else {
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml.pattern, regexSchema(yaml.pattern.regex)));
    }
}
function convertFromPath(yaml) {
    return setBaseSchemaProperties(yaml["path"], stringSchema);
}
function convertFromNumber(yaml) {
    return setBaseSchemaProperties(yaml["number"], numberSchema);
}
function convertFromBoolean(yaml) {
    return setBaseSchemaProperties(yaml["boolean"], booleanSchema);
}
function convertFromRef(yaml) {
    return setBaseSchemaProperties(yaml, refSchema(yaml.ref, `be ${yaml.ref}`));
}
function convertFromMaybeArrayOf(yaml) {
    const inner = convertFromYaml(yaml.maybeArrayOf);
    const schema66 = tagSchema(anyOfSchema(inner, arraySchema(inner)), {
        "complete-from": [
            "anyOf",
            0
        ]
    });
    return setBaseSchemaProperties(yaml, schema66);
}
function convertFromArrayOf(yaml) {
    if (yaml.arrayOf.schema) {
        const result = arraySchema(convertFromYaml(yaml.arrayOf.schema));
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml.arrayOf, result));
    } else {
        return setBaseSchemaProperties(yaml, arraySchema(convertFromYaml(yaml.arrayOf)));
    }
}
function convertFromAllOf(yaml) {
    if (yaml.allOf.schemas) {
        const inner = yaml.allOf.schemas.map((x)=>convertFromYaml(x)
        );
        const schema67 = allOfSchema(...inner);
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml.allOf, schema67));
    } else {
        const inner = yaml.allOf.map((x)=>convertFromYaml(x)
        );
        const schema68 = allOfSchema(...inner);
        return setBaseSchemaProperties(yaml, schema68);
    }
}
function convertFromAnyOf(yaml) {
    if (yaml.anyOf.schemas) {
        const inner = yaml.anyOf.schemas.map((x)=>convertFromYaml(x)
        );
        const schema69 = anyOfSchema(...inner);
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml.anyOf, schema69));
    } else {
        const inner = yaml.anyOf.map((x)=>convertFromYaml(x)
        );
        const schema70 = anyOfSchema(...inner);
        return setBaseSchemaProperties(yaml, schema70);
    }
}
function convertFromEnum(yaml) {
    const schema71 = yaml["enum"];
    if (schema71.hasOwnProperty("values")) {
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml["enum"], enumSchema(...schema71.values)));
    } else {
        return setBaseSchemaProperties(yaml, enumSchema(...schema71));
    }
}
function convertFromRecord(yaml) {
    if (yaml.record.properties) {
        const schema72 = convertFromObject({
            "object": {
                "properties": yaml.record.properties,
                "closed": true,
                "required": "all"
            }
        });
        return setBaseSchemaProperties(yaml, setBaseSchemaProperties(yaml.record, schema72));
    } else {
        const schema73 = convertFromObject({
            "object": {
                "properties": yaml.record,
                "closed": true,
                "required": "all"
            }
        });
        return setBaseSchemaProperties(yaml, schema73);
    }
}
function convertFromObject(yaml) {
    const schema74 = yaml["object"];
    const params = {};
    if (schema74.namingConvention) {
        switch(schema74.namingConvention){
            case "capitalizationCase":
                params.namingConvention = "capitalizationCase";
                break;
            case "capitalization-case":
                params.namingConvention = "capitalizationCase";
                break;
            case "capitalization_case":
                params.namingConvention = "capitalizationCase";
                break;
            case "underscoreCase":
                params.namingConvention = "underscore_case";
                break;
            case "underscore-case":
                params.namingConvention = "underscore_case";
                break;
            case "underscore_case":
                params.namingConvention = "underscore_case";
                break;
            case "dashCase":
                params.namingConvention = "dash-case";
                break;
            case "dash-case":
                params.namingConvention = "dash-case";
                break;
            case "dash_case":
                params.namingConvention = "dash-case";
                break;
            case "camelCase":
                params.namingConvention = "capitalizationCase";
                break;
            case "camel-case":
                params.namingConvention = "capitalizationCase";
                break;
            case "camel_case":
                params.namingConvention = "capitalizationCase";
                break;
            case "snakeCase":
                params.namingConvention = "underscore_case";
                break;
            case "snake-case":
                params.namingConvention = "underscore_case";
                break;
            case "snake_case":
                params.namingConvention = "underscore_case";
                break;
            case "kebabCase":
                params.namingConvention = "dash-case";
                break;
            case "kebab-case":
                params.namingConvention = "dash-case";
                break;
            case "kebab_case":
                params.namingConvention = "dash-case";
                break;
            default:
                throw new Error("Internal Error: this should have failed validation");
        }
        params.namingConvention = schema74.namingConvention;
    }
    if (schema74.properties) {
        params.properties = fromEntries(Object.entries(schema74.properties).map(([key, value])=>[
                key,
                convertFromYaml(value)
            ]
        ));
    }
    if (schema74.patternProperties) {
        params.patternProperties = fromEntries(Object.entries(schema74.properties).map(([key, value])=>[
                key,
                convertFromYaml(value)
            ]
        ));
    }
    if (schema74.propertyNames !== undefined) {
        params.propertyNames = convertFromYaml(schema74.propertyNames);
    } else if (schema74.closed === true) {
        const objectKeys = Object.keys(params.properties || {});
        if (objectKeys.length === 0) {
            throw new Error("object schema `closed` requires field `properties`.");
        }
        if (params.namingConvention !== undefined && params.namingConvention !== "ignore") {
            throw new Error("object schema `closed` is only supported with namingConvention: `ignore`");
        }
        params.namingConvention = "ignore";
        params.propertyNames = enumSchema(...objectKeys);
    }
    if (schema74.additionalProperties !== undefined) {
        if (schema74.additionalProperties === false) {
            params.additionalProperties = false;
        } else {
            params.additionalProperties = convertFromYaml(schema74.additionalProperties);
        }
    }
    if (schema74["super"]) {
        params.baseSchema = convertFromYaml(schema74["super"]);
    }
    if (schema74["required"] === "all") {
        params.required = Object.keys(schema74.properties || {});
    } else if (schema74["required"]) {
        params.required = schema74["required"];
    }
    if (schema74["completions"]) {
        params.completions = schema74["completions"];
    }
    return setBaseSchemaProperties(yaml, setBaseSchemaProperties(schema74, objectSchema(params)));
}
function lookup(yaml) {
    if (!hasSchemaDefinition(yaml.resolveRef)) {
        throw new Error(`lookup of key ${yaml.resolveRef} in definitions failed`);
    }
    return getSchemaDefinition(yaml.resolveRef);
}
function convertFromYaml(yaml) {
    const literalValues = [
        {
            val: "object",
            schema: objectSchema()
        },
        {
            val: "path",
            schema: stringSchema
        },
        {
            val: "string",
            schema: stringSchema
        },
        {
            val: "number",
            schema: numberSchema
        },
        {
            val: "boolean",
            schema: booleanSchema
        },
        {
            val: null,
            schema: nullSchema
        }, 
    ];
    for (const { val , schema: schema75  } of literalValues){
        if (yaml === val) {
            return schema75;
        }
    }
    if (typeof yaml !== "object") {
        return valueSchema(yaml);
    }
    const schemaObjectKeyFunctions = [
        {
            key: "anyOf",
            value: convertFromAnyOf
        },
        {
            key: "allOf",
            value: convertFromAllOf
        },
        {
            key: "boolean",
            value: convertFromBoolean
        },
        {
            key: "arrayOf",
            value: convertFromArrayOf
        },
        {
            key: "enum",
            value: convertFromEnum
        },
        {
            key: "maybeArrayOf",
            value: convertFromMaybeArrayOf
        },
        {
            key: "null",
            value: convertFromNull
        },
        {
            key: "number",
            value: convertFromNumber
        },
        {
            key: "object",
            value: convertFromObject
        },
        {
            key: "path",
            value: convertFromPath
        },
        {
            key: "record",
            value: convertFromRecord
        },
        {
            key: "ref",
            value: convertFromRef
        },
        {
            key: "resolveRef",
            value: lookup
        },
        {
            key: "string",
            value: convertFromString
        },
        {
            key: "pattern",
            value: convertFromPattern
        },
        {
            key: "schema",
            value: convertFromSchema
        }, 
    ];
    for (const { key: objectKey , value: fun  } of schemaObjectKeyFunctions){
        if (yaml[objectKey] !== undefined) {
            return fun(yaml);
        }
    }
    throw new Error("Internal Error: Cannot convert object; this should have failed validation.");
}
function objectSchemaFromFieldsObject(fields, exclude) {
    exclude = exclude || ((_key)=>false
    );
    const properties = {};
    convertFromFieldsObject(fields, properties);
    for (const key of Object.keys(properties)){
        if (exclude(key)) {
            delete properties[key];
        }
    }
    return objectSchema({
        properties
    });
}
function annotateSchemaFromField(field, schema76) {
    if (field.enabled !== undefined) {
        schema76 = tagSchema(schema76, {
            formats: field.enabled
        });
    }
    if (field.disabled !== undefined) {
        schema76 = tagSchema(schema76, {
            formats: field.disabled.map((x)=>`!${x}`
            )
        });
    }
    if (field.tags) {
        schema76 = tagSchema(schema76, field.tags);
    }
    if (field.description) {
        if (typeof field.description === "string") {
            schema76 = documentSchema(schema76, field.description);
        } else if (typeof field.description === "object") {
            schema76 = documentSchema(schema76, field.description.short);
        }
        schema76 = tagSchema(schema76, {
            description: field.description
        });
    }
    if (field.hidden) {
        schema76 = tagSchema(schema76, {
            "hidden": true
        });
    }
    return schema76;
}
function schemaFromField(entry) {
    const schema77 = convertFromYaml(entry.schema);
    return annotateSchemaFromField(entry, schema77);
}
function convertFromFieldsObject(yaml, obj) {
    const result = obj || {};
    for (const field of yaml){
        let schema78 = convertFromYaml(field.schema);
        schema78 = annotateSchemaFromField(field, schema78);
        result[field.name] = schema78;
        if (field.alias) {
            result[field.alias] = schema78;
        }
    }
    return result;
}
function schemaFieldsFromGlob(globPath, testFun) {
    const result = [];
    testFun = testFun || ((_e, _p)=>true
    );
    for (const [file, fields] of expandResourceGlob(globPath)){
        for (const field of fields){
            const fieldName = field.name;
            const schemaId = `quarto-resource-${file.split("/").slice(-1)[0].slice(0, -4)}-${fieldName}`;
            if (testFun(field, file)) {
                result.push({
                    schemaId,
                    field
                });
            }
        }
    }
    return result;
}
memoize(()=>{
    const groups = getYamlIntelligenceResource("schema/groups.yml");
    const result = [];
    for (const [topLevel, sub] of Object.entries(groups)){
        for (const key of Object.keys(sub)){
            result.push(`${topLevel}-${key}`);
        }
    }
    return result;
}, ()=>"const"
);
function objectRefSchemaFromContextGlob(contextGlob, testFun) {
    const regexp5 = globToRegExp1(contextGlob);
    return objectRefSchemaFromGlob("schema/{document,cell}-*.yml", (field, path47)=>{
        if (testFun !== undefined && !testFun(field, path47)) {
            return false;
        }
        const pathContext = path47.split("/").slice(-1)[0].slice(0, -4);
        const schemaContexts = field !== undefined && field.tags !== undefined && field.tags.contexts || [];
        if (pathContext.match(regexp5)) {
            return true;
        }
        return schemaContexts.some((c)=>c.match(regexp5)
        );
    });
}
function objectRefSchemaFromGlob(glob, testFun) {
    const properties = {};
    for (const { schemaId , field  } of schemaFieldsFromGlob(glob, testFun)){
        const schema79 = refSchema(schemaId, schemaId);
        properties[field.name] = schema79;
        if (field.alias) {
            properties[field.alias] = schema79;
        }
    }
    return objectSchema({
        properties
    });
}
async function buildResourceSchemas() {
    const path48 = "schema/{cell-*,document-*,project}.yml";
    for (const [file, fields] of expandResourceGlob(path48)){
        const yaml = fields;
        const entries = Object.entries(convertFromFieldsObject(yaml));
        for (const [fieldName, fieldSchema] of entries){
            const schemaId = `quarto-resource-${file.split("/").slice(-1)[0].slice(0, -4)}-${fieldName}`;
            const schema80 = idSchema(fieldSchema, schemaId);
            setSchemaDefinition(schema80);
            await withValidator(schema80, async (_validator)=>{});
        }
    }
}
function defineCached(thunk, schemaId) {
    let schema81;
    return async ()=>{
        if (hasSchemaDefinition(schemaId)) {
            schema81 = getSchemaDefinition(schemaId);
            return refSchema(schema81.$id, schema81.description || `be a {schema['$id'] as string}`);
        }
        const result = await thunk();
        const { errorHandlers  } = result;
        schema81 = result.schema;
        if (schemaId !== schema81.$id) {
            schema81 = idSchema(schema81, schemaId);
        }
        define(schema81);
        for (const fun of errorHandlers){
            addValidatorErrorHandler(schema81, fun);
        }
        return refSchema(schema81.$id, schema81.description || `be a {schema['$id']}`);
    };
}
function define(schema82) {
    if (schema82 !== true && schema82 !== false && schema82.$id && !hasSchemaDefinition(schema82.$id)) {
        setSchemaDefinition(schema82);
    }
}
async function loadDefaultSchemaDefinitions() {
    await loadSchemaDefinitions(getYamlIntelligenceResource("schema/definitions.yml"));
    await buildResourceSchemas();
}
async function loadSchemaDefinitions(yaml) {
    await Promise.all(yaml.map(async (yamlSchema)=>{
        const schema83 = convertFromYaml(yamlSchema);
        if (schema83.$id === undefined) {
            throw new Error(`Internal error: unnamed schema in definitions`);
        }
        setSchemaDefinition(schema83);
    }));
}
function getFormatExecuteOptionsSchema() {
    const schema84 = idSchema(objectRefSchemaFromContextGlob("document-execute"), "front-matter-execute");
    define(schema84);
    return refSchema("front-matter-execute", "be a front-matter-execute object");
}
let formatAliases = undefined;
function getFormatAliases() {
    if (formatAliases !== undefined) {
        return formatAliases;
    }
    formatAliases = getYamlIntelligenceResource("schema/format-aliases.yml").aliases;
    return formatAliases;
}
function expandFormatAliases(lst) {
    return expandAliasesFrom(lst, getFormatAliases());
}
function useSchema(schema85, format7) {
    const formats1 = schema85 && schema85.tags && schema85.tags.formats;
    if (formats1 === undefined) {
        return true;
    }
    const disabled = formats1.filter((f)=>f.startsWith("!")
    ).map((f)=>f.slice(1)
    );
    const enabled2 = formats1.filter((f)=>!f.startsWith("!")
    );
    if (disabled.length > 0 && expandFormatAliases(disabled).indexOf(format7) !== -1) {
        return false;
    }
    if (enabled2.length > 0 && expandFormatAliases(enabled2).indexOf(format7) === -1) {
        return false;
    }
    return true;
}
function getFormatSchema(format8) {
    const schema1 = objectRefSchemaFromContextGlob("document-*", (field)=>{
        const schema86 = schemaFromField(field);
        return useSchema(schema86, format8);
    });
    return anyOfSchema(schema1, enumSchema("default"));
}
function pandocFormatsResource() {
    return getYamlIntelligenceResource("pandoc/formats.yml");
}
async function makeFrontMatterFormatSchema(nonStrict = false) {
    const hideFormat = (format9)=>{
        const hideList = [
            "html",
            "epub",
            "docbook"
        ];
        const hidden26 = hideList.some((h)=>format9.startsWith(h) && format9.length > h.length
        );
        return {
            name: format9,
            hidden: hidden26
        };
    };
    const formatSchemaDescriptorList = (await pandocFormatsResource()).concat("hugo").map((format10)=>{
        const { name: name86 , hidden: hidden27 ,  } = hideFormat(format10);
        return {
            regex: `^(.+-)?${name86}([-+].+)?$`,
            schema: getFormatSchema(name86),
            name: name86,
            hidden: hidden27
        };
    });
    const formatSchemas = formatSchemaDescriptorList.map(({ regex , schema: schema87  })=>[
            regex,
            schema87
        ]
    );
    const plusFormatStringSchemas = formatSchemaDescriptorList.map(({ regex , name: name87 , hidden: hidden28  })=>{
        const schema88 = regexSchema(regex, `be '${name87}'`);
        if (hidden28) {
            return schema88;
        }
        return completeSchema(schema88, name87);
    });
    const completionsObject = fromEntries(formatSchemaDescriptorList.filter(({ hidden: hidden29  })=>!hidden29
    ).map(({ name: name88  })=>[
            name88,
            ""
        ]
    ));
    return errorMessageSchema(anyOfSchema(describeSchema(anyOfSchema(...plusFormatStringSchemas), "the name of a pandoc-supported output format"), allOfSchema(objectSchema({
        patternProperties: fromEntries(formatSchemas),
        completions: completionsObject,
        additionalProperties: nonStrict
    }))), "${value} is not a valid output format.");
}
const getFrontMatterFormatSchema = defineCached(async ()=>{
    return {
        schema: await makeFrontMatterFormatSchema(),
        errorHandlers: []
    };
}, "front-matter-format");
defineCached(async ()=>{
    return {
        schema: await makeFrontMatterFormatSchema(true),
        errorHandlers: []
    };
}, "front-matter-format-nonstrict");
const getFrontMatterSchema = defineCached(async ()=>{
    const executeObjSchema = await getFormatExecuteOptionsSchema();
    return {
        schema: anyOfSchema(nullSchema, allOfSchema(objectSchema({
            properties: {
                execute: executeObjSchema,
                format: await getFrontMatterFormatSchema()
            },
            description: "be a Quarto YAML front matter object"
        }), objectRefSchemaFromContextGlob("document-*", (field)=>field.name !== "format"
        ), executeObjSchema)),
        errorHandlers: []
    };
}, "front-matter");
function Diff() {}
Diff.prototype = {
    diff: function diff(oldString, newString) {
        var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        var callback = options.callback;
        if (typeof options === "function") {
            callback = options;
            options = {};
        }
        this.options = options;
        var self = this;
        function done(value) {
            if (callback) {
                setTimeout(function() {
                    callback(void 0, value);
                }, 0);
                return true;
            } else {
                return value;
            }
        }
        oldString = this.castInput(oldString);
        newString = this.castInput(newString);
        oldString = this.removeEmpty(this.tokenize(oldString));
        newString = this.removeEmpty(this.tokenize(newString));
        var newLen = newString.length, oldLen = oldString.length;
        var editLength = 1;
        var maxEditLength = newLen + oldLen;
        var bestPath = [
            {
                newPos: -1,
                components: []
            }
        ];
        var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);
        if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
            return done([
                {
                    value: this.join(newString),
                    count: newString.length
                }
            ]);
        }
        function execEditLength() {
            for(var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2){
                var basePath = void 0;
                var addPath1 = bestPath[diagonalPath - 1], removePath1 = bestPath[diagonalPath + 1], _oldPos = (removePath1 ? removePath1.newPos : 0) - diagonalPath;
                if (addPath1) {
                    bestPath[diagonalPath - 1] = void 0;
                }
                var canAdd = addPath1 && addPath1.newPos + 1 < newLen, canRemove = removePath1 && 0 <= _oldPos && _oldPos < oldLen;
                if (!canAdd && !canRemove) {
                    bestPath[diagonalPath] = void 0;
                    continue;
                }
                if (!canAdd || canRemove && addPath1.newPos < removePath1.newPos) {
                    basePath = clonePath(removePath1);
                    self.pushComponent(basePath.components, void 0, true);
                } else {
                    basePath = addPath1;
                    basePath.newPos++;
                    self.pushComponent(basePath.components, true, void 0);
                }
                _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath);
                if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
                    return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
                } else {
                    bestPath[diagonalPath] = basePath;
                }
            }
            editLength++;
        }
        if (callback) {
            (function exec1() {
                setTimeout(function() {
                    if (editLength > maxEditLength) {
                        return callback();
                    }
                    if (!execEditLength()) {
                        exec1();
                    }
                }, 0);
            })();
        } else {
            while(editLength <= maxEditLength){
                var ret = execEditLength();
                if (ret) {
                    return ret;
                }
            }
        }
    },
    pushComponent: function pushComponent(components, added, removed) {
        var last = components[components.length - 1];
        if (last && last.added === added && last.removed === removed) {
            components[components.length - 1] = {
                count: last.count + 1,
                added,
                removed
            };
        } else {
            components.push({
                count: 1,
                added,
                removed
            });
        }
    },
    extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
        var newLen = newString.length, oldLen = oldString.length, newPos = basePath.newPos, oldPos = newPos - diagonalPath, commonCount = 0;
        while(newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])){
            newPos++;
            oldPos++;
            commonCount++;
        }
        if (commonCount) {
            basePath.components.push({
                count: commonCount
            });
        }
        basePath.newPos = newPos;
        return oldPos;
    },
    equals: function equals(left, right) {
        if (this.options.comparator) {
            return this.options.comparator(left, right);
        } else {
            return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
        }
    },
    removeEmpty: function removeEmpty(array) {
        var ret = [];
        for(var i55 = 0; i55 < array.length; i55++){
            if (array[i55]) {
                ret.push(array[i55]);
            }
        }
        return ret;
    },
    castInput: function castInput(value) {
        return value;
    },
    tokenize: function tokenize(value) {
        return value.split("");
    },
    join: function join(chars) {
        return chars.join("");
    }
};
function buildValues(diff2, components, newString, oldString, useLongestToken) {
    var componentPos = 0, componentLen = components.length, newPos = 0, oldPos = 0;
    for(; componentPos < componentLen; componentPos++){
        var component = components[componentPos];
        if (!component.removed) {
            if (!component.added && useLongestToken) {
                var value = newString.slice(newPos, newPos + component.count);
                value = value.map(function(value2, i56) {
                    var oldValue = oldString[oldPos + i56];
                    return oldValue.length > value2.length ? oldValue : value2;
                });
                component.value = diff2.join(value);
            } else {
                component.value = diff2.join(newString.slice(newPos, newPos + component.count));
            }
            newPos += component.count;
            if (!component.added) {
                oldPos += component.count;
            }
        } else {
            component.value = diff2.join(oldString.slice(oldPos, oldPos + component.count));
            oldPos += component.count;
            if (componentPos && components[componentPos - 1].added) {
                var tmp = components[componentPos - 1];
                components[componentPos - 1] = components[componentPos];
                components[componentPos] = tmp;
            }
        }
    }
    var lastComponent = components[componentLen - 1];
    if (componentLen > 1 && typeof lastComponent.value === "string" && (lastComponent.added || lastComponent.removed) && diff2.equals("", lastComponent.value)) {
        components[componentLen - 2].value += lastComponent.value;
        components.pop();
    }
    return components;
}
function clonePath(path49) {
    return {
        newPos: path49.newPos,
        components: path49.components.slice(0)
    };
}
new Diff();
var extendedWordChars = /^[A-Za-z\xC0-\u02C6\u02C8-\u02D7\u02DE-\u02FF\u1E00-\u1EFF]+$/;
var reWhitespace = /\S/;
var wordDiff = new Diff();
wordDiff.equals = function(left, right) {
    if (this.options.ignoreCase) {
        left = left.toLowerCase();
        right = right.toLowerCase();
    }
    return left === right || this.options.ignoreWhitespace && !reWhitespace.test(left) && !reWhitespace.test(right);
};
wordDiff.tokenize = function(value) {
    var tokens = value.split(/([^\S\r\n]+|[()[\]{}'"\r\n]|\b)/);
    for(var i57 = 0; i57 < tokens.length - 1; i57++){
        if (!tokens[i57 + 1] && tokens[i57 + 2] && extendedWordChars.test(tokens[i57]) && extendedWordChars.test(tokens[i57 + 2])) {
            tokens[i57] += tokens[i57 + 2];
            tokens.splice(i57 + 1, 2);
            i57--;
        }
    }
    return tokens;
};
var lineDiff = new Diff();
lineDiff.tokenize = function(value) {
    var retLines = [], linesAndNewlines = value.split(/(\n|\r\n)/);
    if (!linesAndNewlines[linesAndNewlines.length - 1]) {
        linesAndNewlines.pop();
    }
    for(var i58 = 0; i58 < linesAndNewlines.length; i58++){
        var line = linesAndNewlines[i58];
        if (i58 % 2 && !this.options.newlineIsToken) {
            retLines[retLines.length - 1] += line;
        } else {
            if (this.options.ignoreWhitespace) {
                line = line.trim();
            }
            retLines.push(line);
        }
    }
    return retLines;
};
function diffLines(oldStr, newStr, callback) {
    return lineDiff.diff(oldStr, newStr, callback);
}
var sentenceDiff = new Diff();
sentenceDiff.tokenize = function(value) {
    return value.split(/(\S.+?[.!?])(?=\s+|$)/);
};
var cssDiff = new Diff();
cssDiff.tokenize = function(value) {
    return value.split(/([{}:;,]|\s+)/);
};
function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function(obj2) {
            return typeof obj2;
        };
    } else {
        _typeof = function(obj2) {
            return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        };
    }
    return _typeof(obj);
}
var objectPrototypeToString = Object.prototype.toString;
var jsonDiff = new Diff();
jsonDiff.useLongestToken = true;
jsonDiff.tokenize = lineDiff.tokenize;
jsonDiff.castInput = function(value) {
    var _this$options = this.options, undefinedReplacement = _this$options.undefinedReplacement, _this$options$stringi = _this$options.stringifyReplacer, stringifyReplacer = _this$options$stringi === void 0 ? function(k, v) {
        return typeof v === "undefined" ? undefinedReplacement : v;
    } : _this$options$stringi;
    return typeof value === "string" ? value : JSON.stringify(canonicalize(value, null, null, stringifyReplacer), stringifyReplacer, "  ");
};
jsonDiff.equals = function(left, right) {
    return Diff.prototype.equals.call(jsonDiff, left.replace(/,([\r\n])/g, "$1"), right.replace(/,([\r\n])/g, "$1"));
};
function canonicalize(obj, stack, replacementStack, replacer, key) {
    stack = stack || [];
    replacementStack = replacementStack || [];
    if (replacer) {
        obj = replacer(key, obj);
    }
    var i59;
    for(i59 = 0; i59 < stack.length; i59 += 1){
        if (stack[i59] === obj) {
            return replacementStack[i59];
        }
    }
    var canonicalizedObj;
    if (objectPrototypeToString.call(obj) === "[object Array]") {
        stack.push(obj);
        canonicalizedObj = new Array(obj.length);
        replacementStack.push(canonicalizedObj);
        for(i59 = 0; i59 < obj.length; i59 += 1){
            canonicalizedObj[i59] = canonicalize(obj[i59], stack, replacementStack, replacer, key);
        }
        stack.pop();
        replacementStack.pop();
        return canonicalizedObj;
    }
    if (obj && obj.toJSON) {
        obj = obj.toJSON();
    }
    if (_typeof(obj) === "object" && obj !== null) {
        stack.push(obj);
        canonicalizedObj = {};
        replacementStack.push(canonicalizedObj);
        var sortedKeys = [], _key;
        for(_key in obj){
            if (obj.hasOwnProperty(_key)) {
                sortedKeys.push(_key);
            }
        }
        sortedKeys.sort();
        for(i59 = 0; i59 < sortedKeys.length; i59 += 1){
            _key = sortedKeys[i59];
            canonicalizedObj[_key] = canonicalize(obj[_key], stack, replacementStack, replacer, _key);
        }
        stack.pop();
        replacementStack.pop();
    } else {
        canonicalizedObj = obj;
    }
    return canonicalizedObj;
}
var arrayDiff = new Diff();
arrayDiff.tokenize = function(value) {
    return value.slice();
};
arrayDiff.join = arrayDiff.removeEmpty = function(value) {
    return value;
};
function mappedDiff(source, target) {
    const sourceLineRanges = rangedLines(source.value).map((x)=>x.range
    );
    let sourceCursor = 0;
    const resultChunks = [];
    for (const action of diffLines(source.value, target)){
        if (action.removed) {
            sourceCursor += action.count;
        } else if (action.added) {
            resultChunks.push(action.value);
        } else {
            const start = sourceLineRanges[sourceCursor].start;
            const nextCursor = sourceCursor + action.count;
            const end = nextCursor < sourceLineRanges.length ? sourceLineRanges[nextCursor].start : sourceLineRanges[sourceLineRanges.length - 1].end;
            sourceCursor = nextCursor;
            resultChunks.push({
                start,
                end
            });
        }
    }
    return mappedString(source, resultChunks, source.fileName);
}
function mappedStringFromFile(filename) {
    const value = Deno.readTextFileSync(filename);
    if (filename.startsWith("/")) {
        filename = relative2(Deno.cwd(), filename);
    }
    return asMappedString(value, filename);
}
const kRegExBeginYAML = /^---[ \t]*$/;
const kRegExEndYAML = /^(?:---|\.\.\.)([ \t]*)$/;
const kRegExYAML = /(^)(---[ \t]*[\r\n]+(?![ \t]*[\r\n]+)[\W\w]*?[\r\n]+(?:---|\.\.\.))([ \t]*)$/gm;
const kRegxHTMLComment = /<!--[\W\w]*?-->/gm;
const kRegexFencedCode = /^([\t >]*`{3,})[^`\n]*\n[\W\w]*?\n\1\s*$/gm;
function isYamlPath(file) {
    return [
        ".yaml",
        ".yml"
    ].includes(extname2(file));
}
function readYaml(file) {
    if (existsSync(file)) {
        const decoder = new TextDecoder("utf-8");
        const yml = Deno.readFileSync(file);
        const result = parse3(decoder.decode(yml), {
            schema: QuartoJSONSchema1
        });
        try {
            JSON.stringify(result);
            return result;
        } catch (e) {
            throw new Error(`Circular structures not allowed.\nFile ${file}\n${e.message.split("\n").slice(1).join("\n")}`);
        }
    } else {
        throw new Error(`YAML file ${file} not found.`);
    }
}
function readYamlFromString(yml) {
    return parse3(yml, {
        schema: QuartoJSONSchema1
    });
}
function readYamlFromMarkdown(markdown) {
    if (markdown) {
        markdown = normalizeNewlines(markdown);
        markdown = markdown.replaceAll(kRegxHTMLComment, "");
        markdown = markdown.replaceAll(kRegexFencedCode, "");
        let yaml = "";
        kRegExYAML.lastIndex = 0;
        let match = kRegExYAML.exec(markdown);
        while(match != null){
            let yamlBlock = removeYamlDelimiters(match[2]);
            yamlBlock = lines(yamlBlock).map((x)=>x.trimEnd()
            ).join("\n");
            if (!yamlBlock.match(/^\n\s*\n/m) && !yamlBlock.match(/^\n\s*\n---/m) && yamlBlock.trim().length > 0) {
                parse3(yamlBlock, {
                    json: true,
                    schema: QuartoJSONSchema1
                });
                yaml += yamlBlock;
            }
            match = kRegExYAML.exec(markdown);
        }
        kRegExYAML.lastIndex = 0;
        const metadata = parse3(yaml, {
            json: true,
            schema: QuartoJSONSchema1
        });
        return metadata || {};
    } else {
        return {};
    }
}
function partitionYamlFrontMatter(markdown) {
    const mdLines = lines(markdown.trimLeft());
    if (mdLines.length < 3 || !mdLines[0].match(kRegExBeginYAML)) {
        return null;
    } else if (mdLines[1].trim().length === 0 || mdLines[1].match(kRegExEndYAML)) {
        return null;
    } else {
        const endYamlPos = mdLines.findIndex((line, index)=>index > 0 && line.match(kRegExEndYAML)
        );
        if (endYamlPos === -1) {
            return null;
        } else {
            return {
                yaml: mdLines.slice(0, endYamlPos + 1).join("\n"),
                markdown: "\n" + mdLines.slice(endYamlPos + 1).join("\n")
            };
        }
    }
}
function removeYamlDelimiters(yaml) {
    return yaml.replace(/^---/, "").replace(/---\s*$/, "");
}
class YAMLValidationError extends ErrorEx {
    constructor(message){
        super("YAMLValidationError", message, false, false);
    }
}
const QuartoJSONSchema1 = new Schema({
    implicit: [
        nil,
        bool,
        __int,
        __float
    ],
    include: [
        failsafe
    ],
    explicit: [
        new Type1("!expr", {
            kind: "scalar",
            construct (data55) {
                const result = data55 !== null ? data55 : "";
                return {
                    value: result,
                    tag: "!expr"
                };
            }
        }), 
    ]
});
function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
}
var __VIRTUAL_FILE = listCacheClear;
function eq(value, other) {
    return value === other || value !== value && other !== other;
}
var __VIRTUAL_FILE1 = eq;
function assocIndexOf(array, key) {
    var length = array.length;
    while(length--){
        if (__VIRTUAL_FILE1(array[length][0], key)) {
            return length;
        }
    }
    return -1;
}
var __VIRTUAL_FILE2 = assocIndexOf;
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete(key) {
    var data56 = this.__data__, index = __VIRTUAL_FILE2(data56, key);
    if (index < 0) {
        return false;
    }
    var lastIndex = data56.length - 1;
    if (index == lastIndex) {
        data56.pop();
    } else {
        splice.call(data56, index, 1);
    }
    --this.size;
    return true;
}
var __VIRTUAL_FILE3 = listCacheDelete;
function listCacheGet(key) {
    var data57 = this.__data__, index = __VIRTUAL_FILE2(data57, key);
    return index < 0 ? void 0 : data57[index][1];
}
var __VIRTUAL_FILE4 = listCacheGet;
function listCacheHas(key) {
    return __VIRTUAL_FILE2(this.__data__, key) > -1;
}
var __VIRTUAL_FILE5 = listCacheHas;
function listCacheSet(key, value) {
    var data58 = this.__data__, index = __VIRTUAL_FILE2(data58, key);
    if (index < 0) {
        ++this.size;
        data58.push([
            key,
            value
        ]);
    } else {
        data58[index][1] = value;
    }
    return this;
}
var __VIRTUAL_FILE6 = listCacheSet;
function ListCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
ListCache.prototype.clear = __VIRTUAL_FILE;
ListCache.prototype["delete"] = __VIRTUAL_FILE3;
ListCache.prototype.get = __VIRTUAL_FILE4;
ListCache.prototype.has = __VIRTUAL_FILE5;
ListCache.prototype.set = __VIRTUAL_FILE6;
var __VIRTUAL_FILE7 = ListCache;
function stackClear() {
    this.__data__ = new __VIRTUAL_FILE7();
    this.size = 0;
}
var __VIRTUAL_FILE8 = stackClear;
function stackDelete(key) {
    var data59 = this.__data__, result = data59["delete"](key);
    this.size = data59.size;
    return result;
}
var __VIRTUAL_FILE9 = stackDelete;
function stackGet(key) {
    return this.__data__.get(key);
}
var __VIRTUAL_FILE10 = stackGet;
function stackHas(key) {
    return this.__data__.has(key);
}
var __VIRTUAL_FILE11 = stackHas;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
var __VIRTUAL_FILE12 = freeGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = __VIRTUAL_FILE12 || freeSelf || Function("return this")();
var __VIRTUAL_FILE13 = root;
var Symbol1 = __VIRTUAL_FILE13.Symbol;
var __VIRTUAL_FILE14 = Symbol1;
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
var nativeObjectToString = objectProto.toString;
var symToStringTag = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.toStringTag : void 0;
function getRawTag(value) {
    var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
    try {
        value[symToStringTag] = void 0;
        var unmasked = true;
    } catch (e) {}
    var result = nativeObjectToString.call(value);
    if (unmasked) {
        if (isOwn) {
            value[symToStringTag] = tag;
        } else {
            delete value[symToStringTag];
        }
    }
    return result;
}
var __VIRTUAL_FILE15 = getRawTag;
var objectProto1 = Object.prototype;
var nativeObjectToString1 = objectProto1.toString;
function objectToString(value) {
    return nativeObjectToString1.call(value);
}
var __VIRTUAL_FILE16 = objectToString;
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag1 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.toStringTag : void 0;
function baseGetTag(value) {
    if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag1 && symToStringTag1 in Object(value) ? __VIRTUAL_FILE15(value) : __VIRTUAL_FILE16(value);
}
var __VIRTUAL_FILE17 = baseGetTag;
function isObject3(value) {
    var type36 = typeof value;
    return value != null && (type36 == "object" || type36 == "function");
}
var __VIRTUAL_FILE18 = isObject3;
var asyncTag = "[object AsyncFunction]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
function isFunction(value) {
    if (!__VIRTUAL_FILE18(value)) {
        return false;
    }
    var tag = __VIRTUAL_FILE17(value);
    return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}
var __VIRTUAL_FILE19 = isFunction;
var coreJsData = __VIRTUAL_FILE13["__core-js_shared__"];
var __VIRTUAL_FILE20 = coreJsData;
var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(__VIRTUAL_FILE20 && __VIRTUAL_FILE20.keys && __VIRTUAL_FILE20.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
}();
function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
}
var __VIRTUAL_FILE21 = isMasked;
var funcProto = Function.prototype;
var funcToString = funcProto.toString;
function toSource(func) {
    if (func != null) {
        try {
            return funcToString.call(func);
        } catch (e) {}
        try {
            return func + "";
        } catch (e1) {}
    }
    return "";
}
var __VIRTUAL_FILE22 = toSource;
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto1 = Function.prototype, objectProto2 = Object.prototype;
var funcToString1 = funcProto1.toString;
var hasOwnProperty1 = objectProto2.hasOwnProperty;
var reIsNative = RegExp("^" + funcToString1.call(hasOwnProperty1).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
function baseIsNative(value) {
    if (!__VIRTUAL_FILE18(value) || __VIRTUAL_FILE21(value)) {
        return false;
    }
    var pattern = __VIRTUAL_FILE19(value) ? reIsNative : reIsHostCtor;
    return pattern.test(__VIRTUAL_FILE22(value));
}
var __VIRTUAL_FILE23 = baseIsNative;
function getValue(object, key) {
    return object == null ? void 0 : object[key];
}
var __VIRTUAL_FILE24 = getValue;
function getNative(object, key) {
    var value = __VIRTUAL_FILE24(object, key);
    return __VIRTUAL_FILE23(value) ? value : void 0;
}
var __VIRTUAL_FILE25 = getNative;
var Map1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Map");
var __VIRTUAL_FILE26 = Map1;
var nativeCreate = __VIRTUAL_FILE25(Object, "create");
var __VIRTUAL_FILE27 = nativeCreate;
function hashClear() {
    this.__data__ = __VIRTUAL_FILE27 ? __VIRTUAL_FILE27(null) : {};
    this.size = 0;
}
var __VIRTUAL_FILE28 = hashClear;
function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
}
var __VIRTUAL_FILE29 = hashDelete;
var HASH_UNDEFINED = "__lodash_hash_undefined__";
var objectProto3 = Object.prototype;
var hasOwnProperty2 = objectProto3.hasOwnProperty;
function hashGet(key) {
    var data60 = this.__data__;
    if (__VIRTUAL_FILE27) {
        var result = data60[key];
        return result === HASH_UNDEFINED ? void 0 : result;
    }
    return hasOwnProperty2.call(data60, key) ? data60[key] : void 0;
}
var __VIRTUAL_FILE30 = hashGet;
var objectProto4 = Object.prototype;
var hasOwnProperty3 = objectProto4.hasOwnProperty;
function hashHas(key) {
    var data61 = this.__data__;
    return __VIRTUAL_FILE27 ? data61[key] !== void 0 : hasOwnProperty3.call(data61, key);
}
var __VIRTUAL_FILE31 = hashHas;
var HASH_UNDEFINED1 = "__lodash_hash_undefined__";
function hashSet(key, value) {
    var data62 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data62[key] = __VIRTUAL_FILE27 && value === void 0 ? HASH_UNDEFINED1 : value;
    return this;
}
var __VIRTUAL_FILE32 = hashSet;
function Hash(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
Hash.prototype.clear = __VIRTUAL_FILE28;
Hash.prototype["delete"] = __VIRTUAL_FILE29;
Hash.prototype.get = __VIRTUAL_FILE30;
Hash.prototype.has = __VIRTUAL_FILE31;
Hash.prototype.set = __VIRTUAL_FILE32;
var __VIRTUAL_FILE33 = Hash;
function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
        hash: new __VIRTUAL_FILE33(),
        map: new (__VIRTUAL_FILE26 || __VIRTUAL_FILE7)(),
        string: new __VIRTUAL_FILE33()
    };
}
var __VIRTUAL_FILE34 = mapCacheClear;
function isKeyable(value) {
    var type37 = typeof value;
    return type37 == "string" || type37 == "number" || type37 == "symbol" || type37 == "boolean" ? value !== "__proto__" : value === null;
}
var __VIRTUAL_FILE35 = isKeyable;
function getMapData(map6, key) {
    var data63 = map6.__data__;
    return __VIRTUAL_FILE35(key) ? data63[typeof key == "string" ? "string" : "hash"] : data63.map;
}
var __VIRTUAL_FILE36 = getMapData;
function mapCacheDelete(key) {
    var result = __VIRTUAL_FILE36(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
}
var __VIRTUAL_FILE37 = mapCacheDelete;
function mapCacheGet(key) {
    return __VIRTUAL_FILE36(this, key).get(key);
}
var __VIRTUAL_FILE38 = mapCacheGet;
function mapCacheHas(key) {
    return __VIRTUAL_FILE36(this, key).has(key);
}
var __VIRTUAL_FILE39 = mapCacheHas;
function mapCacheSet(key, value) {
    var data64 = __VIRTUAL_FILE36(this, key), size = data64.size;
    data64.set(key, value);
    this.size += data64.size == size ? 0 : 1;
    return this;
}
var __VIRTUAL_FILE40 = mapCacheSet;
function MapCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
MapCache.prototype.clear = __VIRTUAL_FILE34;
MapCache.prototype["delete"] = __VIRTUAL_FILE37;
MapCache.prototype.get = __VIRTUAL_FILE38;
MapCache.prototype.has = __VIRTUAL_FILE39;
MapCache.prototype.set = __VIRTUAL_FILE40;
var __VIRTUAL_FILE41 = MapCache;
var LARGE_ARRAY_SIZE = 200;
function stackSet(key, value) {
    var data65 = this.__data__;
    if (data65 instanceof __VIRTUAL_FILE7) {
        var pairs2 = data65.__data__;
        if (!__VIRTUAL_FILE26 || pairs2.length < LARGE_ARRAY_SIZE - 1) {
            pairs2.push([
                key,
                value
            ]);
            this.size = ++data65.size;
            return this;
        }
        data65 = this.__data__ = new __VIRTUAL_FILE41(pairs2);
    }
    data65.set(key, value);
    this.size = data65.size;
    return this;
}
var __VIRTUAL_FILE42 = stackSet;
function Stack(entries) {
    var data66 = this.__data__ = new __VIRTUAL_FILE7(entries);
    this.size = data66.size;
}
Stack.prototype.clear = __VIRTUAL_FILE8;
Stack.prototype["delete"] = __VIRTUAL_FILE9;
Stack.prototype.get = __VIRTUAL_FILE10;
Stack.prototype.has = __VIRTUAL_FILE11;
Stack.prototype.set = __VIRTUAL_FILE42;
var __VIRTUAL_FILE43 = Stack;
function arrayEach(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (iteratee(array[index], index, array) === false) {
            break;
        }
    }
    return array;
}
var __VIRTUAL_FILE44 = arrayEach;
var defineProperty = function() {
    try {
        var func = __VIRTUAL_FILE25(Object, "defineProperty");
        func({}, "", {});
        return func;
    } catch (e) {}
}();
var __VIRTUAL_FILE45 = defineProperty;
function baseAssignValue(object, key, value) {
    if (key == "__proto__" && __VIRTUAL_FILE45) {
        __VIRTUAL_FILE45(object, key, {
            configurable: true,
            enumerable: true,
            value,
            writable: true
        });
    } else {
        object[key] = value;
    }
}
var __VIRTUAL_FILE46 = baseAssignValue;
var objectProto5 = Object.prototype;
var hasOwnProperty4 = objectProto5.hasOwnProperty;
function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty4.call(object, key) && __VIRTUAL_FILE1(objValue, value)) || value === void 0 && !(key in object)) {
        __VIRTUAL_FILE46(object, key, value);
    }
}
var __VIRTUAL_FILE47 = assignValue;
function copyObject(source, props, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index = -1, length = props.length;
    while(++index < length){
        var key = props[index];
        var newValue = customizer ? customizer(object[key], source[key], key, object, source) : void 0;
        if (newValue === void 0) {
            newValue = source[key];
        }
        if (isNew) {
            __VIRTUAL_FILE46(object, key, newValue);
        } else {
            __VIRTUAL_FILE47(object, key, newValue);
        }
    }
    return object;
}
var __VIRTUAL_FILE48 = copyObject;
function baseTimes(n8, iteratee) {
    var index = -1, result = Array(n8);
    while(++index < n8){
        result[index] = iteratee(index);
    }
    return result;
}
var __VIRTUAL_FILE49 = baseTimes;
function isObjectLike(value) {
    return value != null && typeof value == "object";
}
var __VIRTUAL_FILE50 = isObjectLike;
var argsTag = "[object Arguments]";
function baseIsArguments(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE17(value) == argsTag;
}
var __VIRTUAL_FILE51 = baseIsArguments;
var objectProto6 = Object.prototype;
var hasOwnProperty5 = objectProto6.hasOwnProperty;
var propertyIsEnumerable = objectProto6.propertyIsEnumerable;
var isArguments = __VIRTUAL_FILE51(function() {
    return arguments;
}()) ? __VIRTUAL_FILE51 : function(value) {
    return __VIRTUAL_FILE50(value) && hasOwnProperty5.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
};
var __VIRTUAL_FILE52 = isArguments;
var isArray = Array.isArray;
var __VIRTUAL_FILE53 = isArray;
function stubFalse() {
    return false;
}
var __VIRTUAL_FILE54 = stubFalse;
function createCommonjsModule(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE55 = createCommonjsModule(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? __VIRTUAL_FILE13.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer = nativeIsBuffer || __VIRTUAL_FILE54;
    module.exports = isBuffer;
});
var MAX_SAFE_INTEGER = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex(value, length) {
    var type38 = typeof value;
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (type38 == "number" || type38 != "symbol" && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
}
var __VIRTUAL_FILE56 = isIndex;
var MAX_SAFE_INTEGER1 = 9007199254740991;
function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER1;
}
var __VIRTUAL_FILE57 = isLength;
var argsTag1 = "[object Arguments]", arrayTag = "[object Array]", boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", funcTag1 = "[object Function]", mapTag = "[object Map]", numberTag = "[object Number]", objectTag = "[object Object]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", weakMapTag = "[object WeakMap]";
var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag1] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag1] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
function baseIsTypedArray(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE57(value.length) && !!typedArrayTags[__VIRTUAL_FILE17(value)];
}
var __VIRTUAL_FILE58 = baseIsTypedArray;
function baseUnary(func) {
    return function(value) {
        return func(value);
    };
}
var __VIRTUAL_FILE59 = baseUnary;
function createCommonjsModule1(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE60 = createCommonjsModule1(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && __VIRTUAL_FILE12.process;
    var nodeUtil = function() {
        try {
            var types10 = freeModule && freeModule.require && freeModule.require("util").types;
            if (types10) {
                return types10;
            }
            return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e) {}
    }();
    module.exports = nodeUtil;
});
var nodeIsTypedArray = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isTypedArray;
var isTypedArray = nodeIsTypedArray ? __VIRTUAL_FILE59(nodeIsTypedArray) : __VIRTUAL_FILE58;
var __VIRTUAL_FILE61 = isTypedArray;
var objectProto7 = Object.prototype;
var hasOwnProperty6 = objectProto7.hasOwnProperty;
function arrayLikeKeys(value, inherited) {
    var isArr = __VIRTUAL_FILE53(value), isArg = !isArr && __VIRTUAL_FILE52(value), isBuff = !isArr && !isArg && __VIRTUAL_FILE55(value), isType = !isArr && !isArg && !isBuff && __VIRTUAL_FILE61(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? __VIRTUAL_FILE49(value.length, String) : [], length = result.length;
    for(var key in value){
        if ((inherited || hasOwnProperty6.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || __VIRTUAL_FILE56(key, length)))) {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE62 = arrayLikeKeys;
var objectProto8 = Object.prototype;
function isPrototype(value) {
    var Ctor = value && value.constructor, proto1 = typeof Ctor == "function" && Ctor.prototype || objectProto8;
    return value === proto1;
}
var __VIRTUAL_FILE63 = isPrototype;
function overArg(func, transform) {
    return function(arg) {
        return func(transform(arg));
    };
}
var __VIRTUAL_FILE64 = overArg;
var nativeKeys = __VIRTUAL_FILE64(Object.keys, Object);
var __VIRTUAL_FILE65 = nativeKeys;
var objectProto9 = Object.prototype;
var hasOwnProperty7 = objectProto9.hasOwnProperty;
function baseKeys(object) {
    if (!__VIRTUAL_FILE63(object)) {
        return __VIRTUAL_FILE65(object);
    }
    var result = [];
    for(var key in Object(object)){
        if (hasOwnProperty7.call(object, key) && key != "constructor") {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE66 = baseKeys;
function isArrayLike(value) {
    return value != null && __VIRTUAL_FILE57(value.length) && !__VIRTUAL_FILE19(value);
}
var __VIRTUAL_FILE67 = isArrayLike;
function keys(object) {
    return __VIRTUAL_FILE67(object) ? __VIRTUAL_FILE62(object) : __VIRTUAL_FILE66(object);
}
var __VIRTUAL_FILE68 = keys;
function baseAssign(object, source) {
    return object && __VIRTUAL_FILE48(source, __VIRTUAL_FILE68(source), object);
}
var __VIRTUAL_FILE69 = baseAssign;
function nativeKeysIn(object) {
    var result = [];
    if (object != null) {
        for(var key in Object(object)){
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE70 = nativeKeysIn;
var objectProto10 = Object.prototype;
var hasOwnProperty8 = objectProto10.hasOwnProperty;
function baseKeysIn(object) {
    if (!__VIRTUAL_FILE18(object)) {
        return __VIRTUAL_FILE70(object);
    }
    var isProto = __VIRTUAL_FILE63(object), result = [];
    for(var key in object){
        if (!(key == "constructor" && (isProto || !hasOwnProperty8.call(object, key)))) {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE71 = baseKeysIn;
function keysIn(object) {
    return __VIRTUAL_FILE67(object) ? __VIRTUAL_FILE62(object, true) : __VIRTUAL_FILE71(object);
}
var __VIRTUAL_FILE72 = keysIn;
function baseAssignIn(object, source) {
    return object && __VIRTUAL_FILE48(source, __VIRTUAL_FILE72(source), object);
}
var __VIRTUAL_FILE73 = baseAssignIn;
function createCommonjsModule2(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE74 = createCommonjsModule2(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer3 = moduleExports ? __VIRTUAL_FILE13.Buffer : void 0, allocUnsafe = Buffer3 ? Buffer3.allocUnsafe : void 0;
    function cloneBuffer(buffer, isDeep) {
        if (isDeep) {
            return buffer.slice();
        }
        var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
        buffer.copy(result);
        return result;
    }
    module.exports = cloneBuffer;
});
function copyArray(source, array) {
    var index = -1, length = source.length;
    array || (array = Array(length));
    while(++index < length){
        array[index] = source[index];
    }
    return array;
}
var __VIRTUAL_FILE75 = copyArray;
function arrayFilter(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
    while(++index < length){
        var value = array[index];
        if (predicate(value, index, array)) {
            result[resIndex++] = value;
        }
    }
    return result;
}
var __VIRTUAL_FILE76 = arrayFilter;
function stubArray() {
    return [];
}
var __VIRTUAL_FILE77 = stubArray;
var objectProto11 = Object.prototype;
var propertyIsEnumerable1 = objectProto11.propertyIsEnumerable;
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbols = !nativeGetSymbols ? __VIRTUAL_FILE77 : function(object) {
    if (object == null) {
        return [];
    }
    object = Object(object);
    return __VIRTUAL_FILE76(nativeGetSymbols(object), function(symbol) {
        return propertyIsEnumerable1.call(object, symbol);
    });
};
var __VIRTUAL_FILE78 = getSymbols;
function copySymbols(source, object) {
    return __VIRTUAL_FILE48(source, __VIRTUAL_FILE78(source), object);
}
var __VIRTUAL_FILE79 = copySymbols;
function arrayPush(array, values9) {
    var index = -1, length = values9.length, offset = array.length;
    while(++index < length){
        array[offset + index] = values9[index];
    }
    return array;
}
var __VIRTUAL_FILE80 = arrayPush;
var getPrototype = __VIRTUAL_FILE64(Object.getPrototypeOf, Object);
var __VIRTUAL_FILE81 = getPrototype;
var nativeGetSymbols1 = Object.getOwnPropertySymbols;
var getSymbolsIn = !nativeGetSymbols1 ? __VIRTUAL_FILE77 : function(object) {
    var result = [];
    while(object){
        __VIRTUAL_FILE80(result, __VIRTUAL_FILE78(object));
        object = __VIRTUAL_FILE81(object);
    }
    return result;
};
var __VIRTUAL_FILE82 = getSymbolsIn;
function copySymbolsIn(source, object) {
    return __VIRTUAL_FILE48(source, __VIRTUAL_FILE82(source), object);
}
var __VIRTUAL_FILE83 = copySymbolsIn;
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return __VIRTUAL_FILE53(object) ? result : __VIRTUAL_FILE80(result, symbolsFunc(object));
}
var __VIRTUAL_FILE84 = baseGetAllKeys;
function getAllKeys(object) {
    return __VIRTUAL_FILE84(object, __VIRTUAL_FILE68, __VIRTUAL_FILE78);
}
var __VIRTUAL_FILE85 = getAllKeys;
function getAllKeysIn(object) {
    return __VIRTUAL_FILE84(object, __VIRTUAL_FILE72, __VIRTUAL_FILE82);
}
var __VIRTUAL_FILE86 = getAllKeysIn;
var DataView1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "DataView");
var __VIRTUAL_FILE87 = DataView1;
var Promise1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Promise");
var __VIRTUAL_FILE88 = Promise1;
var Set1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Set");
var __VIRTUAL_FILE89 = Set1;
var WeakMap1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "WeakMap");
var __VIRTUAL_FILE90 = WeakMap1;
var mapTag1 = "[object Map]", objectTag1 = "[object Object]", promiseTag = "[object Promise]", setTag1 = "[object Set]", weakMapTag1 = "[object WeakMap]";
var dataViewTag1 = "[object DataView]";
var dataViewCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE87), mapCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE26), promiseCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE88), setCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE89), weakMapCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE90);
var getTag = __VIRTUAL_FILE17;
if (__VIRTUAL_FILE87 && getTag(new __VIRTUAL_FILE87(new ArrayBuffer(1))) != dataViewTag1 || __VIRTUAL_FILE26 && getTag(new __VIRTUAL_FILE26()) != mapTag1 || __VIRTUAL_FILE88 && getTag(__VIRTUAL_FILE88.resolve()) != promiseTag || __VIRTUAL_FILE89 && getTag(new __VIRTUAL_FILE89()) != setTag1 || __VIRTUAL_FILE90 && getTag(new __VIRTUAL_FILE90()) != weakMapTag1) {
    getTag = function(value) {
        var result = __VIRTUAL_FILE17(value), Ctor = result == objectTag1 ? value.constructor : void 0, ctorString = Ctor ? __VIRTUAL_FILE22(Ctor) : "";
        if (ctorString) {
            switch(ctorString){
                case dataViewCtorString:
                    return dataViewTag1;
                case mapCtorString:
                    return mapTag1;
                case promiseCtorString:
                    return promiseTag;
                case setCtorString:
                    return setTag1;
                case weakMapCtorString:
                    return weakMapTag1;
            }
        }
        return result;
    };
}
var __VIRTUAL_FILE91 = getTag;
var objectProto12 = Object.prototype;
var hasOwnProperty9 = objectProto12.hasOwnProperty;
function initCloneArray(array) {
    var length = array.length, result = new array.constructor(length);
    if (length && typeof array[0] == "string" && hasOwnProperty9.call(array, "index")) {
        result.index = array.index;
        result.input = array.input;
    }
    return result;
}
var __VIRTUAL_FILE92 = initCloneArray;
var Uint8Array1 = __VIRTUAL_FILE13.Uint8Array;
var __VIRTUAL_FILE93 = Uint8Array1;
function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new __VIRTUAL_FILE93(result).set(new __VIRTUAL_FILE93(arrayBuffer));
    return result;
}
var __VIRTUAL_FILE94 = cloneArrayBuffer;
function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? __VIRTUAL_FILE94(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
var __VIRTUAL_FILE95 = cloneDataView;
var reFlags = /\w*$/;
function cloneRegExp(regexp6) {
    var result = new regexp6.constructor(regexp6.source, reFlags.exec(regexp6));
    result.lastIndex = regexp6.lastIndex;
    return result;
}
var __VIRTUAL_FILE96 = cloneRegExp;
var symbolProto = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
function cloneSymbol(symbol) {
    return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}
var __VIRTUAL_FILE97 = cloneSymbol;
function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? __VIRTUAL_FILE94(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
var __VIRTUAL_FILE98 = cloneTypedArray;
var boolTag1 = "[object Boolean]", dateTag1 = "[object Date]", mapTag2 = "[object Map]", numberTag1 = "[object Number]", regexpTag1 = "[object RegExp]", setTag2 = "[object Set]", stringTag1 = "[object String]", symbolTag = "[object Symbol]";
var arrayBufferTag1 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag1 = "[object Float32Array]", float64Tag1 = "[object Float64Array]", int8Tag1 = "[object Int8Array]", int16Tag1 = "[object Int16Array]", int32Tag1 = "[object Int32Array]", uint8Tag1 = "[object Uint8Array]", uint8ClampedTag1 = "[object Uint8ClampedArray]", uint16Tag1 = "[object Uint16Array]", uint32Tag1 = "[object Uint32Array]";
function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch(tag){
        case arrayBufferTag1:
            return __VIRTUAL_FILE94(object);
        case boolTag1:
        case dateTag1:
            return new Ctor(+object);
        case dataViewTag2:
            return __VIRTUAL_FILE95(object, isDeep);
        case float32Tag1:
        case float64Tag1:
        case int8Tag1:
        case int16Tag1:
        case int32Tag1:
        case uint8Tag1:
        case uint8ClampedTag1:
        case uint16Tag1:
        case uint32Tag1:
            return __VIRTUAL_FILE98(object, isDeep);
        case mapTag2:
            return new Ctor();
        case numberTag1:
        case stringTag1:
            return new Ctor(object);
        case regexpTag1:
            return __VIRTUAL_FILE96(object);
        case setTag2:
            return new Ctor();
        case symbolTag:
            return __VIRTUAL_FILE97(object);
    }
}
var __VIRTUAL_FILE99 = initCloneByTag;
var objectCreate = Object.create;
var baseCreate = function() {
    function object() {}
    return function(proto2) {
        if (!__VIRTUAL_FILE18(proto2)) {
            return {};
        }
        if (objectCreate) {
            return objectCreate(proto2);
        }
        object.prototype = proto2;
        var result = new object();
        object.prototype = void 0;
        return result;
    };
}();
var __VIRTUAL_FILE100 = baseCreate;
function initCloneObject(object) {
    return typeof object.constructor == "function" && !__VIRTUAL_FILE63(object) ? __VIRTUAL_FILE100(__VIRTUAL_FILE81(object)) : {};
}
var __VIRTUAL_FILE101 = initCloneObject;
var mapTag3 = "[object Map]";
function baseIsMap(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE91(value) == mapTag3;
}
var __VIRTUAL_FILE102 = baseIsMap;
var nodeIsMap = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isMap;
var isMap = nodeIsMap ? __VIRTUAL_FILE59(nodeIsMap) : __VIRTUAL_FILE102;
var __VIRTUAL_FILE103 = isMap;
var setTag3 = "[object Set]";
function baseIsSet(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE91(value) == setTag3;
}
var __VIRTUAL_FILE104 = baseIsSet;
var nodeIsSet = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isSet;
var isSet = nodeIsSet ? __VIRTUAL_FILE59(nodeIsSet) : __VIRTUAL_FILE104;
var __VIRTUAL_FILE105 = isSet;
var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
var argsTag2 = "[object Arguments]", arrayTag1 = "[object Array]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", errorTag1 = "[object Error]", funcTag2 = "[object Function]", genTag1 = "[object GeneratorFunction]", mapTag4 = "[object Map]", numberTag2 = "[object Number]", objectTag2 = "[object Object]", regexpTag2 = "[object RegExp]", setTag4 = "[object Set]", stringTag2 = "[object String]", symbolTag1 = "[object Symbol]", weakMapTag2 = "[object WeakMap]";
var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag3 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
var cloneableTags = {};
cloneableTags[argsTag2] = cloneableTags[arrayTag1] = cloneableTags[arrayBufferTag2] = cloneableTags[dataViewTag3] = cloneableTags[boolTag2] = cloneableTags[dateTag2] = cloneableTags[float32Tag2] = cloneableTags[float64Tag2] = cloneableTags[int8Tag2] = cloneableTags[int16Tag2] = cloneableTags[int32Tag2] = cloneableTags[mapTag4] = cloneableTags[numberTag2] = cloneableTags[objectTag2] = cloneableTags[regexpTag2] = cloneableTags[setTag4] = cloneableTags[stringTag2] = cloneableTags[symbolTag1] = cloneableTags[uint8Tag2] = cloneableTags[uint8ClampedTag2] = cloneableTags[uint16Tag2] = cloneableTags[uint32Tag2] = true;
cloneableTags[errorTag1] = cloneableTags[funcTag2] = cloneableTags[weakMapTag2] = false;
function baseClone(value, bitmask, customizer, key, object, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
    if (customizer) {
        result = object ? customizer(value, key, object, stack) : customizer(value);
    }
    if (result !== void 0) {
        return result;
    }
    if (!__VIRTUAL_FILE18(value)) {
        return value;
    }
    var isArr = __VIRTUAL_FILE53(value);
    if (isArr) {
        result = __VIRTUAL_FILE92(value);
        if (!isDeep) {
            return __VIRTUAL_FILE75(value, result);
        }
    } else {
        var tag = __VIRTUAL_FILE91(value), isFunc = tag == funcTag2 || tag == genTag1;
        if (__VIRTUAL_FILE55(value)) {
            return __VIRTUAL_FILE74(value, isDeep);
        }
        if (tag == objectTag2 || tag == argsTag2 || isFunc && !object) {
            result = isFlat || isFunc ? {} : __VIRTUAL_FILE101(value);
            if (!isDeep) {
                return isFlat ? __VIRTUAL_FILE83(value, __VIRTUAL_FILE73(result, value)) : __VIRTUAL_FILE79(value, __VIRTUAL_FILE69(result, value));
            }
        } else {
            if (!cloneableTags[tag]) {
                return object ? value : {};
            }
            result = __VIRTUAL_FILE99(value, tag, isDeep);
        }
    }
    stack || (stack = new __VIRTUAL_FILE43());
    var stacked = stack.get(value);
    if (stacked) {
        return stacked;
    }
    stack.set(value, result);
    if (__VIRTUAL_FILE105(value)) {
        value.forEach(function(subValue) {
            result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
        });
    } else if (__VIRTUAL_FILE103(value)) {
        value.forEach(function(subValue, key2) {
            result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
        });
    }
    var keysFunc = isFull ? isFlat ? __VIRTUAL_FILE86 : __VIRTUAL_FILE85 : isFlat ? __VIRTUAL_FILE72 : __VIRTUAL_FILE68;
    var props = isArr ? void 0 : keysFunc(value);
    __VIRTUAL_FILE44(props || value, function(subValue, key2) {
        if (props) {
            key2 = subValue;
            subValue = value[key2];
        }
        __VIRTUAL_FILE47(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
}
var __VIRTUAL_FILE106 = baseClone;
var CLONE_DEEP_FLAG1 = 1, CLONE_SYMBOLS_FLAG1 = 4;
function cloneDeep(value) {
    return __VIRTUAL_FILE106(value, CLONE_DEEP_FLAG1 | CLONE_SYMBOLS_FLAG1);
}
var __VIRTUAL_FILE107 = cloneDeep;
var now = function() {
    return __VIRTUAL_FILE13.Date.now();
};
var __VIRTUAL_FILE108 = now;
var reWhitespace1 = /\s/;
function trimmedEndIndex(string26) {
    var index = string26.length;
    while(index-- && reWhitespace1.test(string26.charAt(index))){}
    return index;
}
var __VIRTUAL_FILE109 = trimmedEndIndex;
var reTrimStart = /^\s+/;
function baseTrim(string27) {
    return string27 ? string27.slice(0, __VIRTUAL_FILE109(string27) + 1).replace(reTrimStart, "") : string27;
}
var __VIRTUAL_FILE110 = baseTrim;
var symbolTag2 = "[object Symbol]";
function isSymbol(value) {
    return typeof value == "symbol" || __VIRTUAL_FILE50(value) && __VIRTUAL_FILE17(value) == symbolTag2;
}
var __VIRTUAL_FILE111 = isSymbol;
var NAN = 0 / 0;
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary = /^0b[01]+$/i;
var reIsOctal = /^0o[0-7]+$/i;
var freeParseInt = parseInt;
function toNumber(value) {
    if (typeof value == "number") {
        return value;
    }
    if (__VIRTUAL_FILE111(value)) {
        return NAN;
    }
    if (__VIRTUAL_FILE18(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = __VIRTUAL_FILE18(other) ? other + "" : other;
    }
    if (typeof value != "string") {
        return value === 0 ? value : +value;
    }
    value = __VIRTUAL_FILE110(value);
    var isBinary2 = reIsBinary.test(value);
    return isBinary2 || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary2 ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
var __VIRTUAL_FILE112 = toNumber;
var FUNC_ERROR_TEXT = "Expected a function";
var nativeMax = Math.max, nativeMin = Math.min;
function debounce(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
    }
    wait = __VIRTUAL_FILE112(wait) || 0;
    if (__VIRTUAL_FILE18(options)) {
        leading = !!options.leading;
        maxing = "maxWait" in options;
        maxWait = maxing ? nativeMax(__VIRTUAL_FILE112(options.maxWait) || 0, wait) : maxWait;
        trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
        var args = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = void 0;
        lastInvokeTime = time;
        result = func.apply(thisArg, args);
        return result;
    }
    function leadingEdge(time) {
        lastInvokeTime = time;
        timerId = setTimeout(timerExpired, wait);
        return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
        return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
        return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
        var time = __VIRTUAL_FILE108();
        if (shouldInvoke(time)) {
            return trailingEdge(time);
        }
        timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
        timerId = void 0;
        if (trailing && lastArgs) {
            return invokeFunc(time);
        }
        lastArgs = lastThis = void 0;
        return result;
    }
    function cancel() {
        if (timerId !== void 0) {
            clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = void 0;
    }
    function flush() {
        return timerId === void 0 ? result : trailingEdge(__VIRTUAL_FILE108());
    }
    function debounced() {
        var time = __VIRTUAL_FILE108(), isInvoking = shouldInvoke(time);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time;
        if (isInvoking) {
            if (timerId === void 0) {
                return leadingEdge(lastCallTime);
            }
            if (maxing) {
                clearTimeout(timerId);
                timerId = setTimeout(timerExpired, wait);
                return invokeFunc(lastCallTime);
            }
        }
        if (timerId === void 0) {
            timerId = setTimeout(timerExpired, wait);
        }
        return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
}
var __VIRTUAL_FILE113 = debounce;
var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED2);
    return this;
}
var __VIRTUAL_FILE114 = setCacheAdd;
function setCacheHas(value) {
    return this.__data__.has(value);
}
var __VIRTUAL_FILE115 = setCacheHas;
function SetCache(values10) {
    var index = -1, length = values10 == null ? 0 : values10.length;
    this.__data__ = new __VIRTUAL_FILE41();
    while(++index < length){
        this.add(values10[index]);
    }
}
SetCache.prototype.add = SetCache.prototype.push = __VIRTUAL_FILE114;
SetCache.prototype.has = __VIRTUAL_FILE115;
var __VIRTUAL_FILE116 = SetCache;
function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
    while(fromRight ? index-- : ++index < length){
        if (predicate(array[index], index, array)) {
            return index;
        }
    }
    return -1;
}
var __VIRTUAL_FILE117 = baseFindIndex;
function baseIsNaN(value) {
    return value !== value;
}
var __VIRTUAL_FILE118 = baseIsNaN;
function strictIndexOf(array, value, fromIndex) {
    var index = fromIndex - 1, length = array.length;
    while(++index < length){
        if (array[index] === value) {
            return index;
        }
    }
    return -1;
}
var __VIRTUAL_FILE119 = strictIndexOf;
function baseIndexOf(array, value, fromIndex) {
    return value === value ? __VIRTUAL_FILE119(array, value, fromIndex) : __VIRTUAL_FILE117(array, __VIRTUAL_FILE118, fromIndex);
}
var __VIRTUAL_FILE120 = baseIndexOf;
function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && __VIRTUAL_FILE120(array, value, 0) > -1;
}
var __VIRTUAL_FILE121 = arrayIncludes;
function arrayIncludesWith(array, value, comparator) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (comparator(value, array[index])) {
            return true;
        }
    }
    return false;
}
var __VIRTUAL_FILE122 = arrayIncludesWith;
function arrayMap(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length, result = Array(length);
    while(++index < length){
        result[index] = iteratee(array[index], index, array);
    }
    return result;
}
var __VIRTUAL_FILE123 = arrayMap;
function cacheHas(cache, key) {
    return cache.has(key);
}
var __VIRTUAL_FILE124 = cacheHas;
var LARGE_ARRAY_SIZE1 = 200;
function baseDifference(array, values11, iteratee, comparator) {
    var index = -1, includes = __VIRTUAL_FILE121, isCommon = true, length = array.length, result = [], valuesLength = values11.length;
    if (!length) {
        return result;
    }
    if (iteratee) {
        values11 = __VIRTUAL_FILE123(values11, __VIRTUAL_FILE59(iteratee));
    }
    if (comparator) {
        includes = __VIRTUAL_FILE122;
        isCommon = false;
    } else if (values11.length >= LARGE_ARRAY_SIZE1) {
        includes = __VIRTUAL_FILE124;
        isCommon = false;
        values11 = new __VIRTUAL_FILE116(values11);
    }
    outer: while(++index < length){
        var value = array[index], computed = iteratee == null ? value : iteratee(value);
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
            var valuesIndex = valuesLength;
            while(valuesIndex--){
                if (values11[valuesIndex] === computed) {
                    continue outer;
                }
            }
            result.push(value);
        } else if (!includes(values11, computed, comparator)) {
            result.push(value);
        }
    }
    return result;
}
var __VIRTUAL_FILE125 = baseDifference;
var spreadableSymbol = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.isConcatSpreadable : void 0;
function isFlattenable(value) {
    return __VIRTUAL_FILE53(value) || __VIRTUAL_FILE52(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
}
var __VIRTUAL_FILE126 = isFlattenable;
function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1, length = array.length;
    predicate || (predicate = __VIRTUAL_FILE126);
    result || (result = []);
    while(++index < length){
        var value = array[index];
        if (depth > 0 && predicate(value)) {
            if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result);
            } else {
                __VIRTUAL_FILE80(result, value);
            }
        } else if (!isStrict) {
            result[result.length] = value;
        }
    }
    return result;
}
var __VIRTUAL_FILE127 = baseFlatten;
function identity(value) {
    return value;
}
var __VIRTUAL_FILE128 = identity;
function apply(func, thisArg, args) {
    switch(args.length){
        case 0:
            return func.call(thisArg);
        case 1:
            return func.call(thisArg, args[0]);
        case 2:
            return func.call(thisArg, args[0], args[1]);
        case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
}
var __VIRTUAL_FILE129 = apply;
var nativeMax1 = Math.max;
function overRest(func, start, transform) {
    start = nativeMax1(start === void 0 ? func.length - 1 : start, 0);
    return function() {
        var args = arguments, index = -1, length = nativeMax1(args.length - start, 0), array = Array(length);
        while(++index < length){
            array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while(++index < start){
            otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return __VIRTUAL_FILE129(func, this, otherArgs);
    };
}
var __VIRTUAL_FILE130 = overRest;
function constant(value) {
    return function() {
        return value;
    };
}
var __VIRTUAL_FILE131 = constant;
var baseSetToString = !__VIRTUAL_FILE45 ? __VIRTUAL_FILE128 : function(func, string28) {
    return __VIRTUAL_FILE45(func, "toString", {
        configurable: true,
        enumerable: false,
        value: __VIRTUAL_FILE131(string28),
        writable: true
    });
};
var __VIRTUAL_FILE132 = baseSetToString;
var HOT_COUNT = 800, HOT_SPAN = 16;
var nativeNow = Date.now;
function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
        var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
            if (++count >= HOT_COUNT) {
                return arguments[0];
            }
        } else {
            count = 0;
        }
        return func.apply(void 0, arguments);
    };
}
var __VIRTUAL_FILE133 = shortOut;
var setToString = __VIRTUAL_FILE133(__VIRTUAL_FILE132);
var __VIRTUAL_FILE134 = setToString;
function baseRest(func, start) {
    return __VIRTUAL_FILE134(__VIRTUAL_FILE130(func, start, __VIRTUAL_FILE128), func + "");
}
var __VIRTUAL_FILE135 = baseRest;
function isArrayLikeObject(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE67(value);
}
var __VIRTUAL_FILE136 = isArrayLikeObject;
var difference = __VIRTUAL_FILE135(function(array, values12) {
    return __VIRTUAL_FILE136(array) ? __VIRTUAL_FILE125(array, __VIRTUAL_FILE127(values12, 1, __VIRTUAL_FILE136, true)) : [];
});
var __VIRTUAL_FILE137 = difference;
function createBaseFor(fromRight) {
    return function(object, iteratee, keysFunc) {
        var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
        while(length--){
            var key = props[fromRight ? length : ++index];
            if (iteratee(iterable[key], key, iterable) === false) {
                break;
            }
        }
        return object;
    };
}
var __VIRTUAL_FILE138 = createBaseFor;
var baseFor = __VIRTUAL_FILE138();
var __VIRTUAL_FILE139 = baseFor;
function baseForOwn(object, iteratee) {
    return object && __VIRTUAL_FILE139(object, iteratee, __VIRTUAL_FILE68);
}
var __VIRTUAL_FILE140 = baseForOwn;
function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
        if (collection == null) {
            return collection;
        }
        if (!__VIRTUAL_FILE67(collection)) {
            return eachFunc(collection, iteratee);
        }
        var length = collection.length, index = fromRight ? length : -1, iterable = Object(collection);
        while(fromRight ? index-- : ++index < length){
            if (iteratee(iterable[index], index, iterable) === false) {
                break;
            }
        }
        return collection;
    };
}
var __VIRTUAL_FILE141 = createBaseEach;
var baseEach = __VIRTUAL_FILE141(__VIRTUAL_FILE140);
var __VIRTUAL_FILE142 = baseEach;
function castFunction(value) {
    return typeof value == "function" ? value : __VIRTUAL_FILE128;
}
var __VIRTUAL_FILE143 = castFunction;
function forEach(collection, iteratee) {
    var func = __VIRTUAL_FILE53(collection) ? __VIRTUAL_FILE44 : __VIRTUAL_FILE142;
    return func(collection, __VIRTUAL_FILE143(iteratee));
}
var __VIRTUAL_FILE144 = forEach;
var __VIRTUAL_FILE145 = __VIRTUAL_FILE144;
function assignMergeValue(object, key, value) {
    if (value !== void 0 && !__VIRTUAL_FILE1(object[key], value) || value === void 0 && !(key in object)) {
        __VIRTUAL_FILE46(object, key, value);
    }
}
var __VIRTUAL_FILE146 = assignMergeValue;
var objectTag3 = "[object Object]";
var funcProto2 = Function.prototype, objectProto13 = Object.prototype;
var funcToString2 = funcProto2.toString;
var hasOwnProperty10 = objectProto13.hasOwnProperty;
var objectCtorString = funcToString2.call(Object);
function isPlainObject(value) {
    if (!__VIRTUAL_FILE50(value) || __VIRTUAL_FILE17(value) != objectTag3) {
        return false;
    }
    var proto3 = __VIRTUAL_FILE81(value);
    if (proto3 === null) {
        return true;
    }
    var Ctor = hasOwnProperty10.call(proto3, "constructor") && proto3.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString2.call(Ctor) == objectCtorString;
}
var __VIRTUAL_FILE147 = isPlainObject;
function safeGet(object, key) {
    if (key === "constructor" && typeof object[key] === "function") {
        return;
    }
    if (key == "__proto__") {
        return;
    }
    return object[key];
}
var __VIRTUAL_FILE148 = safeGet;
function toPlainObject(value) {
    return __VIRTUAL_FILE48(value, __VIRTUAL_FILE72(value));
}
var __VIRTUAL_FILE149 = toPlainObject;
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = __VIRTUAL_FILE148(object, key), srcValue = __VIRTUAL_FILE148(source, key), stacked = stack.get(srcValue);
    if (stacked) {
        __VIRTUAL_FILE146(object, key, stacked);
        return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
        var isArr = __VIRTUAL_FILE53(srcValue), isBuff = !isArr && __VIRTUAL_FILE55(srcValue), isTyped = !isArr && !isBuff && __VIRTUAL_FILE61(srcValue);
        newValue = srcValue;
        if (isArr || isBuff || isTyped) {
            if (__VIRTUAL_FILE53(objValue)) {
                newValue = objValue;
            } else if (__VIRTUAL_FILE136(objValue)) {
                newValue = __VIRTUAL_FILE75(objValue);
            } else if (isBuff) {
                isCommon = false;
                newValue = __VIRTUAL_FILE74(srcValue, true);
            } else if (isTyped) {
                isCommon = false;
                newValue = __VIRTUAL_FILE98(srcValue, true);
            } else {
                newValue = [];
            }
        } else if (__VIRTUAL_FILE147(srcValue) || __VIRTUAL_FILE52(srcValue)) {
            newValue = objValue;
            if (__VIRTUAL_FILE52(objValue)) {
                newValue = __VIRTUAL_FILE149(objValue);
            } else if (!__VIRTUAL_FILE18(objValue) || __VIRTUAL_FILE19(objValue)) {
                newValue = __VIRTUAL_FILE101(srcValue);
            }
        } else {
            isCommon = false;
        }
    }
    if (isCommon) {
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack["delete"](srcValue);
    }
    __VIRTUAL_FILE146(object, key, newValue);
}
var __VIRTUAL_FILE150 = baseMergeDeep;
function baseMerge(object, source, srcIndex, customizer, stack) {
    if (object === source) {
        return;
    }
    __VIRTUAL_FILE139(source, function(srcValue, key) {
        stack || (stack = new __VIRTUAL_FILE43());
        if (__VIRTUAL_FILE18(srcValue)) {
            __VIRTUAL_FILE150(object, source, key, srcIndex, baseMerge, customizer, stack);
        } else {
            var newValue = customizer ? customizer(__VIRTUAL_FILE148(object, key), srcValue, key + "", object, source, stack) : void 0;
            if (newValue === void 0) {
                newValue = srcValue;
            }
            __VIRTUAL_FILE146(object, key, newValue);
        }
    }, __VIRTUAL_FILE72);
}
var __VIRTUAL_FILE151 = baseMerge;
function isIterateeCall(value, index, object) {
    if (!__VIRTUAL_FILE18(object)) {
        return false;
    }
    var type39 = typeof index;
    if (type39 == "number" ? __VIRTUAL_FILE67(object) && __VIRTUAL_FILE56(index, object.length) : type39 == "string" && index in object) {
        return __VIRTUAL_FILE1(object[index], value);
    }
    return false;
}
var __VIRTUAL_FILE152 = isIterateeCall;
function createAssigner(assigner) {
    return __VIRTUAL_FILE135(function(object, sources) {
        var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : void 0, guard = length > 2 ? sources[2] : void 0;
        customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : void 0;
        if (guard && __VIRTUAL_FILE152(sources[0], sources[1], guard)) {
            customizer = length < 3 ? void 0 : customizer;
            length = 1;
        }
        object = Object(object);
        while(++index < length){
            var source = sources[index];
            if (source) {
                assigner(object, source, index, customizer);
            }
        }
        return object;
    });
}
var __VIRTUAL_FILE153 = createAssigner;
var mergeWith = __VIRTUAL_FILE153(function(object, source, srcIndex, customizer) {
    __VIRTUAL_FILE151(object, source, srcIndex, customizer);
});
var __VIRTUAL_FILE154 = mergeWith;
var nativeFloor = Math.floor, nativeRandom = Math.random;
function baseRandom(lower, upper) {
    return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
}
var __VIRTUAL_FILE155 = baseRandom;
function shuffleSelf(array, size) {
    var index = -1, length = array.length, lastIndex = length - 1;
    size = size === void 0 ? length : size;
    while(++index < size){
        var rand = __VIRTUAL_FILE155(index, lastIndex), value = array[rand];
        array[rand] = array[index];
        array[index] = value;
    }
    array.length = size;
    return array;
}
var __VIRTUAL_FILE156 = shuffleSelf;
function arrayShuffle(array) {
    return __VIRTUAL_FILE156(__VIRTUAL_FILE75(array));
}
var __VIRTUAL_FILE157 = arrayShuffle;
function baseValues(object, props) {
    return __VIRTUAL_FILE123(props, function(key) {
        return object[key];
    });
}
var __VIRTUAL_FILE158 = baseValues;
function values(object) {
    return object == null ? [] : __VIRTUAL_FILE158(object, __VIRTUAL_FILE68(object));
}
var __VIRTUAL_FILE159 = values;
function baseShuffle(collection) {
    return __VIRTUAL_FILE156(__VIRTUAL_FILE159(collection));
}
var __VIRTUAL_FILE160 = baseShuffle;
function shuffle(collection) {
    var func = __VIRTUAL_FILE53(collection) ? __VIRTUAL_FILE157 : __VIRTUAL_FILE160;
    return func(collection);
}
var __VIRTUAL_FILE161 = shuffle;
var assignInWith = __VIRTUAL_FILE153(function(object, source, srcIndex, customizer) {
    __VIRTUAL_FILE48(source, __VIRTUAL_FILE72(source), object, customizer);
});
var __VIRTUAL_FILE162 = assignInWith;
var domExcTag = "[object DOMException]", errorTag2 = "[object Error]";
function isError(value) {
    if (!__VIRTUAL_FILE50(value)) {
        return false;
    }
    var tag = __VIRTUAL_FILE17(value);
    return tag == errorTag2 || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !__VIRTUAL_FILE147(value);
}
var __VIRTUAL_FILE163 = isError;
var attempt = __VIRTUAL_FILE135(function(func, args) {
    try {
        return __VIRTUAL_FILE129(func, void 0, args);
    } catch (e) {
        return __VIRTUAL_FILE163(e) ? e : new Error(e);
    }
});
var __VIRTUAL_FILE164 = attempt;
var objectProto14 = Object.prototype;
var hasOwnProperty11 = objectProto14.hasOwnProperty;
function customDefaultsAssignIn(objValue, srcValue, key, object) {
    if (objValue === void 0 || __VIRTUAL_FILE1(objValue, objectProto14[key]) && !hasOwnProperty11.call(object, key)) {
        return srcValue;
    }
    return objValue;
}
var __VIRTUAL_FILE165 = customDefaultsAssignIn;
var stringEscapes = {
    "\\": "\\",
    "'": "'",
    "\n": "n",
    "\r": "r",
    "\u2028": "u2028",
    "\u2029": "u2029"
};
function escapeStringChar(chr) {
    return "\\" + stringEscapes[chr];
}
var __VIRTUAL_FILE166 = escapeStringChar;
var reInterpolate = /<%=([\s\S]+?)%>/g;
var __VIRTUAL_FILE167 = reInterpolate;
function basePropertyOf(object) {
    return function(key) {
        return object == null ? void 0 : object[key];
    };
}
var __VIRTUAL_FILE168 = basePropertyOf;
var htmlEscapes = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#39;"
};
var escapeHtmlChar = __VIRTUAL_FILE168(htmlEscapes);
var __VIRTUAL_FILE169 = escapeHtmlChar;
var INFINITY = 1 / 0;
var symbolProto1 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolToString = symbolProto1 ? symbolProto1.toString : void 0;
function baseToString(value) {
    if (typeof value == "string") {
        return value;
    }
    if (__VIRTUAL_FILE53(value)) {
        return __VIRTUAL_FILE123(value, baseToString) + "";
    }
    if (__VIRTUAL_FILE111(value)) {
        return symbolToString ? symbolToString.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY ? "-0" : result;
}
var __VIRTUAL_FILE170 = baseToString;
function toString(value) {
    return value == null ? "" : __VIRTUAL_FILE170(value);
}
var __VIRTUAL_FILE171 = toString;
var reUnescapedHtml = /[&<>"']/g, reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
function escape(string29) {
    string29 = __VIRTUAL_FILE171(string29);
    return string29 && reHasUnescapedHtml.test(string29) ? string29.replace(reUnescapedHtml, __VIRTUAL_FILE169) : string29;
}
var __VIRTUAL_FILE172 = escape;
var reEscape = /<%-([\s\S]+?)%>/g;
var __VIRTUAL_FILE173 = reEscape;
var reEvaluate = /<%([\s\S]+?)%>/g;
var __VIRTUAL_FILE174 = reEvaluate;
var templateSettings = {
    escape: __VIRTUAL_FILE173,
    evaluate: __VIRTUAL_FILE174,
    interpolate: __VIRTUAL_FILE167,
    variable: "",
    imports: {
        _: {
            escape: __VIRTUAL_FILE172
        }
    }
};
var __VIRTUAL_FILE175 = templateSettings;
var INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
var reNoMatch = /($^)/;
var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
var objectProto15 = Object.prototype;
var hasOwnProperty12 = objectProto15.hasOwnProperty;
function template(string30, options, guard) {
    var settings = __VIRTUAL_FILE175.imports._.templateSettings || __VIRTUAL_FILE175;
    if (guard && __VIRTUAL_FILE152(string30, options, guard)) {
        options = void 0;
    }
    string30 = __VIRTUAL_FILE171(string30);
    options = __VIRTUAL_FILE162({}, options, settings, __VIRTUAL_FILE165);
    var imports2 = __VIRTUAL_FILE162({}, options.imports, settings.imports, __VIRTUAL_FILE165), importsKeys = __VIRTUAL_FILE68(imports2), importsValues = __VIRTUAL_FILE158(imports2, importsKeys);
    var isEscaping, isEvaluating, index = 0, interpolate = options.interpolate || reNoMatch, source = "__p += '";
    var reDelimiters = RegExp((options.escape || reNoMatch).source + "|" + interpolate.source + "|" + (interpolate === __VIRTUAL_FILE167 ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$", "g");
    var sourceURL = hasOwnProperty12.call(options, "sourceURL") ? "//# sourceURL=" + (options.sourceURL + "").replace(/\s/g, " ") + "\n" : "";
    string30.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
        interpolateValue || (interpolateValue = esTemplateValue);
        source += string30.slice(index, offset).replace(reUnescapedString, __VIRTUAL_FILE166);
        if (escapeValue) {
            isEscaping = true;
            source += "' +\n__e(" + escapeValue + ") +\n'";
        }
        if (evaluateValue) {
            isEvaluating = true;
            source += "';\n" + evaluateValue + ";\n__p += '";
        }
        if (interpolateValue) {
            source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
        }
        index = offset + match.length;
        return match;
    });
    source += "';\n";
    var variable = hasOwnProperty12.call(options, "variable") && options.variable;
    if (!variable) {
        source = "with (obj) {\n" + source + "\n}\n";
    } else if (reForbiddenIdentifierChars.test(variable)) {
        throw new Error(INVALID_TEMPL_VAR_ERROR_TEXT);
    }
    source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
    source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
    var result = __VIRTUAL_FILE164(function() {
        return Function(importsKeys, sourceURL + "return " + source).apply(void 0, importsValues);
    });
    result.source = source;
    if (__VIRTUAL_FILE163(result)) {
        throw result;
    }
    return result;
}
var __VIRTUAL_FILE176 = template;
function noop() {}
var __VIRTUAL_FILE177 = noop;
function setToArray(set2) {
    var index = -1, result = Array(set2.size);
    set2.forEach(function(value) {
        result[++index] = value;
    });
    return result;
}
var __VIRTUAL_FILE178 = setToArray;
var INFINITY1 = 1 / 0;
var createSet = !(__VIRTUAL_FILE89 && 1 / __VIRTUAL_FILE178(new __VIRTUAL_FILE89([
    ,
    -0
]))[1] == INFINITY1) ? __VIRTUAL_FILE177 : function(values13) {
    return new __VIRTUAL_FILE89(values13);
};
var __VIRTUAL_FILE179 = createSet;
var LARGE_ARRAY_SIZE2 = 200;
function baseUniq(array, iteratee, comparator) {
    var index = -1, includes = __VIRTUAL_FILE121, length = array.length, isCommon = true, result = [], seen = result;
    if (comparator) {
        isCommon = false;
        includes = __VIRTUAL_FILE122;
    } else if (length >= LARGE_ARRAY_SIZE2) {
        var set3 = iteratee ? null : __VIRTUAL_FILE179(array);
        if (set3) {
            return __VIRTUAL_FILE178(set3);
        }
        isCommon = false;
        includes = __VIRTUAL_FILE124;
        seen = new __VIRTUAL_FILE116();
    } else {
        seen = iteratee ? [] : result;
    }
    outer: while(++index < length){
        var value = array[index], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
            var seenIndex = seen.length;
            while(seenIndex--){
                if (seen[seenIndex] === computed) {
                    continue outer;
                }
            }
            if (iteratee) {
                seen.push(computed);
            }
            result.push(value);
        } else if (!includes(seen, computed, comparator)) {
            if (seen !== result) {
                seen.push(computed);
            }
            result.push(value);
        }
    }
    return result;
}
var __VIRTUAL_FILE180 = baseUniq;
function uniq(array) {
    return array && array.length ? __VIRTUAL_FILE180(array) : [];
}
var __VIRTUAL_FILE181 = uniq;
function arraySome(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (predicate(array[index], index, array)) {
            return true;
        }
    }
    return false;
}
var __VIRTUAL_FILE182 = arraySome;
var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
    }
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
        return arrStacked == other && othStacked == array;
    }
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new __VIRTUAL_FILE116() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while(++index < arrLength){
        var arrValue = array[index], othValue = other[index];
        if (customizer) {
            var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        }
        if (compared !== void 0) {
            if (compared) {
                continue;
            }
            result = false;
            break;
        }
        if (seen) {
            if (!__VIRTUAL_FILE182(other, function(othValue2, othIndex) {
                if (!__VIRTUAL_FILE124(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                    return seen.push(othIndex);
                }
            })) {
                result = false;
                break;
            }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
            result = false;
            break;
        }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
}
var __VIRTUAL_FILE183 = equalArrays;
function mapToArray(map7) {
    var index = -1, result = Array(map7.size);
    map7.forEach(function(value, key) {
        result[++index] = [
            key,
            value
        ];
    });
    return result;
}
var __VIRTUAL_FILE184 = mapToArray;
var COMPARE_PARTIAL_FLAG1 = 1, COMPARE_UNORDERED_FLAG1 = 2;
var boolTag3 = "[object Boolean]", dateTag3 = "[object Date]", errorTag3 = "[object Error]", mapTag5 = "[object Map]", numberTag3 = "[object Number]", regexpTag3 = "[object RegExp]", setTag5 = "[object Set]", stringTag3 = "[object String]", symbolTag3 = "[object Symbol]";
var arrayBufferTag3 = "[object ArrayBuffer]", dataViewTag4 = "[object DataView]";
var symbolProto2 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolValueOf1 = symbolProto2 ? symbolProto2.valueOf : void 0;
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
    switch(tag){
        case dataViewTag4:
            if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
                return false;
            }
            object = object.buffer;
            other = other.buffer;
        case arrayBufferTag3:
            if (object.byteLength != other.byteLength || !equalFunc(new __VIRTUAL_FILE93(object), new __VIRTUAL_FILE93(other))) {
                return false;
            }
            return true;
        case boolTag3:
        case dateTag3:
        case numberTag3:
            return __VIRTUAL_FILE1(+object, +other);
        case errorTag3:
            return object.name == other.name && object.message == other.message;
        case regexpTag3:
        case stringTag3:
            return object == other + "";
        case mapTag5:
            var convert = __VIRTUAL_FILE184;
        case setTag5:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG1;
            convert || (convert = __VIRTUAL_FILE178);
            if (object.size != other.size && !isPartial) {
                return false;
            }
            var stacked = stack.get(object);
            if (stacked) {
                return stacked == other;
            }
            bitmask |= COMPARE_UNORDERED_FLAG1;
            stack.set(object, other);
            var result = __VIRTUAL_FILE183(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
            stack["delete"](object);
            return result;
        case symbolTag3:
            if (symbolValueOf1) {
                return symbolValueOf1.call(object) == symbolValueOf1.call(other);
            }
    }
    return false;
}
var __VIRTUAL_FILE185 = equalByTag;
var COMPARE_PARTIAL_FLAG2 = 1;
var objectProto16 = Object.prototype;
var hasOwnProperty13 = objectProto16.hasOwnProperty;
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, objProps = __VIRTUAL_FILE85(object), objLength = objProps.length, othProps = __VIRTUAL_FILE85(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
        return false;
    }
    var index = objLength;
    while(index--){
        var key = objProps[index];
        if (!(isPartial ? key in other : hasOwnProperty13.call(other, key))) {
            return false;
        }
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
        return objStacked == other && othStacked == object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while(++index < objLength){
        key = objProps[index];
        var objValue = object[key], othValue = other[key];
        if (customizer) {
            var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        }
        if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
            result = false;
            break;
        }
        skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
        var objCtor = object.constructor, othCtor = other.constructor;
        if (objCtor != othCtor && "constructor" in object && "constructor" in other && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
            result = false;
        }
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
}
var __VIRTUAL_FILE186 = equalObjects;
var COMPARE_PARTIAL_FLAG3 = 1;
var argsTag3 = "[object Arguments]", arrayTag2 = "[object Array]", objectTag4 = "[object Object]";
var objectProto17 = Object.prototype;
var hasOwnProperty14 = objectProto17.hasOwnProperty;
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = __VIRTUAL_FILE53(object), othIsArr = __VIRTUAL_FILE53(other), objTag = objIsArr ? arrayTag2 : __VIRTUAL_FILE91(object), othTag = othIsArr ? arrayTag2 : __VIRTUAL_FILE91(other);
    objTag = objTag == argsTag3 ? objectTag4 : objTag;
    othTag = othTag == argsTag3 ? objectTag4 : othTag;
    var objIsObj = objTag == objectTag4, othIsObj = othTag == objectTag4, isSameTag = objTag == othTag;
    if (isSameTag && __VIRTUAL_FILE55(object)) {
        if (!__VIRTUAL_FILE55(other)) {
            return false;
        }
        objIsArr = true;
        objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
        stack || (stack = new __VIRTUAL_FILE43());
        return objIsArr || __VIRTUAL_FILE61(object) ? __VIRTUAL_FILE183(object, other, bitmask, customizer, equalFunc, stack) : __VIRTUAL_FILE185(object, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG3)) {
        var objIsWrapped = objIsObj && hasOwnProperty14.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty14.call(other, "__wrapped__");
        if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
            stack || (stack = new __VIRTUAL_FILE43());
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
    }
    if (!isSameTag) {
        return false;
    }
    stack || (stack = new __VIRTUAL_FILE43());
    return __VIRTUAL_FILE186(object, other, bitmask, customizer, equalFunc, stack);
}
var __VIRTUAL_FILE187 = baseIsEqualDeep;
function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
        return true;
    }
    if (value == null || other == null || !__VIRTUAL_FILE50(value) && !__VIRTUAL_FILE50(other)) {
        return value !== value && other !== other;
    }
    return __VIRTUAL_FILE187(value, other, bitmask, customizer, baseIsEqual, stack);
}
var __VIRTUAL_FILE188 = baseIsEqual;
var COMPARE_PARTIAL_FLAG4 = 1, COMPARE_UNORDERED_FLAG2 = 2;
function baseIsMatch(object, source, matchData, customizer) {
    var index = matchData.length, length = index, noCustomizer = !customizer;
    if (object == null) {
        return !length;
    }
    object = Object(object);
    while(index--){
        var data67 = matchData[index];
        if (noCustomizer && data67[2] ? data67[1] !== object[data67[0]] : !(data67[0] in object)) {
            return false;
        }
    }
    while(++index < length){
        data67 = matchData[index];
        var key = data67[0], objValue = object[key], srcValue = data67[1];
        if (noCustomizer && data67[2]) {
            if (objValue === void 0 && !(key in object)) {
                return false;
            }
        } else {
            var stack = new __VIRTUAL_FILE43();
            if (customizer) {
                var result = customizer(objValue, srcValue, key, object, source, stack);
            }
            if (!(result === void 0 ? __VIRTUAL_FILE188(srcValue, objValue, COMPARE_PARTIAL_FLAG4 | COMPARE_UNORDERED_FLAG2, customizer, stack) : result)) {
                return false;
            }
        }
    }
    return true;
}
var __VIRTUAL_FILE189 = baseIsMatch;
function isStrictComparable(value) {
    return value === value && !__VIRTUAL_FILE18(value);
}
var __VIRTUAL_FILE190 = isStrictComparable;
function getMatchData(object) {
    var result = __VIRTUAL_FILE68(object), length = result.length;
    while(length--){
        var key = result[length], value = object[key];
        result[length] = [
            key,
            value,
            __VIRTUAL_FILE190(value)
        ];
    }
    return result;
}
var __VIRTUAL_FILE191 = getMatchData;
function matchesStrictComparable(key, srcValue) {
    return function(object) {
        if (object == null) {
            return false;
        }
        return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
    };
}
var __VIRTUAL_FILE192 = matchesStrictComparable;
function baseMatches(source) {
    var matchData = __VIRTUAL_FILE191(source);
    if (matchData.length == 1 && matchData[0][2]) {
        return __VIRTUAL_FILE192(matchData[0][0], matchData[0][1]);
    }
    return function(object) {
        return object === source || __VIRTUAL_FILE189(object, source, matchData);
    };
}
var __VIRTUAL_FILE193 = baseMatches;
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
function isKey(value, object) {
    if (__VIRTUAL_FILE53(value)) {
        return false;
    }
    var type40 = typeof value;
    if (type40 == "number" || type40 == "symbol" || type40 == "boolean" || value == null || __VIRTUAL_FILE111(value)) {
        return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
}
var __VIRTUAL_FILE194 = isKey;
var FUNC_ERROR_TEXT1 = "Expected a function";
function memoize1(func, resolver) {
    if (typeof func != "function" || resolver != null && typeof resolver != "function") {
        throw new TypeError(FUNC_ERROR_TEXT1);
    }
    var memoized = function() {
        var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
        if (cache.has(key)) {
            return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result) || cache;
        return result;
    };
    memoized.cache = new (memoize1.Cache || __VIRTUAL_FILE41)();
    return memoized;
}
memoize1.Cache = __VIRTUAL_FILE41;
var __VIRTUAL_FILE195 = memoize1;
var MAX_MEMOIZE_SIZE = 500;
function memoizeCapped(func) {
    var result = __VIRTUAL_FILE195(func, function(key) {
        if (cache.size === MAX_MEMOIZE_SIZE) {
            cache.clear();
        }
        return key;
    });
    var cache = result.cache;
    return result;
}
var __VIRTUAL_FILE196 = memoizeCapped;
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
var stringToPath = __VIRTUAL_FILE196(function(string31) {
    var result = [];
    if (string31.charCodeAt(0) === 46) {
        result.push("");
    }
    string31.replace(rePropName, function(match, number2, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match);
    });
    return result;
});
var __VIRTUAL_FILE197 = stringToPath;
function castPath(value, object) {
    if (__VIRTUAL_FILE53(value)) {
        return value;
    }
    return __VIRTUAL_FILE194(value, object) ? [
        value
    ] : __VIRTUAL_FILE197(__VIRTUAL_FILE171(value));
}
var __VIRTUAL_FILE198 = castPath;
var INFINITY2 = 1 / 0;
function toKey(value) {
    if (typeof value == "string" || __VIRTUAL_FILE111(value)) {
        return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY2 ? "-0" : result;
}
var __VIRTUAL_FILE199 = toKey;
function baseGet(object, path50) {
    path50 = __VIRTUAL_FILE198(path50, object);
    var index = 0, length = path50.length;
    while(object != null && index < length){
        object = object[__VIRTUAL_FILE199(path50[index++])];
    }
    return index && index == length ? object : void 0;
}
var __VIRTUAL_FILE200 = baseGet;
function get(object, path51, defaultValue) {
    var result = object == null ? void 0 : __VIRTUAL_FILE200(object, path51);
    return result === void 0 ? defaultValue : result;
}
var __VIRTUAL_FILE201 = get;
function baseHasIn(object, key) {
    return object != null && key in Object(object);
}
var __VIRTUAL_FILE202 = baseHasIn;
function hasPath(object, path52, hasFunc) {
    path52 = __VIRTUAL_FILE198(path52, object);
    var index = -1, length = path52.length, result = false;
    while(++index < length){
        var key = __VIRTUAL_FILE199(path52[index]);
        if (!(result = object != null && hasFunc(object, key))) {
            break;
        }
        object = object[key];
    }
    if (result || ++index != length) {
        return result;
    }
    length = object == null ? 0 : object.length;
    return !!length && __VIRTUAL_FILE57(length) && __VIRTUAL_FILE56(key, length) && (__VIRTUAL_FILE53(object) || __VIRTUAL_FILE52(object));
}
var __VIRTUAL_FILE203 = hasPath;
function hasIn(object, path53) {
    return object != null && __VIRTUAL_FILE203(object, path53, __VIRTUAL_FILE202);
}
var __VIRTUAL_FILE204 = hasIn;
var COMPARE_PARTIAL_FLAG5 = 1, COMPARE_UNORDERED_FLAG3 = 2;
function baseMatchesProperty(path54, srcValue) {
    if (__VIRTUAL_FILE194(path54) && __VIRTUAL_FILE190(srcValue)) {
        return __VIRTUAL_FILE192(__VIRTUAL_FILE199(path54), srcValue);
    }
    return function(object) {
        var objValue = __VIRTUAL_FILE201(object, path54);
        return objValue === void 0 && objValue === srcValue ? __VIRTUAL_FILE204(object, path54) : __VIRTUAL_FILE188(srcValue, objValue, COMPARE_PARTIAL_FLAG5 | COMPARE_UNORDERED_FLAG3);
    };
}
var __VIRTUAL_FILE205 = baseMatchesProperty;
function baseProperty(key) {
    return function(object) {
        return object == null ? void 0 : object[key];
    };
}
var __VIRTUAL_FILE206 = baseProperty;
function basePropertyDeep(path55) {
    return function(object) {
        return __VIRTUAL_FILE200(object, path55);
    };
}
var __VIRTUAL_FILE207 = basePropertyDeep;
function property(path56) {
    return __VIRTUAL_FILE194(path56) ? __VIRTUAL_FILE206(__VIRTUAL_FILE199(path56)) : __VIRTUAL_FILE207(path56);
}
var __VIRTUAL_FILE208 = property;
function baseIteratee(value) {
    if (typeof value == "function") {
        return value;
    }
    if (value == null) {
        return __VIRTUAL_FILE128;
    }
    if (typeof value == "object") {
        return __VIRTUAL_FILE53(value) ? __VIRTUAL_FILE205(value[0], value[1]) : __VIRTUAL_FILE193(value);
    }
    return __VIRTUAL_FILE208(value);
}
var __VIRTUAL_FILE209 = baseIteratee;
function uniqBy(array, iteratee) {
    return array && array.length ? __VIRTUAL_FILE180(array, __VIRTUAL_FILE209(iteratee, 2)) : [];
}
var __VIRTUAL_FILE210 = uniqBy;
function isEqual(value, other) {
    return __VIRTUAL_FILE188(value, other);
}
var __VIRTUAL_FILE211 = isEqual;
function baseMap(collection, iteratee) {
    var index = -1, result = __VIRTUAL_FILE67(collection) ? Array(collection.length) : [];
    __VIRTUAL_FILE142(collection, function(value, key, collection2) {
        result[++index] = iteratee(value, key, collection2);
    });
    return result;
}
var __VIRTUAL_FILE212 = baseMap;
function baseSortBy(array, comparer) {
    var length = array.length;
    array.sort(comparer);
    while(length--){
        array[length] = array[length].value;
    }
    return array;
}
var __VIRTUAL_FILE213 = baseSortBy;
function compareAscending(value, other) {
    if (value !== other) {
        var valIsDefined = value !== void 0, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = __VIRTUAL_FILE111(value);
        var othIsDefined = other !== void 0, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = __VIRTUAL_FILE111(other);
        if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
            return 1;
        }
        if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
            return -1;
        }
    }
    return 0;
}
var __VIRTUAL_FILE214 = compareAscending;
function compareMultiple(object, other, orders) {
    var index = -1, objCriteria = object.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
    while(++index < length){
        var result = __VIRTUAL_FILE214(objCriteria[index], othCriteria[index]);
        if (result) {
            if (index >= ordersLength) {
                return result;
            }
            var order = orders[index];
            return result * (order == "desc" ? -1 : 1);
        }
    }
    return object.index - other.index;
}
var __VIRTUAL_FILE215 = compareMultiple;
function baseOrderBy(collection, iteratees, orders) {
    if (iteratees.length) {
        iteratees = __VIRTUAL_FILE123(iteratees, function(iteratee) {
            if (__VIRTUAL_FILE53(iteratee)) {
                return function(value) {
                    return __VIRTUAL_FILE200(value, iteratee.length === 1 ? iteratee[0] : iteratee);
                };
            }
            return iteratee;
        });
    } else {
        iteratees = [
            __VIRTUAL_FILE128
        ];
    }
    var index = -1;
    iteratees = __VIRTUAL_FILE123(iteratees, __VIRTUAL_FILE59(__VIRTUAL_FILE209));
    var result = __VIRTUAL_FILE212(collection, function(value, key, collection2) {
        var criteria = __VIRTUAL_FILE123(iteratees, function(iteratee) {
            return iteratee(value);
        });
        return {
            criteria,
            index: ++index,
            value
        };
    });
    return __VIRTUAL_FILE213(result, function(object, other) {
        return __VIRTUAL_FILE215(object, other, orders);
    });
}
var __VIRTUAL_FILE216 = baseOrderBy;
function orderBy(collection, iteratees, orders, guard) {
    if (collection == null) {
        return [];
    }
    if (!__VIRTUAL_FILE53(iteratees)) {
        iteratees = iteratees == null ? [] : [
            iteratees
        ];
    }
    orders = guard ? void 0 : orders;
    if (!__VIRTUAL_FILE53(orders)) {
        orders = orders == null ? [] : [
            orders
        ];
    }
    return __VIRTUAL_FILE216(collection, iteratees, orders);
}
var __VIRTUAL_FILE217 = orderBy;
const cloneDeep1 = __VIRTUAL_FILE107;
const debounce1 = __VIRTUAL_FILE113;
const shuffle1 = __VIRTUAL_FILE161;
const toString1 = __VIRTUAL_FILE171;
const uniq1 = __VIRTUAL_FILE181;
const uniqBy1 = __VIRTUAL_FILE210;
const escape1 = __VIRTUAL_FILE172;
function generate() {
    return crypto.randomUUID();
}
function mergeConfigs(config2, ...configs) {
    config2 = cloneDeep1(config2);
    configs = cloneDeep1(configs);
    return __VIRTUAL_FILE154(config2, ...configs, mergeArrayCustomizer);
}
function mergeArrayCustomizer(objValue, srcValue) {
    if (__VIRTUAL_FILE53(objValue) || __VIRTUAL_FILE53(srcValue)) {
        if (!objValue) {
            return srcValue;
        } else if (!srcValue) {
            return objValue;
        } else {
            if (!__VIRTUAL_FILE53(objValue)) {
                objValue = [
                    objValue
                ];
            }
            if (!__VIRTUAL_FILE53(srcValue)) {
                srcValue = [
                    srcValue
                ];
            }
        }
        const combined = objValue.concat(srcValue);
        return __VIRTUAL_FILE210(combined, (value)=>{
            if (typeof value === "function") {
                return generate();
            } else {
                return JSON.stringify(value);
            }
        });
    }
}
function camelToKebab(camel) {
    const kebab = [];
    for(let i60 = 0; i60 < camel.length; i60++){
        const ch = camel.charAt(i60);
        if (ch === ch.toUpperCase() && !/^\d+/.test(ch)) {
            if (i60 > 0) {
                kebab.push("-");
            }
            kebab.push(ch.toLowerCase());
        } else {
            kebab.push(ch);
        }
    }
    return kebab.join("");
}
function kebabToCamel(kebab, leadingUppercase = false) {
    const camel = [];
    for(let i61 = 0; i61 < kebab.length; i61++){
        const ch = kebab.charAt(i61);
        if (ch === "-") {
            camel.push(kebab.charAt(++i61).toUpperCase());
        } else if (i61 === 0 && leadingUppercase) {
            camel.push(ch.toUpperCase());
        } else {
            camel.push(ch);
        }
    }
    return camel.join("");
}
const kMetadataFormat = "format";
const kRenderDefaults = "render";
const kExecuteDefaults = "execute";
const kPandocDefaults = "pandoc";
const kLanguageDefaults = "language";
const kPandocMetadata = "metadata";
const kFigWidth = "fig-width";
const kFigHeight = "fig-height";
const kFigFormat = "fig-format";
const kFigDpi = "fig-dpi";
const kMermaidFormat = "mermaid-format";
const kDfPrint = "df-print";
const kCache = "cache";
const kFreeze = "freeze";
const kEngine = "engine";
const kEval = "eval";
const kEcho = "echo";
const kOutput = "output";
const kWarning = "warning";
const kError = "error";
const kInclude = "include";
const kResources = "resources";
const kKeepHidden = "keep-hidden";
const kExecuteEnabled = "enabled";
const kExecuteIpynb = "ipynb";
const kExecuteDaemon = "daemon";
const kExecuteDaemonRestart = "daemon-restart";
const kExecuteDebug = "debug";
const kIpynbFilter = "ipynb-filter";
const kIpynbFilters = "ipynb-filters";
const kIPynbTitleBlockTemplate = "ipynb-title-block";
const kShortcodes = "shortcodes";
const kKeepMd = "keep-md";
const kKeepTex = "keep-tex";
const kKeepYaml = "keep-yaml";
const kKeepIpynb = "keep-ipynb";
const kKeepSource = "keep-source";
const kVariant = "variant";
const kOutputExt = "output-ext";
const kOutputDivs = "output-divs";
const kPageWidth = "page-width";
const kFigAlign = "fig-align";
const kFigEnv = "fig-env";
const kFigPos = "fig-pos";
const kCodeFold = "code-fold";
const kCodeLineNumbers = "code-line-numbers";
const kCodeOverflow = "code-overflow";
const kCodeLink = "code-link";
const kCodeTools = "code-tools";
const kTblCap = "tbl-cap";
const kTblColwidths = "tbl-colwidths";
const kMergeIncludes = "merge-includes";
const kPreferHtml = "prefer-html";
const kSelfContainedMath = "self-contained-math";
const kLatexAutoMk = "latex-auto-mk";
const kLatexAutoInstall = "latex-auto-install";
const kLatexMinRuns = "latex-min-runs";
const kLatexMaxRuns = "latex-max-runs";
const kLatexClean = "latex-clean";
const kLatexInputPaths = "latex-input-paths";
const kLatexMakeIndex = "latex-makeindex";
const kLatexMakeIndexOpts = "latex-makeindex-opts";
const kLatexTlmgrOpts = "latex-tlmgr-opts";
const kLatexOutputDir = "latex-output-dir";
const kLinkExternalIcon = "link-external-icon";
const kLinkExternalNewwindow = "link-external-newwindow";
const kLinkExternalFilter = "link-external-filter";
const kQuartoVersion = "quarto-version";
const kExecuteDefaultsKeys = [
    kFigWidth,
    kFigHeight,
    kFigFormat,
    kFigDpi,
    kMermaidFormat,
    kDfPrint,
    kError,
    kEval,
    kEngine,
    kCache,
    kFreeze,
    kEcho,
    kOutput,
    kWarning,
    kInclude,
    kKeepMd,
    kKeepIpynb,
    kExecuteEnabled,
    kExecuteIpynb,
    kExecuteDaemon,
    kExecuteDaemonRestart,
    kExecuteDebug,
    kIpynbFilter,
    kIpynbFilters, 
];
const kRenderDefaultsKeys = [
    kKeepTex,
    kKeepYaml,
    kKeepSource,
    kKeepHidden,
    kVariant,
    kOutputExt,
    kOutputDivs,
    kPreferHtml,
    kPageWidth,
    kFigAlign,
    kFigPos,
    kFigEnv,
    kCodeFold,
    kCodeLink,
    kCodeLineNumbers,
    kCodeOverflow,
    kCodeTools,
    kShortcodes,
    kTblColwidths,
    kSelfContainedMath,
    kLatexAutoMk,
    kLatexAutoInstall,
    kLatexMinRuns,
    kLatexMaxRuns,
    kLatexClean,
    kLatexInputPaths,
    kLatexMakeIndex,
    kLatexMakeIndexOpts,
    kLatexTlmgrOpts,
    kLatexOutputDir,
    kLinkExternalIcon,
    kLinkExternalNewwindow,
    kLinkExternalFilter, 
];
const kTocTitleDocument = "toc-title-document";
const kTocTitleWebsite = "toc-title-website";
const kCalloutTipCaption = "callout-tip-caption";
const kCalloutNoteCaption = "callout-note-caption";
const kCalloutWarningCaption = "callout-warning-caption";
const kCalloutImportantCaption = "callout-important-caption";
const kCalloutCautionCaption = "callout-caution-caption";
const kSectionTitleAbstract = "section-title-abstract";
const kSectionTitleFootnotes = "section-title-footnotes";
const kSectionTitleReferences = "section-title-references";
const kSectionTitleAppendices = "section-title-appendices";
const kSectionTitleReuse = "section-title-reuse";
const kSectionTitleCitation = "section-title-citation";
const kAppendixAttributionBibTex = "appendix-attribution-bibtex";
const kAppendixAttributionCiteAs = "appendix-attribution-cite-as";
const kTitleBlockAuthorSingle = "title-block-author-single";
const kTitleBlockAuthorPlural = "title-block-author-plural";
const kTitleBlockAffiliationSingle = "title-block-affiliation-single";
const kTitleBlockAffiliationPlural = "title-block-affiliation-plural";
const kTitleBlockPublished = "title-block-published";
const kCodeSummary = "code-summary";
const kCodeToolsMenuCaption = "code-tools-menu-caption";
const kCodeToolsShowAllCode = "code-tools-show-all-code";
const kCodeToolsHideAllCode = "code-tools-hide-all-code";
const kCodeToolsViewSource = "code-tools-view-source";
const kCodeToolsSourceCode = "code-tools-source-code";
const kSearchNoResultsText = "search-no-results-text";
const kCopyButtonTooltip = "copy-button-tooltip";
const kCopyButtonTooltipSuccess = "copy-button-tooltip-success";
const kRepoActionLinksEdit = "repo-action-links-edit";
const kRepoActionLinksSource = "repo-action-links-source";
const kRepoActionLinksIssue = "repo-action-links-issue";
const kSearchMatchingDocumentsText = "search-matching-documents-text";
const kSearchCopyLinkTitle = "search-copy-link-title";
const kSearchHideMatchesText = "search-hide-matches-text";
const kSearchMoreMatchText = "search-more-match-text";
const kSearchMoreMatchesText = "search-more-matches-text";
const kSearchClearButtonTitle = "search-clear-button-title";
const kSearchDetatchedCancelButtonTitle = "search-detached-cancel-button-title";
const kSearchSubmitButtonTitle = "search-submit-button-title";
const kCrossrefFigTitle = "crossref-fig-title";
const kCrossrefTblTitle = "crossref-tbl-title";
const kCrossrefLstTitle = "crossref-lst-title";
const kCrossrefThmTitle = "crossref-thm-title";
const kCrossrefLemTitle = "crossref-lem-title";
const kCrossrefCorTitle = "crossref-cor-title";
const kCrossrefPrfTitle = "crossref-prp-title";
const kCrossrefCnjTitle = "crossref-cnj-title";
const kCrossrefDefTitle = "crossref-def-title";
const kCrossrefExmTitle = "crossref-exm-title";
const kCrossrefExrTitle = "crossref-exr-title";
const kCrossrefFigPrefix = "crossref-fig-prefix";
const kCrossrefTblPrefix = "crossref-tbl-prefix";
const kCrossrefLstPrefix = "crossref-lst-prefix";
const kCrossrefChPrefix = "crossref-ch-prefix";
const kCrossrefSecPrefix = "crossref-sec-prefix";
const kCrossrefEqPrefix = "crossref-eq-prefix";
const kCrossrefThmPrefix = "crossref-thm-prefix";
const kCrossrefLemPrefix = "crossref-lem-prefix";
const kCrossrefCorPrefix = "crossref-cor-prefix";
const kCrossrefPrpPrefix = "crossref-prp-prefix";
const kCrossrefCnjPrefix = "crossref-cnj-prefix";
const kCrossrefDefPrefix = "crossref-def-prefix";
const kCrossrefExmPrefix = "crossref-exm-prefix";
const kCrossrefExrPrefix = "crossref-exr-prefix";
const kCrossrefLofTitle = "crossref-lof-title";
const kCrossrefLotTitle = "crossref-lot-title";
const kCrossrefLolTitle = "crossref-lol-title";
const kEnvironmentProofTitle = "environment-proof-title";
const kEnvironmentRemarkTitle = "environment-remark-title";
const kEnvironmentSolutionTitle = "environment-solution-title";
const kListingPageOrderBy = "listing-page-order-by";
const kListingPageOrderByDefault = "listing-page-order-by-default";
const kListingPageOrderByDateAsc = "listing-page-order-by-date-asc";
const kListingPageOrderByDateDesc = "listing-page-order-by-date-desc";
const kListingPageOrderByNumberAsc = "listing-page-order-by-number-asc";
const kListingPageOrderByNumberDesc = "listing-page-order-by-number-desc";
const kListingPageFieldDate = "listing-page-field-date";
const kListingPageFieldTitle = "listing-page-field-title";
const kListingPageFieldDescription = "listing-page-field-description";
const kListingPageFieldAuthor = "listing-page-field-author";
const kListingPageFieldFileName = "listing-page-field-filename";
const kListingPageFieldFileModified = "listing-page-field-filemodified";
const kListingPageFieldSubtitle = "listing-page-field-subtitle";
const kListingPageFieldReadingTime = "listing-page-field-readingtime";
const kListingPageFieldCategories = "listing-page-field-categories";
const kListingPageMinutesCompact = "listing-page-minutes-compact";
const kListingPageCategoryAll = "listing-page-category-all";
const kListingPageNoMatches = "listing-page-no-matches";
const kLanguageDefaultsKeys = [
    kTocTitleDocument,
    kTocTitleWebsite,
    kCalloutTipCaption,
    kCalloutNoteCaption,
    kCalloutWarningCaption,
    kCalloutImportantCaption,
    kCalloutCautionCaption,
    kSectionTitleAbstract,
    kSectionTitleFootnotes,
    kSectionTitleReferences,
    kSectionTitleAppendices,
    kSectionTitleReuse,
    kSectionTitleCitation,
    kAppendixAttributionBibTex,
    kAppendixAttributionCiteAs,
    kTitleBlockAuthorSingle,
    kTitleBlockPublished,
    kCodeSummary,
    kCodeToolsMenuCaption,
    kCodeToolsShowAllCode,
    kCodeToolsHideAllCode,
    kCodeToolsViewSource,
    kCodeToolsSourceCode,
    kSearchNoResultsText,
    kCopyButtonTooltip,
    kCopyButtonTooltipSuccess,
    kRepoActionLinksEdit,
    kRepoActionLinksSource,
    kRepoActionLinksIssue,
    kSearchMatchingDocumentsText,
    kSearchCopyLinkTitle,
    kSearchHideMatchesText,
    kSearchMoreMatchText,
    kSearchMoreMatchesText,
    kSearchClearButtonTitle,
    kSearchDetatchedCancelButtonTitle,
    kSearchSubmitButtonTitle,
    kCrossrefFigTitle,
    kCrossrefTblTitle,
    kCrossrefLstTitle,
    kCrossrefThmTitle,
    kCrossrefLemTitle,
    kCrossrefCorTitle,
    kCrossrefPrfTitle,
    kCrossrefCnjTitle,
    kCrossrefDefTitle,
    kCrossrefExmTitle,
    kCrossrefExrTitle,
    kCrossrefFigPrefix,
    kCrossrefTblPrefix,
    kCrossrefLstPrefix,
    kCrossrefChPrefix,
    kCrossrefSecPrefix,
    kCrossrefEqPrefix,
    kCrossrefThmPrefix,
    kCrossrefLemPrefix,
    kCrossrefCorPrefix,
    kCrossrefPrpPrefix,
    kCrossrefCnjPrefix,
    kCrossrefDefPrefix,
    kCrossrefExmPrefix,
    kCrossrefExrPrefix,
    kCrossrefLofTitle,
    kCrossrefLotTitle,
    kCrossrefLolTitle,
    kEnvironmentProofTitle,
    kEnvironmentRemarkTitle,
    kEnvironmentSolutionTitle,
    kListingPageOrderBy,
    kListingPageOrderByDefault,
    kListingPageOrderByDateAsc,
    kListingPageOrderByDateDesc,
    kListingPageOrderByNumberAsc,
    kListingPageOrderByNumberDesc,
    kListingPageFieldDate,
    kListingPageFieldTitle,
    kListingPageFieldDescription,
    kListingPageFieldAuthor,
    kListingPageFieldFileName,
    kListingPageFieldFileModified,
    kListingPageFieldSubtitle,
    kListingPageFieldReadingTime,
    kListingPageFieldCategories,
    kListingPageMinutesCompact,
    kListingPageCategoryAll,
    kListingPageNoMatches,
    kTitleBlockAuthorSingle,
    kTitleBlockAuthorPlural,
    kTitleBlockAffiliationSingle,
    kTitleBlockAffiliationPlural,
    kTitleBlockPublished, 
];
const kTo = "to";
const kFrom = "from";
const kReader = "reader";
const kWriter = "writer";
const kOutputFile = "output-file";
const kInputFiles = "input-files";
const kAtxHeaders = "atx-headers";
const kMarkdownHeadings = "markdown-headings";
const kTemplate = "template";
const kStandalone = "standalone";
const kWrap = "wrap";
const kSelfContained = "self-contained";
const kIncludeBeforeBody = "include-before-body";
const kIncludeAfterBody = "include-after-body";
const kIncludeInHeader = "include-in-header";
const kCiteproc = "citeproc";
const kCiteMethod = "cite-method";
const kFilters = "filters";
const kFilterParams = "filter-params";
const kPdfEngine = "pdf-engine";
const kPdfEngineOpts = "pdf-engine-opts";
const kPdfEngineOpt = "pdf-engine-opt";
const kListings = "listings";
const kNumberSections = "number-sections";
const kNumberOffset = "number-offset";
const kShiftHeadingLevelBy = "shift-heading-level-by";
const kNumberDepth = "number-depth";
const kTopLevelDivision = "top-level-division";
const kPaperSize = "papersize";
const kLogFile = "log-file";
const kHighlightStyle = "highlight-style";
const kDefaultImageExtension = "default-image-extension";
const kLinkColor = "linkcolor";
const kColorLinks = "colorlinks";
const kVariables = "variables";
const kMetadataFile = "metadata-file";
const kMetadataFiles = "metadata-files";
const kSyntaxDefinitions = "syntax-definitions";
const kSyntaxDefinition = "syntax-definition";
const kReferenceDoc = "reference-doc";
const kHtmlMathMethod = "html-math-method";
const kToc = "toc";
const kTableOfContents = "table-of-contents";
const kSectionDivs = "section-divs";
const kEPubCoverImage = "epub-cover-image";
const kReferenceLocation = "reference-location";
const kCitationLocation = "citation-location";
const kQuartoVarsKey = "_quarto-vars";
const kQuartoTemplateParams = "quarto-template-params";
const kRevealJsScripts = "reveal-jsscripts";
const kTitle = "title";
const kSubtitle = "subtitle";
const kAuthor = "author";
const kDate = "date";
const kDateFormat = "date-format";
const kDoi = "doi";
const kAbstract = "abstract";
const kAbstractTitle = "abstract-title";
const kDescription = "description";
const kTocTitle = "toc-title";
const kTocLocation = "toc-location";
const kLang = "lang";
const kAuthors = "authors";
const kServer = "server";
const kPageTitle = "pagetitle";
const kTitlePrefix = "title-prefix";
const kCsl = "csl";
const kCss = "css";
const kBibliography = "bibliography";
const kHeaderIncludes = "header-includes";
const kIncludeBefore = "include-before";
const kIncludeAfter = "include-after";
const kLinkCitations = "link-citations";
const kDocumentClass = "documentclass";
const kClassOption = "classoption";
const kSlideLevel = "slide-level";
const kTheme = "theme";
const kCrossref = "crossref";
const kCrossrefChapters = "chapters";
const kCrossrefLabels = "labels";
const kCrossrefAppendixTitle = "appendix-title";
const kCrossrefAppendixDelim = "appendix-delim";
const kCrossrefChaptersAlpha = "chapters-alpha";
const kCrossrefChapterId = "chapter-id";
const kFigResponsive = "fig-responsive";
const kCapLoc = "cap-location";
const kFigCapLoc = "fig-cap-location";
const kTblCapLoc = "tbl-cap-location";
const kCapTop = "top";
const kCapBottom = "bottom";
const kPositionedRefs = "positioned-refs";
const kPandocDefaultsKeys = [
    kTo,
    kFrom,
    kReader,
    kWriter,
    kOutputFile,
    kInputFiles,
    "defaults",
    kTemplate,
    kStandalone,
    kSelfContained,
    kVariables,
    "metadata",
    kMetadataFiles,
    kMetadataFile,
    kIncludeBeforeBody,
    kIncludeAfterBody,
    kIncludeInHeader,
    "resource-path",
    kCiteproc,
    kCiteMethod,
    "citation-abbreviations",
    "filters",
    "file-scope",
    "data-dir",
    "verbosity",
    kLogFile,
    kTopLevelDivision,
    "abbreviations",
    kPdfEngine,
    kPdfEngineOpts,
    kPdfEngineOpt,
    kWrap,
    "columns",
    "dpi",
    "extract-media",
    kToc,
    kTableOfContents,
    "toc-depth",
    kNumberSections,
    kNumberOffset,
    kShiftHeadingLevelBy,
    kSectionDivs,
    "identifier-prefix",
    kTitlePrefix,
    "strip-empty-paragraphs",
    "eol",
    "strip-comments",
    "indented-code-classes",
    "ascii",
    kDefaultImageExtension,
    kHighlightStyle,
    kSyntaxDefinitions,
    kSyntaxDefinition,
    kListings,
    kReferenceDoc,
    kHtmlMathMethod,
    "email-obfuscation",
    "tab-stop",
    "preserve-tabs",
    "incremental",
    kSlideLevel,
    "epub-subdirectory",
    "epub-metadata",
    "epub-fonts",
    "epub-chapter-level",
    kEPubCoverImage,
    "reference-links",
    kReferenceLocation,
    kAtxHeaders,
    kMarkdownHeadings,
    "track-changes",
    "html-q-tags",
    "css",
    "ipynb-output",
    "request-headers",
    "fail-if-warnings",
    "dump-args",
    "ignore-args",
    "trace", 
];
const kCellCollapsed = "collapsed";
const kCellAutoscroll = "autoscroll";
const kCellDeletable = "deletable";
const kCellFormat = "format";
const kCellName = "name";
const kCellLinesToNext = "lines_to_next_cell";
const kCellLanguage = "language";
const kCellSlideshow = "slideshow";
const kCellSlideshowSlideType = "slide_type";
const kCellRawMimeType = "raw_mimetype";
const kCellId = "id";
const kCellLabel = "label";
const kCellFigCap = "fig-cap";
const kCellFigSubCap = "fig-subcap";
const kCellFigScap = "fig-scap";
const kCellFigColumn = "fig-column";
const kCellTblColumn = "tbl-column";
const kCellFigLink = "fig-link";
const kCellFigAlign = "fig-align";
const kCellFigEnv = "fig-env";
const kCellFigPos = "fig-pos";
const kCellFigAlt = "fig-alt";
const kCellLstLabel = "lst-label";
const kCellLstCap = "lst-cap";
const kCellClasses = "classes";
const kCellPanel = "panel";
const kCellColumn = "column";
const kCellOutWidth = "out-width";
const kCellOutHeight = "out-height";
const kCellMdIndent = "md-indent";
const kCellColab = "colab";
const kCellColabType = "colab_type";
const kCellColbOutputId = "outputId";
const kLayoutAlign = "layout-align";
const kLayoutVAlign = "layout-valign";
const kLayoutNcol = "layout-ncol";
const kLayoutNrow = "layout-nrow";
const kLayout = "layout";
async function readAndValidateYamlFromFile(file, schema89, errorMessage, defaultContents) {
    if (!existsSync(file)) {
        throw new Error(`YAML file ${file} not found.`);
    }
    let shortFileName = file;
    if (shortFileName.startsWith("/")) {
        shortFileName = relative2(Deno.cwd(), shortFileName);
    }
    let fileContents = Deno.readTextFileSync(file).trimEnd();
    if (fileContents.trim().length === 0 && defaultContents) {
        fileContents = defaultContents;
    }
    const contents = asMappedString(fileContents, shortFileName);
    const { yaml , yamlValidationErrors ,  } = await readAndValidateYamlFromMappedString(contents, schema89);
    if (yamlValidationErrors.length) {
        throw new ValidationError2(errorMessage, yamlValidationErrors);
    }
    return yaml;
}
async function includedMetadata(dir, baseMetadata, schema90) {
    const yamlFiles = [];
    const metadataFile = baseMetadata[kMetadataFile];
    if (metadataFile) {
        yamlFiles.push(join3(dir, metadataFile));
    }
    const metadataFiles = baseMetadata[kMetadataFiles];
    if (metadataFiles && Array.isArray(metadataFiles)) {
        metadataFiles.forEach((file)=>yamlFiles.push(join3(dir, file))
        );
    }
    const filesMetadata = await Promise.all(yamlFiles.map(async (yamlFile)=>{
        if (await exists(yamlFile)) {
            try {
                const yaml = await readAndValidateYamlFromFile(yamlFile, schema90, `Validation of metadata file ${yamlFile} failed.`);
                return yaml;
            } catch (e) {
                error("\nError reading metadata file from " + yamlFile + "\n");
                throw e;
            }
        } else {
            return undefined;
        }
    }));
    return {
        metadata: mergeFormatMetadata({}, ...filesMetadata),
        files: yamlFiles
    };
}
function formatFromMetadata(baseFormat, to, debug1) {
    const typedFormat = {
        render: {},
        execute: {},
        pandoc: {},
        language: {},
        metadata: {}
    };
    let format11 = typedFormat;
    const configFormats = baseFormat.metadata[kMetadataFormat];
    if (configFormats instanceof Object) {
        const configFormat = configFormats[to];
        if (configFormat === "default" || configFormat === true) {
            format11 = metadataAsFormat({});
        } else if (configFormat instanceof Object) {
            format11 = metadataAsFormat(configFormat);
        }
    }
    const mergedFormat = mergeFormatMetadata(baseFormat, format11);
    if (debug1) {
        mergedFormat.execute[kKeepMd] = true;
        mergedFormat.render[kKeepTex] = true;
    }
    return mergedFormat;
}
function formatKeys(metadata) {
    if (typeof metadata[kMetadataFormat] === "string") {
        return [
            metadata[kMetadataFormat]
        ];
    } else if (metadata[kMetadataFormat] instanceof Object) {
        return Object.keys(metadata[kMetadataFormat]).filter((key)=>{
            const format12 = metadata[kMetadataFormat][key];
            return format12 !== null && format12 !== false;
        });
    } else {
        return [];
    }
}
function isQuartoMetadata(key) {
    return kRenderDefaultsKeys.includes(key) || kExecuteDefaultsKeys.includes(key) || kPandocDefaultsKeys.includes(key) || kLanguageDefaultsKeys.includes(key);
}
function isIncludeMetadata(key) {
    return [
        kHeaderIncludes,
        kIncludeBefore,
        kIncludeAfter
    ].includes(key);
}
function metadataAsFormat(metadata) {
    const typedFormat = {
        render: {},
        execute: {},
        pandoc: {},
        language: {},
        metadata: {}
    };
    const format13 = typedFormat;
    Object.keys(metadata).forEach((key)=>{
        if ([
            kRenderDefaults,
            kExecuteDefaults,
            kPandocDefaults,
            kLanguageDefaults,
            kPandocMetadata, 
        ].includes(key)) {
            if (typeof metadata[key] == "boolean") {
                if (key === kExecuteDefaults) {
                    format13[key] = format13[key] || {};
                    format13[kExecuteDefaults][kExecuteEnabled] = metadata[key];
                }
            } else {
                format13[key] = {
                    ...format13[key],
                    ...metadata[key]
                };
            }
        } else {
            if (kRenderDefaultsKeys.includes(key)) {
                format13.render[key] = metadata[key];
            } else if (kExecuteDefaultsKeys.includes(key)) {
                format13.execute[key] = metadata[key];
            } else if (kPandocDefaultsKeys.includes(key)) {
                format13.pandoc[key] = metadata[key];
            } else if (kLanguageDefaultsKeys.includes(key)) {
                format13.language[key] = metadata[key];
            } else {
                format13.metadata[key] = metadata[key];
            }
        }
    });
    const filter2 = format13.execute[kIpynbFilter];
    if (typeof filter2 === "string") {
        typedFormat.execute[kIpynbFilters] = typedFormat.execute[kIpynbFilters] || [];
        typedFormat.execute[kIpynbFilters]?.push(filter2);
        delete typedFormat.execute[kIpynbFilter];
    }
    return typedFormat;
}
function metadataGetDeep(metadata, property1) {
    let values14 = [];
    __VIRTUAL_FILE145(metadata, (value, key)=>{
        if (key === property1) {
            values14.push(value);
        } else if (__VIRTUAL_FILE18(value)) {
            values14 = values14.concat(metadataGetDeep(value, property1));
        }
    });
    return values14;
}
const kUnmergeableKeys = [
    kTblColwidths
];
function mergeFormatMetadata(config3, ...configs) {
    config3 = cloneDeep1(config3);
    configs = cloneDeep1(configs);
    return __VIRTUAL_FILE154(config3, ...configs, (objValue, srcValue, key)=>{
        if (kUnmergeableKeys.includes(key)) {
            return srcValue;
        } else {
            return mergeArrayCustomizer(objValue, srcValue);
        }
    });
}
const kStdOut = "-";
async function parseRenderFlags(args) {
    const flags = {};
    const argsStack = [
        ...args
    ];
    let arg = argsStack.shift();
    while(arg !== undefined){
        switch(arg){
            case "-t":
            case "--to":
                arg = argsStack.shift();
                if (arg && !arg.startsWith("-")) {
                    flags.to = arg;
                }
                break;
            case "-o":
            case "--output":
                arg = argsStack.shift();
                if (!arg || arg.startsWith("-")) {
                    flags.output = kStdOut;
                } else {
                    flags.output = arg;
                }
                break;
            case "--output-dir":
                arg = argsStack.shift();
                flags.outputDir = arg;
                break;
            case "--site-url":
                arg = argsStack.shift();
                flags.siteUrl = arg;
                break;
            case "--self-contained":
                flags[kSelfContained] = true;
                arg = argsStack.shift();
                break;
            case "--pdf-engine":
                arg = argsStack.shift();
                flags.pdfEngine = arg;
                break;
            case "--pdf-engine-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.pdfEngineOpts = flags.pdfEngineOpts || [];
                    flags.pdfEngineOpts.push(arg);
                }
                break;
            case "--latex-makeindex-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.makeIndexOpts = flags.makeIndexOpts || [];
                    flags.makeIndexOpts.push(arg);
                }
                break;
            case "--latex-tlmgr-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.tlmgrOpts = flags.tlmgrOpts || [];
                    flags.tlmgrOpts.push(arg);
                }
                break;
            case "--natbib":
                arg = argsStack.shift();
                flags.natbib = true;
                break;
            case "--biblatex":
                arg = argsStack.shift();
                flags.biblatex = true;
                break;
            case `--${kToc}`:
            case `--${kTableOfContents}`:
                arg = argsStack.shift();
                flags.toc = true;
                break;
            case "--listings":
                arg = argsStack.shift();
                flags[kListings] = true;
                break;
            case "--number-sections":
                arg = argsStack.shift();
                flags[kNumberSections] = true;
                break;
            case "--number-offset":
                arg = argsStack.shift();
                flags[kNumberSections] = true;
                flags[kNumberOffset] = parseNumbers("--number-offset", arg);
                break;
            case "--top-level-division":
                arg = argsStack.shift();
                flags[kTopLevelDivision] = arg;
                break;
            case "--shift-heading-level-by":
                arg = argsStack.shift();
                flags[kShiftHeadingLevelBy] = arg;
                break;
            case "--include-in-header":
            case "--include-before-body":
            case "--include-after-body":
                {
                    const include1 = arg.replace("^--", "");
                    const includeFlags = flags;
                    includeFlags[include1] = includeFlags[include1] || [];
                    arg = argsStack.shift();
                    includeFlags[include1].push(arg);
                    break;
                }
            case "--mathjax":
                flags.mathjax = true;
                arg = argsStack.shift();
                break;
            case "--katex":
                flags.katex = true;
                arg = argsStack.shift();
                break;
            case "--mathml":
                flags.mathml = true;
                arg = argsStack.shift();
                break;
            case "--gladtex":
                flags.gladtex = true;
                arg = argsStack.shift();
                break;
            case "--webtex":
                flags.webtex = true;
                arg = argsStack.shift();
                break;
            case "--execute":
                flags.execute = true;
                arg = argsStack.shift();
                break;
            case "--no-execute":
                flags.execute = false;
                arg = argsStack.shift();
                break;
            case "--execute-params":
                arg = argsStack.shift();
                flags.paramsFile = arg;
                break;
            case "--execute-dir":
                arg = argsStack.shift();
                flags.executeDir = arg;
                break;
            case "--execute-daemon":
                arg = argsStack.shift();
                flags.executeDaemon = parseInt(arg, 10);
                if (isNaN(flags.executeDaemon)) {
                    delete flags.executeDaemon;
                }
                break;
            case "--no-execute-daemon":
                arg = argsStack.shift();
                flags.executeDaemon = 0;
                break;
            case "--execute-daemon-restart":
                arg = argsStack.shift();
                flags.executeDaemonRestart = true;
                break;
            case "--execute-debug":
                arg = argsStack.shift();
                flags.executeDebug = true;
                break;
            case "--use-freezer":
                arg = argsStack.shift();
                flags.useFreezer = true;
                break;
            case "--cache":
                arg = argsStack.shift();
                flags.executeCache = true;
                break;
            case "--no-cache":
                arg = argsStack.shift();
                flags.executeCache = false;
                break;
            case "--cache-refresh":
                arg = argsStack.shift();
                flags.executeCache = "refresh";
                break;
            case "--clean":
                arg = argsStack.shift();
                flags.clean = true;
                break;
            case "--no-clean":
                arg = argsStack.shift();
                flags.clean = false;
                break;
            case "--debug":
                flags.debug = true;
                arg = argsStack.shift();
                break;
            case "-P":
            case "--execute-param":
                arg = argsStack.shift();
                if (arg) {
                    const param = parseMetadataFlagValue(arg);
                    if (param) {
                        if (param.value !== undefined) {
                            flags.params = flags.params || {};
                            flags.params[param.name] = param.value;
                        }
                    }
                }
                break;
            case "-M":
            case "--metadata":
                arg = argsStack.shift();
                if (arg) {
                    const metadata = parseMetadataFlagValue(arg);
                    if (metadata) {
                        if (metadata.value !== undefined) {
                            if (isQuartoMetadata(metadata.name)) {
                                flags.metadata = flags.metadata || {};
                                flags.metadata[metadata.name] = metadata.value;
                            } else {
                                flags.pandocMetadata = flags.pandocMetadata || {};
                                flags.pandocMetadata[metadata.name] = metadata.value;
                            }
                        }
                    }
                }
                break;
            case "--metadata-file":
                arg = argsStack.shift();
                if (arg) {
                    if (existsSync(arg)) {
                        const metadata = await readYamlFromString(Deno.readTextFileSync(arg));
                        flags.metadata = {
                            ...flags.metadata,
                            ...metadata
                        };
                    }
                }
                break;
            case "--reference-location":
                arg = argsStack.shift();
                if (arg) {
                    flags[kReferenceLocation] = arg;
                }
                break;
            default:
                arg = argsStack.shift();
                break;
        }
    }
    if (flags.clean === undefined) {
        flags.clean = true;
    }
    return flags;
}
function havePandocArg(pandocArgs, arg) {
    return pandocArgs.indexOf(arg) !== -1;
}
function replacePandocArg(pandocArgs, arg, value) {
    const newArgs = [
        ...pandocArgs
    ];
    const argIndex = pandocArgs.indexOf(arg);
    if (argIndex !== -1) {
        newArgs[argIndex + 1] = value;
    } else {
        newArgs.push(arg);
        newArgs.push(value);
    }
    return newArgs;
}
function getPandocArg(pandocArgs, arg) {
    const argIndex = pandocArgs.indexOf(arg);
    if (argIndex !== -1 && argIndex + 1 < pandocArgs.length) {
        return pandocArgs[argIndex + 1];
    } else {
        return undefined;
    }
}
function replacePandocOutputArg(pandocArgs, output) {
    if (havePandocArg(pandocArgs, "--output")) {
        return replacePandocArg(pandocArgs, "--output", output);
    } else if (havePandocArg(pandocArgs, "-o")) {
        return replacePandocArg(pandocArgs, "-o", output);
    } else {
        return pandocArgs;
    }
}
function fixupPandocArgs(pandocArgs, flags) {
    pandocArgs = pandocArgs.reduce((args, arg, index)=>{
        args.push(arg);
        if (flags.output === kStdOut && pandocArgs[index + 1] !== kStdOut && (arg === "-o" || arg === "--output")) {
            args.push(kStdOut);
        }
        return args;
    }, new Array());
    const removeArgs = new Map();
    removeArgs.set("--output-dir", true);
    removeArgs.set("--site-url", true);
    removeArgs.set("--execute", false);
    removeArgs.set("--no-execute", false);
    removeArgs.set("-P", true);
    removeArgs.set("--execute-param", true);
    removeArgs.set("--execute-params", true);
    removeArgs.set("--execute-dir", true);
    removeArgs.set("--execute-daemon", true);
    removeArgs.set("--no-execute-daemon", false);
    removeArgs.set("--execute-daemon-restart", false);
    removeArgs.set("--execute-debug", false);
    removeArgs.set("--use-freezer", false);
    removeArgs.set("--cache", false);
    removeArgs.set("--no-cache", false);
    removeArgs.set("--cache-refresh", false);
    removeArgs.set("--clean", false);
    removeArgs.set("--no-clean", false);
    removeArgs.set("--debug", false);
    removeArgs.set("--metadata-file", true);
    removeArgs.set("--latex-makeindex-opt", true);
    removeArgs.set("--latex-tlmgr-opt", true);
    removeArgs.set("--log", true);
    removeArgs.set("--l", true);
    removeArgs.set("--log-level", true);
    removeArgs.set("--ll", true);
    removeArgs.set("--log-format", true);
    removeArgs.set("--lf", true);
    removeArgs.set("--quiet", false);
    removeArgs.set("--q", false);
    pandocArgs = removePandocArgs(pandocArgs, removeArgs);
    return removeQuartoMetadataFlags(pandocArgs);
}
function removePandocArgs(pandocArgs, removeArgs) {
    let removeNext = false;
    return pandocArgs.reduce((args, arg)=>{
        if (!removeArgs.has(arg)) {
            if (!removeNext) {
                args.push(arg);
            }
            removeNext = false;
        } else {
            removeNext = removeArgs.get(arg);
        }
        return args;
    }, new Array());
}
function removePandocToArg(args) {
    const removeArgs = new Map();
    removeArgs.set("--to", true);
    removeArgs.set("-t", true);
    return removePandocArgs(args, removeArgs);
}
function removePandocTo(renderOptions) {
    renderOptions = cloneDeep1(renderOptions);
    delete renderOptions.flags?.to;
    if (renderOptions.pandocArgs) {
        renderOptions.pandocArgs = removePandocToArg(renderOptions.pandocArgs);
    }
    return renderOptions;
}
function removeQuartoMetadataFlags(pandocArgs) {
    const args = [];
    for(let i62 = 0; i62 < pandocArgs.length; i62++){
        const arg = pandocArgs[i62];
        if (arg === "--metadata" || arg === "-M") {
            const flagValue = parseMetadataFlagValue(pandocArgs[i62 + 1] || "");
            if (flagValue !== undefined && isQuartoMetadata(flagValue.name)) {
                i62++;
            } else {
                args.push(arg);
            }
        } else {
            args.push(arg);
        }
    }
    return args;
}
function parseMetadataFlagValue(arg) {
    const match = arg.match(/^([^=:]+)[=:](.*)$/);
    if (match) {
        return {
            name: match[1],
            value: readYamlFromString(match[2])
        };
    }
    return undefined;
}
function resolveParams(params, paramsFile) {
    if (params || paramsFile) {
        params = params || {};
        if (paramsFile) {
            params = mergeConfigs(readYaml(paramsFile), params);
        }
        return params;
    } else {
        return undefined;
    }
}
function parseNumbers(flag, value) {
    if (value) {
        const numbers = value.split(/,/).map((number3)=>parseInt(number3.trim(), 10)
        ).filter((number4)=>!isNaN(number4)
        );
        if (numbers.length > 0) {
            return numbers;
        }
    }
    throw new Error(`Invalid value for ${flag} (should be a comma separated list of numbers)`);
}
const importMeta = {
    url: "file:///home/runner/work/quarto-cli/quarto-cli/src/vendor/deno.land/x/deno_dom@v0.1.20-alpha/build/deno-wasm/deno-wasm.js",
    main: false
};
let wasm;
let WASM_VECTOR_LEN = 0;
let cachegetUint8Memory0 = null;
function getUint8Memory0() {
    if (cachegetUint8Memory0 === null || cachegetUint8Memory0.buffer !== wasm.memory.buffer) {
        cachegetUint8Memory0 = new Uint8Array(wasm.memory.buffer);
    }
    return cachegetUint8Memory0;
}
let cachedTextEncoder = new TextEncoder('utf-8');
const encodeString = typeof cachedTextEncoder.encodeInto === 'function' ? function(arg, view) {
    return cachedTextEncoder.encodeInto(arg, view);
} : function(arg, view) {
    const buf = cachedTextEncoder.encode(arg);
    view.set(buf);
    return {
        read: arg.length,
        written: buf.length
    };
};
function passStringToWasm0(arg, malloc, realloc) {
    if (realloc === undefined) {
        const buf = cachedTextEncoder.encode(arg);
        const ptr = malloc(buf.length);
        getUint8Memory0().subarray(ptr, ptr + buf.length).set(buf);
        WASM_VECTOR_LEN = buf.length;
        return ptr;
    }
    let len2 = arg.length;
    let ptr = malloc(len2);
    const mem = getUint8Memory0();
    let offset = 0;
    for(; offset < len2; offset++){
        const code21 = arg.charCodeAt(offset);
        if (code21 > 0x7F) break;
        mem[ptr + offset] = code21;
    }
    if (offset !== len2) {
        if (offset !== 0) {
            arg = arg.slice(offset);
        }
        ptr = realloc(ptr, len2, len2 = offset + arg.length * 3);
        const view = getUint8Memory0().subarray(ptr + offset, ptr + len2);
        const ret = encodeString(arg, view);
        offset += ret.written;
    }
    WASM_VECTOR_LEN = offset;
    return ptr;
}
let cachegetInt32Memory0 = null;
function getInt32Memory0() {
    if (cachegetInt32Memory0 === null || cachegetInt32Memory0.buffer !== wasm.memory.buffer) {
        cachegetInt32Memory0 = new Int32Array(wasm.memory.buffer);
    }
    return cachegetInt32Memory0;
}
let cachedTextDecoder = new TextDecoder('utf-8', {
    ignoreBOM: true,
    fatal: true
});
cachedTextDecoder.decode();
function getStringFromWasm0(ptr, len3) {
    return cachedTextDecoder.decode(getUint8Memory0().subarray(ptr, ptr + len3));
}
function parse4(html) {
    try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        var ptr0 = passStringToWasm0(html, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        var len0 = WASM_VECTOR_LEN;
        wasm.parse(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
    } finally{
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
    }
}
function parse_frag(html) {
    try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        var ptr0 = passStringToWasm0(html, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        var len0 = WASM_VECTOR_LEN;
        wasm.parse_frag(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
    } finally{
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
    }
}
async function load2(module, imports3) {
    if (typeof Response === 'function' && module instanceof Response) {
        if (typeof WebAssembly.instantiateStreaming === 'function') {
            try {
                return await WebAssembly.instantiateStreaming(module, imports3);
            } catch (e) {
                if (module.headers.get('Content-Type') != 'application/wasm') {
                    console.warn("`WebAssembly.instantiateStreaming` failed because your server does not serve wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", e);
                } else {
                    throw e;
                }
            }
        }
        const bytes = await module.arrayBuffer();
        return await WebAssembly.instantiate(bytes, imports3);
    } else {
        const instance = await WebAssembly.instantiate(module, imports3);
        if (instance instanceof WebAssembly.Instance) {
            return {
                instance,
                module
            };
        } else {
            return instance;
        }
    }
}
async function init(input) {
    if (typeof input === 'undefined') {
        input = new URL('deno-wasm_bg.wasm', importMeta.url);
    }
    const imports4 = {};
    imports4.env = {
        now () {}
    };
    input = Uint8Array.from(atob("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