import { Buffer } from "./buffer.ts";
export class StringReader extends Buffer {
    constructor(s) {
        super(new TextEncoder().encode(s).buffer);
    }
}
export class MultiReader {
    #readers;
    #currentIndex = 0;
    constructor(readers) {
        this.#readers = [...readers];
    }
    async read(p) {
        const r = this.#readers[this.#currentIndex];
        if (!r)
            return null;
        const result = await r.read(p);
        if (result === null) {
            this.#currentIndex++;
            return 0;
        }
        return result;
    }
}
export class LimitedReader {
    reader;
    limit;
    constructor(reader, limit) {
        this.reader = reader;
        this.limit = limit;
    }
    async read(p) {
        if (this.limit <= 0) {
            return null;
        }
        if (p.length > this.limit) {
            p = p.subarray(0, this.limit);
        }
        const n = await this.reader.read(p);
        if (n == null) {
            return null;
        }
        this.limit -= n;
        return n;
    }
}
//# sourceMappingURL=data:application/json;base64,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