import { instantiate } from "./lib/deno_hash.generated.mjs";
import * as hex from "../../encoding/hex.ts";
import * as base64 from "../../encoding/base64.ts";
export class Hash {
    #hash;
    #digested;
    constructor(algorithm) {
        this.#hash = instantiate().create_hash(algorithm);
        this.#digested = false;
    }
    update(message) {
        let view;
        if (message instanceof Uint8Array) {
            view = message;
        }
        else if (typeof message === "string") {
            view = new TextEncoder().encode(message);
        }
        else if (ArrayBuffer.isView(message)) {
            view = new Uint8Array(message.buffer, message.byteOffset, message.byteLength);
        }
        else if (message instanceof ArrayBuffer) {
            view = new Uint8Array(message);
        }
        else {
            throw new Error("hash: `data` is invalid type");
        }
        const chunkSize = 65_536;
        const updateHash = instantiate().update_hash;
        for (let offset = 0; offset < view.byteLength; offset += chunkSize) {
            updateHash(this.#hash, new Uint8Array(view.buffer, view.byteOffset + offset, Math.min(chunkSize, view.byteLength - offset)));
        }
        return this;
    }
    digest() {
        if (this.#digested)
            throw new Error("hash: already digested");
        this.#digested = true;
        return instantiate().digest_hash(this.#hash);
    }
    toString(format = "hex") {
        const finalized = new Uint8Array(this.digest());
        switch (format) {
            case "hex":
                return new TextDecoder().decode(hex.encode(finalized));
            case "base64":
                return base64.encode(finalized);
            default:
                throw new Error("hash: invalid format");
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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