const decoder = new TextDecoder();
export class StringWriter {
    base;
    #chunks = [];
    #byteLength = 0;
    #cache;
    constructor(base = "") {
        this.base = base;
        const c = new TextEncoder().encode(base);
        this.#chunks.push(c);
        this.#byteLength += c.byteLength;
    }
    write(p) {
        return Promise.resolve(this.writeSync(p));
    }
    writeSync(p) {
        this.#chunks.push(p);
        this.#byteLength += p.byteLength;
        this.#cache = undefined;
        return p.byteLength;
    }
    toString() {
        if (this.#cache) {
            return this.#cache;
        }
        const buf = new Uint8Array(this.#byteLength);
        let offs = 0;
        for (const chunk of this.#chunks) {
            buf.set(chunk, offs);
            offs += chunk.byteLength;
        }
        this.#cache = decoder.decode(buf);
        return this.#cache;
    }
}
//# sourceMappingURL=data:application/json;base64,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