import { bytesToUuid, uuidToBytes } from "./_common.ts";
import { concat } from "../bytes/mod.ts";
import { assert } from "../_util/assert.ts";
const UUID_RE = /^[0-9a-f]{8}-[0-9a-f]{4}-[5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
export function validate(id) {
    return UUID_RE.test(id);
}
export async function generate(namespace, data) {
    const space = uuidToBytes(namespace);
    assert(space.length === 16, "namespace must be a valid UUID");
    const toHash = concat(new Uint8Array(space), data);
    const buffer = await crypto.subtle.digest("sha-1", toHash);
    const bytes = new Uint8Array(buffer);
    bytes[6] = (bytes[6] & 0x0f) | 0x50;
    bytes[8] = (bytes[8] & 0x3f) | 0x80;
    return bytesToUuid(bytes);
}
//# sourceMappingURL=data:application/json;base64,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