const { PermissionDenied } = Deno.errors;
function getPermissionString(descriptors) {
    return descriptors.length
        ? `  ${descriptors
            .map((pd) => {
            switch (pd.name) {
                case "read":
                case "write":
                    return pd.path
                        ? `--allow-${pd.name}=${pd.path}`
                        : `--allow-${pd.name}`;
                case "net":
                    return pd.host
                        ? `--allow-${pd.name}=${pd.host}`
                        : `--allow-${pd.name}`;
                default:
                    return `--allow-${pd.name}`;
            }
        })
            .join("\n  ")}`
        : "";
}
export async function grant(descriptor, ...descriptors) {
    const result = [];
    descriptors = Array.isArray(descriptor)
        ? descriptor
        : [descriptor, ...descriptors];
    for (const descriptor of descriptors) {
        let state = (await Deno.permissions.query(descriptor)).state;
        if (state === "prompt") {
            state = (await Deno.permissions.request(descriptor)).state;
        }
        if (state === "granted") {
            result.push(descriptor);
        }
    }
    return result.length ? result : undefined;
}
export async function grantOrThrow(descriptor, ...descriptors) {
    const denied = [];
    descriptors = Array.isArray(descriptor)
        ? descriptor
        : [descriptor, ...descriptors];
    for (const descriptor of descriptors) {
        const { state } = await Deno.permissions.request(descriptor);
        if (state !== "granted") {
            denied.push(descriptor);
        }
    }
    if (denied.length) {
        throw new PermissionDenied(`The following permissions have not been granted:\n${getPermissionString(denied)}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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