export function joinToString(array, selector, { separator = ",", prefix = "", suffix = "", limit = -1, truncated = "...", } = {}) {
    let result = "";
    let index = -1;
    while (++index < array.length) {
        const el = array[index];
        if (index > 0) {
            result += separator;
        }
        if (limit > -1 && index >= limit) {
            result += truncated;
            break;
        }
        result += selector(el);
    }
    result = prefix + result + suffix;
    return result;
}
//# sourceMappingURL=data:application/json;base64,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