import * as base64 from "./base64.ts";
export function addPaddingToBase64url(base64url) {
    if (base64url.length % 4 === 2)
        return base64url + "==";
    if (base64url.length % 4 === 3)
        return base64url + "=";
    if (base64url.length % 4 === 1) {
        throw new TypeError("Illegal base64url string!");
    }
    return base64url;
}
function convertBase64urlToBase64(b64url) {
    if (!/^[-_A-Z0-9]*?={0,2}$/i.test(b64url)) {
        throw new TypeError("Failed to decode base64url: invalid character");
    }
    return addPaddingToBase64url(b64url).replace(/\-/g, "+").replace(/_/g, "/");
}
function convertBase64ToBase64url(b64) {
    return b64.replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
}
export function encode(data) {
    return convertBase64ToBase64url(base64.encode(data));
}
export function decode(b64url) {
    return base64.decode(convertBase64urlToBase64(b64url));
}
//# sourceMappingURL=data:application/json;base64,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