export var LogLevels;
(function (LogLevels) {
    LogLevels[LogLevels["NOTSET"] = 0] = "NOTSET";
    LogLevels[LogLevels["DEBUG"] = 10] = "DEBUG";
    LogLevels[LogLevels["INFO"] = 20] = "INFO";
    LogLevels[LogLevels["WARNING"] = 30] = "WARNING";
    LogLevels[LogLevels["ERROR"] = 40] = "ERROR";
    LogLevels[LogLevels["CRITICAL"] = 50] = "CRITICAL";
})(LogLevels || (LogLevels = {}));
export const LogLevelNames = Object.keys(LogLevels).filter((key) => isNaN(Number(key)));
const byLevel = {
    [String(LogLevels.NOTSET)]: "NOTSET",
    [String(LogLevels.DEBUG)]: "DEBUG",
    [String(LogLevels.INFO)]: "INFO",
    [String(LogLevels.WARNING)]: "WARNING",
    [String(LogLevels.ERROR)]: "ERROR",
    [String(LogLevels.CRITICAL)]: "CRITICAL",
};
export function getLevelByName(name) {
    switch (name) {
        case "NOTSET":
            return LogLevels.NOTSET;
        case "DEBUG":
            return LogLevels.DEBUG;
        case "INFO":
            return LogLevels.INFO;
        case "WARNING":
            return LogLevels.WARNING;
        case "ERROR":
            return LogLevels.ERROR;
        case "CRITICAL":
            return LogLevels.CRITICAL;
        default:
            throw new Error(`no log level found for "${name}"`);
    }
}
export function getLevelName(level) {
    const levelName = byLevel[level];
    if (levelName) {
        return levelName;
    }
    throw new Error(`no level name found for level: ${level}`);
}
//# sourceMappingURL=data:application/json;base64,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