import * as v1 from "./v1.ts";
import * as v4 from "./v4.ts";
import * as v5 from "./v5.ts";
export const NIL_UUID = "00000000-0000-0000-0000-000000000000";
export function isNil(id) {
    return id === NIL_UUID;
}
export function validate(uuid) {
    return /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i
        .test(uuid);
}
export { v1, v4, v5 };
//# sourceMappingURL=data:application/json;base64,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