export class BSNode {
    parent;
    value;
    left;
    right;
    constructor(parent, value) {
        this.parent = parent;
        this.value = value;
        this.left = null;
        this.right = null;
    }
    static from(node) {
        const copy = new BSNode(node.parent, node.value);
        copy.left = node.left;
        copy.right = node.right;
        return copy;
    }
    directionFromParent() {
        return this.parent === null
            ? null
            : this === this.parent.left
                ? "left"
                : this === this.parent.right
                    ? "right"
                    : null;
    }
    findMinNode() {
        let minNode = this.left;
        while (minNode?.left)
            minNode = minNode.left;
        return minNode ?? this;
    }
    findMaxNode() {
        let maxNode = this.right;
        while (maxNode?.right)
            maxNode = maxNode.right;
        return maxNode ?? this;
    }
    findSuccessorNode() {
        if (this.right !== null)
            return this.right.findMinNode();
        let parent = this.parent;
        let direction = this.directionFromParent();
        while (parent && direction === "right") {
            direction = parent.directionFromParent();
            parent = parent.parent;
        }
        return parent;
    }
}
//# sourceMappingURL=data:application/json;base64,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