export var EOL;
(function (EOL) {
    EOL["LF"] = "\n";
    EOL["CRLF"] = "\r\n";
})(EOL || (EOL = {}));
const regDetect = /(?:\r?\n)/g;
export function detect(content) {
    const d = content.match(regDetect);
    if (!d || d.length === 0) {
        return null;
    }
    const hasCRLF = d.some((x) => x === EOL.CRLF);
    return hasCRLF ? EOL.CRLF : EOL.LF;
}
export function format(content, eol) {
    return content.replace(regDetect, eol);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW9sLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZW9sLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUdBLE1BQU0sQ0FBTixJQUFZLEdBR1g7QUFIRCxXQUFZLEdBQUc7SUFDYixnQkFBUyxDQUFBO0lBQ1Qsb0JBQWEsQ0FBQTtBQUNmLENBQUMsRUFIVyxHQUFHLEtBQUgsR0FBRyxRQUdkO0FBRUQsTUFBTSxTQUFTLEdBQUcsWUFBWSxDQUFDO0FBTS9CLE1BQU0sVUFBVSxNQUFNLENBQUMsT0FBZTtJQUNwQyxNQUFNLENBQUMsR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ25DLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7UUFDeEIsT0FBTyxJQUFJLENBQUM7S0FDYjtJQUNELE1BQU0sT0FBTyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFTLEVBQVcsRUFBRSxDQUFDLENBQUMsS0FBSyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7SUFFL0QsT0FBTyxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7QUFDckMsQ0FBQztBQUdELE1BQU0sVUFBVSxNQUFNLENBQUMsT0FBZSxFQUFFLEdBQVE7SUFDOUMsT0FBTyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsQ0FBQztBQUN6QyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyMSB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cblxuLyoqIEVuZE9mTGluZSBjaGFyYWN0ZXIgZW51bSAqL1xuZXhwb3J0IGVudW0gRU9MIHtcbiAgTEYgPSBcIlxcblwiLFxuICBDUkxGID0gXCJcXHJcXG5cIixcbn1cblxuY29uc3QgcmVnRGV0ZWN0ID0gLyg/Olxccj9cXG4pL2c7XG5cbi8qKlxuICogRGV0ZWN0IHRoZSBFT0wgY2hhcmFjdGVyIGZvciBzdHJpbmcgaW5wdXQuXG4gKiByZXR1cm5zIG51bGwgaWYgbm8gbmV3bGluZVxuICovXG5leHBvcnQgZnVuY3Rpb24gZGV0ZWN0KGNvbnRlbnQ6IHN0cmluZyk6IEVPTCB8IG51bGwge1xuICBjb25zdCBkID0gY29udGVudC5tYXRjaChyZWdEZXRlY3QpO1xuICBpZiAoIWQgfHwgZC5sZW5ndGggPT09IDApIHtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICBjb25zdCBoYXNDUkxGID0gZC5zb21lKCh4OiBzdHJpbmcpOiBib29sZWFuID0+IHggPT09IEVPTC5DUkxGKTtcblxuICByZXR1cm4gaGFzQ1JMRiA/IEVPTC5DUkxGIDogRU9MLkxGO1xufVxuXG4vKiogRm9ybWF0IHRoZSBmaWxlIHRvIHRoZSB0YXJnZXRlZCBFT0wgKi9cbmV4cG9ydCBmdW5jdGlvbiBmb3JtYXQoY29udGVudDogc3RyaW5nLCBlb2w6IEVPTCk6IHN0cmluZyB7XG4gIHJldHVybiBjb250ZW50LnJlcGxhY2UocmVnRGV0ZWN0LCBlb2wpO1xufVxuIl19