import { bytesToUuid } from "./_common.ts";
const UUID_RE = /^[0-9a-f]{8}-[0-9a-f]{4}-1[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
export function validate(id) {
    return UUID_RE.test(id);
}
let _nodeId;
let _clockseq;
let _lastMSecs = 0;
let _lastNSecs = 0;
export function generate(options, buf, offset) {
    let i = (buf && offset) || 0;
    const b = buf ?? [];
    options ??= {};
    let { node = _nodeId, clockseq = _clockseq } = options;
    if (node === undefined || clockseq === undefined) {
        const seedBytes = options.random ??
            options.rng ??
            crypto.getRandomValues(new Uint8Array(16));
        if (node === undefined) {
            node = _nodeId = [
                seedBytes[0] | 0x01,
                seedBytes[1],
                seedBytes[2],
                seedBytes[3],
                seedBytes[4],
                seedBytes[5],
            ];
        }
        if (clockseq === undefined) {
            clockseq = _clockseq = ((seedBytes[6] << 8) | seedBytes[7]) & 0x3fff;
        }
    }
    let { msecs = new Date().getTime(), nsecs = _lastNSecs + 1 } = options;
    const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000;
    if (dt < 0 && options.clockseq === undefined) {
        clockseq = (clockseq + 1) & 0x3fff;
    }
    if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
        nsecs = 0;
    }
    if (nsecs > 10000) {
        throw new Error("Can't create more than 10M uuids/sec");
    }
    _lastMSecs = msecs;
    _lastNSecs = nsecs;
    _clockseq = clockseq;
    msecs += 12219292800000;
    const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
    b[i++] = (tl >>> 24) & 0xff;
    b[i++] = (tl >>> 16) & 0xff;
    b[i++] = (tl >>> 8) & 0xff;
    b[i++] = tl & 0xff;
    const tmh = ((msecs / 0x100000000) * 10000) & 0xfffffff;
    b[i++] = (tmh >>> 8) & 0xff;
    b[i++] = tmh & 0xff;
    b[i++] = ((tmh >>> 24) & 0xf) | 0x10;
    b[i++] = (tmh >>> 16) & 0xff;
    b[i++] = (clockseq >>> 8) | 0x80;
    b[i++] = clockseq & 0xff;
    for (let n = 0; n < 6; ++n) {
        b[i + n] = node[n];
    }
    return buf ?? bytesToUuid(b);
}
//# sourceMappingURL=data:application/json;base64,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