import { create_hash as createHash, digest_hash as digestHash, update_hash as updateHash, } from "./wasm.js";
import * as hex from "../../encoding/hex.ts";
import * as base64 from "../../encoding/base64.ts";
export class Hash {
    #hash;
    #digested;
    constructor(algorithm) {
        this.#hash = createHash(algorithm);
        this.#digested = false;
    }
    update(message) {
        let view;
        if (message instanceof Uint8Array) {
            view = message;
        }
        else if (typeof message === "string") {
            view = new TextEncoder().encode(message);
        }
        else if (ArrayBuffer.isView(message)) {
            view = new Uint8Array(message.buffer, message.byteOffset, message.byteLength);
        }
        else if (message instanceof ArrayBuffer) {
            view = new Uint8Array(message);
        }
        else {
            throw new Error("hash: `data` is invalid type");
        }
        const chunkSize = 65_536;
        for (let offset = 0; offset < view.byteLength; offset += chunkSize) {
            updateHash(this.#hash, new Uint8Array(view.buffer, view.byteOffset + offset, Math.min(chunkSize, view.byteLength - offset)));
        }
        return this;
    }
    digest() {
        if (this.#digested)
            throw new Error("hash: already digested");
        this.#digested = true;
        return digestHash(this.#hash);
    }
    toString(format = "hex") {
        const finalized = new Uint8Array(this.digest());
        switch (format) {
            case "hex":
                return new TextDecoder().decode(hex.encode(finalized));
            case "base64":
                return base64.encode(finalized);
            default:
                throw new Error("hash: invalid format");
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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