import { MuxAsyncIterator } from "../async/mux_async_iterator.ts";
import { deferred } from "../async/deferred.ts";
export function signal(...signals) {
    const mux = new MuxAsyncIterator();
    if (signals.length < 1) {
        throw new Error("No signals are given. You need to specify at least one signal to create a signal stream.");
    }
    const streams = signals.map(createSignalStream);
    streams.forEach((stream) => {
        mux.add(stream);
    });
    const dispose = () => {
        streams.forEach((stream) => {
            stream.dispose();
        });
    };
    return Object.assign(mux, { dispose });
}
function createSignalStream(signal) {
    let streamContinues = deferred();
    const handler = () => {
        streamContinues.resolve(true);
    };
    Deno.addSignalListener(signal, handler);
    const gen = async function* () {
        while (await streamContinues) {
            streamContinues = deferred();
            yield undefined;
        }
    };
    return Object.assign(gen(), {
        dispose() {
            streamContinues.resolve(false);
            Deno.removeSignalListener(signal, handler);
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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