import { assert } from "./assert.ts";
export function deepAssign(target, ...sources) {
    for (let i = 0; i < sources.length; i++) {
        const source = sources[i];
        if (!source || typeof source !== `object`) {
            return;
        }
        Object.entries(source).forEach(([key, value]) => {
            if (value instanceof Date) {
                target[key] = new Date(value);
                return;
            }
            if (value instanceof RegExp) {
                target[key] = new RegExp(value);
                return;
            }
            if (!value || typeof value !== `object`) {
                target[key] = value;
                return;
            }
            if (Array.isArray(value)) {
                target[key] = [];
            }
            if (typeof target[key] !== `object` || !target[key]) {
                target[key] = {};
            }
            assert(value);
            deepAssign(target[key], value);
        });
    }
    return target;
}
//# sourceMappingURL=data:application/json;base64,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