

// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module = typeof Module !== 'undefined' ? Module : {};

// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
var TreeSitter = function() {
  var initPromise;
  class Parser {
    constructor() {
      this.initialize();
    }

    initialize() {
      throw new Error("cannot construct a Parser before calling `init()`");
    }

    static init(moduleOptions) {
      if (initPromise) return initPromise;
      Module = Object.assign({ }, Module, moduleOptions);
      return initPromise = new Promise((resolveInitPromise) => {



// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

var arguments_ = [];
var thisProgram = './this.program';
var quit_ = function(status, toThrow) {
  throw toThrow;
};

// Determine the runtime environment we are in. You can customize this by
// setting the ENVIRONMENT setting at compile time (see settings.js).

var ENVIRONMENT_IS_WEB = false;
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_NODE = false;
var ENVIRONMENT_IS_SHELL = false;
ENVIRONMENT_IS_WEB = typeof window === 'object';
ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
// N.b. Electron.js environment is simultaneously a NODE-environment, but
// also a web environment.
ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof process.versions === 'object' && typeof process.versions.node === 'string';
ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (Module['ENVIRONMENT']) {
  throw new Error('Module.ENVIRONMENT has been deprecated. To force the environment, use the ENVIRONMENT compile-time option (for example, -s ENVIRONMENT=web or -s ENVIRONMENT=node)');
}

// `/` should be present at the end if `scriptDirectory` is not empty
var scriptDirectory = '';
function locateFile(path) {
  if (Module['locateFile']) {
    return Module['locateFile'](path, scriptDirectory);
  }
  return scriptDirectory + path;
}

// Hooks that are implemented differently in different runtime environments.
var read_,
    readAsync,
    readBinary,
    setWindowTitle;

var nodeFS;
var nodePath;

if (ENVIRONMENT_IS_NODE) {
  if (ENVIRONMENT_IS_WORKER) {
    scriptDirectory = require('path').dirname(scriptDirectory) + '/';
  } else {
    scriptDirectory = __dirname + '/';
  }

// include: node_shell_read.js


read_ = function shell_read(filename, binary) {
  var ret = tryParseAsDataURI(filename);
  if (ret) {
    return binary ? ret : ret.toString();
  }
  if (!nodeFS) nodeFS = require('fs');
  if (!nodePath) nodePath = require('path');
  filename = nodePath['normalize'](filename);
  return nodeFS['readFileSync'](filename, binary ? null : 'utf8');
};

readBinary = function readBinary(filename) {
  var ret = read_(filename, true);
  if (!ret.buffer) {
    ret = new Uint8Array(ret);
  }
  assert(ret.buffer);
  return ret;
};

// end include: node_shell_read.js
  if (process['argv'].length > 1) {
    thisProgram = process['argv'][1].replace(/\\/g, '/');
  }

  arguments_ = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  quit_ = function(status) {
    process['exit'](status);
  };

  Module['inspect'] = function () { return '[Emscripten Module object]'; };

} else
if (ENVIRONMENT_IS_SHELL) {

  if (typeof read != 'undefined') {
    read_ = function shell_read(f) {
      var data = tryParseAsDataURI(f);
      if (data) {
        return intArrayToString(data);
      }
      return read(f);
    };
  }

  readBinary = function readBinary(f) {
    var data;
    data = tryParseAsDataURI(f);
    if (data) {
      return data;
    }
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    arguments_ = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    arguments_ = arguments;
  }

  if (typeof quit === 'function') {
    quit_ = function(status) {
      quit(status);
    };
  }

  if (typeof print !== 'undefined') {
    // Prefer to use print/printErr where they exist, as they usually work better.
    if (typeof console === 'undefined') console = /** @type{!Console} */({});
    console.log = /** @type{!function(this:Console, ...*): undefined} */ (print);
    console.warn = console.error = /** @type{!function(this:Console, ...*): undefined} */ (typeof printErr !== 'undefined' ? printErr : print);
  }

} else

// Note that this includes Node.js workers when relevant (pthreads is enabled).
// Node.js workers are detected as a combination of ENVIRONMENT_IS_WORKER and
// ENVIRONMENT_IS_NODE.
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  if (ENVIRONMENT_IS_WORKER) { // Check worker, not web, since window could be polyfilled
    scriptDirectory = self.location.href;
  } else if (typeof document !== 'undefined' && document.currentScript) { // web
    scriptDirectory = document.currentScript.src;
  }
  // blob urls look like blob:http://site.com/etc/etc and we cannot infer anything from them.
  // otherwise, slice off the final part of the url to find the script directory.
  // if scriptDirectory does not contain a slash, lastIndexOf will return -1,
  // and scriptDirectory will correctly be replaced with an empty string.
  if (scriptDirectory.indexOf('blob:') !== 0) {
    scriptDirectory = scriptDirectory.substr(0, scriptDirectory.lastIndexOf('/')+1);
  } else {
    scriptDirectory = '';
  }

  // Differentiate the Web Worker from the Node Worker case, as reading must
  // be done differently.
  {

// include: web_or_worker_shell_read.js


  read_ = function(url) {
    try {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, false);
      xhr.send(null);
      return xhr.responseText;
    } catch (err) {
      var data = tryParseAsDataURI(url);
      if (data) {
        return intArrayToString(data);
      }
      throw err;
    }
  };

  if (ENVIRONMENT_IS_WORKER) {
    readBinary = function(url) {
      try {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.responseType = 'arraybuffer';
        xhr.send(null);
        return new Uint8Array(/** @type{!ArrayBuffer} */(xhr.response));
      } catch (err) {
        var data = tryParseAsDataURI(url);
        if (data) {
          return data;
        }
        throw err;
      }
    };
  }

  readAsync = function(url, onload, onerror) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function() {
      if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
        onload(xhr.response);
        return;
      }
      var data = tryParseAsDataURI(url);
      if (data) {
        onload(data.buffer);
        return;
      }
      onerror();
    };
    xhr.onerror = onerror;
    xhr.send(null);
  };

// end include: web_or_worker_shell_read.js
  }

  setWindowTitle = function(title) { document.title = title };
} else
{
  throw new Error('environment detection error');
}

// Set up the out() and err() hooks, which are how we can print to stdout or
// stderr, respectively.
var out = Module['print'] || console.log.bind(console);
var err = Module['printErr'] || console.warn.bind(console);

// Merge back in the overrides
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used e.g. in memoryInitializerRequest, which is a large typed array.
moduleOverrides = null;

// Emit code to handle expected values on the Module object. This applies Module.x
// to the proper local x. This has two benefits: first, we only emit it if it is
// expected to arrive, and second, by using a local everywhere else that can be
// minified.

if (Module['arguments']) arguments_ = Module['arguments'];
if (!Object.getOwnPropertyDescriptor(Module, 'arguments')) {
  Object.defineProperty(Module, 'arguments', {
    configurable: true,
    get: function() {
      abort('Module.arguments has been replaced with plain arguments_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (Module['thisProgram']) thisProgram = Module['thisProgram'];
if (!Object.getOwnPropertyDescriptor(Module, 'thisProgram')) {
  Object.defineProperty(Module, 'thisProgram', {
    configurable: true,
    get: function() {
      abort('Module.thisProgram has been replaced with plain thisProgram (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (Module['quit']) quit_ = Module['quit'];
if (!Object.getOwnPropertyDescriptor(Module, 'quit')) {
  Object.defineProperty(Module, 'quit', {
    configurable: true,
    get: function() {
      abort('Module.quit has been replaced with plain quit_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

// perform assertions in shell.js after we set up out() and err(), as otherwise if an assertion fails it cannot print the message
// Assertions on removed incoming Module JS APIs.
assert(typeof Module['memoryInitializerPrefixURL'] === 'undefined', 'Module.memoryInitializerPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['pthreadMainPrefixURL'] === 'undefined', 'Module.pthreadMainPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['cdInitializerPrefixURL'] === 'undefined', 'Module.cdInitializerPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['filePackagePrefixURL'] === 'undefined', 'Module.filePackagePrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['read'] === 'undefined', 'Module.read option was removed (modify read_ in JS)');
assert(typeof Module['readAsync'] === 'undefined', 'Module.readAsync option was removed (modify readAsync in JS)');
assert(typeof Module['readBinary'] === 'undefined', 'Module.readBinary option was removed (modify readBinary in JS)');
assert(typeof Module['setWindowTitle'] === 'undefined', 'Module.setWindowTitle option was removed (modify setWindowTitle in JS)');
assert(typeof Module['TOTAL_MEMORY'] === 'undefined', 'Module.TOTAL_MEMORY has been renamed Module.INITIAL_MEMORY');

if (!Object.getOwnPropertyDescriptor(Module, 'read')) {
  Object.defineProperty(Module, 'read', {
    configurable: true,
    get: function() {
      abort('Module.read has been replaced with plain read_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'readAsync')) {
  Object.defineProperty(Module, 'readAsync', {
    configurable: true,
    get: function() {
      abort('Module.readAsync has been replaced with plain readAsync (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'readBinary')) {
  Object.defineProperty(Module, 'readBinary', {
    configurable: true,
    get: function() {
      abort('Module.readBinary has been replaced with plain readBinary (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'setWindowTitle')) {
  Object.defineProperty(Module, 'setWindowTitle', {
    configurable: true,
    get: function() {
      abort('Module.setWindowTitle has been replaced with plain setWindowTitle (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}
var IDBFS = 'IDBFS is no longer included by default; build with -lidbfs.js';
var PROXYFS = 'PROXYFS is no longer included by default; build with -lproxyfs.js';
var WORKERFS = 'WORKERFS is no longer included by default; build with -lworkerfs.js';
var NODEFS = 'NODEFS is no longer included by default; build with -lnodefs.js';




var STACK_ALIGN = 16;

function alignMemory(size, factor) {
  if (!factor) factor = STACK_ALIGN; // stack alignment (16-byte) by default
  return Math.ceil(size / factor) * factor;
}

function getNativeTypeSize(type) {
  switch (type) {
    case 'i1': case 'i8': return 1;
    case 'i16': return 2;
    case 'i32': return 4;
    case 'i64': return 8;
    case 'float': return 4;
    case 'double': return 8;
    default: {
      if (type[type.length-1] === '*') {
        return 4; // A pointer
      } else if (type[0] === 'i') {
        var bits = Number(type.substr(1));
        assert(bits % 8 === 0, 'getNativeTypeSize invalid bits ' + bits + ', type ' + type);
        return bits / 8;
      } else {
        return 0;
      }
    }
  }
}

function warnOnce(text) {
  if (!warnOnce.shown) warnOnce.shown = {};
  if (!warnOnce.shown[text]) {
    warnOnce.shown[text] = 1;
    err(text);
  }
}

// include: runtime_functions.js


// Wraps a JS function as a wasm function with a given signature.
function convertJsFunctionToWasm(func, sig) {

  // If the type reflection proposal is available, use the new
  // "WebAssembly.Function" constructor.
  // Otherwise, construct a minimal wasm module importing the JS function and
  // re-exporting it.
  if (typeof WebAssembly.Function === "function") {
    var typeNames = {
      'i': 'i32',
      'j': 'i64',
      'f': 'f32',
      'd': 'f64'
    };
    var type = {
      parameters: [],
      results: sig[0] == 'v' ? [] : [typeNames[sig[0]]]
    };
    for (var i = 1; i < sig.length; ++i) {
      type.parameters.push(typeNames[sig[i]]);
    }
    return new WebAssembly.Function(type, func);
  }

  // The module is static, with the exception of the type section, which is
  // generated based on the signature passed in.
  var typeSection = [
    0x01, // id: section,
    0x00, // length: 0 (placeholder)
    0x01, // count: 1
    0x60, // form: func
  ];
  var sigRet = sig.slice(0, 1);
  var sigParam = sig.slice(1);
  var typeCodes = {
    'i': 0x7f, // i32
    'j': 0x7e, // i64
    'f': 0x7d, // f32
    'd': 0x7c, // f64
  };

  // Parameters, length + signatures
  typeSection.push(sigParam.length);
  for (var i = 0; i < sigParam.length; ++i) {
    typeSection.push(typeCodes[sigParam[i]]);
  }

  // Return values, length + signatures
  // With no multi-return in MVP, either 0 (void) or 1 (anything else)
  if (sigRet == 'v') {
    typeSection.push(0x00);
  } else {
    typeSection = typeSection.concat([0x01, typeCodes[sigRet]]);
  }

  // Write the overall length of the type section back into the section header
  // (excepting the 2 bytes for the section id and length)
  typeSection[1] = typeSection.length - 2;

  // Rest of the module is static
  var bytes = new Uint8Array([
    0x00, 0x61, 0x73, 0x6d, // magic ("\0asm")
    0x01, 0x00, 0x00, 0x00, // version: 1
  ].concat(typeSection, [
    0x02, 0x07, // import section
      // (import "e" "f" (func 0 (type 0)))
      0x01, 0x01, 0x65, 0x01, 0x66, 0x00, 0x00,
    0x07, 0x05, // export section
      // (export "f" (func 0 (type 0)))
      0x01, 0x01, 0x66, 0x00, 0x00,
  ]));

   // We can compile this wasm module synchronously because it is very small.
  // This accepts an import (at "e.f"), that it reroutes to an export (at "f")
  var module = new WebAssembly.Module(bytes);
  var instance = new WebAssembly.Instance(module, {
    'e': {
      'f': func
    }
  });
  var wrappedFunc = instance.exports['f'];
  return wrappedFunc;
}

var freeTableIndexes = [];

// Weak map of functions in the table to their indexes, created on first use.
var functionsInTableMap;

function getEmptyTableSlot() {
  // Reuse a free index if there is one, otherwise grow.
  if (freeTableIndexes.length) {
    return freeTableIndexes.pop();
  }
  // Grow the table
  try {
    wasmTable.grow(1);
  } catch (err) {
    if (!(err instanceof RangeError)) {
      throw err;
    }
    throw 'Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.';
  }
  return wasmTable.length - 1;
}

// Add a wasm function to the table.
function addFunctionWasm(func, sig) {
  // Check if the function is already in the table, to ensure each function
  // gets a unique index. First, create the map if this is the first use.
  if (!functionsInTableMap) {
    functionsInTableMap = new WeakMap();
    for (var i = 0; i < wasmTable.length; i++) {
      var item = wasmTable.get(i);
      // Ignore null values.
      if (item) {
        functionsInTableMap.set(item, i);
      }
    }
  }
  if (functionsInTableMap.has(func)) {
    return functionsInTableMap.get(func);
  }

  // It's not in the table, add it now.

  var ret = getEmptyTableSlot();

  // Set the new value.
  try {
    // Attempting to call this with JS function will cause of table.set() to fail
    wasmTable.set(ret, func);
  } catch (err) {
    if (!(err instanceof TypeError)) {
      throw err;
    }
    assert(typeof sig !== 'undefined', 'Missing signature argument to addFunction: ' + func);
    var wrapped = convertJsFunctionToWasm(func, sig);
    wasmTable.set(ret, wrapped);
  }

  functionsInTableMap.set(func, ret);

  return ret;
}

function removeFunction(index) {
  functionsInTableMap.delete(wasmTable.get(index));
  freeTableIndexes.push(index);
}

// 'sig' parameter is required for the llvm backend but only when func is not
// already a WebAssembly function.
function addFunction(func, sig) {
  assert(typeof func !== 'undefined');

  return addFunctionWasm(func, sig);
}

// end include: runtime_functions.js
// include: runtime_debug.js


// end include: runtime_debug.js
var tempRet0 = 0;

var setTempRet0 = function(value) {
  tempRet0 = value;
};

var getTempRet0 = function() {
  return tempRet0;
};



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

var dynamicLibraries = Module['dynamicLibraries'] || [];

var wasmBinary;
if (Module['wasmBinary']) wasmBinary = Module['wasmBinary'];
if (!Object.getOwnPropertyDescriptor(Module, 'wasmBinary')) {
  Object.defineProperty(Module, 'wasmBinary', {
    configurable: true,
    get: function() {
      abort('Module.wasmBinary has been replaced with plain wasmBinary (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}
var noExitRuntime = Module['noExitRuntime'] || true;
if (!Object.getOwnPropertyDescriptor(Module, 'noExitRuntime')) {
  Object.defineProperty(Module, 'noExitRuntime', {
    configurable: true,
    get: function() {
      abort('Module.noExitRuntime has been replaced with plain noExitRuntime (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (typeof WebAssembly !== 'object') {
  abort('no native wasm support detected');
}

// include: runtime_safe_heap.js


// In MINIMAL_RUNTIME, setValue() and getValue() are only available when building with safe heap enabled, for heap safety checking.
// In traditional runtime, setValue() and getValue() are always available (although their use is highly discouraged due to perf penalties)

/** @param {number} ptr
    @param {number} value
    @param {string} type
    @param {number|boolean=} noSafe */
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
      case 'i1': HEAP8[((ptr)>>0)] = value; break;
      case 'i8': HEAP8[((ptr)>>0)] = value; break;
      case 'i16': HEAP16[((ptr)>>1)] = value; break;
      case 'i32': HEAP32[((ptr)>>2)] = value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)] = tempI64[0],HEAP32[(((ptr)+(4))>>2)] = tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)] = value; break;
      case 'double': HEAPF64[((ptr)>>3)] = value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}

/** @param {number} ptr
    @param {string} type
    @param {number|boolean=} noSafe */
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for getValue: ' + type);
    }
  return null;
}

// end include: runtime_safe_heap.js
// Wasm globals

var wasmMemory;

//========================================
// Runtime essentials
//========================================

// whether we are quitting the application. no code should run after this.
// set in exit() and abort()
var ABORT = false;

// set by exit() and abort().  Passed to 'onExit' handler.
// NOTE: This is also used as the process return code code in shell environments
// but only when noExitRuntime is false.
var EXITSTATUS;

/** @type {function(*, string=)} */
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  assert(func, 'Cannot call unknown function ' + ident + ', make sure it is exported');
  return func;
}

// C calling interface.
/** @param {string|null=} returnType
    @param {Array=} argTypes
    @param {Arguments|Array=} args
    @param {Object=} opts */
function ccall(ident, returnType, argTypes, args, opts) {
  // For fast lookup of conversion functions
  var toC = {
    'string': function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        var len = (str.length << 2) + 1;
        ret = stackAlloc(len);
        stringToUTF8(str, ret, len);
      }
      return ret;
    },
    'array': function(arr) {
      var ret = stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    }
  };

  function convertReturnValue(ret) {
    if (returnType === 'string') return UTF8ToString(ret);
    if (returnType === 'boolean') return Boolean(ret);
    return ret;
  }

  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  assert(returnType !== 'array', 'Return type should not be "array".');
  if (args) {
    for (var i = 0; i < args.length; i++) {
      var converter = toC[argTypes[i]];
      if (converter) {
        if (stack === 0) stack = stackSave();
        cArgs[i] = converter(args[i]);
      } else {
        cArgs[i] = args[i];
      }
    }
  }
  var ret = func.apply(null, cArgs);

  ret = convertReturnValue(ret);
  if (stack !== 0) stackRestore(stack);
  return ret;
}

/** @param {string=} returnType
    @param {Array=} argTypes
    @param {Object=} opts */
function cwrap(ident, returnType, argTypes, opts) {
  return function() {
    return ccall(ident, returnType, argTypes, arguments, opts);
  }
}

// We used to include malloc/free by default in the past. Show a helpful error in
// builds with assertions.

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data.
// @allocator: How to allocate memory, see ALLOC_*
/** @type {function((Uint8Array|Array<number>), number)} */
function allocate(slab, allocator) {
  var ret;
  assert(typeof allocator === 'number', 'allocate no longer takes a type argument')
  assert(typeof slab !== 'number', 'allocate no longer takes a number as arg0')

  if (allocator == ALLOC_STACK) {
    ret = stackAlloc(slab.length);
  } else {
    ret = _malloc(slab.length);
  }

  if (slab.subarray || slab.slice) {
    HEAPU8.set(/** @type {!Uint8Array} */(slab), ret);
  } else {
    HEAPU8.set(new Uint8Array(slab), ret);
  }
  return ret;
}

// include: runtime_strings.js


// runtime_strings.js: Strings related runtime functions that are part of both MINIMAL_RUNTIME and regular runtime.

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

var UTF8Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf8') : undefined;

/**
 * @param {number} idx
 * @param {number=} maxBytesToRead
 * @return {string}
 */
function UTF8ArrayToString(heap, idx, maxBytesToRead) {
  var endIdx = idx + maxBytesToRead;
  var endPtr = idx;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  // (As a tiny code save trick, compare endPtr against endIdx using a negation, so that undefined means Infinity)
  while (heap[endPtr] && !(endPtr >= endIdx)) ++endPtr;

  if (endPtr - idx > 16 && heap.subarray && UTF8Decoder) {
    return UTF8Decoder.decode(heap.subarray(idx, endPtr));
  } else {
    var str = '';
    // If building with TextDecoder, we have already computed the string length above, so test loop end condition against that
    while (idx < endPtr) {
      // For UTF8 byte structure, see:
      // http://en.wikipedia.org/wiki/UTF-8#Description
      // https://www.ietf.org/rfc/rfc2279.txt
      // https://tools.ietf.org/html/rfc3629
      var u0 = heap[idx++];
      if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
      var u1 = heap[idx++] & 63;
      if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
      var u2 = heap[idx++] & 63;
      if ((u0 & 0xF0) == 0xE0) {
        u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
      } else {
        if ((u0 & 0xF8) != 0xF0) warnOnce('Invalid UTF-8 leading byte 0x' + u0.toString(16) + ' encountered when deserializing a UTF-8 string in wasm memory to a JS string!');
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (heap[idx++] & 63);
      }

      if (u0 < 0x10000) {
        str += String.fromCharCode(u0);
      } else {
        var ch = u0 - 0x10000;
        str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
      }
    }
  }
  return str;
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns a
// copy of that string as a Javascript String object.
// maxBytesToRead: an optional length that specifies the maximum number of bytes to read. You can omit
//                 this parameter to scan the string until the first \0 byte. If maxBytesToRead is
//                 passed, and the string at [ptr, ptr+maxBytesToReadr[ contains a null byte in the
//                 middle, then the string will cut short at that byte index (i.e. maxBytesToRead will
//                 not produce a string of exact length [ptr, ptr+maxBytesToRead[)
//                 N.B. mixing frequent uses of UTF8ToString() with and without maxBytesToRead may
//                 throw JS JIT optimizations off, so it is worth to consider consistently using one
//                 style or the other.
/**
 * @param {number} ptr
 * @param {number=} maxBytesToRead
 * @return {string}
 */
function UTF8ToString(ptr, maxBytesToRead) {
  return ptr ? UTF8ArrayToString(HEAPU8, ptr, maxBytesToRead) : '';
}

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   heap: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array.
//                    This count should include the null terminator,
//                    i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, heap, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) {
      var u1 = str.charCodeAt(++i);
      u = 0x10000 + ((u & 0x3FF) << 10) | (u1 & 0x3FF);
    }
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      heap[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      heap[outIdx++] = 0xC0 | (u >> 6);
      heap[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      heap[outIdx++] = 0xE0 | (u >> 12);
      heap[outIdx++] = 0x80 | ((u >> 6) & 63);
      heap[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 3 >= endIdx) break;
      if (u >= 0x200000) warnOnce('Invalid Unicode code point 0x' + u.toString(16) + ' encountered when serializing a JS string to a UTF-8 string in wasm memory! (Valid unicode code points should be in range 0-0x1FFFFF).');
      heap[outIdx++] = 0xF0 | (u >> 18);
      heap[outIdx++] = 0x80 | ((u >> 12) & 63);
      heap[outIdx++] = 0x80 | ((u >> 6) & 63);
      heap[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  heap[outIdx] = 0;
  return outIdx - startIdx;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.
function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) ++len;
    else if (u <= 0x7FF) len += 2;
    else if (u <= 0xFFFF) len += 3;
    else len += 4;
  }
  return len;
}

// end include: runtime_strings.js
// include: runtime_strings_extra.js


// runtime_strings_extra.js: Strings related runtime functions that are available only in regular runtime.

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAPU8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

var UTF16Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-16le') : undefined;

function UTF16ToString(ptr, maxBytesToRead) {
  assert(ptr % 2 == 0, 'Pointer passed to UTF16ToString must be aligned to two bytes!');
  var endPtr = ptr;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  var idx = endPtr >> 1;
  var maxIdx = idx + maxBytesToRead / 2;
  // If maxBytesToRead is not passed explicitly, it will be undefined, and this
  // will always evaluate to true. This saves on code size.
  while (!(idx >= maxIdx) && HEAPU16[idx]) ++idx;
  endPtr = idx << 1;

  if (endPtr - ptr > 32 && UTF16Decoder) {
    return UTF16Decoder.decode(HEAPU8.subarray(ptr, endPtr));
  } else {
    var str = '';

    // If maxBytesToRead is not passed explicitly, it will be undefined, and the for-loop's condition
    // will always evaluate to true. The loop is then terminated on the first null char.
    for (var i = 0; !(i >= maxBytesToRead / 2); ++i) {
      var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
      if (codeUnit == 0) break;
      // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
      str += String.fromCharCode(codeUnit);
    }

    return str;
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 2 == 0, 'Pointer passed to stringToUTF16 must be aligned to two bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)] = codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)] = 0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}

function UTF32ToString(ptr, maxBytesToRead) {
  assert(ptr % 4 == 0, 'Pointer passed to UTF32ToString must be aligned to four bytes!');
  var i = 0;

  var str = '';
  // If maxBytesToRead is not passed explicitly, it will be undefined, and this
  // will always evaluate to true. This saves on code size.
  while (!(i >= maxBytesToRead / 4)) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0) break;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
  return str;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 4 == 0, 'Pointer passed to stringToUTF32 must be aligned to four bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)] = codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)] = 0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}

// Allocate heap space for a JS string, and write it there.
// It is the responsibility of the caller to free() that memory.
function allocateUTF8(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = _malloc(size);
  if (ret) stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Allocate stack space for a JS string, and write it there.
function allocateUTF8OnStack(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = stackAlloc(size);
  stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Deprecated: This function should not be called because it is unsafe and does not provide
// a maximum length limit of how many bytes it is allowed to write. Prefer calling the
// function stringToUTF8Array() instead, which takes in a maximum length that can be used
// to be secure from out of bounds writes.
/** @deprecated
    @param {boolean=} dontAddNull */
function writeStringToMemory(string, buffer, dontAddNull) {
  warnOnce('writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!');

  var /** @type {number} */ lastChar, /** @type {number} */ end;
  if (dontAddNull) {
    // stringToUTF8Array always appends null. If we don't want to do that, remember the
    // character that existed at the location where the null will be placed, and restore
    // that after the write (below).
    end = buffer + lengthBytesUTF8(string);
    lastChar = HEAP8[end];
  }
  stringToUTF8(string, buffer, Infinity);
  if (dontAddNull) HEAP8[end] = lastChar; // Restore the value under the null character.
}

function writeArrayToMemory(array, buffer) {
  assert(array.length >= 0, 'writeArrayToMemory array must have a length (should be an array or typed array)')
  HEAP8.set(array, buffer);
}

/** @param {boolean=} dontAddNull */
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    assert(str.charCodeAt(i) === str.charCodeAt(i)&0xff);
    HEAP8[((buffer++)>>0)] = str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)] = 0;
}

// end include: runtime_strings_extra.js
// Memory management

function alignUp(x, multiple) {
  if (x % multiple > 0) {
    x += multiple - (x % multiple);
  }
  return x;
}

var HEAP,
/** @type {ArrayBuffer} */
  buffer,
/** @type {Int8Array} */
  HEAP8,
/** @type {Uint8Array} */
  HEAPU8,
/** @type {Int16Array} */
  HEAP16,
/** @type {Uint16Array} */
  HEAPU16,
/** @type {Int32Array} */
  HEAP32,
/** @type {Uint32Array} */
  HEAPU32,
/** @type {Float32Array} */
  HEAPF32,
/** @type {Float64Array} */
  HEAPF64;

function updateGlobalBufferAndViews(buf) {
  buffer = buf;
  Module['HEAP8'] = HEAP8 = new Int8Array(buf);
  Module['HEAP16'] = HEAP16 = new Int16Array(buf);
  Module['HEAP32'] = HEAP32 = new Int32Array(buf);
  Module['HEAPU8'] = HEAPU8 = new Uint8Array(buf);
  Module['HEAPU16'] = HEAPU16 = new Uint16Array(buf);
  Module['HEAPU32'] = HEAPU32 = new Uint32Array(buf);
  Module['HEAPF32'] = HEAPF32 = new Float32Array(buf);
  Module['HEAPF64'] = HEAPF64 = new Float64Array(buf);
}

var TOTAL_STACK = 5242880;
if (Module['TOTAL_STACK']) assert(TOTAL_STACK === Module['TOTAL_STACK'], 'the stack size can no longer be determined at runtime')

var INITIAL_MEMORY = Module['INITIAL_MEMORY'] || 33554432;
if (!Object.getOwnPropertyDescriptor(Module, 'INITIAL_MEMORY')) {
  Object.defineProperty(Module, 'INITIAL_MEMORY', {
    configurable: true,
    get: function() {
      abort('Module.INITIAL_MEMORY has been replaced with plain INITIAL_MEMORY (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

assert(INITIAL_MEMORY >= TOTAL_STACK, 'INITIAL_MEMORY should be larger than TOTAL_STACK, was ' + INITIAL_MEMORY + '! (TOTAL_STACK=' + TOTAL_STACK + ')');

// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && Int32Array.prototype.subarray !== undefined && Int32Array.prototype.set !== undefined,
       'JS engine does not provide full typed array support');

// In non-standalone/normal mode, we create the memory here.
// include: runtime_init_memory.js


// Create the wasm memory. (Note: this only applies if IMPORTED_MEMORY is defined)

  if (Module['wasmMemory']) {
    wasmMemory = Module['wasmMemory'];
  } else
  {
    wasmMemory = new WebAssembly.Memory({
      'initial': INITIAL_MEMORY / 65536,
      // In theory we should not need to emit the maximum if we want "unlimited"
      // or 4GB of memory, but VMs error on that atm, see
      // https://github.com/emscripten-core/emscripten/issues/14130
      // And in the pthreads case we definitely need to emit a maximum. So
      // always emit one.
      'maximum': 2147483648 / 65536
    });
  }

if (wasmMemory) {
  buffer = wasmMemory.buffer;
}

// If the user provides an incorrect length, just use that length instead rather than providing the user to
// specifically provide the memory length with Module['INITIAL_MEMORY'].
INITIAL_MEMORY = buffer.byteLength;
assert(INITIAL_MEMORY % 65536 === 0);
updateGlobalBufferAndViews(buffer);

// end include: runtime_init_memory.js

// include: runtime_init_table.js
// In RELOCATABLE mode we create the table in JS.
var wasmTable = new WebAssembly.Table({
  'initial': 21,
  'element': 'anyfunc'
});

// end include: runtime_init_table.js
// include: runtime_stack_check.js


// Initializes the stack cookie. Called at the startup of main and at the startup of each thread in pthreads mode.
function writeStackCookie() {
  var max = _emscripten_stack_get_end();
  assert((max & 3) == 0);
  // The stack grows downwards
  HEAPU32[(max >> 2)+1] = 0x2135467;
  HEAPU32[(max >> 2)+2] = 0x89BACDFE;
  // Also test the global address 0 for integrity.
  HEAP32[0] = 0x63736d65; /* 'emsc' */
}

function checkStackCookie() {
  if (ABORT) return;
  var max = _emscripten_stack_get_end();
  var cookie1 = HEAPU32[(max >> 2)+1];
  var cookie2 = HEAPU32[(max >> 2)+2];
  if (cookie1 != 0x2135467 || cookie2 != 0x89BACDFE) {
    abort('Stack overflow! Stack cookie has been overwritten, expected hex dwords 0x89BACDFE and 0x2135467, but received 0x' + cookie2.toString(16) + ' ' + cookie1.toString(16));
  }
  // Also test the global address 0 for integrity.
  if (HEAP32[0] !== 0x63736d65 /* 'emsc' */) abort('Runtime error: The application has corrupted its heap memory area (address zero)!');
}

// end include: runtime_stack_check.js
// include: runtime_assertions.js


// Endianness check
(function() {
  var h16 = new Int16Array(1);
  var h8 = new Int8Array(h16.buffer);
  h16[0] = 0x6373;
  if (h8[0] !== 0x73 || h8[1] !== 0x63) throw 'Runtime error: expected the system to be little-endian! (Run with -s SUPPORT_BIG_ENDIAN=1 to bypass)';
})();

// end include: runtime_assertions.js
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the main() is called

var runtimeInitialized = false;
var runtimeExited = false;

function preRun() {

  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }

  callRuntimeCallbacks(__ATPRERUN__);
}

function initRuntime() {
  checkStackCookie();
  assert(!runtimeInitialized);
  runtimeInitialized = true;

  
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  checkStackCookie();
  
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  checkStackCookie();
  runtimeExited = true;
}

function postRun() {
  checkStackCookie();

  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }

  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}

function addOnExit(cb) {
}

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}

// include: runtime_math.js


// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/fround

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/clz32

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/trunc

assert(Math.imul, 'This browser does not support Math.imul(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill');
assert(Math.fround, 'This browser does not support Math.fround(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill');
assert(Math.clz32, 'This browser does not support Math.clz32(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill');
assert(Math.trunc, 'This browser does not support Math.trunc(), build with LEGACY_VM_SUPPORT or POLYFILL_OLD_MATH_FUNCTIONS to add in a polyfill');

// end include: runtime_math.js
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// Module.preRun (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
var runDependencyTracking = {};

function getUniqueRunDependency(id) {
  var orig = id;
  while (1) {
    if (!runDependencyTracking[id]) return id;
    id = orig + Math.random();
  }
}

function addRunDependency(id) {
  runDependencies++;

  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }

  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        if (ABORT) {
          clearInterval(runDependencyWatcher);
          runDependencyWatcher = null;
          return;
        }
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            err('still waiting on run dependencies:');
          }
          err('dependency: ' + dep);
        }
        if (shown) {
          err('(end of list)');
        }
      }, 10000);
    }
  } else {
    err('warning: run dependency added without ID');
  }
}

function removeRunDependency(id) {
  runDependencies--;

  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }

  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    err('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
Module["preloadedWasm"] = {}; // maps url to wasm instance exports

/** @param {string|number=} what */
function abort(what) {
  if (Module['onAbort']) {
    Module['onAbort'](what);
  }

  what += '';
  err(what);

  ABORT = true;
  EXITSTATUS = 1;

  var output = 'abort(' + what + ') at ' + stackTrace();
  what = output;

  // Use a wasm runtime error, because a JS error might be seen as a foreign
  // exception, which means we'd run destructors on it. We need the error to
  // simply make the program stop.
  var e = new WebAssembly.RuntimeError(what);

  // Throw the error whether or not MODULARIZE is set because abort is used
  // in code paths apart from instantiation where an exception is expected
  // to be thrown when abort is called.
  throw e;
}

// {{MEM_INITIALIZER}}

// include: memoryprofiler.js


// end include: memoryprofiler.js
// show errors on likely calls to FS when it was not included
var FS = {
  error: function() {
    abort('Filesystem support (FS) was not included. The problem is that you are using files from JS, but files were not used from C/C++, so filesystem support was not auto-included. You can force-include filesystem support with  -s FORCE_FILESYSTEM=1');
  },
  init: function() { FS.error() },
  createDataFile: function() { FS.error() },
  createPreloadedFile: function() { FS.error() },
  createLazyFile: function() { FS.error() },
  open: function() { FS.error() },
  mkdev: function() { FS.error() },
  registerDevice: function() { FS.error() },
  analyzePath: function() { FS.error() },
  loadFilesFromDB: function() { FS.error() },

  ErrnoError: function ErrnoError() { FS.error() },
};
Module['FS_createDataFile'] = FS.createDataFile;
Module['FS_createPreloadedFile'] = FS.createPreloadedFile;

// include: URIUtils.js


// Prefix of data URIs emitted by SINGLE_FILE and related options.
var dataURIPrefix = 'data:application/octet-stream;base64,';

// Indicates whether filename is a base64 data URI.
function isDataURI(filename) {
  // Prefix of data URIs emitted by SINGLE_FILE and related options.
  return filename.startsWith(dataURIPrefix);
}

// Indicates whether filename is delivered via file protocol (as opposed to http/https)
function isFileURI(filename) {
  return filename.startsWith('file://');
}

// end include: URIUtils.js
function createExportWrapper(name, fixedasm) {
  return function() {
    var displayName = name;
    var asm = fixedasm;
    if (!fixedasm) {
      asm = Module['asm'];
    }
    assert(runtimeInitialized, 'native function `' + displayName + '` called before runtime initialization');
    assert(!runtimeExited, 'native function `' + displayName + '` called after runtime exit (use NO_EXIT_RUNTIME to keep it alive after main() exits)');
    if (!asm[name]) {
      assert(asm[name], 'exported native function `' + displayName + '` not found');
    }
    return asm[name].apply(null, arguments);
  };
}

var wasmBinaryFile;
  wasmBinaryFile = 'data:application/octet-stream;base64,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';
  if (!isDataURI(wasmBinaryFile)) {
    wasmBinaryFile = locateFile(wasmBinaryFile);
  }

function getBinary(file) {
  try {
    if (file == wasmBinaryFile && wasmBinary) {
      return new Uint8Array(wasmBinary);
    }
    var binary = tryParseAsDataURI(file);
    if (binary) {
      return binary;
    }
    if (readBinary) {
      return readBinary(file);
    } else {
      throw "both async and sync fetching of the wasm failed";
    }
  }
  catch (err) {
    abort(err);
  }
}

function getBinaryPromise() {
  // If we don't have the binary yet, try to to load it asynchronously.
  // Fetch has some additional restrictions over XHR, like it can't be used on a file:// url.
  // See https://github.com/github/fetch/pull/92#issuecomment-140665932
  // Cordova or Electron apps are typically loaded from a file:// url.
  // So use fetch if it is available and the url is not a file, otherwise fall back to XHR.
  if (!wasmBinary && (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)) {
    if (typeof fetch === 'function'
      && !isFileURI(wasmBinaryFile)
    ) {
      return fetch(wasmBinaryFile, { credentials: 'same-origin' }).then(function(response) {
        if (!response['ok']) {
          throw "failed to load wasm binary file at '" + wasmBinaryFile + "'";
        }
        return response['arrayBuffer']();
      }).catch(function () {
          return getBinary(wasmBinaryFile);
      });
    }
    else {
      if (readAsync) {
        // fetch is not available or url is file => try XHR (readAsync uses XHR internally)
        return new Promise(function(resolve, reject) {
          readAsync(wasmBinaryFile, function(response) { resolve(new Uint8Array(/** @type{!ArrayBuffer} */(response))) }, reject)
        });
      }
    }
  }

  // Otherwise, getBinary should be able to get it synchronously
  return Promise.resolve().then(function() { return getBinary(wasmBinaryFile); });
}

// Create the wasm instance.
// Receives the wasm imports, returns the exports.
function createWasm() {
  // prepare imports
  var info = {
    'env': asmLibraryArg,
    'wasi_snapshot_preview1': asmLibraryArg,
    'GOT.mem': new Proxy(asmLibraryArg, GOTHandler),
    'GOT.func': new Proxy(asmLibraryArg, GOTHandler),
  };
  // Load the wasm module and create an instance of using native support in the JS engine.
  // handle a generated wasm instance, receiving its exports and
  // performing other necessary setup
  /** @param {WebAssembly.Module=} module*/
  function receiveInstance(instance, module) {
    var exports = instance.exports;

    exports = relocateExports(exports, 1024);

    Module['asm'] = exports;

    var metadata = getDylinkMetadata(module);
    if (metadata.neededDynlibs) {
      dynamicLibraries = metadata.neededDynlibs.concat(dynamicLibraries);
    }
    mergeLibSymbols(exports, 'main')

    addOnInit(Module['asm']['__wasm_call_ctors']);

    removeRunDependency('wasm-instantiate');
  }
  // we can't run yet (except in a pthread, where we have a custom sync instantiator)
  addRunDependency('wasm-instantiate');

  // Prefer streaming instantiation if available.
  // Async compilation can be confusing when an error on the page overwrites Module
  // (for example, if the order of elements is wrong, and the one defining Module is
  // later), so we save Module and check it later.
  var trueModule = Module;
  function receiveInstantiationResult(result) {
    // 'result' is a ResultObject object which has both the module and instance.
    // receiveInstance() will swap in the exports (to Module.asm) so they can be called
    assert(Module === trueModule, 'the Module object should not be replaced during async compilation - perhaps the order of HTML elements is wrong?');
    trueModule = null;
    receiveInstance(result['instance'], result['module']);
  }

  function instantiateArrayBuffer(receiver) {
    return getBinaryPromise().then(function(binary) {
      var result = WebAssembly.instantiate(binary, info);
      return result;
    }).then(receiver, function(reason) {
      err('failed to asynchronously prepare wasm: ' + reason);

      // Warn on some common problems.
      if (isFileURI(wasmBinaryFile)) {
        err('warning: Loading from a file URI (' + wasmBinaryFile + ') is not supported in most browsers. See https://emscripten.org/docs/getting_started/FAQ.html#how-do-i-run-a-local-webserver-for-testing-why-does-my-program-stall-in-downloading-or-preparing');
      }
      abort(reason);
    });
  }

  function instantiateAsync() {
    if (!wasmBinary &&
        typeof WebAssembly.instantiateStreaming === 'function' &&
        !isDataURI(wasmBinaryFile) &&
        // Don't use streaming for file:// delivered objects in a webview, fetch them synchronously.
        !isFileURI(wasmBinaryFile) &&
        typeof fetch === 'function') {
      return fetch(wasmBinaryFile, { credentials: 'same-origin' }).then(function (response) {
        var result = WebAssembly.instantiateStreaming(response, info);
        return result.then(receiveInstantiationResult, function(reason) {
            // We expect the most common failure cause to be a bad MIME type for the binary,
            // in which case falling back to ArrayBuffer instantiation should work.
            err('wasm streaming compile failed: ' + reason);
            err('falling back to ArrayBuffer instantiation');
            return instantiateArrayBuffer(receiveInstantiationResult);
          });
      });
    } else {
      return instantiateArrayBuffer(receiveInstantiationResult);
    }
  }

  // User shell pages can write their own Module.instantiateWasm = function(imports, successCallback) callback
  // to manually instantiate the Wasm module themselves. This allows pages to run the instantiation parallel
  // to any other async startup actions they are performing.
  if (Module['instantiateWasm']) {
    try {
      var exports = Module['instantiateWasm'](info, receiveInstance);
      return exports;
    } catch(e) {
      err('Module.instantiateWasm callback failed with error: ' + e);
      return false;
    }
  }

  instantiateAsync();
  return {}; // no exports yet; we'll fill them in later
}

// Globals used by JS i64 conversions (see makeSetValue)
var tempDouble;
var tempI64;

// === Body ===

var ASM_CONSTS = {
  
};






  var GOT={};
  var GOTHandler={get:function(obj, symName) {
        if (!GOT[symName]) {
          GOT[symName] = new WebAssembly.Global({'value': 'i32', 'mutable': true});
        }
        return GOT[symName]
      }};

  function callRuntimeCallbacks(callbacks) {
      while (callbacks.length > 0) {
        var callback = callbacks.shift();
        if (typeof callback == 'function') {
          callback(Module); // Pass the module as the first argument.
          continue;
        }
        var func = callback.func;
        if (typeof func === 'number') {
          if (callback.arg === undefined) {
            wasmTable.get(func)();
          } else {
            wasmTable.get(func)(callback.arg);
          }
        } else {
          func(callback.arg === undefined ? null : callback.arg);
        }
      }
    }

  function demangle(func) {
      warnOnce('warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
      return func;
    }

  function demangleAll(text) {
      var regex =
        /\b_Z[\w\d_]+/g;
      return text.replace(regex,
        function(x) {
          var y = demangle(x);
          return x === y ? x : (y + ' [' + x + ']');
        });
    }

  function getDylinkMetadata(binary) {
      var next = 0;
      function getLEB() {
        var ret = 0;
        var mul = 1;
        while (1) {
          var byte = binary[next++];
          ret += ((byte & 0x7f) * mul);
          mul *= 0x80;
          if (!(byte & 0x80)) break;
        }
        return ret;
      }
  
      if (binary instanceof WebAssembly.Module) {
        var dylinkSection = WebAssembly.Module.customSections(binary, "dylink");
        assert(dylinkSection.length != 0, 'need dylink section');
        binary = new Int8Array(dylinkSection[0]);
      } else {
        var int32View = new Uint32Array(new Uint8Array(binary.subarray(0, 24)).buffer);
        assert(int32View[0] == 0x6d736100, 'need to see wasm magic number'); // \0asm
        // we should see the dylink section right after the magic number and wasm version
        assert(binary[8] === 0, 'need the dylink section to be first')
        next = 9;
        getLEB(); //section size
        assert(binary[next] === 6);                 next++; // size of "dylink" string
        assert(binary[next] === 'd'.charCodeAt(0)); next++;
        assert(binary[next] === 'y'.charCodeAt(0)); next++;
        assert(binary[next] === 'l'.charCodeAt(0)); next++;
        assert(binary[next] === 'i'.charCodeAt(0)); next++;
        assert(binary[next] === 'n'.charCodeAt(0)); next++;
        assert(binary[next] === 'k'.charCodeAt(0)); next++;
      }
  
      var customSection = {};
      customSection.memorySize = getLEB();
      customSection.memoryAlign = getLEB();
      customSection.tableSize = getLEB();
      customSection.tableAlign = getLEB();
      var tableAlign = Math.pow(2, customSection.tableAlign);
      assert(tableAlign === 1, 'invalid tableAlign ' + tableAlign);
      // shared libraries this module needs. We need to load them first, so that
      // current module could resolve its imports. (see tools/shared.py
      // WebAssembly.make_shared_library() for "dylink" section extension format)
      var neededDynlibsCount = getLEB();
      customSection.neededDynlibs = [];
      for (var i = 0; i < neededDynlibsCount; ++i) {
        var nameLen = getLEB();
        var nameUTF8 = binary.subarray(next, next + nameLen);
        next += nameLen;
        var name = UTF8ArrayToString(nameUTF8, 0);
        customSection.neededDynlibs.push(name);
      }
      return customSection;
    }

  function jsStackTrace() {
      var error = new Error();
      if (!error.stack) {
        // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
        // so try that as a special-case.
        try {
          throw new Error();
        } catch(e) {
          error = e;
        }
        if (!error.stack) {
          return '(no stack trace available)';
        }
      }
      return error.stack.toString();
    }

  var runtimeKeepaliveCounter=0;
  function keepRuntimeAlive() {
      return noExitRuntime || runtimeKeepaliveCounter > 0;
    }

  function asmjsMangle(x) {
      var unmangledSymbols = ['stackAlloc','stackSave','stackRestore'];
      return x.indexOf('dynCall_') == 0 || unmangledSymbols.includes(x) ? x : '_' + x;
    }
  function mergeLibSymbols(exports, libName) {
      // add symbols into global namespace TODO: weak linking etc.
      for (var sym in exports) {
        if (!exports.hasOwnProperty(sym)) {
          continue;
        }
  
        // When RTLD_GLOBAL is enable, the symbols defined by this shared object will be made
        // available for symbol resolution of subsequently loaded shared objects.
        //
        // We should copy the symbols (which include methods and variables) from SIDE_MODULE to MAIN_MODULE.
  
        if (!asmLibraryArg.hasOwnProperty(sym)) {
          asmLibraryArg[sym] = exports[sym];
        }
  
        // Export native export on the Module object.
        // TODO(sbc): Do all users want this?  Should we skip this by default?
        var module_sym = asmjsMangle(sym);
        if (!Module.hasOwnProperty(module_sym)) {
          Module[module_sym] = exports[sym];
        }
      }
    }

  var LDSO={nextHandle:1,loadedLibs:{},loadedLibNames:{}};
  
  function dynCallLegacy(sig, ptr, args) {
      assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
      if (args && args.length) {
        // j (64-bit integer) must be passed in as two numbers [low 32, high 32].
        assert(args.length === sig.substring(1).replace(/j/g, '--').length);
      } else {
        assert(sig.length == 1);
      }
      var f = Module["dynCall_" + sig];
      return args && args.length ? f.apply(null, [ptr].concat(args)) : f.call(null, ptr);
    }
  function dynCall(sig, ptr, args) {
      // Without WASM_BIGINT support we cannot directly call function with i64 as
      // part of thier signature, so we rely the dynCall functions generated by
      // wasm-emscripten-finalize
      if (sig.includes('j')) {
        return dynCallLegacy(sig, ptr, args);
      }
      assert(wasmTable.get(ptr), 'missing table entry in dynCall: ' + ptr);
      return wasmTable.get(ptr).apply(null, args)
    }
  function createInvokeFunction(sig) {
      return function() {
        var sp = stackSave();
        try {
          return dynCall(sig, arguments[0], Array.prototype.slice.call(arguments, 1));
        } catch(e) {
          stackRestore(sp);
          if (e !== e+0 && e !== 'longjmp') throw e;
          _setThrew(1, 0);
        }
      }
    }
  
  var ___heap_base=5251008;
  Module["___heap_base"] = ___heap_base;
  function getMemory(size) {
      // After the runtime is initialized, we must only use sbrk() normally.
      if (runtimeInitialized)
        return _malloc(size);
      var ret = ___heap_base;
      var end = (ret + size + 15) & -16;
      assert(end <= HEAP8.length, 'failure to getMemory - memory growth etc. is not supported there, call malloc/sbrk directly or increase INITIAL_MEMORY');
      ___heap_base = end;
      GOT['__heap_base'].value = end;
      return ret;
    }
  
  function isInternalSym(symName) {
      // TODO: find a way to mark these in the binary or avoid exporting them.
      return [
        '__cpp_exception',
        '__wasm_apply_data_relocs',
        '__dso_handle',
        '__set_stack_limits'
      ].includes(symName)
      ;
    }
  function updateGOT(exports) {
      for (var symName in exports) {
        if (isInternalSym(symName)) {
          continue;
        }
  
        var replace = false;
        var value = exports[symName];
        if (symName.startsWith('orig$')) {
          symName = symName.split('$')[1];
          replace = true;
        }
  
        if (!GOT[symName]) {
          GOT[symName] = new WebAssembly.Global({'value': 'i32', 'mutable': true});
        }
        if (replace || GOT[symName].value == 0) {
          if (typeof value === 'function') {
            GOT[symName].value = addFunctionWasm(value);
          } else if (typeof value === 'number') {
            GOT[symName].value = value;
          } else {
            err("unhandled export type for `" + symName + "`: " + (typeof value));
          }
        }
      }
    }
  function relocateExports(exports, memoryBase) {
      var relocated = {};
  
      for (var e in exports) {
        var value = exports[e];
        if (typeof value === 'object') {
          // a breaking change in the wasm spec, globals are now objects
          // https://github.com/WebAssembly/mutable-global/issues/1
          value = value.value;
        }
        if (typeof value === 'number') {
          value += memoryBase;
        }
        relocated[e] = value;
      }
      updateGOT(relocated);
      return relocated;
    }
  
  function resolveGlobalSymbol(symName, direct) {
      var sym;
      if (direct) {
        // First look for the orig$ symbol which is the symbols without
        // any legalization performed.
        sym = asmLibraryArg['orig$' + symName];
      }
      if (!sym) {
        sym = asmLibraryArg[symName];
      }
  
      // Check for the symbol on the Module object.  This is the only
      // way to dynamically access JS library symbols that were not
      // referenced by the main module (and therefore not part of the
      // initial set of symbols included in asmLibraryArg when it
      // was declared.
      if (!sym) {
        sym = Module[asmjsMangle(symName)];
      }
  
      if (!sym && symName.startsWith('invoke_')) {
        sym = createInvokeFunction(symName.split('_')[1]);
      }
  
      return sym;
    }
  function loadWebAssemblyModule(binary, flags) {
      var metadata = getDylinkMetadata(binary);
      var originalTable = wasmTable;
  
      // loadModule loads the wasm module after all its dependencies have been loaded.
      // can be called both sync/async.
      function loadModule() {
        // alignments are powers of 2
        var memAlign = Math.pow(2, metadata.memoryAlign);
        // finalize alignments and verify them
        memAlign = Math.max(memAlign, STACK_ALIGN); // we at least need stack alignment
        // prepare memory
        var memoryBase = alignMemory(getMemory(metadata.memorySize + memAlign), memAlign); // TODO: add to cleanups
        // TODO: use only __memory_base and __table_base, need to update asm.js backend
        var tableBase = wasmTable.length;
        wasmTable.grow(metadata.tableSize);
        // zero-initialize memory and table
        // The static area consists of explicitly initialized data, followed by zero-initialized data.
        // The latter may need zeroing out if the MAIN_MODULE has already used this memory area before
        // dlopen'ing the SIDE_MODULE.  Since we don't know the size of the explicitly initialized data
        // here, we just zero the whole thing, which is suboptimal, but should at least resolve bugs
        // from uninitialized memory.
          for (var i = memoryBase; i < memoryBase + metadata.memorySize; i++) {
            HEAP8[i] = 0;
          }
        for (var i = tableBase; i < tableBase + metadata.tableSize; i++) {
          wasmTable.set(i, null);
        }
  
        // This is the export map that we ultimately return.  We declare it here
        // so it can be used within resolveSymbol.  We resolve symbols against
        // this local symbol map in the case there they are not present on the
        // global Module object.  We need this fallback because:
        // a) Modules sometime need to import their own symbols
        // b) Symbols from side modules are not always added to the global namespace.
        var moduleExports;
  
        function resolveSymbol(sym) {
          var resolved = resolveGlobalSymbol(sym, false);
          if (!resolved) {
            resolved = moduleExports[sym];
          }
          assert(resolved, 'undefined symbol `' + sym + '`. perhaps a side module was not linked in? if this global was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment');
          return resolved;
        }
  
        // TODO kill ↓↓↓ (except "symbols local to this module", it will likely be
        // not needed if we require that if A wants symbols from B it has to link
        // to B explicitly: similarly to -Wl,--no-undefined)
        //
        // wasm dynamic libraries are pure wasm, so they cannot assist in
        // their own loading. When side module A wants to import something
        // provided by a side module B that is loaded later, we need to
        // add a layer of indirection, but worse, we can't even tell what
        // to add the indirection for, without inspecting what A's imports
        // are. To do that here, we use a JS proxy (another option would
        // be to inspect the binary directly).
        var proxyHandler = {
          'get': function(stubs, prop) {
            // symbols that should be local to this module
            switch (prop) {
              case '__memory_base':
                return memoryBase;
              case '__table_base':
                return tableBase;
            }
            if (prop in asmLibraryArg) {
              // No stub needed, symbol already exists in symbol table
              return asmLibraryArg[prop];
            }
            // Return a stub function that will resolve the symbol
            // when first called.
            if (!(prop in stubs)) {
              var resolved;
              stubs[prop] = function() {
                if (!resolved) resolved = resolveSymbol(prop, true);
                return resolved.apply(null, arguments);
              };
            }
            return stubs[prop];
          }
        };
        var proxy = new Proxy({}, proxyHandler);
        var info = {
          'GOT.mem': new Proxy({}, GOTHandler),
          'GOT.func': new Proxy({}, GOTHandler),
          'env': proxy,
          wasi_snapshot_preview1: proxy,
        };
  
        function postInstantiation(instance) {
          // the table should be unchanged
          assert(wasmTable === originalTable);
          // add new entries to functionsInTableMap
          for (var i = 0; i < metadata.tableSize; i++) {
            var item = wasmTable.get(tableBase + i);
            // verify that the new table region was filled in
            assert(item !== undefined, 'table entry was not filled in');
            // Ignore null values.
            if (item) {
              functionsInTableMap.set(item, tableBase + i);
            }
          }
          moduleExports = relocateExports(instance.exports, memoryBase);
          if (!flags.allowUndefined) {
            reportUndefinedSymbols();
          }
  
          // initialize the module
            var init = moduleExports['__wasm_call_ctors'];
            // TODO(sbc): Remove this once extra check once the binaryen
            // change propogates: https://github.com/WebAssembly/binaryen/pull/3811
            if (!init) {
              init = moduleExports['__post_instantiate'];
            }
            if (init) {
              if (runtimeInitialized) {
                init();
              } else {
                // we aren't ready to run compiled code yet
                __ATINIT__.push(init);
              }
            }
          return moduleExports;
        }
  
        if (flags.loadAsync) {
          if (binary instanceof WebAssembly.Module) {
            var instance = new WebAssembly.Instance(binary, info);
            return Promise.resolve(postInstantiation(instance));
          }
          return WebAssembly.instantiate(binary, info).then(function(result) {
            return postInstantiation(result.instance);
          });
        }
  
        var module = binary instanceof WebAssembly.Module ? binary : new WebAssembly.Module(binary);
        var instance = new WebAssembly.Instance(module, info);
        return postInstantiation(instance);
      }
  
      // now load needed libraries and the module itself.
      if (flags.loadAsync) {
        return metadata.neededDynlibs.reduce(function(chain, dynNeeded) {
          return chain.then(function() {
            return loadDynamicLibrary(dynNeeded, flags);
          });
        }, Promise.resolve()).then(function() {
          return loadModule();
        });
      }
  
      metadata.neededDynlibs.forEach(function(dynNeeded) {
        loadDynamicLibrary(dynNeeded, flags);
      });
      return loadModule();
    }
  
  function fetchBinary(url) {
      return fetch(url, { credentials: 'same-origin' }).then(function(response) {
        if (!response['ok']) {
          throw "failed to load binary file at '" + url + "'";
        }
        return response['arrayBuffer']();
      }).then(function(buffer) {
        return new Uint8Array(buffer);
      });
    }
  function loadDynamicLibrary(lib, flags) {
      if (lib == '__main__' && !LDSO.loadedLibNames[lib]) {
        LDSO.loadedLibs[-1] = {
          refcount: Infinity,   // = nodelete
          name:     '__main__',
          module:   Module['asm'],
          global:   true
        };
        LDSO.loadedLibNames['__main__'] = -1;
      }
  
      // when loadDynamicLibrary did not have flags, libraries were loaded globally & permanently
      flags = flags || {global: true, nodelete: true}
  
      var handle = LDSO.loadedLibNames[lib];
      var dso;
      if (handle) {
        // the library is being loaded or has been loaded already.
        //
        // however it could be previously loaded only locally and if we get
        // load request with global=true we have to make it globally visible now.
        dso = LDSO.loadedLibs[handle];
        if (flags.global && !dso.global) {
          dso.global = true;
          if (dso.module !== 'loading') {
            // ^^^ if module is 'loading' - symbols merging will be eventually done by the loader.
            mergeLibSymbols(dso.module, lib)
          }
        }
        // same for "nodelete"
        if (flags.nodelete && dso.refcount !== Infinity) {
          dso.refcount = Infinity;
        }
        dso.refcount++
        return flags.loadAsync ? Promise.resolve(handle) : handle;
      }
  
      // allocate new DSO & handle
      handle = LDSO.nextHandle++;
      dso = {
        refcount: flags.nodelete ? Infinity : 1,
        name:     lib,
        module:   'loading',
        global:   flags.global,
      };
      LDSO.loadedLibNames[lib] = handle;
      LDSO.loadedLibs[handle] = dso;
  
      // libData <- libFile
      function loadLibData(libFile) {
        // for wasm, we can use fetch for async, but for fs mode we can only imitate it
        if (flags.fs) {
          var libData = flags.fs.readFile(libFile, {encoding: 'binary'});
          if (!(libData instanceof Uint8Array)) {
            libData = new Uint8Array(libData);
          }
          return flags.loadAsync ? Promise.resolve(libData) : libData;
        }
  
        if (flags.loadAsync) {
          return fetchBinary(libFile);
        }
        // load the binary synchronously
        return readBinary(libFile);
      }
  
      // libModule <- lib
      function getLibModule() {
        // lookup preloaded cache first
        if (Module['preloadedWasm'] !== undefined &&
            Module['preloadedWasm'][lib] !== undefined) {
          var libModule = Module['preloadedWasm'][lib];
          return flags.loadAsync ? Promise.resolve(libModule) : libModule;
        }
  
        // module not preloaded - load lib data and create new module from it
        if (flags.loadAsync) {
          return loadLibData(lib).then(function(libData) {
            return loadWebAssemblyModule(libData, flags);
          });
        }
  
        return loadWebAssemblyModule(loadLibData(lib), flags);
      }
  
      // module for lib is loaded - update the dso & global namespace
      function moduleLoaded(libModule) {
        if (dso.global) {
          mergeLibSymbols(libModule, lib);
        }
        dso.module = libModule;
      }
  
      if (flags.loadAsync) {
        return getLibModule().then(function(libModule) {
          moduleLoaded(libModule);
          return handle;
        })
      }
  
      moduleLoaded(getLibModule());
      return handle;
    }
  
  function reportUndefinedSymbols() {
      for (var symName in GOT) {
        if (GOT[symName].value == 0) {
          var value = resolveGlobalSymbol(symName, true)
          assert(value, 'undefined symbol `' + symName + '`. perhaps a side module was not linked in? if this global was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment');
          if (typeof value === 'function') {
            GOT[symName].value = addFunctionWasm(value, value.sig);
          } else if (typeof value === 'number') {
            GOT[symName].value = value;
          } else {
            assert(false, 'bad export type for `' + symName + '`: ' + (typeof value));
          }
        }
      }
    }
  function preloadDylibs() {
      if (!dynamicLibraries.length) {
        reportUndefinedSymbols();
        return;
      }
  
      // if we can load dynamic libraries synchronously, do so, otherwise, preload
      if (!readBinary) {
        // we can't read binary data synchronously, so preload
        addRunDependency('preloadDylibs');
        dynamicLibraries.reduce(function(chain, lib) {
          return chain.then(function() {
            return loadDynamicLibrary(lib, {loadAsync: true, global: true, nodelete: true, allowUndefined: true});
          });
        }, Promise.resolve()).then(function() {
          // we got them all, wonderful
          removeRunDependency('preloadDylibs');
          reportUndefinedSymbols();
        });
        return;
      }
  
      dynamicLibraries.forEach(function(lib) {
        // libraries linked to main never go away
        loadDynamicLibrary(lib, {global: true, nodelete: true, allowUndefined: true});
      });
      reportUndefinedSymbols();
    }



  function stackTrace() {
      var js = jsStackTrace();
      if (Module['extraStackTrace']) js += '\n' + Module['extraStackTrace']();
      return demangleAll(js);
    }


  var ___stack_pointer=new WebAssembly.Global({'value': 'i32', 'mutable': true}, 5251008);

  function _abort() {
      abort();
    }
  Module["_abort"] = _abort;
  _abort.sig = 'v';

  var _emscripten_get_now;if (ENVIRONMENT_IS_NODE) {
    _emscripten_get_now = function() {
      var t = process['hrtime']();
      return t[0] * 1e3 + t[1] / 1e6;
    };
  } else if (typeof dateNow !== 'undefined') {
    _emscripten_get_now = dateNow;
  } else _emscripten_get_now = function() { return performance.now(); }
  ;
  
  var _emscripten_get_now_is_monotonic=true;;
  
  function setErrNo(value) {
      HEAP32[((___errno_location())>>2)] = value;
      return value;
    }
  function _clock_gettime(clk_id, tp) {
      // int clock_gettime(clockid_t clk_id, struct timespec *tp);
      var now;
      if (clk_id === 0) {
        now = Date.now();
      } else if ((clk_id === 1 || clk_id === 4) && _emscripten_get_now_is_monotonic) {
        now = _emscripten_get_now();
      } else {
        setErrNo(28);
        return -1;
      }
      HEAP32[((tp)>>2)] = (now/1000)|0; // seconds
      HEAP32[(((tp)+(4))>>2)] = ((now % 1000)*1000*1000)|0; // nanoseconds
      return 0;
    }
  _clock_gettime.sig = 'iii';

  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.copyWithin(dest, src, src + num);
    }

  function emscripten_realloc_buffer(size) {
      try {
        // round size grow request up to wasm page size (fixed 64KB per spec)
        wasmMemory.grow((size - buffer.byteLength + 65535) >>> 16); // .grow() takes a delta compared to the previous size
        updateGlobalBufferAndViews(wasmMemory.buffer);
        return 1 /*success*/;
      } catch(e) {
        console.error('emscripten_realloc_buffer: Attempted to grow heap from ' + buffer.byteLength  + ' bytes to ' + size + ' bytes, but got error: ' + e);
      }
      // implicit 0 return to save code size (caller will cast "undefined" into 0
      // anyhow)
    }
  function _emscripten_resize_heap(requestedSize) {
      var oldSize = HEAPU8.length;
      requestedSize = requestedSize >>> 0;
      // With pthreads, races can happen (another thread might increase the size in between), so return a failure, and let the caller retry.
      assert(requestedSize > oldSize);
  
      // Memory resize rules:
      // 1. Always increase heap size to at least the requested size, rounded up to next page multiple.
      // 2a. If MEMORY_GROWTH_LINEAR_STEP == -1, excessively resize the heap geometrically: increase the heap size according to 
      //                                         MEMORY_GROWTH_GEOMETRIC_STEP factor (default +20%),
      //                                         At most overreserve by MEMORY_GROWTH_GEOMETRIC_CAP bytes (default 96MB).
      // 2b. If MEMORY_GROWTH_LINEAR_STEP != -1, excessively resize the heap linearly: increase the heap size by at least MEMORY_GROWTH_LINEAR_STEP bytes.
      // 3. Max size for the heap is capped at 2048MB-WASM_PAGE_SIZE, or by MAXIMUM_MEMORY, or by ASAN limit, depending on which is smallest
      // 4. If we were unable to allocate as much memory, it may be due to over-eager decision to excessively reserve due to (3) above.
      //    Hence if an allocation fails, cut down on the amount of excess growth, in an attempt to succeed to perform a smaller allocation.
  
      // A limit is set for how much we can grow. We should not exceed that
      // (the wasm binary specifies it, so if we tried, we'd fail anyhow).
      // In CAN_ADDRESS_2GB mode, stay one Wasm page short of 4GB: while e.g. Chrome is able to allocate full 4GB Wasm memories, the size will wrap
      // back to 0 bytes in Wasm side for any code that deals with heap sizes, which would require special casing all heap size related code to treat
      // 0 specially.
      var maxHeapSize = 2147483648;
      if (requestedSize > maxHeapSize) {
        err('Cannot enlarge memory, asked to go up to ' + requestedSize + ' bytes, but the limit is ' + maxHeapSize + ' bytes!');
        return false;
      }
  
      // Loop through potential heap size increases. If we attempt a too eager reservation that fails, cut down on the
      // attempted size and reserve a smaller bump instead. (max 3 times, chosen somewhat arbitrarily)
      for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
        var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown); // ensure geometric growth
        // but limit overreserving (default to capping at +96MB overgrowth at most)
        overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296 );
  
        var newSize = Math.min(maxHeapSize, alignUp(Math.max(requestedSize, overGrownHeapSize), 65536));
  
        var replacement = emscripten_realloc_buffer(newSize);
        if (replacement) {
  
          return true;
        }
      }
      err('Failed to grow the heap from ' + oldSize + ' bytes to ' + newSize + ' bytes, not enough memory!');
      return false;
    }

  function _exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      exit(status);
    }
  _exit.sig = 'vi';

  var SYSCALLS={mappings:{},DEFAULT_POLLMASK:5,umask:511,calculateAt:function(dirfd, path, allowEmpty) {
        if (path[0] === '/') {
          return path;
        }
        // relative path
        var dir;
        if (dirfd === -100) {
          dir = FS.cwd();
        } else {
          var dirstream = FS.getStream(dirfd);
          if (!dirstream) throw new FS.ErrnoError(8);
          dir = dirstream.path;
        }
        if (path.length == 0) {
          if (!allowEmpty) {
            throw new FS.ErrnoError(44);;
          }
          return dir;
        }
        return PATH.join2(dir, path);
      },doStat:function(func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -54;
          }
          throw e;
        }
        HEAP32[((buf)>>2)] = stat.dev;
        HEAP32[(((buf)+(4))>>2)] = 0;
        HEAP32[(((buf)+(8))>>2)] = stat.ino;
        HEAP32[(((buf)+(12))>>2)] = stat.mode;
        HEAP32[(((buf)+(16))>>2)] = stat.nlink;
        HEAP32[(((buf)+(20))>>2)] = stat.uid;
        HEAP32[(((buf)+(24))>>2)] = stat.gid;
        HEAP32[(((buf)+(28))>>2)] = stat.rdev;
        HEAP32[(((buf)+(32))>>2)] = 0;
        (tempI64 = [stat.size>>>0,(tempDouble=stat.size,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((buf)+(40))>>2)] = tempI64[0],HEAP32[(((buf)+(44))>>2)] = tempI64[1]);
        HEAP32[(((buf)+(48))>>2)] = 4096;
        HEAP32[(((buf)+(52))>>2)] = stat.blocks;
        HEAP32[(((buf)+(56))>>2)] = (stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)] = 0;
        HEAP32[(((buf)+(64))>>2)] = (stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)] = 0;
        HEAP32[(((buf)+(72))>>2)] = (stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(76))>>2)] = 0;
        (tempI64 = [stat.ino>>>0,(tempDouble=stat.ino,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((buf)+(80))>>2)] = tempI64[0],HEAP32[(((buf)+(84))>>2)] = tempI64[1]);
        return 0;
      },doMsync:function(addr, stream, len, flags, offset) {
        var buffer = HEAPU8.slice(addr, addr + len);
        FS.msync(stream, buffer, offset, len, flags);
      },doMkdir:function(path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function(path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -28;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function(path, buf, bufsize) {
        if (bufsize <= 0) return -28;
        var ret = FS.readlink(path);
  
        var len = Math.min(bufsize, lengthBytesUTF8(ret));
        var endChar = HEAP8[buf+len];
        stringToUTF8(ret, buf, bufsize+1);
        // readlink is one of the rare functions that write out a C string, but does never append a null to the output buffer(!)
        // stringToUTF8() always appends a null byte, so restore the character under the null byte after the write.
        HEAP8[buf+len] = endChar;
  
        return len;
      },doAccess:function(path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -28;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        if (!node) {
          return -44;
        }
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -2;
        }
        return 0;
      },doDup:function(path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function(stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function(stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:undefined,get:function() {
        assert(SYSCALLS.varargs != undefined);
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function(ptr) {
        var ret = UTF8ToString(ptr);
        return ret;
      },getStreamFromFD:function(fd) {
        var stream = FS.getStream(fd);
        if (!stream) throw new FS.ErrnoError(8);
        return stream;
      },get64:function(low, high) {
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      }};
  function _fd_close(fd) {try {
  
      var stream = SYSCALLS.getStreamFromFD(fd);
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }
  _fd_close.sig = 'ii';

  function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {try {
  
      
      var stream = SYSCALLS.getStreamFromFD(fd);
      var HIGH_OFFSET = 0x100000000; // 2^32
      // use an unsigned operator on low and shift high by 32-bits
      var offset = offset_high * HIGH_OFFSET + (offset_low >>> 0);
  
      var DOUBLE_LIMIT = 0x20000000000000; // 2^53
      // we also check for equality since DOUBLE_LIMIT + 1 == DOUBLE_LIMIT
      if (offset <= -DOUBLE_LIMIT || offset >= DOUBLE_LIMIT) {
        return -61;
      }
  
      FS.llseek(stream, offset, whence);
      (tempI64 = [stream.position>>>0,(tempDouble=stream.position,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((newOffset)>>2)] = tempI64[0],HEAP32[(((newOffset)+(4))>>2)] = tempI64[1]);
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }

  function _fd_write(fd, iov, iovcnt, pnum) {try {
  
      var stream = SYSCALLS.getStreamFromFD(fd);
      var num = SYSCALLS.doWritev(stream, iov, iovcnt);
      HEAP32[((pnum)>>2)] = num
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }
  _fd_write.sig = 'iiiii';

  function _setTempRet0(val) {
      setTempRet0(val);
    }
  _setTempRet0.sig = 'vi';

  function _tree_sitter_log_callback(isLexMessage, messageAddress) {
      if (currentLogCallback) {
        const message = UTF8ToString(messageAddress);
        currentLogCallback(message, isLexMessage !== 0);
      }
    }

  function _tree_sitter_parse_callback(
      inputBufferAddress,
      index,
      row,
      column,
      lengthAddress
    ) {
      var INPUT_BUFFER_SIZE = 10 * 1024;
      var string = currentParseCallback(index, {row: row, column: column});
      if (typeof string === 'string') {
        setValue(lengthAddress, string.length, 'i32');
        stringToUTF16(string, inputBufferAddress, INPUT_BUFFER_SIZE);
      } else {
        setValue(lengthAddress, 0, 'i32');
      }
    }


  var ___memory_base=1024;

  var ___table_base=1;

var ASSERTIONS = true;



/** @type {function(string, boolean=, number=)} */
function intArrayFromString(stringy, dontAddNull, length) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      if (ASSERTIONS) {
        assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      }
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}


// Copied from https://github.com/strophe/strophejs/blob/e06d027/src/polyfills.js#L149

// This code was written by Tyler Akins and has been placed in the
// public domain.  It would be nice if you left this header intact.
// Base64 code from Tyler Akins -- http://rumkin.com

/**
 * Decodes a base64 string.
 * @param {string} input The string to decode.
 */
var decodeBase64 = typeof atob === 'function' ? atob : function (input) {
  var keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

  var output = '';
  var chr1, chr2, chr3;
  var enc1, enc2, enc3, enc4;
  var i = 0;
  // remove all characters that are not A-Z, a-z, 0-9, +, /, or =
  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');
  do {
    enc1 = keyStr.indexOf(input.charAt(i++));
    enc2 = keyStr.indexOf(input.charAt(i++));
    enc3 = keyStr.indexOf(input.charAt(i++));
    enc4 = keyStr.indexOf(input.charAt(i++));

    chr1 = (enc1 << 2) | (enc2 >> 4);
    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
    chr3 = ((enc3 & 3) << 6) | enc4;

    output = output + String.fromCharCode(chr1);

    if (enc3 !== 64) {
      output = output + String.fromCharCode(chr2);
    }
    if (enc4 !== 64) {
      output = output + String.fromCharCode(chr3);
    }
  } while (i < input.length);
  return output;
};

// Converts a string of base64 into a byte array.
// Throws error on invalid input.
function intArrayFromBase64(s) {
  if (typeof ENVIRONMENT_IS_NODE === 'boolean' && ENVIRONMENT_IS_NODE) {
    var buf;
    try {
      // TODO: Update Node.js externs, Closure does not recognize the following Buffer.from()
      /**@suppress{checkTypes}*/
      buf = Buffer.from(s, 'base64');
    } catch (_) {
      buf = new Buffer(s, 'base64');
    }
    return new Uint8Array(buf['buffer'], buf['byteOffset'], buf['byteLength']);
  }

  try {
    var decoded = decodeBase64(s);
    var bytes = new Uint8Array(decoded.length);
    for (var i = 0 ; i < decoded.length ; ++i) {
      bytes[i] = decoded.charCodeAt(i);
    }
    return bytes;
  } catch (_) {
    throw new Error('Converting base64 string to bytes failed.');
  }
}

// If filename is a base64 data URI, parses and returns data (Buffer on node,
// Uint8Array otherwise). If filename is not a base64 data URI, returns undefined.
function tryParseAsDataURI(filename) {
  if (!isDataURI(filename)) {
    return;
  }

  return intArrayFromBase64(filename.slice(dataURIPrefix.length));
}


var asmLibraryArg = {
  "__heap_base": ___heap_base,
  "__indirect_function_table": wasmTable,
  "__memory_base": ___memory_base,
  "__stack_pointer": ___stack_pointer,
  "__table_base": ___table_base,
  "abort": _abort,
  "clock_gettime": _clock_gettime,
  "emscripten_memcpy_big": _emscripten_memcpy_big,
  "emscripten_resize_heap": _emscripten_resize_heap,
  "exit": _exit,
  "fd_close": _fd_close,
  "fd_seek": _fd_seek,
  "fd_write": _fd_write,
  "memory": wasmMemory,
  "setTempRet0": _setTempRet0,
  "tree_sitter_log_callback": _tree_sitter_log_callback,
  "tree_sitter_parse_callback": _tree_sitter_parse_callback
};
var asm = createWasm();
/** @type {function(...*):?} */
var ___wasm_call_ctors = Module["___wasm_call_ctors"] = createExportWrapper("__wasm_call_ctors");

/** @type {function(...*):?} */
var _ts_language_symbol_count = Module["_ts_language_symbol_count"] = createExportWrapper("ts_language_symbol_count");

/** @type {function(...*):?} */
var _ts_language_version = Module["_ts_language_version"] = createExportWrapper("ts_language_version");

/** @type {function(...*):?} */
var _ts_language_field_count = Module["_ts_language_field_count"] = createExportWrapper("ts_language_field_count");

/** @type {function(...*):?} */
var _ts_language_symbol_name = Module["_ts_language_symbol_name"] = createExportWrapper("ts_language_symbol_name");

/** @type {function(...*):?} */
var _ts_language_symbol_for_name = Module["_ts_language_symbol_for_name"] = createExportWrapper("ts_language_symbol_for_name");

/** @type {function(...*):?} */
var _ts_language_symbol_type = Module["_ts_language_symbol_type"] = createExportWrapper("ts_language_symbol_type");

/** @type {function(...*):?} */
var _ts_language_field_name_for_id = Module["_ts_language_field_name_for_id"] = createExportWrapper("ts_language_field_name_for_id");

/** @type {function(...*):?} */
var _memcpy = Module["_memcpy"] = createExportWrapper("memcpy");

/** @type {function(...*):?} */
var _free = Module["_free"] = createExportWrapper("free");

/** @type {function(...*):?} */
var _calloc = Module["_calloc"] = createExportWrapper("calloc");

/** @type {function(...*):?} */
var _ts_parser_delete = Module["_ts_parser_delete"] = createExportWrapper("ts_parser_delete");

/** @type {function(...*):?} */
var _ts_parser_set_language = Module["_ts_parser_set_language"] = createExportWrapper("ts_parser_set_language");

/** @type {function(...*):?} */
var _ts_parser_reset = Module["_ts_parser_reset"] = createExportWrapper("ts_parser_reset");

/** @type {function(...*):?} */
var _ts_parser_timeout_micros = Module["_ts_parser_timeout_micros"] = createExportWrapper("ts_parser_timeout_micros");

/** @type {function(...*):?} */
var _ts_parser_set_timeout_micros = Module["_ts_parser_set_timeout_micros"] = createExportWrapper("ts_parser_set_timeout_micros");

/** @type {function(...*):?} */
var _ts_query_new = Module["_ts_query_new"] = createExportWrapper("ts_query_new");

/** @type {function(...*):?} */
var _ts_query_delete = Module["_ts_query_delete"] = createExportWrapper("ts_query_delete");

/** @type {function(...*):?} */
var _malloc = Module["_malloc"] = createExportWrapper("malloc");

/** @type {function(...*):?} */
var _iswspace = Module["_iswspace"] = createExportWrapper("iswspace");

/** @type {function(...*):?} */
var _ts_query_pattern_count = Module["_ts_query_pattern_count"] = createExportWrapper("ts_query_pattern_count");

/** @type {function(...*):?} */
var _ts_query_capture_count = Module["_ts_query_capture_count"] = createExportWrapper("ts_query_capture_count");

/** @type {function(...*):?} */
var _ts_query_string_count = Module["_ts_query_string_count"] = createExportWrapper("ts_query_string_count");

/** @type {function(...*):?} */
var _ts_query_capture_name_for_id = Module["_ts_query_capture_name_for_id"] = createExportWrapper("ts_query_capture_name_for_id");

/** @type {function(...*):?} */
var _ts_query_string_value_for_id = Module["_ts_query_string_value_for_id"] = createExportWrapper("ts_query_string_value_for_id");

/** @type {function(...*):?} */
var _ts_query_predicates_for_pattern = Module["_ts_query_predicates_for_pattern"] = createExportWrapper("ts_query_predicates_for_pattern");

/** @type {function(...*):?} */
var _memmove = Module["_memmove"] = createExportWrapper("memmove");

/** @type {function(...*):?} */
var _memcmp = Module["_memcmp"] = createExportWrapper("memcmp");

/** @type {function(...*):?} */
var _ts_tree_copy = Module["_ts_tree_copy"] = createExportWrapper("ts_tree_copy");

/** @type {function(...*):?} */
var _ts_tree_delete = Module["_ts_tree_delete"] = createExportWrapper("ts_tree_delete");

/** @type {function(...*):?} */
var _iswalnum = Module["_iswalnum"] = createExportWrapper("iswalnum");

/** @type {function(...*):?} */
var _ts_init = Module["_ts_init"] = createExportWrapper("ts_init");

/** @type {function(...*):?} */
var _ts_parser_new_wasm = Module["_ts_parser_new_wasm"] = createExportWrapper("ts_parser_new_wasm");

/** @type {function(...*):?} */
var _ts_parser_enable_logger_wasm = Module["_ts_parser_enable_logger_wasm"] = createExportWrapper("ts_parser_enable_logger_wasm");

/** @type {function(...*):?} */
var _ts_parser_parse_wasm = Module["_ts_parser_parse_wasm"] = createExportWrapper("ts_parser_parse_wasm");

/** @type {function(...*):?} */
var _ts_language_type_is_named_wasm = Module["_ts_language_type_is_named_wasm"] = createExportWrapper("ts_language_type_is_named_wasm");

/** @type {function(...*):?} */
var _ts_language_type_is_visible_wasm = Module["_ts_language_type_is_visible_wasm"] = createExportWrapper("ts_language_type_is_visible_wasm");

/** @type {function(...*):?} */
var _ts_tree_root_node_wasm = Module["_ts_tree_root_node_wasm"] = createExportWrapper("ts_tree_root_node_wasm");

/** @type {function(...*):?} */
var _ts_tree_edit_wasm = Module["_ts_tree_edit_wasm"] = createExportWrapper("ts_tree_edit_wasm");

/** @type {function(...*):?} */
var _ts_tree_get_changed_ranges_wasm = Module["_ts_tree_get_changed_ranges_wasm"] = createExportWrapper("ts_tree_get_changed_ranges_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_new_wasm = Module["_ts_tree_cursor_new_wasm"] = createExportWrapper("ts_tree_cursor_new_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_delete_wasm = Module["_ts_tree_cursor_delete_wasm"] = createExportWrapper("ts_tree_cursor_delete_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_reset_wasm = Module["_ts_tree_cursor_reset_wasm"] = createExportWrapper("ts_tree_cursor_reset_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_goto_first_child_wasm = Module["_ts_tree_cursor_goto_first_child_wasm"] = createExportWrapper("ts_tree_cursor_goto_first_child_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_goto_next_sibling_wasm = Module["_ts_tree_cursor_goto_next_sibling_wasm"] = createExportWrapper("ts_tree_cursor_goto_next_sibling_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_goto_parent_wasm = Module["_ts_tree_cursor_goto_parent_wasm"] = createExportWrapper("ts_tree_cursor_goto_parent_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_node_type_id_wasm = Module["_ts_tree_cursor_current_node_type_id_wasm"] = createExportWrapper("ts_tree_cursor_current_node_type_id_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_node_is_named_wasm = Module["_ts_tree_cursor_current_node_is_named_wasm"] = createExportWrapper("ts_tree_cursor_current_node_is_named_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_node_is_missing_wasm = Module["_ts_tree_cursor_current_node_is_missing_wasm"] = createExportWrapper("ts_tree_cursor_current_node_is_missing_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_node_id_wasm = Module["_ts_tree_cursor_current_node_id_wasm"] = createExportWrapper("ts_tree_cursor_current_node_id_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_start_position_wasm = Module["_ts_tree_cursor_start_position_wasm"] = createExportWrapper("ts_tree_cursor_start_position_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_end_position_wasm = Module["_ts_tree_cursor_end_position_wasm"] = createExportWrapper("ts_tree_cursor_end_position_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_start_index_wasm = Module["_ts_tree_cursor_start_index_wasm"] = createExportWrapper("ts_tree_cursor_start_index_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_end_index_wasm = Module["_ts_tree_cursor_end_index_wasm"] = createExportWrapper("ts_tree_cursor_end_index_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_field_id_wasm = Module["_ts_tree_cursor_current_field_id_wasm"] = createExportWrapper("ts_tree_cursor_current_field_id_wasm");

/** @type {function(...*):?} */
var _ts_tree_cursor_current_node_wasm = Module["_ts_tree_cursor_current_node_wasm"] = createExportWrapper("ts_tree_cursor_current_node_wasm");

/** @type {function(...*):?} */
var _ts_node_symbol_wasm = Module["_ts_node_symbol_wasm"] = createExportWrapper("ts_node_symbol_wasm");

/** @type {function(...*):?} */
var _ts_node_child_count_wasm = Module["_ts_node_child_count_wasm"] = createExportWrapper("ts_node_child_count_wasm");

/** @type {function(...*):?} */
var _ts_node_named_child_count_wasm = Module["_ts_node_named_child_count_wasm"] = createExportWrapper("ts_node_named_child_count_wasm");

/** @type {function(...*):?} */
var _ts_node_child_wasm = Module["_ts_node_child_wasm"] = createExportWrapper("ts_node_child_wasm");

/** @type {function(...*):?} */
var _ts_node_named_child_wasm = Module["_ts_node_named_child_wasm"] = createExportWrapper("ts_node_named_child_wasm");

/** @type {function(...*):?} */
var _ts_node_child_by_field_id_wasm = Module["_ts_node_child_by_field_id_wasm"] = createExportWrapper("ts_node_child_by_field_id_wasm");

/** @type {function(...*):?} */
var _ts_node_next_sibling_wasm = Module["_ts_node_next_sibling_wasm"] = createExportWrapper("ts_node_next_sibling_wasm");

/** @type {function(...*):?} */
var _ts_node_prev_sibling_wasm = Module["_ts_node_prev_sibling_wasm"] = createExportWrapper("ts_node_prev_sibling_wasm");

/** @type {function(...*):?} */
var _ts_node_next_named_sibling_wasm = Module["_ts_node_next_named_sibling_wasm"] = createExportWrapper("ts_node_next_named_sibling_wasm");

/** @type {function(...*):?} */
var _ts_node_prev_named_sibling_wasm = Module["_ts_node_prev_named_sibling_wasm"] = createExportWrapper("ts_node_prev_named_sibling_wasm");

/** @type {function(...*):?} */
var _ts_node_parent_wasm = Module["_ts_node_parent_wasm"] = createExportWrapper("ts_node_parent_wasm");

/** @type {function(...*):?} */
var _ts_node_descendant_for_index_wasm = Module["_ts_node_descendant_for_index_wasm"] = createExportWrapper("ts_node_descendant_for_index_wasm");

/** @type {function(...*):?} */
var _ts_node_named_descendant_for_index_wasm = Module["_ts_node_named_descendant_for_index_wasm"] = createExportWrapper("ts_node_named_descendant_for_index_wasm");

/** @type {function(...*):?} */
var _ts_node_descendant_for_position_wasm = Module["_ts_node_descendant_for_position_wasm"] = createExportWrapper("ts_node_descendant_for_position_wasm");

/** @type {function(...*):?} */
var _ts_node_named_descendant_for_position_wasm = Module["_ts_node_named_descendant_for_position_wasm"] = createExportWrapper("ts_node_named_descendant_for_position_wasm");

/** @type {function(...*):?} */
var _ts_node_start_point_wasm = Module["_ts_node_start_point_wasm"] = createExportWrapper("ts_node_start_point_wasm");

/** @type {function(...*):?} */
var _ts_node_end_point_wasm = Module["_ts_node_end_point_wasm"] = createExportWrapper("ts_node_end_point_wasm");

/** @type {function(...*):?} */
var _ts_node_start_index_wasm = Module["_ts_node_start_index_wasm"] = createExportWrapper("ts_node_start_index_wasm");

/** @type {function(...*):?} */
var _ts_node_end_index_wasm = Module["_ts_node_end_index_wasm"] = createExportWrapper("ts_node_end_index_wasm");

/** @type {function(...*):?} */
var _ts_node_to_string_wasm = Module["_ts_node_to_string_wasm"] = createExportWrapper("ts_node_to_string_wasm");

/** @type {function(...*):?} */
var _ts_node_children_wasm = Module["_ts_node_children_wasm"] = createExportWrapper("ts_node_children_wasm");

/** @type {function(...*):?} */
var _ts_node_named_children_wasm = Module["_ts_node_named_children_wasm"] = createExportWrapper("ts_node_named_children_wasm");

/** @type {function(...*):?} */
var _ts_node_descendants_of_type_wasm = Module["_ts_node_descendants_of_type_wasm"] = createExportWrapper("ts_node_descendants_of_type_wasm");

/** @type {function(...*):?} */
var _ts_node_is_named_wasm = Module["_ts_node_is_named_wasm"] = createExportWrapper("ts_node_is_named_wasm");

/** @type {function(...*):?} */
var _ts_node_has_changes_wasm = Module["_ts_node_has_changes_wasm"] = createExportWrapper("ts_node_has_changes_wasm");

/** @type {function(...*):?} */
var _ts_node_has_error_wasm = Module["_ts_node_has_error_wasm"] = createExportWrapper("ts_node_has_error_wasm");

/** @type {function(...*):?} */
var _ts_node_is_missing_wasm = Module["_ts_node_is_missing_wasm"] = createExportWrapper("ts_node_is_missing_wasm");

/** @type {function(...*):?} */
var _ts_query_matches_wasm = Module["_ts_query_matches_wasm"] = createExportWrapper("ts_query_matches_wasm");

/** @type {function(...*):?} */
var _ts_query_captures_wasm = Module["_ts_query_captures_wasm"] = createExportWrapper("ts_query_captures_wasm");

/** @type {function(...*):?} */
var ___errno_location = Module["___errno_location"] = createExportWrapper("__errno_location");

/** @type {function(...*):?} */
var _iswalpha = Module["_iswalpha"] = createExportWrapper("iswalpha");

/** @type {function(...*):?} */
var _towupper = Module["_towupper"] = createExportWrapper("towupper");

/** @type {function(...*):?} */
var _iswlower = Module["_iswlower"] = createExportWrapper("iswlower");

/** @type {function(...*):?} */
var _iswdigit = Module["_iswdigit"] = createExportWrapper("iswdigit");

/** @type {function(...*):?} */
var _memchr = Module["_memchr"] = createExportWrapper("memchr");

/** @type {function(...*):?} */
var _strlen = Module["_strlen"] = createExportWrapper("strlen");

/** @type {function(...*):?} */
var stackSave = Module["stackSave"] = createExportWrapper("stackSave");

/** @type {function(...*):?} */
var stackRestore = Module["stackRestore"] = createExportWrapper("stackRestore");

/** @type {function(...*):?} */
var stackAlloc = Module["stackAlloc"] = createExportWrapper("stackAlloc");

/** @type {function(...*):?} */
var _emscripten_stack_set_limits = Module["_emscripten_stack_set_limits"] = function() {
  return (_emscripten_stack_set_limits = Module["_emscripten_stack_set_limits"] = Module["asm"]["emscripten_stack_set_limits"]).apply(null, arguments);
};

/** @type {function(...*):?} */
var _emscripten_stack_get_free = Module["_emscripten_stack_get_free"] = function() {
  return (_emscripten_stack_get_free = Module["_emscripten_stack_get_free"] = Module["asm"]["emscripten_stack_get_free"]).apply(null, arguments);
};

/** @type {function(...*):?} */
var _emscripten_stack_get_end = Module["_emscripten_stack_get_end"] = function() {
  return (_emscripten_stack_get_end = Module["_emscripten_stack_get_end"] = Module["asm"]["emscripten_stack_get_end"]).apply(null, arguments);
};

/** @type {function(...*):?} */
var _setThrew = Module["_setThrew"] = createExportWrapper("setThrew");

/** @type {function(...*):?} */
var __Znwm = Module["__Znwm"] = createExportWrapper("_Znwm");

/** @type {function(...*):?} */
var __ZdlPv = Module["__ZdlPv"] = createExportWrapper("_ZdlPv");

/** @type {function(...*):?} */
var __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv = Module["__ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv"] = createExportWrapper("_ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEED2Ev = Module["__ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEED2Ev"] = createExportWrapper("_ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEED2Ev");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9__grow_byEmmmmmm = Module["__ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9__grow_byEmmmmmm"] = createExportWrapper("_ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9__grow_byEmmmmmm");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE6__initEPKcm = Module["__ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE6__initEPKcm"] = createExportWrapper("_ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE6__initEPKcm");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE7reserveEm = Module["__ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE7reserveEm"] = createExportWrapper("_ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE7reserveEm");

/** @type {function(...*):?} */
var __ZNKSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE4copyEPcmm = Module["__ZNKSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE4copyEPcmm"] = createExportWrapper("_ZNKSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE4copyEPcmm");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9push_backEc = Module["__ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9push_backEc"] = createExportWrapper("_ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE9push_backEc");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEED2Ev = Module["__ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEED2Ev"] = createExportWrapper("_ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEED2Ev");

/** @type {function(...*):?} */
var __ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEE9push_backEw = Module["__ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEE9push_backEw"] = createExportWrapper("_ZNSt3__212basic_stringIwNS_11char_traitsIwEENS_9allocatorIwEEE9push_backEw");

/** @type {function(...*):?} */
var dynCall_jiji = Module["dynCall_jiji"] = createExportWrapper("dynCall_jiji");

/** @type {function(...*):?} */
var _orig$ts_parser_timeout_micros = Module["_orig$ts_parser_timeout_micros"] = createExportWrapper("orig$ts_parser_timeout_micros");

/** @type {function(...*):?} */
var _orig$ts_parser_set_timeout_micros = Module["_orig$ts_parser_set_timeout_micros"] = createExportWrapper("orig$ts_parser_set_timeout_micros");

var _stderr = Module['_stderr'] = 7088;
var _TRANSFER_BUFFER = Module['_TRANSFER_BUFFER'] = 7472;
var ___THREW__ = Module['___THREW__'] = 8116;
var ___threwValue = Module['___threwValue'] = 8120;
var ___cxa_new_handler = Module['___cxa_new_handler'] = 8112;
var ___data_end = Module['___data_end'] = 8124;



// === Auto-generated postamble setup entry stuff ===

if (!Object.getOwnPropertyDescriptor(Module, "intArrayFromString")) Module["intArrayFromString"] = function() { abort("'intArrayFromString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "intArrayToString")) Module["intArrayToString"] = function() { abort("'intArrayToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ccall")) Module["ccall"] = function() { abort("'ccall' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "cwrap")) Module["cwrap"] = function() { abort("'cwrap' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setValue")) Module["setValue"] = function() { abort("'setValue' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getValue")) Module["getValue"] = function() { abort("'getValue' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
Module["allocate"] = allocate;
if (!Object.getOwnPropertyDescriptor(Module, "UTF8ArrayToString")) Module["UTF8ArrayToString"] = function() { abort("'UTF8ArrayToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "UTF8ToString")) Module["UTF8ToString"] = function() { abort("'UTF8ToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToUTF8Array")) Module["stringToUTF8Array"] = function() { abort("'stringToUTF8Array' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToUTF8")) Module["stringToUTF8"] = function() { abort("'stringToUTF8' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "lengthBytesUTF8")) Module["lengthBytesUTF8"] = function() { abort("'lengthBytesUTF8' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stackTrace")) Module["stackTrace"] = function() { abort("'stackTrace' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addOnPreRun")) Module["addOnPreRun"] = function() { abort("'addOnPreRun' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addOnInit")) Module["addOnInit"] = function() { abort("'addOnInit' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addOnPreMain")) Module["addOnPreMain"] = function() { abort("'addOnPreMain' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addOnExit")) Module["addOnExit"] = function() { abort("'addOnExit' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addOnPostRun")) Module["addOnPostRun"] = function() { abort("'addOnPostRun' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeStringToMemory")) Module["writeStringToMemory"] = function() { abort("'writeStringToMemory' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeArrayToMemory")) Module["writeArrayToMemory"] = function() { abort("'writeArrayToMemory' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeAsciiToMemory")) Module["writeAsciiToMemory"] = function() { abort("'writeAsciiToMemory' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addRunDependency")) Module["addRunDependency"] = function() { abort("'addRunDependency' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "removeRunDependency")) Module["removeRunDependency"] = function() { abort("'removeRunDependency' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createFolder")) Module["FS_createFolder"] = function() { abort("'FS_createFolder' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createPath")) Module["FS_createPath"] = function() { abort("'FS_createPath' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createDataFile")) Module["FS_createDataFile"] = function() { abort("'FS_createDataFile' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createPreloadedFile")) Module["FS_createPreloadedFile"] = function() { abort("'FS_createPreloadedFile' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createLazyFile")) Module["FS_createLazyFile"] = function() { abort("'FS_createLazyFile' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createLink")) Module["FS_createLink"] = function() { abort("'FS_createLink' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_createDevice")) Module["FS_createDevice"] = function() { abort("'FS_createDevice' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "FS_unlink")) Module["FS_unlink"] = function() { abort("'FS_unlink' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ). Alternatively, forcing filesystem support (-s FORCE_FILESYSTEM=1) can export this for you") };
if (!Object.getOwnPropertyDescriptor(Module, "getLEB")) Module["getLEB"] = function() { abort("'getLEB' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getFunctionTables")) Module["getFunctionTables"] = function() { abort("'getFunctionTables' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "alignFunctionTables")) Module["alignFunctionTables"] = function() { abort("'alignFunctionTables' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerFunctions")) Module["registerFunctions"] = function() { abort("'registerFunctions' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "addFunction")) Module["addFunction"] = function() { abort("'addFunction' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "removeFunction")) Module["removeFunction"] = function() { abort("'removeFunction' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getFuncWrapper")) Module["getFuncWrapper"] = function() { abort("'getFuncWrapper' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "prettyPrint")) Module["prettyPrint"] = function() { abort("'prettyPrint' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "dynCall")) Module["dynCall"] = function() { abort("'dynCall' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getCompilerSetting")) Module["getCompilerSetting"] = function() { abort("'getCompilerSetting' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "print")) Module["print"] = function() { abort("'print' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "printErr")) Module["printErr"] = function() { abort("'printErr' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getTempRet0")) Module["getTempRet0"] = function() { abort("'getTempRet0' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setTempRet0")) Module["setTempRet0"] = function() { abort("'setTempRet0' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "callMain")) Module["callMain"] = function() { abort("'callMain' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "abort")) Module["abort"] = function() { abort("'abort' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToNewUTF8")) Module["stringToNewUTF8"] = function() { abort("'stringToNewUTF8' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setFileTime")) Module["setFileTime"] = function() { abort("'setFileTime' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "emscripten_realloc_buffer")) Module["emscripten_realloc_buffer"] = function() { abort("'emscripten_realloc_buffer' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ENV")) Module["ENV"] = function() { abort("'ENV' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ERRNO_CODES")) Module["ERRNO_CODES"] = function() { abort("'ERRNO_CODES' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ERRNO_MESSAGES")) Module["ERRNO_MESSAGES"] = function() { abort("'ERRNO_MESSAGES' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setErrNo")) Module["setErrNo"] = function() { abort("'setErrNo' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "inetPton4")) Module["inetPton4"] = function() { abort("'inetPton4' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "inetNtop4")) Module["inetNtop4"] = function() { abort("'inetNtop4' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "inetPton6")) Module["inetPton6"] = function() { abort("'inetPton6' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "inetNtop6")) Module["inetNtop6"] = function() { abort("'inetNtop6' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "readSockaddr")) Module["readSockaddr"] = function() { abort("'readSockaddr' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeSockaddr")) Module["writeSockaddr"] = function() { abort("'writeSockaddr' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "DNS")) Module["DNS"] = function() { abort("'DNS' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getHostByName")) Module["getHostByName"] = function() { abort("'getHostByName' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GAI_ERRNO_MESSAGES")) Module["GAI_ERRNO_MESSAGES"] = function() { abort("'GAI_ERRNO_MESSAGES' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "Protocols")) Module["Protocols"] = function() { abort("'Protocols' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "Sockets")) Module["Sockets"] = function() { abort("'Sockets' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getRandomDevice")) Module["getRandomDevice"] = function() { abort("'getRandomDevice' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "traverseStack")) Module["traverseStack"] = function() { abort("'traverseStack' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "UNWIND_CACHE")) Module["UNWIND_CACHE"] = function() { abort("'UNWIND_CACHE' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "withBuiltinMalloc")) Module["withBuiltinMalloc"] = function() { abort("'withBuiltinMalloc' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "readAsmConstArgsArray")) Module["readAsmConstArgsArray"] = function() { abort("'readAsmConstArgsArray' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "readAsmConstArgs")) Module["readAsmConstArgs"] = function() { abort("'readAsmConstArgs' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "mainThreadEM_ASM")) Module["mainThreadEM_ASM"] = function() { abort("'mainThreadEM_ASM' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "jstoi_q")) Module["jstoi_q"] = function() { abort("'jstoi_q' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "jstoi_s")) Module["jstoi_s"] = function() { abort("'jstoi_s' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getExecutableName")) Module["getExecutableName"] = function() { abort("'getExecutableName' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "listenOnce")) Module["listenOnce"] = function() { abort("'listenOnce' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "autoResumeAudioContext")) Module["autoResumeAudioContext"] = function() { abort("'autoResumeAudioContext' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "dynCallLegacy")) Module["dynCallLegacy"] = function() { abort("'dynCallLegacy' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getDynCaller")) Module["getDynCaller"] = function() { abort("'getDynCaller' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "dynCall")) Module["dynCall"] = function() { abort("'dynCall' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "callRuntimeCallbacks")) Module["callRuntimeCallbacks"] = function() { abort("'callRuntimeCallbacks' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "runtimeKeepaliveCounter")) Module["runtimeKeepaliveCounter"] = function() { abort("'runtimeKeepaliveCounter' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "keepRuntimeAlive")) Module["keepRuntimeAlive"] = function() { abort("'keepRuntimeAlive' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "runtimeKeepalivePush")) Module["runtimeKeepalivePush"] = function() { abort("'runtimeKeepalivePush' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "runtimeKeepalivePop")) Module["runtimeKeepalivePop"] = function() { abort("'runtimeKeepalivePop' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "callUserCallback")) Module["callUserCallback"] = function() { abort("'callUserCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "maybeExit")) Module["maybeExit"] = function() { abort("'maybeExit' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "asmjsMangle")) Module["asmjsMangle"] = function() { abort("'asmjsMangle' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "reallyNegative")) Module["reallyNegative"] = function() { abort("'reallyNegative' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "unSign")) Module["unSign"] = function() { abort("'unSign' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "reSign")) Module["reSign"] = function() { abort("'reSign' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "formatString")) Module["formatString"] = function() { abort("'formatString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "PATH")) Module["PATH"] = function() { abort("'PATH' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "PATH_FS")) Module["PATH_FS"] = function() { abort("'PATH_FS' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SYSCALLS")) Module["SYSCALLS"] = function() { abort("'SYSCALLS' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "syscallMmap2")) Module["syscallMmap2"] = function() { abort("'syscallMmap2' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "syscallMunmap")) Module["syscallMunmap"] = function() { abort("'syscallMunmap' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getSocketFromFD")) Module["getSocketFromFD"] = function() { abort("'getSocketFromFD' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getSocketAddress")) Module["getSocketAddress"] = function() { abort("'getSocketAddress' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "JSEvents")) Module["JSEvents"] = function() { abort("'JSEvents' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerKeyEventCallback")) Module["registerKeyEventCallback"] = function() { abort("'registerKeyEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "specialHTMLTargets")) Module["specialHTMLTargets"] = function() { abort("'specialHTMLTargets' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "maybeCStringToJsString")) Module["maybeCStringToJsString"] = function() { abort("'maybeCStringToJsString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "findEventTarget")) Module["findEventTarget"] = function() { abort("'findEventTarget' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "findCanvasEventTarget")) Module["findCanvasEventTarget"] = function() { abort("'findCanvasEventTarget' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getBoundingClientRect")) Module["getBoundingClientRect"] = function() { abort("'getBoundingClientRect' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillMouseEventData")) Module["fillMouseEventData"] = function() { abort("'fillMouseEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerMouseEventCallback")) Module["registerMouseEventCallback"] = function() { abort("'registerMouseEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerWheelEventCallback")) Module["registerWheelEventCallback"] = function() { abort("'registerWheelEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerUiEventCallback")) Module["registerUiEventCallback"] = function() { abort("'registerUiEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerFocusEventCallback")) Module["registerFocusEventCallback"] = function() { abort("'registerFocusEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillDeviceOrientationEventData")) Module["fillDeviceOrientationEventData"] = function() { abort("'fillDeviceOrientationEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerDeviceOrientationEventCallback")) Module["registerDeviceOrientationEventCallback"] = function() { abort("'registerDeviceOrientationEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillDeviceMotionEventData")) Module["fillDeviceMotionEventData"] = function() { abort("'fillDeviceMotionEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerDeviceMotionEventCallback")) Module["registerDeviceMotionEventCallback"] = function() { abort("'registerDeviceMotionEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "screenOrientation")) Module["screenOrientation"] = function() { abort("'screenOrientation' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillOrientationChangeEventData")) Module["fillOrientationChangeEventData"] = function() { abort("'fillOrientationChangeEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerOrientationChangeEventCallback")) Module["registerOrientationChangeEventCallback"] = function() { abort("'registerOrientationChangeEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillFullscreenChangeEventData")) Module["fillFullscreenChangeEventData"] = function() { abort("'fillFullscreenChangeEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerFullscreenChangeEventCallback")) Module["registerFullscreenChangeEventCallback"] = function() { abort("'registerFullscreenChangeEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerRestoreOldStyle")) Module["registerRestoreOldStyle"] = function() { abort("'registerRestoreOldStyle' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "hideEverythingExceptGivenElement")) Module["hideEverythingExceptGivenElement"] = function() { abort("'hideEverythingExceptGivenElement' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "restoreHiddenElements")) Module["restoreHiddenElements"] = function() { abort("'restoreHiddenElements' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setLetterbox")) Module["setLetterbox"] = function() { abort("'setLetterbox' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "currentFullscreenStrategy")) Module["currentFullscreenStrategy"] = function() { abort("'currentFullscreenStrategy' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "restoreOldWindowedStyle")) Module["restoreOldWindowedStyle"] = function() { abort("'restoreOldWindowedStyle' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "softFullscreenResizeWebGLRenderTarget")) Module["softFullscreenResizeWebGLRenderTarget"] = function() { abort("'softFullscreenResizeWebGLRenderTarget' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "doRequestFullscreen")) Module["doRequestFullscreen"] = function() { abort("'doRequestFullscreen' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillPointerlockChangeEventData")) Module["fillPointerlockChangeEventData"] = function() { abort("'fillPointerlockChangeEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerPointerlockChangeEventCallback")) Module["registerPointerlockChangeEventCallback"] = function() { abort("'registerPointerlockChangeEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerPointerlockErrorEventCallback")) Module["registerPointerlockErrorEventCallback"] = function() { abort("'registerPointerlockErrorEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "requestPointerLock")) Module["requestPointerLock"] = function() { abort("'requestPointerLock' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillVisibilityChangeEventData")) Module["fillVisibilityChangeEventData"] = function() { abort("'fillVisibilityChangeEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerVisibilityChangeEventCallback")) Module["registerVisibilityChangeEventCallback"] = function() { abort("'registerVisibilityChangeEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerTouchEventCallback")) Module["registerTouchEventCallback"] = function() { abort("'registerTouchEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillGamepadEventData")) Module["fillGamepadEventData"] = function() { abort("'fillGamepadEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerGamepadEventCallback")) Module["registerGamepadEventCallback"] = function() { abort("'registerGamepadEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerBeforeUnloadEventCallback")) Module["registerBeforeUnloadEventCallback"] = function() { abort("'registerBeforeUnloadEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fillBatteryEventData")) Module["fillBatteryEventData"] = function() { abort("'fillBatteryEventData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "battery")) Module["battery"] = function() { abort("'battery' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "registerBatteryEventCallback")) Module["registerBatteryEventCallback"] = function() { abort("'registerBatteryEventCallback' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setCanvasElementSize")) Module["setCanvasElementSize"] = function() { abort("'setCanvasElementSize' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getCanvasElementSize")) Module["getCanvasElementSize"] = function() { abort("'getCanvasElementSize' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "polyfillSetImmediate")) Module["polyfillSetImmediate"] = function() { abort("'polyfillSetImmediate' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "demangle")) Module["demangle"] = function() { abort("'demangle' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "demangleAll")) Module["demangleAll"] = function() { abort("'demangleAll' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "jsStackTrace")) Module["jsStackTrace"] = function() { abort("'jsStackTrace' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stackTrace")) Module["stackTrace"] = function() { abort("'stackTrace' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getEnvStrings")) Module["getEnvStrings"] = function() { abort("'getEnvStrings' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "checkWasiClock")) Module["checkWasiClock"] = function() { abort("'checkWasiClock' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeI53ToI64")) Module["writeI53ToI64"] = function() { abort("'writeI53ToI64' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeI53ToI64Clamped")) Module["writeI53ToI64Clamped"] = function() { abort("'writeI53ToI64Clamped' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeI53ToI64Signaling")) Module["writeI53ToI64Signaling"] = function() { abort("'writeI53ToI64Signaling' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeI53ToU64Clamped")) Module["writeI53ToU64Clamped"] = function() { abort("'writeI53ToU64Clamped' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeI53ToU64Signaling")) Module["writeI53ToU64Signaling"] = function() { abort("'writeI53ToU64Signaling' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "readI53FromI64")) Module["readI53FromI64"] = function() { abort("'readI53FromI64' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "readI53FromU64")) Module["readI53FromU64"] = function() { abort("'readI53FromU64' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "convertI32PairToI53")) Module["convertI32PairToI53"] = function() { abort("'convertI32PairToI53' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "convertU32PairToI53")) Module["convertU32PairToI53"] = function() { abort("'convertU32PairToI53' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "resolveGlobalSymbol")) Module["resolveGlobalSymbol"] = function() { abort("'resolveGlobalSymbol' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GOT")) Module["GOT"] = function() { abort("'GOT' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GOTHandler")) Module["GOTHandler"] = function() { abort("'GOTHandler' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "isInternalSym")) Module["isInternalSym"] = function() { abort("'isInternalSym' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "updateGOT")) Module["updateGOT"] = function() { abort("'updateGOT' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "relocateExports")) Module["relocateExports"] = function() { abort("'relocateExports' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "reportUndefinedSymbols")) Module["reportUndefinedSymbols"] = function() { abort("'reportUndefinedSymbols' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "DLFCN")) Module["DLFCN"] = function() { abort("'DLFCN' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "LDSO")) Module["LDSO"] = function() { abort("'LDSO' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "createInvokeFunction")) Module["createInvokeFunction"] = function() { abort("'createInvokeFunction' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getMemory")) Module["getMemory"] = function() { abort("'getMemory' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "fetchBinary")) Module["fetchBinary"] = function() { abort("'fetchBinary' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getDylinkMetadata")) Module["getDylinkMetadata"] = function() { abort("'getDylinkMetadata' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "mergeLibSymbols")) Module["mergeLibSymbols"] = function() { abort("'mergeLibSymbols' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "loadWebAssemblyModule")) Module["loadWebAssemblyModule"] = function() { abort("'loadWebAssemblyModule' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "loadDynamicLibrary")) Module["loadDynamicLibrary"] = function() { abort("'loadDynamicLibrary' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "preloadDylibs")) Module["preloadDylibs"] = function() { abort("'preloadDylibs' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "uncaughtExceptionCount")) Module["uncaughtExceptionCount"] = function() { abort("'uncaughtExceptionCount' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "exceptionLast")) Module["exceptionLast"] = function() { abort("'exceptionLast' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "exceptionCaught")) Module["exceptionCaught"] = function() { abort("'exceptionCaught' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ExceptionInfoAttrs")) Module["ExceptionInfoAttrs"] = function() { abort("'ExceptionInfoAttrs' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ExceptionInfo")) Module["ExceptionInfo"] = function() { abort("'ExceptionInfo' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "CatchInfo")) Module["CatchInfo"] = function() { abort("'CatchInfo' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "exception_addRef")) Module["exception_addRef"] = function() { abort("'exception_addRef' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "exception_decRef")) Module["exception_decRef"] = function() { abort("'exception_decRef' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "Browser")) Module["Browser"] = function() { abort("'Browser' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "funcWrappers")) Module["funcWrappers"] = function() { abort("'funcWrappers' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "getFuncWrapper")) Module["getFuncWrapper"] = function() { abort("'getFuncWrapper' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "setMainLoop")) Module["setMainLoop"] = function() { abort("'setMainLoop' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "tempFixedLengthArray")) Module["tempFixedLengthArray"] = function() { abort("'tempFixedLengthArray' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "miniTempWebGLFloatBuffers")) Module["miniTempWebGLFloatBuffers"] = function() { abort("'miniTempWebGLFloatBuffers' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "heapObjectForWebGLType")) Module["heapObjectForWebGLType"] = function() { abort("'heapObjectForWebGLType' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "heapAccessShiftForWebGLHeap")) Module["heapAccessShiftForWebGLHeap"] = function() { abort("'heapAccessShiftForWebGLHeap' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GL")) Module["GL"] = function() { abort("'GL' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "emscriptenWebGLGet")) Module["emscriptenWebGLGet"] = function() { abort("'emscriptenWebGLGet' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "computeUnpackAlignedImageSize")) Module["computeUnpackAlignedImageSize"] = function() { abort("'computeUnpackAlignedImageSize' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "emscriptenWebGLGetTexPixelData")) Module["emscriptenWebGLGetTexPixelData"] = function() { abort("'emscriptenWebGLGetTexPixelData' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "emscriptenWebGLGetUniform")) Module["emscriptenWebGLGetUniform"] = function() { abort("'emscriptenWebGLGetUniform' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "webglGetUniformLocation")) Module["webglGetUniformLocation"] = function() { abort("'webglGetUniformLocation' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "webglPrepareUniformLocationsBeforeFirstUse")) Module["webglPrepareUniformLocationsBeforeFirstUse"] = function() { abort("'webglPrepareUniformLocationsBeforeFirstUse' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "webglGetLeftBracePos")) Module["webglGetLeftBracePos"] = function() { abort("'webglGetLeftBracePos' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "emscriptenWebGLGetVertexAttrib")) Module["emscriptenWebGLGetVertexAttrib"] = function() { abort("'emscriptenWebGLGetVertexAttrib' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "writeGLArray")) Module["writeGLArray"] = function() { abort("'writeGLArray' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "AL")) Module["AL"] = function() { abort("'AL' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SDL_unicode")) Module["SDL_unicode"] = function() { abort("'SDL_unicode' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SDL_ttfContext")) Module["SDL_ttfContext"] = function() { abort("'SDL_ttfContext' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SDL_audio")) Module["SDL_audio"] = function() { abort("'SDL_audio' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SDL")) Module["SDL"] = function() { abort("'SDL' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "SDL_gfx")) Module["SDL_gfx"] = function() { abort("'SDL_gfx' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GLUT")) Module["GLUT"] = function() { abort("'GLUT' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "EGL")) Module["EGL"] = function() { abort("'EGL' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GLFW_Window")) Module["GLFW_Window"] = function() { abort("'GLFW_Window' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GLFW")) Module["GLFW"] = function() { abort("'GLFW' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "GLEW")) Module["GLEW"] = function() { abort("'GLEW' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "IDBStore")) Module["IDBStore"] = function() { abort("'IDBStore' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "runAndAbortIfError")) Module["runAndAbortIfError"] = function() { abort("'runAndAbortIfError' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "warnOnce")) Module["warnOnce"] = function() { abort("'warnOnce' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stackSave")) Module["stackSave"] = function() { abort("'stackSave' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stackRestore")) Module["stackRestore"] = function() { abort("'stackRestore' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stackAlloc")) Module["stackAlloc"] = function() { abort("'stackAlloc' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "AsciiToString")) Module["AsciiToString"] = function() { abort("'AsciiToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToAscii")) Module["stringToAscii"] = function() { abort("'stringToAscii' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "UTF16ToString")) Module["UTF16ToString"] = function() { abort("'UTF16ToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToUTF16")) Module["stringToUTF16"] = function() { abort("'stringToUTF16' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "lengthBytesUTF16")) Module["lengthBytesUTF16"] = function() { abort("'lengthBytesUTF16' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "UTF32ToString")) Module["UTF32ToString"] = function() { abort("'UTF32ToString' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "stringToUTF32")) Module["stringToUTF32"] = function() { abort("'stringToUTF32' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "lengthBytesUTF32")) Module["lengthBytesUTF32"] = function() { abort("'lengthBytesUTF32' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "allocateUTF8")) Module["allocateUTF8"] = function() { abort("'allocateUTF8' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "allocateUTF8OnStack")) Module["allocateUTF8OnStack"] = function() { abort("'allocateUTF8OnStack' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
Module["writeStackCookie"] = writeStackCookie;
Module["checkStackCookie"] = checkStackCookie;
if (!Object.getOwnPropertyDescriptor(Module, "intArrayFromBase64")) Module["intArrayFromBase64"] = function() { abort("'intArrayFromBase64' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "tryParseAsDataURI")) Module["tryParseAsDataURI"] = function() { abort("'tryParseAsDataURI' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") };
if (!Object.getOwnPropertyDescriptor(Module, "ALLOC_NORMAL")) Object.defineProperty(Module, "ALLOC_NORMAL", { configurable: true, get: function() { abort("'ALLOC_NORMAL' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") } });
if (!Object.getOwnPropertyDescriptor(Module, "ALLOC_STACK")) Object.defineProperty(Module, "ALLOC_STACK", { configurable: true, get: function() { abort("'ALLOC_STACK' was not exported. add it to EXPORTED_RUNTIME_METHODS (see the FAQ)") } });

var calledRun;

/**
 * @constructor
 * @this {ExitStatus}
 */
function ExitStatus(status) {
  this.name = "ExitStatus";
  this.message = "Program terminated with exit(" + status + ")";
  this.status = status;
}

var calledMain = false;

dependenciesFulfilled = function runCaller() {
  // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
  if (!calledRun) run();
  if (!calledRun) dependenciesFulfilled = runCaller; // try this again later, after new deps are fulfilled
};

function callMain(args) {
  assert(runDependencies == 0, 'cannot call main when async dependencies remain! (listen on Module["onRuntimeInitialized"])');
  assert(__ATPRERUN__.length == 0, 'cannot call main when preRun functions remain to be called');

  var entryFunction = Module['_main'];

  // Main modules can't tell if they have main() at compile time, since it may
  // arrive from a dynamic library.
  if (!entryFunction) return;

  args = args || [];

  var argc = args.length+1;
  var argv = stackAlloc((argc + 1) * 4);
  HEAP32[argv >> 2] = allocateUTF8OnStack(thisProgram);
  for (var i = 1; i < argc; i++) {
    HEAP32[(argv >> 2) + i] = allocateUTF8OnStack(args[i - 1]);
  }
  HEAP32[(argv >> 2) + argc] = 0;

  try {

    var ret = entryFunction(argc, argv);

    // In PROXY_TO_PTHREAD builds, we should never exit the runtime below, as
    // execution is asynchronously handed off to a pthread.
      // if we're not running an evented main loop, it's time to exit
      exit(ret, /* implicit = */ true);
  }
  catch(e) {
    if (e instanceof ExitStatus) {
      // exit() throws this once it's done to make sure execution
      // has been stopped completely
      return;
    } else if (e == 'unwind') {
      // running an evented main loop, don't immediately exit
      return;
    } else {
      var toLog = e;
      if (e && typeof e === 'object' && e.stack) {
        toLog = [e, e.stack];
      }
      err('exception thrown: ' + toLog);
      quit_(1, e);
    }
  } finally {
    calledMain = true;

  }
}

function stackCheckInit() {
  // This is normally called automatically during __wasm_call_ctors but need to
  // get these values before even running any of the ctors so we call it redundantly
  // here.
  // TODO(sbc): Move writeStackCookie to native to to avoid this.
  _emscripten_stack_set_limits(5251008, 8128);
  writeStackCookie();
}

var dylibsLoaded = false;

/** @type {function(Array=)} */
function run(args) {
  args = args || arguments_;

  if (runDependencies > 0) {
    return;
  }

  stackCheckInit();

  if (!dylibsLoaded) {
  // Loading of dynamic libraries needs to happen on each thread, so we can't
  // use the normal __ATPRERUN__ mechanism.
    preloadDylibs();
    dylibsLoaded = true;

    // Loading dylibs can add run dependencies.
    if (runDependencies > 0) {
      return;
    }
  }

  preRun();

  // a preRun added a dependency, run will be called later
  if (runDependencies > 0) {
    return;
  }

  function doRun() {
    // run may have just been called through dependencies being fulfilled just in this very frame,
    // or while the async setStatus time below was happening
    if (calledRun) return;
    calledRun = true;
    Module['calledRun'] = true;

    if (ABORT) return;

    initRuntime();

    preMain();

    if (Module['onRuntimeInitialized']) Module['onRuntimeInitialized']();

    if (shouldRunNow) callMain(args);

    postRun();
  }

  if (Module['setStatus']) {
    Module['setStatus']('Running...');
    setTimeout(function() {
      setTimeout(function() {
        Module['setStatus']('');
      }, 1);
      doRun();
    }, 1);
  } else
  {
    doRun();
  }
  checkStackCookie();
}
Module['run'] = run;

function checkUnflushedContent() {
  // Compiler settings do not allow exiting the runtime, so flushing
  // the streams is not possible. but in ASSERTIONS mode we check
  // if there was something to flush, and if so tell the user they
  // should request that the runtime be exitable.
  // Normally we would not even include flush() at all, but in ASSERTIONS
  // builds we do so just for this check, and here we see if there is any
  // content to flush, that is, we check if there would have been
  // something a non-ASSERTIONS build would have not seen.
  // How we flush the streams depends on whether we are in SYSCALLS_REQUIRE_FILESYSTEM=0
  // mode (which has its own special function for this; otherwise, all
  // the code is inside libc)
  var oldOut = out;
  var oldErr = err;
  var has = false;
  out = err = function(x) {
    has = true;
  }
  try { // it doesn't matter if it fails
    var flush = Module['_fflush'];
    if (flush) flush(0);
  } catch(e) {}
  out = oldOut;
  err = oldErr;
  if (has) {
    warnOnce('stdio streams had content in them that was not flushed. you should set EXIT_RUNTIME to 1 (see the FAQ), or make sure to emit a newline when you printf etc.');
    warnOnce('(this may also be due to not including full filesystem support - try building with -s FORCE_FILESYSTEM=1)');
  }
}

/** @param {boolean|number=} implicit */
function exit(status, implicit) {
  EXITSTATUS = status;

  checkUnflushedContent();

  // if this is just main exit-ing implicitly, and the status is 0, then we
  // don't need to do anything here and can just leave. if the status is
  // non-zero, though, then we need to report it.
  // (we may have warned about this earlier, if a situation justifies doing so)
  if (implicit && keepRuntimeAlive() && status === 0) {
    return;
  }

  if (keepRuntimeAlive()) {
    // if exit() was called, we may warn the user if the runtime isn't actually being shut down
    if (!implicit) {
      var msg = 'program exited (with status: ' + status + '), but EXIT_RUNTIME is not set, so halting execution but not exiting the runtime or preventing further async execution (build with EXIT_RUNTIME=1, if you want a true shutdown)';
      err(msg);
    }
  } else {

    exitRuntime();

    if (Module['onExit']) Module['onExit'](status);

    ABORT = true;
  }

  quit_(status, new ExitStatus(status));
}

if (Module['preInit']) {
  if (typeof Module['preInit'] == 'function') Module['preInit'] = [Module['preInit']];
  while (Module['preInit'].length > 0) {
    Module['preInit'].pop()();
  }
}

// shouldRunNow refers to calling main(), not run().
var shouldRunNow = true;

if (Module['noInitialRun']) shouldRunNow = false;

run();





const C = Module;
const INTERNAL = {};
const SIZE_OF_INT = 4;
const SIZE_OF_NODE = 5 * SIZE_OF_INT;
const SIZE_OF_POINT = 2 * SIZE_OF_INT;
const SIZE_OF_RANGE = 2 * SIZE_OF_INT + 2 * SIZE_OF_POINT;
const ZERO_POINT = {row: 0, column: 0};
const QUERY_WORD_REGEX = /[\w-.]*/g;

const PREDICATE_STEP_TYPE_CAPTURE = 1;
const PREDICATE_STEP_TYPE_STRING = 2;

const LANGUAGE_FUNCTION_REGEX = /^_?tree_sitter_\w+/;

var VERSION;
var MIN_COMPATIBLE_VERSION;
var TRANSFER_BUFFER;
var currentParseCallback;
var currentLogCallback;

class ParserImpl {
  static init() {
    TRANSFER_BUFFER = C._ts_init();
    VERSION = getValue(TRANSFER_BUFFER, 'i32');
    MIN_COMPATIBLE_VERSION = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
  }

  initialize() {
    C._ts_parser_new_wasm();
    this[0] = getValue(TRANSFER_BUFFER, 'i32');
    this[1] = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
  }

  delete() {
    C._ts_parser_delete(this[0]);
    C._free(this[1]);
    this[0] = 0;
    this[1] = 0;
  }

  setLanguage(language) {
    let address;
    if (!language) {
      address = 0;
      language = null;
    } else if (language.constructor === Language) {
      address = language[0];
      const version = C._ts_language_version(address);
      if (version < MIN_COMPATIBLE_VERSION || VERSION < version) {
        throw new Error(
          `Incompatible language version ${version}. ` +
          `Compatibility range ${MIN_COMPATIBLE_VERSION} through ${VERSION}.`
        );
      }
    } else {
      throw new Error('Argument must be a Language');
    }
    this.language = language;
    C._ts_parser_set_language(this[0], address);
    return this;
  }

  getLanguage() {
    return this.language
  }

  parse(callback, oldTree, options) {
    if (typeof callback === 'string') {
      currentParseCallback = (index, _, endIndex) => callback.slice(index, endIndex);
    } else if (typeof callback === 'function') {
      currentParseCallback = callback;
    } else {
      throw new Error("Argument must be a string or a function");
    }

    if (this.logCallback) {
      currentLogCallback = this.logCallback;
      C._ts_parser_enable_logger_wasm(this[0], 1);
    } else {
      currentLogCallback = null;
      C._ts_parser_enable_logger_wasm(this[0], 0);
    }

    let rangeCount = 0;
    let rangeAddress = 0;
    if (options && options.includedRanges) {
      rangeCount = options.includedRanges.length;
      rangeAddress = C._calloc(rangeCount, SIZE_OF_RANGE);
      let address = rangeAddress;
      for (let i = 0; i < rangeCount; i++) {
        marshalRange(address, options.includedRanges[i]);
        address += SIZE_OF_RANGE;
      }
    }

    const treeAddress = C._ts_parser_parse_wasm(
      this[0],
      this[1],
      oldTree ? oldTree[0] : 0,
      rangeAddress,
      rangeCount
    );

    if (!treeAddress) {
      currentParseCallback = null;
      currentLogCallback = null;
      throw new Error('Parsing failed');
    }

    const result = new Tree(INTERNAL, treeAddress, this.language, currentParseCallback);
    currentParseCallback = null;
    currentLogCallback = null;
    return result;
  }

  reset() {
    C._ts_parser_reset(this[0]);
  }

  setTimeoutMicros(timeout) {
    C._ts_parser_set_timeout_micros(this[0], timeout);
  }

  getTimeoutMicros() {
    return C._ts_parser_timeout_micros(this[0]);
  }

  setLogger(callback) {
    if (!callback) {
      callback = null;
    } else if (typeof callback !== "function") {
      throw new Error("Logger callback must be a function");
    }
    this.logCallback = callback;
    return this;
  }

  getLogger() {
    return this.logCallback;
  }
}

class Tree {
  constructor(internal, address, language, textCallback) {
    assertInternal(internal);
    this[0] = address;
    this.language = language;
    this.textCallback = textCallback;
  }

  copy() {
    const address = C._ts_tree_copy(this[0]);
    return new Tree(INTERNAL, address, this.language, this.textCallback);
  }

  delete() {
    C._ts_tree_delete(this[0]);
    this[0] = 0;
  }

  edit(edit) {
    marshalEdit(edit);
    C._ts_tree_edit_wasm(this[0]);
  }

  get rootNode() {
    C._ts_tree_root_node_wasm(this[0]);
    return unmarshalNode(this);
  }

  getLanguage() {
    return this.language;
  }

  walk() {
    return this.rootNode.walk();
  }

  getChangedRanges(other) {
    if (other.constructor !== Tree) {
      throw new TypeError('Argument must be a Tree');
    }

    C._ts_tree_get_changed_ranges_wasm(this[0], other[0]);
    const count = getValue(TRANSFER_BUFFER, 'i32');
    const buffer = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
    const result = new Array(count);
    if (count > 0) {
      let address = buffer;
      for (let i = 0; i < count; i++) {
        result[i] = unmarshalRange(address);
        address += SIZE_OF_RANGE;
      }
      C._free(buffer);
    }
    return result;
  }
}

class Node {
  constructor(internal, tree) {
    assertInternal(internal);
    this.tree = tree;
  }

  get typeId() {
    marshalNode(this);
    return C._ts_node_symbol_wasm(this.tree[0]);
  }

  get type() {
    return this.tree.language.types[this.typeId] || 'ERROR';
  }

  get endPosition() {
    marshalNode(this);
    C._ts_node_end_point_wasm(this.tree[0]);
    return unmarshalPoint(TRANSFER_BUFFER);
  }

  get endIndex() {
    marshalNode(this);
    return C._ts_node_end_index_wasm(this.tree[0]);
  }

  get text() {
    return getText(this.tree, this.startIndex, this.endIndex);
  }

  isNamed() {
    marshalNode(this);
    return C._ts_node_is_named_wasm(this.tree[0]) === 1;
  }

  hasError() {
    marshalNode(this);
    return C._ts_node_has_error_wasm(this.tree[0]) === 1;
  }

  hasChanges() {
    marshalNode(this);
    return C._ts_node_has_changes_wasm(this.tree[0]) === 1;
  }

  isMissing() {
    marshalNode(this);
    return C._ts_node_is_missing_wasm(this.tree[0]) === 1;
  }

  equals(other) {
    return this.id === other.id;
  }

  child(index) {
    marshalNode(this);
    C._ts_node_child_wasm(this.tree[0], index);
    return unmarshalNode(this.tree);
  }

  namedChild(index) {
    marshalNode(this);
    C._ts_node_named_child_wasm(this.tree[0], index);
    return unmarshalNode(this.tree);
  }

  childForFieldId(fieldId) {
    marshalNode(this);
    C._ts_node_child_by_field_id_wasm(this.tree[0], fieldId);
    return unmarshalNode(this.tree);
  }

  childForFieldName(fieldName) {
    const fieldId = this.tree.language.fields.indexOf(fieldName);
    if (fieldId !== -1) return this.childForFieldId(fieldId);
  }

  get childCount() {
    marshalNode(this);
    return C._ts_node_child_count_wasm(this.tree[0]);
  }

  get namedChildCount() {
    marshalNode(this);
    return C._ts_node_named_child_count_wasm(this.tree[0]);
  }

  get firstChild() {
    return this.child(0);
  }

  get firstNamedChild() {
    return this.namedChild(0);
  }

  get lastChild() {
    return this.child(this.childCount - 1);
  }

  get lastNamedChild() {
    return this.namedChild(this.namedChildCount - 1);
  }

  get children() {
    if (!this._children) {
      marshalNode(this);
      C._ts_node_children_wasm(this.tree[0]);
      const count = getValue(TRANSFER_BUFFER, 'i32');
      const buffer = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
      this._children = new Array(count);
      if (count > 0) {
        let address = buffer;
        for (let i = 0; i < count; i++) {
          this._children[i] = unmarshalNode(this.tree, address);
          address += SIZE_OF_NODE;
        }
        C._free(buffer);
      }
    }
    return this._children;
  }

  get namedChildren() {
    if (!this._namedChildren) {
      marshalNode(this);
      C._ts_node_named_children_wasm(this.tree[0]);
      const count = getValue(TRANSFER_BUFFER, 'i32');
      const buffer = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
      this._namedChildren = new Array(count);
      if (count > 0) {
        let address = buffer;
        for (let i = 0; i < count; i++) {
          this._namedChildren[i] = unmarshalNode(this.tree, address);
          address += SIZE_OF_NODE;
        }
        C._free(buffer);
      }
    }
    return this._namedChildren;
  }

  descendantsOfType(types, startPosition, endPosition) {
    if (!Array.isArray(types)) types = [types];
    if (!startPosition) startPosition = ZERO_POINT;
    if (!endPosition) endPosition = ZERO_POINT;

    // Convert the type strings to numeric type symbols.
    const symbols = [];
    const typesBySymbol = this.tree.language.types;
    for (let i = 0, n = typesBySymbol.length; i < n; i++) {
      if (types.includes(typesBySymbol[i])) {
        symbols.push(i);
      }
    }

    // Copy the array of symbols to the WASM heap.
    const symbolsAddress = C._malloc(SIZE_OF_INT * symbols.length);
    for (let i = 0, n = symbols.length; i < n; i++) {
      setValue(symbolsAddress + i * SIZE_OF_INT, symbols[i], 'i32');
    }

    // Call the C API to compute the descendants.
    marshalNode(this);
    C._ts_node_descendants_of_type_wasm(
      this.tree[0],
      symbolsAddress,
      symbols.length,
      startPosition.row,
      startPosition.column,
      endPosition.row,
      endPosition.column
    );

    // Instantiate the nodes based on the data returned.
    const descendantCount = getValue(TRANSFER_BUFFER, 'i32');
    const descendantAddress = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
    const result = new Array(descendantCount);
    if (descendantCount > 0) {
      let address = descendantAddress;
      for (let i = 0; i < descendantCount; i++) {
        result[i] = unmarshalNode(this.tree, address);
        address += SIZE_OF_NODE;
      }
    }

    // Free the intermediate buffers
    C._free(descendantAddress);
    C._free(symbolsAddress);
    return result;
  }

  get nextSibling() {
    marshalNode(this);
    C._ts_node_next_sibling_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  get previousSibling() {
    marshalNode(this);
    C._ts_node_prev_sibling_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  get nextNamedSibling() {
    marshalNode(this);
    C._ts_node_next_named_sibling_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  get previousNamedSibling() {
    marshalNode(this);
    C._ts_node_prev_named_sibling_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  get parent() {
    marshalNode(this);
    C._ts_node_parent_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  descendantForIndex(start, end = start) {
    if (typeof start !== 'number' || typeof end !== 'number') {
      throw new Error('Arguments must be numbers');
    }

    marshalNode(this);
    let address = TRANSFER_BUFFER + SIZE_OF_NODE;
    setValue(address, start, 'i32');
    setValue(address + SIZE_OF_INT, end, 'i32');
    C._ts_node_descendant_for_index_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  namedDescendantForIndex(start, end = start) {
    if (typeof start !== 'number' || typeof end !== 'number') {
      throw new Error('Arguments must be numbers');
    }

    marshalNode(this);
    let address = TRANSFER_BUFFER + SIZE_OF_NODE;
    setValue(address, start, 'i32');
    setValue(address + SIZE_OF_INT, end, 'i32');
    C._ts_node_named_descendant_for_index_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  descendantForPosition(start, end = start) {
    if (!isPoint(start) || !isPoint(end)) {
      throw new Error('Arguments must be {row, column} objects');
    }

    marshalNode(this);
    let address = TRANSFER_BUFFER + SIZE_OF_NODE;
    marshalPoint(address, start);
    marshalPoint(address + SIZE_OF_POINT, end);
    C._ts_node_descendant_for_position_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  namedDescendantForPosition(start, end = start) {
    if (!isPoint(start) || !isPoint(end)) {
      throw new Error('Arguments must be {row, column} objects');
    }

    marshalNode(this);
    let address = TRANSFER_BUFFER + SIZE_OF_NODE;
    marshalPoint(address, start);
    marshalPoint(address + SIZE_OF_POINT, end);
    C._ts_node_named_descendant_for_position_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  walk() {
    marshalNode(this);
    C._ts_tree_cursor_new_wasm(this.tree[0]);
    return new TreeCursor(INTERNAL, this.tree);
  }

  toString() {
    marshalNode(this);
    const address = C._ts_node_to_string_wasm(this.tree[0]);
    const result = AsciiToString(address);
    C._free(address);
    return result;
  }
}

class TreeCursor {
  constructor(internal, tree) {
    assertInternal(internal);
    this.tree = tree;
    unmarshalTreeCursor(this);
  }

  delete() {
    marshalTreeCursor(this);
    C._ts_tree_cursor_delete_wasm(this.tree[0]);
    this[0] = this[1] = this[2] = 0;
  }

  reset(node) {
    marshalNode(node);
    marshalTreeCursor(this, TRANSFER_BUFFER + SIZE_OF_NODE);
    C._ts_tree_cursor_reset_wasm(this.tree[0]);
    unmarshalTreeCursor(this);
  }

  get nodeType() {
    return this.tree.language.types[this.nodeTypeId] || 'ERROR';
  }

  get nodeTypeId() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_current_node_type_id_wasm(this.tree[0]);
  }

  get nodeId() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_current_node_id_wasm(this.tree[0]);
  }

  get nodeIsNamed() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_current_node_is_named_wasm(this.tree[0]) === 1;
  }

  get nodeIsMissing() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_current_node_is_missing_wasm(this.tree[0]) === 1;
  }

  get nodeText() {
    marshalTreeCursor(this);
    const startIndex = C._ts_tree_cursor_start_index_wasm(this.tree[0]);
    const endIndex = C._ts_tree_cursor_end_index_wasm(this.tree[0]);
    return getText(this.tree, startIndex, endIndex);
  }

  get startPosition() {
    marshalTreeCursor(this);
    C._ts_tree_cursor_start_position_wasm(this.tree[0]);
    return unmarshalPoint(TRANSFER_BUFFER);
  }

  get endPosition() {
    marshalTreeCursor(this);
    C._ts_tree_cursor_end_position_wasm(this.tree[0]);
    return unmarshalPoint(TRANSFER_BUFFER);
  }

  get startIndex() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_start_index_wasm(this.tree[0]);
  }

  get endIndex() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_end_index_wasm(this.tree[0]);
  }

  currentNode() {
    marshalTreeCursor(this);
    C._ts_tree_cursor_current_node_wasm(this.tree[0]);
    return unmarshalNode(this.tree);
  }

  currentFieldId() {
    marshalTreeCursor(this);
    return C._ts_tree_cursor_current_field_id_wasm(this.tree[0]);
  }

  currentFieldName() {
    return this.tree.language.fields[this.currentFieldId()];
  }

  gotoFirstChild() {
    marshalTreeCursor(this);
    const result = C._ts_tree_cursor_goto_first_child_wasm(this.tree[0]);
    unmarshalTreeCursor(this);
    return result === 1;
  }

  gotoNextSibling() {
    marshalTreeCursor(this);
    const result = C._ts_tree_cursor_goto_next_sibling_wasm(this.tree[0]);
    unmarshalTreeCursor(this);
    return result === 1;
  }

  gotoParent() {
    marshalTreeCursor(this);
    const result = C._ts_tree_cursor_goto_parent_wasm(this.tree[0]);
    unmarshalTreeCursor(this);
    return result === 1;
  }
}

class Language {
  constructor(internal, address) {
    assertInternal(internal);
    this[0] = address;
    this.types = new Array(C._ts_language_symbol_count(this[0]));
    for (let i = 0, n = this.types.length; i < n; i++) {
      if (C._ts_language_symbol_type(this[0], i) < 2) {
        this.types[i] = UTF8ToString(C._ts_language_symbol_name(this[0], i));
      }
    }
    this.fields = new Array(C._ts_language_field_count(this[0]) + 1);
    for (let i = 0, n = this.fields.length; i < n; i++) {
      const fieldName = C._ts_language_field_name_for_id(this[0], i);
      if (fieldName !== 0) {
        this.fields[i] = UTF8ToString(fieldName);
      } else {
        this.fields[i] = null;
      }
    }
  }

  get version() {
    return C._ts_language_version(this[0]);
  }

  get fieldCount() {
    return this.fields.length - 1;
  }

  fieldIdForName(fieldName) {
    const result = this.fields.indexOf(fieldName);
    if (result !== -1) {
      return result;
    } else {
      return null;
    }
  }

  fieldNameForId(fieldId) {
    return this.fields[fieldId] || null;
  }

  idForNodeType(type, named) {
    const typeLength = lengthBytesUTF8(type);
    const typeAddress = C._malloc(typeLength + 1);
    stringToUTF8(type, typeAddress, typeLength + 1);
    const result = C._ts_language_symbol_for_name(this[0], typeAddress, typeLength, named);
    C._free(typeAddress);
    return result || null;
  }

  get nodeTypeCount() {
    return C._ts_language_symbol_count(this[0]);
  }

  nodeTypeForId(typeId) {
    const name = C._ts_language_symbol_name(this[0], typeId);
    return name ? UTF8ToString(name) : null;
  }

  nodeTypeIsNamed(typeId) {
    return C._ts_language_type_is_named_wasm(this[0], typeId) ? true : false;
  }

  nodeTypeIsVisible(typeId) {
    return C._ts_language_type_is_visible_wasm(this[0], typeId) ? true : false;
  }

  query(source) {
    const sourceLength = lengthBytesUTF8(source);
    const sourceAddress = C._malloc(sourceLength + 1);
    stringToUTF8(source, sourceAddress, sourceLength + 1);
    const address = C._ts_query_new(
      this[0],
      sourceAddress,
      sourceLength,
      TRANSFER_BUFFER,
      TRANSFER_BUFFER + SIZE_OF_INT
    );

    if (!address) {
      const errorId = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
      const errorByte = getValue(TRANSFER_BUFFER, 'i32');
      const errorIndex = UTF8ToString(sourceAddress, errorByte).length;
      const suffix = source.substr(errorIndex, 100).split('\n')[0];
      let word = suffix.match(QUERY_WORD_REGEX)[0];
      let error;
      switch (errorId) {
        case 2:
          error = new RangeError(`Bad node name '${word}'`);
          break;
        case 3:
          error = new RangeError(`Bad field name '${word}'`);
          break;
        case 4:
          error = new RangeError(`Bad capture name @${word}`);
          break;
        case 5:
          error = new TypeError(`Bad pattern structure at offset ${errorIndex}: '${suffix}'...`);
          word = "";
          break;
        default:
          error = new SyntaxError(`Bad syntax at offset ${errorIndex}: '${suffix}'...`);
          word = "";
          break;
      }
      error.index = errorIndex;
      error.length = word.length;
      C._free(sourceAddress);
      throw error;
    }

    const stringCount = C._ts_query_string_count(address);
    const captureCount = C._ts_query_capture_count(address);
    const patternCount = C._ts_query_pattern_count(address);
    const captureNames = new Array(captureCount);
    const stringValues = new Array(stringCount);

    for (let i = 0; i < captureCount; i++) {
      const nameAddress = C._ts_query_capture_name_for_id(
        address,
        i,
        TRANSFER_BUFFER
      );
      const nameLength = getValue(TRANSFER_BUFFER, 'i32');
      captureNames[i] = UTF8ToString(nameAddress, nameLength);
    }

    for (let i = 0; i < stringCount; i++) {
      const valueAddress = C._ts_query_string_value_for_id(
        address,
        i,
        TRANSFER_BUFFER
      );
      const nameLength = getValue(TRANSFER_BUFFER, 'i32');
      stringValues[i] = UTF8ToString(valueAddress, nameLength);
    }

    const setProperties = new Array(patternCount);
    const assertedProperties = new Array(patternCount);
    const refutedProperties = new Array(patternCount);
    const predicates = new Array(patternCount);
    const textPredicates = new Array(patternCount);
    for (let i = 0; i < patternCount; i++) {
      const predicatesAddress = C._ts_query_predicates_for_pattern(
        address,
        i,
        TRANSFER_BUFFER
      );
      const stepCount = getValue(TRANSFER_BUFFER, 'i32');

      predicates[i] = [];
      textPredicates[i] = [];

      const steps = [];
      let stepAddress = predicatesAddress;
      for (let j = 0; j < stepCount; j++) {
        const stepType = getValue(stepAddress, 'i32');
        stepAddress += SIZE_OF_INT;
        const stepValueId = getValue(stepAddress, 'i32');
        stepAddress += SIZE_OF_INT;
        if (stepType === PREDICATE_STEP_TYPE_CAPTURE) {
          steps.push({type: 'capture', name: captureNames[stepValueId]});
        } else if (stepType === PREDICATE_STEP_TYPE_STRING) {
          steps.push({type: 'string', value: stringValues[stepValueId]});
        } else if (steps.length > 0) {
          if (steps[0].type !== 'string') {
            throw new Error('Predicates must begin with a literal value');
          }
          const operator = steps[0].value;
          let isPositive = true;
          switch (operator) {
            case 'not-eq?':
              isPositive = false;
            case 'eq?':
              if (steps.length !== 3) throw new Error(
                `Wrong number of arguments to \`#eq?\` predicate. Expected 2, got ${steps.length - 1}`
              );
              if (steps[1].type !== 'capture') throw new Error(
                `First argument of \`#eq?\` predicate must be a capture. Got "${steps[1].value}"`
              );
              if (steps[2].type === 'capture') {
                const captureName1 = steps[1].name;
                const captureName2 = steps[2].name;
                textPredicates[i].push(function(captures) {
                  let node1, node2
                  for (const c of captures) {
                    if (c.name === captureName1) node1 = c.node;
                    if (c.name === captureName2) node2 = c.node;
                  }
                  if(node1 === undefined || node2 === undefined) return true;
                  return (node1.text === node2.text) === isPositive;
                });
              } else {
                const captureName = steps[1].name;
                const stringValue = steps[2].value;
                textPredicates[i].push(function(captures) {
                  for (const c of captures) {
                    if (c.name === captureName) {
                      return (c.node.text === stringValue) === isPositive;
                    };
                  }
                  return true;
                });
              }
              break;

            case 'not-match?':
              isPositive = false;
            case 'match?':
              if (steps.length !== 3) throw new Error(
                `Wrong number of arguments to \`#match?\` predicate. Expected 2, got ${steps.length - 1}.`
              );
              if (steps[1].type !== 'capture') throw new Error(
                `First argument of \`#match?\` predicate must be a capture. Got "${steps[1].value}".`
              );
              if (steps[2].type !== 'string') throw new Error(
                `Second argument of \`#match?\` predicate must be a string. Got @${steps[2].value}.`
              );
              const captureName = steps[1].name;
              const regex = new RegExp(steps[2].value);
              textPredicates[i].push(function(captures) {
                for (const c of captures) {
                  if (c.name === captureName) return regex.test(c.node.text) === isPositive;
                }
                return true;
              });
              break;

            case 'set!':
              if (steps.length < 2 || steps.length > 3) throw new Error(
                `Wrong number of arguments to \`#set!\` predicate. Expected 1 or 2. Got ${steps.length - 1}.`
              );
              if (steps.some(s => s.type !== 'string')) throw new Error(
                `Arguments to \`#set!\` predicate must be a strings.".`
              );
              if (!setProperties[i]) setProperties[i] = {};
              setProperties[i][steps[1].value] = steps[2] ? steps[2].value : null;
              break;

            case 'is?':
            case 'is-not?':
              if (steps.length < 2 || steps.length > 3) throw new Error(
                `Wrong number of arguments to \`#${operator}\` predicate. Expected 1 or 2. Got ${steps.length - 1}.`
              );
              if (steps.some(s => s.type !== 'string')) throw new Error(
                `Arguments to \`#${operator}\` predicate must be a strings.".`
              );
              const properties = operator === 'is?' ? assertedProperties : refutedProperties;
              if (!properties[i]) properties[i] = {};
              properties[i][steps[1].value] = steps[2] ? steps[2].value : null;
              break;

            default:
              predicates[i].push({operator, operands: steps.slice(1)});
          }

          steps.length = 0;
        }
      }

      Object.freeze(setProperties[i]);
      Object.freeze(assertedProperties[i]);
      Object.freeze(refutedProperties[i]);
    }

    C._free(sourceAddress);
    return new Query(
      INTERNAL,
      address,
      captureNames,
      textPredicates,
      predicates,
      Object.freeze(setProperties),
      Object.freeze(assertedProperties),
      Object.freeze(refutedProperties)
    );
  }

  static load(input) {
    let bytes;
    if (input instanceof Uint8Array) {
      bytes = Promise.resolve(input);
    } else {
      const url = input;
      if (
        typeof process !== 'undefined' &&
        process.versions &&
        process.versions.node
      ) {
        const fs = require('fs');
        bytes = Promise.resolve(fs.readFileSync(url));
      } else {
        bytes = fetch(url)
          .then(response => response.arrayBuffer()
            .then(buffer => {
              if (response.ok) {
                return new Uint8Array(buffer);
              } else {
                const body = new TextDecoder('utf-8').decode(buffer);
                throw new Error(`Language.load failed with status ${response.status}.\n\n${body}`)
              }
            }));
      }
    }

    // emscripten-core/emscripten#12969
    const loadModule =
      typeof loadSideModule === 'function'
      ? loadSideModule
      : loadWebAssemblyModule;

    return bytes
      .then(bytes => loadModule(bytes, {loadAsync: true}))
      .then(mod => {
        const symbolNames = Object.keys(mod)
        const functionName = symbolNames.find(key =>
          LANGUAGE_FUNCTION_REGEX.test(key) &&
          !key.includes("external_scanner_")
        );
        if (!functionName) {
          console.log(`Couldn't find language function in WASM file. Symbols:\n${JSON.stringify(symbolNames, null, 2)}`)
        }
        const languageAddress = mod[functionName]();
        return new Language(INTERNAL, languageAddress);
      });
  }
}

class Query {
  constructor(
    internal, address, captureNames, textPredicates, predicates,
    setProperties, assertedProperties, refutedProperties
  ) {
    assertInternal(internal);
    this[0] = address;
    this.captureNames = captureNames;
    this.textPredicates = textPredicates;
    this.predicates = predicates;
    this.setProperties = setProperties;
    this.assertedProperties = assertedProperties;
    this.refutedProperties = refutedProperties;
    this.exceededMatchLimit = false;
  }

  delete() {
    C._ts_query_delete(this[0]);
    this[0] = 0;
  }

  matches(node, startPosition, endPosition, options) {
    if (!startPosition) startPosition = ZERO_POINT;
    if (!endPosition) endPosition = ZERO_POINT;
    if (!options) options = {};

    let matchLimit = options.matchLimit;
    if (typeof matchLimit === 'undefined') {
      matchLimit = 0;
    } else if (typeof matchLimit !== 'number') {
      throw new Error('Arguments must be numbers');
    }

    marshalNode(node);

    C._ts_query_matches_wasm(
      this[0],
      node.tree[0],
      startPosition.row,
      startPosition.column,
      endPosition.row,
      endPosition.column,
      matchLimit
    );

    const rawCount = getValue(TRANSFER_BUFFER, 'i32');
    const startAddress = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
    const didExceedMatchLimit = getValue(TRANSFER_BUFFER + 2 * SIZE_OF_INT, 'i32');
    const result = new Array(rawCount);
    this.exceededMatchLimit = !!didExceedMatchLimit;

    let filteredCount = 0;
    let address = startAddress;
    for (let i = 0; i < rawCount; i++) {
      const pattern = getValue(address, 'i32');
      address += SIZE_OF_INT;
      const captureCount = getValue(address, 'i32');
      address += SIZE_OF_INT;

      const captures = new Array(captureCount);
      address = unmarshalCaptures(this, node.tree, address, captures);
      if (this.textPredicates[pattern].every(p => p(captures))) {
        result[filteredCount++] = {pattern, captures};
        const setProperties = this.setProperties[pattern];
        if (setProperties) result[i].setProperties = setProperties;
        const assertedProperties = this.assertedProperties[pattern];
        if (assertedProperties) result[i].assertedProperties = assertedProperties;
        const refutedProperties = this.refutedProperties[pattern];
        if (refutedProperties) result[i].refutedProperties = refutedProperties;
      }
    }
    result.length = filteredCount;

    C._free(startAddress);
    return result;
  }

  captures(node, startPosition, endPosition, options) {
    if (!startPosition) startPosition = ZERO_POINT;
    if (!endPosition) endPosition = ZERO_POINT;
    if (!options) options = {};

    let matchLimit = options.matchLimit;
    if (typeof matchLimit === 'undefined') {
      matchLimit = 0;
    } else if (typeof matchLimit !== 'number') {
      throw new Error('Arguments must be numbers');
    }

    marshalNode(node);

    C._ts_query_captures_wasm(
      this[0],
      node.tree[0],
      startPosition.row,
      startPosition.column,
      endPosition.row,
      endPosition.column,
      matchLimit
    );

    const count = getValue(TRANSFER_BUFFER, 'i32');
    const startAddress = getValue(TRANSFER_BUFFER + SIZE_OF_INT, 'i32');
    const didExceedMatchLimit = getValue(TRANSFER_BUFFER + 2 * SIZE_OF_INT, 'i32');
    const result = [];
    this.exceededMatchLimit = !!didExceedMatchLimit;

    const captures = [];
    let address = startAddress;
    for (let i = 0; i < count; i++) {
      const pattern = getValue(address, 'i32');
      address += SIZE_OF_INT;
      const captureCount = getValue(address, 'i32');
      address += SIZE_OF_INT;
      const captureIndex = getValue(address, 'i32');
      address += SIZE_OF_INT;

      captures.length = captureCount
      address = unmarshalCaptures(this, node.tree, address, captures);

      if (this.textPredicates[pattern].every(p => p(captures))) {
        const capture = captures[captureIndex];
        const setProperties = this.setProperties[pattern];
        if (setProperties) capture.setProperties = setProperties;
        const assertedProperties = this.assertedProperties[pattern];
        if (assertedProperties) capture.assertedProperties = assertedProperties;
        const refutedProperties = this.refutedProperties[pattern];
        if (refutedProperties) capture.refutedProperties = refutedProperties;
        result.push(capture);
      }
    }

    C._free(startAddress);
    return result;
  }

  predicatesForPattern(patternIndex) {
    return this.predicates[patternIndex]
  }

  didExceedMatchLimit() {
    return this.exceededMatchLimit;
  }
}

function getText(tree, startIndex, endIndex) {
  const length = endIndex - startIndex;
  let result = tree.textCallback(startIndex, null, endIndex);
  startIndex += result.length;
  while (startIndex < endIndex) {
    const string = tree.textCallback(startIndex, null, endIndex);
    if (string && string.length > 0) {
      startIndex += string.length;
      result += string;
    } else {
      break;
    }
  }
  if (startIndex > endIndex) {
    result = result.slice(0, length);
  }
  return result;
}

function unmarshalCaptures(query, tree, address, result) {
  for (let i = 0, n = result.length; i < n; i++) {
    const captureIndex = getValue(address, 'i32');
    address += SIZE_OF_INT;
    const node = unmarshalNode(tree, address);
    address += SIZE_OF_NODE;
    result[i] = {name: query.captureNames[captureIndex], node};
  }
  return address;
}

function assertInternal(x) {
  if (x !== INTERNAL) throw new Error('Illegal constructor')
}

function isPoint(point) {
  return (
    point &&
    typeof point.row === 'number' &&
    typeof point.column === 'number'
  );
}

function marshalNode(node) {
  let address = TRANSFER_BUFFER;
  setValue(address, node.id, 'i32');
  address += SIZE_OF_INT;
  setValue(address, node.startIndex, 'i32');
  address += SIZE_OF_INT;
  setValue(address, node.startPosition.row, 'i32');
  address += SIZE_OF_INT;
  setValue(address, node.startPosition.column, 'i32');
  address += SIZE_OF_INT;
  setValue(address, node[0], 'i32');
}

function unmarshalNode(tree, address = TRANSFER_BUFFER) {
  const id = getValue(address, 'i32');
  address += SIZE_OF_INT;
  if (id === 0) return null;

  const index = getValue(address, 'i32');
  address += SIZE_OF_INT;
  const row = getValue(address, 'i32');
  address += SIZE_OF_INT;
  const column = getValue(address, 'i32');
  address += SIZE_OF_INT;
  const other = getValue(address, 'i32');

  const result = new Node(INTERNAL, tree);
  result.id = id;
  result.startIndex = index;
  result.startPosition = {row, column};
  result[0] = other;

  return result;
}

function marshalTreeCursor(cursor, address = TRANSFER_BUFFER) {
  setValue(address + 0 * SIZE_OF_INT, cursor[0], 'i32'),
  setValue(address + 1 * SIZE_OF_INT, cursor[1], 'i32'),
  setValue(address + 2 * SIZE_OF_INT, cursor[2], 'i32')
}

function unmarshalTreeCursor(cursor) {
  cursor[0] = getValue(TRANSFER_BUFFER + 0 * SIZE_OF_INT, 'i32'),
  cursor[1] = getValue(TRANSFER_BUFFER + 1 * SIZE_OF_INT, 'i32'),
  cursor[2] = getValue(TRANSFER_BUFFER + 2 * SIZE_OF_INT, 'i32')
}

function marshalPoint(address, point) {
  setValue(address, point.row, 'i32')
  setValue(address + SIZE_OF_INT, point.column, 'i32')
}

function unmarshalPoint(address) {
  return {
    row: getValue(address, 'i32'),
    column: getValue(address + SIZE_OF_INT, 'i32')
  }
}

function marshalRange(address, range) {
  marshalPoint(address, range.startPosition); address += SIZE_OF_POINT;
  marshalPoint(address, range.endPosition); address += SIZE_OF_POINT;
  setValue(address, range.startIndex, 'i32'); address += SIZE_OF_INT;
  setValue(address, range.endIndex, 'i32'); address += SIZE_OF_INT;
}

function unmarshalRange(address) {
  const result = {};
  result.startPosition = unmarshalPoint(address); address += SIZE_OF_POINT;
  result.endPosition = unmarshalPoint(address); address += SIZE_OF_POINT;
  result.startIndex = getValue(address, 'i32'); address += SIZE_OF_INT;
  result.endIndex = getValue(address, 'i32');
  return result;
}

function marshalEdit(edit) {
  let address = TRANSFER_BUFFER;
  marshalPoint(address, edit.startPosition); address += SIZE_OF_POINT;
  marshalPoint(address, edit.oldEndPosition); address += SIZE_OF_POINT;
  marshalPoint(address, edit.newEndPosition); address += SIZE_OF_POINT;
  setValue(address, edit.startIndex, 'i32'); address += SIZE_OF_INT;
  setValue(address, edit.oldEndIndex, 'i32'); address += SIZE_OF_INT;
  setValue(address, edit.newEndIndex, 'i32'); address += SIZE_OF_INT;
}

        for (const name of Object.getOwnPropertyNames(ParserImpl.prototype)) {
          Object.defineProperty(Parser.prototype, name, {
            value: ParserImpl.prototype[name],
            enumerable: false,
            writable: false,
          })
        }

        Parser.Language = Language;
        Module.onRuntimeInitialized = () => {
          ParserImpl.init();
          resolveInitPromise();
        };
      });
    }
  }

  return Parser;
}();

if (typeof exports === 'object') {
  module.exports = TreeSitter;
}
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.ajv7 = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.regexpCode = exports.getProperty = exports.safeStringify = exports.stringify = exports.strConcat = exports.addCodeArg = exports.str = exports._ = exports.nil = exports._Code = exports.Name = exports.IDENTIFIER = exports._CodeOrName = void 0;
class _CodeOrName {
}
exports._CodeOrName = _CodeOrName;
exports.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
class Name extends _CodeOrName {
    constructor(s) {
        super();
        if (!exports.IDENTIFIER.test(s))
            throw new Error("CodeGen: name must be a valid identifier");
        this.str = s;
    }
    toString() {
        return this.str;
    }
    emptyStr() {
        return false;
    }
    get names() {
        return { [this.str]: 1 };
    }
}
exports.Name = Name;
class _Code extends _CodeOrName {
    constructor(code) {
        super();
        this._items = typeof code === "string" ? [code] : code;
    }
    toString() {
        return this.str;
    }
    emptyStr() {
        if (this._items.length > 1)
            return false;
        const item = this._items[0];
        return item === "" || item === '""';
    }
    get str() {
        var _a;
        return ((_a = this._str) !== null && _a !== void 0 ? _a : (this._str = this._items.reduce((s, c) => `${s}${c}`, "")));
    }
    get names() {
        var _a;
        return ((_a = this._names) !== null && _a !== void 0 ? _a : (this._names = this._items.reduce((names, c) => {
            if (c instanceof Name)
                names[c.str] = (names[c.str] || 0) + 1;
            return names;
        }, {})));
    }
}
exports._Code = _Code;
exports.nil = new _Code("");
function _(strs, ...args) {
    const code = [strs[0]];
    let i = 0;
    while (i < args.length) {
        addCodeArg(code, args[i]);
        code.push(strs[++i]);
    }
    return new _Code(code);
}
exports._ = _;
const plus = new _Code("+");
function str(strs, ...args) {
    const expr = [safeStringify(strs[0])];
    let i = 0;
    while (i < args.length) {
        expr.push(plus);
        addCodeArg(expr, args[i]);
        expr.push(plus, safeStringify(strs[++i]));
    }
    optimize(expr);
    return new _Code(expr);
}
exports.str = str;
function addCodeArg(code, arg) {
    if (arg instanceof _Code)
        code.push(...arg._items);
    else if (arg instanceof Name)
        code.push(arg);
    else
        code.push(interpolate(arg));
}
exports.addCodeArg = addCodeArg;
function optimize(expr) {
    let i = 1;
    while (i < expr.length - 1) {
        if (expr[i] === plus) {
            const res = mergeExprItems(expr[i - 1], expr[i + 1]);
            if (res !== undefined) {
                expr.splice(i - 1, 3, res);
                continue;
            }
            expr[i++] = "+";
        }
        i++;
    }
}
function mergeExprItems(a, b) {
    if (b === '""')
        return a;
    if (a === '""')
        return b;
    if (typeof a == "string") {
        if (b instanceof Name || a[a.length - 1] !== '"')
            return;
        if (typeof b != "string")
            return `${a.slice(0, -1)}${b}"`;
        if (b[0] === '"')
            return a.slice(0, -1) + b.slice(1);
        return;
    }
    if (typeof b == "string" && b[0] === '"' && !(a instanceof Name))
        return `"${a}${b.slice(1)}`;
    return;
}
function strConcat(c1, c2) {
    return c2.emptyStr() ? c1 : c1.emptyStr() ? c2 : str `${c1}${c2}`;
}
exports.strConcat = strConcat;
// TODO do not allow arrays here
function interpolate(x) {
    return typeof x == "number" || typeof x == "boolean" || x === null
        ? x
        : safeStringify(Array.isArray(x) ? x.join(",") : x);
}
function stringify(x) {
    return new _Code(safeStringify(x));
}
exports.stringify = stringify;
function safeStringify(x) {
    return JSON.stringify(x)
        .replace(/\u2028/g, "\\u2028")
        .replace(/\u2029/g, "\\u2029");
}
exports.safeStringify = safeStringify;
function getProperty(key) {
    return typeof key == "string" && exports.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _ `[${key}]`;
}
exports.getProperty = getProperty;
function regexpCode(rx) {
    return new _Code(rx.toString());
}
exports.regexpCode = regexpCode;

},{}],2:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.or = exports.and = exports.not = exports.CodeGen = exports.operators = exports.varKinds = exports.ValueScopeName = exports.ValueScope = exports.Scope = exports.Name = exports.regexpCode = exports.stringify = exports.getProperty = exports.nil = exports.strConcat = exports.str = exports._ = void 0;
const code_1 = require("./code");
const scope_1 = require("./scope");
var code_2 = require("./code");
Object.defineProperty(exports, "_", { enumerable: true, get: function () { return code_2._; } });
Object.defineProperty(exports, "str", { enumerable: true, get: function () { return code_2.str; } });
Object.defineProperty(exports, "strConcat", { enumerable: true, get: function () { return code_2.strConcat; } });
Object.defineProperty(exports, "nil", { enumerable: true, get: function () { return code_2.nil; } });
Object.defineProperty(exports, "getProperty", { enumerable: true, get: function () { return code_2.getProperty; } });
Object.defineProperty(exports, "stringify", { enumerable: true, get: function () { return code_2.stringify; } });
Object.defineProperty(exports, "regexpCode", { enumerable: true, get: function () { return code_2.regexpCode; } });
Object.defineProperty(exports, "Name", { enumerable: true, get: function () { return code_2.Name; } });
var scope_2 = require("./scope");
Object.defineProperty(exports, "Scope", { enumerable: true, get: function () { return scope_2.Scope; } });
Object.defineProperty(exports, "ValueScope", { enumerable: true, get: function () { return scope_2.ValueScope; } });
Object.defineProperty(exports, "ValueScopeName", { enumerable: true, get: function () { return scope_2.ValueScopeName; } });
Object.defineProperty(exports, "varKinds", { enumerable: true, get: function () { return scope_2.varKinds; } });
exports.operators = {
    GT: new code_1._Code(">"),
    GTE: new code_1._Code(">="),
    LT: new code_1._Code("<"),
    LTE: new code_1._Code("<="),
    EQ: new code_1._Code("==="),
    NEQ: new code_1._Code("!=="),
    NOT: new code_1._Code("!"),
    OR: new code_1._Code("||"),
    AND: new code_1._Code("&&"),
    ADD: new code_1._Code("+"),
};
class Node {
    optimizeNodes() {
        return this;
    }
    optimizeNames(_names, _constants) {
        return this;
    }
}
class Def extends Node {
    constructor(varKind, name, rhs) {
        super();
        this.varKind = varKind;
        this.name = name;
        this.rhs = rhs;
    }
    render({ es5, _n }) {
        const varKind = es5 ? scope_1.varKinds.var : this.varKind;
        const rhs = this.rhs === undefined ? "" : ` = ${this.rhs}`;
        return `${varKind} ${this.name}${rhs};` + _n;
    }
    optimizeNames(names, constants) {
        if (!names[this.name.str])
            return;
        if (this.rhs)
            this.rhs = optimizeExpr(this.rhs, names, constants);
        return this;
    }
    get names() {
        return this.rhs instanceof code_1._CodeOrName ? this.rhs.names : {};
    }
}
class Assign extends Node {
    constructor(lhs, rhs, sideEffects) {
        super();
        this.lhs = lhs;
        this.rhs = rhs;
        this.sideEffects = sideEffects;
    }
    render({ _n }) {
        return `${this.lhs} = ${this.rhs};` + _n;
    }
    optimizeNames(names, constants) {
        if (this.lhs instanceof code_1.Name && !names[this.lhs.str] && !this.sideEffects)
            return;
        this.rhs = optimizeExpr(this.rhs, names, constants);
        return this;
    }
    get names() {
        const names = this.lhs instanceof code_1.Name ? {} : { ...this.lhs.names };
        return addExprNames(names, this.rhs);
    }
}
class AssignOp extends Assign {
    constructor(lhs, op, rhs, sideEffects) {
        super(lhs, rhs, sideEffects);
        this.op = op;
    }
    render({ _n }) {
        return `${this.lhs} ${this.op}= ${this.rhs};` + _n;
    }
}
class Label extends Node {
    constructor(label) {
        super();
        this.label = label;
        this.names = {};
    }
    render({ _n }) {
        return `${this.label}:` + _n;
    }
}
class Break extends Node {
    constructor(label) {
        super();
        this.label = label;
        this.names = {};
    }
    render({ _n }) {
        const label = this.label ? ` ${this.label}` : "";
        return `break${label};` + _n;
    }
}
class Throw extends Node {
    constructor(error) {
        super();
        this.error = error;
    }
    render({ _n }) {
        return `throw ${this.error};` + _n;
    }
    get names() {
        return this.error.names;
    }
}
class AnyCode extends Node {
    constructor(code) {
        super();
        this.code = code;
    }
    render({ _n }) {
        return `${this.code};` + _n;
    }
    optimizeNodes() {
        return `${this.code}` ? this : undefined;
    }
    optimizeNames(names, constants) {
        this.code = optimizeExpr(this.code, names, constants);
        return this;
    }
    get names() {
        return this.code instanceof code_1._CodeOrName ? this.code.names : {};
    }
}
class ParentNode extends Node {
    constructor(nodes = []) {
        super();
        this.nodes = nodes;
    }
    render(opts) {
        return this.nodes.reduce((code, n) => code + n.render(opts), "");
    }
    optimizeNodes() {
        const { nodes } = this;
        let i = nodes.length;
        while (i--) {
            const n = nodes[i].optimizeNodes();
            if (Array.isArray(n))
                nodes.splice(i, 1, ...n);
            else if (n)
                nodes[i] = n;
            else
                nodes.splice(i, 1);
        }
        return nodes.length > 0 ? this : undefined;
    }
    optimizeNames(names, constants) {
        const { nodes } = this;
        let i = nodes.length;
        while (i--) {
            // iterating backwards improves 1-pass optimization
            const n = nodes[i];
            if (n.optimizeNames(names, constants))
                continue;
            subtractNames(names, n.names);
            nodes.splice(i, 1);
        }
        return nodes.length > 0 ? this : undefined;
    }
    get names() {
        return this.nodes.reduce((names, n) => addNames(names, n.names), {});
    }
}
class BlockNode extends ParentNode {
    render(opts) {
        return "{" + opts._n + super.render(opts) + "}" + opts._n;
    }
}
class Root extends ParentNode {
}
class Else extends BlockNode {
}
Else.kind = "else";
class If extends BlockNode {
    constructor(condition, nodes) {
        super(nodes);
        this.condition = condition;
    }
    render(opts) {
        let code = `if(${this.condition})` + super.render(opts);
        if (this.else)
            code += "else " + this.else.render(opts);
        return code;
    }
    optimizeNodes() {
        super.optimizeNodes();
        const cond = this.condition;
        if (cond === true)
            return this.nodes; // else is ignored here
        let e = this.else;
        if (e) {
            const ns = e.optimizeNodes();
            e = this.else = Array.isArray(ns) ? new Else(ns) : ns;
        }
        if (e) {
            if (cond === false)
                return e instanceof If ? e : e.nodes;
            if (this.nodes.length)
                return this;
            return new If(not(cond), e instanceof If ? [e] : e.nodes);
        }
        if (cond === false || !this.nodes.length)
            return undefined;
        return this;
    }
    optimizeNames(names, constants) {
        var _a;
        this.else = (_a = this.else) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
        if (!(super.optimizeNames(names, constants) || this.else))
            return;
        this.condition = optimizeExpr(this.condition, names, constants);
        return this;
    }
    get names() {
        const names = super.names;
        addExprNames(names, this.condition);
        if (this.else)
            addNames(names, this.else.names);
        return names;
    }
}
If.kind = "if";
class For extends BlockNode {
}
For.kind = "for";
class ForLoop extends For {
    constructor(iteration) {
        super();
        this.iteration = iteration;
    }
    render(opts) {
        return `for(${this.iteration})` + super.render(opts);
    }
    optimizeNames(names, constants) {
        if (!super.optimizeNames(names, constants))
            return;
        this.iteration = optimizeExpr(this.iteration, names, constants);
        return this;
    }
    get names() {
        return addNames(super.names, this.iteration.names);
    }
}
class ForRange extends For {
    constructor(varKind, name, from, to) {
        super();
        this.varKind = varKind;
        this.name = name;
        this.from = from;
        this.to = to;
    }
    render(opts) {
        const varKind = opts.es5 ? scope_1.varKinds.var : this.varKind;
        const { name, from, to } = this;
        return `for(${varKind} ${name}=${from}; ${name}<${to}; ${name}++)` + super.render(opts);
    }
    get names() {
        const names = addExprNames(super.names, this.from);
        return addExprNames(names, this.to);
    }
}
class ForIter extends For {
    constructor(loop, varKind, name, iterable) {
        super();
        this.loop = loop;
        this.varKind = varKind;
        this.name = name;
        this.iterable = iterable;
    }
    render(opts) {
        return `for(${this.varKind} ${this.name} ${this.loop} ${this.iterable})` + super.render(opts);
    }
    optimizeNames(names, constants) {
        if (!super.optimizeNames(names, constants))
            return;
        this.iterable = optimizeExpr(this.iterable, names, constants);
        return this;
    }
    get names() {
        return addNames(super.names, this.iterable.names);
    }
}
class Func extends BlockNode {
    constructor(name, args, async) {
        super();
        this.name = name;
        this.args = args;
        this.async = async;
    }
    render(opts) {
        const _async = this.async ? "async " : "";
        return `${_async}function ${this.name}(${this.args})` + super.render(opts);
    }
}
Func.kind = "func";
class Return extends ParentNode {
    render(opts) {
        return "return " + super.render(opts);
    }
}
Return.kind = "return";
class Try extends BlockNode {
    render(opts) {
        let code = "try" + super.render(opts);
        if (this.catch)
            code += this.catch.render(opts);
        if (this.finally)
            code += this.finally.render(opts);
        return code;
    }
    optimizeNodes() {
        var _a, _b;
        super.optimizeNodes();
        (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNodes();
        (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNodes();
        return this;
    }
    optimizeNames(names, constants) {
        var _a, _b;
        super.optimizeNames(names, constants);
        (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
        (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNames(names, constants);
        return this;
    }
    get names() {
        const names = super.names;
        if (this.catch)
            addNames(names, this.catch.names);
        if (this.finally)
            addNames(names, this.finally.names);
        return names;
    }
}
class Catch extends BlockNode {
    constructor(error) {
        super();
        this.error = error;
    }
    render(opts) {
        return `catch(${this.error})` + super.render(opts);
    }
}
Catch.kind = "catch";
class Finally extends BlockNode {
    render(opts) {
        return "finally" + super.render(opts);
    }
}
Finally.kind = "finally";
class CodeGen {
    constructor(extScope, opts = {}) {
        this._values = {};
        this._blockStarts = [];
        this._constants = {};
        this.opts = { ...opts, _n: opts.lines ? "\n" : "" };
        this._extScope = extScope;
        this._scope = new scope_1.Scope({ parent: extScope });
        this._nodes = [new Root()];
    }
    toString() {
        return this._root.render(this.opts);
    }
    // returns unique name in the internal scope
    name(prefix) {
        return this._scope.name(prefix);
    }
    // reserves unique name in the external scope
    scopeName(prefix) {
        return this._extScope.name(prefix);
    }
    // reserves unique name in the external scope and assigns value to it
    scopeValue(prefixOrName, value) {
        const name = this._extScope.value(prefixOrName, value);
        const vs = this._values[name.prefix] || (this._values[name.prefix] = new Set());
        vs.add(name);
        return name;
    }
    getScopeValue(prefix, keyOrRef) {
        return this._extScope.getValue(prefix, keyOrRef);
    }
    // return code that assigns values in the external scope to the names that are used internally
    // (same names that were returned by gen.scopeName or gen.scopeValue)
    scopeRefs(scopeName) {
        return this._extScope.scopeRefs(scopeName, this._values);
    }
    scopeCode() {
        return this._extScope.scopeCode(this._values);
    }
    _def(varKind, nameOrPrefix, rhs, constant) {
        const name = this._scope.toName(nameOrPrefix);
        if (rhs !== undefined && constant)
            this._constants[name.str] = rhs;
        this._leafNode(new Def(varKind, name, rhs));
        return name;
    }
    // `const` declaration (`var` in es5 mode)
    const(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.const, nameOrPrefix, rhs, _constant);
    }
    // `let` declaration with optional assignment (`var` in es5 mode)
    let(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.let, nameOrPrefix, rhs, _constant);
    }
    // `var` declaration with optional assignment
    var(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.var, nameOrPrefix, rhs, _constant);
    }
    // assignment code
    assign(lhs, rhs, sideEffects) {
        return this._leafNode(new Assign(lhs, rhs, sideEffects));
    }
    // `+=` code
    add(lhs, rhs) {
        return this._leafNode(new AssignOp(lhs, exports.operators.ADD, rhs));
    }
    // appends passed SafeExpr to code or executes Block
    code(c) {
        if (typeof c == "function")
            c();
        else if (c !== code_1.nil)
            this._leafNode(new AnyCode(c));
        return this;
    }
    // returns code for object literal for the passed argument list of key-value pairs
    object(...keyValues) {
        const code = ["{"];
        for (const [key, value] of keyValues) {
            if (code.length > 1)
                code.push(",");
            code.push(key);
            if (key !== value || this.opts.es5) {
                code.push(":");
                code_1.addCodeArg(code, value);
            }
        }
        code.push("}");
        return new code_1._Code(code);
    }
    // `if` clause (or statement if `thenBody` and, optionally, `elseBody` are passed)
    if(condition, thenBody, elseBody) {
        this._blockNode(new If(condition));
        if (thenBody && elseBody) {
            this.code(thenBody).else().code(elseBody).endIf();
        }
        else if (thenBody) {
            this.code(thenBody).endIf();
        }
        else if (elseBody) {
            throw new Error('CodeGen: "else" body without "then" body');
        }
        return this;
    }
    // `else if` clause - invalid without `if` or after `else` clauses
    elseIf(condition) {
        return this._elseNode(new If(condition));
    }
    // `else` clause - only valid after `if` or `else if` clauses
    else() {
        return this._elseNode(new Else());
    }
    // end `if` statement (needed if gen.if was used only with condition)
    endIf() {
        return this._endBlockNode(If, Else);
    }
    _for(node, forBody) {
        this._blockNode(node);
        if (forBody)
            this.code(forBody).endFor();
        return this;
    }
    // a generic `for` clause (or statement if `forBody` is passed)
    for(iteration, forBody) {
        return this._for(new ForLoop(iteration), forBody);
    }
    // `for` statement for a range of values
    forRange(nameOrPrefix, from, to, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.let) {
        const name = this._scope.toName(nameOrPrefix);
        return this._for(new ForRange(varKind, name, from, to), () => forBody(name));
    }
    // `for-of` statement (in es5 mode replace with a normal for loop)
    forOf(nameOrPrefix, iterable, forBody, varKind = scope_1.varKinds.const) {
        const name = this._scope.toName(nameOrPrefix);
        if (this.opts.es5) {
            const arr = iterable instanceof code_1.Name ? iterable : this.var("_arr", iterable);
            return this.forRange("_i", 0, code_1._ `${arr}.length`, (i) => {
                this.var(name, code_1._ `${arr}[${i}]`);
                forBody(name);
            });
        }
        return this._for(new ForIter("of", varKind, name, iterable), () => forBody(name));
    }
    // `for-in` statement.
    // With option `ownProperties` replaced with a `for-of` loop for object keys
    forIn(nameOrPrefix, obj, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.const) {
        if (this.opts.ownProperties) {
            return this.forOf(nameOrPrefix, code_1._ `Object.keys(${obj})`, forBody);
        }
        const name = this._scope.toName(nameOrPrefix);
        return this._for(new ForIter("in", varKind, name, obj), () => forBody(name));
    }
    // end `for` loop
    endFor() {
        return this._endBlockNode(For);
    }
    // `label` statement
    label(label) {
        return this._leafNode(new Label(label));
    }
    // `break` statement
    break(label) {
        return this._leafNode(new Break(label));
    }
    // `return` statement
    return(value) {
        const node = new Return();
        this._blockNode(node);
        this.code(value);
        if (node.nodes.length !== 1)
            throw new Error('CodeGen: "return" should have one node');
        return this._endBlockNode(Return);
    }
    // `try` statement
    try(tryBody, catchCode, finallyCode) {
        if (!catchCode && !finallyCode)
            throw new Error('CodeGen: "try" without "catch" and "finally"');
        const node = new Try();
        this._blockNode(node);
        this.code(tryBody);
        if (catchCode) {
            const error = this.name("e");
            this._currNode = node.catch = new Catch(error);
            catchCode(error);
        }
        if (finallyCode) {
            this._currNode = node.finally = new Finally();
            this.code(finallyCode);
        }
        return this._endBlockNode(Catch, Finally);
    }
    // `throw` statement
    throw(error) {
        return this._leafNode(new Throw(error));
    }
    // start self-balancing block
    block(body, nodeCount) {
        this._blockStarts.push(this._nodes.length);
        if (body)
            this.code(body).endBlock(nodeCount);
        return this;
    }
    // end the current self-balancing block
    endBlock(nodeCount) {
        const len = this._blockStarts.pop();
        if (len === undefined)
            throw new Error("CodeGen: not in self-balancing block");
        const toClose = this._nodes.length - len;
        if (toClose < 0 || (nodeCount !== undefined && toClose !== nodeCount)) {
            throw new Error(`CodeGen: wrong number of nodes: ${toClose} vs ${nodeCount} expected`);
        }
        this._nodes.length = len;
        return this;
    }
    // `function` heading (or definition if funcBody is passed)
    func(name, args = code_1.nil, async, funcBody) {
        this._blockNode(new Func(name, args, async));
        if (funcBody)
            this.code(funcBody).endFunc();
        return this;
    }
    // end function definition
    endFunc() {
        return this._endBlockNode(Func);
    }
    optimize(n = 1) {
        while (n-- > 0) {
            this._root.optimizeNodes();
            this._root.optimizeNames(this._root.names, this._constants);
        }
    }
    _leafNode(node) {
        this._currNode.nodes.push(node);
        return this;
    }
    _blockNode(node) {
        this._currNode.nodes.push(node);
        this._nodes.push(node);
    }
    _endBlockNode(N1, N2) {
        const n = this._currNode;
        if (n instanceof N1 || (N2 && n instanceof N2)) {
            this._nodes.pop();
            return this;
        }
        throw new Error(`CodeGen: not in block "${N2 ? `${N1.kind}/${N2.kind}` : N1.kind}"`);
    }
    _elseNode(node) {
        const n = this._currNode;
        if (!(n instanceof If)) {
            throw new Error('CodeGen: "else" without "if"');
        }
        this._currNode = n.else = node;
        return this;
    }
    get _root() {
        return this._nodes[0];
    }
    get _currNode() {
        const ns = this._nodes;
        return ns[ns.length - 1];
    }
    set _currNode(node) {
        const ns = this._nodes;
        ns[ns.length - 1] = node;
    }
}
exports.CodeGen = CodeGen;
function addNames(names, from) {
    for (const n in from)
        names[n] = (names[n] || 0) + (from[n] || 0);
    return names;
}
function addExprNames(names, from) {
    return from instanceof code_1._CodeOrName ? addNames(names, from.names) : names;
}
function optimizeExpr(expr, names, constants) {
    if (expr instanceof code_1.Name)
        return replaceName(expr);
    if (!canOptimize(expr))
        return expr;
    return new code_1._Code(expr._items.reduce((items, c) => {
        if (c instanceof code_1.Name)
            c = replaceName(c);
        if (c instanceof code_1._Code)
            items.push(...c._items);
        else
            items.push(c);
        return items;
    }, []));
    function replaceName(n) {
        const c = constants[n.str];
        if (c === undefined || names[n.str] !== 1)
            return n;
        delete names[n.str];
        return c;
    }
    function canOptimize(e) {
        return (e instanceof code_1._Code &&
            e._items.some((c) => c instanceof code_1.Name && names[c.str] === 1 && constants[c.str] !== undefined));
    }
}
function subtractNames(names, from) {
    for (const n in from)
        names[n] = (names[n] || 0) - (from[n] || 0);
}
function not(x) {
    return typeof x == "boolean" || typeof x == "number" || x === null ? !x : code_1._ `!${par(x)}`;
}
exports.not = not;
const andCode = mappend(exports.operators.AND);
// boolean AND (&&) expression with the passed arguments
function and(...args) {
    return args.reduce(andCode);
}
exports.and = and;
const orCode = mappend(exports.operators.OR);
// boolean OR (||) expression with the passed arguments
function or(...args) {
    return args.reduce(orCode);
}
exports.or = or;
function mappend(op) {
    return (x, y) => (x === code_1.nil ? y : y === code_1.nil ? x : code_1._ `${par(x)} ${op} ${par(y)}`);
}
function par(x) {
    return x instanceof code_1.Name ? x : code_1._ `(${x})`;
}

},{"./code":1,"./scope":3}],3:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValueScope = exports.ValueScopeName = exports.Scope = exports.varKinds = exports.UsedValueState = void 0;
const code_1 = require("./code");
class ValueError extends Error {
    constructor(name) {
        super(`CodeGen: "code" for ${name} not defined`);
        this.value = name.value;
    }
}
var UsedValueState;
(function (UsedValueState) {
    UsedValueState[UsedValueState["Started"] = 0] = "Started";
    UsedValueState[UsedValueState["Completed"] = 1] = "Completed";
})(UsedValueState = exports.UsedValueState || (exports.UsedValueState = {}));
exports.varKinds = {
    const: new code_1.Name("const"),
    let: new code_1.Name("let"),
    var: new code_1.Name("var"),
};
class Scope {
    constructor({ prefixes, parent } = {}) {
        this._names = {};
        this._prefixes = prefixes;
        this._parent = parent;
    }
    toName(nameOrPrefix) {
        return nameOrPrefix instanceof code_1.Name ? nameOrPrefix : this.name(nameOrPrefix);
    }
    name(prefix) {
        return new code_1.Name(this._newName(prefix));
    }
    _newName(prefix) {
        const ng = this._names[prefix] || this._nameGroup(prefix);
        return `${prefix}${ng.index++}`;
    }
    _nameGroup(prefix) {
        var _a, _b;
        if (((_b = (_a = this._parent) === null || _a === void 0 ? void 0 : _a._prefixes) === null || _b === void 0 ? void 0 : _b.has(prefix)) || (this._prefixes && !this._prefixes.has(prefix))) {
            throw new Error(`CodeGen: prefix "${prefix}" is not allowed in this scope`);
        }
        return (this._names[prefix] = { prefix, index: 0 });
    }
}
exports.Scope = Scope;
class ValueScopeName extends code_1.Name {
    constructor(prefix, nameStr) {
        super(nameStr);
        this.prefix = prefix;
    }
    setValue(value, { property, itemIndex }) {
        this.value = value;
        this.scopePath = code_1._ `.${new code_1.Name(property)}[${itemIndex}]`;
    }
}
exports.ValueScopeName = ValueScopeName;
const line = code_1._ `\n`;
class ValueScope extends Scope {
    constructor(opts) {
        super(opts);
        this._values = {};
        this._scope = opts.scope;
        this.opts = { ...opts, _n: opts.lines ? line : code_1.nil };
    }
    get() {
        return this._scope;
    }
    name(prefix) {
        return new ValueScopeName(prefix, this._newName(prefix));
    }
    value(nameOrPrefix, value) {
        var _a;
        if (value.ref === undefined)
            throw new Error("CodeGen: ref must be passed in value");
        const name = this.toName(nameOrPrefix);
        const { prefix } = name;
        const valueKey = (_a = value.key) !== null && _a !== void 0 ? _a : value.ref;
        let vs = this._values[prefix];
        if (vs) {
            const _name = vs.get(valueKey);
            if (_name)
                return _name;
        }
        else {
            vs = this._values[prefix] = new Map();
        }
        vs.set(valueKey, name);
        const s = this._scope[prefix] || (this._scope[prefix] = []);
        const itemIndex = s.length;
        s[itemIndex] = value.ref;
        name.setValue(value, { property: prefix, itemIndex });
        return name;
    }
    getValue(prefix, keyOrRef) {
        const vs = this._values[prefix];
        if (!vs)
            return;
        return vs.get(keyOrRef);
    }
    scopeRefs(scopeName, values = this._values) {
        return this._reduceValues(values, (name) => {
            if (name.scopePath === undefined)
                throw new Error(`CodeGen: name "${name}" has no value`);
            return code_1._ `${scopeName}${name.scopePath}`;
        });
    }
    scopeCode(values = this._values, usedValues, getCode) {
        return this._reduceValues(values, (name) => {
            if (name.value === undefined)
                throw new Error(`CodeGen: name "${name}" has no value`);
            return name.value.code;
        }, usedValues, getCode);
    }
    _reduceValues(values, valueCode, usedValues = {}, getCode) {
        let code = code_1.nil;
        for (const prefix in values) {
            const vs = values[prefix];
            if (!vs)
                continue;
            const nameSet = (usedValues[prefix] = usedValues[prefix] || new Map());
            vs.forEach((name) => {
                if (nameSet.has(name))
                    return;
                nameSet.set(name, UsedValueState.Started);
                let c = valueCode(name);
                if (c) {
                    const def = this.opts.es5 ? exports.varKinds.var : exports.varKinds.const;
                    code = code_1._ `${code}${def} ${name} = ${c};${this.opts._n}`;
                }
                else if ((c = getCode === null || getCode === void 0 ? void 0 : getCode(name))) {
                    code = code_1._ `${code}${c}${this.opts._n}`;
                }
                else {
                    throw new ValueError(name);
                }
                nameSet.set(name, UsedValueState.Completed);
            });
        }
        return code;
    }
}
exports.ValueScope = ValueScope;

},{"./code":1}],4:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extendErrors = exports.resetErrorsCount = exports.reportExtraError = exports.reportError = exports.keyword$DataError = exports.keywordError = void 0;
const codegen_1 = require("./codegen");
const util_1 = require("./util");
const names_1 = require("./names");
exports.keywordError = {
    message: ({ keyword }) => codegen_1.str `should pass "${keyword}" keyword validation`,
};
exports.keyword$DataError = {
    message: ({ keyword, schemaType }) => schemaType
        ? codegen_1.str `"${keyword}" keyword must be ${schemaType} ($data)`
        : codegen_1.str `"${keyword}" keyword is invalid ($data)`,
};
function reportError(cxt, error = exports.keywordError, errorPaths, overrideAllErrors) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error, errorPaths);
    if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : (compositeRule || allErrors)) {
        addError(gen, errObj);
    }
    else {
        returnErrors(it, codegen_1._ `[${errObj}]`);
    }
}
exports.reportError = reportError;
function reportExtraError(cxt, error = exports.keywordError, errorPaths) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error, errorPaths);
    addError(gen, errObj);
    if (!(compositeRule || allErrors)) {
        returnErrors(it, names_1.default.vErrors);
    }
}
exports.reportExtraError = reportExtraError;
function resetErrorsCount(gen, errsCount) {
    gen.assign(names_1.default.errors, errsCount);
    gen.if(codegen_1._ `${names_1.default.vErrors} !== null`, () => gen.if(errsCount, () => gen.assign(codegen_1._ `${names_1.default.vErrors}.length`, errsCount), () => gen.assign(names_1.default.vErrors, null)));
}
exports.resetErrorsCount = resetErrorsCount;
function extendErrors({ gen, keyword, schemaValue, data, errsCount, it, }) {
    /* istanbul ignore if */
    if (errsCount === undefined)
        throw new Error("ajv implementation error");
    const err = gen.name("err");
    gen.forRange("i", errsCount, names_1.default.errors, (i) => {
        gen.const(err, codegen_1._ `${names_1.default.vErrors}[${i}]`);
        gen.if(codegen_1._ `${err}.instancePath === undefined`, () => gen.assign(codegen_1._ `${err}.instancePath`, codegen_1.strConcat(names_1.default.instancePath, it.errorPath)));
        gen.assign(codegen_1._ `${err}.schemaPath`, codegen_1.str `${it.errSchemaPath}/${keyword}`);
        if (it.opts.verbose) {
            gen.assign(codegen_1._ `${err}.schema`, schemaValue);
            gen.assign(codegen_1._ `${err}.data`, data);
        }
    });
}
exports.extendErrors = extendErrors;
function addError(gen, errObj) {
    const err = gen.const("err", errObj);
    gen.if(codegen_1._ `${names_1.default.vErrors} === null`, () => gen.assign(names_1.default.vErrors, codegen_1._ `[${err}]`), codegen_1._ `${names_1.default.vErrors}.push(${err})`);
    gen.code(codegen_1._ `${names_1.default.errors}++`);
}
function returnErrors(it, errs) {
    const { gen, validateName, schemaEnv } = it;
    if (schemaEnv.$async) {
        gen.throw(codegen_1._ `new ${it.ValidationError}(${errs})`);
    }
    else {
        gen.assign(codegen_1._ `${validateName}.errors`, errs);
        gen.return(false);
    }
}
const E = {
    keyword: new codegen_1.Name("keyword"),
    schemaPath: new codegen_1.Name("schemaPath"),
    params: new codegen_1.Name("params"),
    propertyName: new codegen_1.Name("propertyName"),
    message: new codegen_1.Name("message"),
    schema: new codegen_1.Name("schema"),
    parentSchema: new codegen_1.Name("parentSchema"),
};
function errorObjectCode(cxt, error, errorPaths) {
    const { createErrors } = cxt.it;
    if (createErrors === false)
        return codegen_1._ `{}`;
    return errorObject(cxt, error, errorPaths);
}
function errorObject(cxt, error, errorPaths = {}) {
    const { gen, it } = cxt;
    const keyValues = [
        errorInstancePath(it, errorPaths),
        errorSchemaPath(cxt, errorPaths),
    ];
    extraErrorProps(cxt, error, keyValues);
    return gen.object(...keyValues);
}
function errorInstancePath({ errorPath }, { instancePath }) {
    const instPath = instancePath
        ? codegen_1.str `${errorPath}${util_1.getErrorPath(instancePath, util_1.Type.Str)}`
        : errorPath;
    return [names_1.default.instancePath, codegen_1.strConcat(names_1.default.instancePath, instPath)];
}
function errorSchemaPath({ keyword, it: { errSchemaPath } }, { schemaPath, parentSchema }) {
    let schPath = parentSchema ? errSchemaPath : codegen_1.str `${errSchemaPath}/${keyword}`;
    if (schemaPath) {
        schPath = codegen_1.str `${schPath}${util_1.getErrorPath(schemaPath, util_1.Type.Str)}`;
    }
    return [E.schemaPath, schPath];
}
function extraErrorProps(cxt, { params, message }, keyValues) {
    const { keyword, data, schemaValue, it } = cxt;
    const { opts, propertyName, topSchemaRef, schemaPath } = it;
    keyValues.push([E.keyword, keyword], [E.params, typeof params == "function" ? params(cxt) : params || codegen_1._ `{}`]);
    if (opts.messages) {
        keyValues.push([E.message, typeof message == "function" ? message(cxt) : message]);
    }
    if (opts.verbose) {
        keyValues.push([E.schema, schemaValue], [E.parentSchema, codegen_1._ `${topSchemaRef}${schemaPath}`], [names_1.default.data, data]);
    }
    if (propertyName)
        keyValues.push([E.propertyName, propertyName]);
}

},{"./codegen":2,"./names":6,"./util":10}],5:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveSchema = exports.getCompilingSchema = exports.resolveRef = exports.compileSchema = exports.SchemaEnv = void 0;
const codegen_1 = require("./codegen");
const validation_error_1 = require("../runtime/validation_error");
const names_1 = require("./names");
const resolve_1 = require("./resolve");
const util_1 = require("./util");
const validate_1 = require("./validate");
const URI = require("uri-js");
class SchemaEnv {
    constructor(env) {
        var _a;
        this.refs = {};
        this.dynamicAnchors = {};
        let schema;
        if (typeof env.schema == "object")
            schema = env.schema;
        this.schema = env.schema;
        this.root = env.root || this;
        this.baseId = (_a = env.baseId) !== null && _a !== void 0 ? _a : resolve_1.normalizeId(schema === null || schema === void 0 ? void 0 : schema.$id);
        this.schemaPath = env.schemaPath;
        this.localRefs = env.localRefs;
        this.meta = env.meta;
        this.$async = schema === null || schema === void 0 ? void 0 : schema.$async;
        this.refs = {};
    }
}
exports.SchemaEnv = SchemaEnv;
// let codeSize = 0
// let nodeCount = 0
// Compiles schema in SchemaEnv
function compileSchema(sch) {
    // TODO refactor - remove compilations
    const _sch = getCompilingSchema.call(this, sch);
    if (_sch)
        return _sch;
    const rootId = resolve_1.getFullPath(sch.root.baseId); // TODO if getFullPath removed 1 tests fails
    const { es5, lines } = this.opts.code;
    const { ownProperties } = this.opts;
    const gen = new codegen_1.CodeGen(this.scope, { es5, lines, ownProperties });
    let _ValidationError;
    if (sch.$async) {
        _ValidationError = gen.scopeValue("Error", {
            ref: validation_error_1.default,
            code: codegen_1._ `require("ajv/dist/runtime/validation_error").default`,
        });
    }
    const validateName = gen.scopeName("validate");
    sch.validateName = validateName;
    const schemaCxt = {
        gen,
        allErrors: this.opts.allErrors,
        data: names_1.default.data,
        parentData: names_1.default.parentData,
        parentDataProperty: names_1.default.parentDataProperty,
        dataNames: [names_1.default.data],
        dataPathArr: [codegen_1.nil],
        dataLevel: 0,
        dataTypes: [],
        definedProperties: new Set(),
        topSchemaRef: gen.scopeValue("schema", this.opts.code.source === true
            ? { ref: sch.schema, code: codegen_1.stringify(sch.schema) }
            : { ref: sch.schema }),
        validateName,
        ValidationError: _ValidationError,
        schema: sch.schema,
        schemaEnv: sch,
        rootId,
        baseId: sch.baseId || rootId,
        schemaPath: codegen_1.nil,
        errSchemaPath: sch.schemaPath || (this.opts.jtd ? "" : "#"),
        errorPath: codegen_1._ `""`,
        opts: this.opts,
        self: this,
    };
    let sourceCode;
    try {
        this._compilations.add(sch);
        validate_1.validateFunctionCode(schemaCxt);
        gen.optimize(this.opts.code.optimize);
        // gen.optimize(1)
        const validateCode = gen.toString();
        sourceCode = `${gen.scopeRefs(names_1.default.scope)}return ${validateCode}`;
        // console.log((codeSize += sourceCode.length), (nodeCount += gen.nodeCount))
        if (this.opts.code.process)
            sourceCode = this.opts.code.process(sourceCode, sch);
        // console.log("\n\n\n *** \n", sourceCode)
        const makeValidate = new Function(`${names_1.default.self}`, `${names_1.default.scope}`, sourceCode);
        const validate = makeValidate(this, this.scope.get());
        this.scope.value(validateName, { ref: validate });
        validate.errors = null;
        validate.schema = sch.schema;
        validate.schemaEnv = sch;
        if (sch.$async)
            validate.$async = true;
        if (this.opts.code.source === true) {
            validate.source = { validateName, validateCode, scopeValues: gen._values };
        }
        if (this.opts.unevaluated) {
            const { props, items } = schemaCxt;
            validate.evaluated = {
                props: props instanceof codegen_1.Name ? undefined : props,
                items: items instanceof codegen_1.Name ? undefined : items,
                dynamicProps: props instanceof codegen_1.Name,
                dynamicItems: items instanceof codegen_1.Name,
            };
            if (validate.source)
                validate.source.evaluated = codegen_1.stringify(validate.evaluated);
        }
        sch.validate = validate;
        return sch;
    }
    catch (e) {
        delete sch.validate;
        delete sch.validateName;
        if (sourceCode)
            this.logger.error("Error compiling schema, function code:", sourceCode);
        // console.log("\n\n\n *** \n", sourceCode, this.opts)
        throw e;
    }
    finally {
        this._compilations.delete(sch);
    }
}
exports.compileSchema = compileSchema;
function resolveRef(root, baseId, ref) {
    var _a;
    ref = resolve_1.resolveUrl(baseId, ref);
    const schOrFunc = root.refs[ref];
    if (schOrFunc)
        return schOrFunc;
    let _sch = resolve.call(this, root, ref);
    if (_sch === undefined) {
        const schema = (_a = root.localRefs) === null || _a === void 0 ? void 0 : _a[ref]; // TODO maybe localRefs should hold SchemaEnv
        if (schema)
            _sch = new SchemaEnv({ schema, root, baseId });
    }
    if (_sch === undefined)
        return;
    return (root.refs[ref] = inlineOrCompile.call(this, _sch));
}
exports.resolveRef = resolveRef;
function inlineOrCompile(sch) {
    if (resolve_1.inlineRef(sch.schema, this.opts.inlineRefs))
        return sch.schema;
    return sch.validate ? sch : compileSchema.call(this, sch);
}
// Index of schema compilation in the currently compiled list
function getCompilingSchema(schEnv) {
    for (const sch of this._compilations) {
        if (sameSchemaEnv(sch, schEnv))
            return sch;
    }
}
exports.getCompilingSchema = getCompilingSchema;
function sameSchemaEnv(s1, s2) {
    return s1.schema === s2.schema && s1.root === s2.root && s1.baseId === s2.baseId;
}
// resolve and compile the references ($ref)
// TODO returns AnySchemaObject (if the schema can be inlined) or validation function
function resolve(root, // information about the root schema for the current schema
ref // reference to resolve
) {
    let sch;
    while (typeof (sch = this.refs[ref]) == "string")
        ref = sch;
    return sch || this.schemas[ref] || resolveSchema.call(this, root, ref);
}
// Resolve schema, its root and baseId
function resolveSchema(root, // root object with properties schema, refs TODO below SchemaEnv is assigned to it
ref // reference to resolve
) {
    const p = URI.parse(ref);
    const refPath = resolve_1._getFullPath(p);
    let baseId = resolve_1.getFullPath(root.baseId);
    // TODO `Object.keys(root.schema).length > 0` should not be needed - but removing breaks 2 tests
    if (Object.keys(root.schema).length > 0 && refPath === baseId) {
        return getJsonPointer.call(this, p, root);
    }
    const id = resolve_1.normalizeId(refPath);
    const schOrRef = this.refs[id] || this.schemas[id];
    if (typeof schOrRef == "string") {
        const sch = resolveSchema.call(this, root, schOrRef);
        if (typeof (sch === null || sch === void 0 ? void 0 : sch.schema) !== "object")
            return;
        return getJsonPointer.call(this, p, sch);
    }
    if (typeof (schOrRef === null || schOrRef === void 0 ? void 0 : schOrRef.schema) !== "object")
        return;
    if (!schOrRef.validate)
        compileSchema.call(this, schOrRef);
    if (id === resolve_1.normalizeId(ref)) {
        const { schema } = schOrRef;
        if (schema.$id)
            baseId = resolve_1.resolveUrl(baseId, schema.$id);
        return new SchemaEnv({ schema, root, baseId });
    }
    return getJsonPointer.call(this, p, schOrRef);
}
exports.resolveSchema = resolveSchema;
const PREVENT_SCOPE_CHANGE = new Set([
    "properties",
    "patternProperties",
    "enum",
    "dependencies",
    "definitions",
]);
function getJsonPointer(parsedRef, { baseId, schema, root }) {
    var _a;
    if (((_a = parsedRef.fragment) === null || _a === void 0 ? void 0 : _a[0]) !== "/")
        return;
    for (const part of parsedRef.fragment.slice(1).split("/")) {
        if (typeof schema == "boolean")
            return;
        schema = schema[util_1.unescapeFragment(part)];
        if (schema === undefined)
            return;
        // TODO PREVENT_SCOPE_CHANGE could be defined in keyword def?
        if (!PREVENT_SCOPE_CHANGE.has(part) && typeof schema == "object" && schema.$id) {
            baseId = resolve_1.resolveUrl(baseId, schema.$id);
        }
    }
    let env;
    if (typeof schema != "boolean" && schema.$ref && !util_1.schemaHasRulesButRef(schema, this.RULES)) {
        const $ref = resolve_1.resolveUrl(baseId, schema.$ref);
        env = resolveSchema.call(this, root, $ref);
    }
    // even though resolution failed we need to return SchemaEnv to throw exception
    // so that compileAsync loads missing schema.
    env = env || new SchemaEnv({ schema, root, baseId });
    if (env.schema !== env.root.schema)
        return env;
    return undefined;
}

},{"../runtime/validation_error":23,"./codegen":2,"./names":6,"./resolve":8,"./util":10,"./validate":15,"uri-js":64}],6:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("./codegen");
const names = {
    // validation function arguments
    data: new codegen_1.Name("data"),
    // args passed from referencing schema
    valCxt: new codegen_1.Name("valCxt"),
    instancePath: new codegen_1.Name("instancePath"),
    parentData: new codegen_1.Name("parentData"),
    parentDataProperty: new codegen_1.Name("parentDataProperty"),
    rootData: new codegen_1.Name("rootData"),
    dynamicAnchors: new codegen_1.Name("dynamicAnchors"),
    // function scoped variables
    vErrors: new codegen_1.Name("vErrors"),
    errors: new codegen_1.Name("errors"),
    this: new codegen_1.Name("this"),
    // "globals"
    self: new codegen_1.Name("self"),
    scope: new codegen_1.Name("scope"),
    // JTD serialize/parse name for JSON string and position
    json: new codegen_1.Name("json"),
    jsonPos: new codegen_1.Name("jsonPos"),
    jsonLen: new codegen_1.Name("jsonLen"),
    jsonPart: new codegen_1.Name("jsonPart"),
};
exports.default = names;

},{"./codegen":2}],7:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const resolve_1 = require("./resolve");
class MissingRefError extends Error {
    constructor(baseId, ref, msg) {
        super(msg || `can't resolve reference ${ref} from id ${baseId}`);
        this.missingRef = resolve_1.resolveUrl(baseId, ref);
        this.missingSchema = resolve_1.normalizeId(resolve_1.getFullPath(this.missingRef));
    }
}
exports.default = MissingRefError;

},{"./resolve":8}],8:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSchemaRefs = exports.resolveUrl = exports.normalizeId = exports._getFullPath = exports.getFullPath = exports.inlineRef = void 0;
const util_1 = require("./util");
const equal = require("fast-deep-equal");
const traverse = require("json-schema-traverse");
const URI = require("uri-js");
// TODO refactor to use keyword definitions
const SIMPLE_INLINED = new Set([
    "type",
    "format",
    "pattern",
    "maxLength",
    "minLength",
    "maxProperties",
    "minProperties",
    "maxItems",
    "minItems",
    "maximum",
    "minimum",
    "uniqueItems",
    "multipleOf",
    "required",
    "enum",
    "const",
]);
function inlineRef(schema, limit = true) {
    if (typeof schema == "boolean")
        return true;
    if (limit === true)
        return !hasRef(schema);
    if (!limit)
        return false;
    return countKeys(schema) <= limit;
}
exports.inlineRef = inlineRef;
const REF_KEYWORDS = new Set([
    "$ref",
    "$recursiveRef",
    "$recursiveAnchor",
    "$dynamicRef",
    "$dynamicAnchor",
]);
function hasRef(schema) {
    for (const key in schema) {
        if (REF_KEYWORDS.has(key))
            return true;
        const sch = schema[key];
        if (Array.isArray(sch) && sch.some(hasRef))
            return true;
        if (typeof sch == "object" && hasRef(sch))
            return true;
    }
    return false;
}
function countKeys(schema) {
    let count = 0;
    for (const key in schema) {
        if (key === "$ref")
            return Infinity;
        count++;
        if (SIMPLE_INLINED.has(key))
            continue;
        if (typeof schema[key] == "object") {
            util_1.eachItem(schema[key], (sch) => (count += countKeys(sch)));
        }
        if (count === Infinity)
            return Infinity;
    }
    return count;
}
function getFullPath(id = "", normalize) {
    if (normalize !== false)
        id = normalizeId(id);
    const p = URI.parse(id);
    return _getFullPath(p);
}
exports.getFullPath = getFullPath;
function _getFullPath(p) {
    return URI.serialize(p).split("#")[0] + "#";
}
exports._getFullPath = _getFullPath;
const TRAILING_SLASH_HASH = /#\/?$/;
function normalizeId(id) {
    return id ? id.replace(TRAILING_SLASH_HASH, "") : "";
}
exports.normalizeId = normalizeId;
function resolveUrl(baseId, id) {
    id = normalizeId(id);
    return URI.resolve(baseId, id);
}
exports.resolveUrl = resolveUrl;
const ANCHOR = /^[a-z_][-a-z0-9._]*$/i;
function getSchemaRefs(schema) {
    if (typeof schema == "boolean")
        return {};
    const schemaId = normalizeId(schema.$id);
    const baseIds = { "": schemaId };
    const pathPrefix = getFullPath(schemaId, false);
    const localRefs = {};
    const schemaRefs = new Set();
    traverse(schema, { allKeys: true }, (sch, jsonPtr, _, parentJsonPtr) => {
        if (parentJsonPtr === undefined)
            return;
        const fullPath = pathPrefix + jsonPtr;
        let baseId = baseIds[parentJsonPtr];
        if (typeof sch.$id == "string")
            baseId = addRef.call(this, sch.$id);
        addAnchor.call(this, sch.$anchor);
        addAnchor.call(this, sch.$dynamicAnchor);
        baseIds[jsonPtr] = baseId;
        function addRef(ref) {
            ref = normalizeId(baseId ? URI.resolve(baseId, ref) : ref);
            if (schemaRefs.has(ref))
                throw ambiguos(ref);
            schemaRefs.add(ref);
            let schOrRef = this.refs[ref];
            if (typeof schOrRef == "string")
                schOrRef = this.refs[schOrRef];
            if (typeof schOrRef == "object") {
                checkAmbiguosRef(sch, schOrRef.schema, ref);
            }
            else if (ref !== normalizeId(fullPath)) {
                if (ref[0] === "#") {
                    checkAmbiguosRef(sch, localRefs[ref], ref);
                    localRefs[ref] = sch;
                }
                else {
                    this.refs[ref] = fullPath;
                }
            }
            return ref;
        }
        function addAnchor(anchor) {
            if (typeof anchor == "string") {
                if (!ANCHOR.test(anchor))
                    throw new Error(`invalid anchor "${anchor}"`);
                addRef.call(this, `#${anchor}`);
            }
        }
    });
    return localRefs;
    function checkAmbiguosRef(sch1, sch2, ref) {
        if (sch2 !== undefined && !equal(sch1, sch2))
            throw ambiguos(ref);
    }
    function ambiguos(ref) {
        return new Error(`reference "${ref}" resolves to more than one schema`);
    }
}
exports.getSchemaRefs = getSchemaRefs;

},{"./util":10,"fast-deep-equal":62,"json-schema-traverse":63,"uri-js":64}],9:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRules = exports.isJSONType = void 0;
const _jsonTypes = ["string", "number", "integer", "boolean", "null", "object", "array"];
const jsonTypes = new Set(_jsonTypes);
function isJSONType(x) {
    return typeof x == "string" && jsonTypes.has(x);
}
exports.isJSONType = isJSONType;
function getRules() {
    const groups = {
        number: { type: "number", rules: [] },
        string: { type: "string", rules: [] },
        array: { type: "array", rules: [] },
        object: { type: "object", rules: [] },
    };
    return {
        types: { ...groups, integer: true, boolean: true, null: true },
        rules: [{ rules: [] }, groups.number, groups.string, groups.array, groups.object],
        post: { rules: [] },
        all: {},
        keywords: {},
    };
}
exports.getRules = getRules;

},{}],10:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkStrictMode = exports.getErrorPath = exports.Type = exports.useFunc = exports.setEvaluated = exports.evaluatedPropsToName = exports.mergeEvaluated = exports.eachItem = exports.unescapeJsonPointer = exports.escapeJsonPointer = exports.escapeFragment = exports.unescapeFragment = exports.schemaRefOrVal = exports.schemaHasRulesButRef = exports.schemaHasRules = exports.checkUnknownRules = exports.alwaysValidSchema = exports.toHash = void 0;
const codegen_1 = require("./codegen");
const code_1 = require("./codegen/code");
// TODO refactor to use Set
function toHash(arr) {
    const hash = {};
    for (const item of arr)
        hash[item] = true;
    return hash;
}
exports.toHash = toHash;
function alwaysValidSchema(it, schema) {
    if (typeof schema == "boolean")
        return schema;
    if (Object.keys(schema).length === 0)
        return true;
    checkUnknownRules(it, schema);
    return !schemaHasRules(schema, it.self.RULES.all);
}
exports.alwaysValidSchema = alwaysValidSchema;
function checkUnknownRules(it, schema = it.schema) {
    const { opts, self } = it;
    if (!opts.strictSchema)
        return;
    if (typeof schema === "boolean")
        return;
    const rules = self.RULES.keywords;
    for (const key in schema) {
        if (!rules[key])
            checkStrictMode(it, `unknown keyword: "${key}"`);
    }
}
exports.checkUnknownRules = checkUnknownRules;
function schemaHasRules(schema, rules) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (rules[key])
            return true;
    return false;
}
exports.schemaHasRules = schemaHasRules;
function schemaHasRulesButRef(schema, RULES) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (key !== "$ref" && RULES.all[key])
            return true;
    return false;
}
exports.schemaHasRulesButRef = schemaHasRulesButRef;
function schemaRefOrVal({ topSchemaRef, schemaPath }, schema, keyword, $data) {
    if (!$data) {
        if (typeof schema == "number" || typeof schema == "boolean")
            return schema;
        if (typeof schema == "string")
            return codegen_1._ `${schema}`;
    }
    return codegen_1._ `${topSchemaRef}${schemaPath}${codegen_1.getProperty(keyword)}`;
}
exports.schemaRefOrVal = schemaRefOrVal;
function unescapeFragment(str) {
    return unescapeJsonPointer(decodeURIComponent(str));
}
exports.unescapeFragment = unescapeFragment;
function escapeFragment(str) {
    return encodeURIComponent(escapeJsonPointer(str));
}
exports.escapeFragment = escapeFragment;
function escapeJsonPointer(str) {
    if (typeof str == "number")
        return `${str}`;
    return str.replace(/~/g, "~0").replace(/\//g, "~1");
}
exports.escapeJsonPointer = escapeJsonPointer;
function unescapeJsonPointer(str) {
    return str.replace(/~1/g, "/").replace(/~0/g, "~");
}
exports.unescapeJsonPointer = unescapeJsonPointer;
function eachItem(xs, f) {
    if (Array.isArray(xs)) {
        for (const x of xs)
            f(x);
    }
    else {
        f(xs);
    }
}
exports.eachItem = eachItem;
function makeMergeEvaluated({ mergeNames, mergeToName, mergeValues, resultToName, }) {
    return (gen, from, to, toName) => {
        const res = to === undefined
            ? from
            : to instanceof codegen_1.Name
                ? (from instanceof codegen_1.Name ? mergeNames(gen, from, to) : mergeToName(gen, from, to), to)
                : from instanceof codegen_1.Name
                    ? (mergeToName(gen, to, from), from)
                    : mergeValues(from, to);
        return toName === codegen_1.Name && !(res instanceof codegen_1.Name) ? resultToName(gen, res) : res;
    };
}
exports.mergeEvaluated = {
    props: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if(codegen_1._ `${to} !== true && ${from} !== undefined`, () => {
            gen.if(codegen_1._ `${from} === true`, () => gen.assign(to, true), () => gen.assign(to, codegen_1._ `${to} || {}`).code(codegen_1._ `Object.assign(${to}, ${from})`));
        }),
        mergeToName: (gen, from, to) => gen.if(codegen_1._ `${to} !== true`, () => {
            if (from === true) {
                gen.assign(to, true);
            }
            else {
                gen.assign(to, codegen_1._ `${to} || {}`);
                setEvaluated(gen, to, from);
            }
        }),
        mergeValues: (from, to) => (from === true ? true : { ...from, ...to }),
        resultToName: evaluatedPropsToName,
    }),
    items: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if(codegen_1._ `${to} !== true && ${from} !== undefined`, () => gen.assign(to, codegen_1._ `${from} === true ? true : ${to} > ${from} ? ${to} : ${from}`)),
        mergeToName: (gen, from, to) => gen.if(codegen_1._ `${to} !== true`, () => gen.assign(to, from === true ? true : codegen_1._ `${to} > ${from} ? ${to} : ${from}`)),
        mergeValues: (from, to) => (from === true ? true : Math.max(from, to)),
        resultToName: (gen, items) => gen.var("items", items),
    }),
};
function evaluatedPropsToName(gen, ps) {
    if (ps === true)
        return gen.var("props", true);
    const props = gen.var("props", codegen_1._ `{}`);
    if (ps !== undefined)
        setEvaluated(gen, props, ps);
    return props;
}
exports.evaluatedPropsToName = evaluatedPropsToName;
function setEvaluated(gen, props, ps) {
    Object.keys(ps).forEach((p) => gen.assign(codegen_1._ `${props}${codegen_1.getProperty(p)}`, true));
}
exports.setEvaluated = setEvaluated;
const snippets = {};
function useFunc(gen, f) {
    return gen.scopeValue("func", {
        ref: f,
        code: snippets[f.code] || (snippets[f.code] = new code_1._Code(f.code)),
    });
}
exports.useFunc = useFunc;
var Type;
(function (Type) {
    Type[Type["Num"] = 0] = "Num";
    Type[Type["Str"] = 1] = "Str";
})(Type = exports.Type || (exports.Type = {}));
function getErrorPath(dataProp, dataPropType, jsPropertySyntax) {
    // let path
    if (dataProp instanceof codegen_1.Name) {
        const isNumber = dataPropType === Type.Num;
        return jsPropertySyntax
            ? isNumber
                ? codegen_1._ `"[" + ${dataProp} + "]"`
                : codegen_1._ `"['" + ${dataProp} + "']"`
            : isNumber
                ? codegen_1._ `"/" + ${dataProp}`
                : codegen_1._ `"/" + ${dataProp}.replace(/~/g, "~0").replace(/\\//g, "~1")`; // TODO maybe use global escapePointer
    }
    return jsPropertySyntax ? codegen_1.getProperty(dataProp).toString() : "/" + escapeJsonPointer(dataProp);
}
exports.getErrorPath = getErrorPath;
function checkStrictMode(it, msg, mode = it.opts.strictSchema) {
    if (!mode)
        return;
    msg = `strict mode: ${msg}`;
    if (mode === true)
        throw new Error(msg);
    it.self.logger.warn(msg);
}
exports.checkStrictMode = checkStrictMode;

},{"./codegen":2,"./codegen/code":1}],11:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldUseRule = exports.shouldUseGroup = exports.schemaHasRulesForType = void 0;
function schemaHasRulesForType({ schema, self }, type) {
    const group = self.RULES.types[type];
    return group && group !== true && shouldUseGroup(schema, group);
}
exports.schemaHasRulesForType = schemaHasRulesForType;
function shouldUseGroup(schema, group) {
    return group.rules.some((rule) => shouldUseRule(schema, rule));
}
exports.shouldUseGroup = shouldUseGroup;
function shouldUseRule(schema, rule) {
    var _a;
    return (schema[rule.keyword] !== undefined ||
        ((_a = rule.definition.implements) === null || _a === void 0 ? void 0 : _a.some((kwd) => schema[kwd] !== undefined)));
}
exports.shouldUseRule = shouldUseRule;

},{}],12:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.boolOrEmptySchema = exports.topBoolOrEmptySchema = void 0;
const errors_1 = require("../errors");
const codegen_1 = require("../codegen");
const names_1 = require("../names");
const boolError = {
    message: "boolean schema is false",
};
function topBoolOrEmptySchema(it) {
    const { gen, schema, validateName } = it;
    if (schema === false) {
        falseSchemaError(it, false);
    }
    else if (typeof schema == "object" && schema.$async === true) {
        gen.return(names_1.default.data);
    }
    else {
        gen.assign(codegen_1._ `${validateName}.errors`, null);
        gen.return(true);
    }
}
exports.topBoolOrEmptySchema = topBoolOrEmptySchema;
function boolOrEmptySchema(it, valid) {
    const { gen, schema } = it;
    if (schema === false) {
        gen.var(valid, false); // TODO var
        falseSchemaError(it);
    }
    else {
        gen.var(valid, true); // TODO var
    }
}
exports.boolOrEmptySchema = boolOrEmptySchema;
function falseSchemaError(it, overrideAllErrors) {
    const { gen, data } = it;
    // TODO maybe some other interface should be used for non-keyword validation errors...
    const cxt = {
        gen,
        keyword: "false schema",
        data,
        schema: false,
        schemaCode: false,
        schemaValue: false,
        params: {},
        it,
    };
    errors_1.reportError(cxt, boolError, undefined, overrideAllErrors);
}

},{"../codegen":2,"../errors":4,"../names":6}],13:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportTypeError = exports.checkDataTypes = exports.checkDataType = exports.coerceAndCheckDataType = exports.getJSONTypes = exports.getSchemaTypes = exports.DataType = void 0;
const rules_1 = require("../rules");
const applicability_1 = require("./applicability");
const errors_1 = require("../errors");
const codegen_1 = require("../codegen");
const util_1 = require("../util");
var DataType;
(function (DataType) {
    DataType[DataType["Correct"] = 0] = "Correct";
    DataType[DataType["Wrong"] = 1] = "Wrong";
})(DataType = exports.DataType || (exports.DataType = {}));
function getSchemaTypes(schema) {
    const types = getJSONTypes(schema.type);
    const hasNull = types.includes("null");
    if (hasNull) {
        if (schema.nullable === false)
            throw new Error("type: null contradicts nullable: false");
    }
    else {
        if (!types.length && schema.nullable !== undefined) {
            throw new Error('"nullable" cannot be used without "type"');
        }
        if (schema.nullable === true)
            types.push("null");
    }
    return types;
}
exports.getSchemaTypes = getSchemaTypes;
function getJSONTypes(ts) {
    const types = Array.isArray(ts) ? ts : ts ? [ts] : [];
    if (types.every(rules_1.isJSONType))
        return types;
    throw new Error("type must be JSONType or JSONType[]: " + types.join(","));
}
exports.getJSONTypes = getJSONTypes;
function coerceAndCheckDataType(it, types) {
    const { gen, data, opts } = it;
    const coerceTo = coerceToTypes(types, opts.coerceTypes);
    const checkTypes = types.length > 0 &&
        !(coerceTo.length === 0 && types.length === 1 && applicability_1.schemaHasRulesForType(it, types[0]));
    if (checkTypes) {
        const wrongType = checkDataTypes(types, data, opts.strictNumbers, DataType.Wrong);
        gen.if(wrongType, () => {
            if (coerceTo.length)
                coerceData(it, types, coerceTo);
            else
                reportTypeError(it);
        });
    }
    return checkTypes;
}
exports.coerceAndCheckDataType = coerceAndCheckDataType;
const COERCIBLE = new Set(["string", "number", "integer", "boolean", "null"]);
function coerceToTypes(types, coerceTypes) {
    return coerceTypes
        ? types.filter((t) => COERCIBLE.has(t) || (coerceTypes === "array" && t === "array"))
        : [];
}
function coerceData(it, types, coerceTo) {
    const { gen, data, opts } = it;
    const dataType = gen.let("dataType", codegen_1._ `typeof ${data}`);
    const coerced = gen.let("coerced", codegen_1._ `undefined`);
    if (opts.coerceTypes === "array") {
        gen.if(codegen_1._ `${dataType} == 'object' && Array.isArray(${data}) && ${data}.length == 1`, () => gen
            .assign(data, codegen_1._ `${data}[0]`)
            .assign(dataType, codegen_1._ `typeof ${data}`)
            .if(checkDataTypes(types, data, opts.strictNumbers), () => gen.assign(coerced, data)));
    }
    gen.if(codegen_1._ `${coerced} !== undefined`);
    for (const t of coerceTo) {
        if (COERCIBLE.has(t) || (t === "array" && opts.coerceTypes === "array")) {
            coerceSpecificType(t);
        }
    }
    gen.else();
    reportTypeError(it);
    gen.endIf();
    gen.if(codegen_1._ `${coerced} !== undefined`, () => {
        gen.assign(data, coerced);
        assignParentData(it, coerced);
    });
    function coerceSpecificType(t) {
        switch (t) {
            case "string":
                gen
                    .elseIf(codegen_1._ `${dataType} == "number" || ${dataType} == "boolean"`)
                    .assign(coerced, codegen_1._ `"" + ${data}`)
                    .elseIf(codegen_1._ `${data} === null`)
                    .assign(coerced, codegen_1._ `""`);
                return;
            case "number":
                gen
                    .elseIf(codegen_1._ `${dataType} == "boolean" || ${data} === null
              || (${dataType} == "string" && ${data} && ${data} == +${data})`)
                    .assign(coerced, codegen_1._ `+${data}`);
                return;
            case "integer":
                gen
                    .elseIf(codegen_1._ `${dataType} === "boolean" || ${data} === null
              || (${dataType} === "string" && ${data} && ${data} == +${data} && !(${data} % 1))`)
                    .assign(coerced, codegen_1._ `+${data}`);
                return;
            case "boolean":
                gen
                    .elseIf(codegen_1._ `${data} === "false" || ${data} === 0 || ${data} === null`)
                    .assign(coerced, false)
                    .elseIf(codegen_1._ `${data} === "true" || ${data} === 1`)
                    .assign(coerced, true);
                return;
            case "null":
                gen.elseIf(codegen_1._ `${data} === "" || ${data} === 0 || ${data} === false`);
                gen.assign(coerced, null);
                return;
            case "array":
                gen
                    .elseIf(codegen_1._ `${dataType} === "string" || ${dataType} === "number"
              || ${dataType} === "boolean" || ${data} === null`)
                    .assign(coerced, codegen_1._ `[${data}]`);
        }
    }
}
function assignParentData({ gen, parentData, parentDataProperty }, expr) {
    // TODO use gen.property
    gen.if(codegen_1._ `${parentData} !== undefined`, () => gen.assign(codegen_1._ `${parentData}[${parentDataProperty}]`, expr));
}
function checkDataType(dataType, data, strictNums, correct = DataType.Correct) {
    const EQ = correct === DataType.Correct ? codegen_1.operators.EQ : codegen_1.operators.NEQ;
    let cond;
    switch (dataType) {
        case "null":
            return codegen_1._ `${data} ${EQ} null`;
        case "array":
            cond = codegen_1._ `Array.isArray(${data})`;
            break;
        case "object":
            cond = codegen_1._ `${data} && typeof ${data} == "object" && !Array.isArray(${data})`;
            break;
        case "integer":
            cond = numCond(codegen_1._ `!(${data} % 1) && !isNaN(${data})`);
            break;
        case "number":
            cond = numCond();
            break;
        default:
            return codegen_1._ `typeof ${data} ${EQ} ${dataType}`;
    }
    return correct === DataType.Correct ? cond : codegen_1.not(cond);
    function numCond(_cond = codegen_1.nil) {
        return codegen_1.and(codegen_1._ `typeof ${data} == "number"`, _cond, strictNums ? codegen_1._ `isFinite(${data})` : codegen_1.nil);
    }
}
exports.checkDataType = checkDataType;
function checkDataTypes(dataTypes, data, strictNums, correct) {
    if (dataTypes.length === 1) {
        return checkDataType(dataTypes[0], data, strictNums, correct);
    }
    let cond;
    const types = util_1.toHash(dataTypes);
    if (types.array && types.object) {
        const notObj = codegen_1._ `typeof ${data} != "object"`;
        cond = types.null ? notObj : codegen_1._ `!${data} || ${notObj}`;
        delete types.null;
        delete types.array;
        delete types.object;
    }
    else {
        cond = codegen_1.nil;
    }
    if (types.number)
        delete types.integer;
    for (const t in types)
        cond = codegen_1.and(cond, checkDataType(t, data, strictNums, correct));
    return cond;
}
exports.checkDataTypes = checkDataTypes;
const typeError = {
    message: ({ schema }) => `must be ${schema}`,
    params: ({ schema, schemaValue }) => typeof schema == "string" ? codegen_1._ `{type: ${schema}}` : codegen_1._ `{type: ${schemaValue}}`,
};
function reportTypeError(it) {
    const cxt = getTypeErrorContext(it);
    errors_1.reportError(cxt, typeError);
}
exports.reportTypeError = reportTypeError;
function getTypeErrorContext(it) {
    const { gen, data, schema } = it;
    const schemaCode = util_1.schemaRefOrVal(it, schema, "type");
    return {
        gen,
        keyword: "type",
        data,
        schema: schema.type,
        schemaCode,
        schemaValue: schemaCode,
        parentSchema: schema,
        params: {},
        it,
    };
}

},{"../codegen":2,"../errors":4,"../rules":9,"../util":10,"./applicability":11}],14:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignDefaults = void 0;
const codegen_1 = require("../codegen");
const util_1 = require("../util");
function assignDefaults(it, ty) {
    const { properties, items } = it.schema;
    if (ty === "object" && properties) {
        for (const key in properties) {
            assignDefault(it, key, properties[key].default);
        }
    }
    else if (ty === "array" && Array.isArray(items)) {
        items.forEach((sch, i) => assignDefault(it, i, sch.default));
    }
}
exports.assignDefaults = assignDefaults;
function assignDefault(it, prop, defaultValue) {
    const { gen, compositeRule, data, opts } = it;
    if (defaultValue === undefined)
        return;
    const childData = codegen_1._ `${data}${codegen_1.getProperty(prop)}`;
    if (compositeRule) {
        util_1.checkStrictMode(it, `default is ignored for: ${childData}`);
        return;
    }
    let condition = codegen_1._ `${childData} === undefined`;
    if (opts.useDefaults === "empty") {
        condition = codegen_1._ `${condition} || ${childData} === null || ${childData} === ""`;
    }
    // `${childData} === undefined` +
    // (opts.useDefaults === "empty" ? ` || ${childData} === null || ${childData} === ""` : "")
    gen.if(condition, codegen_1._ `${childData} = ${codegen_1.stringify(defaultValue)}`);
}

},{"../codegen":2,"../util":10}],15:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = exports.KeywordCxt = exports.validateFunctionCode = void 0;
const boolSchema_1 = require("./boolSchema");
const dataType_1 = require("./dataType");
const applicability_1 = require("./applicability");
const dataType_2 = require("./dataType");
const defaults_1 = require("./defaults");
const keyword_1 = require("./keyword");
const subschema_1 = require("./subschema");
const codegen_1 = require("../codegen");
const names_1 = require("../names");
const resolve_1 = require("../resolve");
const util_1 = require("../util");
const errors_1 = require("../errors");
// schema compilation - generates validation function, subschemaCode (below) is used for subschemas
function validateFunctionCode(it) {
    if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
            topSchemaObjCode(it);
            return;
        }
    }
    validateFunction(it, () => boolSchema_1.topBoolOrEmptySchema(it));
}
exports.validateFunctionCode = validateFunctionCode;
function validateFunction({ gen, validateName, schema, schemaEnv, opts }, body) {
    if (opts.code.es5) {
        gen.func(validateName, codegen_1._ `${names_1.default.data}, ${names_1.default.valCxt}`, schemaEnv.$async, () => {
            gen.code(codegen_1._ `"use strict"; ${funcSourceUrl(schema, opts)}`);
            destructureValCxtES5(gen, opts);
            gen.code(body);
        });
    }
    else {
        gen.func(validateName, codegen_1._ `${names_1.default.data}, ${destructureValCxt(opts)}`, schemaEnv.$async, () => gen.code(funcSourceUrl(schema, opts)).code(body));
    }
}
function destructureValCxt(opts) {
    return codegen_1._ `{${names_1.default.instancePath}="", ${names_1.default.parentData}, ${names_1.default.parentDataProperty}, ${names_1.default.rootData}=${names_1.default.data}${opts.dynamicRef ? codegen_1._ `, ${names_1.default.dynamicAnchors}={}` : codegen_1.nil}}={}`;
}
function destructureValCxtES5(gen, opts) {
    gen.if(names_1.default.valCxt, () => {
        gen.var(names_1.default.instancePath, codegen_1._ `${names_1.default.valCxt}.${names_1.default.instancePath}`);
        gen.var(names_1.default.parentData, codegen_1._ `${names_1.default.valCxt}.${names_1.default.parentData}`);
        gen.var(names_1.default.parentDataProperty, codegen_1._ `${names_1.default.valCxt}.${names_1.default.parentDataProperty}`);
        gen.var(names_1.default.rootData, codegen_1._ `${names_1.default.valCxt}.${names_1.default.rootData}`);
        if (opts.dynamicRef)
            gen.var(names_1.default.dynamicAnchors, codegen_1._ `${names_1.default.valCxt}.${names_1.default.dynamicAnchors}`);
    }, () => {
        gen.var(names_1.default.instancePath, codegen_1._ `""`);
        gen.var(names_1.default.parentData, codegen_1._ `undefined`);
        gen.var(names_1.default.parentDataProperty, codegen_1._ `undefined`);
        gen.var(names_1.default.rootData, names_1.default.data);
        if (opts.dynamicRef)
            gen.var(names_1.default.dynamicAnchors, codegen_1._ `{}`);
    });
}
function topSchemaObjCode(it) {
    const { schema, opts, gen } = it;
    validateFunction(it, () => {
        if (opts.$comment && schema.$comment)
            commentKeyword(it);
        checkNoDefault(it);
        gen.let(names_1.default.vErrors, null);
        gen.let(names_1.default.errors, 0);
        if (opts.unevaluated)
            resetEvaluated(it);
        typeAndKeywords(it);
        returnResults(it);
    });
    return;
}
function resetEvaluated(it) {
    // TODO maybe some hook to execute it in the end to check whether props/items are Name, as in assignEvaluated
    const { gen, validateName } = it;
    it.evaluated = gen.const("evaluated", codegen_1._ `${validateName}.evaluated`);
    gen.if(codegen_1._ `${it.evaluated}.dynamicProps`, () => gen.assign(codegen_1._ `${it.evaluated}.props`, codegen_1._ `undefined`));
    gen.if(codegen_1._ `${it.evaluated}.dynamicItems`, () => gen.assign(codegen_1._ `${it.evaluated}.items`, codegen_1._ `undefined`));
}
function funcSourceUrl(schema, opts) {
    return typeof schema == "object" && schema.$id && (opts.code.source || opts.code.process)
        ? codegen_1._ `/*# sourceURL=${schema.$id} */`
        : codegen_1.nil;
}
// schema compilation - this function is used recursively to generate code for sub-schemas
function subschemaCode(it, valid) {
    if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
            subSchemaObjCode(it, valid);
            return;
        }
    }
    boolSchema_1.boolOrEmptySchema(it, valid);
}
function schemaCxtHasRules({ schema, self }) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (self.RULES.all[key])
            return true;
    return false;
}
function isSchemaObj(it) {
    return typeof it.schema != "boolean";
}
function subSchemaObjCode(it, valid) {
    const { schema, gen, opts } = it;
    if (opts.$comment && schema.$comment)
        commentKeyword(it);
    updateContext(it);
    checkAsyncSchema(it);
    const errsCount = gen.const("_errs", names_1.default.errors);
    typeAndKeywords(it, errsCount);
    // TODO var
    gen.var(valid, codegen_1._ `${errsCount} === ${names_1.default.errors}`);
}
function checkKeywords(it) {
    util_1.checkUnknownRules(it);
    checkRefsAndKeywords(it);
}
function typeAndKeywords(it, errsCount) {
    if (it.opts.jtd)
        return schemaKeywords(it, [], false, errsCount);
    const types = dataType_1.getSchemaTypes(it.schema);
    const checkedTypes = dataType_1.coerceAndCheckDataType(it, types);
    schemaKeywords(it, types, !checkedTypes, errsCount);
}
function checkRefsAndKeywords(it) {
    const { schema, errSchemaPath, opts, self } = it;
    if (schema.$ref && opts.ignoreKeywordsWithRef && util_1.schemaHasRulesButRef(schema, self.RULES)) {
        self.logger.warn(`$ref: keywords ignored in schema at path "${errSchemaPath}"`);
    }
}
function checkNoDefault(it) {
    const { schema, opts } = it;
    if (schema.default !== undefined && opts.useDefaults && opts.strictSchema) {
        util_1.checkStrictMode(it, "default is ignored in the schema root");
    }
}
function updateContext(it) {
    if (it.schema.$id)
        it.baseId = resolve_1.resolveUrl(it.baseId, it.schema.$id);
}
function checkAsyncSchema(it) {
    if (it.schema.$async && !it.schemaEnv.$async)
        throw new Error("async schema in sync schema");
}
function commentKeyword({ gen, schemaEnv, schema, errSchemaPath, opts }) {
    const msg = schema.$comment;
    if (opts.$comment === true) {
        gen.code(codegen_1._ `${names_1.default.self}.logger.log(${msg})`);
    }
    else if (typeof opts.$comment == "function") {
        const schemaPath = codegen_1.str `${errSchemaPath}/$comment`;
        const rootName = gen.scopeValue("root", { ref: schemaEnv.root });
        gen.code(codegen_1._ `${names_1.default.self}.opts.$comment(${msg}, ${schemaPath}, ${rootName}.schema)`);
    }
}
function returnResults(it) {
    const { gen, schemaEnv, validateName, ValidationError, opts } = it;
    if (schemaEnv.$async) {
        // TODO assign unevaluated
        gen.if(codegen_1._ `${names_1.default.errors} === 0`, () => gen.return(names_1.default.data), () => gen.throw(codegen_1._ `new ${ValidationError}(${names_1.default.vErrors})`));
    }
    else {
        gen.assign(codegen_1._ `${validateName}.errors`, names_1.default.vErrors);
        if (opts.unevaluated)
            assignEvaluated(it);
        gen.return(codegen_1._ `${names_1.default.errors} === 0`);
    }
}
function assignEvaluated({ gen, evaluated, props, items }) {
    if (props instanceof codegen_1.Name)
        gen.assign(codegen_1._ `${evaluated}.props`, props);
    if (items instanceof codegen_1.Name)
        gen.assign(codegen_1._ `${evaluated}.items`, items);
}
function schemaKeywords(it, types, typeErrors, errsCount) {
    const { gen, schema, data, allErrors, opts, self } = it;
    const { RULES } = self;
    if (schema.$ref && (opts.ignoreKeywordsWithRef || !util_1.schemaHasRulesButRef(schema, RULES))) {
        gen.block(() => keywordCode(it, "$ref", RULES.all.$ref.definition)); // TODO typecast
        return;
    }
    if (!opts.jtd)
        checkStrictTypes(it, types);
    gen.block(() => {
        for (const group of RULES.rules)
            groupKeywords(group);
        groupKeywords(RULES.post);
    });
    function groupKeywords(group) {
        if (!applicability_1.shouldUseGroup(schema, group))
            return;
        if (group.type) {
            gen.if(dataType_2.checkDataType(group.type, data, opts.strictNumbers));
            iterateKeywords(it, group);
            if (types.length === 1 && types[0] === group.type && typeErrors) {
                gen.else();
                dataType_2.reportTypeError(it);
            }
            gen.endIf();
        }
        else {
            iterateKeywords(it, group);
        }
        // TODO make it "ok" call?
        if (!allErrors)
            gen.if(codegen_1._ `${names_1.default.errors} === ${errsCount || 0}`);
    }
}
function iterateKeywords(it, group) {
    const { gen, schema, opts: { useDefaults }, } = it;
    if (useDefaults)
        defaults_1.assignDefaults(it, group.type);
    gen.block(() => {
        for (const rule of group.rules) {
            if (applicability_1.shouldUseRule(schema, rule)) {
                keywordCode(it, rule.keyword, rule.definition, group.type);
            }
        }
    });
}
function checkStrictTypes(it, types) {
    if (it.schemaEnv.meta || !it.opts.strictTypes)
        return;
    checkContextTypes(it, types);
    if (!it.opts.allowUnionTypes)
        checkMultipleTypes(it, types);
    checkKeywordTypes(it, it.dataTypes);
}
function checkContextTypes(it, types) {
    if (!types.length)
        return;
    if (!it.dataTypes.length) {
        it.dataTypes = types;
        return;
    }
    types.forEach((t) => {
        if (!includesType(it.dataTypes, t)) {
            strictTypesError(it, `type "${t}" not allowed by context "${it.dataTypes.join(",")}"`);
        }
    });
    it.dataTypes = it.dataTypes.filter((t) => includesType(types, t));
}
function checkMultipleTypes(it, ts) {
    if (ts.length > 1 && !(ts.length === 2 && ts.includes("null"))) {
        strictTypesError(it, "use allowUnionTypes to allow union type keyword");
    }
}
function checkKeywordTypes(it, ts) {
    const rules = it.self.RULES.all;
    for (const keyword in rules) {
        const rule = rules[keyword];
        if (typeof rule == "object" && applicability_1.shouldUseRule(it.schema, rule)) {
            const { type } = rule.definition;
            if (type.length && !type.some((t) => hasApplicableType(ts, t))) {
                strictTypesError(it, `missing type "${type.join(",")}" for keyword "${keyword}"`);
            }
        }
    }
}
function hasApplicableType(schTs, kwdT) {
    return schTs.includes(kwdT) || (kwdT === "number" && schTs.includes("integer"));
}
function includesType(ts, t) {
    return ts.includes(t) || (t === "integer" && ts.includes("number"));
}
function strictTypesError(it, msg) {
    const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
    msg += ` at "${schemaPath}" (strictTypes)`;
    util_1.checkStrictMode(it, msg, it.opts.strictTypes);
}
class KeywordCxt {
    constructor(it, def, keyword) {
        keyword_1.validateKeywordUsage(it, def, keyword);
        this.gen = it.gen;
        this.allErrors = it.allErrors;
        this.keyword = keyword;
        this.data = it.data;
        this.schema = it.schema[keyword];
        this.$data = def.$data && it.opts.$data && this.schema && this.schema.$data;
        this.schemaValue = util_1.schemaRefOrVal(it, this.schema, keyword, this.$data);
        this.schemaType = def.schemaType;
        this.parentSchema = it.schema;
        this.params = {};
        this.it = it;
        this.def = def;
        if (this.$data) {
            this.schemaCode = it.gen.const("vSchema", getData(this.$data, it));
        }
        else {
            this.schemaCode = this.schemaValue;
            if (!keyword_1.validSchemaType(this.schema, def.schemaType, def.allowUndefined)) {
                throw new Error(`${keyword} value must be ${JSON.stringify(def.schemaType)}`);
            }
        }
        if ("code" in def ? def.trackErrors : def.errors !== false) {
            this.errsCount = it.gen.const("_errs", names_1.default.errors);
        }
    }
    result(condition, successAction, failAction) {
        this.gen.if(codegen_1.not(condition));
        if (failAction)
            failAction();
        else
            this.error();
        if (successAction) {
            this.gen.else();
            successAction();
            if (this.allErrors)
                this.gen.endIf();
        }
        else {
            if (this.allErrors)
                this.gen.endIf();
            else
                this.gen.else();
        }
    }
    pass(condition, failAction) {
        this.result(condition, undefined, failAction);
    }
    fail(condition) {
        if (condition === undefined) {
            this.error();
            if (!this.allErrors)
                this.gen.if(false); // this branch will be removed by gen.optimize
            return;
        }
        this.gen.if(condition);
        this.error();
        if (this.allErrors)
            this.gen.endIf();
        else
            this.gen.else();
    }
    fail$data(condition) {
        if (!this.$data)
            return this.fail(condition);
        const { schemaCode } = this;
        this.fail(codegen_1._ `${schemaCode} !== undefined && (${codegen_1.or(this.invalid$data(), condition)})`);
    }
    error(append, errorParams, errorPaths) {
        if (errorParams) {
            this.setParams(errorParams);
            this._error(append, errorPaths);
            this.setParams({});
            return;
        }
        this._error(append, errorPaths);
    }
    _error(append, errorPaths) {
        ;
        (append ? errors_1.reportExtraError : errors_1.reportError)(this, this.def.error, errorPaths);
    }
    $dataError() {
        errors_1.reportError(this, this.def.$dataError || errors_1.keyword$DataError);
    }
    reset() {
        if (this.errsCount === undefined)
            throw new Error('add "trackErrors" to keyword definition');
        errors_1.resetErrorsCount(this.gen, this.errsCount);
    }
    ok(cond) {
        if (!this.allErrors)
            this.gen.if(cond);
    }
    setParams(obj, assign) {
        if (assign)
            Object.assign(this.params, obj);
        else
            this.params = obj;
    }
    block$data(valid, codeBlock, $dataValid = codegen_1.nil) {
        this.gen.block(() => {
            this.check$data(valid, $dataValid);
            codeBlock();
        });
    }
    check$data(valid = codegen_1.nil, $dataValid = codegen_1.nil) {
        if (!this.$data)
            return;
        const { gen, schemaCode, schemaType, def } = this;
        gen.if(codegen_1.or(codegen_1._ `${schemaCode} === undefined`, $dataValid));
        if (valid !== codegen_1.nil)
            gen.assign(valid, true);
        if (schemaType.length || def.validateSchema) {
            gen.elseIf(this.invalid$data());
            this.$dataError();
            if (valid !== codegen_1.nil)
                gen.assign(valid, false);
        }
        gen.else();
    }
    invalid$data() {
        const { gen, schemaCode, schemaType, def, it } = this;
        return codegen_1.or(wrong$DataType(), invalid$DataSchema());
        function wrong$DataType() {
            if (schemaType.length) {
                /* istanbul ignore if */
                if (!(schemaCode instanceof codegen_1.Name))
                    throw new Error("ajv implementation error");
                const st = Array.isArray(schemaType) ? schemaType : [schemaType];
                return codegen_1._ `${dataType_2.checkDataTypes(st, schemaCode, it.opts.strictNumbers, dataType_2.DataType.Wrong)}`;
            }
            return codegen_1.nil;
        }
        function invalid$DataSchema() {
            if (def.validateSchema) {
                const validateSchemaRef = gen.scopeValue("validate$data", { ref: def.validateSchema }); // TODO value.code for standalone
                return codegen_1._ `!${validateSchemaRef}(${schemaCode})`;
            }
            return codegen_1.nil;
        }
    }
    subschema(appl, valid) {
        const subschema = subschema_1.getSubschema(this.it, appl);
        subschema_1.extendSubschemaData(subschema, this.it, appl);
        subschema_1.extendSubschemaMode(subschema, appl);
        const nextContext = { ...this.it, ...subschema, items: undefined, props: undefined };
        subschemaCode(nextContext, valid);
        return nextContext;
    }
    mergeEvaluated(schemaCxt, toName) {
        const { it, gen } = this;
        if (!it.opts.unevaluated)
            return;
        if (it.props !== true && schemaCxt.props !== undefined) {
            it.props = util_1.mergeEvaluated.props(gen, schemaCxt.props, it.props, toName);
        }
        if (it.items !== true && schemaCxt.items !== undefined) {
            it.items = util_1.mergeEvaluated.items(gen, schemaCxt.items, it.items, toName);
        }
    }
    mergeValidEvaluated(schemaCxt, valid) {
        const { it, gen } = this;
        if (it.opts.unevaluated && (it.props !== true || it.items !== true)) {
            gen.if(valid, () => this.mergeEvaluated(schemaCxt, codegen_1.Name));
            return true;
        }
    }
}
exports.KeywordCxt = KeywordCxt;
function keywordCode(it, keyword, def, ruleType) {
    const cxt = new KeywordCxt(it, def, keyword);
    if ("code" in def) {
        def.code(cxt, ruleType);
    }
    else if (cxt.$data && def.validate) {
        keyword_1.funcKeywordCode(cxt, def);
    }
    else if ("macro" in def) {
        keyword_1.macroKeywordCode(cxt, def);
    }
    else if (def.compile || def.validate) {
        keyword_1.funcKeywordCode(cxt, def);
    }
}
const JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
const RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
function getData($data, { dataLevel, dataNames, dataPathArr }) {
    let jsonPointer;
    let data;
    if ($data === "")
        return names_1.default.rootData;
    if ($data[0] === "/") {
        if (!JSON_POINTER.test($data))
            throw new Error(`Invalid JSON-pointer: ${$data}`);
        jsonPointer = $data;
        data = names_1.default.rootData;
    }
    else {
        const matches = RELATIVE_JSON_POINTER.exec($data);
        if (!matches)
            throw new Error(`Invalid JSON-pointer: ${$data}`);
        const up = +matches[1];
        jsonPointer = matches[2];
        if (jsonPointer === "#") {
            if (up >= dataLevel)
                throw new Error(errorMsg("property/index", up));
            return dataPathArr[dataLevel - up];
        }
        if (up > dataLevel)
            throw new Error(errorMsg("data", up));
        data = dataNames[dataLevel - up];
        if (!jsonPointer)
            return data;
    }
    let expr = data;
    const segments = jsonPointer.split("/");
    for (const segment of segments) {
        if (segment) {
            data = codegen_1._ `${data}${codegen_1.getProperty(util_1.unescapeJsonPointer(segment))}`;
            expr = codegen_1._ `${expr} && ${data}`;
        }
    }
    return expr;
    function errorMsg(pointerType, up) {
        return `Cannot access ${pointerType} ${up} levels up, current level is ${dataLevel}`;
    }
}
exports.getData = getData;

},{"../codegen":2,"../errors":4,"../names":6,"../resolve":8,"../util":10,"./applicability":11,"./boolSchema":12,"./dataType":13,"./defaults":14,"./keyword":16,"./subschema":17}],16:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateKeywordUsage = exports.validSchemaType = exports.funcKeywordCode = exports.macroKeywordCode = void 0;
const codegen_1 = require("../codegen");
const names_1 = require("../names");
const code_1 = require("../../vocabularies/code");
const errors_1 = require("../errors");
function macroKeywordCode(cxt, def) {
    const { gen, keyword, schema, parentSchema, it } = cxt;
    const macroSchema = def.macro.call(it.self, schema, parentSchema, it);
    const schemaRef = useKeyword(gen, keyword, macroSchema);
    if (it.opts.validateSchema !== false)
        it.self.validateSchema(macroSchema, true);
    const valid = gen.name("valid");
    cxt.subschema({
        schema: macroSchema,
        schemaPath: codegen_1.nil,
        errSchemaPath: `${it.errSchemaPath}/${keyword}`,
        topSchemaRef: schemaRef,
        compositeRule: true,
    }, valid);
    cxt.pass(valid, () => cxt.error(true));
}
exports.macroKeywordCode = macroKeywordCode;
function funcKeywordCode(cxt, def) {
    var _a;
    const { gen, keyword, schema, parentSchema, $data, it } = cxt;
    checkAsyncKeyword(it, def);
    const validate = !$data && def.compile ? def.compile.call(it.self, schema, parentSchema, it) : def.validate;
    const validateRef = useKeyword(gen, keyword, validate);
    const valid = gen.let("valid");
    cxt.block$data(valid, validateKeyword);
    cxt.ok((_a = def.valid) !== null && _a !== void 0 ? _a : valid);
    function validateKeyword() {
        if (def.errors === false) {
            assignValid();
            if (def.modifying)
                modifyData(cxt);
            reportErrs(() => cxt.error());
        }
        else {
            const ruleErrs = def.async ? validateAsync() : validateSync();
            if (def.modifying)
                modifyData(cxt);
            reportErrs(() => addErrs(cxt, ruleErrs));
        }
    }
    function validateAsync() {
        const ruleErrs = gen.let("ruleErrs", null);
        gen.try(() => assignValid(codegen_1._ `await `), (e) => gen.assign(valid, false).if(codegen_1._ `${e} instanceof ${it.ValidationError}`, () => gen.assign(ruleErrs, codegen_1._ `${e}.errors`), () => gen.throw(e)));
        return ruleErrs;
    }
    function validateSync() {
        const validateErrs = codegen_1._ `${validateRef}.errors`;
        gen.assign(validateErrs, null);
        assignValid(codegen_1.nil);
        return validateErrs;
    }
    function assignValid(_await = def.async ? codegen_1._ `await ` : codegen_1.nil) {
        const passCxt = it.opts.passContext ? names_1.default.this : names_1.default.self;
        const passSchema = !(("compile" in def && !$data) || def.schema === false);
        gen.assign(valid, codegen_1._ `${_await}${code_1.callValidateCode(cxt, validateRef, passCxt, passSchema)}`, def.modifying);
    }
    function reportErrs(errors) {
        var _a;
        gen.if(codegen_1.not((_a = def.valid) !== null && _a !== void 0 ? _a : valid), errors);
    }
}
exports.funcKeywordCode = funcKeywordCode;
function modifyData(cxt) {
    const { gen, data, it } = cxt;
    gen.if(it.parentData, () => gen.assign(data, codegen_1._ `${it.parentData}[${it.parentDataProperty}]`));
}
function addErrs(cxt, errs) {
    const { gen } = cxt;
    gen.if(codegen_1._ `Array.isArray(${errs})`, () => {
        gen
            .assign(names_1.default.vErrors, codegen_1._ `${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`)
            .assign(names_1.default.errors, codegen_1._ `${names_1.default.vErrors}.length`);
        errors_1.extendErrors(cxt);
    }, () => cxt.error());
}
function checkAsyncKeyword({ schemaEnv }, def) {
    if (def.async && !schemaEnv.$async)
        throw new Error("async keyword in sync schema");
}
function useKeyword(gen, keyword, result) {
    if (result === undefined)
        throw new Error(`keyword "${keyword}" failed to compile`);
    return gen.scopeValue("keyword", typeof result == "function" ? { ref: result } : { ref: result, code: codegen_1.stringify(result) });
}
function validSchemaType(schema, schemaType, allowUndefined = false) {
    // TODO add tests
    return (!schemaType.length ||
        schemaType.some((st) => st === "array"
            ? Array.isArray(schema)
            : st === "object"
                ? schema && typeof schema == "object" && !Array.isArray(schema)
                : typeof schema == st || (allowUndefined && typeof schema == "undefined")));
}
exports.validSchemaType = validSchemaType;
function validateKeywordUsage({ schema, opts, self, errSchemaPath }, def, keyword) {
    /* istanbul ignore if */
    if (Array.isArray(def.keyword) ? !def.keyword.includes(keyword) : def.keyword !== keyword) {
        throw new Error("ajv implementation error");
    }
    const deps = def.dependencies;
    if (deps === null || deps === void 0 ? void 0 : deps.some((kwd) => !Object.prototype.hasOwnProperty.call(schema, kwd))) {
        throw new Error(`parent schema must have dependencies of ${keyword}: ${deps.join(",")}`);
    }
    if (def.validateSchema) {
        const valid = def.validateSchema(schema[keyword]);
        if (!valid) {
            const msg = `keyword "${keyword}" value is invalid at path "${errSchemaPath}": ` +
                self.errorsText(def.validateSchema.errors);
            if (opts.validateSchema === "log")
                self.logger.error(msg);
            else
                throw new Error(msg);
        }
    }
}
exports.validateKeywordUsage = validateKeywordUsage;

},{"../../vocabularies/code":41,"../codegen":2,"../errors":4,"../names":6}],17:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extendSubschemaMode = exports.extendSubschemaData = exports.getSubschema = void 0;
const codegen_1 = require("../codegen");
const util_1 = require("../util");
function getSubschema(it, { keyword, schemaProp, schema, schemaPath, errSchemaPath, topSchemaRef }) {
    if (keyword !== undefined && schema !== undefined) {
        throw new Error('both "keyword" and "schema" passed, only one allowed');
    }
    if (keyword !== undefined) {
        const sch = it.schema[keyword];
        return schemaProp === undefined
            ? {
                schema: sch,
                schemaPath: codegen_1._ `${it.schemaPath}${codegen_1.getProperty(keyword)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword}`,
            }
            : {
                schema: sch[schemaProp],
                schemaPath: codegen_1._ `${it.schemaPath}${codegen_1.getProperty(keyword)}${codegen_1.getProperty(schemaProp)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword}/${util_1.escapeFragment(schemaProp)}`,
            };
    }
    if (schema !== undefined) {
        if (schemaPath === undefined || errSchemaPath === undefined || topSchemaRef === undefined) {
            throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');
        }
        return {
            schema,
            schemaPath,
            topSchemaRef,
            errSchemaPath,
        };
    }
    throw new Error('either "keyword" or "schema" must be passed');
}
exports.getSubschema = getSubschema;
function extendSubschemaData(subschema, it, { dataProp, dataPropType: dpType, data, dataTypes, propertyName }) {
    if (data !== undefined && dataProp !== undefined) {
        throw new Error('both "data" and "dataProp" passed, only one allowed');
    }
    const { gen } = it;
    if (dataProp !== undefined) {
        const { errorPath, dataPathArr, opts } = it;
        const nextData = gen.let("data", codegen_1._ `${it.data}${codegen_1.getProperty(dataProp)}`, true);
        dataContextProps(nextData);
        subschema.errorPath = codegen_1.str `${errorPath}${util_1.getErrorPath(dataProp, dpType, opts.jsPropertySyntax)}`;
        subschema.parentDataProperty = codegen_1._ `${dataProp}`;
        subschema.dataPathArr = [...dataPathArr, subschema.parentDataProperty];
    }
    if (data !== undefined) {
        const nextData = data instanceof codegen_1.Name ? data : gen.let("data", data, true); // replaceable if used once?
        dataContextProps(nextData);
        if (propertyName !== undefined)
            subschema.propertyName = propertyName;
        // TODO something is possibly wrong here with not changing parentDataProperty and not appending dataPathArr
    }
    if (dataTypes)
        subschema.dataTypes = dataTypes;
    function dataContextProps(_nextData) {
        subschema.data = _nextData;
        subschema.dataLevel = it.dataLevel + 1;
        subschema.dataTypes = [];
        it.definedProperties = new Set();
        subschema.parentData = it.data;
        subschema.dataNames = [...it.dataNames, _nextData];
    }
}
exports.extendSubschemaData = extendSubschemaData;
function extendSubschemaMode(subschema, { jtdDiscriminator, jtdMetadata, compositeRule, createErrors, allErrors }) {
    if (compositeRule !== undefined)
        subschema.compositeRule = compositeRule;
    if (createErrors !== undefined)
        subschema.createErrors = createErrors;
    if (allErrors !== undefined)
        subschema.allErrors = allErrors;
    subschema.jtdDiscriminator = jtdDiscriminator; // not inherited
    subschema.jtdMetadata = jtdMetadata; // not inherited
}
exports.extendSubschemaMode = extendSubschemaMode;

},{"../codegen":2,"../util":10}],18:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = void 0;
var validate_1 = require("./compile/validate");
Object.defineProperty(exports, "KeywordCxt", { enumerable: true, get: function () { return validate_1.KeywordCxt; } });
var codegen_1 = require("./compile/codegen");
Object.defineProperty(exports, "_", { enumerable: true, get: function () { return codegen_1._; } });
Object.defineProperty(exports, "str", { enumerable: true, get: function () { return codegen_1.str; } });
Object.defineProperty(exports, "stringify", { enumerable: true, get: function () { return codegen_1.stringify; } });
Object.defineProperty(exports, "nil", { enumerable: true, get: function () { return codegen_1.nil; } });
Object.defineProperty(exports, "Name", { enumerable: true, get: function () { return codegen_1.Name; } });
Object.defineProperty(exports, "CodeGen", { enumerable: true, get: function () { return codegen_1.CodeGen; } });
const validation_error_1 = require("./runtime/validation_error");
const ref_error_1 = require("./compile/ref_error");
const rules_1 = require("./compile/rules");
const compile_1 = require("./compile");
const codegen_2 = require("./compile/codegen");
const resolve_1 = require("./compile/resolve");
const dataType_1 = require("./compile/validate/dataType");
const util_1 = require("./compile/util");
const $dataRefSchema = require("./refs/data.json");
const META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes"];
const EXT_SCOPE_NAMES = new Set([
    "validate",
    "serialize",
    "parse",
    "wrapper",
    "root",
    "schema",
    "keyword",
    "pattern",
    "formats",
    "validate$data",
    "func",
    "obj",
    "Error",
]);
const removedOptions = {
    errorDataPath: "",
    format: "`validateFormats: false` can be used instead.",
    nullable: '"nullable" keyword is supported by default.',
    jsonPointers: "Deprecated jsPropertySyntax can be used instead.",
    extendRefs: "Deprecated ignoreKeywordsWithRef can be used instead.",
    missingRefs: "Pass empty schema with $id that should be ignored to ajv.addSchema.",
    processCode: "Use option `code: {process: (code, schemaEnv: object) => string}`",
    sourceCode: "Use option `code: {source: true}`",
    schemaId: "JSON Schema draft-04 is not supported in Ajv v7/8.",
    strictDefaults: "It is default now, see option `strict`.",
    strictKeywords: "It is default now, see option `strict`.",
    uniqueItems: '"uniqueItems" keyword is always validated.',
    unknownFormats: "Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",
    cache: "Map is used as cache, schema object as key.",
    serialize: "Map is used as cache, schema object as key.",
    ajvErrors: "It is default now, see option `strict`.",
};
const deprecatedOptions = {
    ignoreKeywordsWithRef: "",
    jsPropertySyntax: "",
    unicode: '"minLength"/"maxLength" account for unicode characters by default.',
};
const MAX_EXPRESSION = 200;
// eslint-disable-next-line complexity
function requiredOptions(o) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
    const s = o.strict;
    const _optz = (_a = o.code) === null || _a === void 0 ? void 0 : _a.optimize;
    const optimize = _optz === true || _optz === undefined ? 1 : _optz || 0;
    return {
        strictSchema: (_c = (_b = o.strictSchema) !== null && _b !== void 0 ? _b : s) !== null && _c !== void 0 ? _c : true,
        strictNumbers: (_e = (_d = o.strictNumbers) !== null && _d !== void 0 ? _d : s) !== null && _e !== void 0 ? _e : true,
        strictTypes: (_g = (_f = o.strictTypes) !== null && _f !== void 0 ? _f : s) !== null && _g !== void 0 ? _g : "log",
        strictTuples: (_j = (_h = o.strictTuples) !== null && _h !== void 0 ? _h : s) !== null && _j !== void 0 ? _j : "log",
        strictRequired: (_l = (_k = o.strictRequired) !== null && _k !== void 0 ? _k : s) !== null && _l !== void 0 ? _l : false,
        code: o.code ? { ...o.code, optimize } : { optimize },
        loopRequired: (_m = o.loopRequired) !== null && _m !== void 0 ? _m : MAX_EXPRESSION,
        loopEnum: (_o = o.loopEnum) !== null && _o !== void 0 ? _o : MAX_EXPRESSION,
        meta: (_p = o.meta) !== null && _p !== void 0 ? _p : true,
        messages: (_q = o.messages) !== null && _q !== void 0 ? _q : true,
        inlineRefs: (_r = o.inlineRefs) !== null && _r !== void 0 ? _r : true,
        addUsedSchema: (_s = o.addUsedSchema) !== null && _s !== void 0 ? _s : true,
        validateSchema: (_t = o.validateSchema) !== null && _t !== void 0 ? _t : true,
        validateFormats: (_u = o.validateFormats) !== null && _u !== void 0 ? _u : true,
        unicodeRegExp: (_v = o.unicodeRegExp) !== null && _v !== void 0 ? _v : true,
    };
}
class Ajv {
    constructor(opts = {}) {
        this.schemas = {};
        this.refs = {};
        this.formats = {};
        this._compilations = new Set();
        this._loading = {};
        this._cache = new Map();
        opts = this.opts = { ...opts, ...requiredOptions(opts) };
        const { es5, lines } = this.opts.code;
        this.scope = new codegen_2.ValueScope({ scope: {}, prefixes: EXT_SCOPE_NAMES, es5, lines });
        this.logger = getLogger(opts.logger);
        const formatOpt = opts.validateFormats;
        opts.validateFormats = false;
        this.RULES = rules_1.getRules();
        checkOptions.call(this, removedOptions, opts, "NOT SUPPORTED");
        checkOptions.call(this, deprecatedOptions, opts, "DEPRECATED", "warn");
        this._metaOpts = getMetaSchemaOptions.call(this);
        if (opts.formats)
            addInitialFormats.call(this);
        this._addVocabularies();
        this._addDefaultMetaSchema();
        if (opts.keywords)
            addInitialKeywords.call(this, opts.keywords);
        if (typeof opts.meta == "object")
            this.addMetaSchema(opts.meta);
        addInitialSchemas.call(this);
        opts.validateFormats = formatOpt;
    }
    _addVocabularies() {
        this.addKeyword("$async");
    }
    _addDefaultMetaSchema() {
        const { $data, meta } = this.opts;
        if (meta && $data)
            this.addMetaSchema($dataRefSchema, $dataRefSchema.$id, false);
    }
    defaultMeta() {
        const { meta } = this.opts;
        return (this.opts.defaultMeta = typeof meta == "object" ? meta.$id || meta : undefined);
    }
    validate(schemaKeyRef, // key, ref or schema object
    data // to be validated
    ) {
        let v;
        if (typeof schemaKeyRef == "string") {
            v = this.getSchema(schemaKeyRef);
            if (!v)
                throw new Error(`no schema with key or ref "${schemaKeyRef}"`);
        }
        else {
            v = this.compile(schemaKeyRef);
        }
        const valid = v(data);
        if (!("$async" in v))
            this.errors = v.errors;
        return valid;
    }
    compile(schema, _meta) {
        const sch = this._addSchema(schema, _meta);
        return (sch.validate || this._compileSchemaEnv(sch));
    }
    compileAsync(schema, meta) {
        if (typeof this.opts.loadSchema != "function") {
            throw new Error("options.loadSchema should be a function");
        }
        const { loadSchema } = this.opts;
        return runCompileAsync.call(this, schema, meta);
        async function runCompileAsync(_schema, _meta) {
            await loadMetaSchema.call(this, _schema.$schema);
            const sch = this._addSchema(_schema, _meta);
            return sch.validate || _compileAsync.call(this, sch);
        }
        async function loadMetaSchema($ref) {
            if ($ref && !this.getSchema($ref)) {
                await runCompileAsync.call(this, { $ref }, true);
            }
        }
        async function _compileAsync(sch) {
            try {
                return this._compileSchemaEnv(sch);
            }
            catch (e) {
                if (!(e instanceof ref_error_1.default))
                    throw e;
                checkLoaded.call(this, e);
                await loadMissingSchema.call(this, e.missingSchema);
                return _compileAsync.call(this, sch);
            }
        }
        function checkLoaded({ missingSchema: ref, missingRef }) {
            if (this.refs[ref]) {
                throw new Error(`AnySchema ${ref} is loaded but ${missingRef} cannot be resolved`);
            }
        }
        async function loadMissingSchema(ref) {
            const _schema = await _loadSchema.call(this, ref);
            if (!this.refs[ref])
                await loadMetaSchema.call(this, _schema.$schema);
            if (!this.refs[ref])
                this.addSchema(_schema, ref, meta);
        }
        async function _loadSchema(ref) {
            const p = this._loading[ref];
            if (p)
                return p;
            try {
                return await (this._loading[ref] = loadSchema(ref));
            }
            finally {
                delete this._loading[ref];
            }
        }
    }
    // Adds schema to the instance
    addSchema(schema, // If array is passed, `key` will be ignored
    key, // Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
    _meta, // true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
    _validateSchema = this.opts.validateSchema // false to skip schema validation. Used internally, option validateSchema should be used instead.
    ) {
        if (Array.isArray(schema)) {
            for (const sch of schema)
                this.addSchema(sch, undefined, _meta, _validateSchema);
            return this;
        }
        let id;
        if (typeof schema === "object") {
            id = schema.$id;
            if (id !== undefined && typeof id != "string")
                throw new Error("schema $id must be string");
        }
        key = resolve_1.normalizeId(key || id);
        this._checkUnique(key);
        this.schemas[key] = this._addSchema(schema, _meta, key, _validateSchema, true);
        return this;
    }
    // Add schema that will be used to validate other schemas
    // options in META_IGNORE_OPTIONS are alway set to false
    addMetaSchema(schema, key, // schema key
    _validateSchema = this.opts.validateSchema // false to skip schema validation, can be used to override validateSchema option for meta-schema
    ) {
        this.addSchema(schema, key, true, _validateSchema);
        return this;
    }
    //  Validate schema against its meta-schema
    validateSchema(schema, throwOrLogError) {
        if (typeof schema == "boolean")
            return true;
        let $schema;
        $schema = schema.$schema;
        if ($schema !== undefined && typeof $schema != "string") {
            throw new Error("$schema must be a string");
        }
        $schema = $schema || this.opts.defaultMeta || this.defaultMeta();
        if (!$schema) {
            this.logger.warn("meta-schema not available");
            this.errors = null;
            return true;
        }
        const valid = this.validate($schema, schema);
        if (!valid && throwOrLogError) {
            const message = "schema is invalid: " + this.errorsText();
            if (this.opts.validateSchema === "log")
                this.logger.error(message);
            else
                throw new Error(message);
        }
        return valid;
    }
    // Get compiled schema by `key` or `ref`.
    // (`key` that was passed to `addSchema` or full schema reference - `schema.$id` or resolved id)
    getSchema(keyRef) {
        let sch;
        while (typeof (sch = getSchEnv.call(this, keyRef)) == "string")
            keyRef = sch;
        if (sch === undefined) {
            const root = new compile_1.SchemaEnv({ schema: {} });
            sch = compile_1.resolveSchema.call(this, root, keyRef);
            if (!sch)
                return;
            this.refs[keyRef] = sch;
        }
        return (sch.validate || this._compileSchemaEnv(sch));
    }
    // Remove cached schema(s).
    // If no parameter is passed all schemas but meta-schemas are removed.
    // If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
    // Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
    removeSchema(schemaKeyRef) {
        if (schemaKeyRef instanceof RegExp) {
            this._removeAllSchemas(this.schemas, schemaKeyRef);
            this._removeAllSchemas(this.refs, schemaKeyRef);
            return this;
        }
        switch (typeof schemaKeyRef) {
            case "undefined":
                this._removeAllSchemas(this.schemas);
                this._removeAllSchemas(this.refs);
                this._cache.clear();
                return this;
            case "string": {
                const sch = getSchEnv.call(this, schemaKeyRef);
                if (typeof sch == "object")
                    this._cache.delete(sch.schema);
                delete this.schemas[schemaKeyRef];
                delete this.refs[schemaKeyRef];
                return this;
            }
            case "object": {
                const cacheKey = schemaKeyRef;
                this._cache.delete(cacheKey);
                let id = schemaKeyRef.$id;
                if (id) {
                    id = resolve_1.normalizeId(id);
                    delete this.schemas[id];
                    delete this.refs[id];
                }
                return this;
            }
            default:
                throw new Error("ajv.removeSchema: invalid parameter");
        }
    }
    // add "vocabulary" - a collection of keywords
    addVocabulary(definitions) {
        for (const def of definitions)
            this.addKeyword(def);
        return this;
    }
    addKeyword(kwdOrDef, def // deprecated
    ) {
        let keyword;
        if (typeof kwdOrDef == "string") {
            keyword = kwdOrDef;
            if (typeof def == "object") {
                this.logger.warn("these parameters are deprecated, see docs for addKeyword");
                def.keyword = keyword;
            }
        }
        else if (typeof kwdOrDef == "object" && def === undefined) {
            def = kwdOrDef;
            keyword = def.keyword;
            if (Array.isArray(keyword) && !keyword.length) {
                throw new Error("addKeywords: keyword must be string or non-empty array");
            }
        }
        else {
            throw new Error("invalid addKeywords parameters");
        }
        checkKeyword.call(this, keyword, def);
        if (!def) {
            util_1.eachItem(keyword, (kwd) => addRule.call(this, kwd));
            return this;
        }
        keywordMetaschema.call(this, def);
        const definition = {
            ...def,
            type: dataType_1.getJSONTypes(def.type),
            schemaType: dataType_1.getJSONTypes(def.schemaType),
        };
        util_1.eachItem(keyword, definition.type.length === 0
            ? (k) => addRule.call(this, k, definition)
            : (k) => definition.type.forEach((t) => addRule.call(this, k, definition, t)));
        return this;
    }
    getKeyword(keyword) {
        const rule = this.RULES.all[keyword];
        return typeof rule == "object" ? rule.definition : !!rule;
    }
    // Remove keyword
    removeKeyword(keyword) {
        // TODO return type should be Ajv
        const { RULES } = this;
        delete RULES.keywords[keyword];
        delete RULES.all[keyword];
        for (const group of RULES.rules) {
            const i = group.rules.findIndex((rule) => rule.keyword === keyword);
            if (i >= 0)
                group.rules.splice(i, 1);
        }
        return this;
    }
    // Add format
    addFormat(name, format) {
        if (typeof format == "string")
            format = new RegExp(format);
        this.formats[name] = format;
        return this;
    }
    errorsText(errors = this.errors, // optional array of validation errors
    { separator = ", ", dataVar = "data" } = {} // optional options with properties `separator` and `dataVar`
    ) {
        if (!errors || errors.length === 0)
            return "No errors";
        return errors
            .map((e) => `${dataVar}${e.instancePath} ${e.message}`)
            .reduce((text, msg) => text + separator + msg);
    }
    $dataMetaSchema(metaSchema, keywordsJsonPointers) {
        const rules = this.RULES.all;
        metaSchema = JSON.parse(JSON.stringify(metaSchema));
        for (const jsonPointer of keywordsJsonPointers) {
            const segments = jsonPointer.split("/").slice(1); // first segment is an empty string
            let keywords = metaSchema;
            for (const seg of segments)
                keywords = keywords[seg];
            for (const key in rules) {
                const rule = rules[key];
                if (typeof rule != "object")
                    continue;
                const { $data } = rule.definition;
                const schema = keywords[key];
                if ($data && schema)
                    keywords[key] = schemaOrData(schema);
            }
        }
        return metaSchema;
    }
    _removeAllSchemas(schemas, regex) {
        for (const keyRef in schemas) {
            const sch = schemas[keyRef];
            if (!regex || regex.test(keyRef)) {
                if (typeof sch == "string") {
                    delete schemas[keyRef];
                }
                else if (sch && !sch.meta) {
                    this._cache.delete(sch.schema);
                    delete schemas[keyRef];
                }
            }
        }
    }
    _addSchema(schema, meta, baseId, validateSchema = this.opts.validateSchema, addSchema = this.opts.addUsedSchema) {
        let id;
        if (typeof schema == "object") {
            id = schema.$id;
        }
        else {
            if (this.opts.jtd)
                throw new Error("schema must be object");
            else if (typeof schema != "boolean")
                throw new Error("schema must be object or boolean");
        }
        let sch = this._cache.get(schema);
        if (sch !== undefined)
            return sch;
        const localRefs = resolve_1.getSchemaRefs.call(this, schema);
        baseId = resolve_1.normalizeId(id || baseId);
        sch = new compile_1.SchemaEnv({ schema, meta, baseId, localRefs });
        this._cache.set(sch.schema, sch);
        if (addSchema && !baseId.startsWith("#")) {
            // TODO atm it is allowed to overwrite schemas without id (instead of not adding them)
            if (baseId)
                this._checkUnique(baseId);
            this.refs[baseId] = sch;
        }
        if (validateSchema)
            this.validateSchema(schema, true);
        return sch;
    }
    _checkUnique(id) {
        if (this.schemas[id] || this.refs[id]) {
            throw new Error(`schema with key or id "${id}" already exists`);
        }
    }
    _compileSchemaEnv(sch) {
        if (sch.meta)
            this._compileMetaSchema(sch);
        else
            compile_1.compileSchema.call(this, sch);
        /* istanbul ignore if */
        if (!sch.validate)
            throw new Error("ajv implementation error");
        return sch.validate;
    }
    _compileMetaSchema(sch) {
        const currentOpts = this.opts;
        this.opts = this._metaOpts;
        try {
            compile_1.compileSchema.call(this, sch);
        }
        finally {
            this.opts = currentOpts;
        }
    }
}
exports.default = Ajv;
Ajv.ValidationError = validation_error_1.default;
Ajv.MissingRefError = ref_error_1.default;
function checkOptions(checkOpts, options, msg, log = "error") {
    for (const key in checkOpts) {
        const opt = key;
        if (opt in options)
            this.logger[log](`${msg}: option ${key}. ${checkOpts[opt]}`);
    }
}
function getSchEnv(keyRef) {
    keyRef = resolve_1.normalizeId(keyRef); // TODO tests fail without this line
    return this.schemas[keyRef] || this.refs[keyRef];
}
function addInitialSchemas() {
    const optsSchemas = this.opts.schemas;
    if (!optsSchemas)
        return;
    if (Array.isArray(optsSchemas))
        this.addSchema(optsSchemas);
    else
        for (const key in optsSchemas)
            this.addSchema(optsSchemas[key], key);
}
function addInitialFormats() {
    for (const name in this.opts.formats) {
        const format = this.opts.formats[name];
        if (format)
            this.addFormat(name, format);
    }
}
function addInitialKeywords(defs) {
    if (Array.isArray(defs)) {
        this.addVocabulary(defs);
        return;
    }
    this.logger.warn("keywords option as map is deprecated, pass array");
    for (const keyword in defs) {
        const def = defs[keyword];
        if (!def.keyword)
            def.keyword = keyword;
        this.addKeyword(def);
    }
}
function getMetaSchemaOptions() {
    const metaOpts = { ...this.opts };
    for (const opt of META_IGNORE_OPTIONS)
        delete metaOpts[opt];
    return metaOpts;
}
const noLogs = { log() { }, warn() { }, error() { } };
function getLogger(logger) {
    if (logger === false)
        return noLogs;
    if (logger === undefined)
        return console;
    if (logger.log && logger.warn && logger.error)
        return logger;
    throw new Error("logger must implement log, warn and error methods");
}
const KEYWORD_NAME = /^[a-z_$][a-z0-9_$:-]*$/i;
function checkKeyword(keyword, def) {
    const { RULES } = this;
    util_1.eachItem(keyword, (kwd) => {
        if (RULES.keywords[kwd])
            throw new Error(`Keyword ${kwd} is already defined`);
        if (!KEYWORD_NAME.test(kwd))
            throw new Error(`Keyword ${kwd} has invalid name`);
    });
    if (!def)
        return;
    if (def.$data && !("code" in def || "validate" in def)) {
        throw new Error('$data keyword must have "code" or "validate" function');
    }
}
function addRule(keyword, definition, dataType) {
    var _a;
    const post = definition === null || definition === void 0 ? void 0 : definition.post;
    if (dataType && post)
        throw new Error('keyword with "post" flag cannot have "type"');
    const { RULES } = this;
    let ruleGroup = post ? RULES.post : RULES.rules.find(({ type: t }) => t === dataType);
    if (!ruleGroup) {
        ruleGroup = { type: dataType, rules: [] };
        RULES.rules.push(ruleGroup);
    }
    RULES.keywords[keyword] = true;
    if (!definition)
        return;
    const rule = {
        keyword,
        definition: {
            ...definition,
            type: dataType_1.getJSONTypes(definition.type),
            schemaType: dataType_1.getJSONTypes(definition.schemaType),
        },
    };
    if (definition.before)
        addBeforeRule.call(this, ruleGroup, rule, definition.before);
    else
        ruleGroup.rules.push(rule);
    RULES.all[keyword] = rule;
    (_a = definition.implements) === null || _a === void 0 ? void 0 : _a.forEach((kwd) => this.addKeyword(kwd));
}
function addBeforeRule(ruleGroup, rule, before) {
    const i = ruleGroup.rules.findIndex((_rule) => _rule.keyword === before);
    if (i >= 0) {
        ruleGroup.rules.splice(i, 0, rule);
    }
    else {
        ruleGroup.rules.push(rule);
        this.logger.warn(`rule ${before} is not defined`);
    }
}
function keywordMetaschema(def) {
    let { metaSchema } = def;
    if (metaSchema === undefined)
        return;
    if (def.$data && this.opts.$data)
        metaSchema = schemaOrData(metaSchema);
    def.validateSchema = this.compile(metaSchema, true);
}
const $dataRef = {
    $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
};
function schemaOrData(schema) {
    return { anyOf: [schema, $dataRef] };
}

},{"./compile":5,"./compile/codegen":2,"./compile/ref_error":7,"./compile/resolve":8,"./compile/rules":9,"./compile/util":10,"./compile/validate":15,"./compile/validate/dataType":13,"./refs/data.json":19,"./runtime/validation_error":23}],19:[function(require,module,exports){
module.exports={
  "$id": "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
  "description": "Meta-schema for $data reference (JSON AnySchema extension proposal)",
  "type": "object",
  "required": ["$data"],
  "properties": {
    "$data": {
      "type": "string",
      "anyOf": [{"format": "relative-json-pointer"}, {"format": "json-pointer"}]
    }
  },
  "additionalProperties": false
}

},{}],20:[function(require,module,exports){
module.exports={
  "$schema": "http://json-schema.org/draft-07/schema#",
  "$id": "http://json-schema.org/draft-07/schema#",
  "title": "Core schema meta-schema",
  "definitions": {
    "schemaArray": {
      "type": "array",
      "minItems": 1,
      "items": {"$ref": "#"}
    },
    "nonNegativeInteger": {
      "type": "integer",
      "minimum": 0
    },
    "nonNegativeIntegerDefault0": {
      "allOf": [{"$ref": "#/definitions/nonNegativeInteger"}, {"default": 0}]
    },
    "simpleTypes": {
      "enum": ["array", "boolean", "integer", "null", "number", "object", "string"]
    },
    "stringArray": {
      "type": "array",
      "items": {"type": "string"},
      "uniqueItems": true,
      "default": []
    }
  },
  "type": ["object", "boolean"],
  "properties": {
    "$id": {
      "type": "string",
      "format": "uri-reference"
    },
    "$schema": {
      "type": "string",
      "format": "uri"
    },
    "$ref": {
      "type": "string",
      "format": "uri-reference"
    },
    "$comment": {
      "type": "string"
    },
    "title": {
      "type": "string"
    },
    "description": {
      "type": "string"
    },
    "default": true,
    "readOnly": {
      "type": "boolean",
      "default": false
    },
    "examples": {
      "type": "array",
      "items": true
    },
    "multipleOf": {
      "type": "number",
      "exclusiveMinimum": 0
    },
    "maximum": {
      "type": "number"
    },
    "exclusiveMaximum": {
      "type": "number"
    },
    "minimum": {
      "type": "number"
    },
    "exclusiveMinimum": {
      "type": "number"
    },
    "maxLength": {"$ref": "#/definitions/nonNegativeInteger"},
    "minLength": {"$ref": "#/definitions/nonNegativeIntegerDefault0"},
    "pattern": {
      "type": "string",
      "format": "regex"
    },
    "additionalItems": {"$ref": "#"},
    "items": {
      "anyOf": [{"$ref": "#"}, {"$ref": "#/definitions/schemaArray"}],
      "default": true
    },
    "maxItems": {"$ref": "#/definitions/nonNegativeInteger"},
    "minItems": {"$ref": "#/definitions/nonNegativeIntegerDefault0"},
    "uniqueItems": {
      "type": "boolean",
      "default": false
    },
    "contains": {"$ref": "#"},
    "maxProperties": {"$ref": "#/definitions/nonNegativeInteger"},
    "minProperties": {"$ref": "#/definitions/nonNegativeIntegerDefault0"},
    "required": {"$ref": "#/definitions/stringArray"},
    "additionalProperties": {"$ref": "#"},
    "definitions": {
      "type": "object",
      "additionalProperties": {"$ref": "#"},
      "default": {}
    },
    "properties": {
      "type": "object",
      "additionalProperties": {"$ref": "#"},
      "default": {}
    },
    "patternProperties": {
      "type": "object",
      "additionalProperties": {"$ref": "#"},
      "propertyNames": {"format": "regex"},
      "default": {}
    },
    "dependencies": {
      "type": "object",
      "additionalProperties": {
        "anyOf": [{"$ref": "#"}, {"$ref": "#/definitions/stringArray"}]
      }
    },
    "propertyNames": {"$ref": "#"},
    "const": true,
    "enum": {
      "type": "array",
      "items": true,
      "minItems": 1,
      "uniqueItems": true
    },
    "type": {
      "anyOf": [
        {"$ref": "#/definitions/simpleTypes"},
        {
          "type": "array",
          "items": {"$ref": "#/definitions/simpleTypes"},
          "minItems": 1,
          "uniqueItems": true
        }
      ]
    },
    "format": {"type": "string"},
    "contentMediaType": {"type": "string"},
    "contentEncoding": {"type": "string"},
    "if": {"$ref": "#"},
    "then": {"$ref": "#"},
    "else": {"$ref": "#"},
    "allOf": {"$ref": "#/definitions/schemaArray"},
    "anyOf": {"$ref": "#/definitions/schemaArray"},
    "oneOf": {"$ref": "#/definitions/schemaArray"},
    "not": {"$ref": "#"}
  },
  "default": true
}

},{}],21:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// https://github.com/ajv-validator/ajv/issues/889
const equal = require("fast-deep-equal");
equal.code = 'require("ajv/dist/runtime/equal").default';
exports.default = equal;

},{"fast-deep-equal":62}],22:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// https://mathiasbynens.be/notes/javascript-encoding
// https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
function ucs2length(str) {
    const len = str.length;
    let length = 0;
    let pos = 0;
    let value;
    while (pos < len) {
        length++;
        value = str.charCodeAt(pos++);
        if (value >= 0xd800 && value <= 0xdbff && pos < len) {
            // high surrogate, and there is a next character
            value = str.charCodeAt(pos);
            if ((value & 0xfc00) === 0xdc00)
                pos++; // low surrogate
        }
    }
    return length;
}
exports.default = ucs2length;
ucs2length.code = 'require("ajv/dist/runtime/ucs2length").default';

},{}],23:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ValidationError extends Error {
    constructor(errors) {
        super("validation failed");
        this.errors = errors;
        this.ajv = this.validation = true;
    }
}
exports.default = ValidationError;

},{}],24:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateAdditionalItems = void 0;
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: ({ params: { len } }) => codegen_1.str `must NOT have more than ${len} items`,
    params: ({ params: { len } }) => codegen_1._ `{limit: ${len}}`,
};
const def = {
    keyword: "additionalItems",
    type: "array",
    schemaType: ["boolean", "object"],
    before: "uniqueItems",
    error,
    code(cxt) {
        const { parentSchema, it } = cxt;
        const { items } = parentSchema;
        if (!Array.isArray(items)) {
            util_1.checkStrictMode(it, '"additionalItems" is ignored when "items" is not an array of schemas');
            return;
        }
        validateAdditionalItems(cxt, items);
    },
};
function validateAdditionalItems(cxt, items) {
    const { gen, schema, data, keyword, it } = cxt;
    it.items = true;
    const len = gen.const("len", codegen_1._ `${data}.length`);
    if (schema === false) {
        cxt.setParams({ len: items.length });
        cxt.pass(codegen_1._ `${len} <= ${items.length}`);
    }
    else if (typeof schema == "object" && !util_1.alwaysValidSchema(it, schema)) {
        const valid = gen.var("valid", codegen_1._ `${len} <= ${items.length}`); // TODO var
        gen.if(codegen_1.not(valid), () => validateItems(valid));
        cxt.ok(valid);
    }
    function validateItems(valid) {
        gen.forRange("i", items.length, len, (i) => {
            cxt.subschema({ keyword, dataProp: i, dataPropType: util_1.Type.Num }, valid);
            if (!it.allErrors)
                gen.if(codegen_1.not(valid), () => gen.break());
        });
    }
}
exports.validateAdditionalItems = validateAdditionalItems;
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10}],25:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const names_1 = require("../../compile/names");
const util_1 = require("../../compile/util");
const error = {
    message: "must NOT have additional properties",
    params: ({ params }) => codegen_1._ `{additionalProperty: ${params.additionalProperty}}`,
};
const def = {
    keyword: "additionalProperties",
    type: ["object"],
    schemaType: ["boolean", "object"],
    allowUndefined: true,
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, data, errsCount, it } = cxt;
        /* istanbul ignore if */
        if (!errsCount)
            throw new Error("ajv implementation error");
        const { allErrors, opts } = it;
        it.props = true;
        if (opts.removeAdditional !== "all" && util_1.alwaysValidSchema(it, schema))
            return;
        const props = code_1.allSchemaProperties(parentSchema.properties);
        const patProps = code_1.allSchemaProperties(parentSchema.patternProperties);
        checkAdditionalProperties();
        cxt.ok(codegen_1._ `${errsCount} === ${names_1.default.errors}`);
        function checkAdditionalProperties() {
            gen.forIn("key", data, (key) => {
                if (!props.length && !patProps.length)
                    additionalPropertyCode(key);
                else
                    gen.if(isAdditional(key), () => additionalPropertyCode(key));
            });
        }
        function isAdditional(key) {
            let definedProp;
            if (props.length > 8) {
                // TODO maybe an option instead of hard-coded 8?
                const propsSchema = util_1.schemaRefOrVal(it, parentSchema.properties, "properties");
                definedProp = code_1.isOwnProperty(gen, propsSchema, key);
            }
            else if (props.length) {
                definedProp = codegen_1.or(...props.map((p) => codegen_1._ `${key} === ${p}`));
            }
            else {
                definedProp = codegen_1.nil;
            }
            if (patProps.length) {
                definedProp = codegen_1.or(definedProp, ...patProps.map((p) => codegen_1._ `${code_1.usePattern(cxt, p)}.test(${key})`));
            }
            return codegen_1.not(definedProp);
        }
        function deleteAdditional(key) {
            gen.code(codegen_1._ `delete ${data}[${key}]`);
        }
        function additionalPropertyCode(key) {
            if (opts.removeAdditional === "all" || (opts.removeAdditional && schema === false)) {
                deleteAdditional(key);
                return;
            }
            if (schema === false) {
                cxt.setParams({ additionalProperty: key });
                cxt.error();
                if (!allErrors)
                    gen.break();
                return;
            }
            if (typeof schema == "object" && !util_1.alwaysValidSchema(it, schema)) {
                const valid = gen.name("valid");
                if (opts.removeAdditional === "failing") {
                    applyAdditionalSchema(key, valid, false);
                    gen.if(codegen_1.not(valid), () => {
                        cxt.reset();
                        deleteAdditional(key);
                    });
                }
                else {
                    applyAdditionalSchema(key, valid);
                    if (!allErrors)
                        gen.if(codegen_1.not(valid), () => gen.break());
                }
            }
        }
        function applyAdditionalSchema(key, valid, errors) {
            const subschema = {
                keyword: "additionalProperties",
                dataProp: key,
                dataPropType: util_1.Type.Str,
            };
            if (errors === false) {
                Object.assign(subschema, {
                    compositeRule: true,
                    createErrors: false,
                    allErrors: false,
                });
            }
            cxt.subschema(subschema, valid);
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/names":6,"../../compile/util":10,"../code":41}],26:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../../compile/util");
const def = {
    keyword: "allOf",
    schemaType: "array",
    code(cxt) {
        const { gen, schema, it } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        const valid = gen.name("valid");
        schema.forEach((sch, i) => {
            if (util_1.alwaysValidSchema(it, sch))
                return;
            const schCxt = cxt.subschema({ keyword: "allOf", schemaProp: i }, valid);
            cxt.ok(valid);
            cxt.mergeEvaluated(schCxt);
        });
    },
};
exports.default = def;

},{"../../compile/util":10}],27:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const code_1 = require("../code");
const def = {
    keyword: "anyOf",
    schemaType: "array",
    trackErrors: true,
    code: code_1.validateUnion,
    error: { message: "must match a schema in anyOf" },
};
exports.default = def;

},{"../code":41}],28:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: ({ params: { min, max } }) => max === undefined
        ? codegen_1.str `must contain at least ${min} valid item(s)`
        : codegen_1.str `must contain at least ${min} and no more than ${max} valid item(s)`,
    params: ({ params: { min, max } }) => max === undefined ? codegen_1._ `{minContains: ${min}}` : codegen_1._ `{minContains: ${min}, maxContains: ${max}}`,
};
const def = {
    keyword: "contains",
    type: "array",
    schemaType: ["object", "boolean"],
    before: "uniqueItems",
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        let min;
        let max;
        const { minContains, maxContains } = parentSchema;
        if (it.opts.next) {
            min = minContains === undefined ? 1 : minContains;
            max = maxContains;
        }
        else {
            min = 1;
        }
        const len = gen.const("len", codegen_1._ `${data}.length`);
        cxt.setParams({ min, max });
        if (max === undefined && min === 0) {
            util_1.checkStrictMode(it, `"minContains" == 0 without "maxContains": "contains" keyword ignored`);
            return;
        }
        if (max !== undefined && min > max) {
            util_1.checkStrictMode(it, `"minContains" > "maxContains" is always invalid`);
            cxt.fail();
            return;
        }
        if (util_1.alwaysValidSchema(it, schema)) {
            let cond = codegen_1._ `${len} >= ${min}`;
            if (max !== undefined)
                cond = codegen_1._ `${cond} && ${len} <= ${max}`;
            cxt.pass(cond);
            return;
        }
        it.items = true;
        const valid = gen.name("valid");
        if (max === undefined && min === 1) {
            validateItems(valid, () => gen.if(valid, () => gen.break()));
        }
        else {
            gen.let(valid, false);
            const schValid = gen.name("_valid");
            const count = gen.let("count", 0);
            validateItems(schValid, () => gen.if(schValid, () => checkLimits(count)));
        }
        cxt.result(valid, () => cxt.reset());
        function validateItems(_valid, block) {
            gen.forRange("i", 0, len, (i) => {
                cxt.subschema({
                    keyword: "contains",
                    dataProp: i,
                    dataPropType: util_1.Type.Num,
                    compositeRule: true,
                }, _valid);
                block();
            });
        }
        function checkLimits(count) {
            gen.code(codegen_1._ `${count}++`);
            if (max === undefined) {
                gen.if(codegen_1._ `${count} >= ${min}`, () => gen.assign(valid, true).break());
            }
            else {
                gen.if(codegen_1._ `${count} > ${max}`, () => gen.assign(valid, false).break());
                if (min === 1)
                    gen.assign(valid, true);
                else
                    gen.if(codegen_1._ `${count} >= ${min}`, () => gen.assign(valid, true));
            }
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10}],29:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSchemaDeps = exports.validatePropertyDeps = exports.error = void 0;
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const code_1 = require("../code");
exports.error = {
    message: ({ params: { property, depsCount, deps } }) => {
        const property_ies = depsCount === 1 ? "property" : "properties";
        return codegen_1.str `must have ${property_ies} ${deps} when property ${property} is present`;
    },
    params: ({ params: { property, depsCount, deps, missingProperty } }) => codegen_1._ `{property: ${property},
    missingProperty: ${missingProperty},
    depsCount: ${depsCount},
    deps: ${deps}}`, // TODO change to reference
};
const def = {
    keyword: "dependencies",
    type: "object",
    schemaType: "object",
    error: exports.error,
    code(cxt) {
        const [propDeps, schDeps] = splitDependencies(cxt);
        validatePropertyDeps(cxt, propDeps);
        validateSchemaDeps(cxt, schDeps);
    },
};
function splitDependencies({ schema }) {
    const propertyDeps = {};
    const schemaDeps = {};
    for (const key in schema) {
        if (key === "__proto__")
            continue;
        const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
        deps[key] = schema[key];
    }
    return [propertyDeps, schemaDeps];
}
function validatePropertyDeps(cxt, propertyDeps = cxt.schema) {
    const { gen, data, it } = cxt;
    if (Object.keys(propertyDeps).length === 0)
        return;
    const missing = gen.let("missing");
    for (const prop in propertyDeps) {
        const deps = propertyDeps[prop];
        if (deps.length === 0)
            continue;
        const hasProperty = code_1.propertyInData(gen, data, prop, it.opts.ownProperties);
        cxt.setParams({
            property: prop,
            depsCount: deps.length,
            deps: deps.join(", "),
        });
        if (it.allErrors) {
            gen.if(hasProperty, () => {
                for (const depProp of deps) {
                    code_1.checkReportMissingProp(cxt, depProp);
                }
            });
        }
        else {
            gen.if(codegen_1._ `${hasProperty} && (${code_1.checkMissingProp(cxt, deps, missing)})`);
            code_1.reportMissingProp(cxt, missing);
            gen.else();
        }
    }
}
exports.validatePropertyDeps = validatePropertyDeps;
function validateSchemaDeps(cxt, schemaDeps = cxt.schema) {
    const { gen, data, keyword, it } = cxt;
    const valid = gen.name("valid");
    for (const prop in schemaDeps) {
        if (util_1.alwaysValidSchema(it, schemaDeps[prop]))
            continue;
        gen.if(code_1.propertyInData(gen, data, prop, it.opts.ownProperties), () => {
            const schCxt = cxt.subschema({ keyword, schemaProp: prop }, valid);
            cxt.mergeValidEvaluated(schCxt, valid);
        }, () => gen.var(valid, true) // TODO var
        );
        cxt.ok(valid);
    }
}
exports.validateSchemaDeps = validateSchemaDeps;
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../code":41}],30:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: ({ params }) => codegen_1.str `must match "${params.ifClause}" schema`,
    params: ({ params }) => codegen_1._ `{failingKeyword: ${params.ifClause}}`,
};
const def = {
    keyword: "if",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, parentSchema, it } = cxt;
        if (parentSchema.then === undefined && parentSchema.else === undefined) {
            util_1.checkStrictMode(it, '"if" without "then" and "else" is ignored');
        }
        const hasThen = hasSchema(it, "then");
        const hasElse = hasSchema(it, "else");
        if (!hasThen && !hasElse)
            return;
        const valid = gen.let("valid", true);
        const schValid = gen.name("_valid");
        validateIf();
        cxt.reset();
        if (hasThen && hasElse) {
            const ifClause = gen.let("ifClause");
            cxt.setParams({ ifClause });
            gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
        }
        else if (hasThen) {
            gen.if(schValid, validateClause("then"));
        }
        else {
            gen.if(codegen_1.not(schValid), validateClause("else"));
        }
        cxt.pass(valid, () => cxt.error(true));
        function validateIf() {
            const schCxt = cxt.subschema({
                keyword: "if",
                compositeRule: true,
                createErrors: false,
                allErrors: false,
            }, schValid);
            cxt.mergeEvaluated(schCxt);
        }
        function validateClause(keyword, ifClause) {
            return () => {
                const schCxt = cxt.subschema({ keyword }, schValid);
                gen.assign(valid, schValid);
                cxt.mergeValidEvaluated(schCxt, valid);
                if (ifClause)
                    gen.assign(ifClause, codegen_1._ `${keyword}`);
                else
                    cxt.setParams({ ifClause: keyword });
            };
        }
    },
};
function hasSchema(it, keyword) {
    const schema = it.schema[keyword];
    return schema !== undefined && !util_1.alwaysValidSchema(it, schema);
}
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10}],31:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const additionalItems_1 = require("./additionalItems");
const prefixItems_1 = require("./prefixItems");
const items_1 = require("./items");
const items2020_1 = require("./items2020");
const contains_1 = require("./contains");
const dependencies_1 = require("./dependencies");
const propertyNames_1 = require("./propertyNames");
const additionalProperties_1 = require("./additionalProperties");
const properties_1 = require("./properties");
const patternProperties_1 = require("./patternProperties");
const not_1 = require("./not");
const anyOf_1 = require("./anyOf");
const oneOf_1 = require("./oneOf");
const allOf_1 = require("./allOf");
const if_1 = require("./if");
const thenElse_1 = require("./thenElse");
function getApplicator(draft2020 = false) {
    const applicator = [
        // any
        not_1.default,
        anyOf_1.default,
        oneOf_1.default,
        allOf_1.default,
        if_1.default,
        thenElse_1.default,
        // object
        propertyNames_1.default,
        additionalProperties_1.default,
        dependencies_1.default,
        properties_1.default,
        patternProperties_1.default,
    ];
    // array
    if (draft2020)
        applicator.push(prefixItems_1.default, items2020_1.default);
    else
        applicator.push(additionalItems_1.default, items_1.default);
    applicator.push(contains_1.default);
    return applicator;
}
exports.default = getApplicator;

},{"./additionalItems":24,"./additionalProperties":25,"./allOf":26,"./anyOf":27,"./contains":28,"./dependencies":29,"./if":30,"./items":32,"./items2020":33,"./not":34,"./oneOf":35,"./patternProperties":36,"./prefixItems":37,"./properties":38,"./propertyNames":39,"./thenElse":40}],32:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateTuple = void 0;
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const code_1 = require("../code");
const def = {
    keyword: "items",
    type: "array",
    schemaType: ["object", "array", "boolean"],
    before: "uniqueItems",
    code(cxt) {
        const { schema, it } = cxt;
        if (Array.isArray(schema))
            return validateTuple(cxt, "additionalItems", schema);
        it.items = true;
        if (util_1.alwaysValidSchema(it, schema))
            return;
        cxt.ok(code_1.validateArray(cxt));
    },
};
function validateTuple(cxt, extraItems, schArr = cxt.schema) {
    const { gen, parentSchema, data, keyword, it } = cxt;
    checkStrictTuple(parentSchema);
    if (it.opts.unevaluated && schArr.length && it.items !== true) {
        it.items = util_1.mergeEvaluated.items(gen, schArr.length, it.items);
    }
    const valid = gen.name("valid");
    const len = gen.const("len", codegen_1._ `${data}.length`);
    schArr.forEach((sch, i) => {
        if (util_1.alwaysValidSchema(it, sch))
            return;
        gen.if(codegen_1._ `${len} > ${i}`, () => cxt.subschema({
            keyword,
            schemaProp: i,
            dataProp: i,
        }, valid));
        cxt.ok(valid);
    });
    function checkStrictTuple(sch) {
        const { opts, errSchemaPath } = it;
        const l = schArr.length;
        const fullTuple = l === sch.minItems && (l === sch.maxItems || sch[extraItems] === false);
        if (opts.strictTuples && !fullTuple) {
            const msg = `"${keyword}" is ${l}-tuple, but minItems or maxItems/${extraItems} are not specified or different at path "${errSchemaPath}"`;
            util_1.checkStrictMode(it, msg, opts.strictTuples);
        }
    }
}
exports.validateTuple = validateTuple;
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../code":41}],33:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const code_1 = require("../code");
const additionalItems_1 = require("./additionalItems");
const error = {
    message: ({ params: { len } }) => codegen_1.str `must NOT have more than ${len} items`,
    params: ({ params: { len } }) => codegen_1._ `{limit: ${len}}`,
};
const def = {
    keyword: "items",
    type: "array",
    schemaType: ["object", "boolean"],
    before: "uniqueItems",
    error,
    code(cxt) {
        const { schema, parentSchema, it } = cxt;
        const { prefixItems } = parentSchema;
        it.items = true;
        if (util_1.alwaysValidSchema(it, schema))
            return;
        if (prefixItems)
            additionalItems_1.validateAdditionalItems(cxt, prefixItems);
        else
            cxt.ok(code_1.validateArray(cxt));
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../code":41,"./additionalItems":24}],34:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../../compile/util");
const def = {
    keyword: "not",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    code(cxt) {
        const { gen, schema, it } = cxt;
        if (util_1.alwaysValidSchema(it, schema)) {
            cxt.fail();
            return;
        }
        const valid = gen.name("valid");
        cxt.subschema({
            keyword: "not",
            compositeRule: true,
            createErrors: false,
            allErrors: false,
        }, valid);
        cxt.result(valid, () => cxt.error(), () => cxt.reset());
    },
    error: { message: "must NOT be valid" },
};
exports.default = def;

},{"../../compile/util":10}],35:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: "must match exactly one schema in oneOf",
    params: ({ params }) => codegen_1._ `{passingSchemas: ${params.passing}}`,
};
const def = {
    keyword: "oneOf",
    schemaType: "array",
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, it } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        if (it.opts.discriminator && parentSchema.discriminator)
            return;
        const schArr = schema;
        const valid = gen.let("valid", false);
        const passing = gen.let("passing", null);
        const schValid = gen.name("_valid");
        cxt.setParams({ passing });
        // TODO possibly fail straight away (with warning or exception) if there are two empty always valid schemas
        gen.block(validateOneOf);
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
        function validateOneOf() {
            schArr.forEach((sch, i) => {
                let schCxt;
                if (util_1.alwaysValidSchema(it, sch)) {
                    gen.var(schValid, true);
                }
                else {
                    schCxt = cxt.subschema({
                        keyword: "oneOf",
                        schemaProp: i,
                        compositeRule: true,
                    }, schValid);
                }
                if (i > 0) {
                    gen
                        .if(codegen_1._ `${schValid} && ${valid}`)
                        .assign(valid, false)
                        .assign(passing, codegen_1._ `[${passing}, ${i}]`)
                        .else();
                }
                gen.if(schValid, () => {
                    gen.assign(valid, true);
                    gen.assign(passing, i);
                    if (schCxt)
                        cxt.mergeEvaluated(schCxt, codegen_1.Name);
                });
            });
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10}],36:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const util_2 = require("../../compile/util");
const def = {
    keyword: "patternProperties",
    type: "object",
    schemaType: "object",
    code(cxt) {
        const { gen, schema, data, parentSchema, it } = cxt;
        const { opts } = it;
        const patterns = code_1.schemaProperties(it, schema);
        // TODO mark properties matching patterns with always valid schemas as evaluated
        if (patterns.length === 0)
            return;
        const checkProperties = opts.strictSchema && !opts.allowMatchingProperties && parentSchema.properties;
        const valid = gen.name("valid");
        if (it.props !== true && !(it.props instanceof codegen_1.Name)) {
            it.props = util_2.evaluatedPropsToName(gen, it.props);
        }
        const { props } = it;
        validatePatternProperties();
        function validatePatternProperties() {
            for (const pat of patterns) {
                if (checkProperties)
                    checkMatchingProperties(pat);
                if (it.allErrors) {
                    validateProperties(pat);
                }
                else {
                    gen.var(valid, true); // TODO var
                    validateProperties(pat);
                    gen.if(valid);
                }
            }
        }
        function checkMatchingProperties(pat) {
            for (const prop in checkProperties) {
                if (new RegExp(pat).test(prop)) {
                    util_1.checkStrictMode(it, `property ${prop} matches pattern ${pat} (use allowMatchingProperties)`);
                }
            }
        }
        function validateProperties(pat) {
            gen.forIn("key", data, (key) => {
                gen.if(codegen_1._ `${code_1.usePattern(cxt, pat)}.test(${key})`, () => {
                    cxt.subschema({
                        keyword: "patternProperties",
                        schemaProp: pat,
                        dataProp: key,
                        dataPropType: util_2.Type.Str,
                    }, valid);
                    if (it.opts.unevaluated && props !== true) {
                        gen.assign(codegen_1._ `${props}[${key}]`, true);
                    }
                    else if (!it.allErrors) {
                        // can short-circuit if `unevaluatedProperties` is not supported (opts.next === false)
                        // or if all properties were evaluated (props === true)
                        gen.if(codegen_1.not(valid), () => gen.break());
                    }
                });
            });
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../code":41}],37:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const items_1 = require("./items");
const def = {
    keyword: "prefixItems",
    type: "array",
    schemaType: ["array"],
    before: "uniqueItems",
    code: (cxt) => items_1.validateTuple(cxt, "items"),
};
exports.default = def;

},{"./items":32}],38:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const validate_1 = require("../../compile/validate");
const code_1 = require("../code");
const util_1 = require("../../compile/util");
const additionalProperties_1 = require("./additionalProperties");
const def = {
    keyword: "properties",
    type: "object",
    schemaType: "object",
    code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        if (it.opts.removeAdditional === "all" && parentSchema.additionalProperties === undefined) {
            additionalProperties_1.default.code(new validate_1.KeywordCxt(it, additionalProperties_1.default, "additionalProperties"));
        }
        const allProps = code_1.allSchemaProperties(schema);
        for (const prop of allProps) {
            it.definedProperties.add(prop);
        }
        if (it.opts.unevaluated && allProps.length && it.props !== true) {
            it.props = util_1.mergeEvaluated.props(gen, util_1.toHash(allProps), it.props);
        }
        const properties = allProps.filter((p) => !util_1.alwaysValidSchema(it, schema[p]));
        if (properties.length === 0)
            return;
        const valid = gen.name("valid");
        for (const prop of properties) {
            if (hasDefault(prop)) {
                applyPropertySchema(prop);
            }
            else {
                gen.if(code_1.propertyInData(gen, data, prop, it.opts.ownProperties));
                applyPropertySchema(prop);
                if (!it.allErrors)
                    gen.else().var(valid, true);
                gen.endIf();
            }
            cxt.it.definedProperties.add(prop);
            cxt.ok(valid);
        }
        function hasDefault(prop) {
            return it.opts.useDefaults && !it.compositeRule && schema[prop].default !== undefined;
        }
        function applyPropertySchema(prop) {
            cxt.subschema({
                keyword: "properties",
                schemaProp: prop,
                dataProp: prop,
            }, valid);
        }
    },
};
exports.default = def;

},{"../../compile/util":10,"../../compile/validate":15,"../code":41,"./additionalProperties":25}],39:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: "property name must be valid",
    params: ({ params }) => codegen_1._ `{propertyName: ${params.propertyName}}`,
};
const def = {
    keyword: "propertyNames",
    type: "object",
    schemaType: ["object", "boolean"],
    error,
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        if (util_1.alwaysValidSchema(it, schema))
            return;
        const valid = gen.name("valid");
        gen.forIn("key", data, (key) => {
            cxt.setParams({ propertyName: key });
            cxt.subschema({
                keyword: "propertyNames",
                data: key,
                dataTypes: ["string"],
                propertyName: key,
                compositeRule: true,
            }, valid);
            gen.if(codegen_1.not(valid), () => {
                cxt.error(true);
                if (!it.allErrors)
                    gen.break();
            });
        });
        cxt.ok(valid);
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10}],40:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../../compile/util");
const def = {
    keyword: ["then", "else"],
    schemaType: ["object", "boolean"],
    code({ keyword, parentSchema, it }) {
        if (parentSchema.if === undefined)
            util_1.checkStrictMode(it, `"${keyword}" without "if" is ignored`);
    },
};
exports.default = def;

},{"../../compile/util":10}],41:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateUnion = exports.validateArray = exports.usePattern = exports.callValidateCode = exports.schemaProperties = exports.allSchemaProperties = exports.noPropertyInData = exports.propertyInData = exports.isOwnProperty = exports.hasPropFunc = exports.reportMissingProp = exports.checkMissingProp = exports.checkReportMissingProp = void 0;
const codegen_1 = require("../compile/codegen");
const util_1 = require("../compile/util");
const names_1 = require("../compile/names");
function checkReportMissingProp(cxt, prop) {
    const { gen, data, it } = cxt;
    gen.if(noPropertyInData(gen, data, prop, it.opts.ownProperties), () => {
        cxt.setParams({ missingProperty: codegen_1._ `${prop}` }, true);
        cxt.error();
    });
}
exports.checkReportMissingProp = checkReportMissingProp;
function checkMissingProp({ gen, data, it: { opts } }, properties, missing) {
    return codegen_1.or(...properties.map((prop) => codegen_1.and(noPropertyInData(gen, data, prop, opts.ownProperties), codegen_1._ `${missing} = ${prop}`)));
}
exports.checkMissingProp = checkMissingProp;
function reportMissingProp(cxt, missing) {
    cxt.setParams({ missingProperty: missing }, true);
    cxt.error();
}
exports.reportMissingProp = reportMissingProp;
function hasPropFunc(gen) {
    return gen.scopeValue("func", {
        // eslint-disable-next-line @typescript-eslint/unbound-method
        ref: Object.prototype.hasOwnProperty,
        code: codegen_1._ `Object.prototype.hasOwnProperty`,
    });
}
exports.hasPropFunc = hasPropFunc;
function isOwnProperty(gen, data, property) {
    return codegen_1._ `${hasPropFunc(gen)}.call(${data}, ${property})`;
}
exports.isOwnProperty = isOwnProperty;
function propertyInData(gen, data, property, ownProperties) {
    const cond = codegen_1._ `${data}${codegen_1.getProperty(property)} !== undefined`;
    return ownProperties ? codegen_1._ `${cond} && ${isOwnProperty(gen, data, property)}` : cond;
}
exports.propertyInData = propertyInData;
function noPropertyInData(gen, data, property, ownProperties) {
    const cond = codegen_1._ `${data}${codegen_1.getProperty(property)} === undefined`;
    return ownProperties ? codegen_1.or(cond, codegen_1.not(isOwnProperty(gen, data, property))) : cond;
}
exports.noPropertyInData = noPropertyInData;
function allSchemaProperties(schemaMap) {
    return schemaMap ? Object.keys(schemaMap).filter((p) => p !== "__proto__") : [];
}
exports.allSchemaProperties = allSchemaProperties;
function schemaProperties(it, schemaMap) {
    return allSchemaProperties(schemaMap).filter((p) => !util_1.alwaysValidSchema(it, schemaMap[p]));
}
exports.schemaProperties = schemaProperties;
function callValidateCode({ schemaCode, data, it: { gen, topSchemaRef, schemaPath, errorPath }, it }, func, context, passSchema) {
    const dataAndSchema = passSchema ? codegen_1._ `${schemaCode}, ${data}, ${topSchemaRef}${schemaPath}` : data;
    const valCxt = [
        [names_1.default.instancePath, codegen_1.strConcat(names_1.default.instancePath, errorPath)],
        [names_1.default.parentData, it.parentData],
        [names_1.default.parentDataProperty, it.parentDataProperty],
        [names_1.default.rootData, names_1.default.rootData],
    ];
    if (it.opts.dynamicRef)
        valCxt.push([names_1.default.dynamicAnchors, names_1.default.dynamicAnchors]);
    const args = codegen_1._ `${dataAndSchema}, ${gen.object(...valCxt)}`;
    return context !== codegen_1.nil ? codegen_1._ `${func}.call(${context}, ${args})` : codegen_1._ `${func}(${args})`;
}
exports.callValidateCode = callValidateCode;
function usePattern({ gen, it: { opts } }, pattern) {
    const u = opts.unicodeRegExp ? "u" : "";
    return gen.scopeValue("pattern", {
        key: pattern,
        ref: new RegExp(pattern, u),
        code: codegen_1._ `new RegExp(${pattern}, ${u})`,
    });
}
exports.usePattern = usePattern;
function validateArray(cxt) {
    const { gen, data, keyword, it } = cxt;
    const valid = gen.name("valid");
    if (it.allErrors) {
        const validArr = gen.let("valid", true);
        validateItems(() => gen.assign(validArr, false));
        return validArr;
    }
    gen.var(valid, true);
    validateItems(() => gen.break());
    return valid;
    function validateItems(notValid) {
        const len = gen.const("len", codegen_1._ `${data}.length`);
        gen.forRange("i", 0, len, (i) => {
            cxt.subschema({
                keyword,
                dataProp: i,
                dataPropType: util_1.Type.Num,
            }, valid);
            gen.if(codegen_1.not(valid), notValid);
        });
    }
}
exports.validateArray = validateArray;
function validateUnion(cxt) {
    const { gen, schema, keyword, it } = cxt;
    /* istanbul ignore if */
    if (!Array.isArray(schema))
        throw new Error("ajv implementation error");
    const alwaysValid = schema.some((sch) => util_1.alwaysValidSchema(it, sch));
    if (alwaysValid && !it.opts.unevaluated)
        return;
    const valid = gen.let("valid", false);
    const schValid = gen.name("_valid");
    gen.block(() => schema.forEach((_sch, i) => {
        const schCxt = cxt.subschema({
            keyword,
            schemaProp: i,
            compositeRule: true,
        }, schValid);
        gen.assign(valid, codegen_1._ `${valid} || ${schValid}`);
        const merged = cxt.mergeValidEvaluated(schCxt, schValid);
        // can short-circuit if `unevaluatedProperties/Items` not supported (opts.unevaluated !== true)
        // or if all properties and items were evaluated (it.props === true && it.items === true)
        if (!merged)
            gen.if(codegen_1.not(valid));
    }));
    cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
}
exports.validateUnion = validateUnion;

},{"../compile/codegen":2,"../compile/names":6,"../compile/util":10}],42:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const def = {
    keyword: "id",
    code() {
        throw new Error('NOT SUPPORTED: keyword "id", use "$id" for schema ID');
    },
};
exports.default = def;

},{}],43:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const id_1 = require("./id");
const ref_1 = require("./ref");
const core = [
    "$schema",
    "$id",
    "$defs",
    "$vocabulary",
    { keyword: "$comment" },
    "definitions",
    id_1.default,
    ref_1.default,
];
exports.default = core;

},{"./id":42,"./ref":44}],44:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.callRef = exports.getValidate = void 0;
const ref_error_1 = require("../../compile/ref_error");
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const names_1 = require("../../compile/names");
const compile_1 = require("../../compile");
const util_1 = require("../../compile/util");
const def = {
    keyword: "$ref",
    schemaType: "string",
    code(cxt) {
        const { gen, schema: $ref, it } = cxt;
        const { baseId, schemaEnv: env, validateName, opts, self } = it;
        const { root } = env;
        if (($ref === "#" || $ref === "#/") && baseId === root.baseId)
            return callRootRef();
        const schOrEnv = compile_1.resolveRef.call(self, root, baseId, $ref);
        if (schOrEnv === undefined)
            throw new ref_error_1.default(baseId, $ref);
        if (schOrEnv instanceof compile_1.SchemaEnv)
            return callValidate(schOrEnv);
        return inlineRefSchema(schOrEnv);
        function callRootRef() {
            if (env === root)
                return callRef(cxt, validateName, env, env.$async);
            const rootName = gen.scopeValue("root", { ref: root });
            return callRef(cxt, codegen_1._ `${rootName}.validate`, root, root.$async);
        }
        function callValidate(sch) {
            const v = getValidate(cxt, sch);
            callRef(cxt, v, sch, sch.$async);
        }
        function inlineRefSchema(sch) {
            const schName = gen.scopeValue("schema", opts.code.source === true ? { ref: sch, code: codegen_1.stringify(sch) } : { ref: sch });
            const valid = gen.name("valid");
            const schCxt = cxt.subschema({
                schema: sch,
                dataTypes: [],
                schemaPath: codegen_1.nil,
                topSchemaRef: schName,
                errSchemaPath: $ref,
            }, valid);
            cxt.mergeEvaluated(schCxt);
            cxt.ok(valid);
        }
    },
};
function getValidate(cxt, sch) {
    const { gen } = cxt;
    return sch.validate
        ? gen.scopeValue("validate", { ref: sch.validate })
        : codegen_1._ `${gen.scopeValue("wrapper", { ref: sch })}.validate`;
}
exports.getValidate = getValidate;
function callRef(cxt, v, sch, $async) {
    const { gen, it } = cxt;
    const { allErrors, schemaEnv: env, opts } = it;
    const passCxt = opts.passContext ? names_1.default.this : codegen_1.nil;
    if ($async)
        callAsyncRef();
    else
        callSyncRef();
    function callAsyncRef() {
        if (!env.$async)
            throw new Error("async schema referenced by sync schema");
        const valid = gen.let("valid");
        gen.try(() => {
            gen.code(codegen_1._ `await ${code_1.callValidateCode(cxt, v, passCxt)}`);
            addEvaluatedFrom(v); // TODO will not work with async, it has to be returned with the result
            if (!allErrors)
                gen.assign(valid, true);
        }, (e) => {
            gen.if(codegen_1._ `!(${e} instanceof ${it.ValidationError})`, () => gen.throw(e));
            addErrorsFrom(e);
            if (!allErrors)
                gen.assign(valid, false);
        });
        cxt.ok(valid);
    }
    function callSyncRef() {
        cxt.result(code_1.callValidateCode(cxt, v, passCxt), () => addEvaluatedFrom(v), () => addErrorsFrom(v));
    }
    function addErrorsFrom(source) {
        const errs = codegen_1._ `${source}.errors`;
        gen.assign(names_1.default.vErrors, codegen_1._ `${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`); // TODO tagged
        gen.assign(names_1.default.errors, codegen_1._ `${names_1.default.vErrors}.length`);
    }
    function addEvaluatedFrom(source) {
        var _a;
        if (!it.opts.unevaluated)
            return;
        const schEvaluated = (_a = sch === null || sch === void 0 ? void 0 : sch.validate) === null || _a === void 0 ? void 0 : _a.evaluated;
        // TODO refactor
        if (it.props !== true) {
            if (schEvaluated && !schEvaluated.dynamicProps) {
                if (schEvaluated.props !== undefined) {
                    it.props = util_1.mergeEvaluated.props(gen, schEvaluated.props, it.props);
                }
            }
            else {
                const props = gen.var("props", codegen_1._ `${source}.evaluated.props`);
                it.props = util_1.mergeEvaluated.props(gen, props, it.props, codegen_1.Name);
            }
        }
        if (it.items !== true) {
            if (schEvaluated && !schEvaluated.dynamicItems) {
                if (schEvaluated.items !== undefined) {
                    it.items = util_1.mergeEvaluated.items(gen, schEvaluated.items, it.items);
                }
            }
            else {
                const items = gen.var("items", codegen_1._ `${source}.evaluated.items`);
                it.items = util_1.mergeEvaluated.items(gen, items, it.items, codegen_1.Name);
            }
        }
    }
}
exports.callRef = callRef;
exports.default = def;

},{"../../compile":5,"../../compile/codegen":2,"../../compile/names":6,"../../compile/ref_error":7,"../../compile/util":10,"../code":41}],45:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const types_1 = require("../discriminator/types");
const error = {
    message: ({ params: { discrError, tagName } }) => discrError === types_1.DiscrError.Tag
        ? `tag "${tagName}" must be string`
        : `value of tag "${tagName}" must be in oneOf`,
    params: ({ params: { discrError, tag, tagName } }) => codegen_1._ `{error: ${discrError}, tag: ${tagName}, tagValue: ${tag}}`,
};
const def = {
    keyword: "discriminator",
    type: "object",
    schemaType: "object",
    error,
    code(cxt) {
        const { gen, data, schema, parentSchema, it } = cxt;
        const { oneOf } = parentSchema;
        if (!it.opts.discriminator) {
            throw new Error("discriminator: requires discriminator option");
        }
        const tagName = schema.propertyName;
        if (typeof tagName != "string")
            throw new Error("discriminator: requires propertyName");
        if (schema.mapping)
            throw new Error("discriminator: mapping is not supported");
        if (!oneOf)
            throw new Error("discriminator: requires oneOf keyword");
        const valid = gen.let("valid", false);
        const tag = gen.const("tag", codegen_1._ `${data}${codegen_1.getProperty(tagName)}`);
        gen.if(codegen_1._ `typeof ${tag} == "string"`, () => validateMapping(), () => cxt.error(false, { discrError: types_1.DiscrError.Tag, tag, tagName }));
        cxt.ok(valid);
        function validateMapping() {
            const mapping = getMapping();
            gen.if(false);
            for (const tagValue in mapping) {
                gen.elseIf(codegen_1._ `${tag} === ${tagValue}`);
                gen.assign(valid, applyTagSchema(mapping[tagValue]));
            }
            gen.else();
            cxt.error(false, { discrError: types_1.DiscrError.Mapping, tag, tagName });
            gen.endIf();
        }
        function applyTagSchema(schemaProp) {
            const _valid = gen.name("valid");
            const schCxt = cxt.subschema({ keyword: "oneOf", schemaProp }, _valid);
            cxt.mergeEvaluated(schCxt, codegen_1.Name);
            return _valid;
        }
        function getMapping() {
            var _a;
            const oneOfMapping = {};
            const topRequired = hasRequired(parentSchema);
            let tagRequired = true;
            for (let i = 0; i < oneOf.length; i++) {
                const sch = oneOf[i];
                const propSch = (_a = sch.properties) === null || _a === void 0 ? void 0 : _a[tagName];
                if (typeof propSch != "object") {
                    throw new Error(`discriminator: oneOf schemas must have "properties/${tagName}"`);
                }
                tagRequired = tagRequired && (topRequired || hasRequired(sch));
                addMappings(propSch, i);
            }
            if (!tagRequired)
                throw new Error(`discriminator: "${tagName}" must be required`);
            return oneOfMapping;
            function hasRequired({ required }) {
                return Array.isArray(required) && required.includes(tagName);
            }
            function addMappings(sch, i) {
                if (sch.const) {
                    addMapping(sch.const, i);
                }
                else if (sch.enum) {
                    for (const tagValue of sch.enum) {
                        addMapping(tagValue, i);
                    }
                }
                else {
                    throw new Error(`discriminator: "properties/${tagName}" must have "const" or "enum"`);
                }
            }
            function addMapping(tagValue, i) {
                if (typeof tagValue != "string" || tagValue in oneOfMapping) {
                    throw new Error(`discriminator: "${tagName}" values must be unique strings`);
                }
                oneOfMapping[tagValue] = i;
            }
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../discriminator/types":46}],46:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiscrError = void 0;
var DiscrError;
(function (DiscrError) {
    DiscrError["Tag"] = "tag";
    DiscrError["Mapping"] = "mapping";
})(DiscrError = exports.DiscrError || (exports.DiscrError = {}));

},{}],47:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("./core");
const validation_1 = require("./validation");
const applicator_1 = require("./applicator");
const format_1 = require("./format");
const metadata_1 = require("./metadata");
const draft7Vocabularies = [
    core_1.default,
    validation_1.default,
    applicator_1.default(),
    format_1.default,
    metadata_1.metadataVocabulary,
    metadata_1.contentVocabulary,
];
exports.default = draft7Vocabularies;

},{"./applicator":31,"./core":43,"./format":49,"./metadata":50,"./validation":53}],48:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const error = {
    message: ({ schemaCode }) => codegen_1.str `must match format "${schemaCode}"`,
    params: ({ schemaCode }) => codegen_1._ `{format: ${schemaCode}}`,
};
const def = {
    keyword: "format",
    type: ["number", "string"],
    schemaType: "string",
    $data: true,
    error,
    code(cxt, ruleType) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        const { opts, errSchemaPath, schemaEnv, self } = it;
        if (!opts.validateFormats)
            return;
        if ($data)
            validate$DataFormat();
        else
            validateFormat();
        function validate$DataFormat() {
            const fmts = gen.scopeValue("formats", {
                ref: self.formats,
                code: opts.code.formats,
            });
            const fDef = gen.const("fDef", codegen_1._ `${fmts}[${schemaCode}]`);
            const fType = gen.let("fType");
            const format = gen.let("format");
            // TODO simplify
            gen.if(codegen_1._ `typeof ${fDef} == "object" && !(${fDef} instanceof RegExp)`, () => gen.assign(fType, codegen_1._ `${fDef}.type || "string"`).assign(format, codegen_1._ `${fDef}.validate`), () => gen.assign(fType, codegen_1._ `"string"`).assign(format, fDef));
            cxt.fail$data(codegen_1.or(unknownFmt(), invalidFmt()));
            function unknownFmt() {
                if (opts.strictSchema === false)
                    return codegen_1.nil;
                return codegen_1._ `${schemaCode} && !${format}`;
            }
            function invalidFmt() {
                const callFormat = schemaEnv.$async
                    ? codegen_1._ `(${fDef}.async ? await ${format}(${data}) : ${format}(${data}))`
                    : codegen_1._ `${format}(${data})`;
                const validData = codegen_1._ `(typeof ${format} == "function" ? ${callFormat} : ${format}.test(${data}))`;
                return codegen_1._ `${format} && ${format} !== true && ${fType} === ${ruleType} && !${validData}`;
            }
        }
        function validateFormat() {
            const formatDef = self.formats[schema];
            if (!formatDef) {
                unknownFormat();
                return;
            }
            if (formatDef === true)
                return;
            const [fmtType, format, fmtRef] = getFormat(formatDef);
            if (fmtType === ruleType)
                cxt.pass(validCondition());
            function unknownFormat() {
                if (opts.strictSchema === false) {
                    self.logger.warn(unknownMsg());
                    return;
                }
                throw new Error(unknownMsg());
                function unknownMsg() {
                    return `unknown format "${schema}" ignored in schema at path "${errSchemaPath}"`;
                }
            }
            function getFormat(fmtDef) {
                const code = fmtDef instanceof RegExp
                    ? codegen_1.regexpCode(fmtDef)
                    : opts.code.formats
                        ? codegen_1._ `${opts.code.formats}${codegen_1.getProperty(schema)}`
                        : undefined;
                const fmt = gen.scopeValue("formats", { key: schema, ref: fmtDef, code });
                if (typeof fmtDef == "object" && !(fmtDef instanceof RegExp)) {
                    return [fmtDef.type || "string", fmtDef.validate, codegen_1._ `${fmt}.validate`];
                }
                return ["string", fmtDef, fmt];
            }
            function validCondition() {
                if (typeof formatDef == "object" && !(formatDef instanceof RegExp) && formatDef.async) {
                    if (!schemaEnv.$async)
                        throw new Error("async format in sync schema");
                    return codegen_1._ `await ${fmtRef}(${data})`;
                }
                return typeof format == "function" ? codegen_1._ `${fmtRef}(${data})` : codegen_1._ `${fmtRef}.test(${data})`;
            }
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2}],49:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const format_1 = require("./format");
const format = [format_1.default];
exports.default = format;

},{"./format":48}],50:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.contentVocabulary = exports.metadataVocabulary = void 0;
exports.metadataVocabulary = [
    "title",
    "description",
    "default",
    "deprecated",
    "readOnly",
    "writeOnly",
    "examples",
];
exports.contentVocabulary = [
    "contentMediaType",
    "contentEncoding",
    "contentSchema",
];

},{}],51:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const equal_1 = require("../../runtime/equal");
const error = {
    message: "must be equal to constant",
    params: ({ schemaCode }) => codegen_1._ `{allowedValue: ${schemaCode}}`,
};
const def = {
    keyword: "const",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, schemaCode } = cxt;
        // TODO optimize for scalar values in schema
        cxt.fail$data(codegen_1._ `!${util_1.useFunc(gen, equal_1.default)}(${data}, ${schemaCode})`);
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../../runtime/equal":21}],52:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const equal_1 = require("../../runtime/equal");
const error = {
    message: "must be equal to one of the allowed values",
    params: ({ schemaCode }) => codegen_1._ `{allowedValues: ${schemaCode}}`,
};
const def = {
    keyword: "enum",
    schemaType: "array",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        if (!$data && schema.length === 0)
            throw new Error("enum must have non-empty array");
        const useLoop = schema.length >= it.opts.loopEnum;
        const eql = util_1.useFunc(gen, equal_1.default);
        let valid;
        if (useLoop || $data) {
            valid = gen.let("valid");
            cxt.block$data(valid, loopEnum);
        }
        else {
            /* istanbul ignore if */
            if (!Array.isArray(schema))
                throw new Error("ajv implementation error");
            const vSchema = gen.const("vSchema", schemaCode);
            valid = codegen_1.or(...schema.map((_x, i) => equalCode(vSchema, i)));
        }
        cxt.pass(valid);
        function loopEnum() {
            gen.assign(valid, false);
            gen.forOf("v", schemaCode, (v) => gen.if(codegen_1._ `${eql}(${data}, ${v})`, () => gen.assign(valid, true).break()));
        }
        function equalCode(vSchema, i) {
            const sch = schema[i];
            return sch && typeof sch === "object"
                ? codegen_1._ `${eql}(${data}, ${vSchema}[${i}])`
                : codegen_1._ `${data} === ${sch}`;
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../../runtime/equal":21}],53:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const limitNumber_1 = require("./limitNumber");
const multipleOf_1 = require("./multipleOf");
const limitLength_1 = require("./limitLength");
const pattern_1 = require("./pattern");
const limitProperties_1 = require("./limitProperties");
const required_1 = require("./required");
const limitItems_1 = require("./limitItems");
const uniqueItems_1 = require("./uniqueItems");
const const_1 = require("./const");
const enum_1 = require("./enum");
const validation = [
    // number
    limitNumber_1.default,
    multipleOf_1.default,
    // string
    limitLength_1.default,
    pattern_1.default,
    // object
    limitProperties_1.default,
    required_1.default,
    // array
    limitItems_1.default,
    uniqueItems_1.default,
    // any
    { keyword: "type", schemaType: ["string", "array"] },
    { keyword: "nullable", schemaType: "boolean" },
    const_1.default,
    enum_1.default,
];
exports.default = validation;

},{"./const":51,"./enum":52,"./limitItems":54,"./limitLength":55,"./limitNumber":56,"./limitProperties":57,"./multipleOf":58,"./pattern":59,"./required":60,"./uniqueItems":61}],54:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxItems" ? "more" : "fewer";
        return codegen_1.str `must NOT have ${comp} than ${schemaCode} items`;
    },
    params: ({ schemaCode }) => codegen_1._ `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxItems", "minItems"],
    type: "array",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxItems" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data(codegen_1._ `${data}.length ${op} ${schemaCode}`);
    },
};
exports.default = def;

},{"../../compile/codegen":2}],55:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const ucs2length_1 = require("../../runtime/ucs2length");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxLength" ? "more" : "fewer";
        return codegen_1.str `must NOT have ${comp} than ${schemaCode} characters`;
    },
    params: ({ schemaCode }) => codegen_1._ `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxLength", "minLength"],
    type: "string",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode, it } = cxt;
        const op = keyword === "maxLength" ? codegen_1.operators.GT : codegen_1.operators.LT;
        const len = it.opts.unicode === false ? codegen_1._ `${data}.length` : codegen_1._ `${util_1.useFunc(cxt.gen, ucs2length_1.default)}(${data})`;
        cxt.fail$data(codegen_1._ `${len} ${op} ${schemaCode}`);
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../../runtime/ucs2length":22}],56:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const ops = codegen_1.operators;
const KWDs = {
    maximum: { okStr: "<=", ok: ops.LTE, fail: ops.GT },
    minimum: { okStr: ">=", ok: ops.GTE, fail: ops.LT },
    exclusiveMaximum: { okStr: "<", ok: ops.LT, fail: ops.GTE },
    exclusiveMinimum: { okStr: ">", ok: ops.GT, fail: ops.LTE },
};
const error = {
    message: ({ keyword, schemaCode }) => codegen_1.str `must be ${KWDs[keyword].okStr} ${schemaCode}`,
    params: ({ keyword, schemaCode }) => codegen_1._ `{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`,
};
const def = {
    keyword: Object.keys(KWDs),
    type: "number",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        cxt.fail$data(codegen_1._ `${data} ${KWDs[keyword].fail} ${schemaCode} || isNaN(${data})`);
    },
};
exports.default = def;

},{"../../compile/codegen":2}],57:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxProperties" ? "more" : "fewer";
        return codegen_1.str `must NOT have ${comp} than ${schemaCode} items`;
    },
    params: ({ schemaCode }) => codegen_1._ `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxProperties", "minProperties"],
    type: "object",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxProperties" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data(codegen_1._ `Object.keys(${data}).length ${op} ${schemaCode}`);
    },
};
exports.default = def;

},{"../../compile/codegen":2}],58:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const error = {
    message: ({ schemaCode }) => codegen_1.str `must be multiple of ${schemaCode}`,
    params: ({ schemaCode }) => codegen_1._ `{multipleOf: ${schemaCode}}`,
};
const def = {
    keyword: "multipleOf",
    type: "number",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, schemaCode, it } = cxt;
        // const bdt = bad$DataType(schemaCode, <string>def.schemaType, $data)
        const prec = it.opts.multipleOfPrecision;
        const res = gen.let("res");
        const invalid = prec
            ? codegen_1._ `Math.abs(Math.round(${res}) - ${res}) > 1e-${prec}`
            : codegen_1._ `${res} !== parseInt(${res})`;
        cxt.fail$data(codegen_1._ `(${schemaCode} === 0 || (${res} = ${data}/${schemaCode}, ${invalid}))`);
    },
};
exports.default = def;

},{"../../compile/codegen":2}],59:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const error = {
    message: ({ schemaCode }) => codegen_1.str `must match pattern "${schemaCode}"`,
    params: ({ schemaCode }) => codegen_1._ `{pattern: ${schemaCode}}`,
};
const def = {
    keyword: "pattern",
    type: "string",
    schemaType: "string",
    $data: true,
    error,
    code(cxt) {
        const { data, $data, schema, schemaCode, it } = cxt;
        // TODO regexp should be wrapped in try/catchs
        const u = it.opts.unicodeRegExp ? "u" : "";
        const regExp = $data ? codegen_1._ `(new RegExp(${schemaCode}, ${u}))` : code_1.usePattern(cxt, schema);
        cxt.fail$data(codegen_1._ `!${regExp}.test(${data})`);
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../code":41}],60:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const error = {
    message: ({ params: { missingProperty } }) => codegen_1.str `must have required property '${missingProperty}'`,
    params: ({ params: { missingProperty } }) => codegen_1._ `{missingProperty: ${missingProperty}}`,
};
const def = {
    keyword: "required",
    type: "object",
    schemaType: "array",
    $data: true,
    error,
    code(cxt) {
        const { gen, schema, schemaCode, data, $data, it } = cxt;
        const { opts } = it;
        if (!$data && schema.length === 0)
            return;
        const useLoop = schema.length >= opts.loopRequired;
        if (it.allErrors)
            allErrorsMode();
        else
            exitOnErrorMode();
        if (opts.strictRequired) {
            const props = cxt.parentSchema.properties;
            const { definedProperties } = cxt.it;
            for (const requiredKey of schema) {
                if ((props === null || props === void 0 ? void 0 : props[requiredKey]) === undefined && !definedProperties.has(requiredKey)) {
                    const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
                    const msg = `required property "${requiredKey}" is not defined at "${schemaPath}" (strictRequired)`;
                    util_1.checkStrictMode(it, msg, it.opts.strictRequired);
                }
            }
        }
        function allErrorsMode() {
            if (useLoop || $data) {
                cxt.block$data(codegen_1.nil, loopAllRequired);
            }
            else {
                for (const prop of schema) {
                    code_1.checkReportMissingProp(cxt, prop);
                }
            }
        }
        function exitOnErrorMode() {
            const missing = gen.let("missing");
            if (useLoop || $data) {
                const valid = gen.let("valid", true);
                cxt.block$data(valid, () => loopUntilMissing(missing, valid));
                cxt.ok(valid);
            }
            else {
                gen.if(code_1.checkMissingProp(cxt, schema, missing));
                code_1.reportMissingProp(cxt, missing);
                gen.else();
            }
        }
        function loopAllRequired() {
            gen.forOf("prop", schemaCode, (prop) => {
                cxt.setParams({ missingProperty: prop });
                gen.if(code_1.noPropertyInData(gen, data, prop, opts.ownProperties), () => cxt.error());
            });
        }
        function loopUntilMissing(missing, valid) {
            cxt.setParams({ missingProperty: missing });
            gen.forOf(missing, schemaCode, () => {
                gen.assign(valid, code_1.propertyInData(gen, data, missing, opts.ownProperties));
                gen.if(codegen_1.not(valid), () => {
                    cxt.error();
                    gen.break();
                });
            }, codegen_1.nil);
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../code":41}],61:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dataType_1 = require("../../compile/validate/dataType");
const codegen_1 = require("../../compile/codegen");
const util_1 = require("../../compile/util");
const equal_1 = require("../../runtime/equal");
const error = {
    message: ({ params: { i, j } }) => codegen_1.str `must NOT have duplicate items (items ## ${j} and ${i} are identical)`,
    params: ({ params: { i, j } }) => codegen_1._ `{i: ${i}, j: ${j}}`,
};
const def = {
    keyword: "uniqueItems",
    type: "array",
    schemaType: "boolean",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, $data, schema, parentSchema, schemaCode, it } = cxt;
        if (!$data && !schema)
            return;
        const valid = gen.let("valid");
        const itemTypes = parentSchema.items ? dataType_1.getSchemaTypes(parentSchema.items) : [];
        cxt.block$data(valid, validateUniqueItems, codegen_1._ `${schemaCode} === false`);
        cxt.ok(valid);
        function validateUniqueItems() {
            const i = gen.let("i", codegen_1._ `${data}.length`);
            const j = gen.let("j");
            cxt.setParams({ i, j });
            gen.assign(valid, true);
            gen.if(codegen_1._ `${i} > 1`, () => (canOptimize() ? loopN : loopN2)(i, j));
        }
        function canOptimize() {
            return itemTypes.length > 0 && !itemTypes.some((t) => t === "object" || t === "array");
        }
        function loopN(i, j) {
            const item = gen.name("item");
            const wrongType = dataType_1.checkDataTypes(itemTypes, item, it.opts.strictNumbers, dataType_1.DataType.Wrong);
            const indices = gen.const("indices", codegen_1._ `{}`);
            gen.for(codegen_1._ `;${i}--;`, () => {
                gen.let(item, codegen_1._ `${data}[${i}]`);
                gen.if(wrongType, codegen_1._ `continue`);
                if (itemTypes.length > 1)
                    gen.if(codegen_1._ `typeof ${item} == "string"`, codegen_1._ `${item} += "_"`);
                gen
                    .if(codegen_1._ `typeof ${indices}[${item}] == "number"`, () => {
                    gen.assign(j, codegen_1._ `${indices}[${item}]`);
                    cxt.error();
                    gen.assign(valid, false).break();
                })
                    .code(codegen_1._ `${indices}[${item}] = ${i}`);
            });
        }
        function loopN2(i, j) {
            const eql = util_1.useFunc(gen, equal_1.default);
            const outer = gen.name("outer");
            gen.label(outer).for(codegen_1._ `;${i}--;`, () => gen.for(codegen_1._ `${j} = ${i}; ${j}--;`, () => gen.if(codegen_1._ `${eql}(${data}[${i}], ${data}[${j}])`, () => {
                cxt.error();
                gen.assign(valid, false).break(outer);
            })));
        }
    },
};
exports.default = def;

},{"../../compile/codegen":2,"../../compile/util":10,"../../compile/validate/dataType":13,"../../runtime/equal":21}],62:[function(require,module,exports){
'use strict';

// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};

},{}],63:[function(require,module,exports){
'use strict';

var traverse = module.exports = function (schema, opts, cb) {
  // Legacy support for v0.3.1 and earlier.
  if (typeof opts == 'function') {
    cb = opts;
    opts = {};
  }

  cb = opts.cb || cb;
  var pre = (typeof cb == 'function') ? cb : cb.pre || function() {};
  var post = cb.post || function() {};

  _traverse(opts, pre, post, schema, '', schema);
};


traverse.keywords = {
  additionalItems: true,
  items: true,
  contains: true,
  additionalProperties: true,
  propertyNames: true,
  not: true,
  if: true,
  then: true,
  else: true
};

traverse.arrayKeywords = {
  items: true,
  allOf: true,
  anyOf: true,
  oneOf: true
};

traverse.propsKeywords = {
  $defs: true,
  definitions: true,
  properties: true,
  patternProperties: true,
  dependencies: true
};

traverse.skipKeywords = {
  default: true,
  enum: true,
  const: true,
  required: true,
  maximum: true,
  minimum: true,
  exclusiveMaximum: true,
  exclusiveMinimum: true,
  multipleOf: true,
  maxLength: true,
  minLength: true,
  pattern: true,
  format: true,
  maxItems: true,
  minItems: true,
  uniqueItems: true,
  maxProperties: true,
  minProperties: true
};


function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
  if (schema && typeof schema == 'object' && !Array.isArray(schema)) {
    pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
    for (var key in schema) {
      var sch = schema[key];
      if (Array.isArray(sch)) {
        if (key in traverse.arrayKeywords) {
          for (var i=0; i<sch.length; i++)
            _traverse(opts, pre, post, sch[i], jsonPtr + '/' + key + '/' + i, rootSchema, jsonPtr, key, schema, i);
        }
      } else if (key in traverse.propsKeywords) {
        if (sch && typeof sch == 'object') {
          for (var prop in sch)
            _traverse(opts, pre, post, sch[prop], jsonPtr + '/' + key + '/' + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
        }
      } else if (key in traverse.keywords || (opts.allKeys && !(key in traverse.skipKeywords))) {
        _traverse(opts, pre, post, sch, jsonPtr + '/' + key, rootSchema, jsonPtr, key, schema);
      }
    }
    post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
  }
}


function escapeJsonPtr(str) {
  return str.replace(/~/g, '~0').replace(/\//g, '~1');
}

},{}],64:[function(require,module,exports){
/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.URI = global.URI || {})));
}(this, (function (exports) { 'use strict';

function merge() {
    for (var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++) {
        sets[_key] = arguments[_key];
    }

    if (sets.length > 1) {
        sets[0] = sets[0].slice(0, -1);
        var xl = sets.length - 1;
        for (var x = 1; x < xl; ++x) {
            sets[x] = sets[x].slice(1, -1);
        }
        sets[xl] = sets[xl].slice(1);
        return sets.join('');
    } else {
        return sets[0];
    }
}
function subexp(str) {
    return "(?:" + str + ")";
}
function typeOf(o) {
    return o === undefined ? "undefined" : o === null ? "null" : Object.prototype.toString.call(o).split(" ").pop().split("]").shift().toLowerCase();
}
function toUpperCase(str) {
    return str.toUpperCase();
}
function toArray(obj) {
    return obj !== undefined && obj !== null ? obj instanceof Array ? obj : typeof obj.length !== "number" || obj.split || obj.setInterval || obj.call ? [obj] : Array.prototype.slice.call(obj) : [];
}
function assign(target, source) {
    var obj = target;
    if (source) {
        for (var key in source) {
            obj[key] = source[key];
        }
    }
    return obj;
}

function buildExps(isIRI) {
    var ALPHA$$ = "[A-Za-z]",
        CR$ = "[\\x0D]",
        DIGIT$$ = "[0-9]",
        DQUOTE$$ = "[\\x22]",
        HEXDIG$$ = merge(DIGIT$$, "[A-Fa-f]"),
        //case-insensitive
    LF$$ = "[\\x0A]",
        SP$$ = "[\\x20]",
        PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$)),
        //expanded
    GEN_DELIMS$$ = "[\\:\\/\\?\\#\\[\\]\\@]",
        SUB_DELIMS$$ = "[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",
        RESERVED$$ = merge(GEN_DELIMS$$, SUB_DELIMS$$),
        UCSCHAR$$ = isIRI ? "[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]" : "[]",
        //subset, excludes bidi control characters
    IPRIVATE$$ = isIRI ? "[\\uE000-\\uF8FF]" : "[]",
        //subset
    UNRESERVED$$ = merge(ALPHA$$, DIGIT$$, "[\\-\\.\\_\\~]", UCSCHAR$$),
        SCHEME$ = subexp(ALPHA$$ + merge(ALPHA$$, DIGIT$$, "[\\+\\-\\.]") + "*"),
        USERINFO$ = subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:]")) + "*"),
        DEC_OCTET$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("[1-9]" + DIGIT$$) + "|" + DIGIT$$),
        DEC_OCTET_RELAXED$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("0?[1-9]" + DIGIT$$) + "|0?0?" + DIGIT$$),
        //relaxed parsing rules
    IPV4ADDRESS$ = subexp(DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$),
        H16$ = subexp(HEXDIG$$ + "{1,4}"),
        LS32$ = subexp(subexp(H16$ + "\\:" + H16$) + "|" + IPV4ADDRESS$),
        IPV6ADDRESS1$ = subexp(subexp(H16$ + "\\:") + "{6}" + LS32$),
        //                           6( h16 ":" ) ls32
    IPV6ADDRESS2$ = subexp("\\:\\:" + subexp(H16$ + "\\:") + "{5}" + LS32$),
        //                      "::" 5( h16 ":" ) ls32
    IPV6ADDRESS3$ = subexp(subexp(H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{4}" + LS32$),
        //[               h16 ] "::" 4( h16 ":" ) ls32
    IPV6ADDRESS4$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,1}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{3}" + LS32$),
        //[ *1( h16 ":" ) h16 ] "::" 3( h16 ":" ) ls32
    IPV6ADDRESS5$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,2}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{2}" + LS32$),
        //[ *2( h16 ":" ) h16 ] "::" 2( h16 ":" ) ls32
    IPV6ADDRESS6$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,3}" + H16$) + "?\\:\\:" + H16$ + "\\:" + LS32$),
        //[ *3( h16 ":" ) h16 ] "::"    h16 ":"   ls32
    IPV6ADDRESS7$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,4}" + H16$) + "?\\:\\:" + LS32$),
        //[ *4( h16 ":" ) h16 ] "::"              ls32
    IPV6ADDRESS8$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,5}" + H16$) + "?\\:\\:" + H16$),
        //[ *5( h16 ":" ) h16 ] "::"              h16
    IPV6ADDRESS9$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,6}" + H16$) + "?\\:\\:"),
        //[ *6( h16 ":" ) h16 ] "::"
    IPV6ADDRESS$ = subexp([IPV6ADDRESS1$, IPV6ADDRESS2$, IPV6ADDRESS3$, IPV6ADDRESS4$, IPV6ADDRESS5$, IPV6ADDRESS6$, IPV6ADDRESS7$, IPV6ADDRESS8$, IPV6ADDRESS9$].join("|")),
        ZONEID$ = subexp(subexp(UNRESERVED$$ + "|" + PCT_ENCODED$) + "+"),
        //RFC 6874
    IPV6ADDRZ$ = subexp(IPV6ADDRESS$ + "\\%25" + ZONEID$),
        //RFC 6874
    IPV6ADDRZ_RELAXED$ = subexp(IPV6ADDRESS$ + subexp("\\%25|\\%(?!" + HEXDIG$$ + "{2})") + ZONEID$),
        //RFC 6874, with relaxed parsing rules
    IPVFUTURE$ = subexp("[vV]" + HEXDIG$$ + "+\\." + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:]") + "+"),
        IP_LITERAL$ = subexp("\\[" + subexp(IPV6ADDRZ_RELAXED$ + "|" + IPV6ADDRESS$ + "|" + IPVFUTURE$) + "\\]"),
        //RFC 6874
    REG_NAME$ = subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$)) + "*"),
        HOST$ = subexp(IP_LITERAL$ + "|" + IPV4ADDRESS$ + "(?!" + REG_NAME$ + ")" + "|" + REG_NAME$),
        PORT$ = subexp(DIGIT$$ + "*"),
        AUTHORITY$ = subexp(subexp(USERINFO$ + "@") + "?" + HOST$ + subexp("\\:" + PORT$) + "?"),
        PCHAR$ = subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@]")),
        SEGMENT$ = subexp(PCHAR$ + "*"),
        SEGMENT_NZ$ = subexp(PCHAR$ + "+"),
        SEGMENT_NZ_NC$ = subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\@]")) + "+"),
        PATH_ABEMPTY$ = subexp(subexp("\\/" + SEGMENT$) + "*"),
        PATH_ABSOLUTE$ = subexp("\\/" + subexp(SEGMENT_NZ$ + PATH_ABEMPTY$) + "?"),
        //simplified
    PATH_NOSCHEME$ = subexp(SEGMENT_NZ_NC$ + PATH_ABEMPTY$),
        //simplified
    PATH_ROOTLESS$ = subexp(SEGMENT_NZ$ + PATH_ABEMPTY$),
        //simplified
    PATH_EMPTY$ = "(?!" + PCHAR$ + ")",
        PATH$ = subexp(PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$),
        QUERY$ = subexp(subexp(PCHAR$ + "|" + merge("[\\/\\?]", IPRIVATE$$)) + "*"),
        FRAGMENT$ = subexp(subexp(PCHAR$ + "|[\\/\\?]") + "*"),
        HIER_PART$ = subexp(subexp("\\/\\/" + AUTHORITY$ + PATH_ABEMPTY$) + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$),
        URI$ = subexp(SCHEME$ + "\\:" + HIER_PART$ + subexp("\\?" + QUERY$) + "?" + subexp("\\#" + FRAGMENT$) + "?"),
        RELATIVE_PART$ = subexp(subexp("\\/\\/" + AUTHORITY$ + PATH_ABEMPTY$) + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_EMPTY$),
        RELATIVE$ = subexp(RELATIVE_PART$ + subexp("\\?" + QUERY$) + "?" + subexp("\\#" + FRAGMENT$) + "?"),
        URI_REFERENCE$ = subexp(URI$ + "|" + RELATIVE$),
        ABSOLUTE_URI$ = subexp(SCHEME$ + "\\:" + HIER_PART$ + subexp("\\?" + QUERY$) + "?"),
        GENERIC_REF$ = "^(" + SCHEME$ + ")\\:" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?" + subexp("\\#(" + FRAGMENT$ + ")") + "?$",
        RELATIVE_REF$ = "^(){0}" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?" + subexp("\\#(" + FRAGMENT$ + ")") + "?$",
        ABSOLUTE_REF$ = "^(" + SCHEME$ + ")\\:" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?$",
        SAMEDOC_REF$ = "^" + subexp("\\#(" + FRAGMENT$ + ")") + "?$",
        AUTHORITY_REF$ = "^" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?$";
    return {
        NOT_SCHEME: new RegExp(merge("[^]", ALPHA$$, DIGIT$$, "[\\+\\-\\.]"), "g"),
        NOT_USERINFO: new RegExp(merge("[^\\%\\:]", UNRESERVED$$, SUB_DELIMS$$), "g"),
        NOT_HOST: new RegExp(merge("[^\\%\\[\\]\\:]", UNRESERVED$$, SUB_DELIMS$$), "g"),
        NOT_PATH: new RegExp(merge("[^\\%\\/\\:\\@]", UNRESERVED$$, SUB_DELIMS$$), "g"),
        NOT_PATH_NOSCHEME: new RegExp(merge("[^\\%\\/\\@]", UNRESERVED$$, SUB_DELIMS$$), "g"),
        NOT_QUERY: new RegExp(merge("[^\\%]", UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@\\/\\?]", IPRIVATE$$), "g"),
        NOT_FRAGMENT: new RegExp(merge("[^\\%]", UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@\\/\\?]"), "g"),
        ESCAPE: new RegExp(merge("[^]", UNRESERVED$$, SUB_DELIMS$$), "g"),
        UNRESERVED: new RegExp(UNRESERVED$$, "g"),
        OTHER_CHARS: new RegExp(merge("[^\\%]", UNRESERVED$$, RESERVED$$), "g"),
        PCT_ENCODED: new RegExp(PCT_ENCODED$, "g"),
        IPV4ADDRESS: new RegExp("^(" + IPV4ADDRESS$ + ")$"),
        IPV6ADDRESS: new RegExp("^\\[?(" + IPV6ADDRESS$ + ")" + subexp(subexp("\\%25|\\%(?!" + HEXDIG$$ + "{2})") + "(" + ZONEID$ + ")") + "?\\]?$") //RFC 6874, with relaxed parsing rules
    };
}
var URI_PROTOCOL = buildExps(false);

var IRI_PROTOCOL = buildExps(true);

var slicedToArray = function () {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();













var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

/** Highest positive signed 32-bit float value */

var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

/** Bootstring parameters */
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128; // 0x80
var delimiter = '-'; // '\x2D'

/** Regular expressions */
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/; // non-ASCII chars
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

/** Error messages */
var errors = {
	'overflow': 'Overflow: input needs wider integers to process',
	'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
	'invalid-input': 'Invalid input'
};

/** Convenience shortcuts */
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;

/*--------------------------------------------------------------------------*/

/**
 * A generic error utility function.
 * @private
 * @param {String} type The error type.
 * @returns {Error} Throws a `RangeError` with the applicable error message.
 */
function error$1(type) {
	throw new RangeError(errors[type]);
}

/**
 * A generic `Array#map` utility function.
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} callback The function that gets called for every array
 * item.
 * @returns {Array} A new array of values returned by the callback function.
 */
function map(array, fn) {
	var result = [];
	var length = array.length;
	while (length--) {
		result[length] = fn(array[length]);
	}
	return result;
}

/**
 * A simple `Array#map`-like wrapper to work with domain name strings or email
 * addresses.
 * @private
 * @param {String} domain The domain name or email address.
 * @param {Function} callback The function that gets called for every
 * character.
 * @returns {Array} A new string of characters returned by the callback
 * function.
 */
function mapDomain(string, fn) {
	var parts = string.split('@');
	var result = '';
	if (parts.length > 1) {
		// In email addresses, only the domain name should be punycoded. Leave
		// the local part (i.e. everything up to `@`) intact.
		result = parts[0] + '@';
		string = parts[1];
	}
	// Avoid `split(regex)` for IE8 compatibility. See #17.
	string = string.replace(regexSeparators, '\x2E');
	var labels = string.split('.');
	var encoded = map(labels, fn).join('.');
	return result + encoded;
}

/**
 * Creates an array containing the numeric code points of each Unicode
 * character in the string. While JavaScript uses UCS-2 internally,
 * this function will convert a pair of surrogate halves (each of which
 * UCS-2 exposes as separate characters) into a single code point,
 * matching UTF-16.
 * @see `punycode.ucs2.encode`
 * @see <https://mathiasbynens.be/notes/javascript-encoding>
 * @memberOf punycode.ucs2
 * @name decode
 * @param {String} string The Unicode input string (UCS-2).
 * @returns {Array} The new array of code points.
 */
function ucs2decode(string) {
	var output = [];
	var counter = 0;
	var length = string.length;
	while (counter < length) {
		var value = string.charCodeAt(counter++);
		if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
			// It's a high surrogate, and there is a next character.
			var extra = string.charCodeAt(counter++);
			if ((extra & 0xFC00) == 0xDC00) {
				// Low surrogate.
				output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
			} else {
				// It's an unmatched surrogate; only append this code unit, in case the
				// next code unit is the high surrogate of a surrogate pair.
				output.push(value);
				counter--;
			}
		} else {
			output.push(value);
		}
	}
	return output;
}

/**
 * Creates a string based on an array of numeric code points.
 * @see `punycode.ucs2.decode`
 * @memberOf punycode.ucs2
 * @name encode
 * @param {Array} codePoints The array of numeric code points.
 * @returns {String} The new Unicode string (UCS-2).
 */
var ucs2encode = function ucs2encode(array) {
	return String.fromCodePoint.apply(String, toConsumableArray(array));
};

/**
 * Converts a basic code point into a digit/integer.
 * @see `digitToBasic()`
 * @private
 * @param {Number} codePoint The basic numeric code point value.
 * @returns {Number} The numeric value of a basic code point (for use in
 * representing integers) in the range `0` to `base - 1`, or `base` if
 * the code point does not represent a value.
 */
var basicToDigit = function basicToDigit(codePoint) {
	if (codePoint - 0x30 < 0x0A) {
		return codePoint - 0x16;
	}
	if (codePoint - 0x41 < 0x1A) {
		return codePoint - 0x41;
	}
	if (codePoint - 0x61 < 0x1A) {
		return codePoint - 0x61;
	}
	return base;
};

/**
 * Converts a digit/integer into a basic code point.
 * @see `basicToDigit()`
 * @private
 * @param {Number} digit The numeric value of a basic code point.
 * @returns {Number} The basic code point whose value (when used for
 * representing integers) is `digit`, which needs to be in the range
 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
 * used; else, the lowercase form is used. The behavior is undefined
 * if `flag` is non-zero and `digit` has no uppercase form.
 */
var digitToBasic = function digitToBasic(digit, flag) {
	//  0..25 map to ASCII a..z or A..Z
	// 26..35 map to ASCII 0..9
	return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
};

/**
 * Bias adaptation function as per section 3.4 of RFC 3492.
 * https://tools.ietf.org/html/rfc3492#section-3.4
 * @private
 */
var adapt = function adapt(delta, numPoints, firstTime) {
	var k = 0;
	delta = firstTime ? floor(delta / damp) : delta >> 1;
	delta += floor(delta / numPoints);
	for (; /* no initialization */delta > baseMinusTMin * tMax >> 1; k += base) {
		delta = floor(delta / baseMinusTMin);
	}
	return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
};

/**
 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
 * symbols.
 * @memberOf punycode
 * @param {String} input The Punycode string of ASCII-only symbols.
 * @returns {String} The resulting string of Unicode symbols.
 */
var decode = function decode(input) {
	// Don't use UCS-2.
	var output = [];
	var inputLength = input.length;
	var i = 0;
	var n = initialN;
	var bias = initialBias;

	// Handle the basic code points: let `basic` be the number of input code
	// points before the last delimiter, or `0` if there is none, then copy
	// the first basic code points to the output.

	var basic = input.lastIndexOf(delimiter);
	if (basic < 0) {
		basic = 0;
	}

	for (var j = 0; j < basic; ++j) {
		// if it's not a basic code point
		if (input.charCodeAt(j) >= 0x80) {
			error$1('not-basic');
		}
		output.push(input.charCodeAt(j));
	}

	// Main decoding loop: start just after the last delimiter if any basic code
	// points were copied; start at the beginning otherwise.

	for (var index = basic > 0 ? basic + 1 : 0; index < inputLength;) /* no final expression */{

		// `index` is the index of the next character to be consumed.
		// Decode a generalized variable-length integer into `delta`,
		// which gets added to `i`. The overflow checking is easier
		// if we increase `i` as we go, then subtract off its starting
		// value at the end to obtain `delta`.
		var oldi = i;
		for (var w = 1, k = base;; /* no condition */k += base) {

			if (index >= inputLength) {
				error$1('invalid-input');
			}

			var digit = basicToDigit(input.charCodeAt(index++));

			if (digit >= base || digit > floor((maxInt - i) / w)) {
				error$1('overflow');
			}

			i += digit * w;
			var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;

			if (digit < t) {
				break;
			}

			var baseMinusT = base - t;
			if (w > floor(maxInt / baseMinusT)) {
				error$1('overflow');
			}

			w *= baseMinusT;
		}

		var out = output.length + 1;
		bias = adapt(i - oldi, out, oldi == 0);

		// `i` was supposed to wrap around from `out` to `0`,
		// incrementing `n` each time, so we'll fix that now:
		if (floor(i / out) > maxInt - n) {
			error$1('overflow');
		}

		n += floor(i / out);
		i %= out;

		// Insert `n` at position `i` of the output.
		output.splice(i++, 0, n);
	}

	return String.fromCodePoint.apply(String, output);
};

/**
 * Converts a string of Unicode symbols (e.g. a domain name label) to a
 * Punycode string of ASCII-only symbols.
 * @memberOf punycode
 * @param {String} input The string of Unicode symbols.
 * @returns {String} The resulting Punycode string of ASCII-only symbols.
 */
var encode = function encode(input) {
	var output = [];

	// Convert the input in UCS-2 to an array of Unicode code points.
	input = ucs2decode(input);

	// Cache the length.
	var inputLength = input.length;

	// Initialize the state.
	var n = initialN;
	var delta = 0;
	var bias = initialBias;

	// Handle the basic code points.
	var _iteratorNormalCompletion = true;
	var _didIteratorError = false;
	var _iteratorError = undefined;

	try {
		for (var _iterator = input[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
			var _currentValue2 = _step.value;

			if (_currentValue2 < 0x80) {
				output.push(stringFromCharCode(_currentValue2));
			}
		}
	} catch (err) {
		_didIteratorError = true;
		_iteratorError = err;
	} finally {
		try {
			if (!_iteratorNormalCompletion && _iterator.return) {
				_iterator.return();
			}
		} finally {
			if (_didIteratorError) {
				throw _iteratorError;
			}
		}
	}

	var basicLength = output.length;
	var handledCPCount = basicLength;

	// `handledCPCount` is the number of code points that have been handled;
	// `basicLength` is the number of basic code points.

	// Finish the basic string with a delimiter unless it's empty.
	if (basicLength) {
		output.push(delimiter);
	}

	// Main encoding loop:
	while (handledCPCount < inputLength) {

		// All non-basic code points < n have been handled already. Find the next
		// larger one:
		var m = maxInt;
		var _iteratorNormalCompletion2 = true;
		var _didIteratorError2 = false;
		var _iteratorError2 = undefined;

		try {
			for (var _iterator2 = input[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
				var currentValue = _step2.value;

				if (currentValue >= n && currentValue < m) {
					m = currentValue;
				}
			}

			// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
			// but guard against overflow.
		} catch (err) {
			_didIteratorError2 = true;
			_iteratorError2 = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion2 && _iterator2.return) {
					_iterator2.return();
				}
			} finally {
				if (_didIteratorError2) {
					throw _iteratorError2;
				}
			}
		}

		var handledCPCountPlusOne = handledCPCount + 1;
		if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
			error$1('overflow');
		}

		delta += (m - n) * handledCPCountPlusOne;
		n = m;

		var _iteratorNormalCompletion3 = true;
		var _didIteratorError3 = false;
		var _iteratorError3 = undefined;

		try {
			for (var _iterator3 = input[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
				var _currentValue = _step3.value;

				if (_currentValue < n && ++delta > maxInt) {
					error$1('overflow');
				}
				if (_currentValue == n) {
					// Represent delta as a generalized variable-length integer.
					var q = delta;
					for (var k = base;; /* no condition */k += base) {
						var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
						if (q < t) {
							break;
						}
						var qMinusT = q - t;
						var baseMinusT = base - t;
						output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
						q = floor(qMinusT / baseMinusT);
					}

					output.push(stringFromCharCode(digitToBasic(q, 0)));
					bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
					delta = 0;
					++handledCPCount;
				}
			}
		} catch (err) {
			_didIteratorError3 = true;
			_iteratorError3 = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion3 && _iterator3.return) {
					_iterator3.return();
				}
			} finally {
				if (_didIteratorError3) {
					throw _iteratorError3;
				}
			}
		}

		++delta;
		++n;
	}
	return output.join('');
};

/**
 * Converts a Punycode string representing a domain name or an email address
 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
 * it doesn't matter if you call it on a string that has already been
 * converted to Unicode.
 * @memberOf punycode
 * @param {String} input The Punycoded domain name or email address to
 * convert to Unicode.
 * @returns {String} The Unicode representation of the given Punycode
 * string.
 */
var toUnicode = function toUnicode(input) {
	return mapDomain(input, function (string) {
		return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
	});
};

/**
 * Converts a Unicode string representing a domain name or an email address to
 * Punycode. Only the non-ASCII parts of the domain name will be converted,
 * i.e. it doesn't matter if you call it with a domain that's already in
 * ASCII.
 * @memberOf punycode
 * @param {String} input The domain name or email address to convert, as a
 * Unicode string.
 * @returns {String} The Punycode representation of the given domain name or
 * email address.
 */
var toASCII = function toASCII(input) {
	return mapDomain(input, function (string) {
		return regexNonASCII.test(string) ? 'xn--' + encode(string) : string;
	});
};

/*--------------------------------------------------------------------------*/

/** Define the public API */
var punycode = {
	/**
  * A string representing the current Punycode.js version number.
  * @memberOf punycode
  * @type String
  */
	'version': '2.1.0',
	/**
  * An object of methods to convert from JavaScript's internal character
  * representation (UCS-2) to Unicode code points, and back.
  * @see <https://mathiasbynens.be/notes/javascript-encoding>
  * @memberOf punycode
  * @type Object
  */
	'ucs2': {
		'decode': ucs2decode,
		'encode': ucs2encode
	},
	'decode': decode,
	'encode': encode,
	'toASCII': toASCII,
	'toUnicode': toUnicode
};

/**
 * URI.js
 *
 * @fileoverview An RFC 3986 compliant, scheme extendable URI parsing/validating/resolving library for JavaScript.
 * @author <a href="mailto:gary.court@gmail.com">Gary Court</a>
 * @see http://github.com/garycourt/uri-js
 */
/**
 * Copyright 2011 Gary Court. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GARY COURT ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GARY COURT OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of Gary Court.
 */
var SCHEMES = {};
function pctEncChar(chr) {
    var c = chr.charCodeAt(0);
    var e = void 0;
    if (c < 16) e = "%0" + c.toString(16).toUpperCase();else if (c < 128) e = "%" + c.toString(16).toUpperCase();else if (c < 2048) e = "%" + (c >> 6 | 192).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();else e = "%" + (c >> 12 | 224).toString(16).toUpperCase() + "%" + (c >> 6 & 63 | 128).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
    return e;
}
function pctDecChars(str) {
    var newStr = "";
    var i = 0;
    var il = str.length;
    while (i < il) {
        var c = parseInt(str.substr(i + 1, 2), 16);
        if (c < 128) {
            newStr += String.fromCharCode(c);
            i += 3;
        } else if (c >= 194 && c < 224) {
            if (il - i >= 6) {
                var c2 = parseInt(str.substr(i + 4, 2), 16);
                newStr += String.fromCharCode((c & 31) << 6 | c2 & 63);
            } else {
                newStr += str.substr(i, 6);
            }
            i += 6;
        } else if (c >= 224) {
            if (il - i >= 9) {
                var _c = parseInt(str.substr(i + 4, 2), 16);
                var c3 = parseInt(str.substr(i + 7, 2), 16);
                newStr += String.fromCharCode((c & 15) << 12 | (_c & 63) << 6 | c3 & 63);
            } else {
                newStr += str.substr(i, 9);
            }
            i += 9;
        } else {
            newStr += str.substr(i, 3);
            i += 3;
        }
    }
    return newStr;
}
function _normalizeComponentEncoding(components, protocol) {
    function decodeUnreserved(str) {
        var decStr = pctDecChars(str);
        return !decStr.match(protocol.UNRESERVED) ? str : decStr;
    }
    if (components.scheme) components.scheme = String(components.scheme).replace(protocol.PCT_ENCODED, decodeUnreserved).toLowerCase().replace(protocol.NOT_SCHEME, "");
    if (components.userinfo !== undefined) components.userinfo = String(components.userinfo).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_USERINFO, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
    if (components.host !== undefined) components.host = String(components.host).replace(protocol.PCT_ENCODED, decodeUnreserved).toLowerCase().replace(protocol.NOT_HOST, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
    if (components.path !== undefined) components.path = String(components.path).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(components.scheme ? protocol.NOT_PATH : protocol.NOT_PATH_NOSCHEME, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
    if (components.query !== undefined) components.query = String(components.query).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_QUERY, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
    if (components.fragment !== undefined) components.fragment = String(components.fragment).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_FRAGMENT, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
    return components;
}

function _stripLeadingZeros(str) {
    return str.replace(/^0*(.*)/, "$1") || "0";
}
function _normalizeIPv4(host, protocol) {
    var matches = host.match(protocol.IPV4ADDRESS) || [];

    var _matches = slicedToArray(matches, 2),
        address = _matches[1];

    if (address) {
        return address.split(".").map(_stripLeadingZeros).join(".");
    } else {
        return host;
    }
}
function _normalizeIPv6(host, protocol) {
    var matches = host.match(protocol.IPV6ADDRESS) || [];

    var _matches2 = slicedToArray(matches, 3),
        address = _matches2[1],
        zone = _matches2[2];

    if (address) {
        var _address$toLowerCase$ = address.toLowerCase().split('::').reverse(),
            _address$toLowerCase$2 = slicedToArray(_address$toLowerCase$, 2),
            last = _address$toLowerCase$2[0],
            first = _address$toLowerCase$2[1];

        var firstFields = first ? first.split(":").map(_stripLeadingZeros) : [];
        var lastFields = last.split(":").map(_stripLeadingZeros);
        var isLastFieldIPv4Address = protocol.IPV4ADDRESS.test(lastFields[lastFields.length - 1]);
        var fieldCount = isLastFieldIPv4Address ? 7 : 8;
        var lastFieldsStart = lastFields.length - fieldCount;
        var fields = Array(fieldCount);
        for (var x = 0; x < fieldCount; ++x) {
            fields[x] = firstFields[x] || lastFields[lastFieldsStart + x] || '';
        }
        if (isLastFieldIPv4Address) {
            fields[fieldCount - 1] = _normalizeIPv4(fields[fieldCount - 1], protocol);
        }
        var allZeroFields = fields.reduce(function (acc, field, index) {
            if (!field || field === "0") {
                var lastLongest = acc[acc.length - 1];
                if (lastLongest && lastLongest.index + lastLongest.length === index) {
                    lastLongest.length++;
                } else {
                    acc.push({ index: index, length: 1 });
                }
            }
            return acc;
        }, []);
        var longestZeroFields = allZeroFields.sort(function (a, b) {
            return b.length - a.length;
        })[0];
        var newHost = void 0;
        if (longestZeroFields && longestZeroFields.length > 1) {
            var newFirst = fields.slice(0, longestZeroFields.index);
            var newLast = fields.slice(longestZeroFields.index + longestZeroFields.length);
            newHost = newFirst.join(":") + "::" + newLast.join(":");
        } else {
            newHost = fields.join(":");
        }
        if (zone) {
            newHost += "%" + zone;
        }
        return newHost;
    } else {
        return host;
    }
}
var URI_PARSE = /^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i;
var NO_MATCH_IS_UNDEFINED = "".match(/(){0}/)[1] === undefined;
function parse(uriString) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var components = {};
    var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
    if (options.reference === "suffix") uriString = (options.scheme ? options.scheme + ":" : "") + "//" + uriString;
    var matches = uriString.match(URI_PARSE);
    if (matches) {
        if (NO_MATCH_IS_UNDEFINED) {
            //store each component
            components.scheme = matches[1];
            components.userinfo = matches[3];
            components.host = matches[4];
            components.port = parseInt(matches[5], 10);
            components.path = matches[6] || "";
            components.query = matches[7];
            components.fragment = matches[8];
            //fix port number
            if (isNaN(components.port)) {
                components.port = matches[5];
            }
        } else {
            //IE FIX for improper RegExp matching
            //store each component
            components.scheme = matches[1] || undefined;
            components.userinfo = uriString.indexOf("@") !== -1 ? matches[3] : undefined;
            components.host = uriString.indexOf("//") !== -1 ? matches[4] : undefined;
            components.port = parseInt(matches[5], 10);
            components.path = matches[6] || "";
            components.query = uriString.indexOf("?") !== -1 ? matches[7] : undefined;
            components.fragment = uriString.indexOf("#") !== -1 ? matches[8] : undefined;
            //fix port number
            if (isNaN(components.port)) {
                components.port = uriString.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/) ? matches[4] : undefined;
            }
        }
        if (components.host) {
            //normalize IP hosts
            components.host = _normalizeIPv6(_normalizeIPv4(components.host, protocol), protocol);
        }
        //determine reference type
        if (components.scheme === undefined && components.userinfo === undefined && components.host === undefined && components.port === undefined && !components.path && components.query === undefined) {
            components.reference = "same-document";
        } else if (components.scheme === undefined) {
            components.reference = "relative";
        } else if (components.fragment === undefined) {
            components.reference = "absolute";
        } else {
            components.reference = "uri";
        }
        //check for reference errors
        if (options.reference && options.reference !== "suffix" && options.reference !== components.reference) {
            components.error = components.error || "URI is not a " + options.reference + " reference.";
        }
        //find scheme handler
        var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
        //check if scheme can't handle IRIs
        if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
            //if host component is a domain name
            if (components.host && (options.domainHost || schemeHandler && schemeHandler.domainHost)) {
                //convert Unicode IDN -> ASCII IDN
                try {
                    components.host = punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase());
                } catch (e) {
                    components.error = components.error || "Host's domain name can not be converted to ASCII via punycode: " + e;
                }
            }
            //convert IRI -> URI
            _normalizeComponentEncoding(components, URI_PROTOCOL);
        } else {
            //normalize encodings
            _normalizeComponentEncoding(components, protocol);
        }
        //perform scheme specific parsing
        if (schemeHandler && schemeHandler.parse) {
            schemeHandler.parse(components, options);
        }
    } else {
        components.error = components.error || "URI can not be parsed.";
    }
    return components;
}

function _recomposeAuthority(components, options) {
    var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
    var uriTokens = [];
    if (components.userinfo !== undefined) {
        uriTokens.push(components.userinfo);
        uriTokens.push("@");
    }
    if (components.host !== undefined) {
        //normalize IP hosts, add brackets and escape zone separator for IPv6
        uriTokens.push(_normalizeIPv6(_normalizeIPv4(String(components.host), protocol), protocol).replace(protocol.IPV6ADDRESS, function (_, $1, $2) {
            return "[" + $1 + ($2 ? "%25" + $2 : "") + "]";
        }));
    }
    if (typeof components.port === "number" || typeof components.port === "string") {
        uriTokens.push(":");
        uriTokens.push(String(components.port));
    }
    return uriTokens.length ? uriTokens.join("") : undefined;
}

var RDS1 = /^\.\.?\//;
var RDS2 = /^\/\.(\/|$)/;
var RDS3 = /^\/\.\.(\/|$)/;
var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/;
function removeDotSegments(input) {
    var output = [];
    while (input.length) {
        if (input.match(RDS1)) {
            input = input.replace(RDS1, "");
        } else if (input.match(RDS2)) {
            input = input.replace(RDS2, "/");
        } else if (input.match(RDS3)) {
            input = input.replace(RDS3, "/");
            output.pop();
        } else if (input === "." || input === "..") {
            input = "";
        } else {
            var im = input.match(RDS5);
            if (im) {
                var s = im[0];
                input = input.slice(s.length);
                output.push(s);
            } else {
                throw new Error("Unexpected dot segment condition");
            }
        }
    }
    return output.join("");
}

function serialize(components) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var protocol = options.iri ? IRI_PROTOCOL : URI_PROTOCOL;
    var uriTokens = [];
    //find scheme handler
    var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
    //perform scheme specific serialization
    if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
    if (components.host) {
        //if host component is an IPv6 address
        if (protocol.IPV6ADDRESS.test(components.host)) {}
        //TODO: normalize IPv6 address as per RFC 5952

        //if host component is a domain name
        else if (options.domainHost || schemeHandler && schemeHandler.domainHost) {
                //convert IDN via punycode
                try {
                    components.host = !options.iri ? punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase()) : punycode.toUnicode(components.host);
                } catch (e) {
                    components.error = components.error || "Host's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
                }
            }
    }
    //normalize encoding
    _normalizeComponentEncoding(components, protocol);
    if (options.reference !== "suffix" && components.scheme) {
        uriTokens.push(components.scheme);
        uriTokens.push(":");
    }
    var authority = _recomposeAuthority(components, options);
    if (authority !== undefined) {
        if (options.reference !== "suffix") {
            uriTokens.push("//");
        }
        uriTokens.push(authority);
        if (components.path && components.path.charAt(0) !== "/") {
            uriTokens.push("/");
        }
    }
    if (components.path !== undefined) {
        var s = components.path;
        if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
            s = removeDotSegments(s);
        }
        if (authority === undefined) {
            s = s.replace(/^\/\//, "/%2F"); //don't allow the path to start with "//"
        }
        uriTokens.push(s);
    }
    if (components.query !== undefined) {
        uriTokens.push("?");
        uriTokens.push(components.query);
    }
    if (components.fragment !== undefined) {
        uriTokens.push("#");
        uriTokens.push(components.fragment);
    }
    return uriTokens.join(""); //merge tokens into a string
}

function resolveComponents(base, relative) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var skipNormalization = arguments[3];

    var target = {};
    if (!skipNormalization) {
        base = parse(serialize(base, options), options); //normalize base components
        relative = parse(serialize(relative, options), options); //normalize relative components
    }
    options = options || {};
    if (!options.tolerant && relative.scheme) {
        target.scheme = relative.scheme;
        //target.authority = relative.authority;
        target.userinfo = relative.userinfo;
        target.host = relative.host;
        target.port = relative.port;
        target.path = removeDotSegments(relative.path || "");
        target.query = relative.query;
    } else {
        if (relative.userinfo !== undefined || relative.host !== undefined || relative.port !== undefined) {
            //target.authority = relative.authority;
            target.userinfo = relative.userinfo;
            target.host = relative.host;
            target.port = relative.port;
            target.path = removeDotSegments(relative.path || "");
            target.query = relative.query;
        } else {
            if (!relative.path) {
                target.path = base.path;
                if (relative.query !== undefined) {
                    target.query = relative.query;
                } else {
                    target.query = base.query;
                }
            } else {
                if (relative.path.charAt(0) === "/") {
                    target.path = removeDotSegments(relative.path);
                } else {
                    if ((base.userinfo !== undefined || base.host !== undefined || base.port !== undefined) && !base.path) {
                        target.path = "/" + relative.path;
                    } else if (!base.path) {
                        target.path = relative.path;
                    } else {
                        target.path = base.path.slice(0, base.path.lastIndexOf("/") + 1) + relative.path;
                    }
                    target.path = removeDotSegments(target.path);
                }
                target.query = relative.query;
            }
            //target.authority = base.authority;
            target.userinfo = base.userinfo;
            target.host = base.host;
            target.port = base.port;
        }
        target.scheme = base.scheme;
    }
    target.fragment = relative.fragment;
    return target;
}

function resolve(baseURI, relativeURI, options) {
    var schemelessOptions = assign({ scheme: 'null' }, options);
    return serialize(resolveComponents(parse(baseURI, schemelessOptions), parse(relativeURI, schemelessOptions), schemelessOptions, true), schemelessOptions);
}

function normalize(uri, options) {
    if (typeof uri === "string") {
        uri = serialize(parse(uri, options), options);
    } else if (typeOf(uri) === "object") {
        uri = parse(serialize(uri, options), options);
    }
    return uri;
}

function equal(uriA, uriB, options) {
    if (typeof uriA === "string") {
        uriA = serialize(parse(uriA, options), options);
    } else if (typeOf(uriA) === "object") {
        uriA = serialize(uriA, options);
    }
    if (typeof uriB === "string") {
        uriB = serialize(parse(uriB, options), options);
    } else if (typeOf(uriB) === "object") {
        uriB = serialize(uriB, options);
    }
    return uriA === uriB;
}

function escapeComponent(str, options) {
    return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.ESCAPE : IRI_PROTOCOL.ESCAPE, pctEncChar);
}

function unescapeComponent(str, options) {
    return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.PCT_ENCODED : IRI_PROTOCOL.PCT_ENCODED, pctDecChars);
}

var handler = {
    scheme: "http",
    domainHost: true,
    parse: function parse(components, options) {
        //report missing host
        if (!components.host) {
            components.error = components.error || "HTTP URIs must have a host.";
        }
        return components;
    },
    serialize: function serialize(components, options) {
        var secure = String(components.scheme).toLowerCase() === "https";
        //normalize the default port
        if (components.port === (secure ? 443 : 80) || components.port === "") {
            components.port = undefined;
        }
        //normalize the empty path
        if (!components.path) {
            components.path = "/";
        }
        //NOTE: We do not parse query strings for HTTP URIs
        //as WWW Form Url Encoded query strings are part of the HTML4+ spec,
        //and not the HTTP spec.
        return components;
    }
};

var handler$1 = {
    scheme: "https",
    domainHost: handler.domainHost,
    parse: handler.parse,
    serialize: handler.serialize
};

function isSecure(wsComponents) {
    return typeof wsComponents.secure === 'boolean' ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
}
//RFC 6455
var handler$2 = {
    scheme: "ws",
    domainHost: true,
    parse: function parse(components, options) {
        var wsComponents = components;
        //indicate if the secure flag is set
        wsComponents.secure = isSecure(wsComponents);
        //construct resouce name
        wsComponents.resourceName = (wsComponents.path || '/') + (wsComponents.query ? '?' + wsComponents.query : '');
        wsComponents.path = undefined;
        wsComponents.query = undefined;
        return wsComponents;
    },
    serialize: function serialize(wsComponents, options) {
        //normalize the default port
        if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
            wsComponents.port = undefined;
        }
        //ensure scheme matches secure flag
        if (typeof wsComponents.secure === 'boolean') {
            wsComponents.scheme = wsComponents.secure ? 'wss' : 'ws';
            wsComponents.secure = undefined;
        }
        //reconstruct path from resource name
        if (wsComponents.resourceName) {
            var _wsComponents$resourc = wsComponents.resourceName.split('?'),
                _wsComponents$resourc2 = slicedToArray(_wsComponents$resourc, 2),
                path = _wsComponents$resourc2[0],
                query = _wsComponents$resourc2[1];

            wsComponents.path = path && path !== '/' ? path : undefined;
            wsComponents.query = query;
            wsComponents.resourceName = undefined;
        }
        //forbid fragment component
        wsComponents.fragment = undefined;
        return wsComponents;
    }
};

var handler$3 = {
    scheme: "wss",
    domainHost: handler$2.domainHost,
    parse: handler$2.parse,
    serialize: handler$2.serialize
};

var O = {};
var isIRI = true;
//RFC 3986
var UNRESERVED$$ = "[A-Za-z0-9\\-\\.\\_\\~" + (isIRI ? "\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF" : "") + "]";
var HEXDIG$$ = "[0-9A-Fa-f]"; //case-insensitive
var PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$)); //expanded
//RFC 5322, except these symbols as per RFC 6068: @ : / ? # [ ] & ; =
//const ATEXT$$ = "[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]";
//const WSP$$ = "[\\x20\\x09]";
//const OBS_QTEXT$$ = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]";  //(%d1-8 / %d11-12 / %d14-31 / %d127)
//const QTEXT$$ = merge("[\\x21\\x23-\\x5B\\x5D-\\x7E]", OBS_QTEXT$$);  //%d33 / %d35-91 / %d93-126 / obs-qtext
//const VCHAR$$ = "[\\x21-\\x7E]";
//const WSP$$ = "[\\x20\\x09]";
//const OBS_QP$ = subexp("\\\\" + merge("[\\x00\\x0D\\x0A]", OBS_QTEXT$$));  //%d0 / CR / LF / obs-qtext
//const FWS$ = subexp(subexp(WSP$$ + "*" + "\\x0D\\x0A") + "?" + WSP$$ + "+");
//const QUOTED_PAIR$ = subexp(subexp("\\\\" + subexp(VCHAR$$ + "|" + WSP$$)) + "|" + OBS_QP$);
//const QUOTED_STRING$ = subexp('\\"' + subexp(FWS$ + "?" + QCONTENT$) + "*" + FWS$ + "?" + '\\"');
var ATEXT$$ = "[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]";
var QTEXT$$ = "[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]";
var VCHAR$$ = merge(QTEXT$$, "[\\\"\\\\]");
var SOME_DELIMS$$ = "[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]";
var UNRESERVED = new RegExp(UNRESERVED$$, "g");
var PCT_ENCODED = new RegExp(PCT_ENCODED$, "g");
var NOT_LOCAL_PART = new RegExp(merge("[^]", ATEXT$$, "[\\.]", '[\\"]', VCHAR$$), "g");
var NOT_HFNAME = new RegExp(merge("[^]", UNRESERVED$$, SOME_DELIMS$$), "g");
var NOT_HFVALUE = NOT_HFNAME;
function decodeUnreserved(str) {
    var decStr = pctDecChars(str);
    return !decStr.match(UNRESERVED) ? str : decStr;
}
var handler$4 = {
    scheme: "mailto",
    parse: function parse$$1(components, options) {
        var mailtoComponents = components;
        var to = mailtoComponents.to = mailtoComponents.path ? mailtoComponents.path.split(",") : [];
        mailtoComponents.path = undefined;
        if (mailtoComponents.query) {
            var unknownHeaders = false;
            var headers = {};
            var hfields = mailtoComponents.query.split("&");
            for (var x = 0, xl = hfields.length; x < xl; ++x) {
                var hfield = hfields[x].split("=");
                switch (hfield[0]) {
                    case "to":
                        var toAddrs = hfield[1].split(",");
                        for (var _x = 0, _xl = toAddrs.length; _x < _xl; ++_x) {
                            to.push(toAddrs[_x]);
                        }
                        break;
                    case "subject":
                        mailtoComponents.subject = unescapeComponent(hfield[1], options);
                        break;
                    case "body":
                        mailtoComponents.body = unescapeComponent(hfield[1], options);
                        break;
                    default:
                        unknownHeaders = true;
                        headers[unescapeComponent(hfield[0], options)] = unescapeComponent(hfield[1], options);
                        break;
                }
            }
            if (unknownHeaders) mailtoComponents.headers = headers;
        }
        mailtoComponents.query = undefined;
        for (var _x2 = 0, _xl2 = to.length; _x2 < _xl2; ++_x2) {
            var addr = to[_x2].split("@");
            addr[0] = unescapeComponent(addr[0]);
            if (!options.unicodeSupport) {
                //convert Unicode IDN -> ASCII IDN
                try {
                    addr[1] = punycode.toASCII(unescapeComponent(addr[1], options).toLowerCase());
                } catch (e) {
                  