// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
import * as hex from "../encoding/hex.ts";
import * as base64 from "../encoding/base64.ts";
const decoder = new TextDecoder();
/**
 * Converts a hash to a string with a given encoding.
 * @example
 * ```ts
 * import { crypto, toHashString } from "https://deno.land/std@$STD_VERSION/crypto/mod.ts";
 *
 * const hash = await crypto.subtle.digest("SHA-384", new TextEncoder().encode("You hear that Mr. Anderson?"));
 *
 * // Hex encoding by default
 * console.log(toHashString(hash));
 *
 * // Or with base64 encoding
 * console.log(toHashString(hash, "base64"));
 * ```
 */ export function toHashString(hash, encoding = "hex") {
    switch(encoding){
        case "hex":
            return decoder.decode(hex.encode(new Uint8Array(hash)));
        case "base64":
            return base64.encode(hash);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE2Ni4wL2NyeXB0by91dGlsLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjIgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG5pbXBvcnQgKiBhcyBoZXggZnJvbSBcIi4uL2VuY29kaW5nL2hleC50c1wiO1xuaW1wb3J0ICogYXMgYmFzZTY0IGZyb20gXCIuLi9lbmNvZGluZy9iYXNlNjQudHNcIjtcblxuY29uc3QgZGVjb2RlciA9IG5ldyBUZXh0RGVjb2RlcigpO1xuXG4vKipcbiAqIENvbnZlcnRzIGEgaGFzaCB0byBhIHN0cmluZyB3aXRoIGEgZ2l2ZW4gZW5jb2RpbmcuXG4gKiBAZXhhbXBsZVxuICogYGBgdHNcbiAqIGltcG9ydCB7IGNyeXB0bywgdG9IYXNoU3RyaW5nIH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vY3J5cHRvL21vZC50c1wiO1xuICpcbiAqIGNvbnN0IGhhc2ggPSBhd2FpdCBjcnlwdG8uc3VidGxlLmRpZ2VzdChcIlNIQS0zODRcIiwgbmV3IFRleHRFbmNvZGVyKCkuZW5jb2RlKFwiWW91IGhlYXIgdGhhdCBNci4gQW5kZXJzb24/XCIpKTtcbiAqXG4gKiAvLyBIZXggZW5jb2RpbmcgYnkgZGVmYXVsdFxuICogY29uc29sZS5sb2codG9IYXNoU3RyaW5nKGhhc2gpKTtcbiAqXG4gKiAvLyBPciB3aXRoIGJhc2U2NCBlbmNvZGluZ1xuICogY29uc29sZS5sb2codG9IYXNoU3RyaW5nKGhhc2gsIFwiYmFzZTY0XCIpKTtcbiAqIGBgYFxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9IYXNoU3RyaW5nKFxuICBoYXNoOiBBcnJheUJ1ZmZlcixcbiAgZW5jb2Rpbmc6IFwiaGV4XCIgfCBcImJhc2U2NFwiID0gXCJoZXhcIixcbik6IHN0cmluZyB7XG4gIHN3aXRjaCAoZW5jb2RpbmcpIHtcbiAgICBjYXNlIFwiaGV4XCI6XG4gICAgICByZXR1cm4gZGVjb2Rlci5kZWNvZGUoaGV4LmVuY29kZShuZXcgVWludDhBcnJheShoYXNoKSkpO1xuICAgIGNhc2UgXCJiYXNlNjRcIjpcbiAgICAgIHJldHVybiBiYXNlNjQuZW5jb2RlKGhhc2gpO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLFlBQVksU0FBUyxxQkFBcUI7QUFDMUMsWUFBWSxZQUFZLHdCQUF3QjtBQUVoRCxNQUFNLFVBQVUsSUFBSTtBQUVwQjs7Ozs7Ozs7Ozs7Ozs7Q0FjQyxHQUNELE9BQU8sU0FBUyxhQUNkLElBQWlCLEVBQ2pCLFdBQTZCLEtBQUssRUFDMUI7SUFDUixPQUFRO1FBQ04sS0FBSztZQUNILE9BQU8sUUFBUSxNQUFNLENBQUMsSUFBSSxNQUFNLENBQUMsSUFBSSxXQUFXO1FBQ2xELEtBQUs7WUFDSCxPQUFPLE9BQU8sTUFBTSxDQUFDO0lBQ3pCO0FBQ0YsQ0FBQyJ9