// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
const decoder = new TextDecoder();
/** Writer utility for buffering string chunks */ export class StringWriter {
    #chunks;
    #byteLength;
    #cache;
    constructor(base = ""){
        this.base = base;
        this.#chunks = [];
        this.#byteLength = 0;
        const c = new TextEncoder().encode(base);
        this.#chunks.push(c);
        this.#byteLength += c.byteLength;
    }
    write(p) {
        return Promise.resolve(this.writeSync(p));
    }
    writeSync(p) {
        this.#chunks.push(new Uint8Array(p));
        this.#byteLength += p.byteLength;
        this.#cache = undefined;
        return p.byteLength;
    }
    toString() {
        if (this.#cache) {
            return this.#cache;
        }
        const buf = new Uint8Array(this.#byteLength);
        let offs = 0;
        for (const chunk of this.#chunks){
            buf.set(chunk, offs);
            offs += chunk.byteLength;
        }
        this.#cache = decoder.decode(buf);
        return this.#cache;
    }
    base;
}
//# sourceMappingURL=data:application/json;base64,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