// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Builds N-tuples of elements from the given N arrays with matching indices, stopping when the smallest array's end is reached
 * Example:
 *
 * ```ts
 * import { zip } from "https://deno.land/std@$STD_VERSION/collections/zip.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/testing/asserts.ts";
 *
 * const numbers = [ 1, 2, 3, 4 ];
 * const letters = [ 'a', 'b', 'c', 'd' ];
 * const pairs = zip(numbers, letters);
 *
 * assertEquals(pairs, [
 *     [ 1, 'a' ],
 *     [ 2, 'b' ],
 *     [ 3, 'c' ],
 *     [ 4, 'd' ],
 * ]);
 * ```
 */ import { minOf } from "./min_of.ts";
export function zip(...arrays) {
    const minLength = minOf(arrays, (it)=>it.length) ?? 0;
    const ret = new Array(minLength);
    for(let i = 0; i < minLength; i += 1){
        const arr = arrays.map((it)=>it[i]);
        ret[i] = arr;
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE2Ni4wL2NvbGxlY3Rpb25zL3ppcC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDIyIHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vKipcbiAqIEJ1aWxkcyBOLXR1cGxlcyBvZiBlbGVtZW50cyBmcm9tIHRoZSBnaXZlbiBOIGFycmF5cyB3aXRoIG1hdGNoaW5nIGluZGljZXMsIHN0b3BwaW5nIHdoZW4gdGhlIHNtYWxsZXN0IGFycmF5J3MgZW5kIGlzIHJlYWNoZWRcbiAqIEV4YW1wbGU6XG4gKlxuICogYGBgdHNcbiAqIGltcG9ydCB7IHppcCB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL2NvbGxlY3Rpb25zL3ppcC50c1wiO1xuICogaW1wb3J0IHsgYXNzZXJ0RXF1YWxzIH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vdGVzdGluZy9hc3NlcnRzLnRzXCI7XG4gKlxuICogY29uc3QgbnVtYmVycyA9IFsgMSwgMiwgMywgNCBdO1xuICogY29uc3QgbGV0dGVycyA9IFsgJ2EnLCAnYicsICdjJywgJ2QnIF07XG4gKiBjb25zdCBwYWlycyA9IHppcChudW1iZXJzLCBsZXR0ZXJzKTtcbiAqXG4gKiBhc3NlcnRFcXVhbHMocGFpcnMsIFtcbiAqICAgICBbIDEsICdhJyBdLFxuICogICAgIFsgMiwgJ2InIF0sXG4gKiAgICAgWyAzLCAnYycgXSxcbiAqICAgICBbIDQsICdkJyBdLFxuICogXSk7XG4gKiBgYGBcbiAqL1xuXG5pbXBvcnQgeyBtaW5PZiB9IGZyb20gXCIuL21pbl9vZi50c1wiO1xuXG5leHBvcnQgZnVuY3Rpb24gemlwPFQgZXh0ZW5kcyB1bmtub3duW10+KFxuICAuLi5hcnJheXM6IHsgW0sgaW4ga2V5b2YgVF06IFRbS11bXSB9XG4pOiBUW10ge1xuICBjb25zdCBtaW5MZW5ndGggPSBtaW5PZihhcnJheXMsIChpdCkgPT4gaXQubGVuZ3RoKSA/PyAwO1xuXG4gIGNvbnN0IHJldDogVFtdID0gbmV3IEFycmF5KG1pbkxlbmd0aCk7XG5cbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBtaW5MZW5ndGg7IGkgKz0gMSkge1xuICAgIGNvbnN0IGFyciA9IGFycmF5cy5tYXAoKGl0KSA9PiBpdFtpXSk7XG4gICAgcmV0W2ldID0gYXJyIGFzIFQ7XG4gIH1cblxuICByZXR1cm4gcmV0O1xufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLDBFQUEwRTtBQUMxRSxxQ0FBcUM7QUFFckM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Q0FtQkMsR0FFRCxTQUFTLEtBQUssUUFBUSxjQUFjO0FBRXBDLE9BQU8sU0FBUyxJQUNkLEdBQUcsTUFBa0MsRUFDaEM7SUFDTCxNQUFNLFlBQVksTUFBTSxRQUFRLENBQUMsS0FBTyxHQUFHLE1BQU0sS0FBSztJQUV0RCxNQUFNLE1BQVcsSUFBSSxNQUFNO0lBRTNCLElBQUssSUFBSSxJQUFJLEdBQUcsSUFBSSxXQUFXLEtBQUssRUFBRztRQUNyQyxNQUFNLE1BQU0sT0FBTyxHQUFHLENBQUMsQ0FBQyxLQUFPLEVBQUUsQ0FBQyxFQUFFO1FBQ3BDLEdBQUcsQ0FBQyxFQUFFLEdBQUc7SUFDWDtJQUVBLE9BQU87QUFDVCxDQUFDIn0=