/*
 * Decompiled with CFR 0.152.
 */
package infiniteinvo.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import infiniteinvo.achievements.InvoAchievements;
import infiniteinvo.core.II_Settings;
import infiniteinvo.core.InfiniteInvo;
import infiniteinvo.core.XPHelper;
import infiniteinvo.handlers.EventHandler;
import infiniteinvo.inventory.SlotLockable;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;

public class InvoPacket
implements IMessage {
    NBTTagCompound tags = new NBTTagCompound();

    public InvoPacket() {
    }

    public InvoPacket(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class HandleClient
    implements IMessageHandler<InvoPacket, IMessage> {
        public IMessage onMessage(InvoPacket message, MessageContext ctx) {
            if (message.tags.func_74764_b("ID") && message.tags.func_74762_e("ID") == 0) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                if (!message.tags.func_74764_b("Player") || !message.tags.func_74779_i("Player").equals(player.func_70005_c_())) {
                    InfiniteInvo.logger.log(Level.ERROR, "Server sent packet to the wrong player! Intended target: " + message.tags.func_74779_i("Player") + ", Recipient: " + player.func_70005_c_());
                    return null;
                }
                if (message.tags.func_74764_b("Unlocked")) {
                    InfiniteInvo.logger.log(Level.INFO, "Loading serverside unlocks...");
                    player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", message.tags.func_74762_e("Unlocked"));
                }
                if (message.tags.func_74764_b("Settings")) {
                    InfiniteInvo.logger.log(Level.INFO, "Loading serverside settings...");
                    II_Settings.LoadFromTags(message.tags.func_74775_l("Settings"));
                }
            }
            return null;
        }
    }

    public static class HandleServer
    implements IMessageHandler<InvoPacket, IMessage> {
        public IMessage onMessage(InvoPacket message, MessageContext ctx) {
            if (message.tags.func_74764_b("ID")) {
                if (message.tags.func_74762_e("ID") == 0) {
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                    if (world == null) {
                        return null;
                    }
                    EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                    if (player == null) {
                        return null;
                    }
                    int unlocked = player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED");
                    int cost = II_Settings.unlockCost + unlocked * II_Settings.unlockIncrease;
                    int totalXP = XPHelper.getPlayerXP(player);
                    if (totalXP >= (II_Settings.useOrbs ? cost : XPHelper.getLevelXP(cost))) {
                        if (II_Settings.useOrbs) {
                            XPHelper.AddXP(player, -cost);
                        } else {
                            XPHelper.AddXP(player, -XPHelper.getLevelXP(cost));
                        }
                        player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", ++unlocked);
                        EventHandler.unlockCache.put(player.func_70005_c_(), unlocked);
                        if (unlocked > 0 || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockFirst, 1);
                        }
                        if (unlocked + II_Settings.unlockedSlots == II_Settings.invoSize || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockAll, 1);
                        }
                        NBTTagCompound replyTags = new NBTTagCompound();
                        replyTags.func_74768_a("ID", 0);
                        replyTags.func_74778_a("Player", player.func_70005_c_());
                        replyTags.func_74768_a("Unlocked", unlocked);
                        return new InvoPacket(replyTags);
                    }
                } else {
                    if (message.tags.func_74762_e("ID") == 1) {
                        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                        if (world == null) {
                            InfiniteInvo.logger.log(Level.WARN, "Unlock Sync Failed! Reason: Unabled to locate dimension " + message.tags.func_74762_e("World"));
                            return null;
                        }
                        EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                        if (player == null || player.getEntityData() == null) {
                            InfiniteInvo.logger.log(Level.WARN, "Unlock Sync Failed! Reason: Unabled to get data for player '" + message.tags.func_74779_i("Player") + "'");
                            return null;
                        }
                        int unlocked = 0;
                        if (!player.getEntityData().func_74764_b("INFINITE_INVO_UNLOCKED") && (EventHandler.unlockCache.containsKey(player.func_70005_c_()) || EventHandler.unlockCache.containsKey(player.func_110124_au().toString()))) {
                            unlocked = EventHandler.unlockCache.containsKey(player.func_70005_c_()) ? EventHandler.unlockCache.get(player.func_70005_c_()) : EventHandler.unlockCache.get(player.func_110124_au().toString());
                            if (EventHandler.unlockCache.containsKey(player.func_70005_c_())) {
                                EventHandler.unlockCache.put(player.func_110124_au().toString(), unlocked);
                                EventHandler.unlockCache.remove(player.func_70005_c_());
                            }
                            player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", unlocked);
                        } else {
                            unlocked = player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED");
                            EventHandler.unlockCache.put(player.func_110124_au().toString(), unlocked);
                        }
                        if (unlocked > 0 || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockFirst, 1);
                        }
                        if (unlocked + II_Settings.unlockedSlots >= II_Settings.invoSize || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockAll, 1);
                        }
                        NBTTagCompound reply = new NBTTagCompound();
                        reply.func_74768_a("ID", 0);
                        reply.func_74778_a("Player", player.func_70005_c_());
                        reply.func_74768_a("Unlocked", unlocked);
                        reply.func_74782_a("Settings", (NBTBase)II_Settings.cachedSettings);
                        return new InvoPacket(reply);
                    }
                    if (message.tags.func_74762_e("ID") == 2) {
                        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                        if (world == null) {
                            InfiniteInvo.logger.log(Level.ERROR, "Custom Invo Sync Failed! Reason: Unabled to locate dimension " + message.tags.func_74762_e("World"));
                            return null;
                        }
                        EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                        int scrollPos = message.tags.func_74762_e("Scroll");
                        int[] indexes = message.tags.func_74759_k("Indexes");
                        int[] numbers = message.tags.func_74759_k("Numbers");
                        int conID = message.tags.func_74762_e("Container ID");
                        if (player == null || player.getEntityData() == null) {
                            InfiniteInvo.logger.log(Level.ERROR, "Custom Invo Sync Failed! Reason: Unabled to get data for player '" + message.tags.func_74779_i("Player") + "'");
                            return null;
                        }
                        Container container = player.field_71070_bA;
                        if (container.field_75152_c != conID) {
                            InfiniteInvo.logger.log(Level.ERROR, "Custom Invo Sync Failed! Server hasn't opened the matching container yet...");
                            return null;
                        }
                        if (container.field_75151_b.size() < numbers.length) {
                            InfiniteInvo.logger.log(Level.ERROR, "Custom Invo Sync Failed! Only found " + container.field_75151_b.size() + " / " + numbers.length + " requested slots");
                            return null;
                        }
                        boolean flag = true;
                        for (int i = 0; i < numbers.length; ++i) {
                            int sNum = numbers[i];
                            int sInx = indexes[i];
                            Slot s = (Slot)container.field_75151_b.get(sNum);
                            if (!(s.field_75224_c instanceof InventoryPlayer)) continue;
                            if (s.getClass() != Slot.class && s.getClass() != SlotLockable.class) {
                                InfiniteInvo.logger.log(Level.WARN, "Container " + container.getClass().getSimpleName() + " is not supported by InfiniteInvo! Reason: Custom Slots (" + s.getClass().getSimpleName() + ") are being used!");
                                return null;
                            }
                            if (!(s instanceof SlotLockable)) {
                                SlotLockable r = new SlotLockable(s.field_75224_c, sInx + scrollPos * 9, s.field_75223_e, s.field_75221_f);
                                container.field_75151_b.set(sNum, r);
                                r.field_75222_d = s.field_75222_d;
                                s = r;
                                container.field_75153_a.set(sNum, r.func_75211_c());
                                r.func_75218_e();
                            } else {
                                ((SlotLockable)s).field_75225_a = sInx + scrollPos * 9;
                            }
                            if (!flag || container.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c) != null) continue;
                            flag = false;
                            InfiniteInvo.logger.log(Level.WARN, "Slot broke at index " + s.getSlotIndex() + "(Scroll: " + scrollPos + ", Pass: " + i + "/" + numbers.length + ")");
                        }
                        container.func_75142_b();
                    }
                }
            }
            return null;
        }
    }
}

