/*
 * Decompiled with CFR 0.152.
 */
package infiniteinvo.client.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import infiniteinvo.core.II_Settings;
import infiniteinvo.core.InfiniteInvo;
import infiniteinvo.inventory.BigInventoryPlayer;
import infiniteinvo.inventory.SlotLockable;
import infiniteinvo.network.InvoPacket;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class InvoScrollBar
extends GuiButton {
    int refresh = 0;
    boolean creative = false;
    int maxScroll = 0;
    int scrollPos = 0;
    Container container;
    GuiContainer gui;
    int guiLeft = 0;
    int guiTop = 0;
    int[][] slotPos = new int[27][2];
    Slot[] invoSlots = new Slot[27];
    int[][] slotIndex = new int[2][27];
    int scrollX = 0;
    int scrollY = Integer.MAX_VALUE;
    boolean firstSync = false;
    int dragging = 0;

    public InvoScrollBar(int id, int posX, int posY, int width, int height, String title, Container container, GuiContainer gui) {
        super(id, posX, posY, width, height, title);
        this.container = container;
        this.gui = gui;
        this.creative = gui instanceof GuiContainerCreative;
        this.field_146124_l = false;
        this.refresh = 0;
        this.field_146124_l = this.creative ? this.InitCreative() : this.InitDefault();
        this.UpdateGuiPos();
    }

    public boolean InitDefault() {
        if (this.refresh > 0) {
            return this.field_146124_l;
        }
        this.refresh = 15;
        int index = 0;
        for (int i = 0; i < this.container.field_75151_b.size() && index < 27; ++i) {
            Slot s = (Slot)this.container.field_75151_b.get(i);
            if (!(s.field_75224_c instanceof InventoryPlayer) || s.getSlotIndex() < 9 || s.getSlotIndex() >= (II_Settings.invoSize < 27 ? 27 : II_Settings.invoSize) + 9) continue;
            if (s.getClass() != Slot.class && s.getClass() != SlotLockable.class) {
                InfiniteInvo.logger.log(Level.WARN, "Container " + this.container.getClass().getSimpleName() + " is not supported by InfiniteInvo! Reason: Custom Slots (" + s.getClass() + ") are being used!");
                return false;
            }
            SlotLockable r = new SlotLockable(s.field_75224_c, index + 9, s.field_75223_e, s.field_75221_f);
            this.container.field_75151_b.set(i, r);
            r.field_75222_d = s.field_75222_d;
            s = r;
            this.container.field_75153_a.set(i, r.func_75211_c());
            r.func_75218_e();
            this.invoSlots[index] = s;
            this.slotIndex[0][index] = s.getSlotIndex();
            this.slotIndex[1][index] = i;
            this.slotPos[index][0] = s.field_75223_e;
            this.slotPos[index][1] = s.field_75221_f;
            if (s.field_75223_e - 1 > this.scrollX) {
                this.scrollX = s.field_75223_e - 1;
            }
            if (s.field_75221_f - 1 < this.scrollY) {
                this.scrollY = s.field_75221_f - 1;
            }
            ++index;
        }
        this.container.func_75142_b();
        this.maxScroll = II_Settings.invoSize <= 27 ? 0 : MathHelper.func_76123_f((float)((float)(II_Settings.invoSize - 27) / 9.0f));
        return true;
    }

    public boolean InitCreative() {
        int i;
        if (this.refresh > 0) {
            return this.field_146124_l;
        }
        this.refresh = 15;
        ArrayList<Slot> slotList = new ArrayList<Slot>();
        ArrayList<int[]> indexList = new ArrayList<int[]>();
        for (i = 0; i < this.container.field_75151_b.size(); ++i) {
            Slot s = (Slot)this.container.field_75151_b.get(i);
            if (!(s.field_75224_c instanceof InventoryPlayer) || s.getSlotIndex() < 9 || s.getSlotIndex() >= II_Settings.invoSize + 27 || s.getSlotIndex() >= 36 && s.getSlotIndex() < 45) continue;
            slotList.add(s);
            int[] tmp = new int[]{s.getSlotIndex(), i};
            indexList.add(tmp);
            if (s.getSlotIndex() >= 36) {
                s.field_75223_e = -2000;
                s.field_75221_f = -2000;
                continue;
            }
            if (s.field_75223_e - 1 > this.scrollX) {
                this.scrollX = s.field_75223_e - 1;
            }
            if (s.field_75221_f - 1 >= this.scrollY) continue;
            this.scrollY = s.field_75221_f - 1;
        }
        this.invoSlots = slotList.toArray(new Slot[0]);
        this.slotIndex = new int[indexList.size()][2];
        for (i = 0; i < indexList.size(); ++i) {
            this.slotIndex[i] = (int[])indexList.get(i);
        }
        this.maxScroll = this.invoSlots.length <= 27 ? 0 : MathHelper.func_76123_f((float)((float)(this.invoSlots.length - 27) / 9.0f));
        return true;
    }

    public void UpdateGuiPos() {
        Field f2;
        Field f1;
        try {
            f1 = GuiContainer.class.getDeclaredField("field_147003_i");
            f2 = GuiContainer.class.getDeclaredField("field_147009_r");
        }
        catch (Exception e1) {
            try {
                f1 = GuiContainer.class.getDeclaredField("guiLeft");
                f2 = GuiContainer.class.getDeclaredField("guiTop");
            }
            catch (Exception e2) {
                InfiniteInvo.logger.log(Level.ERROR, "Unable to get gui positioning for GUI: ", (Throwable)e2);
                return;
            }
        }
        f1.setAccessible(true);
        f2.setAccessible(true);
        try {
            this.guiLeft = f1.getInt(this.gui);
            this.guiTop = f2.getInt(this.gui);
        }
        catch (Exception e) {
            InfiniteInvo.logger.log(Level.ERROR, "Unable to get gui positioning for GUI: ", (Throwable)e);
            return;
        }
    }

    public void func_146112_a(Minecraft mc, int mx, int my) {
        if (this.refresh > 0) {
            --this.refresh;
        }
        if (!this.field_146124_l) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.UpdateGuiPos();
        float tmp = Mouse.getDWheel();
        int scrollDX = (int)Math.signum(tmp);
        if (scrollDX != 0) {
            this.doScroll(scrollDX);
        } else if (Mouse.isButtonDown((int)0)) {
            boolean flag;
            int sx = this.guiLeft + this.scrollX + 20;
            int sy = this.guiTop + this.scrollY;
            boolean bl = flag = mx >= sx && my >= sy && mx < sx + 8 && my < sy + 54;
            if ((flag || this.dragging == 1) && this.dragging != -1) {
                this.dragging = 1;
                int preScroll = this.scrollPos;
                int tmpPos = MathHelper.func_76125_a((int)Math.round((float)(my - sy) / 54.0f * (float)this.maxScroll), (int)0, (int)this.maxScroll);
                if (preScroll - tmpPos != 0) {
                    this.doScroll(preScroll - tmpPos);
                }
            } else {
                this.dragging = -1;
            }
        } else {
            this.dragging = 0;
        }
        mc.func_110434_K().func_110577_a(new ResourceLocation("infiniteinvo", "textures/gui/adjustable_gui.png"));
        if (this.maxScroll > 0) {
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY, 52, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + 18, 44, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + 36, 36, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + Math.round((float)this.scrollPos / (float)this.maxScroll * 46.0f), 60, 166, 8, 8);
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by instanceof BigInventoryPlayer) {
            BigInventoryPlayer pinvo = (BigInventoryPlayer)Minecraft.func_71410_x().field_71439_g.field_71071_by;
            if (this.field_146124_l && (this.invoSlots.length <= 0 || this.invoSlots[0] == null)) {
                this.field_146124_l = this.creative ? this.InitCreative() : this.InitDefault();
                if (this.field_146124_l && this.invoSlots.length > 0 && this.invoSlots[0] != null) {
                    this.doScroll(0);
                }
                return;
            }
            if (!this.firstSync && !this.creative) {
                this.firstSync = true;
                this.scrollPos = 0;
                this.doScroll(0);
                return;
            }
            for (int i = 0; i < this.invoSlots.length; ++i) {
                Slot s = this.invoSlots[i];
                if (s == null) continue;
                if (this.creative) {
                    if (!this.container.field_75151_b.contains(s)) {
                        this.InitCreative();
                        return;
                    }
                    int j = this.slotIndex[i][1] - 9 * this.scrollPos - (s.getSlotIndex() >= 36 ? 9 : 0);
                    int k = j - 9;
                    int l = k % 9;
                    int i1 = k / 9;
                    s.field_75223_e = 9 + l * 18;
                    if (j >= 36 || j < 9) {
                        s.field_75221_f = -2000;
                        s.field_75223_e = -2000;
                        continue;
                    }
                    s.field_75221_f = 54 + i1 * 18;
                    continue;
                }
                if (!this.container.field_75151_b.contains(s)) {
                    this.InitDefault();
                    return;
                }
                if (s.getSlotIndex() - 9 >= II_Settings.invoSize) {
                    s.field_75223_e = -999;
                    s.field_75221_f = -999;
                    this.func_73729_b(this.slotPos[i][0] + this.guiLeft - 1, this.slotPos[i][1] + this.guiTop - 1, 0, 166, 18, 18);
                    continue;
                }
                if (pinvo.getUnlockedSlots() <= s.getSlotIndex()) {
                    s.field_75223_e = -999;
                    s.field_75221_f = -999;
                    this.func_73729_b(this.slotPos[i][0] + this.guiLeft - 1, this.slotPos[i][1] + this.guiTop - 1, 18, 166, 18, 18);
                    continue;
                }
                s.field_75223_e = this.slotPos[i][0];
                s.field_75221_f = this.slotPos[i][1];
            }
        }
    }

    public void doScroll(int scrollDX) {
        if (!this.field_146124_l) {
            return;
        }
        this.scrollPos -= (int)Math.signum(scrollDX);
        this.scrollPos = MathHelper.func_76125_a((int)this.scrollPos, (int)0, (int)this.maxScroll);
        if (!this.creative) {
            for (int i = 0; i < this.invoSlots.length; ++i) {
                Slot s = this.invoSlots[i];
                if (s == null || !(s instanceof SlotLockable)) continue;
                ((SlotLockable)s).field_75225_a = this.slotIndex[0][i] + this.scrollPos * 9;
                s.func_75218_e();
            }
            NBTTagCompound scrollTags = new NBTTagCompound();
            scrollTags.func_74768_a("ID", 2);
            scrollTags.func_74778_a("Player", Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            scrollTags.func_74768_a("World", Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.field_76574_g);
            scrollTags.func_74768_a("Scroll", this.scrollPos);
            scrollTags.func_74783_a("Indexes", this.slotIndex[0]);
            scrollTags.func_74783_a("Numbers", this.slotIndex[1]);
            scrollTags.func_74768_a("Container ID", this.container.field_75152_c);
            InfiniteInvo.instance.network.sendToServer((IMessage)new InvoPacket(scrollTags));
        }
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        return false;
    }
}

