/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEnderIsland
extends WorldGenerator {
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private int size;

    private void initialize(Random rand, int x, int y, int z) {
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
        this.size = 150;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        LogHelper.info("Generate");
        for (int y1 = y - 10; y1 < y + 10; ++y1) {
            if (world.func_147439_a(x, y1, z) != Blocks.field_150377_bs) continue;
            LogHelper.info("cancel");
            return false;
        }
        this.initialize(random, x, y, z);
        this.generateCentre(world, random);
        this.generateBelt(world, random, this.size + 50, this.size + 200);
        this.generateObelisks(world, random);
        EntityCustomDragon dragon = new EntityCustomDragon(world, 500.0, 100.0f);
        dragon.func_70634_a(x, 180.0, z);
        dragon.setUber(true);
        dragon.portalX = x;
        dragon.portalY = y + 20;
        dragon.portalZ = z;
        dragon.func_94058_c("Chaos Guardian");
        LogHelper.info("Spawn dragon");
        world.func_72838_d((Entity)dragon);
        return true;
    }

    private void generateCentre(World world, Random rand) {
        int centreThikness = 10;
        int curve = 2;
        int diffStart = 20;
        int r = this.size;
        int offPoint = this.size * curve;
        for (int x = this.spawnX - r; x <= this.spawnX + r; ++x) {
            for (int z = this.spawnZ - r; z <= this.spawnZ + r; ++z) {
                for (int y = this.spawnY - r / 2; y <= this.spawnY + r / 2; ++y) {
                    if ((int)WorldGenEnderIsland.getDistance(x, y, z, this.spawnX, this.spawnY + offPoint + centreThikness, this.spawnZ) < offPoint || (int)WorldGenEnderIsland.getDistance(x, y, z, this.spawnX, this.spawnY - offPoint - centreThikness, this.spawnZ) < offPoint || (int)WorldGenEnderIsland.getDistance(x, y, z, this.spawnX, this.spawnY, this.spawnZ) > r) continue;
                    int dist = (int)WorldGenEnderIsland.getDistance(x, y, z, this.spawnX, this.spawnY, this.spawnZ);
                    int diffusionPCt = this.getDiffusionPct(dist - diffStart, this.size - diffStart);
                    int yRand = (int)(Math.max(0.0, this.getDiffusionPctD(dist - 40, this.size - 40)) * (double)(40 - rand.nextInt(80)));
                    if (dist <= diffStart) {
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.3) && diffusionPCt > rand.nextInt(3000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.4) && diffusionPCt > rand.nextInt(4000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.5) && diffusionPCt > rand.nextInt(5000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.6) && diffusionPCt > rand.nextInt(6000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.7) && diffusionPCt > rand.nextInt(7000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (dist < (int)((double)this.size * 0.8) && diffusionPCt > rand.nextInt(8000)) {
                        if (0.95f > rand.nextFloat()) {
                            if (!world.func_147437_c(x, y + yRand, z)) continue;
                            world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                            continue;
                        }
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (diffusionPCt <= rand.nextInt(9000)) continue;
                    if (0.95f > rand.nextFloat()) {
                        if (!world.func_147437_c(x, y + yRand, z)) continue;
                        world.func_147465_d(x, y + yRand, z, Blocks.field_150377_bs, 0, 2);
                        continue;
                    }
                    if (!world.func_147437_c(x, y + yRand, z)) continue;
                    world.func_147465_d(x, y + yRand, z, Blocks.field_150343_Z, 0, 2);
                }
            }
        }
    }

    private int getDiffusionPct(int dist, int maxDist) {
        double d = (double)dist / (double)maxDist;
        int i = Math.max(1, (int)(d * 1000.0));
        return 1000 - i;
    }

    private double getDiffusionPctD(int dist, int maxDist) {
        double d = (double)dist / (double)maxDist;
        return d;
    }

    private void generateObelisks(World world, Random rand) {
        int sZ;
        int sX;
        double rotation;
        int i;
        for (i = 0; i < 7; ++i) {
            rotation = (double)i * 0.9;
            sX = this.spawnX + (int)(Math.sin(rotation) * 35.0);
            sZ = this.spawnZ + (int)(Math.cos(rotation) * 35.0);
            this.generateObelisk(world, sX, this.spawnY + 10, sZ, false, rand);
        }
        for (i = 0; i < 14; ++i) {
            rotation = (double)i * 0.45;
            sX = this.spawnX + (int)(Math.sin(rotation) * 70.0);
            sZ = this.spawnZ + (int)(Math.cos(rotation) * 70.0);
            this.generateObelisk(world, sX, this.spawnY + 10, sZ, true, rand);
        }
    }

    private void generateObelisk(World world, int x1, int y1, int z1, boolean outer, Random rand) {
        if (!outer) {
            world.func_147465_d(x1, y1 + 20, z1, Blocks.field_150357_h, 0, 2);
            if (!world.field_72995_K) {
                EntityEnderCrystal crystal = new EntityEnderCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, (double)(y1 + 21), (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            for (int y = y1; y < y1 + 20; ++y) {
                world.func_147465_d(x1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
            }
        } else {
            int z;
            int y;
            world.func_147465_d(x1, y1 + 40, z1, Blocks.field_150357_h, 0, 2);
            if (!world.field_72995_K) {
                EntityEnderCrystal crystal = new EntityEnderCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, (double)(y1 + 41), (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            int diff = 0;
            for (int y2 = y1 + 20; y2 < y1 + 40; ++y2) {
                double pct = (double)(++diff) / 25.0;
                int r = 3;
                for (int x = x1 - r; x <= x1 + r; ++x) {
                    for (int z2 = z1 - r; z2 <= z1 + r; ++z2) {
                        if (!(WorldGenEnderIsland.getDistance(x, z2, x1, z1) <= (double)r) || !(pct > rand.nextDouble())) continue;
                        world.func_147465_d(x, y2, z2, Blocks.field_150343_Z, 0, 2);
                    }
                }
            }
            int cageS = 2;
            for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_147465_d(x, y + 41, z1 + cageS, Blocks.field_150411_aY, 0, 2);
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x, y + 41, z1 - cageS, Blocks.field_150411_aY, 0, 2);
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_147465_d(x1 + cageS, y + 41, z, Blocks.field_150411_aY, 0, 2);
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x1 - cageS, y + 41, z, Blocks.field_150411_aY, 0, 2);
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x, y1 + 44, z, (Block)Blocks.field_150333_U, 6, 2);
                }
            }
        }
    }

    private void generateBelt(World world, Random random, int innerRadius, int outerRadius) {
        int r = outerRadius;
        for (int x = this.spawnX - r; x <= this.spawnX + r; ++x) {
            for (int z = this.spawnZ - r; z <= this.spawnZ + r; ++z) {
                int dist = (int)WorldGenEnderIsland.getDistance(x, z, this.spawnX, this.spawnZ);
                if (dist >= outerRadius || dist < innerRadius) continue;
                int y = this.spawnY + (int)((double)(this.spawnX - x) * 0.2) + (random.nextInt(10) - 5);
                if (0.1f > random.nextFloat()) {
                    world.func_147465_d(x, y, z, Blocks.field_150377_bs, 0, 2);
                }
                if (!(0.001f > random.nextFloat())) continue;
                world.func_147465_d(x, y, z, (Block)ModBlocks.draconiumOre, 0, 2);
            }
        }
    }

    public static double getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistance(int x1, int z1, int x2, int z2) {
        int dx = x1 - x2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }
}

