/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.entity;

import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import com.brandon3055.draconicevolution.common.utills.Utills;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityChaosDrill
extends Entity {
    public int MAX_AGE = 300;
    private int ENTITY_AGE = 0;
    private EntityPlayer PLAYER;

    public EntityChaosDrill(World world) {
        super(world);
    }

    public EntityChaosDrill(World world, EntityPlayer player) {
        super(world);
        this.PLAYER = player;
        this.func_70105_a(0.1f, 0.1f);
        this.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70088_a() {
        LogHelper.info("entityInit");
    }

    public void func_70071_h_() {
        this.mineNextBlockInPattern();
        this.entityTick();
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    private void entityTick() {
        if (this.ENTITY_AGE >= this.MAX_AGE) {
            this.func_70106_y();
        }
        ++this.ENTITY_AGE;
    }

    private void mineNextBlockInPattern() {
        ArrayList<MultiblockHelper.TileLocation> blocks = this.getBlocksInSphere(5);
        LogHelper.info(blocks.size());
        if (blocks.size() > 0) {
            this.field_70170_p.func_147468_f(blocks.get(1).getXCoord(), blocks.get(1).getYCoord(), blocks.get(1).getZCoord());
        }
    }

    private ArrayList<MultiblockHelper.TileLocation> getBlocksInSphere(int r) {
        ArrayList<MultiblockHelper.TileLocation> blocks = new ArrayList<MultiblockHelper.TileLocation>();
        int minDist = 100;
        for (int x = (int)this.field_70165_t - r; x <= (int)this.field_70165_t + r; ++x) {
            for (int z = (int)this.field_70161_v - r; z <= (int)this.field_70161_v + r; ++z) {
                for (int y = (int)this.field_70163_u - r; y <= (int)this.field_70163_u + r; ++y) {
                    int dist = (int)Utills.getDistanceAtoB(x, y, z, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                    if (dist > r || this.field_70170_p.func_147437_c(x, y, z)) continue;
                    if (blocks.size() <= dist) {
                        blocks.add(new MultiblockHelper.TileLocation(x, y, z));
                    } else {
                        blocks.set(dist, new MultiblockHelper.TileLocation(x, y, z));
                    }
                    if (dist >= minDist) continue;
                    minDist = dist;
                }
            }
        }
        LogHelper.info("dist: " + minDist);
        return blocks;
    }
}

