/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.common;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import glassmaker.extratic.metals.MoltenMetalBucketItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BucketHandler {
    private static BucketHandler INSTANCE = new BucketHandler();
    private static HashMap<Block, ItemStack> FILLED_BUCKETS = new HashMap();

    public static BucketHandler getInstance() {
        return INSTANCE;
    }

    public static void addBuckets() {
        ItemStack bucketStack;
        int bucketId;
        MoltenMetalBucketItem bucket = new MoltenMetalBucketItem(null);
        GameRegistry.registerItem((Item)bucket, (String)"extra.bucket");
        int bucketVol = 1000;
        ItemStack emptyBucketStack = FluidContainerRegistry.EMPTY_BUCKET.func_77946_l();
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)"fairy.molten", (int)bucketVol);
        if (fluidStack != null) {
            bucketId = 1;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_fairy");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"refined.glowstone.molten", (int)bucketVol)) != null) {
            bucketId = 2;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_glowstone");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"osmium.molten", (int)bucketVol)) != null) {
            bucketId = 3;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_osmium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"pokefennium.molten", (int)bucketVol)) != null) {
            bucketId = 4;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_pokefennium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
    }

    public void fillEvent(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        ItemStack bucketStack = BucketHandler.getFilledBucket(block);
        if (bucketStack == null) {
            return;
        }
        world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        event.result = bucketStack;
        event.setResult(Event.Result.ALLOW);
    }

    public static HashMap<Block, ItemStack> getAllBuckets() {
        return FILLED_BUCKETS;
    }

    public static ItemStack getFilledBucket(Block fluidBlock) {
        return FILLED_BUCKETS.get(fluidBlock);
    }

    public static ItemStack getFilledBucket(String fluidName) {
        Block fluidBlock = FluidRegistry.getFluid((String)fluidName).getBlock();
        return FILLED_BUCKETS.get(fluidBlock).func_77946_l();
    }

    public static boolean isAvailableBucket(int fluidBlockId) {
        return FILLED_BUCKETS.containsKey(fluidBlockId);
    }

    public static boolean isAvailableBucket(String fluidName) {
        Block fluidBlock = FluidRegistry.getFluid((String)fluidName).getBlock();
        return FILLED_BUCKETS.containsKey(fluidBlock);
    }

    public static Block getBlock(ItemStack bucketStack) {
        Block block = Blocks.field_150350_a;
        for (Map.Entry<Block, ItemStack> entry : FILLED_BUCKETS.entrySet()) {
            ItemStack stack = entry.getValue();
            if (!stack.func_77969_a(bucketStack)) continue;
            block = entry.getKey();
            break;
        }
        return block;
    }
}

