/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartP2PLiquids
extends PartP2PTunnel<PartP2PLiquids>
implements IFluidHandler {
    static final ThreadLocal<Stack<PartP2PLiquids>> DEPTH = new ThreadLocal();
    private static final FluidTankInfo[] ACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 10000)};
    private static final FluidTankInfo[] INACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 0)};
    IFluidHandler cachedTank;
    private int tmpUsed;

    public PartP2PLiquids(ItemStack is) {
        super(is);
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150368_y.func_149733_h(0);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.cachedTank = null;
    }

    @Override
    public void onNeighborChanged() {
        PartP2PLiquids in;
        this.cachedTank = null;
        if (this.output && (in = (PartP2PLiquids)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Stack<PartP2PLiquids> stack = this.getDepth();
        for (PartP2PLiquids t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<PartP2PLiquids> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<PartP2PLiquids> i = list.iterator();
        while (i.hasNext()) {
            PartP2PLiquids l = i.next();
            IFluidHandler tank = l.getTarget();
            l.tmpUsed = tank != null ? tank.fill(l.side.getOpposite(), resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new RuntimeException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (!doFill) {
            if (stack.pop() != this) {
                throw new RuntimeException("Invalid Recursion detected.");
            }
            return Math.min(resource.amount, requestTotal);
        }
        int available = resource.amount;
        int used = 0;
        for (PartP2PLiquids l : list) {
            IFluidHandler tank;
            FluidStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > available) {
                insert.amount = available;
            }
            l.tmpUsed = (tank = l.getTarget()) != null ? tank.fill(l.side.getOpposite(), insert.copy(), true) : 0;
            available -= insert.amount;
            used += insert.amount;
        }
        if (stack.pop() != this) {
            throw new RuntimeException("Invalid Recursion detected.");
        }
        return used;
    }

    private Stack<PartP2PLiquids> getDepth() {
        Stack<PartP2PLiquids> s = DEPTH.get();
        if (s == null) {
            s = new Stack();
            DEPTH.set(s);
        }
        return s;
    }

    List<PartP2PLiquids> getOutputs(Fluid input) {
        LinkedList<PartP2PLiquids> outs = new LinkedList<PartP2PLiquids>();
        try {
            for (PartP2PLiquids l : this.getOutputs()) {
                IFluidHandler handler = l.getTarget();
                if (handler == null || !handler.canFill(l.side.getOpposite(), input)) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    IFluidHandler getTarget() {
        if (!this.proxy.isActive()) {
            return null;
        }
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.tile.func_145831_w().func_147438_o(this.tile.field_145851_c + this.side.offsetX, this.tile.field_145848_d + this.side.offsetY, this.tile.field_145849_e + this.side.offsetZ);
        if (te instanceof IFluidHandler) {
            this.cachedTank = (IFluidHandler)te;
            return this.cachedTank;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.output && from == this.side && !this.getOutputs(fluid).isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == this.side) {
            return this.getTank();
        }
        return new FluidTankInfo[0];
    }

    private FluidTankInfo[] getTank() {
        if (this.output) {
            PartP2PLiquids tun = (PartP2PLiquids)this.getInput();
            if (tun != null) {
                return ACTIVE_TANK;
            }
        } else {
            try {
                if (!this.getOutputs().isEmpty()) {
                    return ACTIVE_TANK;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return INACTIVE_TANK;
    }
}

