/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.entity.AEBaseEntityItem;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public final class EntityChargedQuartz
extends AEBaseEntityItem {
    int delay = 0;
    int transformTime = 0;

    public EntityChargedQuartz(World w) {
        super(w);
    }

    public EntityChargedQuartz(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.inWorldFluix)) {
            return;
        }
        if (Platform.isClient() && this.delay > 30 && AEConfig.instance.enableEffects) {
            CommonHelper.proxy.spawnEffect(EffectType.Lightning, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, null);
            this.delay = 0;
        }
        ++this.delay;
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int i = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        Material mat = this.field_70170_p.func_147439_a(j, i, k).func_149688_o();
        if (Platform.isServer() && mat.func_76224_d()) {
            ++this.transformTime;
            if (this.transformTime > 60 && !this.transform()) {
                this.transformTime = 0;
            }
        } else {
            this.transformTime = 0;
        }
    }

    public boolean transform() {
        ItemStack item = this.func_92059_d();
        IMaterials materials = AEApi.instance().definitions().materials();
        if (materials.certusQuartzCrystalCharged().isSameAs(item)) {
            AxisAlignedBB region = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 1.0), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - 1.0), (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0));
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            EntityItem redstone = null;
            EntityItem netherQuartz = null;
            for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof EntityItem) || e.field_70128_L || (other = ((EntityItem)e).func_92059_d()) == null || other.field_77994_a <= 0) continue;
                if (Platform.isSameItem(other, new ItemStack(Items.field_151137_ax))) {
                    redstone = (EntityItem)e;
                }
                if (!Platform.isSameItem(other, new ItemStack(Items.field_151128_bU))) continue;
                netherQuartz = (EntityItem)e;
            }
            if (redstone != null && netherQuartz != null) {
                --this.func_92059_d().field_77994_a;
                --redstone.func_92059_d().field_77994_a;
                --netherQuartz.func_92059_d().field_77994_a;
                if (this.func_92059_d().field_77994_a <= 0) {
                    this.func_70106_y();
                }
                if (redstone.func_92059_d().field_77994_a <= 0) {
                    redstone.func_70106_y();
                }
                if (netherQuartz.func_92059_d().field_77994_a <= 0) {
                    netherQuartz.func_70106_y();
                }
                for (ItemStack fluixCrystalStack : materials.fluixCrystal().maybeStack(2).asSet()) {
                    EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, fluixCrystalStack);
                    this.field_70170_p.func_72838_d((Entity)entity);
                }
                return true;
            }
        }
        return false;
    }
}

