/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.client.render.AppEngRenderItem;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketSwapSlots;
import appeng.helpers.InventoryAction;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.INEI;
import appeng.util.Platform;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class AEBaseGui
extends GuiContainer {
    public static boolean switchingGuis;
    protected final List<InternalSlotME> meSlots = new LinkedList<InternalSlotME>();
    final Set<Slot> drag_click = new HashSet<Slot>();
    final AppEngRenderItem aeRenderItem = new AppEngRenderItem();
    protected GuiScrollbar myScrollBar = null;
    boolean disableShiftClick = false;
    Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    ItemStack dbl_whichItem;
    Slot bl_clicked;
    boolean useNEI = false;
    private boolean subGui = switchingGuis;

    public AEBaseGui(Container container) {
        super(container);
        switchingGuis = false;
    }

    protected static String join(Collection<String> toolTip, String delimiter) {
        Joiner joiner = Joiner.on((String)delimiter);
        return joiner.join(toolTip);
    }

    protected int getQty(GuiButton btn) {
        try {
            DecimalFormat df = new DecimalFormat("+#;-#");
            return df.parse(btn.field_146126_j).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public boolean isSubGui() {
        return this.subGui;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        List<Slot> slots = this.getInventorySlots();
        Iterator<Slot> i = slots.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof SlotME)) continue;
            i.remove();
        }
        for (InternalSlotME me : this.meSlots) {
            slots.add(new SlotME(me));
        }
    }

    private List<Slot> getInventorySlots() {
        return this.field_147002_h.field_75151_b;
    }

    public void func_73863_a(int mouse_x, int mouse_y, float btn) {
        super.func_73863_a(mouse_x, mouse_y, btn);
        boolean hasClicked = Mouse.isButtonDown((int)0);
        if (hasClicked && this.myScrollBar != null) {
            this.myScrollBar.click(this, mouse_x - this.field_147003_i, mouse_y - this.field_147009_r);
        }
        for (Object c : this.field_146292_n) {
            String msg;
            if (!(c instanceof ITooltip)) continue;
            ITooltip tooltip = (ITooltip)c;
            int x = tooltip.xPos();
            int y = tooltip.yPos();
            if (x >= mouse_x || x + tooltip.getWidth() <= mouse_x || !tooltip.isVisible() || y >= mouse_y || y + tooltip.getHeight() <= mouse_y) continue;
            if (y < 15) {
                y = 15;
            }
            if ((msg = tooltip.getMessage()) == null) continue;
            this.drawTooltip(x + 11, y + 4, 0, msg);
        }
    }

    public void drawTooltip(int par2, int par3, int forceWidth, String Msg) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        String[] var4 = Msg.split("\n");
        if (var4.length > 0) {
            int var7;
            int var6;
            int var5 = 0;
            for (var6 = 0; var6 < var4.length; ++var6) {
                var7 = this.field_146289_q.func_78256_a(var4[var6]);
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = par2 + 12;
            var7 = par3 - 12;
            int var9 = 8;
            if (var4.length > 1) {
                var9 += 2 + (var4.length - 1) * 10;
            }
            if (this.field_147009_r + var7 + var9 + 6 > this.field_146295_m) {
                var7 = this.field_146295_m - var9 - this.field_147009_r - 6;
            }
            if (forceWidth > 0) {
                var5 = forceWidth;
            }
            this.field_73735_i = 300.0f;
            AEBaseGui.field_146296_j.field_77023_b = 300.0f;
            int var10 = -267386864;
            this.func_73733_a(var6 - 3, var7 - 4, var6 + var5 + 3, var7 - 3, var10, var10);
            this.func_73733_a(var6 - 3, var7 + var9 + 3, var6 + var5 + 3, var7 + var9 + 4, var10, var10);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 + var9 + 3, var10, var10);
            this.func_73733_a(var6 - 4, var7 - 3, var6 - 3, var7 + var9 + 3, var10, var10);
            this.func_73733_a(var6 + var5 + 3, var7 - 3, var6 + var5 + 4, var7 + var9 + 3, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            this.func_73733_a(var6 - 3, var7 - 3 + 1, var6 - 3 + 1, var7 + var9 + 3 - 1, var11, var12);
            this.func_73733_a(var6 + var5 + 2, var7 - 3 + 1, var6 + var5 + 3, var7 + var9 + 3 - 1, var11, var12);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 - 3 + 1, var11, var11);
            this.func_73733_a(var6 - 3, var7 + var9 + 2, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            for (int var13 = 0; var13 < var4.length; ++var13) {
                String var14 = var4[var13];
                var14 = var13 == 0 ? '\u00a7' + Integer.toHexString(15) + var14 : "\u00a77" + var14;
                this.field_146289_q.func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            this.field_73735_i = 0.0f;
            AEBaseGui.field_146296_j.field_77023_b = 0.0f;
        }
        GL11.glPopAttrib();
    }

    protected final void func_146979_b(int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.myScrollBar != null) {
            this.myScrollBar.draw(this);
        }
        this.drawFG(ox, oy, x, y);
    }

    public abstract void drawFG(int var1, int var2, int var3, int var4);

    protected final void func_146976_a(float f, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(ox, oy, x, y);
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            OptionalSlotFake fs;
            if (!(slot instanceof OptionalSlotFake) || !(fs = (OptionalSlotFake)slot).renderDisabled()) continue;
            if (fs.isEnabled()) {
                this.func_73729_b(ox + fs.field_75223_e - 1, oy + fs.field_75221_f - 1, fs.srcX - 1, fs.srcY - 1, 18, 18);
                continue;
            }
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GL11.glEnable((int)3042);
            this.func_73729_b(ox + fs.field_75223_e - 1, oy + fs.field_75221_f - 1, fs.srcX - 1, fs.srcY - 1, 18, 18);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopAttrib();
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.drag_click.clear();
        if (btn == 1) {
            for (Object o : this.field_146292_n) {
                GuiButton guibutton = (GuiButton)o;
                if (!guibutton.func_146116_c(this.field_146297_k, xCoord, yCoord)) continue;
                super.func_73864_a(xCoord, yCoord, 0);
                return;
            }
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146273_a(int x, int y, int c, long d) {
        Slot slot = this.getSlot(x, y);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (slot instanceof SlotFake && itemstack != null) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (Slot dr : this.drag_click) {
                    PacketInventoryAction p = new PacketInventoryAction(c == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_75222_d, 0L);
                    NetworkHandler.instance.sendToServer(p);
                }
            }
        } else {
            super.func_146273_a(x, y, c, d);
        }
    }

    protected void func_146984_a(Slot slot, int slotIdx, int ctrlDown, int key) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (slot instanceof SlotFake) {
            InventoryAction action;
            InventoryAction inventoryAction = action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (slot instanceof SlotPatternTerm) {
            if (key == 6) {
                return;
            }
            try {
                NetworkHandler.instance.sendToServer(((SlotPatternTerm)slot).getRequest(key == 1));
            }
            catch (IOException e) {
                AELog.error(e);
            }
        } else if (slot instanceof SlotCraftingTerm) {
            if (key == 6) {
                return;
            }
            InventoryAction action = null;
            action = key == 1 ? InventoryAction.CRAFT_SHIFT : (ctrlDown == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (Keyboard.isKeyDown((int)57) && this.enableSpaceClicking()) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = this.getInventorySlots().size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance.sendToServer(p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            InventoryAction action = null;
            switch (key) {
                case 0: {
                    action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case 3: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PacketInventoryAction p = new PacketInventoryAction(action, slot.getSlotIndex(), ((SlotDisconnected)slot).mySlot.id);
                NetworkHandler.instance.sendToServer(p);
            }
            return;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (key) {
                case 0: {
                    action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || player.field_71071_by.func_70445_o() != null) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case 3: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, this.getInventorySlots().size(), 0L);
                NetworkHandler.instance.sendToServer(p);
            }
            return;
        }
        if (!this.disableShiftClick && AEBaseGui.func_146272_n()) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem == null || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 150L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot != null ? (slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : null) : null;
            } else if (this.dbl_whichItem != null) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !inventorySlot.func_75216_d() || inventorySlot.field_75224_c != slot.field_75224_c || !Container.func_94527_a((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.func_146984_a(inventorySlot, inventorySlot.field_75222_d, ctrlDown, 1);
                }
            }
            this.disableShiftClick = false;
        }
        super.func_146984_a(slot, slotIdx, ctrlDown, key);
    }

    protected boolean func_146983_a(int p_146983_1_) {
        Slot theSlot;
        try {
            theSlot = (Slot)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((Object)this), (String[])new String[]{"theSlot", "field_147006_u", "f"});
        }
        catch (Throwable t) {
            return false;
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (p_146983_1_ != this.field_146297_k.field_71474_y.field_151456_ac[j].func_151463_i()) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv() || s.func_82869_a(((AEBaseContainer)this.field_147002_h).getPlayerInv().field_70458_d)) continue;
                    return false;
                }
                if (theSlot.func_75219_a() == 64) {
                    this.func_146984_a(theSlot, theSlot.field_75222_d, j, 2);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv()) continue;
                    NetworkHandler.instance.sendToServer(new PacketSwapSlots(s.field_75222_d, theSlot.field_75222_d));
                    return true;
                }
            }
        }
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.subGui = true;
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public abstract void drawBG(int var1, int var2, int var3, int var4);

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && AEBaseGui.func_146272_n()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseWheelEvent(x, y, i / Math.abs(i));
        } else if (i != 0 && this.myScrollBar != null) {
            this.myScrollBar.wheel(i);
        }
    }

    protected void mouseWheelEvent(int x, int y, int wheel) {
        IAEItemStack item;
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotME && (item = ((SlotME)slot).getAEStack()) != null) {
            ((AEBaseContainer)this.field_147002_h).setTargetStack(item);
            InventoryAction direction = wheel > 0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = Math.abs(wheel);
            int inventorySize = this.getInventorySlots().size();
            for (int h = 0; h < times; ++h) {
                PacketInventoryAction p = new PacketInventoryAction(direction, inventorySize, 0L);
                NetworkHandler.instance.sendToServer(p);
            }
        }
    }

    protected boolean enableSpaceClicking() {
        return true;
    }

    public void bindTexture(String base, String file) {
        ResourceLocation loc = new ResourceLocation(base, "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    protected void drawItem(int x, int y, ItemStack is) {
        this.field_73735_i = 100.0f;
        AEBaseGui.field_146296_j.field_77023_b = 100.0f;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, is, x, y);
        GL11.glPopAttrib();
        AEBaseGui.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected String getGuiDisplayName(String in) {
        return this.hasCustomInventoryName() ? this.getInventoryName() : in;
    }

    private boolean hasCustomInventoryName() {
        if (this.field_147002_h instanceof AEBaseContainer) {
            return ((AEBaseContainer)this.field_147002_h).customName != null;
        }
        return false;
    }

    private String getInventoryName() {
        return ((AEBaseContainer)this.field_147002_h).customName;
    }

    public void a(Slot s) {
        this.drawSlot(s);
    }

    public void drawSlot(Slot s) {
        if (s instanceof SlotME) {
            RenderItem pIR;
            block17: {
                pIR = this.setItemRender(this.aeRenderItem);
                try {
                    this.field_73735_i = 100.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 100.0f;
                    if (!this.isPowered()) {
                        GL11.glDisable((int)2896);
                        AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                        GL11.glEnable((int)2896);
                    }
                    this.field_73735_i = 0.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 0.0f;
                    this.aeRenderItem.aeStack = ((SlotME)s).getAEStack();
                    this.safeDrawSlot(s);
                }
                catch (Exception err) {
                    AELog.warning("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
                    if (!Platform.isDrawing(Tessellator.field_78398_a)) break block17;
                    Tessellator.field_78398_a.func_78381_a();
                }
            }
            this.setItemRender(pIR);
            return;
        }
        try {
            AppEngSlot aes;
            ItemStack is = s.func_75211_c();
            if (s instanceof AppEngSlot && (((AppEngSlot)s).renderIconWithItem() || is == null) && ((AppEngSlot)s).shouldDisplay() && (aes = (AppEngSlot)s).getIcon() >= 0) {
                block18: {
                    this.bindTexture("guis/states.png");
                    GL11.glPushAttrib((int)1048575);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    try {
                        int uv_y = (int)Math.floor(aes.getIcon() / 16);
                        int uv_x = aes.getIcon() - uv_y * 16;
                        GL11.glEnable((int)3042);
                        GL11.glDisable((int)2896);
                        GL11.glEnable((int)3553);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        float par1 = aes.field_75223_e;
                        float par2 = aes.field_75221_f;
                        float par3 = uv_x * 16;
                        float par4 = uv_y * 16;
                        float par5 = 16.0f;
                        float par6 = 16.0f;
                        float f = 0.00390625f;
                        float f1 = 0.00390625f;
                        tessellator.func_78382_b();
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon());
                        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + 0.0f) * f), (double)((par4 + par6) * f1));
                        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + par5) * f), (double)((par4 + par6) * f1));
                        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + par5) * f), (double)((par4 + 0.0f) * f1));
                        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + 0.0f) * f), (double)((par4 + 0.0f) * f1));
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
                        tessellator.func_78381_a();
                    }
                    catch (Exception err) {
                        if (!Platform.isDrawing(tessellator)) break block18;
                        tessellator.func_78381_a();
                    }
                }
                GL11.glPopAttrib();
            }
            if (is != null && s instanceof AppEngSlot) {
                if (((AppEngSlot)s).isValid == AppEngSlot.hasCalculatedValidness.NotAvailable) {
                    boolean isValid;
                    boolean bl = isValid = s.func_75214_a(is) || s instanceof SlotOutput || s instanceof AppEngCraftingSlot || s instanceof SlotDisabled || s instanceof SlotInaccessible || s instanceof SlotFake || s instanceof SlotRestrictedInput || s instanceof SlotDisconnected;
                    if (isValid && s instanceof SlotRestrictedInput) {
                        try {
                            isValid = ((SlotRestrictedInput)s).isValid(is, (World)this.field_146297_k.field_71441_e);
                        }
                        catch (Exception err) {
                            AELog.error(err);
                        }
                    }
                    AppEngSlot.hasCalculatedValidness hasCalculatedValidness2 = ((AppEngSlot)s).isValid = isValid ? AppEngSlot.hasCalculatedValidness.Valid : AppEngSlot.hasCalculatedValidness.Invalid;
                }
                if (((AppEngSlot)s).isValid == AppEngSlot.hasCalculatedValidness.Invalid) {
                    this.field_73735_i = 100.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 100.0f;
                    GL11.glDisable((int)2896);
                    AEBaseGui.func_73734_a((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66FF6666);
                    GL11.glEnable((int)2896);
                    this.field_73735_i = 0.0f;
                    AEBaseGui.field_146296_j.field_77023_b = 0.0f;
                }
            }
            if (s instanceof AppEngSlot) {
                ((AppEngSlot)s).isDisplay = true;
                this.safeDrawSlot(s);
            } else {
                this.safeDrawSlot(s);
            }
            return;
        }
        catch (Exception err) {
            AELog.warning("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            this.safeDrawSlot(s);
            return;
        }
    }

    private RenderItem setItemRender(RenderItem item) {
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.NEI)) {
            return ((INEI)AppEng.instance.getIntegration(IntegrationType.NEI)).setItemRender(item);
        }
        RenderItem ri = field_146296_j;
        field_146296_j = item;
        return ri;
    }

    protected boolean isPowered() {
        return true;
    }

    private void safeDrawSlot(Slot s) {
        block2: {
            try {
                GuiContainer.class.getDeclaredMethod("func_146977_a_original", Slot.class).invoke((Object)this, s);
            }
            catch (Exception err) {
                Tessellator tessellator = Tessellator.field_78398_a;
                if (!Platform.isDrawing(tessellator)) break block2;
                tessellator.func_78381_a();
            }
        }
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public void func_146977_a(Slot s) {
        this.drawSlot(s);
    }
}

