/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.rftools.RFTools;
import mcjty.rftools.network.ClientCommandHandler;
import mcjty.rftools.network.NetworkTools;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class PacketIntegerFromServer
implements IMessage,
IMessageHandler<PacketIntegerFromServer, IMessage> {
    private int x;
    private int y;
    private int z;
    private Integer result;
    private String command;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.command = NetworkTools.readString(buf);
        boolean resultPresent = buf.readBoolean();
        this.result = resultPresent ? Integer.valueOf(buf.readInt()) : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        NetworkTools.writeString(buf, this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            buf.writeInt(this.result.intValue());
        }
    }

    public PacketIntegerFromServer() {
    }

    public PacketIntegerFromServer(int x, int y, int z, String command, Integer result) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.command = command;
        this.result = result;
    }

    public IMessage onMessage(PacketIntegerFromServer message, MessageContext ctx) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof ClientCommandHandler)) {
            RFTools.log("createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
            return null;
        }
        ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
        if (!clientCommandHandler.execute(message.command, message.result)) {
            RFTools.log("Command " + message.command + " was not handled!");
        }
        return null;
    }
}

