/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.items.netmonitor.PacketGetConnectedBlocks;
import mcjty.rftools.network.PacketHandler;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class GuiNetworkMonitor
extends GuiScreen {
    private Map<Coordinate, BlockInfo> connectedBlocks;
    private Map<Coordinate, EnergyBar> labelMap;
    private Map<Coordinate, Integer> previousRf = null;
    private long previousRfMillis = 0L;
    private Map<Integer, Coordinate> indexToCoordinate;
    private static Map<Coordinate, BlockInfo> serverConnectedBlocks = null;
    private static int selectedX;
    private static int selectedY;
    private static int selectedZ;
    protected int xSize = 356;
    protected int ySize = 206;
    public static final int TEXT_COLOR = 1677215;
    public static final int SEL_TEXT_COLOR = 598048;
    private Window window;
    private ToggleButton showRfPerTick;
    private WidgetList list;
    private TextField filterTextField;
    private int listDirty = 0;
    private String filter = null;

    public static void setSelected(int x, int y, int z) {
        selectedX = x;
        selectedY = y;
        selectedZ = z;
    }

    public static void setServerConnectedBlocks(Map<Coordinate, BlockInfo> serverConnectedBlocks) {
        GuiNetworkMonitor.serverConnectedBlocks = new HashMap<Coordinate, BlockInfo>(serverConnectedBlocks);
    }

    private void requestConnectedBlocksFromServer() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetConnectedBlocks(selectedX, selectedY, selectedZ));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        this.list = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void doubleClick(Widget parent, int index) {
                GuiNetworkMonitor.this.hilightBlock(index);
            }
        });
        this.listDirty = 0;
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable(this.list);
        Panel listPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.list)).addChild(listSlider);
        this.showRfPerTick = (ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("RF/tick")).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiNetworkMonitor.this.previousRfMillis = 0L;
            }
        }).setDesiredHeight(13);
        this.filterTextField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(13)).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiNetworkMonitor.this.filter = GuiNetworkMonitor.this.filterTextField.getText();
                if (GuiNetworkMonitor.this.filter.trim().isEmpty()) {
                    GuiNetworkMonitor.this.filter = null;
                }
                GuiNetworkMonitor.this.connectedBlocks = null;
            }
        });
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.showRfPerTick)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Filter:"))).addChild(this.filterTextField)).setDesiredHeight(16);
        Widget toplevel = ((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout()).addChild(listPanel)).addChild(buttonPanel)).setDesiredHeight(13);
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window(this, toplevel);
        serverConnectedBlocks = null;
    }

    private void hilightBlock(int index) {
        if (index == -1) {
            return;
        }
        Coordinate c = this.indexToCoordinate.get(index);
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + (long)(1000 * NetworkMonitorConfiguration.hilightTime));
        RFTools.message((EntityPlayer)this.field_146297_k.field_71439_g, "The block is now highlighted");
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    private void refreshList(boolean recalcPerTick) {
        long millis = System.currentTimeMillis();
        boolean rftick = this.showRfPerTick.isPressed();
        for (Map.Entry<Coordinate, BlockInfo> me : this.connectedBlocks.entrySet()) {
            BlockInfo blockInfo = me.getValue();
            int energy = blockInfo.getEnergyStored();
            int maxEnergy = blockInfo.getMaxEnergyStored();
            EnergyBar energyLabel = this.labelMap.get(me.getKey());
            if (energyLabel == null) continue;
            this.setEnergyLabel(millis, rftick, recalcPerTick, me, energy, maxEnergy, energyLabel);
        }
    }

    private void setEnergyLabel(long millis, boolean rftick, boolean recalcPerTick, Map.Entry<Coordinate, BlockInfo> me, int energy, int maxEnergy, EnergyBar energyLabel) {
        energyLabel.setValue(energy).setMaxValue(maxEnergy).setShowRfPerTick(rftick);
        if (rftick && recalcPerTick) {
            long dt = millis - this.previousRfMillis;
            int rft = 0;
            if (dt > 0L && this.previousRf != null && this.previousRf.containsKey(me.getKey())) {
                rft = energy - this.previousRf.get(me.getKey());
                rft = rft * 20 / (int)dt;
            }
            energyLabel.setRfPerTick(rft);
        }
    }

    private void populateList() {
        boolean recalcPerTick;
        this.requestConnectedBlocksFromServer();
        if (serverConnectedBlocks == null) {
            return;
        }
        boolean rftick = this.showRfPerTick.isPressed();
        long millis = System.currentTimeMillis();
        boolean bl = recalcPerTick = this.previousRfMillis == 0L || millis - this.previousRfMillis > 1000L;
        if (((Object)serverConnectedBlocks).equals(this.connectedBlocks)) {
            this.refreshList(recalcPerTick);
        } else {
            this.connectedBlocks = new HashMap<Coordinate, BlockInfo>(serverConnectedBlocks);
            Map<Coordinate, EnergyBar> oldLabelMap = this.labelMap;
            this.labelMap = new HashMap<Coordinate, EnergyBar>();
            this.indexToCoordinate = new HashMap<Integer, Coordinate>();
            this.list.removeChildren();
            int index = 0;
            for (Map.Entry<Coordinate, BlockInfo> me : this.connectedBlocks.entrySet()) {
                EnergyBar energyLabel;
                BlockInfo blockInfo = me.getValue();
                Coordinate coordinate = me.getKey();
                Block block = this.field_146297_k.field_71441_e.func_147439_a(coordinate.getX(), coordinate.getY(), coordinate.getZ());
                if (block == null || block.isAir((IBlockAccess)this.field_146297_k.field_71441_e, coordinate.getX(), coordinate.getY(), coordinate.getZ())) continue;
                int energy = blockInfo.getEnergyStored();
                int maxEnergy = blockInfo.getMaxEnergyStored();
                int color = this.getTextColor(blockInfo);
                int meta = this.field_146297_k.field_71441_e.func_72805_g(coordinate.getX(), coordinate.getY(), coordinate.getZ());
                String displayName = BlockInfo.getReadableName(block, coordinate, meta, (World)this.field_146297_k.field_71441_e);
                if (this.filter != null && !displayName.toLowerCase().contains(this.filter)) continue;
                Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
                panel.addChild(new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(block));
                panel.addChild(((AbstractWidget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setText(displayName)).setColor(color)).setDesiredWidth(100));
                panel.addChild(((AbstractWidget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setText(coordinate.toString())).setColor(color)).setDesiredWidth(75));
                EnergyBar energyBar = energyLabel = oldLabelMap == null ? null : oldLabelMap.get(coordinate);
                if (energyLabel == null) {
                    energyLabel = new EnergyBar(this.field_146297_k, (Gui)this).setColor(1677215).setHorizontal();
                }
                this.setEnergyLabel(millis, rftick, recalcPerTick, me, energy, maxEnergy, energyLabel);
                panel.addChild(energyLabel);
                this.list.addChild(panel);
                this.labelMap.put(coordinate, energyLabel);
                this.indexToCoordinate.put(index, coordinate);
                ++index;
            }
        }
        if (rftick && recalcPerTick) {
            this.previousRfMillis = millis;
            this.previousRf = new HashMap<Coordinate, Integer>(this.connectedBlocks.size());
            for (Map.Entry<Coordinate, BlockInfo> me : this.connectedBlocks.entrySet()) {
                this.previousRf.put(me.getKey(), me.getValue().getEnergyStored());
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.window.mouseMovedOrUp(x, y, button);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.window.draw();
        List<String> tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }

    private int getTextColor(BlockInfo blockInfo) {
        Coordinate c = blockInfo.getCoordinate();
        int color = c.getX() == selectedX && c.getY() == selectedY && c.getZ() == selectedZ ? 598048 : 1677215;
        return color;
    }
}

