/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets.types;

import java.util.List;
import java.util.Random;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.types.DimletCraftingTools;
import mcjty.rftools.items.dimlets.types.IDimletType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class MobDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_mob";
    private static int rarity = 2;
    private static int baseCreationCost = 300;
    private static int baseMaintainCost = 100;
    private static int baseTickCost = 200;

    @Override
    public String getName() {
        return "Mob";
    }

    @Override
    public String getOpcode() {
        return "M";
    }

    @Override
    public String getTextureName() {
        return "mobsDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the mob dimlet type");
        rarity = cfg.get(CATEGORY_TYPE, "rarity", rarity, "Default rarity for this dimlet type").getInt();
        baseCreationCost = cfg.get(CATEGORY_TYPE, "creation.cost", baseCreationCost, "Dimlet creation cost (how much power this dimlets adds during creation time of a dimension)").getInt();
        baseMaintainCost = cfg.get(CATEGORY_TYPE, "maintenance.cost", baseMaintainCost, "Dimlet maintenance cost (how much power this dimlet will use up to keep the dimension running)").getInt();
        baseTickCost = cfg.get(CATEGORY_TYPE, "tick.cost", baseTickCost, "Dimlet tick cost (how long it takes to make a dimension with this dimlet in it)").getInt();
    }

    @Override
    public int getRarity() {
        return rarity;
    }

    @Override
    public int getCreationCost() {
        return baseCreationCost;
    }

    @Override
    public int getMaintenanceCost() {
        return baseMaintainCost;
    }

    @Override
    public int getTickCost() {
        return baseTickCost;
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return false;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return true;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
        MobDescriptor mobDescriptor = DimletObjectMapping.idtoMob.get(key);
        if (mobDescriptor != null && mobDescriptor.getEntityClass() != null) {
            dimensionInformation.getExtraMobs().add(mobDescriptor);
        }
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        block3: {
            List<MobDescriptor> extraMobs;
            block2: {
                extraMobs = dimensionInformation.getExtraMobs();
                if (!(dimlets = DimensionInformation.extractType(DimletType.DIMLET_MOBS, dimlets)).isEmpty()) break block2;
                while (random.nextFloat() < DimletConfiguration.randomExtraMobsChance) {
                    DimletKey key = DimletRandomizer.getRandomMob(random, false);
                    dimensionInformation.updateCostFactor(key);
                    extraMobs.add(DimletObjectMapping.idtoMob.get(key));
                }
                break block3;
            }
            DimletKey key = (DimletKey)dimlets.get(0).getLeft();
            MobDescriptor mobDescriptor = DimletObjectMapping.idtoMob.get(key);
            if (dimlets.size() == 1 && (mobDescriptor == null || mobDescriptor.getEntityClass() == null)) break block3;
            for (Pair<DimletKey, List<DimletKey>> dimletWithModifiers : dimlets) {
                DimletKey modifierKey = (DimletKey)dimletWithModifiers.getLeft();
                MobDescriptor descriptor = DimletObjectMapping.idtoMob.get(modifierKey);
                if (descriptor == null || descriptor.getEntityClass() == null) continue;
                extraMobs.add(descriptor);
            }
        }
    }

    @Override
    public String[] getInformation() {
        return new String[]{"Control what type of mobs can spawn", "in addition to normal mob spawning."};
    }

    private static boolean isValidMobEssence(ItemStack stackEssence, NBTTagCompound essenceCompound) {
        if (stackEssence.func_77973_b() != ModItems.syringeItem) {
            return false;
        }
        if (essenceCompound == null) {
            return false;
        }
        int level = essenceCompound.func_74762_e("level");
        String mob = essenceCompound.func_74779_i("mobName");
        return level >= DimletConstructionConfiguration.maxMobInjections && mob != null;
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        if (!MobDimletType.isValidMobEssence(stackEssence, stackEssence.func_77978_p())) {
            return null;
        }
        String mob = stackEssence.func_77978_p().func_74779_i("mobName");
        if (!DimletCraftingTools.matchDimletRecipe(new DimletKey(DimletType.DIMLET_MOBS, mob), stackController, stackMemory, stackEnergy)) {
            return null;
        }
        DimletKey mobDimlet = new DimletKey(DimletType.DIMLET_MOBS, mob);
        return mobDimlet;
    }
}

