/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class DimletMapping
extends WorldSavedData {
    public static final String DIMLETMAPPING_NAME = "RFToolsDimletMapping";
    private static DimletMapping instance = null;
    private final Map<Integer, DimletKey> idToDimlet = new HashMap<Integer, DimletKey>();
    private final Map<DimletKey, Integer> dimletToID = new HashMap<DimletKey, Integer>();

    public DimletMapping(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.field_72988_C.func_75745_a(DIMLETMAPPING_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public static boolean isInitialized() {
        if (DimletMapping.getInstance() == null) {
            return false;
        }
        return !DimletMapping.instance.idToDimlet.isEmpty();
    }

    public void clear() {
        this.idToDimlet.clear();
        this.dimletToID.clear();
    }

    public static DimletMapping getDimletMapping(World world) {
        if (instance != null) {
            return instance;
        }
        instance = (DimletMapping)world.field_72988_C.func_75742_a(DimletMapping.class, DIMLETMAPPING_NAME);
        if (instance == null) {
            instance = new DimletMapping(DIMLETMAPPING_NAME);
        }
        return instance;
    }

    public static DimletMapping getInstance() {
        return instance;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.idToDimlet.clear();
        this.dimletToID.clear();
        int[] ids = tagCompound.func_74759_k("ids");
        int[] types = tagCompound.func_74759_k("types");
        for (int i = 0; i < ids.length; ++i) {
            String s = tagCompound.func_74779_i("n" + i);
            DimletKey key = new DimletKey(DimletType.values()[types[i]], s);
            this.idToDimlet.put(ids[i], key);
            this.dimletToID.put(key, ids[i]);
        }
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        int[] ids = new int[this.idToDimlet.size()];
        int[] types = new int[this.idToDimlet.size()];
        int idx = 0;
        for (Map.Entry<Integer, DimletKey> entry : this.idToDimlet.entrySet()) {
            ids[idx] = entry.getKey();
            types[idx] = entry.getValue().getType().ordinal();
            tagCompound.func_74778_a("n" + idx, entry.getValue().getName());
            ++idx;
        }
        tagCompound.func_74783_a("ids", ids);
        tagCompound.func_74783_a("types", types);
    }

    public void registerDimletKey(int id, DimletKey key) {
        this.idToDimlet.put(id, key);
        this.dimletToID.put(key, id);
    }

    public int getId(DimletType type, String name) {
        return this.dimletToID.get(new DimletKey(type, name));
    }

    public Integer getId(DimletKey key) {
        return this.dimletToID.get(key);
    }

    public DimletKey getKey(int id) {
        return this.idToDimlet.get(id);
    }

    public void removeKey(DimletKey key) {
        Integer id = this.dimletToID.get(key);
        if (id != null) {
            this.idToDimlet.remove(id);
        }
        this.dimletToID.remove(key);
    }

    public Set<Map.Entry<Integer, DimletKey>> getEntries() {
        return this.idToDimlet.entrySet();
    }

    public Set<Integer> getIds() {
        return this.idToDimlet.keySet();
    }

    public Set<DimletKey> getKeys() {
        return this.dimletToID.keySet();
    }

    public void overrideServerMapping(Map<Integer, DimletKey> dimlets) {
        this.idToDimlet.clear();
        this.dimletToID.clear();
        for (Map.Entry<Integer, DimletKey> entry : dimlets.entrySet()) {
            this.idToDimlet.put(entry.getKey(), entry.getValue());
            this.dimletToID.put(entry.getValue(), entry.getKey());
        }
    }
}

