/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.network.ByteBufConverter;
import mcjty.rftools.network.NetworkTools;
import mcjty.varia.Coordinate;

public class TransmitterInfo
implements ByteBufConverter {
    private final Coordinate coordinate;
    private final String name;
    private final TeleportDestination teleportDestination;

    public TransmitterInfo(ByteBuf buf) {
        this.coordinate = new Coordinate(buf.readInt(), buf.readInt(), buf.readInt());
        this.name = NetworkTools.readString(buf);
        this.teleportDestination = new TeleportDestination(buf);
    }

    public TransmitterInfo(Coordinate coordinate, String name, TeleportDestination destination) {
        this.coordinate = coordinate;
        this.name = name;
        this.teleportDestination = destination == null ? new TeleportDestination(null, 0) : destination;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinate.getX());
        buf.writeInt(this.coordinate.getY());
        buf.writeInt(this.coordinate.getZ());
        NetworkTools.writeString(buf, this.getName());
        this.teleportDestination.toBytes(buf);
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public String getName() {
        return this.name;
    }

    public TeleportDestination getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransmitterInfo that = (TransmitterInfo)o;
        if (this.coordinate != null ? !this.coordinate.equals(that.coordinate) : that.coordinate != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.teleportDestination.equals(that.teleportDestination);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.teleportDestination.hashCode();
        return result;
    }
}

