/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.container.EmptyContainer;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.SyncedValueList;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.events.ValueEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ScrollableLabel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storagemonitor.InvBlockInfo;
import mcjty.rftools.blocks.storagemonitor.PacketGetInventory;
import mcjty.rftools.blocks.storagemonitor.PacketSearchItems;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class GuiStorageScanner
extends GenericGuiContainer<StorageScannerTileEntity> {
    public static final int STORAGE_MONITOR_WIDTH = 256;
    public static final int STORAGE_MONITOR_HEIGHT = 224;
    private WidgetList storageList;
    private WidgetList itemList;
    private EnergyBar energyBar;
    private EnergyBar progressBar;
    private ScrollableLabel radiusLabel;
    private Button scanButton;
    private int clientVersion = -1;
    public static Set<Coordinate> fromServer_coordinates = new HashSet<Coordinate>();

    public GuiStorageScanner(StorageScannerTileEntity storageScannerTileEntity, EmptyContainer storageScannerContainer) {
        super(storageScannerTileEntity, storageScannerContainer);
        StorageScannerTileEntity.setCurrentRF(storageScannerTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((StorageScannerTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setVertical().setDesiredWidth(10)).setDesiredHeight(60)).setMaxValue(maxEnergyStored).setShowText(false);
        StorageScannerTileEntity cfr_ignored_0 = (StorageScannerTileEntity)this.tileEntity;
        this.energyBar.setValue(StorageScannerTileEntity.getCurrentRF());
        this.storageList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiStorageScanner.this.itemList.removeChildren();
                ((StorageScannerTileEntity)GuiStorageScanner.this.tileEntity).clearShowingItems();
                GuiStorageScanner.this.getInventoryOnServer();
            }

            @Override
            public void doubleClick(Widget parent, int index) {
                GuiStorageScanner.this.hilightSelectedContainer(index);
            }
        }).setFilledRectThickness(1);
        Slider storageListSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable(this.storageList);
        Panel topPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setDesiredHeight(90)).addChild(this.energyBar)).addChild(this.storageList)).addChild(storageListSlider);
        this.itemList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setFilledRectThickness(1);
        Slider itemListSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable(this.itemList);
        Panel midPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.itemList)).addChild(itemListSlider);
        this.scanButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Scan")).setDesiredWidth(50)).setDesiredHeight(16)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiStorageScanner.this.startStopScan();
            }
        }).setTooltips(new String[]{"Start/stop a scan of", "all storage units", "in radius"});
        this.progressBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setShowText(false).setColor1(-8947849).setColor2(-11184811).setHorizontal().setMaxValue(100).setDesiredWidth(30)).setValue(0);
        this.radiusLabel = (ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).addValueEvent(new ValueEvent(){

            @Override
            public void valueChanged(Widget parent, int newValue) {
                GuiStorageScanner.this.changeRadius(newValue);
            }
        }).setRealMinimum(1).setRealMaximum(20).setDesiredWidth(30);
        this.radiusLabel.setRealValue(((StorageScannerTileEntity)this.tileEntity).getRadius());
        TextField textField = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiStorageScanner.this.storageList.clearHilightedRows();
                fromServer_coordinates.clear();
                GuiStorageScanner.this.startSearch(newText);
            }
        });
        Panel searchPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setDesiredHeight(20)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Search:"))).addChild(textField);
        Slider radiusSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setHorizontal().setTooltips(new String[]{"Radius of scan"})).setScrollable(this.radiusLabel);
        Panel scanPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setDesiredHeight(20)).addChild(this.scanButton)).addChild(this.progressBar)).addChild(radiusSlider)).addChild(this.radiusLabel);
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout()).addChild(topPanel)).addChild(midPanel)).addChild(searchPanel)).addChild(scanPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void hilightSelectedContainer(int index) {
        if (index == -1) {
            return;
        }
        SyncedValueList<InvBlockInfo> inventories = ((StorageScannerTileEntity)this.tileEntity).getInventories();
        Coordinate c = inventories.get(index).getCoordinate();
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + (long)(1000 * StorageScannerConfiguration.hilightTime));
        RFTools.message((EntityPlayer)this.field_146297_k.field_71439_g, "The inventory is now highlighted");
        GuiStorageScanner guiStorageScanner = this;
        guiStorageScanner.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
    }

    private void changeRadius(int r) {
        this.sendServerCommand("setRadius", new Argument("r", r));
    }

    private void startStopScan() {
        this.sendServerCommand("startScan", new Argument("start", !((StorageScannerTileEntity)this.tileEntity).isScanning()));
    }

    private void startSearch(String text) {
        if (!text.isEmpty()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSearchItems(((StorageScannerTileEntity)this.tileEntity).field_145851_c, ((StorageScannerTileEntity)this.tileEntity).field_145848_d, ((StorageScannerTileEntity)this.tileEntity).field_145849_e, text));
        }
    }

    private void getInventoryOnServer() {
        InvBlockInfo invBlockInfo = this.getSelectedContainer();
        if (invBlockInfo != null) {
            Coordinate c = invBlockInfo.getCoordinate();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetInventory(((StorageScannerTileEntity)this.tileEntity).field_145851_c, ((StorageScannerTileEntity)this.tileEntity).field_145848_d, ((StorageScannerTileEntity)this.tileEntity).field_145849_e, c.getX(), c.getY(), c.getZ()));
        }
    }

    private InvBlockInfo getSelectedContainer() {
        SyncedValueList<InvBlockInfo> inventories;
        int selected = this.storageList.getSelected();
        if (selected != -1 && selected < (inventories = ((StorageScannerTileEntity)this.tileEntity).getInventories()).size()) {
            InvBlockInfo invBlockInfo = inventories.get(selected);
            return invBlockInfo;
        }
        return null;
    }

    private void updateContentsList() {
        List<ItemStack> items = ((StorageScannerTileEntity)this.tileEntity).getShowingItems();
        if (this.itemList.getMaximum() == 0) {
            for (ItemStack stack : items) {
                if (stack == null) continue;
                String displayName = BlockInfo.getReadableName(stack, 0);
                Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
                panel.addChild(new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(stack));
                panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setDynamic(true)).setText(displayName)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
                this.itemList.addChild(panel);
            }
        }
    }

    private void updateStorageList() {
        SyncedValueList<InvBlockInfo> inventories = ((StorageScannerTileEntity)this.tileEntity).getInventories();
        if (inventories.getClientVersion() != this.clientVersion) {
            this.clientVersion = inventories.getClientVersion();
            this.storageList.removeChildren();
            for (InvBlockInfo blockInfo : inventories) {
                String displayName;
                Coordinate c = blockInfo.getCoordinate();
                Block block = this.field_146297_k.field_71441_e.func_147439_a(c.getX(), c.getY(), c.getZ());
                int meta = this.field_146297_k.field_71441_e.func_72805_g(c.getX(), c.getY(), c.getZ());
                if (block == null || block.isAir((IBlockAccess)this.field_146297_k.field_71441_e, c.getX(), c.getY(), c.getZ())) {
                    displayName = "[REMOVED]";
                    block = null;
                } else {
                    displayName = BlockInfo.getReadableName(block, meta);
                }
                Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
                panel.addChild(new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(block));
                panel.addChild(((AbstractWidget)((Label)new Label(this.field_146297_k, (Gui)this).setText(displayName)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(90));
                panel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setDynamic(true)).setText(c.toString()));
                this.storageList.addChild(panel);
            }
        }
        this.storageList.clearHilightedRows();
        Set<Coordinate> coordinates = fromServer_coordinates;
        int i = 0;
        for (InvBlockInfo blockInfo : inventories) {
            Coordinate c = blockInfo.getCoordinate();
            if (coordinates.contains(c)) {
                this.storageList.addHilightedRow(i);
            }
            ++i;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateStorageList();
        this.updateContentsList();
        this.updateScanButton();
        this.window.draw();
        StorageScannerTileEntity cfr_ignored_0 = (StorageScannerTileEntity)this.tileEntity;
        int currentRF = StorageScannerTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void updateScanButton() {
        if (((StorageScannerTileEntity)this.tileEntity).isScanning()) {
            this.scanButton.setText("Stop");
            this.progressBar.setValue(((StorageScannerTileEntity)this.tileEntity).getProgress());
        } else {
            this.scanButton.setText("Scan");
            this.progressBar.setValue(0);
        }
    }
}

