/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcjty.rftools.render.DefaultISBRH;
import mcjty.varia.Coordinate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MatterBeamerRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation redglow = new ResourceLocation("rftools", "textures/blocks/redglow.png");
    private static final ResourceLocation blueglow = new ResourceLocation("rftools", "textures/blocks/blueglow.png");

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        ResourceLocation txt;
        Coordinate coord;
        int meta;
        MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)tileEntity;
        Coordinate destination = matterBeamerTileEntity.getDestination();
        if (destination != null && ((meta = tileEntity.func_145831_w().func_72805_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e)) & 8) != 0) {
            this.drawBeam(f, new Coordinate(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e), destination, meta & 1);
        }
        if ((coord = new Coordinate(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e)).equals(RFTools.instance.clientInfo.getSelectedTE())) {
            txt = redglow;
        } else if (coord.equals(RFTools.instance.clientInfo.getDestinationTE())) {
            txt = blueglow;
        } else {
            return;
        }
        this.func_147499_a(txt);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 128);
        tessellator.func_78380_c(240);
        boolean blending = GL11.glIsEnabled((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.UP.ordinal(), 1.1f, -0.05f);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.DOWN.ordinal(), 1.1f, -0.05f);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.NORTH.ordinal(), 1.1f, -0.05f);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.SOUTH.ordinal(), 1.1f, -0.05f);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.WEST.ordinal(), 1.1f, -0.05f);
        DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.EAST.ordinal(), 1.1f, -0.05f);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        if (!blending) {
            GL11.glDisable((int)3042);
        }
    }

    private void drawBeam(float partialTicks, Coordinate c1, Coordinate c2, int meta) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP p = mc.field_71439_g;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        boolean blending = GL11.glIsEnabled((int)3042);
        this.func_147499_a(redglow);
        if (meta != 0) {
            this.drawLine(c1, c2, 0.2f);
        }
        this.drawLine(c1, c2, 0.1f);
        if (!blending) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private void drawLine(Coordinate c1, Coordinate c2, float width) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 128);
        tessellator.func_78380_c(240);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        float mx1 = (float)c1.getX() + 0.5f;
        float my1 = (float)c1.getY() + 0.5f;
        float mz1 = (float)c1.getZ() + 0.5f;
        Vector start = new Vector(mx1, my1, mz1);
        float mx2 = (float)c2.getX() + 0.5f;
        float my2 = (float)c2.getY() + 0.5f;
        float mz2 = (float)c2.getZ() + 0.5f;
        Vector end = new Vector(mx2, my2, mz2);
        Vector normal = MatterBeamerRenderer.Cross(start, end);
        normal = normal.normalize();
        Vector side = MatterBeamerRenderer.Cross(normal, MatterBeamerRenderer.Sub(end, start));
        side = side.normalize();
        Vector side2 = MatterBeamerRenderer.Mul(side, width / 2.0f);
        Vector oside = MatterBeamerRenderer.Cross(side, normal);
        Vector oside2 = MatterBeamerRenderer.Mul(oside, width / 2.0f);
        Vector p1 = MatterBeamerRenderer.Add(start, side2);
        Vector p2 = MatterBeamerRenderer.Sub(start, side2);
        Vector p3 = MatterBeamerRenderer.Add(start, oside2);
        Vector p4 = MatterBeamerRenderer.Sub(start, oside2);
        Vector p5 = MatterBeamerRenderer.Add(end, side2);
        Vector p6 = MatterBeamerRenderer.Sub(end, side2);
        Vector p7 = MatterBeamerRenderer.Add(end, oside2);
        Vector p8 = MatterBeamerRenderer.Sub(end, oside2);
        this.drawQuad(tessellator, p1, p2, p5, p6);
        this.drawQuad(tessellator, p2, p1, p6, p5);
        this.drawQuad(tessellator, p8, p7, p4, p3);
        this.drawQuad(tessellator, p7, p8, p3, p4);
        tessellator.func_78381_a();
    }

    private void drawQuad(Tessellator tessellator, Vector p1, Vector p2, Vector p3, Vector p4) {
        tessellator.func_78377_a((double)p1.getX(), (double)p1.getY(), (double)p1.getZ());
        tessellator.func_78377_a((double)p2.getX(), (double)p2.getY(), (double)p2.getZ());
        tessellator.func_78377_a((double)p3.getX(), (double)p3.getY(), (double)p3.getZ());
        tessellator.func_78377_a((double)p4.getX(), (double)p4.getY(), (double)p4.getZ());
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    private static class Vector {
        private final float x;
        private final float y;
        private final float z;

        private Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

