/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.spaceprojector.ProxyBlockTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorContainer;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorSetup;
import mcjty.rftools.network.Argument;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class SpaceProjectorTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory,
SimpleComponent,
IPeripheral {
    public static final String COMPONENT_NAME = "space_projector";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_PROJECT = "project";
    private InventoryHelper inventoryHelper = new InventoryHelper(this, SpaceProjectorContainer.factory, 1);
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private int powered = 0;
    private Coordinate minBox = null;
    private Coordinate maxBox = null;

    public SpaceProjectorTileEntity() {
        super(SpaceProjectorConfiguration.SPACEPROJECTOR_MAXENERGY, SpaceProjectorConfiguration.SPACEPROJECTOR_RECEIVEPERTICK);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"hasCard", "getRedstoneMode", "setRedstoneMode"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.hasCard() != null};
            }
            case 1: {
                return new Object[]{this.getRedstoneMode().getDescription()};
            }
            case 2: {
                return this.setRedstoneMode((String)arguments[0]);
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] hasCard(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasCard() != null};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getRedstoneMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getRedstoneMode().getDescription()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setRedstoneMode(Context context, Arguments args) throws Exception {
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    private NBTTagCompound hasCard() {
        ItemStack itemStack = this.inventoryHelper.getStacks()[0];
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound;
    }

    @Override
    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            this.func_70296_d();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode(mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRedstoneMode(redstoneMode);
        return null;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void unproject() {
        if (this.minBox == null) {
            return;
        }
        for (int x = this.minBox.getX(); x <= this.maxBox.getX(); ++x) {
            for (int y = this.minBox.getY(); y <= this.maxBox.getY(); ++y) {
                for (int z = this.minBox.getZ(); z <= this.maxBox.getZ(); ++z) {
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (!block.equals((Object)SpaceProjectorSetup.proxyBlock)) continue;
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }
        this.minBox = null;
        this.maxBox = null;
        this.func_70296_d();
    }

    private void project() {
        NBTTagCompound tc;
        if (this.minBox != null) {
            this.unproject();
        }
        if ((tc = this.hasCard()) == null) {
            return;
        }
        int channel = tc.func_74762_e("channel");
        if (channel == -1) {
            return;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return;
        }
        Coordinate minCorner = chamberChannel.getMinCorner();
        Coordinate maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        int dx = this.field_145851_c + 1 - minCorner.getX();
        int dy = this.field_145848_d + 1 - minCorner.getY();
        int dz = this.field_145849_e + 1 - minCorner.getZ();
        this.minBox = new Coordinate(minCorner.getX() + dx, minCorner.getY() + dy, minCorner.getZ() + dz);
        this.maxBox = new Coordinate(maxCorner.getX() + dx, maxCorner.getY() + dy, maxCorner.getZ() + dz);
        for (int x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
            for (int y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                for (int z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null || block.isAir((IBlockAccess)world, x, y, z)) continue;
                    this.field_145850_b.func_147465_d(dx + x, dy + y, dz + z, (Block)SpaceProjectorSetup.proxyBlock, world.func_72805_g(x, y, z), 3);
                    ProxyBlockTileEntity proxyBlockTileEntity = (ProxyBlockTileEntity)this.field_145850_b.func_147438_o(dx + x, dy + y, dz + z);
                    proxyBlockTileEntity.setCamoBlock(Block.field_149771_c.func_148757_b((Object)block));
                    proxyBlockTileEntity.setOrigCoordinate(new Coordinate(x, y, z), dimension);
                }
            }
        }
        this.func_70296_d();
    }

    @Override
    protected void checkStateServer() {
        NBTTagCompound tc;
        if (this.minBox != null && (tc = this.hasCard()) == null) {
            this.unproject();
        }
    }

    public int[] func_94128_d(int side) {
        return SpaceProjectorContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return SpaceProjectorContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return SpaceProjectorContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Space Projector";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74771_c("powered");
        this.minBox = Coordinate.readFromNBT(tagCompound, "minBox");
        this.maxBox = Coordinate.readFromNBT(tagCompound, "maxBox");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        byte m = tagCompound.func_74771_c(CMD_RSMODE);
        this.redstoneMode = RedstoneMode.values()[m];
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("powered", (byte)this.powered);
        Coordinate.writeToNBT(tagCompound, "minBox", this.minBox);
        Coordinate.writeToNBT(tagCompound, "maxBox", this.maxBox);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.redstoneMode.ordinal());
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            return true;
        }
        if (CMD_PROJECT.equals(command)) {
            this.project();
            return true;
        }
        return false;
    }
}

