/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorSetup;
import mcjty.varia.Coordinate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class SpaceChamberControllerTileEntity
extends GenericEnergyReceiverTileEntity {
    private Coordinate minCorner;
    private Coordinate maxCorner;
    private int channel = -1;

    public SpaceChamberControllerTileEntity() {
        super(SpaceProjectorConfiguration.CHAMBERCONTROLLER_MAXENERGY, SpaceProjectorConfiguration.CHAMBERCONTROLLER_RECEIVEPERTICK);
    }

    public Coordinate getMinCorner() {
        return this.minCorner;
    }

    public Coordinate getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(EntityPlayer player) {
        int i;
        int x1 = this.field_145851_c;
        int y1 = this.field_145848_d;
        int z1 = this.field_145849_e;
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < 16; ++i) {
            if (x2 == x1) {
                if (this.field_145850_b.func_147439_a(x1 - i, y1, z1) == SpaceProjectorSetup.spaceChamberBlock) {
                    x2 = x1 - i;
                } else if (this.field_145850_b.func_147439_a(x1 + i, y1, z1) == SpaceProjectorSetup.spaceChamberBlock) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.field_145850_b.func_147439_a(x1, y1, z1 - i) == SpaceProjectorSetup.spaceChamberBlock) {
                z2 = z1 - i;
                continue;
            }
            if (this.field_145850_b.func_147439_a(x1, y1, z1 + i) != SpaceProjectorSetup.spaceChamberBlock) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        if (this.field_145850_b.func_147439_a(x2, y1, z2) != SpaceProjectorSetup.spaceChamberBlock) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        for (i = 1; i < 16; ++i) {
            if (this.field_145850_b.func_147439_a(x1, y1 - i, z1) == SpaceProjectorSetup.spaceChamberBlock) {
                y2 = y1 - i;
                break;
            }
            if (this.field_145850_b.func_147439_a(x1, y1 + i, z1) != SpaceProjectorSetup.spaceChamberBlock) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        if (this.field_145850_b.func_147439_a(x2, y2, z2) != SpaceProjectorSetup.spaceChamberBlock) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        if (this.field_145850_b.func_147439_a(x1, y2, z2) != SpaceProjectorSetup.spaceChamberBlock) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        if (this.field_145850_b.func_147439_a(x2, y2, z1) != SpaceProjectorSetup.spaceChamberBlock) {
            RFTools.message(player, EnumChatFormatting.RED + "Not a valid chamber shape!");
            return;
        }
        this.minCorner = new Coordinate(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new Coordinate(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.getX() > this.maxCorner.getX() || this.minCorner.getY() > this.maxCorner.getY() || this.minCorner.getZ() > this.maxCorner.getZ()) {
            RFTools.message(player, EnumChatFormatting.RED + "Chamber is too small!");
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        RFTools.message(player, EnumChatFormatting.WHITE + "Chamber succesfully created!");
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.channel);
        chamberChannel.setDimension(this.field_145850_b.field_73011_w.field_76574_g);
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save(this.field_145850_b);
        this.func_70296_d();
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.minCorner = Coordinate.readFromNBT(tagCompound, "minCorner");
        this.maxCorner = Coordinate.readFromNBT(tagCompound, "maxCorner");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channel = tagCompound.func_74762_e("channel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Coordinate.writeToNBT(tagCompound, "minCorner", this.minCorner);
        Coordinate.writeToNBT(tagCompound, "maxCorner", this.maxCorner);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("channel", this.channel);
    }
}

