/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.container.GenericContainerBlock;
import mcjty.container.WrenchUsage;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ShieldBlock
extends GenericContainerBlock
implements Infusable {
    public ShieldBlock(String blockName, Class<? extends ShieldTEBase> clazz) {
        super(Material.field_151573_f, clazz);
        this.func_149663_c(blockName);
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_SHIELD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ShieldTEBase shieldTileEntity = (ShieldTEBase)tileEntity;
        ShieldContainer shieldContainer = new ShieldContainer(entityPlayer, shieldTileEntity);
        return new GuiShield(shieldTileEntity, shieldContainer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This machine can build a shield out of adjacent");
            list.add(EnumChatFormatting.WHITE + "shield template block. You can add filters for");
            list.add(EnumChatFormatting.WHITE + "players, mobs, animals, items to control if they");
            list.add(EnumChatFormatting.WHITE + "should be able to pass or not and if they should");
            list.add(EnumChatFormatting.WHITE + "get damage.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(EnumChatFormatting.YELLOW + "increased damage.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new ShieldContainer(entityPlayer, (ShieldTEBase)tileEntity);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sidex, float sidey, float sidez) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        if (wrenchUsed == WrenchUsage.NORMAL) {
            this.composeDecomposeShield(world, x, y, z);
            return true;
        }
        if (wrenchUsed == WrenchUsage.SNEAKING) {
            this.breakAndRemember(world, player, x, y, z);
            return true;
        }
        return this.openGui(world, x, y, z, player);
    }

    private void composeDecomposeShield(World world, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof ShieldTEBase) {
            ((ShieldTEBase)te).composeDecomposeShield();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ShieldTEBase) {
            ShieldTEBase shieldTileEntity = (ShieldTEBase)te;
            BlockTools.emptyInventoryInWorld(world, x, y, z, block, shieldTileEntity);
            if (!world.field_72995_K && shieldTileEntity.isShieldComposed()) {
                shieldTileEntity.decomposeShield();
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineShieldProjector");
    }
}

