/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.ColorChoiceEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ColorChoiceLabel;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.PacketGetFilters;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiShield
extends GenericGuiContainer<ShieldTEBase> {
    public static final int SHIELD_WIDTH = 256;
    public static final int SHIELD_HEIGHT = 224;
    public static final String ACTION_PASS = "Pass";
    public static final String ACTION_SOLID = "Solid";
    public static final String ACTION_DAMAGE = "Damage";
    public static final String ACTION_SOLIDDAMAGE = "SolDmg";
    public static final String DAMAGETYPE_GENERIC = DamageTypeMode.DAMAGETYPE_GENERIC.getDescription();
    public static final String DAMAGETYPE_PLAYER = DamageTypeMode.DAMAGETYPE_PLAYER.getDescription();
    private EnergyBar energyBar;
    private ChoiceLabel visibilityOptions;
    private ChoiceLabel actionOptions;
    private ChoiceLabel typeOptions;
    private ChoiceLabel damageType;
    private ImageChoiceLabel redstoneMode;
    private WidgetList filterList;
    private TextField player;
    private Button addFilter;
    private Button delFilter;
    private Button upFilter;
    private Button downFilter;
    private List<ShieldFilter> filters = null;
    private int listDirty = 0;
    private static List<ShieldFilter> fromServer_filters = new ArrayList<ShieldFilter>();
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/shieldprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public static void storeFiltersForClient(List<ShieldFilter> filters) {
        fromServer_filters = new ArrayList<ShieldFilter>(filters);
    }

    public GuiShield(ShieldTEBase shieldTileEntity, ShieldContainer container) {
        super(shieldTileEntity, container);
        ShieldTEBase.setCurrentRF(shieldTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((ShieldTEBase)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(new PositionalLayout.PositionalHint(12, 141, 8, 76))).setShowText(false);
        ShieldTEBase cfr_ignored_0 = (ShieldTEBase)this.tileEntity;
        this.energyBar.setValue(ShieldTEBase.getCurrentRF());
        this.initVisibilityMode();
        this.initActionOptions();
        this.initTypeOptions();
        this.initRedstoneMode();
        this.initDamageType();
        this.filterList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setLayoutHint(new PositionalLayout.PositionalHint(12, 12, 140, 115))).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiShield.this.selectFilter();
            }
        });
        Slider filterSlider = (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollable(this.filterList).setLayoutHint(new PositionalLayout.PositionalHint(154, 12, 12, 115));
        Button applyCamo = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Set")).setTooltips(new String[]{"Set the camouflage block"})).setLayoutHint(new PositionalLayout.PositionalHint(51, 142, 28, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiShield.this.applyCamoToShield();
            }
        });
        ColorChoiceLabel colorSelector = ((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(this.field_146297_k, (Gui)this).addColors(9895880, 4626687, 16736304, 0x55A0A0, 0xA055A0, 0xFFFFFF).setTooltips(new String[]{"Color for the shield"})).setLayoutHint(new PositionalLayout.PositionalHint(51, 186, 28, 16))).addChoiceEvent(new ColorChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, Integer newColor) {
                GuiShield.this.sendServerCommand("setColor", new Argument[]{new Argument("color", newColor)});
            }
        });
        colorSelector.setCurrentColor(((ShieldTEBase)this.tileEntity).getShieldColor());
        this.player = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Optional player name"})).setLayoutHint(new PositionalLayout.PositionalHint(170, 44, 80, 14));
        this.addFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Add")).setTooltips(new String[]{"Delete selected filter"})).setLayoutHint(new PositionalLayout.PositionalHint(170, 64, 36, 12))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiShield.this.addNewFilter();
            }
        });
        this.delFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Del")).setTooltips(new String[]{"Delete selected filter"})).setLayoutHint(new PositionalLayout.PositionalHint(214, 64, 36, 12))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiShield.this.removeSelectedFilter();
            }
        });
        this.upFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Up")).setTooltips(new String[]{"Move filter up"})).setLayoutHint(new PositionalLayout.PositionalHint(170, 78, 36, 12))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiShield.this.moveFilterUp();
            }
        });
        this.downFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Down")).setTooltips(new String[]{"Move filter down"})).setLayoutHint(new PositionalLayout.PositionalHint(214, 78, 36, 12))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiShield.this.moveFilterDown();
            }
        });
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.energyBar)).addChild(this.visibilityOptions)).addChild(applyCamo)).addChild(this.redstoneMode)).addChild(this.filterList)).addChild(filterSlider)).addChild(this.actionOptions)).addChild(this.typeOptions)).addChild(this.player)).addChild(this.addFilter)).addChild(this.delFilter)).addChild(this.upFilter)).addChild(this.downFilter)).addChild(this.damageType)).addChild(colorSelector);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.listDirty = 0;
        this.requestFilters();
        ((ShieldTEBase)this.tileEntity).requestRfFromServer();
    }

    private void selectFilter() {
        int selected = this.filterList.getSelected();
        if (selected != -1) {
            boolean damage;
            ShieldFilter shieldFilter = this.filters.get(selected);
            boolean solid = (shieldFilter.getAction() & 1) != 0;
            boolean bl = damage = (shieldFilter.getAction() & 2) != 0;
            if (solid && damage) {
                this.actionOptions.setChoice(ACTION_SOLIDDAMAGE);
            } else if (solid) {
                this.actionOptions.setChoice(ACTION_SOLID);
            } else if (damage) {
                this.actionOptions.setChoice(ACTION_DAMAGE);
            } else {
                this.actionOptions.setChoice(ACTION_PASS);
            }
            String type = shieldFilter.getFilterName();
            if ("default".equals(type)) {
                this.typeOptions.setChoice("All");
            } else if ("animal".equals(type)) {
                this.typeOptions.setChoice("Passive");
            } else if ("hostile".equals(type)) {
                this.typeOptions.setChoice("Hostile");
            } else if ("player".equals(type)) {
                this.typeOptions.setChoice("Player");
            } else if ("item".equals(type)) {
                this.typeOptions.setChoice("Item");
            }
            if (shieldFilter instanceof PlayerFilter) {
                this.player.setText(((PlayerFilter)shieldFilter).getName());
            } else {
                this.player.setText("");
            }
        }
    }

    private void requestFilters() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFilters(((ShieldTEBase)this.tileEntity).field_145851_c, ((ShieldTEBase)this.tileEntity).field_145848_d, ((ShieldTEBase)this.tileEntity).field_145849_e));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestFilters();
            this.listDirty = 20;
        }
    }

    private void populateFilters() {
        ArrayList<ShieldFilter> newFilters = new ArrayList<ShieldFilter>(fromServer_filters);
        if (((Object)newFilters).equals(this.filters)) {
            return;
        }
        this.filters = new ArrayList<ShieldFilter>(newFilters);
        this.filterList.removeChildren();
        for (ShieldFilter filter : this.filters) {
            boolean damage;
            PlayerFilter playerFilter;
            String n = "player".equals(filter.getFilterName()) ? ((playerFilter = (PlayerFilter)filter).getName() == null || playerFilter.getName().isEmpty() ? "players" : "player " + playerFilter.getName()) : filter.getFilterName();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
            panel.addChild(((AbstractWidget)((Label)new Label(this.field_146297_k, (Gui)this).setText(n)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(85));
            boolean solid = (filter.getAction() & 1) != 0;
            boolean bl = damage = (filter.getAction() & 2) != 0;
            String actionName = solid && damage ? ACTION_SOLIDDAMAGE : (solid ? ACTION_SOLID : (damage ? ACTION_DAMAGE : ACTION_PASS));
            panel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText(actionName)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
            this.filterList.addChild(panel);
        }
    }

    private void moveFilterUp() {
        this.sendServerCommand("upFilter", new Argument("selected", this.filterList.getSelected()));
        this.listDirty = 0;
    }

    private void moveFilterDown() {
        this.sendServerCommand("downFilter", new Argument("selected", this.filterList.getSelected()));
        this.listDirty = 0;
    }

    private void addNewFilter() {
        String actionName = this.actionOptions.getCurrentChoice();
        int action = ACTION_PASS.equals(actionName) ? 0 : (ACTION_SOLID.equals(actionName) ? 1 : (ACTION_SOLIDDAMAGE.equals(actionName) ? 3 : 2));
        String filterName = this.typeOptions.getCurrentChoice();
        String type = "All".equals(filterName) ? "default" : ("Passive".equals(filterName) ? "animal" : ("Hostile".equals(filterName) ? "hostile" : ("Item".equals(filterName) ? "item" : "player")));
        String playerName = this.player.getText();
        int selected = this.filterList.getSelected();
        this.sendServerCommand("addFilter", new Argument("action", action), new Argument("type", type), new Argument("player", playerName), new Argument("selected", selected));
        this.listDirty = 0;
    }

    private void removeSelectedFilter() {
        this.sendServerCommand("delFilter", new Argument("selected", this.filterList.getSelected()));
        this.listDirty = 0;
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint(new PositionalLayout.PositionalHint(31, 186, 16, 16));
        this.redstoneMode.setCurrentChoice(((ShieldTEBase)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((ShieldTEBase)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoice()]);
        this.sendServerCommand("rsMode", new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoice()].getDescription()));
    }

    private void initVisibilityMode() {
        this.visibilityOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(31, 161, 48, 14));
        for (ShieldRenderingMode m : ShieldRenderingMode.values()) {
            this.visibilityOptions.addChoices(m.getDescription());
        }
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_INVISIBLE.getDescription(), "Shield is completely invisible");
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SHIELD.getDescription(), "Default shield texture");
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SOLID.getDescription(), "Use the texture from the supplied block");
        this.visibilityOptions.setChoice(((ShieldTEBase)this.tileEntity).getShieldRenderingMode().getDescription());
        this.visibilityOptions.addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeVisibilityMode();
            }
        });
    }

    private void initActionOptions() {
        this.actionOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(170, 12, 80, 14));
        this.actionOptions.addChoices(ACTION_PASS, ACTION_SOLID, ACTION_DAMAGE, ACTION_SOLIDDAMAGE);
        this.actionOptions.setChoiceTooltip(ACTION_PASS, "Entity that matches this filter", "can pass through");
        this.actionOptions.setChoiceTooltip(ACTION_SOLID, "Entity that matches this filter", "cannot pass");
        this.actionOptions.setChoiceTooltip(ACTION_DAMAGE, "Entity that matches this filter", "can pass but gets damage");
        this.actionOptions.setChoiceTooltip(ACTION_SOLIDDAMAGE, "Entity that matches this filter", "cannot pass and gets damage");
    }

    private void initTypeOptions() {
        this.typeOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(170, 28, 80, 14));
        this.typeOptions.addChoices("All", "Passive", "Hostile", "Item", "Player");
        this.typeOptions.setChoiceTooltip("All", "Matches everything");
        this.typeOptions.setChoiceTooltip("Passive", "Matches passive mobs");
        this.typeOptions.setChoiceTooltip("Hostile", "Matches hostile mobs");
        this.typeOptions.setChoiceTooltip("Item", "Matches items");
        this.typeOptions.setChoiceTooltip("Player", "Matches players", "(optionaly named)");
    }

    private void initDamageType() {
        this.damageType = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(170, 100, 80, 14));
        this.damageType.addChoices(DAMAGETYPE_GENERIC, DAMAGETYPE_PLAYER);
        this.damageType.setChoiceTooltip(DAMAGETYPE_GENERIC, "Generic damage type");
        this.damageType.setChoiceTooltip(DAMAGETYPE_PLAYER, "Damage as done by a player");
        this.damageType.addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeDamageType();
            }
        });
        this.damageType.setChoice(((ShieldTEBase)this.tileEntity).getDamageMode().getDescription());
    }

    private void changeDamageType() {
        ((ShieldTEBase)this.tileEntity).setDamageMode(DamageTypeMode.getMode(this.damageType.getCurrentChoice()));
        this.sendServerCommand("damageMode", new Argument("mode", DamageTypeMode.getMode(this.damageType.getCurrentChoice()).getDescription()));
    }

    private void changeVisibilityMode() {
        ShieldRenderingMode newMode = ShieldRenderingMode.getMode(this.visibilityOptions.getCurrentChoice());
        ((ShieldTEBase)this.tileEntity).setShieldRenderingMode(newMode);
        this.sendServerCommand("shieldVisMode", new Argument("mode", newMode.getDescription()));
    }

    private void applyCamoToShield() {
        Block block;
        ItemStack stack = ((ShieldTEBase)this.tileEntity).func_70301_a(0);
        int pass = 0;
        if (stack != null && (block = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
            pass = block.func_149701_w();
        }
        this.sendServerCommand("applyCamo", new Argument("pass", pass));
    }

    private void enableButtons() {
        int sel = this.filterList.getSelected();
        int cnt = this.filterList.getMaximum();
        this.delFilter.setEnabled(sel != -1 && cnt > 0);
        this.upFilter.setEnabled(sel > 0 && cnt > 0);
        this.downFilter.setEnabled(sel < cnt - 1 && sel != -1 && cnt > 0);
        if (sel == -1) {
            this.addFilter.setText("Add");
        } else {
            this.addFilter.setText("Insert");
        }
        this.player.setEnabled("Player".equals(this.typeOptions.getCurrentChoice()));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateFilters();
        this.enableButtons();
        this.window.draw();
        ShieldTEBase cfr_ignored_0 = (ShieldTEBase)this.tileEntity;
        int currentRF = ShieldTEBase.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ShieldTEBase)this.tileEntity).requestRfFromServer();
    }
}

