/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.gui.widgets.Panel;
import mcjty.rftools.blocks.screens.ModuleGuiChanged;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModuleHelper;
import mcjty.rftools.blocks.screens.modulesclient.FormatStyle;
import mcjty.rftools.blocks.screens.modulesclient.ScreenModuleGuiBuilder;
import mcjty.varia.Coordinate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EnergyBarClientScreenModule
implements ClientScreenModule {
    private String line = "";
    private int color = 0xFFFFFF;
    private int rfcolor = 0xFFFFFF;
    private int rfcolorNeg = 0xFFFFFF;
    protected int dim = 0;
    private boolean hidebar = false;
    private boolean hidetext = false;
    private boolean showdiff = false;
    private boolean showpct = false;
    private FormatStyle format = FormatStyle.MODE_FULL;
    protected Coordinate coordinate = Coordinate.INVALID;

    @Override
    public ClientScreenModule.TransformMode getTransformMode() {
        return ClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(FontRenderer fontRenderer, int currenty, Object[] screenData, float factor) {
        int xoffset;
        GL11.glDisable((int)2896);
        if (!this.line.isEmpty()) {
            fontRenderer.func_78276_b(this.line, 7, currenty, this.color);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (this.coordinate.isValid()) {
            ClientScreenModuleHelper.renderLevel(fontRenderer, xoffset, currenty, screenData, "RF", this.hidebar, this.hidetext, this.showpct, this.showdiff, this.rfcolor, this.rfcolorNeg, -65536, -13421824, this.format);
        } else {
            fontRenderer.func_78276_b("<invalid>", xoffset, currenty, 0xFF0000);
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public Panel createGui(Minecraft mc, Gui gui, NBTTagCompound currentData, ModuleGuiChanged moduleGuiChanged) {
        return new ScreenModuleGuiBuilder(mc, gui, currentData, moduleGuiChanged).label("Label:").text("text", "Label text").color("color", "Color for the label").nl().label("RF+:").color("rfcolor", "Color for the RF text").label("RF-:").color("rfcolor_neg", "Color for the negative", "RF/tick ratio").nl().toggleNegative("hidebar", "Bar", "Toggle visibility of the", "energy bar").mode("RF").format().nl().label("Block:").monitor().nl().build();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.rfcolor = tagCompound.func_74764_b("rfcolor") ? tagCompound.func_74762_e("rfcolor") : 0xFFFFFF;
            this.rfcolorNeg = tagCompound.func_74764_b("rfcolor_neg") ? tagCompound.func_74762_e("rfcolor_neg") : 0xFFFFFF;
            this.hidebar = tagCompound.func_74767_n("hidebar");
            this.hidetext = tagCompound.func_74767_n("hidetext");
            this.showdiff = tagCompound.func_74767_n("showdiff");
            this.showpct = tagCompound.func_74767_n("showpct");
            this.format = FormatStyle.values()[tagCompound.func_74762_e("format")];
            this.setupCoordinateFromNBT(tagCompound, dim, x, y, z);
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        this.coordinate = Coordinate.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                Coordinate c = new Coordinate(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.getX() - x);
                int dy = Math.abs(c.getY() - y);
                int dz = Math.abs(c.getZ() - z);
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

