/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import java.awt.Rectangle;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ImageLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import mcjty.rftools.network.Argument;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiRelay
extends GenericGuiContainer<RelayTileEntity> {
    public static final int RELAY_WIDTH = 240;
    public static final int RELAY_HEIGHT = 50;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private TextField offEnergy;
    private TextField onEnergy;

    public GuiRelay(RelayTileEntity relayTileEntity, Container container) {
        super(relayTileEntity, container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - 240) / 2;
        int l = (this.field_146295_m - 50) / 2;
        Object redstoneOff = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 16, 0);
        ((AbstractWidget)((AbstractWidget)((AbstractWidget)redstoneOff).setDesiredWidth(16)).setDesiredHeight(16)).setTooltips(new String[]{"Redstone signal off"});
        this.offEnergy = ((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Amount of RF to output", "when redstone is off"})).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiRelay.this.adjustEnergy(GuiRelay.this.offEnergy, 0);
            }
        });
        Button offButtonSub1000 = this.createEnergyOffsetButton(this.offEnergy, "-1000", -1000);
        Button offButtonSub100 = this.createEnergyOffsetButton(this.offEnergy, "-100", -100);
        Button offButtonAdd100 = this.createEnergyOffsetButton(this.offEnergy, "+100", 100);
        Button offButtonAdd1000 = this.createEnergyOffsetButton(this.offEnergy, "+1000", 1000);
        this.offEnergy.setText(Integer.toString(((RelayTileEntity)this.tileEntity).getRfOff()));
        Panel panelOff = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild((Widget)redstoneOff)).addChild(offButtonSub1000)).addChild(offButtonSub100)).addChild(this.offEnergy)).addChild(offButtonAdd100)).addChild(offButtonAdd1000);
        Object redstoneOn = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 32, 0);
        ((AbstractWidget)((AbstractWidget)((AbstractWidget)redstoneOn).setDesiredWidth(16)).setDesiredHeight(16)).setTooltips(new String[]{"Redstone signal on"});
        this.onEnergy = ((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Amount of RF to output", "when redstone is on"})).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiRelay.this.adjustEnergy(GuiRelay.this.onEnergy, 0);
            }
        });
        Button onButtonSub1000 = this.createEnergyOffsetButton(this.onEnergy, "-1000", -1000);
        Button onButtonSub100 = this.createEnergyOffsetButton(this.onEnergy, "-100", -100);
        Button onButtonAdd100 = this.createEnergyOffsetButton(this.onEnergy, "+100", 100);
        Button onButtonAdd1000 = this.createEnergyOffsetButton(this.onEnergy, "+1000", 1000);
        this.onEnergy.setText(Integer.toString(((RelayTileEntity)this.tileEntity).getRfOn()));
        Panel panelOn = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild((Widget)redstoneOn)).addChild(onButtonSub1000)).addChild(onButtonSub100)).addChild(this.onEnergy)).addChild(onButtonAdd100)).addChild(onButtonAdd1000);
        Object toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout()).addChild(panelOff)).addChild(panelOn);
        toplevel.setBounds(new Rectangle(k, l, 240, 50));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private Button createEnergyOffsetButton(final TextField energyField, String label, final int amount) {
        return ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText(label)).setDesiredHeight(16)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiRelay.this.adjustEnergy(energyField, amount);
            }
        });
    }

    private void adjustEnergy(TextField energyField, int amount) {
        int energy;
        try {
            energy = Integer.parseInt(energyField.getText());
        }
        catch (NumberFormatException e) {
            energy = 0;
        }
        if ((energy += amount) < 0) {
            energy = 0;
        } else if (energy > 50000) {
            energy = 50000;
        }
        energyField.setText(Integer.toString(energy));
        this.changeRfOutput();
    }

    private void changeRfOutput() {
        this.sendServerCommand("settings", new Argument("on", Integer.parseInt(this.onEnergy.getText())), new Argument("off", Integer.parseInt(this.offEnergy.getText())));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.window.draw();
    }
}

