/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.container.EmptyContainer;
import mcjty.container.GenericBlock;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.monitor.GuiRFMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorBlockTileEntity;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.input.Keyboard;

public class RFMonitorBlock
extends GenericBlock {
    private IIcon iconFront0;
    private IIcon iconFront1;
    private IIcon iconFront2;
    private IIcon iconFront3;
    private IIcon iconFront4;

    public RFMonitorBlock() {
        super(Material.field_151573_f, RFMonitorBlockTileEntity.class);
        this.func_149663_c("rfMonitorBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    public String getIdentifyingIconName() {
        return "machineFront";
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_RF_MONITOR;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        RFMonitorBlockTileEntity monitorBlockTileEntity = (RFMonitorBlockTileEntity)tileEntity;
        return new GuiRFMonitor(monitorBlockTileEntity, (Container)new EmptyContainer(entityPlayer));
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFront0 = iconRegister.func_94245_a("rftools:machineFront_0");
        this.iconFront1 = iconRegister.func_94245_a("rftools:machineFront_1");
        this.iconFront2 = iconRegister.func_94245_a("rftools:machineFront_2");
        this.iconFront3 = iconRegister.func_94245_a("rftools:machineFront_3");
        this.iconFront4 = iconRegister.func_94245_a("rftools:machineFront_4");
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        return BlockTools.getRedstoneSignal(metadata) ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        return BlockTools.getRedstoneSignal(metadata) ? 15 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This device monitors the amount of RF in an adjacent");
            list.add(EnumChatFormatting.WHITE + "machine (select it with the GUI). It can also send");
            list.add(EnumChatFormatting.WHITE + "out a redstone signal if the power goes above or below");
            list.add(EnumChatFormatting.WHITE + "some value.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        RFMonitorBlockTileEntity monitorBlockTileEntity = (RFMonitorBlockTileEntity)tileEntity;
        int rflevel = monitorBlockTileEntity.getRflevel();
        switch (rflevel) {
            case 1: {
                return this.iconFront0;
            }
            case 2: {
                return this.iconFront1;
            }
            case 3: {
                return this.iconFront2;
            }
            case 4: {
                return this.iconFront3;
            }
            case 5: {
                return this.iconFront4;
            }
        }
        return this.iconInd;
    }
}

