/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.container.InventoryHelper;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.blocks.endergen.PearlInjectorContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PearlInjectorTileEntity
extends GenericTileEntity
implements IInventory {
    private InventoryHelper inventoryHelper = new InventoryHelper(this, PearlInjectorContainer.factory, 18);
    private boolean prevIn = false;

    private EndergenicTileEntity findEndergenicTileEntity() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection k = BlockTools.getOrientation(meta);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.getOpposite());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(ForgeDirection.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(ForgeDirection k) {
        int x = this.field_145851_c + k.offsetX;
        int y = this.field_145848_d + k.offsetY;
        int z = this.field_145849_e + k.offsetZ;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    @Override
    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignal(meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        if (pulse) {
            this.injectPearl();
        }
    }

    private boolean takePearl() {
        for (int i = 0; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            if (stack == null || !Items.field_151079_bi.equals(stack.func_77973_b()) || stack.field_77994_a <= 0) continue;
            this.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    private void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i + 0] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("prevIn", this.prevIn);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : this.inventoryHelper.getStacks()) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Pearl Injector Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 16;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return Items.field_151079_bi.equals(stack.func_77973_b());
    }
}

