/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.container.EmptyContainer;
import mcjty.container.GenericContainerBlock;
import mcjty.container.WrenchUsage;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EndergenicSetup;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.blocks.endergen.GuiEndergenic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class EndergenicBlock
extends GenericContainerBlock
implements Infusable {
    private IIcon icon;
    private IIcon iconUp;

    public EndergenicBlock() {
        super(Material.field_151573_f, EndergenicTileEntity.class);
        this.func_149663_c("endergenicBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_ENDERGENIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Generate power out of ender pearls. You need at");
            list.add(EnumChatFormatting.WHITE + "least two generators for this to work and the setup");
            list.add(EnumChatFormatting.WHITE + "is relatively complicated. Timing is crucial.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: increased power generation and");
            list.add(EnumChatFormatting.YELLOW + "reduced powerloss for holding pearls.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)tileEntity;
        EmptyContainer endergenicContainer = new EmptyContainer(entityPlayer);
        return new GuiEndergenic(endergenicTileEntity, endergenicContainer);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("rftools:machineEndergenic");
        this.iconUp = iconRegister.func_94245_a("rftools:machineEndergenicUp");
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        this.checkForMonitor4Sides(world, x, y, z);
        if (entityLivingBase instanceof EntityPlayer) {
            Achievements.trigger((EntityPlayer)entityLivingBase, Achievements.hardPower);
        }
    }

    private void checkForMonitor4Sides(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.checkForMonitor(world, x + 1, y, z);
            this.checkForMonitor(world, x - 1, y, z);
            this.checkForMonitor(world, x, y, z + 1);
            this.checkForMonitor(world, x, y, z - 1);
        }
    }

    private void checkForMonitor(World world, int x, int y, int z) {
        if (EndergenicSetup.enderMonitorBlock.equals(world.func_147439_a(x, y, z))) {
            EndergenicSetup.enderMonitorBlock.registerWithEndergenic(world, x, y, z);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sx, float sy, float sz) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        if (wrenchUsed == WrenchUsage.NORMAL) {
            if (world.field_72995_K) {
                EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)world.func_147438_o(x, y, z);
                world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
                endergenicTileEntity.useWrench(player);
            }
            return true;
        }
        if (wrenchUsed == WrenchUsage.SNEAKING) {
            this.breakAndRemember(world, player, x, y, z);
            return true;
        }
        return this.openGui(world, x, y, z, player);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    @Override
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.func_149691_a(side, 0);
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconUp;
        }
        return this.icon;
    }
}

