/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimlets.DimensionEnscriberContainer;
import mcjty.rftools.blocks.dimlets.DimensionEnscriberTileEntity;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.network.Argument;
import mcjty.varia.Counter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiDimensionEnscriber
extends GenericGuiContainer<DimensionEnscriberTileEntity> {
    public static final int ENSCRIBER_WIDTH = 256;
    public static final int ENSCRIBER_HEIGHT = 224;
    private Button extractButton;
    private Button storeButton;
    private TextField nameField;
    private Label validateField;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/dimensionenscriber.png");

    public GuiDimensionEnscriber(DimensionEnscriberTileEntity dimensionEnscriberTileEntity, DimensionEnscriberContainer container) {
        super(dimensionEnscriberTileEntity, container);
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.extractButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Extract")).setLayoutHint(new PositionalLayout.PositionalHint(13, 164, 60, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDimensionEnscriber.this.extractDimlets();
            }
        }).setTooltips(new String[]{"Extract the dimlets out of", "a realized dimension tab"});
        this.storeButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Store")).setLayoutHint(new PositionalLayout.PositionalHint(13, 182, 60, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDimensionEnscriber.this.storeDimlets();
            }
        }).setTooltips(new String[]{"Store dimlets in a", "empty dimension tab"});
        this.nameField = (TextField)new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiDimensionEnscriber.this.storeName(newText);
            }
        }).setLayoutHint(new PositionalLayout.PositionalHint(13, 200, 60, 16));
        this.validateField = new Label(this.field_146297_k, (Gui)this).setText("Val");
        this.validateField.setTooltips(new String[]{"Hover here for errors..."});
        this.validateField.setLayoutHint(new PositionalLayout.PositionalHint(35, 142, 38, 16));
        this.setNameFromDimensionTab();
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.extractButton)).addChild(this.storeButton)).addChild(this.nameField)).addChild(this.validateField);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void storeName(String name) {
        this.sendServerCommand("setName", new Argument("name", name));
    }

    private void extractDimlets() {
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = this.field_147002_h.func_75139_a(i + 0).func_75211_c();
            if (stack == null || stack.field_77994_a <= 0) continue;
            RFTools.warn((EntityPlayer)this.field_146297_k.field_71439_g, "You cannot extract. Remove all dimlets first!");
            return;
        }
        this.sendServerCommand("extract", new Argument[0]);
    }

    private void storeDimlets() {
        this.sendServerCommand("store", new Argument("name", this.nameField.getText()));
    }

    private void enableButtons() {
        Slot slot = this.field_147002_h.func_75139_a(91);
        this.extractButton.setEnabled(false);
        this.storeButton.setEnabled(false);
        if (slot.func_75211_c() != null) {
            if (slot.func_75211_c().func_77973_b() == ModItems.emptyDimensionTab) {
                this.storeButton.setEnabled(true);
            } else if (slot.func_75211_c().func_77973_b() == ModItems.realizedDimensionTab) {
                this.extractButton.setEnabled(true);
            }
        }
    }

    private List<DimletKey> extractModifiersForType(List<DimletKey> modifiers, DimletType type) {
        ArrayList<DimletKey> modifiersForType = new ArrayList<DimletKey>();
        int i = 0;
        while (i < modifiers.size()) {
            DimletKey modifier = modifiers.get(i);
            if (type.dimletType.isModifiedBy(modifier.getType())) {
                modifiersForType.add(modifier);
                modifiers.remove(i);
                continue;
            }
            ++i;
        }
        return modifiersForType;
    }

    private String shortenName(String name) {
        int idx = name.indexOf(95);
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    private void validateDimlets() {
        ArrayList<String> tooltips = new ArrayList<String>();
        TerrainType terrainType = null;
        int cntTerrain = 0;
        int cntBiomes = 0;
        int cntController = 0;
        for (int i = 0; i < 91; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot == null || slot.func_75211_c() == null || slot.func_75211_c().field_77994_a <= 0) continue;
            ItemStack stack = slot.func_75211_c();
            DimletKey key = KnownDimletConfiguration.getDimletKey(stack, (World)Minecraft.func_71410_x().field_71441_e);
            if (key.getType() == DimletType.DIMLET_TERRAIN) {
                ++cntTerrain;
                terrainType = DimletObjectMapping.idToTerrainType.get(key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_BIOME) {
                ++cntBiomes;
                continue;
            }
            if (key.getType() != DimletType.DIMLET_CONTROLLER) continue;
            ++cntController;
        }
        if (cntTerrain > 1) {
            tooltips.add("Using more then one TERRAIN is not useful!");
            terrainType = null;
        }
        if (cntController > 1) {
            tooltips.add("Using more then one CONTROLLER is not useful!");
        }
        ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
        for (int i = 0; i < 91; ++i) {
            ControllerType controllerType;
            int neededBiomes;
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot == null || slot.func_75211_c() == null || slot.func_75211_c().field_77994_a <= 0) continue;
            ItemStack stack = slot.func_75211_c();
            DimletKey key = KnownDimletConfiguration.getDimletKey(stack, (World)Minecraft.func_71410_x().field_71441_e);
            DimletType type = key.getType();
            if (type.dimletType.isModifier()) {
                modifiers.add(key);
                continue;
            }
            List<DimletKey> modifiersForType = this.extractModifiersForType(modifiers, type);
            if (type == DimletType.DIMLET_TERRAIN) {
                if (DimletObjectMapping.idToTerrainType.get(key) != TerrainType.TERRAIN_VOID || modifiersForType.isEmpty()) continue;
                tooltips.add("VOID terrain cannot use modifiers");
                continue;
            }
            if (type == DimletType.DIMLET_FEATURE) {
                FeatureType featureType = DimletObjectMapping.idToFeatureType.get(key);
                Counter<DimletType> modifierAmountUsed = new Counter<DimletType>();
                for (DimletKey dimletKey : modifiersForType) {
                    modifierAmountUsed.increment(dimletKey.getType());
                }
                for (Map.Entry entry : modifierAmountUsed.entrySet()) {
                    Integer amountSupported = featureType.getSupportedModifierAmount((DimletType)((Object)entry.getKey()));
                    if (amountSupported == null) {
                        tooltips.add(this.shortenName(featureType.name()) + " does not use " + this.shortenName(((DimletType)((Object)entry.getKey())).name()) + " modifiers!");
                        continue;
                    }
                    if (amountSupported != 1 || (Integer)entry.getValue() <= 1) continue;
                    tooltips.add(this.shortenName(featureType.name()) + " only needs one " + this.shortenName(((DimletType)((Object)entry.getKey())).name()) + " modifier!");
                }
                if (terrainType == null && !featureType.supportsAllTerrains()) {
                    tooltips.add(this.shortenName(featureType.name()) + " is possibly useless as it does not work on all terrains!");
                }
                if (terrainType == null || featureType.isTerrainSupported(terrainType)) continue;
                tooltips.add(this.shortenName(featureType.name()) + " does not work for terrain " + this.shortenName(terrainType.name()) + "!");
                continue;
            }
            if (type != DimletType.DIMLET_CONTROLLER || (neededBiomes = (controllerType = DimletObjectMapping.idToControllerType.get(key)).getNeededBiomes()) == -1) continue;
            if (cntBiomes > neededBiomes) {
                tooltips.add("Too many biomes specified for " + this.shortenName(controllerType.name()) + "!");
                continue;
            }
            if (cntBiomes >= neededBiomes) continue;
            tooltips.add("Too few biomes specified for " + this.shortenName(controllerType.name()) + "!");
        }
        if (!modifiers.isEmpty()) {
            tooltips.add("There are dangling modifiers in this descriptor");
        }
        boolean error = true;
        if (tooltips.isEmpty()) {
            tooltips.add("Everything appears to be alright");
            error = false;
        }
        this.validateField.setTooltips(tooltips.toArray(new String[tooltips.size()]));
        this.validateField.setColor(error ? 0xFF0000 : 34816);
        this.validateField.setText(error ? "Warn" : "Ok");
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.enableButtons();
        this.validateDimlets();
        if (((DimensionEnscriberTileEntity)this.tileEntity).hasTabSlotChangedAndClear()) {
            this.setNameFromDimensionTab();
        }
        this.window.draw();
    }

    private void setNameFromDimensionTab() {
        String name;
        NBTTagCompound tagCompound;
        Slot slot = this.field_147002_h.func_75139_a(91);
        if (slot.func_75211_c() != null && slot.func_75211_c().func_77973_b() == ModItems.realizedDimensionTab && (tagCompound = slot.func_75211_c().func_77978_p()) != null && (name = tagCompound.func_74779_i("name")) != null) {
            this.nameField.setText(name);
        }
    }
}

